/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Type;

public interface ExpressionJSON {

    public static class ExpressionJSONObjectAgg
    extends Expression {
        final ExpressionArrayAggregate namesAgg;
        final ExpressionArrayAggregate valuesAgg;
        final boolean nullOnNull;
        final boolean uniqueKeys;
        boolean isValueJSON;

        public ExpressionJSONObjectAgg(ExpressionArrayAggregate namesAgg, ExpressionArrayAggregate valuesAgg, boolean nullOnNull, boolean uniqueKeys, Type dataType) {
            super(103);
            this.namesAgg = namesAgg;
            this.valuesAgg = valuesAgg;
            this.nullOnNull = nullOnNull;
            this.uniqueKeys = uniqueKeys;
            this.dataType = dataType == null ? Type.SQL_VARCHAR_LONG : dataType;
            this.isValueJSON = valuesAgg.exprOpType == 103;
            this.nodes = new Expression[]{namesAgg, valuesAgg};
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            Object[] names = (Object[])this.nodes[0].getValue(session);
            Object[] values = (Object[])this.nodes[1].getValue(session);
            Type nameType = this.nodes[0].dataType.collectionBaseType();
            Type valueType = this.nodes[1].dataType.collectionBaseType();
            OrderedHashSet<String> keySet = new OrderedHashSet<String>();
            sb.append('{');
            for (int i = 0; i < names.length; ++i) {
                String s;
                String name = (String)names[i];
                String value = (String)values[i];
                if (name == null || !this.nullOnNull && value == null) continue;
                if (count > 0) {
                    sb.append(',');
                }
                if (this.uniqueKeys && !keySet.add(s = nameType.convertToString(name))) {
                    throw Error.error(104);
                }
                if (nameType.isCharacterType()) {
                    nameType.convertToJSON(name, sb);
                } else {
                    s = nameType.convertToString(name);
                    s = StringConverter.toQuotedString(s, '\"', false);
                    sb.append(s);
                }
                sb.append(':');
                if (this.isValueJSON) {
                    sb.append(value);
                } else {
                    valueType.convertToJSON(value, sb);
                }
                ++count;
            }
            sb.append('}');
            if ((long)sb.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return sb.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_OBJECTAGG()";
        }

        @Override
        public String describe(Session session, int blanks) {
            return "JSON_OBJECTAGG()";
        }
    }

    public static class ExpressionJSONObject
    extends Expression {
        final OrderedHashMap exprMap;
        final boolean nullOnNull;
        final boolean uniqueKeys;

        public ExpressionJSONObject(OrderedHashMap exprMap, boolean nullOnNull, boolean uniqueKeys, Type dataType) {
            super(103);
            this.exprMap = exprMap;
            this.nullOnNull = nullOnNull;
            this.uniqueKeys = uniqueKeys;
            this.dataType = dataType == null ? Type.SQL_VARCHAR_LONG : dataType;
            this.nodes = new Expression[exprMap.size() * 2];
            for (int i = 0; i < exprMap.size(); ++i) {
                this.nodes[i * 2] = (Expression)exprMap.getKeyAt(i);
                this.nodes[i * 2 + 1] = (Expression)exprMap.get(i);
            }
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            OrderedHashSet<String> keySet = new OrderedHashSet<String>();
            sb.append('{');
            for (int i = 0; i < this.exprMap.size(); ++i) {
                String s;
                int j = i * 2;
                if (count > 0) {
                    sb.append(',');
                }
                Object name = this.nodes[j].getValue(session);
                if (this.uniqueKeys && !keySet.add(s = this.nodes[j].dataType.convertToString(name))) {
                    throw Error.error(104);
                }
                if (this.nodes[j].dataType.isCharacterType()) {
                    this.nodes[j].dataType.convertToJSON(name, sb);
                } else {
                    s = this.nodes[j].dataType.convertToString(name);
                    s = StringConverter.toQuotedString(s, '\"', false);
                    sb.append(s);
                }
                sb.append(':');
                Object value = this.nodes[j + 1].getValue(session);
                if (this.nodes[j + 1].opType == 103) {
                    sb.append((String)value);
                } else {
                    this.nodes[j + 1].dataType.convertToJSON(value, sb);
                }
                ++count;
            }
            sb.append('}');
            if ((long)sb.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return sb.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_OBJECT()";
        }

        @Override
        public String describe(Session session, int blanks) {
            return "JSON_OBJECT()";
        }
    }

    public static class ExpressionJSONArrayAgg
    extends Expression {
        final boolean isValueJSON;
        final boolean nullOnNull;

        public ExpressionJSONArrayAgg(ExpressionArrayAggregate valuesAgg, boolean nullOnNull, Type dataType) {
            super(103);
            this.nullOnNull = nullOnNull;
            this.dataType = dataType == null ? Type.SQL_VARCHAR_LONG : dataType;
            this.isValueJSON = valuesAgg.exprOpType == 103;
            this.nodes = new Expression[]{valuesAgg};
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            this.nodes[0].resolveTypes(session, this);
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder sb = new StringBuilder();
            Object values = this.nodes[0].getValue(session);
            ArrayType valuesType = (ArrayType)this.nodes[0].dataType;
            if (this.isValueJSON) {
                valuesType.convertToJSONsimple(values, sb);
            } else {
                valuesType.convertToJSON(values, sb);
            }
            if ((long)sb.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return sb.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAYAGG()";
        }

        @Override
        public String describe(Session session, int blanks) {
            return "JSON_ARRAYAGG()";
        }
    }

    public static class ExpressionJSONArrayFromValues
    extends Expression {
        final HsqlArrayList exprList;
        final boolean nullOnNull;

        public ExpressionJSONArrayFromValues(HsqlArrayList expressionList, boolean nullOnNull, Type dataType) {
            super(103);
            this.exprList = expressionList;
            this.nullOnNull = nullOnNull;
            this.dataType = dataType == null ? Type.SQL_VARCHAR_LONG : dataType;
            this.nodes = new Expression[expressionList.size()];
            expressionList.toArray(this.nodes);
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            sb.append('[');
            for (int i = 0; i < this.nodes.length; ++i) {
                if (count > 0) {
                    sb.append(',');
                }
                Object value = this.nodes[i].getValue(session);
                if (this.nodes[i].opType == 103) {
                    sb.append((String)value);
                } else {
                    this.nodes[i].dataType.convertToJSON(value, sb);
                }
                ++count;
            }
            sb.append(']');
            if ((long)sb.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return sb.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAY()";
        }

        @Override
        public String describe(Session session, int blanks) {
            return "JSON_ARRAY()";
        }
    }

    public static class ExpressionJSONArrayFromQuery
    extends Expression {
        final Expression exprQuery;
        final boolean nullOnNull;

        public ExpressionJSONArrayFromQuery(Expression expressionQuery, boolean nullOnNull, Type dataType) {
            super(103);
            this.exprQuery = expressionQuery;
            this.nullOnNull = nullOnNull;
            this.dataType = dataType == null ? Type.SQL_VARCHAR_LONG : dataType;
            this.nodes = new Expression[]{expressionQuery};
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            this.nodes[0].resolveTypes(session, this);
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder sb = new StringBuilder();
            Object values = this.nodes[0].getValue(session);
            this.nodes[0].dataType.convertToJSON(values, sb);
            if ((long)sb.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return sb.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAY()";
        }

        @Override
        public String describe(Session session, int blanks) {
            return "JSON_ARRAY()";
        }
    }

    public static class ExpressionJSONWrapper
    extends Expression {
        public ExpressionJSONWrapper(Expression expr) {
            super(103);
            this.nodes = new Expression[]{expr};
        }

        @Override
        public void resolveTypes(Session session, Expression parent) {
            this.nodes[0].resolveTypes(session, this);
            this.dataType = this.nodes[0].dataType;
        }

        @Override
        public Object getValue(Session session) {
            return this.nodes[0].getValue(session);
        }

        @Override
        public String getSQL() {
            return this.nodes[0].getSQL();
        }

        @Override
        public String describe(Session session, int blanks) {
            return this.nodes[0].getSQL();
        }
    }
}

