/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionTable;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class ExpressionLogical
extends Expression {
    boolean isQuantified;
    boolean isTerminal;

    ExpressionLogical(int type) {
        super(type);
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(boolean b) {
        super(1);
        this.dataType = Type.SQL_BOOLEAN;
        this.valueData = b ? Boolean.TRUE : Boolean.FALSE;
    }

    ExpressionLogical(RangeVariable leftRangeVar, int colIndexLeft, RangeVariable rightRangeVar, int colIndexRight) {
        super(40);
        ExpressionColumn leftExpression = new ExpressionColumn(leftRangeVar, colIndexLeft);
        ExpressionColumn rightExpression = new ExpressionColumn(rightRangeVar, colIndexRight);
        this.nodes = new Expression[2];
        this.nodes[0] = leftExpression;
        this.nodes[1] = rightExpression;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(Expression left, Expression right) {
        super(40);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.setEqualityMode();
                break;
            }
            case 46: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int type, Expression left, Expression right, Expression end) {
        super(type);
        this.nodes = new Expression[3];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.nodes[2] = end;
    }

    ExpressionLogical(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 39: 
            case 47: 
            case 48: 
            case 55: 
            case 66: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.opType == 47 && this.nodes[0].opType == 2) {
            this.isSingleColumnNull = true;
        }
        if (this.opType == 48 && this.nodes[0].isSingleColumnNull) {
            this.isSingleColumnNotNull = true;
        }
    }

    ExpressionLogical(ColumnSchema column) {
        super(48);
        this.nodes = new Expression[1];
        this.dataType = Type.SQL_BOOLEAN;
        Expression e = new ExpressionColumn(column);
        e = new ExpressionLogical(47, e);
        this.nodes[0] = e;
    }

    void setEqualityMode() {
        block11: {
            block10: {
                if (this.nodes[0].opType != 2) break block10;
                this.nodes[0].nullability = 0;
                switch (this.nodes[1].opType) {
                    case 2: {
                        this.isColumnCondition = true;
                        if (this.opType == 40) {
                            this.isColumnEqual = true;
                        }
                        this.nodes[1].nullability = 0;
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.isSingleColumnCondition = true;
                        if (this.opType == 40) {
                            this.isSingleColumnEqual = true;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            if (this.nodes[1].opType == 2) {
                this.nodes[1].nullability = 0;
                switch (this.nodes[0].opType) {
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.isSingleColumnCondition = true;
                        if (this.opType != 40) break;
                        this.isSingleColumnEqual = true;
                        break;
                    }
                }
            }
        }
    }

    static ExpressionLogical newNotNullCondition(Expression e) {
        e = new ExpressionLogical(47, e);
        return new ExpressionLogical(48, e);
    }

    static Expression andExpressions(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (EXPR_FALSE.equals(e1) || EXPR_FALSE.equals(e2)) {
            return new ExpressionBoolean(false);
        }
        if (e1 == e2) {
            return e1;
        }
        return new ExpressionLogical(49, e1, e2);
    }

    static Expression orExpressions(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (e1 == e2) {
            return e1;
        }
        return new ExpressionLogical(50, e1, e2);
    }

    public void addLeftColumnsForAllAny(RangeVariable range, OrderedIntHashSet set) {
        if (this.nodes.length == 0) {
            return;
        }
        for (int j = 0; j < this.nodes[0].nodes.length; ++j) {
            int index = this.nodes[0].nodes[j].getColumnIndex();
            if (index < 0 || this.nodes[0].nodes[j].getRangeVariable() != range) {
                set.clear();
                return;
            }
            set.add(index);
        }
    }

    @Override
    public void setSubType(int type) {
        this.exprSubType = type;
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.isQuantified = true;
        }
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder(64);
        if (this.opType == 1) {
            return super.getSQL();
        }
        String left = ExpressionLogical.getContextSQL(this.nodes[0]);
        String right = ExpressionLogical.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 48: {
                if (this.nodes[0].opType == 47) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return sb.toString();
                }
                if (this.nodes[0].opType == 67) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                    return sb.toString();
                }
                sb.append("NOT").append(' ').append(left);
                return sb.toString();
            }
            case 67: {
                sb.append(left).append(' ').append("IS").append(' ').append("NOT").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(right);
                return sb.toString();
            }
            case 47: {
                sb.append(left).append(' ').append("IS").append(' ').append("NULL");
                return sb.toString();
            }
            case 66: {
                sb.append(' ').append("UNIQUE").append(' ');
                break;
            }
            case 55: {
                sb.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 40: {
                sb.append(left).append('=').append(right);
                return sb.toString();
            }
            case 41: 
            case 42: {
                sb.append(left).append(">=").append(right);
                return sb.toString();
            }
            case 43: {
                sb.append(left).append('>').append(right);
                return sb.toString();
            }
            case 44: {
                sb.append(left).append('<').append(right);
                return sb.toString();
            }
            case 45: {
                sb.append(left).append("<=").append(right);
                return sb.toString();
            }
            case 46: {
                if ("NULL".equals(right)) {
                    sb.append(left).append(" IS NOT ").append(right);
                } else {
                    sb.append(left).append("!=").append(right);
                }
                return sb.toString();
            }
            case 49: {
                sb.append(left).append(' ').append("AND").append(' ').append(right);
                return sb.toString();
            }
            case 50: {
                sb.append(left).append(' ').append("OR").append(' ').append(right);
                return sb.toString();
            }
            case 54: {
                sb.append(left).append(' ').append("IN").append(' ').append(right);
                return sb.toString();
            }
            case 68: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(right);
                return sb.toString();
            }
            case 69: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(510).append(right);
                return sb.toString();
            }
            case 70: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(125).append(right);
                return sb.toString();
            }
            case 71: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(315).append(right);
                return sb.toString();
            }
            case 72: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(315).append(' ').append(510).append(right);
                return sb.toString();
            }
            case 73: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(315).append(' ').append(125).append(right);
                return sb.toString();
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 48: {
                if (this.nodes[0].opType == 67) {
                    sb.append("DISTINCT");
                    return sb.toString();
                }
                sb.append("NOT");
                break;
            }
            case 67: {
                sb.append("NOT").append(' ').append("DISTINCT");
                break;
            }
            case 40: {
                sb.append("EQUAL");
                break;
            }
            case 41: 
            case 42: {
                sb.append("GREATER_EQUAL");
                break;
            }
            case 43: {
                sb.append("GREATER");
                break;
            }
            case 44: {
                sb.append("SMALLER");
                break;
            }
            case 45: {
                sb.append("SMALLER_EQUAL");
                break;
            }
            case 46: {
                sb.append("NOT_EQUAL");
                break;
            }
            case 49: {
                sb.append("AND");
                break;
            }
            case 50: {
                sb.append("OR");
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                sb.append("MATCH");
                break;
            }
            case 47: {
                sb.append("IS").append(' ').append("NULL");
                break;
            }
            case 66: {
                sb.append("UNIQUE");
                break;
            }
            case 55: {
                sb.append("EXISTS");
                break;
            }
            case 56: {
                sb.append("OVERLAPS");
                break;
            }
            case 59: {
                sb.append("CONTAINS");
                break;
            }
            case 60: {
                sb.append("EQUALS");
                break;
            }
            case 61: {
                sb.append("OVERLAPS");
                break;
            }
            case 62: {
                sb.append("PRECEDES");
                break;
            }
            case 63: {
                sb.append("SUCCEEDS");
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        if (this.isQuantified && this.nodes[1].opType == 30 && this.nodes[1] instanceof ExpressionTable && this.nodes[1].nodes[0].opType == 8) {
            this.nodes[0].resolveTypes(session, this);
            this.nodes[1].nodes[0].dataType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.opType) {
            case 1: {
                break;
            }
            case 67: {
                this.changeToRowExpression(0);
                this.changeToRowExpression(1);
                this.resolveRowTypes();
                this.checkRowComparison();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.resolveTypesForComparison(session, parent);
                break;
            }
            case 49: {
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session, parent);
                        break;
                    }
                    Object value = this.nodes[0].getValue(session);
                    if (Boolean.FALSE.equals(value)) {
                        this.setAsConstantValue(Boolean.FALSE, parent);
                        break;
                    }
                    if (!Boolean.TRUE.equals(value) || parent == null) break;
                    parent.replaceNode(this, this.nodes[1]);
                    break;
                }
                if (this.nodes[1].opType != 1) break;
                Object value = this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(value)) {
                    this.setAsConstantValue(Boolean.FALSE, parent);
                    break;
                }
                if (!Boolean.TRUE.equals(value) || parent == null) break;
                parent.replaceNode(this, this.nodes[0]);
                break;
            }
            case 50: {
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session, parent);
                        break;
                    }
                    Object value = this.nodes[0].getValue(session);
                    if (Boolean.TRUE.equals(value)) {
                        this.setAsConstantValue(Boolean.TRUE, parent);
                        break;
                    }
                    if (!Boolean.FALSE.equals(value) || parent == null) break;
                    parent.replaceNode(this, this.nodes[1]);
                    break;
                }
                if (this.nodes[1].opType != 1) break;
                Object value = this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(value)) {
                    this.setAsConstantValue(Boolean.TRUE, parent);
                    break;
                }
                if (!Boolean.FALSE.equals(value) || parent == null) break;
                parent.replaceNode(this, this.nodes[0]);
                break;
            }
            case 39: 
            case 47: {
                switch (this.nodes[0].opType) {
                    case 25: {
                        Expression[] sourceNodes = this.nodes[0].nodes;
                        Expression result = null;
                        for (int i = 0; i < sourceNodes.length; ++i) {
                            ExpressionLogical node = new ExpressionLogical(47, sourceNodes[i]);
                            if (this.opType == 39) {
                                node = new ExpressionLogical(48, (Expression)node);
                            }
                            result = ExpressionLogical.andExpressions(result, node);
                        }
                        this.opType = 49;
                        this.nodes = result.nodes;
                        this.resolveTypes(session, parent);
                        break block0;
                    }
                    case 22: 
                    case 23: {
                        break block0;
                    }
                }
                if (this.nodes[0].isUnresolvedParam()) {
                    if (session.database.sqlEnforceTypes) {
                        throw Error.error(5563);
                    }
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.opType == 39) {
                    ExpressionLogical node = new ExpressionLogical(47, this.nodes[0]);
                    this.nodes[0] = node;
                    this.opType = 48;
                    if (this.noOptimisation) {
                        this.nodes[0].setNoOptimisation();
                    }
                    this.resolveTypes(session, parent);
                    break;
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session, parent);
                break;
            }
            case 48: {
                if (this.nodes[0].isUnresolvedParam()) {
                    this.nodes[0].dataType = Type.SQL_BOOLEAN;
                    break;
                }
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[0].dataType.isBooleanType()) {
                        this.setAsConstantValue(session, parent);
                        break;
                    }
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null || !this.nodes[0].dataType.isBooleanType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 56: {
                this.resolveTypesForOverlaps();
                break;
            }
            case 54: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 66: {
                this.nodes[0].table.getFullIndex(session);
                break;
            }
            case 55: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    private void resolveTypesForLogicalOp() {
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5571);
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25) {
            throw Error.error(5565);
        }
        if (Type.SQL_BOOLEAN != this.nodes[0].dataType || Type.SQL_BOOLEAN != this.nodes[1].dataType) {
            throw Error.error(5568);
        }
    }

    private void resolveTypesForComparison(Session session, Expression parent) {
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.resolveTypesForAllAny(session);
            this.checkRowComparison();
            return;
        }
        int leftDegree = this.nodes[0].getDegree();
        int rightDegree = this.nodes[1].getDegree();
        if (leftDegree > 1 || rightDegree > 1) {
            if (leftDegree != rightDegree) {
                throw Error.error(5564);
            }
            this.resolveRowTypes();
            this.checkRowComparison();
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (!this.nodes[0].dataType.canCompareDirect(this.nodes[1].dataType) && !this.convertDateTime(session)) {
            if (this.nodes[0].dataType.isBitType() || this.nodes[0].dataType.isBooleanType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isBitType() || this.nodes[1].dataType.isBooleanType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isNumberType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isNumberType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0]);
                }
            } else if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
            } else {
                throw Error.error(5562);
            }
        }
        if (this.opType != 40 && this.opType != 46 && (this.nodes[0].dataType.isArrayType() || this.nodes[0].dataType.isLobType() || this.nodes[1].dataType.isLobType())) {
            throw Error.error(5534);
        }
        if (this.nodes[0].opType == 14 && this.nodes[1].opType == 1) {
            this.isTerminal = true;
        }
        if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
            throw Error.error(5562);
        }
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session, parent);
        } else if (session.database.sqlSyntaxDb2 && this.nodes[0].dataType.typeComparisonGroup == 12) {
            if (this.nodes[0].opType == 1) {
                this.nodes[1].dataType.convertToTypeLimits(session, this.nodes[0].valueData);
            }
            if (this.nodes[1].opType == 1) {
                this.nodes[0].dataType.convertToTypeLimits(session, this.nodes[1].valueData);
            }
        }
    }

    private void changeToRowExpression(int nodeIndex) {
        switch (this.nodes[nodeIndex].opType) {
            case 22: 
            case 25: {
                break;
            }
            default: {
                this.nodes[nodeIndex] = new Expression(25, new Expression[]{this.nodes[nodeIndex]});
                this.nodes[nodeIndex].nodeDataTypes = new Type[]{this.nodes[nodeIndex].nodes[0].dataType};
            }
        }
    }

    private void resolveRowTypes() {
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type leftType = this.nodes[0].nodeDataTypes[i];
            Type rightType = this.nodes[1].nodeDataTypes[i];
            if (leftType == null) {
                leftType = this.nodes[0].nodeDataTypes[i] = rightType;
            } else if (this.nodes[1].dataType == null) {
                rightType = this.nodes[1].nodeDataTypes[i] = leftType;
            }
            if (leftType == null || rightType == null) {
                throw Error.error(5567);
            }
            if (leftType.typeComparisonGroup != rightType.typeComparisonGroup) {
                throw Error.error(5562);
            }
            if (!leftType.isDateTimeType() || !(leftType.isDateTimeTypeWithZone() ^ rightType.isDateTimeTypeWithZone())) continue;
            this.nodes[0].nodes[i] = new ExpressionOp(this.nodes[0].nodes[i]);
            this.nodes[0].nodeDataTypes[i] = this.nodes[0].nodes[i].dataType;
        }
    }

    void checkRowComparison() {
        if (this.opType == 40 || this.opType == 46) {
            return;
        }
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type leftType = this.nodes[0].nodeDataTypes[i];
            Type rightType = this.nodes[1].nodeDataTypes[i];
            if (!leftType.isArrayType() && !leftType.isLobType() && !rightType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private boolean convertDateTime(Session session) {
        int a = 0;
        int b = 1;
        if (!this.nodes[a].dataType.isDateTimeType()) {
            if (this.nodes[b].dataType.isDateTimeType()) {
                a = 1;
                b = 0;
            } else {
                return false;
            }
        }
        if (this.nodes[a].dataType.isDateTimeTypeWithZone()) {
            return false;
        }
        if (this.nodes[b].dataType.isCharacterType()) {
            if (this.nodes[b].opType == 1) {
                block8: {
                    try {
                        this.nodes[b].valueData = this.nodes[a].dataType.castToType(session, this.nodes[b].valueData, this.nodes[b].dataType);
                        this.nodes[b].dataType = this.nodes[a].dataType;
                    }
                    catch (HsqlException e) {
                        if (this.nodes[a].dataType != Type.SQL_DATE) break block8;
                        this.nodes[b].valueData = Type.SQL_TIMESTAMP.castToType(session, this.nodes[b].valueData, this.nodes[b].dataType);
                        this.nodes[b].dataType = Type.SQL_TIMESTAMP;
                    }
                }
                return true;
            }
            this.nodes[b] = new ExpressionOp(this.nodes[b], this.nodes[a].dataType);
            this.nodes[b].resolveTypes(session, this);
            return true;
        }
        return false;
    }

    void resolveTypesForOverlaps() {
        if (this.nodes[0].nodes[0].isUnresolvedParam()) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[0].isUnresolvedParam()) {
            this.nodes[1].nodes[0].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (this.nodes[0].nodes[0].dataType == null) {
            this.nodes[0].nodes[0].dataType = Type.SQL_TIMESTAMP;
            this.nodes[1].nodes[0].dataType = Type.SQL_TIMESTAMP;
        }
        if (this.nodes[0].nodes[1].isUnresolvedParam()) {
            this.nodes[0].nodes[1].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[1].isUnresolvedParam()) {
            this.nodes[1].nodes[1].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[1].nodes[0].dataType, this.nodes[1].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        this.nodes[0].nodeDataTypes[0] = this.nodes[0].nodes[0].dataType;
        this.nodes[0].nodeDataTypes[1] = this.nodes[0].nodes[1].dataType;
        this.nodes[1].nodeDataTypes[0] = this.nodes[1].nodes[0].dataType;
        this.nodes[1].nodeDataTypes[1] = this.nodes[1].nodes[1].dataType;
    }

    void resolveTypesForAllAny(Session session) {
        int degree = this.nodes[0].getDegree();
        if (degree == 1 && this.nodes[0].opType != 25) {
            this.nodes[0] = new Expression(25, new Expression[]{this.nodes[0]});
        }
        if (this.nodes[1].opType == 26) {
            this.nodes[1].prepareTable(session, this.nodes[0], degree);
            this.nodes[1].table.prepareTable(session);
        }
        if (this.nodes[1].nodeDataTypes == null) {
            this.nodes[1].prepareTable(session, this.nodes[0], degree);
        }
        if (degree != this.nodes[1].nodeDataTypes.length) {
            throw Error.error(5564);
        }
        if (this.nodes[1].opType == 26) {
            // empty if block
        }
        if (this.nodes[0].nodeDataTypes == null) {
            this.nodes[0].nodeDataTypes = new Type[this.nodes[0].nodes.length];
        }
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodes[i].dataType;
            if (type == null) {
                type = this.nodes[1].nodeDataTypes[i];
            }
            if (type == null) {
                throw Error.error(5567);
            }
            if (type.typeComparisonGroup != this.nodes[1].nodeDataTypes[i].typeComparisonGroup) {
                throw Error.error(5563);
            }
            this.nodes[0].nodeDataTypes[i] = type;
            this.nodes[0].nodes[i].dataType = type;
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 31: {
                return this.dataType.negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
            case 39: 
            case 47: {
                switch (this.nodes[0].opType) {
                    case 22: 
                    case 23: 
                    case 25: {
                        Object[] values = this.nodes[0].getRowValue(session);
                        for (int i = 0; i < values.length; ++i) {
                            if (!(values[i] == null ? this.opType == 39 : this.opType == 47)) continue;
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                }
                return this.nodes[0].getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 56: {
                Object[] left = this.nodes[0].getRowValue(session);
                Object[] right = this.nodes[1].getRowValue(session);
                return DateTimeType.overlaps(session, left, this.nodes[0].nodeDataTypes, right, this.nodes[1].nodeDataTypes);
            }
            case 54: {
                return this.testInCondition(session);
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.testMatchCondition(session);
            }
            case 67: {
                return this.testNotDistinctCondition(session);
            }
            case 66: {
                this.nodes[0].materialise(session);
                return this.nodes[0].table.hasUniqueNotNullRows(session) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return this.testExistsCondition(session);
            }
            case 48: {
                Boolean result = (Boolean)this.nodes[0].getValue(session);
                return result == null ? null : (result != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 49: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.FALSE.equals(r1)) {
                    return Boolean.FALSE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(r2)) {
                    return Boolean.FALSE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.TRUE;
            }
            case 50: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(r1)) {
                    return Boolean.TRUE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(r2)) {
                    return Boolean.TRUE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (this.exprSubType == 52 || this.exprSubType == 51) {
                    return this.testAllAnyCondition(session);
                }
                Object o1 = this.nodes[0].getValue(session);
                Object o2 = this.nodes[1].getValue(session);
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isArrayType()) {
                    return this.compareValues(session, o1, o2);
                }
                if (o1 instanceof Object[]) {
                    if (o2 != null && !(o2 instanceof Object[])) {
                        throw Error.runtimeError(201, "ExpressionLogical");
                    }
                    return this.compareValues(session, (Object[])o1, (Object[])o2);
                }
                if (o2 instanceof Object[]) {
                    o2 = ((Object[])o2)[0];
                }
                return this.compareValues(session, o1, o2);
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        int result = this.nodes[0].dataType.compare(session, left, right, this.opType);
        switch (this.opType) {
            case 40: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return result != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 42: {
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean matchValues(Session session, Object[] leftData, Object[] rightData) {
        Type[] types = this.nodes[0].nodeDataTypes;
        int result = 0;
        switch (this.opType) {
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
                    Object leftValue = leftData[i];
                    Object rightValue = rightData[i];
                    if ((leftValue != null || this.opType != 69 && this.opType != 72) && (result = types[i].compare(session, leftValue, rightValue)) != 0) break;
                }
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object[] leftData, Object[] rightData) {
        Type[] types = this.nodes[0].nodeDataTypes;
        int result = 0;
        boolean hasNull = false;
        if (leftData == null || rightData == null) {
            return null;
        }
        for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
            Object leftValue = leftData[i];
            Object rightValue = rightData[i];
            if (leftValue == null || rightValue == null) {
                hasNull = true;
                continue;
            }
            result = types[i].compare(session, leftValue, rightValue);
            if (result != 0) break;
        }
        switch (this.opType) {
            case 40: 
            case 54: {
                if (result == 0) {
                    if (hasNull) {
                        return null;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 46: {
                if (result == 0) {
                    if (hasNull) {
                        return null;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 43: {
                if (hasNull) {
                    return null;
                }
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 42: {
                if (hasNull) {
                    return null;
                }
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                if (hasNull) {
                    return null;
                }
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                if (hasNull) {
                    return null;
                }
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testInCondition(Session session) {
        Object[] data = this.nodes[0].getRowValue(session);
        if (data == null) {
            return null;
        }
        if (Expression.countNulls(data) != 0) {
            return null;
        }
        if (this.nodes[1].opType == 26) {
            int length = this.nodes[1].nodes.length;
            for (int i = 0; i < length; ++i) {
                Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                if (!Boolean.TRUE.equals(this.compareValues(session, data, rowData))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testNotDistinctCondition(Session session) {
        Object[] leftData = this.nodes[0].getRowValue(session);
        Object[] rightData = this.nodes[1].getRowValue(session);
        if (leftData == null || rightData == null) {
            return leftData == rightData;
        }
        return this.matchValues(session, leftData, rightData);
    }

    private Boolean testMatchCondition(Session session) {
        Object[] data = this.nodes[0].getRowValue(session);
        if (data == null) {
            return Boolean.TRUE;
        }
        int nulls = ExpressionLogical.countNulls(data);
        if (nulls != 0) {
            switch (this.opType) {
                case 68: 
                case 71: {
                    return Boolean.TRUE;
                }
                case 69: 
                case 72: {
                    if (nulls != data.length) break;
                    return Boolean.TRUE;
                }
                case 70: 
                case 73: {
                    return nulls == data.length ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        switch (this.nodes[1].opType) {
            case 26: {
                int length = this.nodes[1].nodes.length;
                boolean hasMatch = false;
                block16: for (int i = 0; i < length; ++i) {
                    Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                    Boolean result = this.matchValues(session, data, rowData);
                    if (!result.booleanValue()) continue;
                    switch (this.opType) {
                        case 68: 
                        case 69: 
                        case 70: {
                            return Boolean.TRUE;
                        }
                        case 71: 
                        case 72: 
                        case 73: {
                            if (hasMatch) {
                                return Boolean.FALSE;
                            }
                            hasMatch = true;
                            continue block16;
                        }
                    }
                }
                return hasMatch ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                PersistentStore store = this.nodes[1].getTable().getRowStore(session);
                this.nodes[1].materialise(session);
                ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                if (nulls != 0 && (this.opType == 69 || this.opType == 72)) {
                    boolean hasMatch = false;
                    RowIterator it = this.nodes[1].getTable().rowIterator(session);
                    while (it.next()) {
                        Object[] rowData = it.getCurrent();
                        Boolean result = this.matchValues(session, data, rowData);
                        if (result == null || !result.booleanValue()) continue;
                        if (this.opType == 69) {
                            return Boolean.TRUE;
                        }
                        if (hasMatch) {
                            return Boolean.FALSE;
                        }
                        hasMatch = true;
                    }
                    return hasMatch ? Boolean.TRUE : Boolean.FALSE;
                }
                RowIterator it = this.nodes[1].getTable().getFullIndex(session).findFirstRow(session, store, data);
                boolean result = it.next();
                if (!result) {
                    return Boolean.FALSE;
                }
                switch (this.opType) {
                    case 68: 
                    case 69: 
                    case 70: {
                        return Boolean.TRUE;
                    }
                }
                while (result = it.next()) {
                    Object[] rowData = it.getCurrent();
                    if (!Boolean.TRUE.equals(this.matchValues(session, data, rowData))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testExistsCondition(Session session) {
        this.nodes[0].materialise(session);
        return this.nodes[0].getTable().isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAllAnyCondition(Session session) {
        Object[] rowData = this.nodes[0].getRowValue(session);
        TableDerived td = this.nodes[1].table;
        td.materialiseCorrelated(session);
        Boolean result = this.getAllAnyValue(session, rowData, td);
        return result;
    }

    private Boolean getAllAnyValue(Session session, Object[] data, TableDerived td) {
        boolean empty = td.isEmpty(session);
        Index index = td.getFullIndex(session);
        PersistentStore store = td.getRowStore(session);
        int nullCount = ExpressionLogical.countNulls(data);
        boolean hasNulls = false;
        for (int i = 0; i < td.columnCount; ++i) {
            hasNulls |= store.hasNull(i);
        }
        ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
        switch (this.exprSubType) {
            case 52: {
                if (empty) {
                    return Boolean.FALSE;
                }
                if (nullCount == data.length) {
                    return null;
                }
                int searchType = this.opType == 46 ? 40 : this.opType;
                RowIterator it = index.findFirstRow(session, store, data, data.length, 0, searchType, false, null);
                switch (this.opType) {
                    case 40: {
                        if (it.next()) {
                            if (nullCount == 0) {
                                return Boolean.TRUE;
                            }
                            return null;
                        }
                        if (nullCount == 0) {
                            if (hasNulls) break;
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                }
                it = index.firstRow(store);
                boolean comparedNull = false;
                while (it.next()) {
                    Object[] currdata = it.getCurrent();
                    Boolean result = this.compareValues(session, data, currdata);
                    if (result == null) {
                        comparedNull = true;
                        continue;
                    }
                    if (!result.booleanValue()) continue;
                    it.release();
                    return Boolean.TRUE;
                }
                if (comparedNull) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 51: {
                RowIterator it;
                if (empty) {
                    return Boolean.TRUE;
                }
                if (nullCount == data.length) {
                    return null;
                }
                switch (this.opType) {
                    case 40: {
                        break;
                    }
                    case 46: {
                        if (hasNulls) break;
                        it = index.findFirstRow(session, store, data);
                        if (it.next()) {
                            return Boolean.FALSE;
                        }
                        if (nullCount != 0) break;
                        return Boolean.TRUE;
                    }
                    case 41: 
                    case 42: 
                    case 43: {
                        if (hasNulls) break;
                        RowIterator it2 = index.lastRow(session, store, 0, null);
                        it2.next();
                        Object[] lastdata = it2.getCurrent();
                        return this.compareValues(session, data, lastdata);
                    }
                    case 44: 
                    case 45: {
                        if (hasNulls) break;
                        RowIterator it3 = index.firstRow(store);
                        it3.next();
                        Object[] firstdata = it3.getCurrent();
                        return this.compareValues(session, data, firstdata);
                    }
                }
                it = index.firstRow(store);
                boolean comparedNull = false;
                while (it.next()) {
                    Object[] currdata = it.getCurrent();
                    Boolean result = this.compareValues(session, data, currdata);
                    if (result == null) {
                        comparedNull = true;
                        continue;
                    }
                    if (result.booleanValue()) continue;
                    it.release();
                    return Boolean.FALSE;
                }
                if (comparedNull) {
                    return null;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    void distributeOr() {
        if (this.opType != 50) {
            return;
        }
        if (this.nodes[0].opType == 49) {
            this.opType = 49;
            ExpressionLogical temp = new ExpressionLogical(50, this.nodes[0].nodes[1], this.nodes[1]);
            this.nodes[0].opType = 50;
            this.nodes[0].nodes[1] = this.nodes[1];
            this.nodes[1] = temp;
        } else if (this.nodes[1].opType == 49) {
            Expression temp = this.nodes[0];
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = temp;
            this.distributeOr();
            return;
        }
        ((ExpressionLogical)this.nodes[0]).distributeOr();
        ((ExpressionLogical)this.nodes[1]).distributeOr();
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVar) {
        switch (this.opType) {
            case 49: {
                boolean result = this.nodes[0].isIndexable(rangeVar) || this.nodes[1].isIndexable(rangeVar);
                return result;
            }
            case 50: {
                boolean result = this.nodes[0].isIndexable(rangeVar) && this.nodes[1].isIndexable(rangeVar);
                return result;
            }
        }
        Expression temp = this.getIndexableExpression(rangeVar);
        return temp != null;
    }

    @Override
    Expression getIndexableExpression(RangeVariable rangeVar) {
        switch (this.opType) {
            case 47: {
                return this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVar) ? this : null;
            }
            case 48: {
                return this.nodes[0].opType == 47 && this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].isIndexable(rangeVar) ? this : null;
            }
            case 40: {
                if (this.exprSubType == 52) {
                    if (this.nodes[1].isCorrelated()) {
                        return null;
                    }
                    for (int node = 0; node < this.nodes[0].nodes.length; ++node) {
                        if (this.nodes[0].nodes[node].opType != 2 || !this.nodes[0].nodes[node].isIndexable(rangeVar)) continue;
                        return this;
                    }
                    return null;
                }
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.exprSubType != 0) {
                    return null;
                }
                if (this.nodes[1].isCorrelated()) {
                    return null;
                }
                if (this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVar)) {
                    if (this.nodes[1].hasReference(rangeVar)) {
                        return null;
                    }
                    return this;
                }
                if (this.nodes[0].hasReference(rangeVar)) {
                    return null;
                }
                if (this.nodes[1].opType == 2 && this.nodes[1].isIndexable(rangeVar)) {
                    this.swapCondition();
                    return this;
                }
                return null;
            }
            case 50: {
                if (this.isIndexable(rangeVar)) {
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    boolean isSimpleBound() {
        if (this.opType == 47) {
            return true;
        }
        if (this.nodes[1] != null) {
            if (this.nodes[1].opType == 1) {
                return true;
            }
            if (this.nodes[1].opType == 28 && ((FunctionSQL)this.nodes[1]).isValueFunction()) {
                return true;
            }
        }
        return false;
    }

    boolean convertToSmaller() {
        switch (this.opType) {
            case 41: 
            case 43: {
                this.swapCondition();
                return true;
            }
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    void swapCondition() {
        int i = 40;
        switch (this.opType) {
            case 41: 
            case 42: {
                i = 45;
                break;
            }
            case 45: {
                i = 41;
                break;
            }
            case 44: {
                i = 43;
                break;
            }
            case 43: {
                i = 44;
                break;
            }
            case 67: {
                i = 67;
                break;
            }
            case 40: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.opType = i;
        Expression e = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = e;
    }

    boolean reorderComparison(Session session, Expression parent) {
        Expression colExpression = null;
        Expression nonColExpression = null;
        boolean left = false;
        boolean replaceColumn = false;
        int operation = 0;
        if (this.nodes[0].opType == 32) {
            operation = 33;
            left = true;
        } else if (this.nodes[0].opType == 33) {
            operation = 32;
            left = true;
        } else if (this.nodes[1].opType == 32) {
            operation = 33;
        } else if (this.nodes[1].opType == 33) {
            operation = 32;
        }
        if (operation == 0) {
            return false;
        }
        if (left) {
            if (this.nodes[0].nodes[0].opType == 2) {
                colExpression = this.nodes[0].nodes[0];
                nonColExpression = this.nodes[0].nodes[1];
            } else if (this.nodes[0].nodes[1].opType == 2) {
                replaceColumn = operation == 32;
                colExpression = this.nodes[0].nodes[1];
                nonColExpression = this.nodes[0].nodes[0];
            }
        } else if (this.nodes[1].nodes[0].opType == 2) {
            colExpression = this.nodes[1].nodes[0];
            nonColExpression = this.nodes[1].nodes[1];
        } else if (this.nodes[1].nodes[1].opType == 2) {
            replaceColumn = operation == 32;
            colExpression = this.nodes[1].nodes[1];
            nonColExpression = this.nodes[1].nodes[0];
        }
        if (colExpression == null) {
            return false;
        }
        Expression otherExpression = left ? this.nodes[1] : this.nodes[0];
        ExpressionArithmetic newArg = null;
        if (!replaceColumn) {
            newArg = new ExpressionArithmetic(operation, otherExpression, nonColExpression);
            newArg.resolveTypesForArithmetic(session, parent);
        }
        if (left) {
            if (replaceColumn) {
                this.nodes[1] = colExpression;
                this.nodes[0].nodes[1] = otherExpression;
                ((ExpressionArithmetic)this.nodes[0]).resolveTypesForArithmetic(session, parent);
            } else {
                this.nodes[0] = colExpression;
                this.nodes[1] = newArg;
            }
        } else if (replaceColumn) {
            this.nodes[0] = colExpression;
            this.nodes[1].nodes[1] = otherExpression;
            ((ExpressionArithmetic)this.nodes[1]).resolveTypesForArithmetic(session, parent);
        } else {
            this.nodes[1] = colExpression;
            this.nodes[0] = newArg;
        }
        return true;
    }

    @Override
    boolean isConditionRangeVariable(RangeVariable range) {
        if (this.nodes[0].getRangeVariable() == range) {
            return true;
        }
        return this.nodes[1].getRangeVariable() == range;
    }

    @Override
    void getJoinRangeVariables(RangeVariable[] ranges, List list) {
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].getJoinRangeVariables(ranges, list);
        }
    }

    @Override
    double costFactor(Session session, RangeVariable rangeVar, int operation) {
        double cost;
        block0 : switch (this.opType) {
            case 50: {
                return this.nodes[0].costFactor(session, rangeVar, this.opType) + this.nodes[1].costFactor(session, rangeVar, this.opType);
            }
            case 54: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                PersistentStore store = rangeVar.rangeTable.getRowStore(session);
                cost = store.elementCount();
                if (!(cost < 16.0)) break;
                cost = 16.0;
                break;
            }
            case 47: 
            case 48: {
                cost = this.costFactorUnaryColumn(session, rangeVar);
                break;
            }
            case 40: {
                switch (this.exprSubType) {
                    case 52: {
                        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
                            cost = this.costFactorColumns(session, rangeVar);
                            cost *= 1024.0;
                            break block0;
                        }
                    }
                    case 51: {
                        PersistentStore store = rangeVar.rangeTable.getRowStore(session);
                        cost = store.elementCount();
                        if (cost < 16.0) {
                            cost = 16.0;
                        }
                        cost *= 1024.0;
                        break block0;
                    }
                }
                cost = this.costFactorColumns(session, rangeVar);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                cost = this.costFactorColumns(session, rangeVar);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return cost;
    }

    double costFactorUnaryColumn(Session session, RangeVariable rangeVar) {
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
            return this.nodes[0].costFactor(session, rangeVar, this.opType);
        }
        PersistentStore store = rangeVar.rangeTable.getRowStore(session);
        double cost = store.elementCount();
        return cost < 16.0 ? 16.0 : cost;
    }

    double costFactorColumns(Session session, RangeVariable rangeVar) {
        PersistentStore store;
        double cost = 0.0;
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
            if (!this.nodes[1].hasReference(rangeVar)) {
                cost = this.nodes[0].costFactor(session, rangeVar, this.opType);
            }
        } else if (this.nodes[1].opType == 2 && this.nodes[1].getRangeVariable() == rangeVar) {
            if (!this.nodes[0].hasReference(rangeVar)) {
                cost = this.nodes[1].costFactor(session, rangeVar, this.opType);
            }
        } else {
            store = rangeVar.rangeTable.getRowStore(session);
            cost = store.elementCount();
        }
        if (cost == 0.0) {
            store = rangeVar.rangeTable.getRowStore(session);
            cost = store.elementCount();
        }
        if (cost < 16.0) {
            cost = 16.0;
        }
        return cost;
    }

    @Override
    public void setNoOptimisation() {
        super.setNoOptimisation();
        if (this.opType == 40 && this.exprSubType == 52) {
            this.exprSubType = 0;
            this.opType = 54;
            this.isQuantified = false;
        }
    }
}

