/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.List;
import org.hsqldb.lib.Set;

public class ExpressionPeriod
extends Expression {
    PeriodDefinition period;
    ExpressionColumn columnExpr;

    ExpressionPeriod() {
        super(57);
    }

    ExpressionPeriod(Expression start, Expression end) {
        super(57);
        this.nodes = new Expression[]{start, end};
    }

    ExpressionPeriod(ExpressionColumn colExpr) {
        super(57);
        this.columnExpr = colExpr;
    }

    ExpressionPeriod(PeriodDefinition period) {
        super(57);
        this.period = period;
    }

    ExpressionPeriod(Expression rowExpr) {
        super(57);
        this.nodes = rowExpr.nodes;
    }

    boolean isNamedPeriod() {
        return this.period != null;
    }

    int getPeriodType() {
        if (this.period == null) {
            return 0;
        }
        return this.period.getPeriodType();
    }

    void setRangeVariable(RangeVariable rangeVar) {
        Table table = rangeVar.getTable();
        this.period = table.getSystemPeriod();
        ExpressionColumn left = new ExpressionColumn(rangeVar, this.period.startColumn);
        ExpressionColumn right = new ExpressionColumn(rangeVar, this.period.endColumn);
        this.nodes = new Expression[]{left, right};
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, List unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
        }
        RangeVariable[] rangeVarArray = rangeGroup.getRangeVariables();
        if (this.columnExpr != null) {
            for (int i = 0; i < rangeCount; ++i) {
                RangeVariable rangeVar = rangeVarArray[i];
                PeriodDefinition p = rangeVar.findPeriod(this.columnExpr.schema, this.columnExpr.tableName, this.columnExpr.columnName);
                if (p == null) continue;
                if (this.period == null) {
                    this.period = p;
                    ExpressionColumn left = new ExpressionColumn(rangeVar, this.period.startColumn);
                    ExpressionColumn right = new ExpressionColumn(rangeVar, this.period.endColumn);
                    this.nodes = new Expression[]{left, right};
                    continue;
                }
                throw Error.error(5516);
            }
            if (this.period == null) {
                throw Error.error(5516);
            }
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
    }

    @Override
    void collectObjectNames(Set set) {
        if (this.period != null) {
            set.add(this.period.getName());
        }
    }
}

