/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionPeriod;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.List;
import org.hsqldb.lib.Set;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class ExpressionPeriodOp
extends ExpressionLogical {
    PeriodDefinition leftPeriod;
    PeriodDefinition rightPeriod;
    final boolean isSystemVersionCondition;
    boolean transformed;

    private ExpressionPeriodOp(Expression[] nodes) {
        super(44);
        this.nodes = nodes;
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(int type, Expression left, Expression right) {
        super(type, left, right);
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp() {
        super(60);
        ExpressionPeriod left = new ExpressionPeriod();
        Expression right = ExpressionPeriodOp.getEpochLimitExpression();
        this.nodes = new Expression[]{left, right};
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(Expression pointOfTime) {
        super(59);
        ExpressionPeriod left = new ExpressionPeriod();
        this.nodes = new Expression[]{left, pointOfTime};
        this.isSystemVersionCondition = true;
    }

    ExpressionPeriodOp(Expression start, Expression end) {
        super(61);
        ExpressionPeriod left = new ExpressionPeriod();
        ExpressionPeriod right = new ExpressionPeriod(start, end);
        this.nodes = new Expression[]{left, right};
        this.isSystemVersionCondition = true;
    }

    boolean isSystemVersionCondition() {
        return this.isSystemVersionCondition;
    }

    void setSystemRangeVariable(Session session, RangeGroup[] rangeGroups, RangeVariable range) {
        ExpressionPeriod period = (ExpressionPeriod)this.nodes[0];
        period.setRangeVariable(range);
        Expression right = this.nodes[1];
        List unresolved = right.resolveColumnReferences(session, RangeGroup.emptyGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        right.resolveTypes(session, null);
        this.transform();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, List unresolvedSet, boolean acceptsSequences) {
        ExpressionColumn columnExpr;
        if (this.opType == 59 && this.nodes[1] instanceof ExpressionPeriod && (columnExpr = ((ExpressionPeriod)this.nodes[1]).columnExpr) != null) {
            try {
                this.nodes[1].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
            }
            catch (HsqlException e) {
                this.nodes[1] = columnExpr;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
        }
        if (this.nodes[0] instanceof ExpressionPeriod) {
            this.leftPeriod = ((ExpressionPeriod)this.nodes[0]).period;
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            this.rightPeriod = ((ExpressionPeriod)this.nodes[1]).period;
        }
        if (!this.transformed) {
            this.transform();
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        super.resolveTypes(session, parent);
    }

    private void transform() {
        ExpressionPeriod left = (ExpressionPeriod)this.nodes[0];
        boolean checkLeft = true;
        boolean checkRight = true;
        if (left.isNamedPeriod()) {
            if (left.getPeriodType() == 1) {
                // empty if block
            }
            checkLeft = false;
        } else {
            Expression node = left.getLeftNode();
            if (node.opType == 8) {
                node.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            node = left.getRightNode();
            if (node.opType == 8) {
                node.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            ExpressionPeriod right = (ExpressionPeriod)this.nodes[1];
            if (right.isNamedPeriod()) {
                if (right.getPeriodType() == 1) {
                    // empty if block
                }
                checkRight = false;
            } else {
                Expression node = right.getLeftNode();
                if (node.opType == 8) {
                    node.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                node = right.getRightNode();
                if (node.opType == 8) {
                    node.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
            }
        } else {
            checkRight = false;
        }
        ExpressionLogical expanded = ExpressionPeriodOp.newExpression(this.opType, this.nodes, checkLeft, checkRight);
        this.nodes = expanded.nodes;
        this.opType = expanded.opType;
        this.transformed = true;
    }

    @Override
    public Object getValue(Session session) {
        Object result = super.getValue(session);
        if (this.opType == 44 && Boolean.FALSE.equals(result)) {
            throw Error.error(3462);
        }
        return result;
    }

    @Override
    void collectObjectNames(Set set) {
        if (this.leftPeriod != null) {
            set.add(this.leftPeriod.getName());
        }
        if (this.rightPeriod != null) {
            set.add(this.rightPeriod.getName());
        }
    }

    static Expression getEpochLimitExpression() {
        return new ExpressionValue(DateTimeType.epochLimitTimestamp, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
    }

    static ExpressionLogical newExpression(int type, Expression[] nodes, boolean checkLeft, boolean checkRight) {
        ExpressionLogical c;
        ExpressionLogical b;
        ExpressionLogical a;
        Expression left = nodes[0];
        Expression right = nodes[1];
        switch (type) {
            case 59: {
                if (right instanceof ExpressionPeriod) {
                    a = new ExpressionLogical(45, left.getLeftNode(), right.getLeftNode());
                    b = new ExpressionLogical(41, left.getRightNode(), right.getRightNode());
                } else {
                    a = new ExpressionLogical(45, left.getLeftNode(), right);
                    b = new ExpressionLogical(43, left.getRightNode(), right);
                }
                c = new ExpressionLogical(49, a, b);
                break;
            }
            case 60: {
                if (right instanceof ExpressionPeriod) {
                    a = new ExpressionLogical(40, left.getLeftNode(), right.getLeftNode());
                    b = new ExpressionLogical(40, left.getRightNode(), right.getRightNode());
                    c = new ExpressionLogical(49, a, b);
                    break;
                }
                c = new ExpressionLogical(40, left.getRightNode(), right);
                break;
            }
            case 61: {
                a = new ExpressionLogical(44, left.getLeftNode(), right.getRightNode());
                b = new ExpressionLogical(43, left.getRightNode(), right.getLeftNode());
                c = new ExpressionLogical(49, a, b);
                break;
            }
            case 62: {
                c = new ExpressionLogical(45, left.getRightNode(), right.getLeftNode());
                break;
            }
            case 64: {
                c = new ExpressionLogical(40, left.getRightNode(), right.getLeftNode());
                break;
            }
            case 63: {
                c = new ExpressionLogical(41, left.getLeftNode(), right.getRightNode());
                break;
            }
            case 65: {
                c = new ExpressionLogical(40, left.getLeftNode(), right.getRightNode());
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        a = null;
        b = null;
        if (checkLeft) {
            a = new ExpressionPeriodOp(left.nodes);
        }
        if (checkRight) {
            b = new ExpressionPeriodOp(right.nodes);
        }
        if (a == null) {
            a = b;
            b = null;
        }
        if (b != null) {
            a = new ExpressionLogical(49, a, b);
            b = null;
        }
        if (a != null) {
            c = new ExpressionLogical(49, a, c);
        }
        return c;
    }
}

