/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression[] e, boolean ordinality) {
        super(30);
        this.nodes = e;
        this.ordinality = ordinality;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        if (this.isTable) {
            sb.append("TABLE").append(' ');
        } else {
            sb.append("UNNEST").append(' ');
        }
        sb.append(this.nodes[0].describe(session, blanks));
        return sb.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes.length == 1 && this.nodes[0].dataType.isRowType()) {
            if (this.ordinality) {
                throw Error.error(5581, "ORDINALITY");
            }
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.table.prepareTable(session);
            this.table.columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
            this.isTable = true;
            return;
        }
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].dataType.isArrayType()) continue;
            throw Error.error(5563, "UNNEST");
        }
        int columnCount = this.ordinality ? this.nodes.length + 1 : this.nodes.length;
        this.nodeDataTypes = new Type[columnCount];
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            this.nodeDataTypes[i2] = this.nodes[i2].dataType.collectionBaseType();
            if (this.nodeDataTypes[i2] != null && this.nodeDataTypes[i2] != Type.SQL_ALL_TYPES) continue;
            throw Error.error(5567, "UNNEST");
        }
        if (this.ordinality) {
            this.nodeDataTypes[this.nodes.length] = Type.SQL_INTEGER;
        }
        this.table.prepareTable(session);
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData navigator = this.table.getNavigator(session);
                Result result = Result.newResult(navigator);
                result.metaData = this.table.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] value = this.table.getValues(session);
                if (value.length == 1) {
                    return value[0];
                }
                return value;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        if (this.isTable) {
            this.insertTableValues(session, store);
        } else {
            this.insertArrayValues(session, store);
        }
    }

    private void insertTableValues(Session session, PersistentStore store) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator nav = result.navigator;
        while (nav.next()) {
            Object[] data = nav.getCurrent();
            Object[] newdata = (Object[])ArrayUtil.duplicateArray(data);
            Row row = (Row)store.getNewCachedObject(session, newdata, false);
            try {
                store.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore store) {
        int i;
        Object[][] array = new Object[this.nodes.length][];
        for (i = 0; i < array.length; ++i) {
            Object[] values = (Object[])this.nodes[i].getValue(session);
            if (values == null) {
                values = ValuePool.emptyObjectArray;
            }
            array[i] = values;
        }
        i = 0;
        while (true) {
            boolean isRow = false;
            Object[] data = new Object[this.nodeDataTypes.length];
            for (int arrayIndex = 0; arrayIndex < array.length; ++arrayIndex) {
                if (i >= array[arrayIndex].length) continue;
                data[arrayIndex] = array[arrayIndex][i];
                isRow = true;
            }
            if (!isRow) break;
            if (this.ordinality) {
                data[this.nodes.length] = ValuePool.getInt(i + 1);
            }
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            ++i;
        }
    }
}

