/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASCIISTR = 75;
    private static final int FUNC_ASIN = 76;
    private static final int FUNC_ATAN = 77;
    private static final int FUNC_ATAN2 = 78;
    private static final int FUNC_BITAND = 79;
    private static final int FUNC_BITANDNOT = 80;
    private static final int FUNC_BITNOT = 81;
    private static final int FUNC_BITOR = 82;
    private static final int FUNC_BITXOR = 83;
    private static final int FUNC_CHAR = 84;
    private static final int FUNC_CONCAT = 85;
    private static final int FUNC_COS = 86;
    private static final int FUNC_COSH = 87;
    private static final int FUNC_COT = 88;
    private static final int FUNC_CRYPT_KEY = 89;
    private static final int FUNC_DATABASE = 90;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 91;
    private static final int FUNC_DATABASE_NAME = 92;
    private static final int FUNC_DATABASE_TIMEZONE = 93;
    private static final int FUNC_DATABASE_VERSION = 94;
    private static final int FUNC_DATE_ADD = 95;
    private static final int FUNC_DATE_SUB = 96;
    private static final int FUNC_DATEADD = 97;
    private static final int FUNC_DATEDIFF = 98;
    private static final int FUNC_DAYS = 99;
    private static final int FUNC_DBTIMEZONE = 100;
    private static final int FUNC_DEGREES = 101;
    private static final int FUNC_DIAGNOSTICS = 102;
    private static final int FUNC_DIFFERENCE = 103;
    private static final int FUNC_FROM_BASE64 = 104;
    private static final int FUNC_FROM_TZ = 105;
    private static final int FUNC_HEX = 106;
    private static final int FUNC_HEXTORAW = 107;
    private static final int FUNC_IDENTITY = 108;
    private static final int FUNC_INSTR = 109;
    private static final int FUNC_ISAUTOCOMMIT = 110;
    private static final int FUNC_ISOLATION_LEVEL = 111;
    private static final int FUNC_ISREADONLYDATABASE = 112;
    private static final int FUNC_ISREADONLYDATABASEFILES = 113;
    private static final int FUNC_ISREADONLYSESSION = 114;
    private static final int FUNC_LAST_DAY = 115;
    private static final int FUNC_LEFT = 116;
    private static final int FUNC_LOAD_FILE = 117;
    private static final int FUNC_LOB_ID = 118;
    private static final int FUNC_LOCATE = 119;
    private static final int FUNC_LOG10 = 120;
    private static final int FUNC_LPAD = 121;
    private static final int FUNC_LTRIM = 122;
    private static final int FUNC_MONTHS_BETWEEN = 123;
    private static final int FUNC_NEW_TIME = 124;
    private static final int FUNC_NEXT_DAY = 125;
    private static final int FUNC_NUMTODSINTERVAL = 126;
    private static final int FUNC_NUMTOYMINTERVAL = 127;
    private static final int FUNC_PI = 128;
    private static final int FUNC_POSITION_ARRAY = 129;
    private static final int FUNC_RADIANS = 130;
    private static final int FUNC_RAND = 131;
    private static final int FUNC_RAWTOHEX = 132;
    private static final int FUNC_REGEXP_COUNT = 133;
    private static final int FUNC_REGEXP_INSTR = 134;
    private static final int FUNC_REGEXP_LIKE = 135;
    private static final int FUNC_REGEXP_MATCHES = 136;
    private static final int FUNC_REGEXP_REPLACE = 137;
    private static final int FUNC_REGEXP_SUBSTR = 138;
    private static final int FUNC_REGEXP_SUBSTRING = 139;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 140;
    private static final int FUNC_REPEAT = 141;
    private static final int FUNC_REPLACE = 142;
    private static final int FUNC_REVERSE = 143;
    private static final int FUNC_RIGHT = 144;
    private static final int FUNC_ROUND = 145;
    private static final int FUNC_ROUNDMAGIC = 146;
    private static final int FUNC_RPAD = 147;
    private static final int FUNC_RTRIM = 148;
    private static final int FUNC_SECONDS_MIDNIGHT = 149;
    private static final int FUNC_SEQUENCE_ARRAY = 150;
    private static final int FUNC_SESSION_ID = 151;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 152;
    private static final int FUNC_SESSION_TIMEZONE = 153;
    private static final int FUNC_SESSIONTIMEZONE = 154;
    private static final int FUNC_SIGN = 155;
    private static final int FUNC_SIN = 156;
    private static final int FUNC_SINH = 157;
    private static final int FUNC_SOUNDEX = 158;
    private static final int FUNC_SORT_ARRAY = 159;
    private static final int FUNC_SPACE = 160;
    private static final int FUNC_SUBSTR = 161;
    private static final int FUNC_SYS_EXTRACT_UTC = 162;
    private static final int FUNC_SYS_GUID = 163;
    private static final int FUNC_SYSDATE = 164;
    private static final int FUNC_SYSTIMESTAMP = 165;
    private static final int FUNC_TAN = 166;
    private static final int FUNC_TANH = 167;
    private static final int FUNC_TIMESTAMP = 168;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 169;
    private static final int FUNC_TIMESTAMPADD = 170;
    private static final int FUNC_TIMESTAMPDIFF = 171;
    private static final int FUNC_TIMEZONE = 172;
    private static final int FUNC_TO_BASE64 = 173;
    private static final int FUNC_TO_CHAR = 174;
    private static final int FUNC_TO_DATE = 175;
    private static final int FUNC_TO_DSINTERVAL = 176;
    private static final int FUNC_TO_YMINTERVAL = 177;
    private static final int FUNC_TO_NUMBER = 178;
    private static final int FUNC_TO_TIMESTAMP = 179;
    private static final int FUNC_TO_TIMESTAMP_TZ = 180;
    private static final int FUNC_TRANSACTION_CONTROL = 181;
    private static final int FUNC_TRANSACTION_ID = 182;
    private static final int FUNC_TRANSACTION_SIZE = 183;
    private static final int FUNC_TRANSACTION_UTC = 184;
    private static final int FUNC_TRANSLATE = 185;
    private static final int FUNC_TRUNC = 186;
    private static final int FUNC_TRUNCATE = 187;
    private static final int FUNC_UNHEX = 188;
    private static final int FUNC_UNISTR = 189;
    private static final int FUNC_UUID = 190;
    private static final int FUNC_UNIX_TIMESTAMP = 191;
    private static final int FUNC_UNIX_MILLIS = 192;
    private static final int FUNC_DATEPART = 193;
    private static final int FUNC_DATENAME = 194;
    private static final int FUNC_NANVL = 195;
    private static final int FUNC_SQLCODE = 196;
    private static final int FUNC_SQLERRM = 197;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(Session session, String token, int tokenType) {
        int id = customRegularFuncMap.get(tokenType, -1);
        if (id == -1) {
            id = customValueFuncMap.get(tokenType, -1);
        }
        if (id == -1) {
            return null;
        }
        switch (tokenType) {
            case 468: 
            case 713: 
            case 763: 
            case 768: 
            case 784: 
            case 844: {
                return new FunctionSQL(id);
            }
            case 724: 
            case 725: 
            case 781: 
            case 837: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 818: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                function.name = "SUBSTR";
                return function;
            }
            case 861: 
            case 862: 
            case 863: 
            case 864: {
                if (session.database.sqlSyntaxMss) break;
                return null;
            }
            case 743: 
            case 822: 
            case 866: {
                if (session.database.sqlSyntaxOra) break;
                return null;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 31) {
            switch (tokenType) {
                case 771: {
                    function.extractSpec = 161;
                    break;
                }
                case 803: {
                    function.extractSpec = 302;
                    break;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 738: {
                    function.extractSpec = 734;
                    break;
                }
                case 774: {
                    function.extractSpec = 773;
                    break;
                }
                case 739: {
                    function.extractSpec = 735;
                    break;
                }
                case 740: {
                    function.extractSpec = 736;
                    break;
                }
                case 741: {
                    function.extractSpec = 737;
                    break;
                }
                case 850: {
                    function.extractSpec = 851;
                    break;
                }
                default: {
                    function.extractSpec = tokenType;
                }
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    public static boolean isRegularFunction(int tokenType) {
        return customRegularFuncMap.get(tokenType, -1) != -1;
    }

    public static boolean isValueFunction(int tokenType) {
        return customValueFuncMap.get(tokenType, -1) != -1;
    }

    private FunctionCustom(int id) {
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 196: 
            case 197: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 100: 
            case 154: 
            case 164: 
            case 165: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 128: 
            case 151: 
            case 152: 
            case 153: 
            case 163: 
            case 172: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 99: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 115: 
            case 118: 
            case 120: 
            case 130: 
            case 132: 
            case 143: 
            case 146: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 162: 
            case 166: 
            case 167: 
            case 169: 
            case 173: 
            case 176: 
            case 177: 
            case 178: 
            case 188: 
            case 189: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 89: 
            case 103: 
            case 105: 
            case 116: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 144: 
            case 195: {
                this.parseList = doubleParamList;
                break;
            }
            case 174: 
            case 175: 
            case 179: 
            case 180: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 117: 
            case 145: 
            case 168: 
            case 186: 
            case 187: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 98: {
                this.parseList = new short[]{937, 1005, 924, 939, 924, 939, 922};
                this.parseListAlt = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 97: {
                this.parseList = new short[]{937, 1005, 924, 939, 924, 939, 922};
                this.parseListAlt = tripleParamList;
                break;
            }
            case 193: 
            case 194: {
                this.parseList = new short[]{937, 1005, 924, 939, 922};
                break;
            }
            case 95: 
            case 96: {
                this.parseList = doubleParamList;
                break;
            }
            case 150: 
            case 185: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 121: 
            case 142: 
            case 147: {
                this.parseList = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 137: {
                this.parseList = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 108: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 102: {
                this.parseList = new short[]{937, 537, 922};
                break;
            }
            case 129: {
                this.parseList = new short[]{937, 939, 140, 939, 1002, 2, 124, 939, 922};
                break;
            }
            case 159: {
                this.parseList = new short[]{937, 939, 1002, 4, 1001, 2, 360, 411, 1002, 5, 489, 1001, 2, 427, 467, 922};
                break;
            }
            case 170: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{937, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 850, 183, 787, 341, 924, 939, 924, 939, 922};
                break;
            }
            case 171: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{937, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 850, 183, 787, 341, 924, 939, 924, 939, 922};
                break;
            }
            case 131: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 1: {
                Expression[] newNodes = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    newNodes[0] = nodes[0];
                    newNodes[1] = nodes[1];
                    newNodes[3] = nodes[2];
                    nodes = newNodes;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                newNodes[0] = nodes[1];
                newNodes[1] = nodes[0];
                newNodes[3] = nodes[2];
                nodes = newNodes;
                break;
            }
            case 32: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 31: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[1] == null ? new ExpressionValue(" ", Type.SQL_CHAR) : nodes[1], nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 85: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 196: {
                return 0;
            }
            case 197: {
                return "Error";
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, data);
            }
            case 90: {
                return session.getDatabase().getPath();
            }
            case 92: {
                return session.getDatabase().getNameString();
            }
            case 110: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 114: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 112: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 113: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 111: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 152: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 91: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 181: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 172: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 153: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 100: {
                TimestampData timestamp = DateTimeType.newSystemTimestampWithZone();
                IntervalSecondData zone = new IntervalSecondData(timestamp.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(zone);
            }
            case 93: {
                int sec = HsqlDateTime.getZoneSeconds();
                return new IntervalSecondData(sec, 0);
            }
            case 94: {
                return "2.7.1";
            }
            case 151: {
                return session.getId();
            }
            case 72: {
                return session.actionSCN;
            }
            case 182: {
                return session.transactionSCN;
            }
            case 183: {
                return (long)session.getTransactionSize();
            }
            case 184: {
                return session.getTransactionUTC();
            }
            case 118: {
                LobData lob = (LobData)data[0];
                if (lob == null) {
                    return null;
                }
                return lob.getId();
            }
            case 108: {
                Number id = session.getLastIdentity();
                if (id instanceof Long) {
                    return id;
                }
                return ValuePool.getLong(id.longValue());
            }
            case 102: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 150: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                HsqlArrayList<Object> list = new HsqlArrayList<Object>();
                Object current = data[0];
                Type type = this.nodes[0].getDataType();
                boolean ascending = type.compare(session, data[1], data[0]) >= 0;
                while (true) {
                    int compare = type.compare(session, current, data[1]);
                    if (ascending ? compare > 0 : compare < 0) break;
                    list.add(current);
                    Object newValue = type.add(session, current, data[2], this.nodes[2].getDataType());
                    compare = type.compare(session, current, newValue);
                    if (ascending ? compare >= 0 : compare <= 0) break;
                    current = newValue;
                }
                Object[] array = list.toArray();
                return array;
            }
            case 170: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                int part = ((Number)this.nodes[0].valueData).intValue();
                long units = ((Number)data[1]).longValue();
                TimestampData source = (TimestampData)data[2];
                switch (part) {
                    case 873: 
                    case 981: {
                        long seconds = units / 1000000000L;
                        int nanos = (int)(units % 1000000000L);
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 871: 
                    case 983: {
                        long seconds = units / 1000000L;
                        int nanos = (int)(units % 1000000L) * 1000;
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 872: 
                    case 982: {
                        long seconds = units / 1000L;
                        int nanos = (int)(units % 1000L) * 1000000;
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 264: 
                    case 984: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 179: 
                    case 985: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 137: 
                    case 986: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 78: 
                    case 736: 
                    case 737: 
                    case 987: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 850: 
                    case 988: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 183: 
                    case 989: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 787: 
                    case 990: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 341: 
                    case 991: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 12L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 171: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                TimestampData a = (TimestampData)data[2];
                TimestampData b = (TimestampData)data[1];
                switch (part) {
                    case 873: 
                    case 981: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(session, a, b, null);
                        return 1000000000L * interval.getSeconds() + (long)interval.getNanos();
                    }
                    case 871: 
                    case 983: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(session, a, b, null);
                        return 1000000L * interval.getSeconds() + (long)(interval.getNanos() / 1000);
                    }
                    case 872: 
                    case 982: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(session, a, b, null);
                        return 1000L * interval.getSeconds() + (long)(interval.getNanos() / 1000000);
                    }
                    case 264: 
                    case 984: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                    case 179: 
                    case 985: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                    case 137: 
                    case 986: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                    case 78: 
                    case 987: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                    case 850: 
                    case 988: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        long ret = t.convertToLongEndUnits(t.subtract(session, a, b, null));
                        ret = ret < 0L ? (ret - 6L) / 7L : (ret + 6L) / 7L;
                        return ret;
                    }
                    case 183: 
                    case 989: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                    case 787: 
                    case 990: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        long ret = t.convertToLongEndUnits(t.subtract(session, a, b, null));
                        ret = ret < 0L ? (ret - 2L) / 3L : (ret + 2L) / 3L;
                        return ret;
                    }
                    case 341: 
                    case 991: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return t.convertToLongEndUnits(t.subtract(session, a, b, null));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 194: {
                Object value = this.getExtractValue(session, data);
                return this.dataType.convertToDefaultType(session, value);
            }
            case 95: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return this.dataType.add(session, data[0], data[1], this.nodes[1].dataType);
            }
            case 96: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, data[0], data[1], this.nodes[1].dataType);
            }
            case 99: {
                if (data[0] == null) {
                    return null;
                }
                IntervalSecondData diff = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, data[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(diff.getSeconds() / 86400L + 1L));
            }
            case 128: {
                return Math.PI;
            }
            case 131: {
                if (this.nodes[0] == null) {
                    return session.random();
                }
                data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                long seed = ((Number)data[0]).longValue();
                return session.random(seed);
            }
            case 145: 
            case 186: {
                int interval = 103;
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType type = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (data[1] == null) {
                            return null;
                        }
                        interval = HsqlDateTime.toStandardIntervalPart((String)data[1]);
                    }
                    if (interval < 0) {
                        throw Error.error(5566, (String)data[1]);
                    }
                    return this.funcType == 145 ? type.round(session, data[0], interval) : type.truncate(session, data[0], interval);
                }
            }
            case 187: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                    offset = ((Number)data[1]).intValue();
                }
                return this.funcType == 145 ? ((NumberType)this.dataType).round(data[0], offset) : ((NumberType)this.dataType).truncate(data[0], offset);
            }
            case 104: {
                String val = (String)data[0];
                if (val == null) {
                    return null;
                }
                val = val.trim();
                byte[] bytes = Base64.getDecoder().decode(val);
                return new BinaryData(bytes, false);
            }
            case 173: {
                BinaryData val = (BinaryData)data[0];
                if (val == null) {
                    return null;
                }
                return Base64.getEncoder().encodeToString(val.getBytes());
            }
            case 174: {
                if (this.nodes[1] == null) {
                    return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                return HsqlDateTime.toFormattedDate(date, (String)data[1], format);
            }
            case 178: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 175: 
            case 179: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateOrTimestampType()) {
                    return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                }
                boolean fraction = this.funcType == 179;
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                TimestampData value = HsqlDateTime.toDate((String)data[0], (String)data[1], format, fraction);
                return value;
            }
            case 168: {
                boolean unary;
                boolean bl = unary = this.nodes[1] == null;
                if (data[0] == null) {
                    return null;
                }
                if (unary) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        Calendar calendar = session.getCalendar();
                        long seconds = ((Number)data[0]).longValue();
                        calendar.setTimeInMillis(seconds * 1000L);
                        int zone = HsqlDateTime.getZoneSeconds(calendar);
                        return new TimestampData(seconds + (long)zone);
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, data[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException e) {
                        return Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                    }
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                TimeData time = (TimeData)Type.SQL_TIME_MAX.convertToType(session, data[1], this.nodes[1].dataType);
                return new TimestampData(date.getSeconds() + (long)time.getSeconds(), time.getNanos());
            }
            case 169: {
                long seconds;
                Calendar calendar = session.getCalendar();
                int nanos = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    seconds = ((Number)data[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    seconds = ((TimestampData)data[0]).getSeconds();
                    seconds = HsqlDateTime.convertMillisToCalendar(calendar, seconds * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    seconds = ((TimestampData)data[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)data[1]);
                }
                calendar.setTimeInMillis(seconds * 1000L);
                int zone = HsqlDateTime.getZoneSeconds(calendar);
                return new TimestampData(seconds, nanos, zone);
            }
            case 163: {
                UUID uuid = UUID.randomUUID();
                long hi = uuid.getMostSignificantBits();
                long lo = uuid.getLeastSignificantBits();
                return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
            }
            case 190: {
                if (this.nodes[0] == null) {
                    UUID uuid = UUID.randomUUID();
                    long hi = uuid.getMostSignificantBits();
                    long lo = uuid.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
                }
                if (data[0] == null) {
                    return null;
                }
                try {
                    if (this.dataType.isBinaryType()) {
                        byte[] bytes = StringConverter.toBinaryUUID((String)data[0]);
                        return new BinaryData(bytes, false);
                    }
                    return StringConverter.toStringUUID(((BinaryData)data[0]).getBytes());
                }
                catch (NumberFormatException e) {
                    throw Error.error(3459, e);
                }
            }
            case 192: {
                TimestampData ts;
                if (this.nodes[0] == null) {
                    ts = session.getCurrentTimestamp();
                } else {
                    if (data[0] == null) {
                        return null;
                    }
                    ts = (TimestampData)data[0];
                }
                long millis = ts.getSeconds() * 1000L + (long)(ts.getNanos() / 1000000);
                return millis;
            }
            case 191: {
                TimestampData ts;
                if (this.nodes[0] == null) {
                    ts = session.getCurrentTimestamp();
                } else {
                    if (data[0] == null) {
                        return null;
                    }
                    ts = (TimestampData)data[0];
                }
                return ts.getSeconds();
            }
            case 71: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.acos(d);
            }
            case 76: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.asin(d);
            }
            case 77: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.atan(d);
            }
            case 86: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.cos(d);
            }
            case 87: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.cosh(d);
            }
            case 88: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                double c = 1.0 / Math.tan(d);
                return c;
            }
            case 101: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.toDegrees(d);
            }
            case 156: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.sin(d);
            }
            case 157: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.sinh(d);
            }
            case 166: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.tan(d);
            }
            case 167: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.tanh(d);
            }
            case 120: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                if (d < 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                return Math.log10(d);
            }
            case 130: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.toRadians(d);
            }
            case 155: {
                if (data[0] == null) {
                    return null;
                }
                if (session.database.sqlSyntaxOra && data[0] instanceof Double && (Double)data[0] == 0.0) {
                    return 1;
                }
                int val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return val;
            }
            case 78: {
                if (data[0] == null) {
                    return null;
                }
                double a = NumberType.toDouble(data[0]);
                double b = NumberType.toDouble(data[1]);
                return Math.atan2(a, b);
            }
            case 74: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.isEmpty()) {
                    return null;
                }
                return ValuePool.getInt(arg.charAt(0));
            }
            case 75: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                return StringConverter.stringToUnicodeEscaped(arg);
            }
            case 84: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int arg = ((Number)data[0]).intValue();
                if (Character.isValidCodePoint(arg) && Character.isValidCodePoint((char)arg)) {
                    return String.valueOf((char)arg);
                }
                throw Error.error(3472);
            }
            case 146: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    offset = ((Number)data[1]).intValue();
                }
                return ((NumberType)this.dataType).round(data[0], offset);
            }
            case 158: {
                if (data[0] == null) {
                    return null;
                }
                String s = (String)data[0];
                return new String(FunctionCustom.soundex(s), 0, 4);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                byte[] v;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long v2 = 0L;
                    long b = 0L;
                    data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                    long a = ((Number)data[0]).longValue();
                    if (this.funcType != 81) {
                        data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                        b = ((Number)data[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 79: {
                            v2 = a & b;
                            break;
                        }
                        case 80: {
                            v2 = a & (b ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 81: {
                            v2 = a ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 82: {
                            v2 = a | b;
                            break;
                        }
                        case 83: {
                            v2 = a ^ b;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(v2);
                        }
                        case 25: {
                            return ValuePool.getLong(v2);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)v2);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] a = ((BinaryData)data[0]).getBytes();
                byte[] b = null;
                if (this.funcType != 81) {
                    b = ((BinaryData)data[1]).getBytes();
                }
                switch (this.funcType) {
                    case 79: {
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 80: {
                        b = BitMap.not(b);
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 81: {
                        v = BitMap.not(a);
                        break;
                    }
                    case 82: {
                        v = BitMap.or(a, b);
                        break;
                    }
                    case 83: {
                        v = BitMap.xor(a, b);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(v, this.dataType.precision);
            }
            case 103: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                char[] s1 = FunctionCustom.soundex((String)data[0]);
                char[] s2 = FunctionCustom.soundex((String)data[1]);
                int e = 0;
                if (s1[0] == s2[0]) {
                    ++e;
                }
                int js = 1;
                block179: for (int i = 1; i < 4; ++i) {
                    for (int j = js; j < 4; ++j) {
                        if (s1[j] != s2[i]) continue;
                        ++e;
                        js = j + 1;
                        continue block179;
                    }
                }
                return ValuePool.getInt(e);
            }
            case 106: {
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isBinaryType()) {
                    return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    long val = ((Number)data[0]).longValue();
                    return Long.toHexString(val);
                }
                String val = (String)data[0];
                byte[] bytes = val.getBytes(JavaSystem.CS_ISO_8859_1);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 189: {
                if (data[0] == null) {
                    return null;
                }
                try {
                    return StringConverter.unicodeEscapedToString((String)data[0]);
                }
                catch (Throwable e) {
                    throw Error.error(e, 5586, null);
                }
            }
            case 107: 
            case 188: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 132: {
                if (data[0] == null) {
                    return null;
                }
                BlobData binary = (BlobData)data[0];
                byte[] bytes = binary.getBytes(session, 0L, (int)binary.length(session));
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 141: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                String string = (String)data[0];
                int i = ((Number)data[1]).intValue();
                StringBuilder sb = new StringBuilder(string.length() * i);
                while (i-- > 0) {
                    sb.append(string);
                }
                return sb.toString();
            }
            case 142: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                String string = (String)data[0];
                String find = (String)data[1];
                String replace = (String)data[2];
                StringBuilder sb = new StringBuilder();
                int start = 0;
                if (find.isEmpty()) {
                    return string;
                }
                while (true) {
                    int i;
                    if ((i = string.indexOf(find, start)) == -1) break;
                    sb.append(string, start, i);
                    sb.append(replace);
                    start = i + find.length();
                }
                sb.append(string.substring(start));
                return sb.toString();
            }
            case 116: 
            case 144: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                int start = 0;
                int count = ((Number)data[1]).intValue();
                boolean hasLength = true;
                boolean trailing = false;
                if (this.funcType == 144) {
                    start = count;
                    count = 0;
                    hasLength = false;
                    trailing = true;
                }
                return ((CharacterType)this.dataType).substring(session, data[0], start, count, hasLength, trailing);
            }
            case 160: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int count = ((Number)data[0]).intValue();
                char[] array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 143: {
                if (data[0] == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 137: {
                String result;
                for (int i = 0; i < this.nodes.length && this.nodes[i] != null; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                int flags = FunctionCustom.regexpParams((String)data[5]);
                String source = (String)data[0];
                String matchPattern = (String)data[1];
                String replace = (String)data[2];
                int start = 1;
                int count = 0;
                if (this.nodes[2] == null) {
                    replace = "";
                }
                if (this.nodes[3] != null && ((start = ((Number)data[3]).intValue()) < 1 || start >= source.length())) {
                    throw Error.error(3403);
                }
                if (this.nodes[4] != null && (count = ((Number)data[4]).intValue()) < 0) {
                    throw Error.error(3403);
                }
                Pattern currentPattern = this.pattern;
                if (currentPattern == null) {
                    currentPattern = Pattern.compile(matchPattern, flags);
                }
                Matcher matcher = currentPattern.matcher(source);
                if (start > 1) {
                    matcher.region(start - 1, source.length());
                }
                if (count == 0) {
                    result = matcher.replaceAll(replace);
                } else if (count == 1) {
                    result = matcher.replaceFirst(replace);
                } else {
                    throw Error.error(3472, "count");
                }
                return result;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                Pattern currentPattern = this.pattern;
                String source = (String)data[0];
                String matchPattern = (String)data[1];
                if (currentPattern == null) {
                    currentPattern = Pattern.compile(matchPattern);
                }
                Matcher matcher = currentPattern.matcher(source);
                switch (this.funcType) {
                    case 135: 
                    case 136: {
                        boolean match = matcher.matches();
                        return match;
                    }
                    case 134: {
                        boolean match = matcher.find();
                        if (match) {
                            return matcher.start() + 1;
                        }
                        return ValuePool.INTEGER_0;
                    }
                    case 138: 
                    case 139: {
                        boolean match = matcher.find();
                        if (match) {
                            return matcher.group();
                        }
                        return null;
                    }
                    case 133: {
                        int count = 0;
                        while (matcher.find()) {
                            ++count;
                        }
                        return count;
                    }
                    case 140: {
                        HsqlArrayList<String> list = new HsqlArrayList<String>();
                        while (matcher.find()) {
                            list.add(matcher.group());
                        }
                        return list.toArray();
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 89: {
                byte[] bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 117: {
                String fileName = (String)data[0];
                if (fileName == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(fileName, (String)data[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(fileName);
            }
            case 121: 
            case 147: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                String value = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, data[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)data[0] : this.nodes[0].dataType.convertToString(data[0]));
                int length = (Integer)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType);
                String pad = " ";
                if (this.nodes[2] != null && (pad = this.nodes[2].dataType.convertToString(data[2])).isEmpty()) {
                    pad = " ";
                }
                value = (String)Type.SQL_VARCHAR.trim(session, value, ' ', true, true);
                value = StringUtil.toPaddedString(value, length, pad, this.funcType == 147);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, value, Type.SQL_VARCHAR);
                }
                return value;
            }
            case 129: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                Object[] array = (Object[])data[1];
                ArrayType dt = (ArrayType)this.nodes[1].dataType;
                Type elementType = dt.collectionBaseType();
                int start = 1;
                if (this.nodes[2] != null) {
                    if (data[2] == null) {
                        return null;
                    }
                    start = ((Number)Type.SQL_INTEGER.convertToType(session, data[2], this.nodes[2].dataType)).intValue();
                }
                if (start < 1) {
                    throw Error.error(3403);
                }
                for (int i = --start; i < array.length; ++i) {
                    if (elementType.compare(session, data[0], array[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 159: {
                if (data[0] == null) {
                    return null;
                }
                ArrayType dt = (ArrayType)this.dataType;
                SortAndSlice exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                exprSort.sortDescending[0] = ((Number)data[1]).intValue() == 411;
                exprSort.sortNullsLast[0] = ((Number)data[2]).intValue() == 467;
                Object[] array = (Object[])ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
            case 73: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData ts = (TimestampData)data[0];
                int months = ((Number)data[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, ts, months);
            }
            case 105: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                TimestampData timestamp = (TimestampData)data[0];
                if (DateTimeType.zoneIDs.contains(data[1])) {
                    return ((DateTimeType)this.dataType).changeZone(session, timestamp, (String)data[1]);
                }
                IntervalSecondData zone = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, data[1]);
                return new TimestampData(timestamp.getSeconds() + (long)timestamp.getZone() - zone.getSeconds(), timestamp.getNanos(), (int)zone.getSeconds());
            }
            case 115: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, data[0]);
            }
            case 123: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)data[0], (TimestampData)data[1]);
            }
            case 195: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                if (Double.isNaN(d)) {
                    return this.dataType.convertToType(session, data[1], this.nodes[1].dataType);
                }
                return data[0];
            }
            case 125: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                int day = DateTimeType.getDayOfWeek((String)data[1]);
                return DateTimeType.nextDayOfWeek(session, date, day);
            }
            case 126: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object st = Type.SQL_VARCHAR.trim(session, data[1], ' ', true, true);
                st = Type.SQL_VARCHAR.upper(session, st);
                st = Type.SQL_VARCHAR.convertToDefaultType(session, st);
                int token = Tokens.get((String)st);
                int typeCode = IntervalType.getFieldNameTypeForToken(token);
                switch (typeCode) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double value = ((Number)data[0]).doubleValue();
                return IntervalSecondData.newInterval(value, typeCode);
            }
            case 127: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object st = Type.SQL_VARCHAR.trim(session, data[1], ' ', true, true);
                st = Type.SQL_VARCHAR.upper(session, st);
                st = Type.SQL_VARCHAR.convertToDefaultType(session, st);
                int token = Tokens.get((String)st);
                int typeCode = IntervalType.getFieldNameTypeForToken(token);
                switch (typeCode) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double value = ((Number)data[0]).doubleValue();
                return IntervalMonthData.newInterval(value, typeCode);
            }
            case 154: {
                IntervalSecondData zone = new IntervalSecondData(session.getZoneSeconds(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(zone);
            }
            case 162: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(session, data[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, false);
            }
            case 164: {
                TimestampData timestamp = DateTimeType.newSysDateTimestamp();
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestamp, Type.SQL_TIMESTAMP);
            }
            case 165: {
                return DateTimeType.newSystemTimestampWithZone();
            }
            case 176: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION.convertToType(session, data[0], Type.SQL_VARCHAR);
            }
            case 177: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, data[0], Type.SQL_VARCHAR);
            }
            case 180: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
            }
            case 185: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap map = this.charLookup;
                if (map == null) {
                    map = FunctionCustom.getTranslationMap((String)data[1], (String)data[2]);
                }
                return FunctionCustom.translateWithMap((String)data[0], map);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 196: {
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 197: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, parent);
                return;
            }
            case 90: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 92: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 110: 
            case 112: 
            case 113: 
            case 114: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 91: 
            case 94: 
            case 111: 
            case 152: 
            case 181: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 93: 
            case 153: 
            case 172: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 108: 
            case 118: 
            case 151: 
            case 182: 
            case 183: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 102: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 150: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[0].dataType.typeCode != this.nodes[1].dataType.typeCode) {
                        throw Error.error(5562);
                    }
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 97: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                int part = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 170;
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 170: {
                int part;
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode == 91) {
                    // empty if block
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.typeCode == 91) {
                    part = ((Number)this.nodes[0].valueData).intValue();
                    switch (part) {
                        case 137: 
                        case 179: 
                        case 264: 
                        case 871: 
                        case 872: 
                        case 873: 
                        case 981: 
                        case 982: 
                        case 984: 
                        case 985: 
                        case 986: {
                            this.dataType = Type.SQL_TIMESTAMP;
                        }
                    }
                }
                return;
            }
            case 98: {
                int part;
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(987), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    part = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(part);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 171;
            }
            case 171: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType.isCharacterType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                if (this.nodes[2].dataType.isCharacterType()) {
                    this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                block80 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                            this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 987: 
                            case 988: 
                            case 989: 
                            case 990: 
                            case 991: {
                                break block80;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (!this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    case 95: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 193: {
                if (this.extractSpec != 0) {
                    return;
                }
                int part = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(part);
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.funcType = 5;
                super.resolveTypes(session, parent);
                return;
            }
            case 194: {
                if (this.extractSpec != 0) {
                    return;
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                int part = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(part);
                if (this.extractSpec == 736) {
                    this.extractSpec = 734;
                } else if (this.extractSpec == 183) {
                    this.extractSpec = 773;
                }
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 95: 
            case 96: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 99: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 145: 
            case 186: {
                boolean single;
                boolean bl = single = this.nodes.length == 1 || this.nodes[1] == null;
                if (this.nodes[0].dataType == null) {
                    if (single) {
                        if (parent instanceof ExpressionLogical || parent instanceof ExpressionArithmetic) {
                            for (int i2 = 0; i2 < parent.nodes.length; ++i2) {
                                if (parent.nodes[i2].dataType == null) continue;
                                this.nodes[0].dataType = parent.nodes[i2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (!single && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 187: {
                Number offset = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    offset = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        offset = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (offset != null) {
                    int scale = offset;
                    if (scale < 0) {
                        scale = 0;
                    } else if (scale > this.dataType.scale) {
                        scale = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && scale != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)scale, scale);
                    }
                }
                return;
            }
            case 174: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[0].dataType.isDateTimeType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 178: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 175: 
            case 179: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String format = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 179) {
                        format = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(format, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 175 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 168: {
                Type argType = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (argType == null) {
                        argType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!argType.isCharacterType() && argType.typeCode != 93 && argType.typeCode != 95 && !argType.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (argType == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            argType = this.nodes[1].dataType;
                        } else {
                            argType = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (argType.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (argType.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME_MAX;
                        }
                    }
                    if (!(argType.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || argType.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 169: {
                Type argType = this.nodes[0].dataType;
                if (argType == null) {
                    argType = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (argType.typeCode != 93 && argType.typeCode != 95 && !argType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 128: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 163: {
                this.dataType = Type.SQL_BINARY_16;
                break;
            }
            case 190: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_UUID;
                    break;
                }
                throw Error.error(5563);
            }
            case 191: 
            case 192: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 131: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 76: 
            case 77: 
            case 86: 
            case 87: 
            case 88: 
            case 101: 
            case 120: 
            case 130: 
            case 146: 
            case 156: 
            case 157: 
            case 166: 
            case 167: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 78: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 158: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (this.funcType == 81) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = this.nodes[1].dataType;
                    }
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (i = 0; i < this.nodes.length; ++i) {
                        if (this.nodes[i].dataType != null) continue;
                        this.nodes[i].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 75: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 84: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision * 3L / 4L);
                break;
            }
            case 189: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 107: 
            case 188: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 173: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].dataType.precision == 0L) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                long precision = (this.nodes[0].dataType.precision + 2L) / 3L * 4L;
                this.dataType = CharacterType.getCharacterType(12, precision);
                break;
            }
            case 106: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 141: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(isChar = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = isChar ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 142: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 116: 
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 160: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 143: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String matchPattern = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(matchPattern);
                }
                switch (this.funcType) {
                    case 133: 
                    case 134: {
                        this.dataType = Type.SQL_INTEGER;
                        break block0;
                    }
                    case 135: 
                    case 136: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break block0;
                    }
                    case 137: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 138: 
                    case 139: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 140: {
                        this.dataType = Type.getDefaultArrayType(12);
                        break block0;
                    }
                }
                break;
            }
            case 89: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 117: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 121: 
            case 147: {
                Number value;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (value = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(value.longValue());
                break;
            }
            case 129: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType.collectionBaseType();
                }
                if (!this.nodes[1].dataType.collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_INTEGER;
                    }
                    if (!this.nodes[2].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 159: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(360), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(427), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 100: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 105: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 115: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP_NO_FRACTION);
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 195: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_DOUBLE);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 125: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 127: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 154: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 162: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 164: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 165: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 176: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 177: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 180: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String format = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(format, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 184: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 185: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[i].dataType.isCharacterType() && !this.nodes[i].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = FunctionCustom.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuilder sb = new StringBuilder("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 121: 
            case 147: {
                StringBuilder sb = new StringBuilder(this.name);
                sb.append("(").append(this.nodes[0].getSQL());
                sb.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(",").append(this.nodes[2].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 129: {
                StringBuilder sb = new StringBuilder(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(' ').append("IN");
                sb.append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(' ').append("FROM");
                    sb.append(' ').append(this.nodes[2].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 159: {
                StringBuilder sb = new StringBuilder(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 411) {
                    sb.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 467) {
                    sb.append(' ').append("NULLS").append(' ');
                    sb.append("LAST");
                }
                sb.append(')');
                return sb.toString();
            }
            case 164: 
            case 165: {
                return this.name;
            }
            case 72: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 128: 
            case 151: 
            case 152: 
            case 153: 
            case 163: 
            case 172: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return this.name + "(" + ")";
            }
            case 170: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPADD" + "(" + token + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 171: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPDIFF" + "(" + token + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 95: {
                return this.nodes[0].getSQL() + ' ' + '+' + this.nodes[1].getSQL();
            }
            case 96: {
                return this.nodes[0].getSQL() + ' ' + '-' + this.nodes[1].getSQL();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 150: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 162: 
            case 166: 
            case 167: 
            case 168: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                return this.getSQLSimple();
            }
            case 102: {
                StringBuilder sb = new StringBuilder(this.name).append('(');
                sb.append("ROW_COUNT");
                sb.append(')');
                return sb.toString();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuilder sb = new StringBuilder(this.name).append('(');
        boolean added = false;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            if (added) {
                sb.append(',');
            }
            sb.append(this.nodes[i].getSQL());
            added = true;
        }
        sb.append(')');
        return sb.toString();
    }

    private static char[] soundex(String s) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return b;
    }

    private static int getTSIToken(String string) {
        int part;
        if ("yy".equalsIgnoreCase(string) || "yyyy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            part = 991;
        } else if ("qq".equalsIgnoreCase(string) || "quarter".equalsIgnoreCase(string)) {
            part = 990;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            part = 989;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            part = 987;
        } else if ("dy".equalsIgnoreCase(string) || "dayofyear".equalsIgnoreCase(string)) {
            part = 737;
        } else if ("dw".equalsIgnoreCase(string) || "weekday".equalsIgnoreCase(string)) {
            part = 736;
        } else if ("wk".equalsIgnoreCase(string) || "week".equalsIgnoreCase(string)) {
            part = 988;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            part = 986;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            part = 985;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            part = 984;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            part = 982;
        } else if ("mcs".equalsIgnoreCase(string) || "microsecond".equalsIgnoreCase(string)) {
            part = 983;
        } else if ("ns".equalsIgnoreCase(string) || "nanosecond".equalsIgnoreCase(string)) {
            part = 981;
        } else if ("tz".equalsIgnoreCase(string) || "tzoffset".equalsIgnoreCase(string)) {
            part = 828;
        } else {
            throw Error.error(5566, string);
        }
        return part;
    }

    private static int getExtractTokenForTSIPart(int part) {
        switch (part) {
            case 981: {
                return 873;
            }
            case 982: {
                return 872;
            }
            case 984: {
                return 264;
            }
            case 985: {
                return 179;
            }
            case 986: {
                return 137;
            }
            case 987: {
                return 78;
            }
            case 736: {
                return 736;
            }
            case 737: {
                return 737;
            }
            case 828: {
                return 828;
            }
            case 988: {
                return 851;
            }
            case 989: {
                return 183;
            }
            case 990: {
                return 787;
            }
            case 991: {
                return 341;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    static int getSQLTypeForToken(String string) {
        int type = -1;
        if ("YEAR_MONTH".equalsIgnoreCase(string)) {
            type = 107;
        } else if ("DAY_HOUR".equalsIgnoreCase(string)) {
            type = 108;
        } else if ("DAY_MINUTE".equalsIgnoreCase(string)) {
            type = 109;
        } else if ("DAY_SECOND".equalsIgnoreCase(string)) {
            type = 110;
        } else if ("DAY_MICROSECOND".equalsIgnoreCase(string)) {
            type = 110;
        } else if ("HOUR_MINUTE".equalsIgnoreCase(string)) {
            type = 111;
        } else if ("HOUR_SECOND".equalsIgnoreCase(string)) {
            type = 112;
        } else if ("HOUR_MICROSECOND".equalsIgnoreCase(string)) {
            type = 112;
        } else if ("MINUTE_SECOND".equalsIgnoreCase(string)) {
            type = 113;
        } else if ("MINUTE_MICROSECOND".equalsIgnoreCase(string)) {
            type = 113;
        } else if ("SECOND_MICROSECOND".equalsIgnoreCase(string)) {
            type = 106;
        }
        return type;
    }

    private static IntKeyIntValueHashMap getTranslationMap(String source, String dest) {
        IntKeyIntValueHashMap map = new IntKeyIntValueHashMap();
        for (int i = 0; i < source.length(); ++i) {
            char character = source.charAt(i);
            if (i >= dest.length()) {
                map.put(character, -1);
                continue;
            }
            char value = dest.charAt(i);
            map.put(character, value);
        }
        return map;
    }

    private static String translateWithMap(String source, IntKeyIntValueHashMap map) {
        StringBuilder sb = new StringBuilder(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char character = source.charAt(i);
            int value = map.get((int)character, -2);
            if (value == -2) {
                sb.append(character);
                continue;
            }
            if (value == -1) continue;
            sb.append((char)value);
        }
        return sb.toString();
    }

    private static int regexpParams(String params) {
        int flags = 0;
        if (params == null) {
            return flags;
        }
        block6: for (int i = 0; i < params.length(); ++i) {
            switch (params.charAt(i)) {
                case 'i': {
                    flags |= 2;
                    continue block6;
                }
                case 'c': {
                    flags &= 0xFFFFFFFD;
                    flags |= 0x40;
                    continue block6;
                }
                case 'n': {
                    flags |= 0x20;
                    continue block6;
                }
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                default: {
                    throw Error.error(3472, params);
                }
            }
        }
        return flags;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(91);
        nonDeterministicFuncSet.add(93);
        nonDeterministicFuncSet.add(100);
        nonDeterministicFuncSet.add(108);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(114);
        nonDeterministicFuncSet.add(112);
        nonDeterministicFuncSet.add(113);
        nonDeterministicFuncSet.add(111);
        nonDeterministicFuncSet.add(151);
        nonDeterministicFuncSet.add(152);
        nonDeterministicFuncSet.add(153);
        nonDeterministicFuncSet.add(154);
        nonDeterministicFuncSet.add(163);
        nonDeterministicFuncSet.add(164);
        nonDeterministicFuncSet.add(165);
        nonDeterministicFuncSet.add(168);
        nonDeterministicFuncSet.add(172);
        nonDeterministicFuncSet.add(181);
        nonDeterministicFuncSet.add(182);
        nonDeterministicFuncSet.add(183);
        nonDeterministicFuncSet.add(184);
        nonDeterministicFuncSet.add(190);
        nonDeterministicFuncSet.add(191);
        nonDeterministicFuncSet.add(192);
        customRegularFuncMap.put(701, 71);
        customRegularFuncMap.put(702, 72);
        customRegularFuncMap.put(706, 73);
        customRegularFuncMap.put(703, 159);
        customRegularFuncMap.put(704, 74);
        customRegularFuncMap.put(705, 75);
        customRegularFuncMap.put(707, 76);
        customRegularFuncMap.put(708, 77);
        customRegularFuncMap.put(709, 78);
        customRegularFuncMap.put(711, 79);
        customRegularFuncMap.put(712, 80);
        customRegularFuncMap.put(713, 6);
        customRegularFuncMap.put(714, 81);
        customRegularFuncMap.put(715, 82);
        customRegularFuncMap.put(716, 83);
        customRegularFuncMap.put(36, 84);
        customRegularFuncMap.put(717, 84);
        customRegularFuncMap.put(718, 85);
        customRegularFuncMap.put(720, 86);
        customRegularFuncMap.put(721, 87);
        customRegularFuncMap.put(722, 88);
        customRegularFuncMap.put(723, 89);
        customRegularFuncMap.put(724, 43);
        customRegularFuncMap.put(725, 51);
        customRegularFuncMap.put(625, 90);
        customRegularFuncMap.put(727, 92);
        customRegularFuncMap.put(726, 91);
        customRegularFuncMap.put(728, 93);
        customRegularFuncMap.put(729, 94);
        customRegularFuncMap.put(730, 95);
        customRegularFuncMap.put(731, 96);
        customRegularFuncMap.put(732, 97);
        customRegularFuncMap.put(733, 98);
        customRegularFuncMap.put(861, 194);
        customRegularFuncMap.put(862, 193);
        customRegularFuncMap.put(78, 5);
        customRegularFuncMap.put(738, 5);
        customRegularFuncMap.put(739, 5);
        customRegularFuncMap.put(740, 5);
        customRegularFuncMap.put(741, 5);
        customRegularFuncMap.put(742, 99);
        customRegularFuncMap.put(743, 100);
        customRegularFuncMap.put(745, 101);
        customRegularFuncMap.put(413, 102);
        customRegularFuncMap.put(746, 103);
        customRegularFuncMap.put(863, 115);
        customRegularFuncMap.put(748, 104);
        customRegularFuncMap.put(749, 105);
        customRegularFuncMap.put(750, 106);
        customRegularFuncMap.put(751, 107);
        customRegularFuncMap.put(137, 5);
        customRegularFuncMap.put(138, 108);
        customRegularFuncMap.put(145, 32);
        customRegularFuncMap.put(755, 1);
        customRegularFuncMap.put(756, 110);
        customRegularFuncMap.put(757, 112);
        customRegularFuncMap.put(758, 113);
        customRegularFuncMap.put(759, 114);
        customRegularFuncMap.put(760, 111);
        customRegularFuncMap.put(762, 115);
        customRegularFuncMap.put(763, 26);
        customRegularFuncMap.put(163, 116);
        customRegularFuncMap.put(468, 7);
        customRegularFuncMap.put(765, 117);
        customRegularFuncMap.put(772, 118);
        customRegularFuncMap.put(766, 1);
        customRegularFuncMap.put(768, 14);
        customRegularFuncMap.put(769, 120);
        customRegularFuncMap.put(770, 121);
        customRegularFuncMap.put(771, 31);
        customRegularFuncMap.put(179, 5);
        customRegularFuncMap.put(183, 5);
        customRegularFuncMap.put(774, 5);
        customRegularFuncMap.put(775, 123);
        customRegularFuncMap.put(865, 195);
        customRegularFuncMap.put(864, 190);
        customRegularFuncMap.put(779, 125);
        customRegularFuncMap.put(782, 126);
        customRegularFuncMap.put(783, 127);
        customRegularFuncMap.put(784, 8);
        customRegularFuncMap.put(785, 128);
        customRegularFuncMap.put(786, 129);
        customRegularFuncMap.put(787, 5);
        customRegularFuncMap.put(788, 130);
        customRegularFuncMap.put(789, 131);
        customRegularFuncMap.put(790, 132);
        customRegularFuncMap.put(791, 133);
        customRegularFuncMap.put(792, 134);
        customRegularFuncMap.put(793, 135);
        customRegularFuncMap.put(794, 136);
        customRegularFuncMap.put(795, 137);
        customRegularFuncMap.put(796, 138);
        customRegularFuncMap.put(797, 139);
        customRegularFuncMap.put(798, 140);
        customRegularFuncMap.put(248, 141);
        customRegularFuncMap.put(799, 142);
        customRegularFuncMap.put(800, 143);
        customRegularFuncMap.put(254, 144);
        customRegularFuncMap.put(801, 145);
        customRegularFuncMap.put(802, 146);
        customRegularFuncMap.put(804, 147);
        customRegularFuncMap.put(803, 31);
        customRegularFuncMap.put(264, 5);
        customRegularFuncMap.put(805, 5);
        customRegularFuncMap.put(806, 150);
        customRegularFuncMap.put(807, 151);
        customRegularFuncMap.put(808, 152);
        customRegularFuncMap.put(809, 153);
        customRegularFuncMap.put(810, 154);
        customRegularFuncMap.put(811, 155);
        customRegularFuncMap.put(812, 156);
        customRegularFuncMap.put(813, 157);
        customRegularFuncMap.put(814, 159);
        customRegularFuncMap.put(815, 158);
        customRegularFuncMap.put(557, 160);
        customRegularFuncMap.put(818, 23);
        customRegularFuncMap.put(820, 162);
        customRegularFuncMap.put(821, 164);
        customRegularFuncMap.put(822, 165);
        customRegularFuncMap.put(823, 166);
        customRegularFuncMap.put(824, 167);
        customRegularFuncMap.put(298, 168);
        customRegularFuncMap.put(825, 169);
        customRegularFuncMap.put(826, 170);
        customRegularFuncMap.put(827, 171);
        customRegularFuncMap.put(828, 172);
        customRegularFuncMap.put(829, 173);
        customRegularFuncMap.put(830, 174);
        customRegularFuncMap.put(831, 175);
        customRegularFuncMap.put(832, 176);
        customRegularFuncMap.put(833, 177);
        customRegularFuncMap.put(834, 178);
        customRegularFuncMap.put(835, 179);
        customRegularFuncMap.put(836, 180);
        customRegularFuncMap.put(838, 181);
        customRegularFuncMap.put(839, 182);
        customRegularFuncMap.put(840, 183);
        customRegularFuncMap.put(841, 184);
        customRegularFuncMap.put(303, 185);
        customRegularFuncMap.put(842, 186);
        customRegularFuncMap.put(311, 187);
        customRegularFuncMap.put(844, 27);
        customRegularFuncMap.put(847, 192);
        customRegularFuncMap.put(848, 191);
        customRegularFuncMap.put(866, 163);
        customRegularFuncMap.put(845, 188);
        customRegularFuncMap.put(846, 189);
        customRegularFuncMap.put(849, 190);
        customRegularFuncMap.put(850, 5);
        customRegularFuncMap.put(341, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(837, 43);
        customValueFuncMap.put(781, 52);
    }
}

