/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueUser;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.List;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;
    Expression condition = Expression.EXPR_TRUE;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(routineSchema.isAggregate() ? 100 : 27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, List unresolvedSet, boolean acceptsSequences) {
        List conditionSet = this.condition.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (this.isSelfAggregate()) {
            if (unresolvedSet == null) {
                unresolvedSet = new ArrayListIdentity<FunctionSQLInvoked>();
            }
            unresolvedSet.add(this);
            return unresolvedSet;
        }
        return super.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, unresolvedSet, acceptsSequences);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        Type[] types = new Type[this.nodes.length];
        for (i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            e.resolveTypes(session, this);
            types[i] = e.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(types);
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].dataType != null) continue;
            this.nodes[i].dataType = this.routine.getParameterTypes()[i];
        }
        this.dataType = this.routine.getReturnType();
        this.condition.resolveTypes(session, null);
    }

    private Object getValueInternal(Session session, Object[] aggregateData) {
        boolean isValue = false;
        int extraArg = this.routine.javaMethodWithConnection ? 1 : 0;
        Object[] data = ValuePool.emptyObjectArray;
        boolean push = true;
        if (extraArg + this.nodes.length > 0) {
            if (this.opType == 100) {
                data = new Object[this.routine.getParameterCount()];
                for (int i = 0; i < aggregateData.length; ++i) {
                    data[i + 1] = aggregateData[i];
                }
            } else {
                data = new Object[this.nodes.length + extraArg];
            }
            if (!this.routine.isPSM()) {
                JDBCConnection connection = session.getInternalConnection();
                if (extraArg > 0) {
                    data[0] = connection;
                }
            }
        }
        Type[] dataTypes = this.routine.getParameterTypes();
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            Object value = e.getValue(session, dataTypes[i]);
            if (value == null) {
                if (this.routine.isNullInputOutput()) {
                    return null;
                }
                if (!this.routine.getParameter(i).isNullable()) {
                    return Result.newErrorResult(Error.error(4811));
                }
            }
            if (this.routine.isPSM()) {
                data[i] = value;
                continue;
            }
            data[i + extraArg] = e.dataType.convertSQLToJava(session, value);
        }
        Result result = this.routine.invoke(session, data, aggregateData, push);
        session.releaseInternalConnection();
        if (result.isError()) {
            throw result.getException();
        }
        if (isValue) {
            return result.valueData;
        }
        return result;
    }

    @Override
    public Object getValue(Session session) {
        Object returnValue = this.getValueInternal(session, null);
        if (returnValue instanceof Result) {
            Result result = (Result)returnValue;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                returnValue = result.getValueObject();
            } else if (result.isData()) {
                returnValue = result;
            } else {
                throw Error.error(4605, this.routine.getName().name);
            }
        }
        return returnValue;
    }

    @Override
    public Result getResult(Session session) {
        Object value = this.getValueInternal(session, null);
        if (value instanceof Result) {
            return (Result)value;
        }
        return Result.newPSMResult(value);
    }

    @Override
    void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.routineSchema.getName().getSchemaQualifiedStatementName());
        sb.append('(');
        int nodeCount = this.nodes.length;
        if (this.opType == 100) {
            nodeCount = 1;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.nodes[i].getSQL());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String describe(Session session, int blanks) {
        return super.describe(session, blanks);
    }

    @Override
    public boolean isSelfAggregate() {
        return this.routineSchema.isAggregate();
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }

    @Override
    boolean equals(Expression other) {
        if (other instanceof FunctionSQLInvoked) {
            FunctionSQLInvoked o = (FunctionSQLInvoked)other;
            return super.equals(other) && this.opType == other.opType && this.routineSchema == o.routineSchema && this.routine == o.routine && this.condition.equals(o.condition);
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        if (currValue == null) {
            currValue = new SetFunctionValueUser();
        }
        Object[] array = ((SetFunctionValueUser)currValue).list;
        array[0] = Boolean.FALSE;
        this.getValueInternal(session, array);
        return currValue;
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction currValue) {
        if (currValue == null) {
            currValue = new SetFunctionValueUser();
        }
        Object[] array = ((SetFunctionValueUser)currValue).list;
        array[0] = Boolean.TRUE;
        Result result = (Result)this.getValueInternal(session, array);
        if (result.isError()) {
            throw result.getException();
        }
        return result.getValueObject();
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && !this.condition.isTrue();
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }
}

