/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Arrays;
import org.hsqldb.Expression;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;

public class GroupSet {
    Expression[] groupExpressions;
    HsqlArrayList sets = new HsqlArrayList();
    int nullSets = 0;
    boolean isDistinctGroups;

    public GroupSet(Expression[] expressions, boolean isDistinct) {
        this.groupExpressions = expressions;
        this.isDistinctGroups = isDistinct;
    }

    public Iterator getIterator() {
        return this.sets.iterator();
    }

    public int isGrouped(List current, Expression e) {
        int count = 0;
        if (current == null) {
            return (1 << e.nodes.length) - 1;
        }
        for (int i = 0; i < e.nodes.length; ++i) {
            count <<= 1;
            int colIndex = e.nodes[i].columnIndex;
            if (current.contains(colIndex)) continue;
            ++count;
        }
        return count;
    }

    public void process() {
        HsqlArrayList tmp = GroupSet.evaluate(this.groupExpressions);
        Iterator it = tmp.iterator();
        block0: while (it.hasNext()) {
            OrderedHashSet set = (OrderedHashSet)it.next();
            if (set.isEmpty()) {
                if (this.isDistinctGroups) {
                    this.nullSets = 1;
                    continue;
                }
                ++this.nullSets;
                continue;
            }
            if (this.isDistinctGroups) {
                OrderedHashSet newSet = new OrderedHashSet();
                newSet.addAll(set);
                for (int i = 0; i < this.sets.size(); ++i) {
                    List current = (List)this.sets.get(i);
                    if (current.size() == newSet.size() && newSet.containsAll(current)) continue block0;
                }
                set = newSet;
            }
            this.sets.add(set);
        }
    }

    private static int getColumnIndex(Expression e) {
        return e.resultTableColumnIndex;
    }

    private static HsqlArrayList evaluate(Expression e) {
        if (e.opType == 0) {
            HsqlArrayList sets = new HsqlArrayList();
            sets.add(new HsqlArrayList());
            return sets;
        }
        Expression[] exprs = e.nodes;
        if (exprs.length == 0 || e.opType != 26 && e.opType != 25) {
            exprs = new Expression[]{e};
        }
        switch (e.groupingType) {
            case 61: {
                return GroupSet.powerSet(exprs);
            }
            case 256: {
                return GroupSet.rollUp(exprs);
            }
            case 553: {
                return GroupSet.grouping(exprs);
            }
        }
        if (e.nodes.length == 0) {
            HsqlArrayList sets = new HsqlArrayList();
            HsqlArrayList<Integer> inner = new HsqlArrayList<Integer>();
            inner.add(GroupSet.getColumnIndex(e));
            sets.add(inner);
            return sets;
        }
        return GroupSet.evaluate(e.nodes);
    }

    private static HsqlArrayList evaluate(Expression[] e) {
        HsqlArrayList sets = new HsqlArrayList();
        if (e.length == 0) {
            sets.add(new HsqlArrayList());
            return sets;
        }
        if (e[0] == null) {
            return sets;
        }
        HsqlArrayList first = GroupSet.evaluate(e[0]);
        HsqlArrayList results = GroupSet.evaluate(Arrays.copyOfRange(e, 1, e.length));
        Iterator it = results.iterator();
        while (it.hasNext()) {
            HsqlArrayList current = (HsqlArrayList)it.next();
            Iterator itFirst = first.iterator();
            while (itFirst.hasNext()) {
                HsqlArrayList newSet = new HsqlArrayList();
                HsqlArrayList next = (HsqlArrayList)itFirst.next();
                newSet.addAll((Collection)next);
                newSet.addAll((Collection)current);
                sets.add(newSet);
            }
        }
        return sets;
    }

    private static HsqlArrayList powerSet(Expression[] expressions) {
        HsqlArrayList first;
        HsqlArrayList sets = new HsqlArrayList();
        if (expressions.length == 0) {
            sets.add(new HsqlArrayList());
            return sets;
        }
        if (expressions[0].nodes.length != 0 && (expressions[0].opType == 26 || expressions[0].opType == 25)) {
            first = GroupSet.evaluate(expressions[0]);
        } else {
            first = new HsqlArrayList();
            HsqlArrayList<Integer> tmp = new HsqlArrayList<Integer>();
            tmp.add(GroupSet.getColumnIndex(expressions[0]));
            first.add(tmp);
        }
        HsqlArrayList results = GroupSet.powerSet(Arrays.copyOfRange(expressions, 1, expressions.length));
        Iterator itFirst = first.iterator();
        while (itFirst.hasNext()) {
            HsqlArrayList current = (HsqlArrayList)itFirst.next();
            Iterator it = results.iterator();
            while (it.hasNext()) {
                HsqlArrayList newSet = new HsqlArrayList();
                HsqlArrayList next = (HsqlArrayList)it.next();
                newSet.addAll((Collection)current);
                newSet.addAll((Collection)next);
                if (newSet.isEmpty()) continue;
                sets.add(newSet);
            }
        }
        sets.addAll((Collection)results);
        return sets;
    }

    private static HsqlArrayList rollUp(Expression[] expressions) {
        HsqlArrayList first;
        HsqlArrayList sets = new HsqlArrayList();
        if (expressions.length == 0) {
            sets.add(new HsqlArrayList());
            return sets;
        }
        if (expressions[0].nodes.length != 0 && (expressions[0].opType == 26 || expressions[0].opType == 25)) {
            first = GroupSet.evaluate(expressions[0]);
        } else {
            first = new HsqlArrayList();
            HsqlArrayList<Integer> tmp = new HsqlArrayList<Integer>();
            tmp.add(GroupSet.getColumnIndex(expressions[0]));
            first.add(tmp);
        }
        HsqlArrayList results = GroupSet.rollUp(Arrays.copyOfRange(expressions, 1, expressions.length));
        Iterator it = results.iterator();
        while (it.hasNext()) {
            HsqlArrayList current = (HsqlArrayList)it.next();
            Iterator itFirst = first.iterator();
            while (itFirst.hasNext()) {
                HsqlArrayList next = (HsqlArrayList)itFirst.next();
                HsqlArrayList newSet = new HsqlArrayList();
                newSet.addAll((Collection)next);
                newSet.addAll((Collection)current);
                sets.add(newSet);
            }
        }
        sets.add(new HsqlArrayList());
        return sets;
    }

    private static HsqlArrayList grouping(Expression[] expressions) {
        HsqlArrayList sets = new HsqlArrayList();
        if (expressions.length == 0) {
            return sets;
        }
        if (expressions[0].nodes.length != 0 && (expressions[0].opType == 26 || expressions[0].opType == 25)) {
            sets = GroupSet.evaluate(expressions[0]);
        } else {
            sets = new HsqlArrayList();
            HsqlArrayList<Integer> tmp = new HsqlArrayList<Integer>();
            if (expressions[0].opType != 0) {
                tmp.add(GroupSet.getColumnIndex(expressions[0]));
            }
            sets.add(tmp);
        }
        HsqlArrayList results = GroupSet.grouping(Arrays.copyOfRange(expressions, 1, expressions.length));
        sets.addAll((Collection)results);
        return sets;
    }
}

