/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.TimestampData;

public class HsqlDateTime {
    public static final Locale defaultLocale = Locale.UK;
    private static final Calendar tempCalDefault = new GregorianCalendar();
    private static final Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd", defaultLocale);
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", defaultLocale);
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SimpleDateFormat sdftsSys = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", defaultLocale);
    private static final Date sysDate = new Date();
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date d = sdfd.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long seconds) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(seconds * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date d = sdfts.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long seconds, int nanos, int scale) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(seconds * 1000L);
            String ts = sdfts.format(sysDate);
            if (scale > 0) {
                ts = ts + '.' + StringUtil.toZeroPaddedString(nanos, 9, scale);
            }
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long millis) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(millis);
            return sdfts.format(sysDate);
        }
    }

    private static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long millis) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.clear();
                tempCalGMT.setTimeInMillis(millis);
                calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
                return calendar.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar sourceCalendar, Calendar targetClendar, long millis) {
        Calendar calendar = targetClendar;
        synchronized (calendar) {
            Calendar calendar2 = sourceCalendar;
            synchronized (calendar2) {
                targetClendar.clear();
                sourceCalendar.setTimeInMillis(millis);
                targetClendar.set(sourceCalendar.get(1), sourceCalendar.get(2), sourceCalendar.get(5), sourceCalendar.get(11), sourceCalendar.get(12), sourceCalendar.get(13));
                return targetClendar.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertSecondsFromCalendar(Calendar sourceCalendar, Calendar targetClendar, long seconds) {
        Calendar calendar = targetClendar;
        synchronized (calendar) {
            Calendar calendar2 = sourceCalendar;
            synchronized (calendar2) {
                targetClendar.clear();
                sourceCalendar.setTimeInMillis(seconds * 1000L);
                targetClendar.set(sourceCalendar.get(1), sourceCalendar.get(2), sourceCalendar.get(5), sourceCalendar.get(11), sourceCalendar.get(12), sourceCalendar.get(13));
                return targetClendar.getTimeInMillis() / 1000L;
            }
        }
    }

    public static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    public static long convertToNormalisedTime(long t) {
        return HsqlDateTime.convertToNormalisedTime(tempCalGMT, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(Calendar cal, long t) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToDate(cal);
            long t1 = cal.getTimeInMillis();
            return t - t1;
        }
    }

    public static long getNormalisedTime(long t) {
        return HsqlDateTime.getNormalisedTime(tempCalGMT, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long t) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, t);
            HsqlDateTime.resetToTime(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static long getNormalisedDate(long d) {
        return HsqlDateTime.getNormalisedDate(tempCalGMT, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long t) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, t);
            HsqlDateTime.resetToDate(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static int getZoneSeconds() {
        return HsqlDateTime.getZoneSeconds(tempCalDefault);
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar calendar, long millis) {
        return calendar.getTimeZone().getOffset(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(Calendar calendar, long m, int part) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(m);
            switch (part) {
                case 136: {
                    int dayWeek = calendar.get(7);
                    if (dayWeek == 1) {
                        dayWeek = 8;
                    }
                    calendar.add(6, 2 - dayWeek);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                case 126: {
                    int dayWeek = calendar.get(7);
                    calendar.add(6, 1 - dayWeek);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(calendar, part);
                }
            }
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(Calendar calendar, long m, int part) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(m);
            switch (part) {
                case 101: {
                    if (calendar.get(2) <= 6) break;
                    calendar.add(1, 1);
                    break;
                }
                case 102: {
                    if (calendar.get(5) <= 15) break;
                    calendar.add(2, 1);
                    break;
                }
                case 103: {
                    if (calendar.get(11) <= 11) break;
                    calendar.add(5, 1);
                    break;
                }
                case 104: {
                    if (calendar.get(12) <= 29) break;
                    calendar.add(11, 1);
                    break;
                }
                case 105: {
                    if (calendar.get(13) <= 29) break;
                    calendar.add(12, 1);
                    break;
                }
                case 106: {
                    if (calendar.get(14) <= 499) break;
                    calendar.add(13, 1);
                    break;
                }
                case 126: {
                    int dayYear = calendar.get(6);
                    int year = calendar.get(1);
                    int week = calendar.get(3);
                    int day = calendar.get(7);
                    calendar.clear();
                    calendar.set(1, year);
                    if (day > 3) {
                        ++week;
                    }
                    if (week == 1 && (dayYear > 356 || dayYear < 7)) {
                        calendar.set(6, dayYear);
                        while (true) {
                            if (calendar.get(7) == 1) {
                                return calendar.getTimeInMillis();
                            }
                            calendar.add(6, -1);
                        }
                    }
                    calendar.set(3, week);
                    return calendar.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(calendar, part);
            return calendar.getTimeInMillis();
        }
    }

    public static void zeroFromPart(Calendar cal, int part) {
        switch (part) {
            case 101: {
                cal.set(2, 0);
            }
            case 102: {
                cal.set(5, 1);
            }
            case 103: {
                cal.set(11, 0);
            }
            case 104: {
                cal.set(12, 0);
            }
            case 105: {
                cal.set(13, 0);
            }
            case 106: {
                cal.set(14, 0);
            }
        }
    }

    public static TimestampData toDate(String string, String pattern, SimpleDateFormat format, boolean fraction) {
        long millis;
        int nanos = 0;
        String javaPattern = HsqlDateTime.toJavaDatePattern(pattern);
        String tempPattern = null;
        int matchIndex = javaPattern.indexOf("*IY");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("*WW");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("*W");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("SSS");
        if (matchIndex >= 0) {
            tempPattern = javaPattern;
            javaPattern = javaPattern.substring(0, matchIndex) + javaPattern.substring(matchIndex + 3);
        }
        try {
            format.applyPattern(javaPattern);
            millis = format.parse(string).getTime();
        }
        catch (Exception e) {
            throw Error.error(e, 3407, e.toString());
        }
        if (matchIndex >= 0 && fraction) {
            javaPattern = tempPattern;
            try {
                format.applyPattern(javaPattern);
                long tempMillis = format.parse(string).getTime();
                int factor = 1;
                nanos = (int)(tempMillis -= millis);
                while (tempMillis > 1000L) {
                    tempMillis /= 10L;
                    factor *= 10;
                }
                nanos *= 1000000 / factor;
            }
            catch (Exception e) {
                throw Error.error(e, 3407, e.toString());
            }
        }
        return new TimestampData(millis / 1000L, nanos, 0);
    }

    public static String toFormattedDate(Date date, String pattern, SimpleDateFormat format) {
        int matchLength;
        Calendar cal;
        String javaPattern = HsqlDateTime.toJavaDatePattern(pattern);
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception e) {
            throw Error.error(3472, e);
        }
        String result = format.format(date);
        int matchIndex = result.indexOf("*IY");
        if (matchIndex >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int temp = result.indexOf("*IYYY");
            if (temp >= 0) {
                matchLength = 5;
                matchIndex = temp;
            }
            int year = cal.get(1);
            int weekOfYear = cal.get(3);
            if (weekOfYear == 1 && cal.get(6) > 360) {
                ++year;
            } else if (weekOfYear > 51 && cal.get(6) < 4) {
                --year;
            }
            String yearString = String.valueOf(year);
            if (matchLength == 3) {
                yearString = yearString.substring(yearString.length() - 2);
            }
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, yearString);
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*WW")) >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int dayOfYear = cal.get(6);
            int weekOfYear = (dayOfYear - 1) / 7 + 1;
            String week = String.valueOf(weekOfYear);
            if (week.length() == 1) {
                week = "0" + week;
            }
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, week);
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*IW")) >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int weekOfYear = cal.get(3);
            String week = String.valueOf(weekOfYear);
            if (week.length() == 1) {
                week = "0" + week;
            }
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, week);
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*W")) >= 0) {
            cal = format.getCalendar();
            matchLength = 2;
            int dayOfMonth = cal.get(5);
            int weekOfMonth = (dayOfMonth - 1) / 7 + 1;
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, String.valueOf(weekOfMonth));
            result = sb.toString();
        }
        return result;
    }

    public static String toJavaDatePattern(String format) {
        int len = format.length();
        StringBuilder sb = new StringBuilder(len);
        Tokenizer tokenizer = new Tokenizer();
        int limitQuotedToken = -1;
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(ch)) {
                    ch = '\'';
                } else if (ch == '\'') {
                    sb.append(ch);
                }
                sb.append(ch);
                continue;
            }
            if (tokenizer.next(ch, i)) continue;
            if (tokenizer.consumed) {
                int index = tokenizer.getLastMatch();
                String s = javaDateTokens[index];
                if (s.startsWith("'") && s.endsWith("'")) {
                    if (limitQuotedToken == sb.length()) {
                        sb.setLength(sb.length() - 1);
                        s = s.substring(1);
                    }
                    limitQuotedToken = sb.length() + s.length();
                }
                sb.append(s);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(ch)) {
                ch = '\'';
                sb.append(ch);
            } else if (tokenizer.isLiteral(ch)) {
                sb.append(ch);
            } else if (ch != '\uffff') {
                throw Error.error(3407, format.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String javaPattern = sb.toString();
        return javaPattern;
    }

    public static int toStandardIntervalPart(String format) {
        int len = format.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.next(ch, i)) continue;
            int index = tokenizer.getLastMatch();
            if (index >= 0) {
                return sqlIntervalCodes[index];
            }
            return -1;
        }
        return -1;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static {
        TimeZone.getDefault();
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'W'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "'*IW'", "dd", "D", "'*W'", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "SSS"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, -1, -1, 126, 136, 103, 103, -1, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = HsqlDateTime.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char ch) {
            if (this.quoteChar == ch) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char ch) {
            return ArrayUtil.isInSortedArray(ch, this.literalChars);
        }

        private boolean isZeroBit(int bit) {
            return (this.state & 1L << bit) == 0L;
        }

        private void setBit(int bit) {
            this.state |= 1L << bit;
        }

        public boolean next(char ch, int position) {
            int index = ++this.offset;
            int len = this.offset + 1;
            int left = 0;
            this.matched = false;
            int i = this.tokens.length;
            while (--i >= 0) {
                if (!this.isZeroBit(i)) continue;
                if (this.tokens[i][index] == Character.toUpperCase(ch)) {
                    if (this.tokens[i].length == len) {
                        this.setBit(i);
                        this.lastMatched = i;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = position;
                        continue;
                    }
                    ++left;
                    continue;
                }
                this.setBit(i);
            }
            return left > 0;
        }
    }

    public static class SystemTimeString {
        private Date date = new Date();
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public SystemTimeString() {
            this.dateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
            this.dateFormat.setLenient(false);
        }

        public synchronized String getTimestampString() {
            this.date.setTime(System.currentTimeMillis());
            return this.dateFormat.format(this.date);
        }
    }
}

