/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public final class HsqlNameManager {
    private static final HsqlNameManager staticManager = new HsqlNameManager();
    private static final HsqlName[] autoColumnNames;
    private static final String[] autoNoNameColumnNames;
    private AtomicLong serialNumber = new AtomicLong(1L);
    private AtomicLong sysNumber = new AtomicLong(10000L);
    private HsqlName catalogName;
    private boolean sqlRegularNames;
    HsqlName subqueryTableName;

    public HsqlNameManager() {
        this.sqlRegularNames = true;
    }

    public HsqlNameManager(Database database) {
        this.catalogName = new HsqlName(this, "PUBLIC", 1, false);
        this.sqlRegularNames = database.sqlRegularNames;
        this.subqueryTableName = new HsqlName(this, "SYSTEM_SUBQUERY", false, 3);
        this.subqueryTableName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
    }

    public HsqlName getCatalogName() {
        return this.catalogName;
    }

    public void setSqlRegularNames(boolean value) {
        this.sqlRegularNames = value;
    }

    public static HsqlName newSystemObjectName(String name, int type) {
        return new HsqlName(staticManager, name, type, false);
    }

    public static HsqlName newInfoSchemaColumnName(String name, HsqlName table) {
        HsqlName hsqlName = new HsqlName(staticManager, name, false, 9);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        hsqlName.parent = table;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaTableName(String name) {
        HsqlName hsqlName = new HsqlName(staticManager, name, 3, false);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaObjectName(String name, boolean isQuoted, int type) {
        HsqlName hsqlName = new HsqlName(staticManager, name, type, isQuoted);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName schema, String name, int type) {
        HsqlName hsqlName = new HsqlName(this, name, type, false);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public HsqlName newHsqlName(String name, boolean isquoted, int type) {
        return new HsqlName(this, name, isquoted, type);
    }

    public HsqlName newHsqlName(HsqlName schema, String name, boolean isquoted, int type) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, type);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName schema, String name, boolean isquoted, int type, HsqlName parent) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, type);
        hsqlName.schema = schema;
        hsqlName.parent = parent;
        return hsqlName;
    }

    public HsqlName newColumnSchemaHsqlName(HsqlName table, SimpleName name) {
        return this.newColumnHsqlName(table, name.name, name.isNameQuoted);
    }

    public HsqlName newColumnHsqlName(HsqlName table, String name, boolean isquoted) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, 9);
        hsqlName.schema = table.schema;
        hsqlName.parent = table;
        return hsqlName;
    }

    public HsqlName getSubqueryTableName() {
        return this.subqueryTableName;
    }

    public HsqlName newAutoName(String prefix, HsqlName schema, HsqlName parent, int type) {
        return this.newAutoName(prefix, null, schema, parent, type);
    }

    public HsqlName newConstraintIndexName(HsqlName tableName, HsqlName constName, boolean useConstraint) {
        if (constName == null) {
            useConstraint = false;
        }
        if (useConstraint) {
            HsqlName name = new HsqlName(this, constName.name, 20, false);
            name.schema = tableName.schema;
            name.parent = tableName;
            return name;
        }
        String constNameString = constName == null ? null : constName.name;
        return this.newAutoName("IDX", constNameString, tableName.schema, tableName, 20);
    }

    public HsqlName newSpecificRoutineName(HsqlName name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.name).append('_').append(this.sysNumber.incrementAndGet());
        HsqlName hsqlName = new HsqlName(this, sb.toString(), 24, name.isNameQuoted);
        hsqlName.parent = name;
        hsqlName.schema = name.schema;
        return hsqlName;
    }

    public static HsqlName getAutoColumnName(int i) {
        if (i < autoColumnNames.length) {
            return autoColumnNames[i];
        }
        return new HsqlName(staticManager, "C" + (i + 1), 9, false);
    }

    public static String getAutoNoNameColumnString(int i) {
        if (i < autoColumnNames.length) {
            return autoNoNameColumnNames[i];
        }
        return String.valueOf(i);
    }

    public static String getAutoSavepointNameString(long i, int j) {
        StringBuilder sb = new StringBuilder("S");
        sb.append(i).append('_').append(j);
        return sb.toString();
    }

    public HsqlName newAutoName(String prefix, String namepart, HsqlName schema, HsqlName parent, int type) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            if (!prefix.isEmpty()) {
                sb.append("SYS_");
                sb.append(prefix);
                sb.append('_');
                if (namepart != null) {
                    sb.append(namepart);
                    sb.append('_');
                }
                sb.append(this.sysNumber.incrementAndGet());
            }
        } else {
            sb.append(namepart);
        }
        HsqlName name = new HsqlName(this, sb.toString(), type, false);
        name.schema = schema;
        name.parent = parent;
        return name;
    }

    public static SimpleName getSimpleName(String name, boolean isNameQuoted) {
        return new SimpleName(name, isNameQuoted);
    }

    static {
        HsqlNameManager.staticManager.serialNumber.set(Long.MIN_VALUE);
        autoColumnNames = new HsqlName[32];
        autoNoNameColumnNames = new String[32];
        for (int i = 0; i < autoColumnNames.length; ++i) {
            HsqlNameManager.autoColumnNames[i] = new HsqlName(staticManager, "C" + (i + 1), 0, false);
            HsqlNameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
    }

    public static final class HsqlName
    extends SimpleName {
        static HsqlName[] emptyArray = new HsqlName[0];
        HsqlNameManager manager;
        public String statementName;
        public String comment;
        public HsqlName schema;
        public HsqlName parent;
        public Grantee owner;
        public final int type;
        private final long hashCode;
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_"};

        private HsqlName(HsqlNameManager man, int type) {
            this.manager = man;
            this.type = type;
            this.hashCode = this.manager.serialNumber.getAndIncrement();
        }

        private HsqlName(HsqlNameManager man, String name, boolean isquoted, int type) {
            this(man, type);
            this.rename(name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String name, int type, boolean isQuoted) {
            this(man, type);
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isQuoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getSchemaQualifiedStatementName() {
            switch (this.type) {
                case 22: 
                case 23: {
                    return this.statementName;
                }
                case 9: 
                case 30: {
                    if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                        return this.statementName;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (this.schema != null) {
                        sb.append(this.schema.getStatementName());
                        sb.append('.');
                    }
                    sb.append(this.parent.getStatementName());
                    sb.append('.');
                    sb.append(this.statementName);
                    return sb.toString();
                }
            }
            if (this.schema == null || "SYSTEM_SCHEMA".equals(this.schema.name)) {
                return this.statementName;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.schema.getStatementName());
            sb.append('.');
            sb.append(this.statementName);
            return sb.toString();
        }

        String getCommentSQL(String typeName) {
            if (this.comment == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("COMMENT").append(' ').append("ON");
            sb.append(' ').append(typeName).append(' ');
            sb.append(this.getSchemaQualifiedStatementName());
            sb.append(' ').append("IS").append(' ');
            sb.append(StringConverter.toQuotedString(this.comment, '\'', true));
            return sb.toString();
        }

        public void rename(HsqlName name) {
            this.rename(name.name, name.isNameQuoted);
        }

        public void rename(String name, boolean isquoted) {
            if (this.manager.sqlRegularNames && name.length() > 128) {
                throw Error.error(5501, name);
            }
            this.statementName = this.name = name;
            this.isNameQuoted = isquoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
            if (name.startsWith("SYS_")) {
                int length = name.lastIndexOf(95) + 1;
                try {
                    int temp = Integer.parseInt(name.substring(length));
                    if ((long)temp > this.manager.sysNumber.get()) {
                        this.manager.sysNumber.set(temp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) {
            StringBuilder sbname = new StringBuilder(prefix);
            sbname.append('_');
            sbname.append(name);
            this.rename(sbname.toString(), isquoted);
        }

        public void setSchemaIfNull(HsqlName schema) {
            if (this.schema == null) {
                this.schema = schema;
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof HsqlName) {
                return this.hashCode == ((HsqlName)other).hashCode;
            }
            if (other instanceof SimpleName) {
                return super.equals(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (int)(this.hashCode ^ this.hashCode >>> 32);
        }

        static int sysPrefixLength(String name) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!name.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String name) {
            return HsqlName.sysPrefixLength(name) > 0;
        }

        boolean isReservedName() {
            return HsqlName.isReservedName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        static boolean isRegularIdentifier(String name) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(name);
        }
    }

    public static class SimpleName {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        private SimpleName(String name, boolean isNameQuoted) {
            this.name = name;
            this.isNameQuoted = isNameQuoted;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleName) {
                return ((SimpleName)other).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, '\"', true) : this.name;
        }

        public String getNameString() {
            return this.name;
        }
    }
}

