/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    protected Scanner scanner;
    protected Token token;
    protected int partPosition;
    protected HsqlException lastError;
    protected HsqlNameManager.HsqlName lastSynonym;
    protected boolean isSchemaDefinition;
    protected boolean isViewDefinition;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner scanner) {
        this.scanner = scanner;
        this.token = scanner.token;
        this.recordedStatement = new HsqlArrayList(256);
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getPartPosition() {
        return this.partPosition;
    }

    public void setPartPosition(int parsePosition) {
        this.partPosition = parsePosition;
    }

    void reset(Session session, String sql) {
        this.scanner.reset(session, sql);
        this.partPosition = 0;
        this.lastError = null;
        this.lastSynonym = null;
        this.isSchemaDefinition = false;
        this.isViewDefinition = false;
        this.isRecording = false;
        this.recordedStatement.clear();
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int position) {
        if (position == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(position);
        if (this.isRecording) {
            int i;
            for (i = this.recordedStatement.size() - 1; i >= 0; --i) {
                Token token = (Token)this.recordedStatement.get(i);
                if (token.position < position) break;
            }
            this.recordedStatement.setSize(i + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.partPosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int position) {
        return this.scanner.getPart(position, this.scanner.getTokenPosition());
    }

    String getStatement(int startPosition, short[] startTokens) {
        while (this.token.tokenType != 943 && this.token.tokenType != 1014 && ArrayUtil.find(startTokens, this.token.tokenType) == -1) {
            this.read();
        }
        String sql = this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
        return sql;
    }

    String getStatementForRoutine(int startPosition, short[] startTokens) {
        int tokenIndex = 0;
        int semiIndex = -1;
        int semiPosition = -1;
        while (true) {
            if (this.token.tokenType == 943) {
                semiPosition = this.scanner.getTokenPosition();
                semiIndex = tokenIndex;
            } else {
                if (this.token.tokenType == 1014) {
                    if (semiIndex <= 0 || semiIndex != tokenIndex - 1) break;
                    this.rewind(semiPosition);
                    break;
                }
                if (ArrayUtil.find(startTokens, this.token.tokenType) != -1) break;
            }
            this.read();
            ++tokenIndex;
        }
        String sql = this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
        return sql;
    }

    Recorder startRecording() {
        if (!this.isRecording) {
            this.recordedStatement.add(this.token.duplicate());
            this.isRecording = true;
        }
        return new Recorder();
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.token.duplicate();
    }

    void replaceToken(String tokenString) {
        this.scanner.replaceToken(tokenString);
        if (this.isRecording) {
            Token dup = this.token.duplicate();
            dup.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(dup);
        }
    }

    void replaceToken(Token token1, Token token2) {
        String tokenString = token1.tokenString;
        if (token2 != null) {
            tokenString = tokenString + token2.tokenString;
        }
        tokenString = tokenString + " ";
        this.scanner.replaceToken(tokenString);
        if (this.isRecording) {
            token1.position = this.scanner.getTokenPosition();
            this.recordedStatement.set(this.recordedStatement.size() - 1, token1);
            if (token2 != null) {
                this.recordedStatement.add(token2);
            }
        }
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int errorCode = -1;
            switch (this.token.tokenType) {
                case 1022: {
                    errorCode = 5587;
                    break;
                }
                case 1021: {
                    errorCode = 5588;
                    break;
                }
                case 1023: {
                    errorCode = 5586;
                    break;
                }
                case 1019: {
                    errorCode = 5584;
                    break;
                }
                case -1: {
                    errorCode = 5582;
                    break;
                }
                case 1020: {
                    errorCode = 5585;
                    break;
                }
                case 1024: {
                    errorCode = 5589;
                    break;
                }
                case 1025: {
                    errorCode = 5583;
                    break;
                }
            }
            throw Error.error(errorCode, this.token.getFullString());
        }
        if (this.isRecording) {
            Token dup = this.token.duplicate();
            dup.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(dup);
        }
    }

    boolean isReservedKey() {
        return this.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.token.isReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.token.isCoreReservedIdentifier && (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    void checkIsIrregularCharInIdentifier() {
        if (this.token.hasIrregularChar) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (!this.token.isDelimitedIdentifier) {
            throw Error.error(5569);
        }
    }

    void checkIsUndelimitedIdentifier() {
        if (!this.token.isUndelimitedIdentifier) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 1011) {
            throw this.unexpectedToken();
        }
    }

    void checkIsIntegral() {
        if (!this.isIntegral()) {
            throw this.unexpectedTokenRequire("an integer");
        }
    }

    void checkIsQuotedString() {
        if (!this.isQuotedString()) {
            throw this.unexpectedTokenRequire("a quoted string");
        }
    }

    boolean isIntegral() {
        return this.token.tokenType == 1011 && this.token.dataType.isIntegralType();
    }

    boolean isQuotedString() {
        return this.token.tokenType == 1011 && this.token.dataType.isCharacterType();
    }

    void checkIsThis(int type) {
        if (this.token.tokenType != type) {
            String required = Tokens.getKeyword(type);
            if (required == null) {
                required = "";
            }
            throw this.unexpectedTokenRequire(required);
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String ident) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(ident)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsQuotedString();
        String value = this.token.tokenString;
        this.read();
        return value;
    }

    void readThis(int tokenId) {
        if (this.token.tokenType != tokenId) {
            String required = Tokens.getKeyword(tokenId);
            throw this.unexpectedTokenRequire(required);
        }
        this.read();
    }

    boolean readIfThis(int tokenId) {
        if (this.token.tokenType == tokenId) {
            this.read();
            return true;
        }
        return false;
    }

    void readThis(String tokenString) {
        if (!tokenString.equals(this.token.tokenString)) {
            throw this.unexpectedTokenRequire(tokenString);
        }
        this.read();
    }

    boolean readIfThis(String tokenString) {
        if (tokenString.equals(this.token.tokenString)) {
            this.read();
            return true;
        }
        return false;
    }

    void readAny(int id1, int id2, int id3, int id4) {
        this.read();
        this.checkIsAny(id1, id2, id3, id4);
    }

    void checkIsAny(int id1, int id2, int id3, int id4) {
        if (this.token.tokenType == id1 || this.token.tokenType == id2 || this.token.tokenType == id3 || this.token.tokenType == id4) {
            return;
        }
        String required = "";
        if (id1 != 0) {
            required = required + Tokens.getKeyword(id1);
            if (id2 != 0) {
                required = required + " or " + Tokens.getKeyword(id2);
            }
            if (id3 != 0) {
                required = required + " or " + Tokens.getKeyword(id3);
            }
            if (id4 != 0) {
                required = required + " or " + Tokens.getKeyword(id4);
            }
        }
        throw this.unexpectedTokenRequire(required);
    }

    Integer readIntegerObject() {
        int value = this.readInteger();
        return ValuePool.getInt(value);
    }

    int readInteger() {
        boolean minus = false;
        if (this.token.tokenType == 935) {
            minus = true;
            this.read();
        }
        this.checkIsIntegral();
        if (minus && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int val = ((Number)this.token.tokenValue).intValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    long readBigint() {
        boolean minus = false;
        if (this.token.tokenType == 935) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long val = ((Number)this.token.tokenValue).longValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    Expression readDateTimeIntervalLiteral(Session session) {
        int pos = this.getPosition();
        switch (this.token.tokenType) {
            case 77: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newDate(s);
                return new ExpressionValue(date, Type.SQL_DATE);
            }
            case 297: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String s = this.token.tokenString;
                this.read();
                TimeData value = this.scanner.newTime(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(value, dataType);
            }
            case 298: {
                this.read();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newTimestamp(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(date, dataType);
            }
            case 150: {
                boolean minus = false;
                this.read();
                if (this.token.tokenType == 935) {
                    this.read();
                    minus = true;
                } else if (this.token.tokenType == 938) {
                    this.read();
                }
                if (this.token.tokenType != 1011) break;
                String s = this.token.tokenString;
                if (!this.token.dataType.isIntegralType() && !this.token.dataType.isCharacterType()) break;
                this.read();
                IntervalType dataType = this.readIntervalType(session, false);
                Object interval = this.scanner.newInterval(s, dataType);
                dataType = (IntervalType)this.scanner.dateTimeType;
                if (minus) {
                    interval = dataType.negate(interval);
                }
                return new ExpressionValue(interval, dataType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(pos);
        return null;
    }

    IntervalType readIntervalType(Session session, boolean maxPrecisionDefault) {
        int endToken;
        int precision = -1;
        int scale = -1;
        int startIndex = -1;
        int endIndex = -1;
        int startToken = endToken = this.token.tokenType;
        String startTokenString = this.token.tokenString;
        startIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, startToken);
        this.read();
        if (this.token.tokenType == 937) {
            this.read();
            precision = this.readInteger();
            if (precision <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 924) {
                if (startToken != 264) {
                    throw this.unexpectedToken();
                }
                this.read();
                scale = this.readInteger();
                if (scale < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(922);
        }
        if (this.token.tokenType == 301) {
            int position = this.getPosition();
            this.read();
            int end = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, this.token.tokenType);
            if (end > startIndex) {
                endToken = this.token.tokenType;
                this.read();
            } else {
                this.rewind(position);
            }
        }
        if (this.token.tokenType == 937) {
            if (endToken != 264 || endToken == startToken) {
                throw this.unexpectedToken();
            }
            this.read();
            scale = this.readInteger();
            if (scale < 0) {
                throw Error.error(5592);
            }
            this.readThis(922);
        }
        endIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, endToken);
        if (precision == -1 && maxPrecisionDefault) {
            precision = startIndex == 5 ? 12 : 9;
        }
        if (startIndex == -1 && session.database.sqlSyntaxMys) {
            int type = FunctionCustom.getSQLTypeForToken(startTokenString);
            int startType = IntervalType.getStartIntervalType(type);
            int endType = IntervalType.getEndIntervalType(type);
            return IntervalType.getIntervalType(type, startType, endType, 9L, 9, true);
        }
        return IntervalType.getIntervalType(startIndex, endIndex, precision, scale);
    }

    static int getExpressionType(int tokenT) {
        int type = expressionTypeMap.get(tokenT, -1);
        if (type == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return type;
    }

    HsqlException unexpectedToken(String tokenS) {
        return Error.parseError(5581, tokenS, this.scanner.getLineNumber());
    }

    HsqlException unexpectedToken(int token) {
        String tokenS = Tokens.getKeyword(token);
        return Error.parseError(5581, tokenS, this.scanner.getLineNumber());
    }

    HsqlException unexpectedTokenRequire(String required) {
        if (this.token.tokenType == 1014) {
            return Error.parseError(5590, 1, this.scanner.getLineNumber(), new String[]{"", required});
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, 1, this.scanner.getLineNumber(), new String[]{tokenS, required});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 1014) {
            return Error.parseError(5590, null, this.scanner.getLineNumber());
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, tokenS, this.scanner.getLineNumber());
    }

    HsqlException tooManyIdentifiers() {
        String tokenS = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.parseError(5551, tokenS, this.scanner.getLineNumber());
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String s, NumberType type) {
        return this.scanner.convertToNumber(s, type);
    }

    OrderedHashMap readPropertyValuePairs(boolean optionalEquals, boolean requireEquals) {
        int pos;
        OrderedHashMap<String, Token> list;
        block2: {
            list = null;
            do {
                pos = this.getPosition();
                if (!this.token.isUndelimitedIdentifier) break block2;
                String prop = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 1014) break block2;
                boolean equals = this.readIfThis(420);
                if (!optionalEquals && (!requireEquals ? equals : !equals)) break block2;
                if (this.token.tokenType != 1011 && this.token.tokenType != 1012) break block2;
                Token value = this.token.duplicate();
                if (list == null) {
                    list = new OrderedHashMap<String, Token>();
                }
                list.put(prop, value);
                this.read();
            } while (this.readIfThis(924));
            pos = this.getPosition();
        }
        this.rewind(pos);
        return list;
    }

    static {
        expressionTypeMap.put(420, 40);
        expressionTypeMap.put(929, 43);
        expressionTypeMap.put(933, 44);
        expressionTypeMap.put(930, 41);
        expressionTypeMap.put(934, 45);
        expressionTypeMap.put(936, 46);
        expressionTypeMap.put(56, 74);
        expressionTypeMap.put(173, 77);
        expressionTypeMap.put(178, 76);
        expressionTypeMap.put(289, 75);
        expressionTypeMap.put(17, 78);
        expressionTypeMap.put(105, 79);
        expressionTypeMap.put(6, 80);
        expressionTypeMap.put(272, 80);
        expressionTypeMap.put(283, 81);
        expressionTypeMap.put(284, 82);
        expressionTypeMap.put(326, 83);
        expressionTypeMap.put(327, 84);
        expressionTypeMap.put(9, 85);
        expressionTypeMap.put(753, 86);
        expressionTypeMap.put(817, 87);
        expressionTypeMap.put(658, 89);
    }

    class Recorder {
        int position;

        Recorder() {
            this.position = ParserBase.this.recordedStatement.size() - 1;
        }

        String getSQL() {
            int size = ParserBase.this.recordedStatement.size() - this.position - 1;
            Token[] tokens = new Token[size];
            ParserBase.this.recordedStatement.toArraySlice(tokens, this.position, this.position + size);
            return Token.getSQL(tokens);
        }
    }
}

