/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner t) {
        super(session, t);
    }

    Statement compileStatement(int props) {
        Statement cs = this.compilePart(props);
        if (this.token.tokenType == 1014) {
            if (cs.getSchemaName() == null) {
                cs.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return cs;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String sql, Result cmd) {
        HsqlArrayList<Statement> list = new HsqlArrayList<Statement>();
        Statement cs = null;
        this.reset(this.session, sql);
        while (this.token.tokenType != 1014) {
            try {
                this.lastError = null;
                cs = this.compilePart(cmd.getExecuteProperties());
            }
            catch (HsqlException e) {
                if (this.lastError != null && this.lastError.getLevel() > e.getLevel()) {
                    throw this.lastError;
                }
                throw e;
            }
            if (!cs.isExplain && cs.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            cs.setCompileTimestamp(this.database.txManager.getSystemChangeNumber());
            list.add(cs);
        }
        if (list.size() > 1 && this.database.sqlRestrictExec) {
            throw Error.error(1252);
        }
        int returnType = cmd.getStatementType();
        if (returnType != 0) {
            int group = cs.getGroup();
            if (group == 2003) {
                if (returnType == 1) {
                    throw Error.error(1253);
                }
            } else if (returnType == 2 && this.database.sqlRestrictExec) {
                throw Error.error(1254);
            }
        }
        return list;
    }

    private Statement compilePart(int props) {
        Statement cs;
        this.compileContext.reset();
        this.setPartPosition(this.getPosition());
        if (this.token.tokenType == 1015) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 337: 
            case 937: {
                cs = this.compileCursorSpecification(RangeGroup.emptyArray, props, false);
                break;
            }
            case 325: {
                RangeGroup[] ranges = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(ranges);
                cs = this.compileShortCursorSpecification(props);
                break;
            }
            case 145: {
                cs = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 319: {
                cs = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 176: {
                cs = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 84: {
                cs = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 311: {
                cs = this.compileTruncateStatement();
                break;
            }
            case 799: {
                cs = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 28: {
                cs = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 268: {
                cs = this.compileSet();
                break;
            }
            case 128: {
                cs = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 281: {
                cs = this.compileStartTransaction();
                break;
            }
            case 47: {
                cs = this.compileCommit();
                break;
            }
            case 255: {
                cs = this.compileRollback();
                break;
            }
            case 260: {
                cs = this.compileSavepoint();
                break;
            }
            case 247: {
                cs = this.compileReleaseSavepoint();
                break;
            }
            case 59: {
                cs = this.compileCreate();
                break;
            }
            case 4: {
                cs = this.compileAlter();
                break;
            }
            case 93: {
                cs = this.compileDrop();
                break;
            }
            case 130: 
            case 253: {
                cs = this.compileGrantOrRevoke();
                break;
            }
            case 619: {
                cs = this.compileComment();
                break;
            }
            case 653: {
                cs = this.compileLock();
                break;
            }
            case 50: {
                cs = this.compileConnect();
                break;
            }
            case 89: {
                cs = this.compileDisconnect();
                break;
            }
            case 681: {
                cs = this.compileScript(false);
                break;
            }
            case 683: {
                cs = this.compileShutdown();
                break;
            }
            case 605: {
                cs = this.compileBackup();
                break;
            }
            case 615: {
                cs = this.compileCheckpoint();
                break;
            }
            case 632: {
                cs = this.compileExplain();
                break;
            }
            case 82: {
                cs = this.compileDeclare();
                break;
            }
            case 669: {
                cs = this.compilePerform();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (cs.type) {
            case 14: 
            case 66: 
            case 1093: 
            case 1151: {
                break;
            }
            default: {
                cs.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 943) {
            this.read();
        } else if (this.token.tokenType == 1014) {
            // empty if block
        }
        return cs;
    }

    private Statement compileDeclare() {
        Statement cs = this.compileDeclareLocalTableOrNull();
        if (cs != null) {
            return cs;
        }
        ColumnSchema[] variables = this.readLocalVariableDeclarationOrNull();
        if (variables != null) {
            Object[] args = new Object[]{variables};
            cs = new StatementSession(1127, args);
            return cs;
        }
        cs = this.compileDeclareCursorOrNull(RangeGroup.emptyArray, false);
        if (cs == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return cs;
    }

    private Statement compileScript(boolean extended) {
        String name = null;
        int scope = 0;
        int type = 0;
        Boolean colNames = Boolean.FALSE;
        HsqlNameManager.HsqlName tableName = null;
        TimestampData timestamp = null;
        this.readThis(681);
        if (extended) {
            this.readThis(120);
            this.checkIsAny(625, 294, 0, 0);
            if (this.readIfThis(625)) {
                switch (this.token.tokenType) {
                    case 561: {
                        this.read();
                        type = 561;
                        break;
                    }
                    case 331: {
                        this.read();
                        this.readThis(400);
                        if (this.readIfThis(124)) {
                            this.readThis(298);
                            String s = this.readQuotedString();
                            timestamp = (TimestampData)Type.SQL_TIMESTAMP.convertToType(this.session, s, Type.SQL_VARCHAR_DEFAULT);
                        } else {
                            timestamp = DateTimeType.epochTimestamp;
                        }
                        type = 331;
                        break;
                    }
                    case 400: {
                        this.read();
                        type = 400;
                        break;
                    }
                    default: {
                        type = 2;
                    }
                }
                if (this.readIfThis(337)) {
                    this.readThis(46);
                    this.readThis(483);
                    colNames = Boolean.TRUE;
                }
                this.readThis(301);
                scope = 625;
            } else if (this.readIfThis(294)) {
                Table table = this.readTableName();
                if (table.isView() || table.isTemp()) {
                    throw Error.error(5501);
                }
                tableName = table.getName();
                this.readThis(400);
                if (this.readIfThis(337)) {
                    this.readThis(46);
                    this.readThis(483);
                    colNames = Boolean.TRUE;
                }
                this.readThis(301);
                scope = 294;
                type = 400;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (this.token.tokenType == 1011) {
            if (scope == 0) {
                scope = 625;
                type = 2;
            }
            name = this.readQuotedString();
        } else if (scope == 0) {
            scope = 625;
            type = 561;
        } else {
            throw this.unexpectedTokenRequire("PATH");
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{name, scope, type, colNames, tableName, timestamp};
        return new StatementCommand(1004, args, null, names);
    }

    private Statement compileConnect() {
        String password = null;
        this.read();
        this.readThis(321);
        this.checkIsSimpleName();
        String userName = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(668);
            password = this.readPassword();
        }
        Expression[] args = new Expression[]{new ExpressionValue(userName, Type.SQL_VARCHAR), new ExpressionValue(password, Type.SQL_VARCHAR)};
        StatementSession cs = new StatementSession(this.session, this.compileContext, 81, args);
        return cs;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 647: {
                this.read();
                this.readThis(540);
                HsqlNameManager.HsqlName schema = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{schema};
                return new StatementCommand(1034, args);
            }
            case 250: {
                this.read();
                this.readThis(659);
                this.readThis(259);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1046, args);
            }
            case 294: {
                int type;
                this.read();
                this.readThis(578);
                switch (this.token.tokenType) {
                    case 659: {
                        type = 4;
                        break;
                    }
                    case 613: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1035, args);
            }
            case 451: {
                int level;
                this.read();
                this.readThis(469);
                switch (this.token.tokenType) {
                    case 521: {
                        this.read();
                        this.readThis(387);
                        level = 2;
                        break;
                    }
                    case 549: {
                        this.read();
                        level = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{ValuePool.getInt(level)};
                return new StatementCommand(1053, args);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object value;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String property = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 310) {
            value = Boolean.TRUE;
        } else if (this.token.tokenType == 114) {
            value = Boolean.FALSE;
        } else {
            this.checkIsValue();
            value = this.token.tokenValue;
        }
        this.read();
        Object[] args = new Object[]{property, value};
        return new StatementCommand(1039, args);
    }

    private Statement compileSet() {
        this.read();
        switch (this.token.tokenType) {
            case 370: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(72, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(this.session, this.compileContext, 72, args);
            }
            case 540: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(80, args);
                }
                if (e.isUnresolvedParam()) {
                    e.setDataType(this.session, Type.SQL_VARCHAR_DEFAULT);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                switch (e.getType()) {
                    case 1: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 28: {
                        if (((FunctionSQL)e).isValueFunction()) break;
                        throw Error.error(2200);
                    }
                    default: {
                        throw Error.error(2200);
                    }
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(this.session, this.compileContext, 80, args);
            }
            case 190: {
                this.read();
                this.readThis(380);
                HsqlArrayList<SchemaObject> charsets = null;
                if (this.readIfThis(120)) {
                    charsets = new HsqlArrayList<SchemaObject>();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 924) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{null, Boolean.FALSE, charsets};
                return new StatementSession(83, args);
            }
            case 380: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null || !e.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList<SchemaObject> charsets = null;
                if (this.readIfThis(120)) {
                    charsets = new HsqlArrayList<SchemaObject>();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 924) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{e, Boolean.TRUE, charsets};
                return new StatementSession(83, args);
            }
            case 297: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 532: {
                this.read();
                return this.compileSetRole();
            }
            case 551: {
                this.read();
                return this.compileSessionSettings();
            }
            case 569: {
                this.read();
                Object[] args = this.processTransactionCharacteristics();
                if (args[0] == null && args[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(85, args);
            }
            case 603: {
                return this.compileSetAutoCommit();
            }
            case 674: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                Object[] args = new Object[]{readonly};
                return new StatementSession(82, args);
            }
            case 640: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1048, args);
            }
            case 657: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1116, args);
            }
            case 83: {
                int type;
                this.read();
                this.readThis(294);
                this.readThis(578);
                switch (this.token.tokenType) {
                    case 659: {
                        type = 4;
                        break;
                    }
                    case 613: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1035, args);
            }
            case 294: {
                return this.compileSetTable();
            }
            case 696: {
                this.read();
                int delay = 0;
                if (this.token.tokenType == 310) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 660) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                Object[] args = new Object[]{delay};
                return new StatementCommand(1033, args, null, null);
            }
            case 668: {
                Boolean isDigest = Boolean.FALSE;
                this.read();
                if (this.readIfThis(629)) {
                    isDigest = Boolean.TRUE;
                }
                String password = this.readPassword();
                Object[] args = new Object[]{null, password, isDigest};
                StatementCommand cs = new StatementCommand(1093, args);
                String sql = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, password, isDigest);
                cs.setSQL(sql);
                return cs;
            }
            case 647: {
                this.read();
                this.readThis(540);
                HsqlNameManager.HsqlName schema = this.token.tokenType == 83 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{null, schema};
                return new StatementCommand(1092, args);
            }
            case 636: {
                return this.compileSetFilesProperty();
            }
            case 625: {
                return this.compileSetDatabaseProperty();
            }
            case 672: {
                return this.compileSetProperty();
            }
        }
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementSession compileSetAutoCommit() {
        this.read();
        boolean mode = false;
        int rows = -1;
        switch (this.token.tokenType) {
            case 114: 
            case 310: {
                mode = this.processTrueOrFalse();
                break;
            }
            case 14: {
                this.read();
                rows = this.readInteger();
                if (rows < 0) {
                    throw Error.error(3403);
                }
                this.readThis(259);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{mode, rows};
        return new StatementSession(1114, args);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] args = new Object[]{table.getName(), null, null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 556: {
                this.read();
                return this.compileTableSource(table);
            }
            case 521: {
                this.read();
                boolean readonly = false;
                if (this.token.tokenType == 591) {
                    this.read();
                } else {
                    this.readThis(205);
                    readonly = true;
                }
                args[1] = readonly;
                return new StatementCommand(1155, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 674: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                args[1] = readonly;
                return new StatementCommand(1155, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 644: {
                this.read();
                this.checkIsValue();
                String value = this.token.tokenString;
                this.read();
                args[1] = value;
                args[2] = 5;
                return new StatementCommand(1154, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 578: {
                int newType;
                this.read();
                switch (this.token.tokenType) {
                    case 659: {
                        newType = 4;
                        break;
                    }
                    case 613: {
                        newType = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                switch (table.getTableType()) {
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                args[1] = newType;
                return new StatementCommand(1158, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 618: {
                this.read();
                this.readThis(204);
                OrderedHashSet set = new OrderedHashSet();
                this.readThis(937);
                this.readSimpleColumnNames(set, table, false);
                this.readThis(922);
                int[] colIndex = table.getColumnIndexes(set);
                args[1] = colIndex;
                return new StatementCommand(1159, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 189: {
                this.read();
                this.readThis(557);
                args = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1160, args, null, writeLockNames);
            }
            case 557: 
        }
        this.read();
        Integer id = this.readIntegerObject();
        args = new Object[]{table.getName(), id};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1161, args, null, writeLockNames);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 604: {
                this.read();
                this.readThis(126);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] args = new Object[]{routine};
                return new StatementCommand(1036, args, null, null);
            }
            case 380: {
                Boolean padSpace = null;
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.read();
                if (this.readIfThis(190)) {
                    this.readThis(503);
                    padSpace = Boolean.FALSE;
                } else if (this.readIfThis(503)) {
                    this.readThis(557);
                    padSpace = Boolean.TRUE;
                }
                if (padSpace == null) {
                    padSpace = Boolean.TRUE;
                }
                Object[] args = new Object[]{name, padSpace};
                return new StatementCommand(1047, args, null, null);
            }
            case 83: {
                return this.compileSetDefault();
            }
            case 631: {
                this.read();
                this.readThis(768);
                boolean sqlLog = this.readIfThis(275);
                this.readThis(469);
                Integer value = this.readIntegerObject();
                Object[] args = new Object[]{value, sqlLog, Boolean.TRUE};
                return new StatementCommand(1016, args, null, null);
            }
            case 112: {
                this.read();
                this.readThis(631);
                this.readThis(768);
                this.readThis(469);
                Integer value = this.readIntegerObject();
                Object[] args = new Object[]{value, Boolean.FALSE, Boolean.FALSE};
                return new StatementCommand(1016, args, null, null);
            }
            case 637: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1037, args, null, null);
            }
            case 668: {
                this.read();
                switch (this.token.tokenType) {
                    case 40: {
                        this.read();
                        this.readThis(126);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] args = new Object[]{routine};
                        return new StatementCommand(1040, args, null, null);
                    }
                    case 629: {
                        this.read();
                        String name = this.readQuotedString();
                        Object[] args = new Object[]{name};
                        return new StatementCommand(1057, args, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 675: {
                this.read();
                this.readThis(642);
                boolean mode = this.processTrueOrFalse();
                Object[] args = new Object[]{mode};
                return new StatementCommand(1049, args, null, null);
            }
            case 275: {
                this.read();
                int type = 1050;
                Boolean flag = Boolean.TRUE;
                Integer value = 0;
                String property = null;
                switch (this.token.tokenType) {
                    case 17: {
                        this.read();
                        this.readThis(539);
                        value = this.readIntegerObject();
                        property = "sql.avg_scale";
                        break;
                    }
                    case 38: {
                        this.read();
                        this.readThis(650);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.char_literal";
                        break;
                    }
                    case 718: {
                        this.read();
                        this.readThis(489);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.concat_nulls";
                        break;
                    }
                    case 53: {
                        this.read();
                        this.readThis(311);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.convert_trunc";
                        break;
                    }
                    case 92: {
                        this.read();
                        this.readThis(662);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.double_nan";
                        break;
                    }
                    case 640: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.ignore_case";
                        break;
                    }
                    case 651: {
                        this.read();
                        this.readThis(491);
                        property = "sql.live_object";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 656: {
                        this.read();
                        this.readThis(152);
                        this.readThis(767);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.longvar_is_lob";
                        break;
                    }
                    case 171: {
                        this.read();
                        this.readThis(32);
                        this.readThis(639);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.lowercase_ident";
                        break;
                    }
                    case 173: {
                        this.read();
                        this.readThis(234);
                        value = this.readIntegerObject();
                        property = "sql.max_recursive";
                        break;
                    }
                    case 483: {
                        this.read();
                        property = "sql.enforce_names";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 489: {
                        this.read();
                        if (this.readIfThis(427)) {
                            property = "sql.nulls_first";
                        } else {
                            this.readThis(208);
                            property = "sql.nulls_order";
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 676: {
                        this.read();
                        this.readThis(483);
                        property = "sql.regular_names";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 236: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_refs";
                        break;
                    }
                    case 526: {
                        this.read();
                        this.readThis(107);
                        property = "sql.restrict_exec";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 555: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_size";
                        break;
                    }
                    case 686: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            property = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            property = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            property = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            property = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            property = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 819: {
                        this.read();
                        this.readThis(644);
                        this.readThis(483);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.sys_index_names";
                        break;
                    }
                    case 687: {
                        this.read();
                        if (this.readIfThis(84)) {
                            property = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(319);
                            property = "sql.enforce_tdc_update";
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 303: {
                        this.read();
                        this.readThis(691);
                        this.readThis(692);
                        flag = this.processTrueOrFalseObject();
                        property = "jdbc.translate_tti_types";
                        break;
                    }
                    case 311: {
                        this.read();
                        this.readThis(302);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.truncate_trailing";
                        break;
                    }
                    case 692: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_types";
                        break;
                    }
                    case 315: {
                        this.read();
                        this.readThis(489);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.unique_nulls";
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{property, flag, value};
                return new StatementCommand(type, args, null, null);
            }
            case 689: {
                this.read();
                this.readThis(294);
                this.readThis(403);
                String source = this.readQuotedString();
                Object[] args = new Object[]{source};
                return new StatementCommand(1051, args, null, null);
            }
            case 569: {
                this.read();
                if (this.readIfThis(255)) {
                    this.readThis(204);
                    if (this.readIfThis(643)) {
                        Boolean mode = this.processTrueOrFalseObject();
                        StatementCommand cs = new StatementCommand(1055, new Object[]{mode}, null, null);
                        return cs;
                    }
                    this.readThis(622);
                    Boolean mode = this.processTrueOrFalseObject();
                    StatementCommand cs = new StatementCommand(1054, new Object[]{mode}, null, null);
                    return cs;
                }
                this.readThis(623);
                int mode = 0;
                switch (this.token.tokenType) {
                    case 776: {
                        this.read();
                        mode = 2;
                        break;
                    }
                    case 777: {
                        this.read();
                        mode = 1;
                        break;
                    }
                    case 654: {
                        this.read();
                        mode = 0;
                        break;
                    }
                }
                HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] args = new Object[]{ValuePool.getInt(mode)};
                StatementCommand cs = new StatementCommand(1052, args, null, names);
                return cs;
            }
            case 315: {
                this.read();
                this.readThis(482);
                if (!this.isUndelimitedSimpleName()) {
                    throw this.unexpectedToken();
                }
                String name = this.token.tokenString;
                this.read();
                if (name.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(name, Charset.unquotedIdentifier) || !Charset.startsWith(name, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] args = new Object[]{name};
                return new StatementCommand(1056, args, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int type = 0;
        Boolean flag = null;
        Object value = null;
        Boolean mode = null;
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 40: {
                this.read();
                long longValue1 = this.readBigint();
                long longValue2 = -1L;
                type = 1014;
                names = this.database.schemaManager.getCatalogNameArray();
                if (this.readIfThis(924)) {
                    longValue2 = this.readBigint();
                }
                Object[] args = new Object[]{longValue1, longValue2};
                return new StatementCommand(type, args, null, names);
            }
            case 612: {
                this.read();
                if (this.readIfThis(555)) {
                    value = this.readIntegerObject();
                    type = 1013;
                } else {
                    this.readThis(259);
                    value = this.readIntegerObject();
                    type = 1012;
                }
                if (!this.readIfThis(190)) break;
                this.readThis(40);
                mode = Boolean.TRUE;
                break;
            }
            case 539: {
                this.read();
                value = this.readIntegerObject();
                type = 1025;
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 557: {
                this.read();
                if (this.token.tokenType == 310) {
                    flag = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 114) {
                    flag = Boolean.FALSE;
                    this.read();
                } else {
                    value = this.readIntegerObject();
                }
                type = 1031;
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 767: {
                this.read();
                if (this.readIfThis(539)) {
                    value = this.readIntegerObject();
                    type = 1017;
                } else {
                    this.readThis(621);
                    type = 1018;
                    flag = this.processTrueOrFalseObject();
                }
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 627: {
                this.read();
                type = 1015;
                value = this.readIntegerObject();
                break;
            }
            case 780: {
                this.read();
                if (this.readIfThis(555)) {
                    value = this.readIntegerObject();
                } else {
                    flag = this.processTrueOrFalseObject();
                }
                type = 1022;
                break;
            }
            case 605: {
                this.read();
                type = 1011;
                this.readThis(444);
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 768: {
                this.read();
                if (this.readIfThis(555)) {
                    type = 1021;
                    value = this.readIntegerObject();
                    break;
                }
                type = 1020;
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 688: {
                this.read();
                this.readThis(513);
                type = 1032;
                value = this.readQuotedString();
                break;
            }
            case 591: {
                this.read();
                this.readThis(628);
                type = 1033;
                int delay = 0;
                if (this.token.tokenType == 310) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 660) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                value = delay;
                break;
            }
            case 681: {
                this.read();
                this.readThis(429);
                if (this.token.tokenType == 689) {
                    this.read();
                    value = 0;
                } else {
                    this.readThis(621);
                    value = 3;
                }
                type = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{flag == null ? value : flag, mode};
        return new StatementCommand(type, args, null, names);
    }

    Object[] processTransactionCharacteristics() {
        int level = 0;
        boolean readonly = false;
        Object[] args = new Object[2];
        this.checkIsAny(521, 451, 0, 0);
        block10: while (true) {
            switch (this.token.tokenType) {
                case 521: {
                    if (args[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 205) {
                        this.read();
                        readonly = true;
                    } else {
                        this.readThis(591);
                        readonly = false;
                    }
                    args[0] = readonly;
                    continue block10;
                }
                case 451: {
                    if (args[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(469);
                    this.checkIsAny(549, 521, 523, 0);
                    switch (this.token.tokenType) {
                        case 549: {
                            this.read();
                            level = 8;
                            break;
                        }
                        case 521: {
                            this.readAny(387, 580, 0, 0);
                            if (this.token.tokenType == 387) {
                                this.read();
                                level = 2;
                                break;
                            }
                            if (this.token.tokenType == 580) {
                                this.read();
                                level = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 523: {
                            this.read();
                            this.readThis(521);
                            level = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    args[1] = level;
                    continue block10;
                }
                case 924: {
                    if (args[0] == null && args[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!readonly && level == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return args;
    }

    private Statement compileCommit() {
        boolean chain = false;
        this.read();
        this.readIfThis(590);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(372);
        }
        String sql = chain ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession st = new StatementSession(14, new Object[]{chain});
        st.setSQL(sql);
        return st;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(569);
        Object[] args = this.processTransactionCharacteristics();
        StatementSession cs = new StatementSession(86, args);
        return cs;
    }

    private Statement compileLock() {
        this.read();
        if (this.readIfThis(370)) {
            return this.compileLockCatalog();
        }
        this.readThis(294);
        return this.compileLockTable();
    }

    private Statement compileLockCatalog() {
        boolean isLock = this.processTrueOrFalse();
        int statementType = isLock ? 1111 : 1112;
        HsqlNameManager.HsqlName[] writeTableNames = isLock ? this.database.schemaManager.getCatalogAndBaseTableNames() : null;
        StatementSession cs = new StatementSession(statementType, null, writeTableNames);
        return cs;
    }

    private Statement compileLockTable() {
        OrderedHashSet<HsqlNameManager.HsqlName> readSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> writeSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        while (true) {
            Table table = this.readTableName(true);
            switch (this.token.tokenType) {
                case 521: {
                    this.read();
                    readSet.add(table.getName());
                    break;
                }
                case 591: {
                    this.read();
                    writeSet.add(table.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        HsqlNameManager.HsqlName[] writeTableNames = new HsqlNameManager.HsqlName[writeSet.size()];
        writeSet.toArray(writeTableNames);
        readSet.removeAll(writeTableNames);
        HsqlNameManager.HsqlName[] readTableNames = new HsqlNameManager.HsqlName[readSet.size()];
        readSet.toArray(readTableNames);
        StatementSession cs = new StatementSession(1113, readTableNames, writeTableNames);
        return cs;
    }

    private Statement compileRollback() {
        boolean chain = false;
        String savepoint = null;
        this.read();
        if (this.token.tokenType == 590) {
            this.read();
        }
        if (this.token.tokenType == 301) {
            this.read();
            this.readThis(260);
            this.checkIsSimpleName();
            savepoint = this.token.tokenString;
            this.read();
            Object[] args = new Object[]{savepoint};
            StatementSession cs = new StatementSession(1118, args);
            return cs;
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(372);
        }
        String sql = chain ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession st = new StatementSession(66, new Object[]{chain});
        st.setSQL(sql);
        return st;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String name = this.token.tokenString;
        this.read();
        Object[] args = new Object[]{name};
        return new StatementSession(67, args);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(260);
        String name = this.token.tokenString;
        this.read();
        Object[] args = new Object[]{name};
        return new StatementSession(61, args);
    }

    private Statement compileSessionSettings() {
        this.checkIsAny(376, 16, 250, 634);
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                this.readThis(11);
                this.readThis(569);
                Object[] args = this.processTransactionCharacteristics();
                return new StatementSession(82, args);
            }
            case 16: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    throw Error.error(5584);
                }
                e.resolveTypes(this.session, null);
                if (e.isUnresolvedParam()) {
                    e.dataType = Type.SQL_VARCHAR;
                }
                if (e.dataType == null || !e.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] args = new Expression[]{e, null};
                return new StatementSession(this.session, this.compileContext, 81, args);
            }
            case 250: {
                this.read();
                this.readThis(659);
                this.readThis(259);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1117, args);
            }
            case 634: {
                this.read();
                String feature = this.parseSQLFeatureValue();
                Boolean value = this.processTrueOrFalseObject();
                Object[] args = new Object[]{feature, value};
                return new StatementSession(1115, args);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression e;
        if (this.token.tokenType == 191) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            e = this.XreadValueSpecificationOrNull();
            if (e == null) {
                throw Error.error(4100);
            }
            if (!e.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        return new StatementSession(this.session, this.compileContext, 79, new Expression[]{e});
    }

    private Statement compileSetTimeZone() {
        Expression e;
        this.readThis(593);
        switch (this.token.tokenType) {
            case 167: {
                this.read();
                e = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
                break;
            }
            case 150: {
                e = this.XreadIntervalValueExpression();
                List unresolved = e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                e.resolveTypes(this.session, null);
                if (e.dataType == null) {
                    throw Error.error(5563);
                }
                if (e.dataType.typeCode == 111) break;
                throw Error.error(5563);
            }
            default: {
                e = this.XreadValueExpression();
            }
        }
        return new StatementSession(this.session, this.compileContext, 76, new Expression[]{e});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int closemode = 2;
        this.read();
        switch (this.token.tokenType) {
            case 641: {
                closemode = 1;
                this.read();
                break;
            }
            case 620: {
                closemode = 3;
                this.read();
                break;
            }
            case 681: {
                closemode = 4;
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 943) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        Object[] args = new Object[]{closemode};
        StatementCommand cs = new StatementCommand(1003, args, null, null);
        return cs;
    }

    private Statement compileBackup() {
        Boolean blockingMode = null;
        Boolean scriptMode = null;
        Boolean compression = null;
        Boolean files = null;
        this.read();
        this.readThis(625);
        this.readThis(301);
        String path = this.readQuotedString();
        path = path.trim();
        if (path.isEmpty()) {
            throw this.unexpectedToken(path);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 609: {
                    if (blockingMode != null) {
                        throw this.unexpectedToken();
                    }
                    blockingMode = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 681: {
                    if (scriptMode != null) {
                        throw this.unexpectedToken();
                    }
                    scriptMode = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 621: {
                    if (compression != null) {
                        throw this.unexpectedToken();
                    }
                    compression = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 193: {
                    this.read();
                    if (this.token.tokenType == 621) {
                        if (compression != null) {
                            throw this.unexpectedToken();
                        }
                        compression = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 609) {
                        if (blockingMode != null) {
                            throw this.unexpectedToken();
                        }
                        blockingMode = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 11: {
                    if (files != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(636);
                    files = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (scriptMode == null) {
            scriptMode = Boolean.FALSE;
        }
        if (blockingMode == null) {
            blockingMode = Boolean.TRUE;
        }
        if (compression == null) {
            compression = Boolean.TRUE;
        }
        if (files == null) {
            files = Boolean.FALSE;
        }
        if (scriptMode.booleanValue() && !blockingMode.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] names = blockingMode != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] args = new Object[]{path, blockingMode, scriptMode, compression, files};
        StatementCommand cs = new StatementCommand(1001, args, null, names);
        return cs;
    }

    private Statement compilePerform() {
        this.readAny(40, 633, 139, 0);
        switch (this.token.tokenType) {
            case 40: {
                return this.compileCheck();
            }
            case 139: {
                this.readAny(681, 400, 0, 0);
                if (this.token.tokenType == 681) {
                    return this.compileImportScript();
                }
                return this.compileImportData();
            }
            case 633: {
                this.readAny(681, 400, 0, 0);
                if (this.token.tokenType == 681) {
                    return this.compileScript(true);
                }
                return this.compileExportData();
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileCheck() {
        this.readAny(2, 294, 0, 0);
        boolean isAll = false;
        HsqlNameManager.HsqlName tableName = null;
        Integer type = 3;
        Integer number = -1;
        switch (this.token.tokenType) {
            case 2: {
                this.read();
                isAll = true;
            }
            case 294: {
                this.readThis(294);
                if (isAll) {
                    this.readThis(644);
                    break;
                }
                tableName = this.readTableName().getName();
                this.readThis(644);
            }
        }
        if (this.readIfThis(5)) {
            this.readThis("FIX");
            type = 8;
        }
        Object[] args = new Object[]{tableName, type, number};
        HsqlNameManager.HsqlName[] names = isAll ? this.database.schemaManager.getCatalogAndBaseTableNames() : this.database.schemaManager.getCatalogAndBaseTableNames(tableName);
        return new StatementCommand(1006, args, null, names);
    }

    private Statement compileExportData() {
        this.readThis(400);
        this.readThis(124);
        this.readThis(294);
        HsqlNameManager.HsqlName tableName = this.readTableName().getName();
        this.readThis(301);
        String fileName = this.readQuotedString();
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{tableName, fileName};
        return new StatementCommand(910, args, null, names);
    }

    private Statement compileImportScript() {
        int mode = 2;
        Boolean isVersioning = Boolean.FALSE;
        this.readThis(681);
        this.checkIsAny(331, 400, 0, 0);
        if (this.token.tokenType == 331) {
            this.readThis(331);
            isVersioning = Boolean.TRUE;
        }
        this.readThis(400);
        this.readThis(124);
        String fileName = this.readQuotedString();
        if (!isVersioning.booleanValue()) {
            mode = this.readLoadMode();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{fileName, mode, isVersioning};
        return new StatementCommand(1005, args, null, names);
    }

    private Statement compileImportData() {
        this.readThis(400);
        this.readThis(151);
        this.readThis(294);
        HsqlNameManager.HsqlName tableName = this.readTableName().getName();
        this.readThis(124);
        String fileName = this.readQuotedString();
        int mode = this.readLoadMode();
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{tableName, fileName, mode};
        return new StatementCommand(909, args, null, names);
    }

    private int readLoadMode() {
        int mode = -1;
        this.checkIsAny(398, 684, 40, 0);
        switch (this.token.tokenType) {
            case 398: {
                mode = 2;
                this.read();
                break;
            }
            case 684: {
                mode = 1;
                this.read();
                break;
            }
            case 40: {
                mode = 4;
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(204);
        this.readThis(421);
        return mode;
    }

    private Statement compileCheckpoint() {
        boolean defrag = false;
        this.read();
        if (this.token.tokenType == 627) {
            defrag = true;
            this.read();
        } else if (this.token.tokenType == 943) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{defrag};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        return cs;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] names = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{Boolean.FALSE};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        cs.setCompileTimestamp(database.txManager.getSystemChangeNumber());
        cs.setSQL("CHECKPOINT");
        return cs;
    }

    private Statement compileDisconnect() {
        this.read();
        String sql = "DISCONNECT";
        StatementSession cs = new StatementSession(22, null);
        return cs;
    }

    private Statement compileExplain() {
        int position = this.getPosition();
        this.readAny(670, 236, 0, 0);
        Statement cs = this.token.tokenType == 670 ? this.compileExplainPlan() : this.compileExplainReferences();
        cs.setSQL(this.getLastPart(position));
        return cs;
    }

    private Statement compileExplainPlan() {
        this.readThis(670);
        this.readThis(120);
        Statement cs = this.compilePart(0);
        cs.setDescribe();
        return new StatementCommand(1151, new Object[]{cs});
    }

    private Statement compileExplainReferences() {
        int type;
        boolean referencesFrom = false;
        this.readAny(301, 124, 0, 0);
        if (!this.readIfThis(301)) {
            this.readThis(124);
            referencesFrom = true;
        }
        switch (this.token.tokenType) {
            case 294: 
            case 589: {
                this.read();
                type = 3;
                break;
            }
            case 273: {
                this.read();
                this.readThis(533);
                type = 24;
                break;
            }
            case 415: 
            case 578: {
                this.read();
                type = 13;
                break;
            }
            case 548: {
                this.read();
                type = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        SchemaObject object = this.readSchemaObjectName(type);
        HsqlNameManager.HsqlName name = object.getName();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        return new StatementCommand(1150, new Object[]{name, referencesFrom});
    }

    private StatementCommand compileTableSource(Table t) {
        String source;
        String sql;
        boolean isSourceHeader = false;
        boolean isDesc = false;
        Object[] args = new Object[5];
        args[0] = t.getName();
        if (!t.isText()) {
            HsqlException hsqlException = Error.error(321);
        }
        if (this.token.tokenType == 204) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.TRUE;
            return new StatementCommand(1156, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 667) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.FALSE;
            return new StatementCommand(1156, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 638) {
            this.read();
            isSourceHeader = true;
        }
        if (this.token.tokenType == 1013) {
            source = this.token.tokenString;
            this.read();
        } else {
            source = this.readQuotedString();
        }
        if (!isSourceHeader && this.token.tokenType == 411) {
            isDesc = true;
            this.read();
        }
        sql = this.getLastPart();
        args[2] = source;
        args[3] = isDesc;
        args[4] = isSourceHeader;
        int type = isSourceHeader ? 1157 : 1156;
        return new StatementCommand(type, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
    }
}

