/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{59, 130};
    static final short[] startStatementTokens = new short[]{59, 130, 4, 93};
    static final short[] startStatementTokensSchema = new short[]{59, 130};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(Session session, String sql) {
        super.reset(session, sql);
    }

    StatementSchema compileCreate() {
        int tableType;
        boolean isTable = false;
        boolean isOrReplace = false;
        this.read();
        switch (this.token.tokenType) {
            case 129: {
                this.read();
                this.readThis(566);
                this.readIfThis(659);
                this.readThis(294);
                isTable = true;
                tableType = 3;
                break;
            }
            case 688: {
                this.read();
                this.readThis(294);
                isTable = true;
                tableType = 3;
                break;
            }
            case 566: {
                this.read();
                this.readThis(294);
                isTable = true;
                tableType = 3;
                break;
            }
            case 659: {
                this.read();
                this.readThis(294);
                isTable = true;
                tableType = 4;
                break;
            }
            case 613: {
                this.read();
                this.readThis(294);
                isTable = true;
                tableType = 5;
                break;
            }
            case 689: {
                this.read();
                this.readThis(294);
                isTable = true;
                tableType = 7;
                break;
            }
            case 294: {
                this.read();
                isTable = true;
                tableType = this.database.schemaManager.getDefaultTableType();
                break;
            }
            default: {
                tableType = 4;
            }
        }
        if (isTable) {
            return this.compileCreateTable(tableType);
        }
        if (this.database.sqlSyntaxOra && this.token.tokenType == 207) {
            this.read();
            this.readThis(799);
            switch (this.token.tokenType) {
                case 126: 
                case 229: 
                case 307: 
                case 578: 
                case 589: 
                case 685: {
                    break;
                }
                default: {
                    throw this.unexpectedToken("OR");
                }
            }
            isOrReplace = true;
        }
        switch (this.token.tokenType) {
            case 601: {
                return this.compileCreateAlias();
            }
            case 548: {
                return this.compileCreateSequence();
            }
            case 540: {
                return this.compileCreateSchema();
            }
            case 307: {
                return this.compileCreateTrigger(isOrReplace);
            }
            case 321: {
                return this.compileCreateUser();
            }
            case 532: {
                return this.compileCreateRole();
            }
            case 589: {
                return this.compileCreateView(false, isOrReplace);
            }
            case 415: {
                return this.compileCreateDomain();
            }
            case 578: {
                return this.compileCreateType(isOrReplace);
            }
            case 38: {
                return this.compileCreateCharacterSet();
            }
            case 380: {
                return this.compileCreateCollation();
            }
            case 315: {
                this.read();
                this.checkIsThis(644);
                return this.compileCreateIndex(true);
            }
            case 644: {
                return this.compileCreateIndex(false);
            }
            case 602: {
                return this.compileCreateProcedureOrFunction(isOrReplace);
            }
            case 126: 
            case 229: {
                return this.compileCreateProcedureOrFunction(isOrReplace);
            }
            case 685: {
                return this.compileCreateSynonym(isOrReplace);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 644: {
                return this.compileAlterIndex();
            }
            case 540: {
                this.read();
                HsqlNameManager.HsqlName name = this.readSchemaName();
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameSchema(name, 2);
            }
            case 370: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.checkValidCatalogName(name);
                this.read();
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameObject(this.database.getCatalogName(), 1, false);
            }
            case 548: {
                return this.compileAlterSequence();
            }
            case 294: {
                return this.compileAlterTable();
            }
            case 321: {
                return this.compileAlterUser();
            }
            case 415: {
                return this.compileAlterDomain();
            }
            case 589: {
                return this.compileAlterView();
            }
            case 551: {
                return this.compileAlterSession();
            }
            case 273: {
                return this.compileAlterSpecificRoutine();
            }
            case 533: {
                return this.compileAlterRoutine();
            }
            case 51: {
                this.read();
                Constraint constraint = (Constraint)this.readSchemaObjectName(5);
                if (this.readIfThis(644)) {
                    return this.compileAlterFKIndex(constraint);
                }
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameObject(constraint.getName(), 5, false);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterSpecificRoutine() {
        this.readThis(273);
        this.readThis(533);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(routine.getSpecificName(), 24, false);
            }
        }
        return this.compileAlterSpecificRoutine(routine);
    }

    Statement compileAlterIndex() {
        this.readThis(644);
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(20, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        if (this.token.tokenType == 677) {
            this.read();
            this.readThis(301);
            return this.compileRenameObject(name, 20, false);
        }
        this.readThis(11);
        Index index = (Index)this.database.schemaManager.getSchemaObject(name);
        if (index == null) {
            throw Error.error(5501);
        }
        Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
        int[] indexColumns = this.readColumnList(table, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, indexColumns, index.getName()};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 1121, args, null, writeLockNames);
    }

    Statement compileAlterFKIndex(Constraint constraint) {
        if (constraint.getConstraintType() != 0) {
            throw Error.error(1501);
        }
        if (constraint.getName().isReservedName()) {
            throw Error.error(4002);
        }
        this.readThis(356);
        Table table = constraint.getRef();
        int[] newColumns = this.readColumnList(table, true);
        int[] constColumns = constraint.getMainColumns();
        int common = ArrayUtil.countCommonElements(constColumns, newColumns);
        if (common > 0) {
            throw Error.error(1501);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, newColumns, constraint.getName()};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 1146, args, null, writeLockNames);
    }

    Statement compileAlterRoutine() {
        this.readThis(533);
        RoutineSchema routine = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(677);
        this.readThis(301);
        return this.compileRenameObject(routine.getName(), routine.getName().type, false);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] writeLockNames;
        SchemaObject object;
        int objectType;
        int statementType;
        boolean canCascade = false;
        boolean cascade = false;
        boolean useIfExists = false;
        boolean ifExists = false;
        this.read();
        int objectTokenType = this.token.tokenType;
        switch (objectTokenType) {
            case 644: {
                this.read();
                statementType = 1129;
                objectType = 20;
                useIfExists = true;
                break;
            }
            case 361: {
                this.read();
                statementType = 24;
                objectType = 6;
                canCascade = true;
                break;
            }
            case 273: {
                this.read();
                switch (this.token.tokenType) {
                    case 126: 
                    case 229: 
                    case 533: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                statementType = 30;
                objectType = 24;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 229: {
                this.read();
                statementType = 30;
                objectType = 17;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 126: {
                this.read();
                statementType = 30;
                objectType = 16;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 540: {
                this.read();
                statementType = 31;
                objectType = 2;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 548: {
                this.read();
                statementType = 32;
                objectType = 7;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 307: {
                this.read();
                statementType = 36;
                objectType = 8;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 321: {
                this.read();
                statementType = 1131;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 532: {
                this.read();
                statementType = 29;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 415: {
                this.read();
                statementType = 28;
                objectType = 13;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 578: {
                this.read();
                statementType = 27;
                objectType = 12;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 38: {
                this.read();
                this.readThis(268);
                statementType = 25;
                objectType = 14;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 380: {
                this.read();
                statementType = 26;
                objectType = 15;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 589: {
                this.read();
                statementType = 39;
                objectType = 4;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 294: {
                this.read();
                statementType = 33;
                objectType = 3;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 685: {
                this.read();
                statementType = 1148;
                objectType = 29;
                canCascade = false;
                useIfExists = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (useIfExists && this.token.tokenType == 439) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 109) {
                this.read();
                ifExists = true;
            } else {
                this.rewind(position);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName name = null;
        switch (objectTokenType) {
            case 321: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                object = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 532: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                object = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 540: {
                name = this.readNewSchemaName();
                object = this.database.schemaManager.findSchema(name.name);
                break;
            }
            case 294: {
                boolean isSession;
                boolean bl = isSession = this.token.namePrePrefix == null && ("SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
                if (isSession) {
                    name = this.readNewSchemaObjectName(objectType, false);
                    if (!ifExists && this.token.tokenType == 439) {
                        this.read();
                        this.readThis(109);
                        ifExists = true;
                    }
                    Object[] args = new Object[]{name, ifExists};
                    return new StatementSession(33, args);
                }
            }
            default: {
                name = this.readNewSchemaObjectName(objectType, false);
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                object = this.database.schemaManager.findSchemaObject(name.name, name.schema.name, name.type);
            }
        }
        if (!ifExists && useIfExists && this.token.tokenType == 439) {
            this.read();
            this.readThis(109);
            ifExists = true;
        }
        if (canCascade) {
            if (this.token.tokenType == 369) {
                cascade = true;
                this.read();
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(396);
                }
            } else if (this.token.tokenType == 526) {
                this.read();
            }
        }
        if (object == null) {
            writeLockNames = null;
        } else {
            if (objectType != 24) {
                name = object.getName();
            }
            writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(name);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, objectType, cascade, ifExists};
        StatementSchema cs = new StatementSchema(sql, statementType, args, null, writeLockNames);
        return cs;
    }

    Statement compileAlterTable() {
        Table t;
        boolean ifExists = false;
        this.readThis(294);
        if (this.token.tokenType == 439) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 109) {
                this.read();
                ifExists = true;
            } else {
                this.rewind(position);
            }
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        if (name.schema == null) {
            name.schema = this.session.getCurrentSchemaHsqlName();
        }
        if ((t = ifExists ? this.database.schemaManager.findUserTable(name.name, name.schema.name) : this.database.schemaManager.getUserTable(name)) != null) {
            name = t.getName();
            this.checkSchemaUpdateAuthorisation(name.schema);
        }
        if (ifExists && this.token.tokenType != 677) {
            this.unexpectedToken(439);
        }
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                if (this.database.sqlSyntaxPgs && this.token.tokenType != 301) {
                    if (this.token.tokenType == 46) {
                        this.read();
                    }
                    this.checkIsIdentifier();
                    int columnIndex = t.getColumnIndex(this.token.tokenString);
                    ColumnSchema column = t.getColumn(columnIndex);
                    this.read();
                    this.readThis(301);
                    return this.compileAlterColumnRename(t, column);
                }
                this.readThis(301);
                return this.compileRenameObject(name, 3, ifExists);
            }
            case 356: {
                this.read();
                HsqlNameManager.HsqlName cname = null;
                Boolean ifNotExists = Boolean.FALSE;
                if (this.token.tokenType == 51) {
                    this.read();
                    ifNotExists = this.readIfNotExists();
                    cname = this.readNewDependentSchemaObjectName(t.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 121: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableAddForeignKeyConstraint(t, cname, ifNotExists);
                    }
                    case 315: {
                        this.read();
                        if (this.database.sqlSyntaxMys && !this.readIfThis(644)) {
                            this.readIfThis(463);
                        }
                        return this.compileAlterTableAddUniqueConstraint(t, cname, ifNotExists);
                    }
                    case 40: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(t, cname, ifNotExists);
                    }
                    case 228: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableAddPrimaryKey(t, cname, ifNotExists);
                    }
                    case 220: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        return this.compileAlterTableAddPeriod(t);
                    }
                    case 291: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readThis(331);
                        return this.compileAlterTableAddVersioning(t);
                    }
                    case 46: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(t);
                    }
                }
                if (cname != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(t);
            }
            case 93: {
                this.read();
                switch (this.token.tokenType) {
                    case 228: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableDropPrimaryKey(t);
                    }
                    case 51: {
                        this.read();
                        return this.compileAlterTableDropConstraint(t);
                    }
                    case 220: {
                        this.read();
                        this.readThis(120);
                        return this.compileAlterTableDropPeriod(t);
                    }
                    case 291: {
                        this.read();
                        this.readThis(331);
                        return this.compileAlterTableDropVersioning(t);
                    }
                    case 46: {
                        this.read();
                        return this.compileAlterTableDropColumn(t);
                    }
                }
                return this.compileAlterTableDropColumn(t);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 46) {
                    this.read();
                }
                int columnIndex = t.getColumnIndex(this.token.tokenString);
                ColumnSchema column = t.getColumn(columnIndex);
                this.read();
                return this.compileAlterColumn(t, column, columnIndex);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean cascade = false;
        SchemaObject object = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            cascade = true;
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName mainTableName = ((Constraint)object).getMainTableName();
        if (mainTableName != null && mainTableName != table.getName()) {
            writeLockNames = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(writeLockNames, mainTableName, writeLockNames.length, 1);
        }
        StatementSchema cs = new StatementSchema(sql, 1130, args, null, writeLockNames);
        return cs;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean cascade = false;
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            cascade = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String sql = this.getLastPart();
        Constraint object = table.getPrimaryConstraint();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema cs = new StatementSchema(sql, 1130, args, null, writeLockNames);
        return cs;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        StatementSchema cs;
        boolean isSession;
        int position = this.getPosition();
        int tableType = 3;
        try {
            this.readThis(82);
            this.readThis(167);
            this.readThis(566);
            this.readThis(294);
        }
        catch (HsqlException e) {
            this.lastError = e;
            this.rewind(position);
            return null;
        }
        boolean bl = isSession = this.token.namePrePrefix == null && (this.token.namePrefix == null || "SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
        if (!isSession) {
            throw this.unexpectedToken();
        }
        boolean ifNot = this.readIfNotExists();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.schema = SqlInvariants.SESSION_SCHEMA_HSQLNAME;
        Table table = new Table(this.database, name, tableType);
        if (this.token.tokenType == 11) {
            cs = this.compileCreateTableAsSubqueryDefinition(table, ifNot);
        } else {
            cs = this.compileCreateTableBody(table, ifNot);
            HsqlArrayList constraints = (HsqlArrayList)cs.arguments[1];
            for (int i = 0; i < constraints.size(); ++i) {
                Constraint c = (Constraint)constraints.get(i);
                if (c.getConstraintType() != 0) continue;
                throw this.unexpectedToken("FOREIGN");
            }
        }
        StatementSession ss = new StatementSession(1119, cs.arguments);
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSchema compileCreateView(boolean alter, boolean orReplace) {
        QueryExpression queryExpression;
        this.read();
        Boolean ifNotExists = Boolean.FALSE;
        if (!alter) {
            ifNotExists = this.readIfNotExists();
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(4, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        HsqlNameManager.HsqlName[] colList = null;
        if (this.token.tokenType == 937) {
            colList = this.readColumnNames(name);
        }
        this.readThis(11);
        ParserBase.Recorder recorder = this.startRecording();
        try {
            this.isViewDefinition = true;
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        finally {
            this.isViewDefinition = false;
        }
        int check = 0;
        if (this.token.tokenType == 337) {
            this.read();
            check = 2;
            if (this.readIfThis(167)) {
                check = 1;
            } else {
                this.readIfThis(31);
            }
            this.readThis(40);
            this.readThis(494);
        }
        View view = new View(this.database, name, colList, check);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        String statementSQL = recorder.getSQL();
        view.setStatement(statementSQL);
        StatementQuery s = new StatementQuery(this.session, queryExpression, this.compileContext);
        String fullSQL = this.getLastPart();
        Object[] args = new Object[]{view, ifNotExists};
        int type = alter ? 1122 : 96;
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(fullSQL, type, args, s.readTableNames, writeLockNames);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        Boolean ifNotExists = this.readIfNotExists();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(7, false);
        NumberSequence sequence = new NumberSequence(name, Type.SQL_INTEGER);
        this.readSequenceOptions(sequence, true, false, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 71, args, null, writeLockNames);
    }

    StatementSchema compileCreateDomain() {
        boolean end;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(13, false);
        this.readIfThis(11);
        Type type = this.readTypeDefinition(true, false).duplicate();
        Expression defaultClause = null;
        if (this.readIfThis(83)) {
            defaultClause = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(name, 13, type);
        userTypeModifier.setDefaultClause(defaultClause);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList tempConstraints = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            end = false;
            switch (this.token.tokenType) {
                case 40: 
                case 51: {
                    this.readConstraint(type, tempConstraints);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        this.compileContext.currentDomain = null;
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Constraint c = (Constraint)tempConstraints.get(i);
            c.prepareDomainCheckConstraint(this.session);
            userTypeModifier.addConstraint(c);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 23, args, null, writeLockNames);
    }

    StatementSchema compileCreateType(boolean orReplace) {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(12, false);
        this.readThis(11);
        Type type = this.readTypeDefinition(true, false).duplicate();
        this.readIfThis(426);
        type.userTypeModifier = new UserTypeModifier(name, 12, type);
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 94, args, null, writeLockNames);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(268);
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(14, false);
        this.readIfThis(11);
        this.readThis(128);
        String schema = this.token.namePrefix;
        Charset source = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, schema);
        this.read();
        if (this.token.tokenType == 380) {
            this.read();
            this.readThis(124);
            this.readThis(83);
        }
        Charset charset = new Charset(name, source.getName());
        String sql = this.getLastPart();
        Object[] args = new Object[]{charset};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 11, args, null, writeLockNames);
    }

    StatementSchema compileCreateCollation() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(15, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(120);
        HsqlNameManager.HsqlName charsetName = this.readNewSchemaObjectName(14, false);
        this.readThis(124);
        HsqlNameManager.HsqlName sourceName = this.readNewSchemaObjectName(15, false);
        Boolean padSpace = null;
        if (this.readIfThis(190)) {
            this.readThis(503);
            padSpace = Boolean.FALSE;
        } else if (this.readIfThis(503)) {
            this.readThis(557);
            padSpace = Boolean.TRUE;
        }
        String schemaName = charsetName.schema == null ? null : charsetName.schema.name;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, charsetName.name, schemaName);
        if (charset == null) {
            throw Error.error(5501, charsetName.getSchemaQualifiedStatementName());
        }
        schemaName = sourceName.schema == null ? null : sourceName.schema.name;
        Collation source = this.database.schemaManager.getCollation(this.session, sourceName.name, schemaName);
        Collation collation = new Collation(name, source, charset, padSpace);
        String sql = this.getLastPart();
        Object[] args = new Object[]{collation};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 13, args, null, writeLockNames);
    }

    StatementSchema compileCreateAlias() {
        String alias;
        HsqlNameManager.HsqlName name = null;
        Routine[] routines = null;
        String methodFQN = null;
        if (!this.session.isProcessingScript()) {
            throw this.unsupportedFeature();
        }
        this.read();
        try {
            alias = this.token.tokenString;
            this.read();
            this.readThis(120);
            methodFQN = this.token.tokenString;
            this.read();
        }
        catch (HsqlException e) {
            alias = null;
        }
        if (alias != null) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            name = this.database.nameManager.newHsqlName(schema, alias, 16);
            Method[] methods = Routine.getMethods(methodFQN);
            routines = Routine.newRoutines(this.session, methods);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, routines};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1124, args, null, writeLockNames);
    }

    StatementSchema compileCreateIndex(boolean unique) {
        this.read();
        Boolean ifNotExists = this.readIfNotExists();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        if (this.database.sqlSyntaxMys && this.readIfThis(322) && !this.readIfThis("HASH")) {
            this.readThis("BTREE");
        }
        this.readThis(204);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName tableSchema = table.getSchemaName();
        indexHsqlName.setSchemaIfNull(tableSchema);
        indexHsqlName.parent = table.getName();
        if (indexHsqlName.schema != tableSchema) {
            throw Error.error(5505);
        }
        indexHsqlName.schema = table.getSchemaName();
        int[] indexColumns = this.readColumnList(table, true);
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(322) && !this.readIfThis("HASH")) {
                this.readThis("BTREE");
            }
            if (this.readIfThis(619)) {
                indexHsqlName.comment = this.readQuotedString();
            }
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, indexColumns, indexHsqlName, unique, null, ifNotExists};
        return new StatementSchema(sql, 1125, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean swapped;
        Grantee owner;
        HsqlNameManager.HsqlName schemaName = null;
        String authorisation = null;
        HsqlNameManager.HsqlName characterSetName = null;
        this.read();
        Boolean ifNotExists = this.readIfNotExists();
        if (this.token.tokenType != 16) {
            schemaName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 16) {
            this.read();
            this.checkIsSimpleName();
            authorisation = this.token.tokenString;
            this.read();
            if (schemaName == null) {
                owner = this.database.getGranteeManager().get(authorisation);
                if (owner == null) {
                    throw Error.error(4001, authorisation);
                }
                schemaName = this.database.nameManager.newHsqlName(owner.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(authorisation)) {
            throw Error.error(4002, authorisation);
        }
        Grantee grantee = owner = authorisation == null ? this.session.getGrantee() : this.database.getGranteeManager().get(authorisation);
        if (owner == null) {
            throw Error.error(4001, authorisation);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (owner instanceof User && ((User)owner).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (!(!this.database.schemaManager.schemaExists(schemaName.name) || this.session.isProcessingScript() && "PUBLIC".equals(schemaName.name) || ifNotExists.booleanValue())) {
            throw Error.error(5504, schemaName.name);
        }
        if (schemaName.name.equals("SYSTEM_LOBS")) {
            schemaName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            owner = schemaName.owner;
        }
        if (this.readIfThis(83)) {
            this.readThis(38);
            this.readThis(268);
            characterSetName = this.readNewSchemaObjectName(14, false);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{schemaName, owner, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema cs = new StatementSchema(sql, 68, args, null, writeLockNames);
        cs.setSchemaHsqlName(schemaName);
        HsqlArrayList<StatementSchema> list = new HsqlArrayList<StatementSchema>(128);
        list.add(cs);
        this.getCompiledStatementBody(list);
        StatementSchema[] array = new StatementSchema[list.size()];
        list.toArray(array);
        do {
            swapped = false;
            for (int i = 0; i < array.length - 1; ++i) {
                if (array[i].order <= array[i + 1].order) continue;
                StatementSchema temp = array[i + 1];
                array[i + 1] = array[i];
                array[i] = temp;
                swapped = true;
            }
        } while (swapped);
        return new StatementSchemaDefinition(array);
    }

    void getCompiledStatementBody(List list) {
        boolean end = false;
        while (!end) {
            StatementSchema cs = null;
            int position = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 59: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 315: 
                        case 321: 
                        case 540: {
                            throw this.unexpectedToken();
                        }
                        case 644: {
                            int statementType = 1125;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 548: {
                            cs = this.compileCreateSequence();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 532: {
                            cs = this.compileCreateRole();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 415: {
                            int statementType = 23;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 578: {
                            cs = this.compileCreateType(false);
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 38: {
                            cs = this.compileCreateCharacterSet();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 361: {
                            throw this.unexpectedToken();
                        }
                        case 129: 
                        case 294: 
                        case 566: 
                        case 613: 
                        case 659: 
                        case 688: 
                        case 689: {
                            int statementType = 87;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 307: {
                            int statementType = 90;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 589: {
                            int statementType = 96;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 126: {
                            int statementType = 69;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 229: {
                            int statementType = 69;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 130: {
                    cs = this.compileGrantOrRevoke();
                    cs.sql = this.getLastPart(position);
                    break;
                }
                case 943: {
                    this.read();
                    end = true;
                    break;
                }
                case 1014: {
                    end = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (cs == null) continue;
            cs.isSchemaDefinition = true;
            list.add(cs);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 65, args, null, writeLockNames);
    }

    StatementSchema compileCreateUser() {
        Boolean admin = Boolean.FALSE;
        Boolean isDigest = Boolean.FALSE;
        Grantee grantor = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        this.readThis(668);
        if (this.readIfThis(629)) {
            isDigest = Boolean.TRUE;
        }
        String password = this.readPassword();
        if (this.token.tokenType == 357) {
            this.read();
            admin = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, password, grantor, admin, isDigest};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1126, args, null, writeLockNames);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String tokenS = this.token.tokenString;
        boolean isQuoted = this.isDelimitedIdentifier();
        if (tokenS.equalsIgnoreCase("SA")) {
            tokenS = "SA";
            isQuoted = false;
        }
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(tokenS, isQuoted, 11);
        this.read();
        return name;
    }

    String readPassword() {
        String tokenS = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return tokenS;
    }

    StatementSchema compileCreateSynonym(boolean isOrReplace) {
        this.read();
        HsqlNameManager.HsqlName synonymHsqlName = this.readNewSchemaObjectName(29, true);
        this.readThis(120);
        HsqlNameManager.HsqlName targetHsqlName = this.readNewSchemaObjectName(29, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{synonymHsqlName, targetHsqlName};
        return new StatementSchema(sql, 1147, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName()});
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName name, int type, boolean ifExists) {
        HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(type, true);
        String sql = this.getLastPart();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, name);
                break;
            }
            default: {
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, name.schema);
            }
        }
        Object[] args = new Object[]{name, newName, ifExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 1152, args, null, writeLockNames);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName name, Boolean ifNotExists) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        HsqlNameManager.HsqlName indexName = this.session.database.nameManager.newConstraintIndexName(table.getName(), name, this.session.database.sqlSysIndexNames);
        Index index = table.createIndexStructure(indexName, cols, null, null, false, true, true, false);
        Constraint constraint = new Constraint(name, table, index, 2);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, constraint, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName name, Boolean ifNotExists) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint c = this.readFKReferences(table, name, set);
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        c.core.mainTable = this.database.schemaManager.getUserTable(mainTableName);
        c.setColumnsIndexes(table);
        if (c.core.mainCols.length != c.core.refCols.length) {
            throw Error.error(5593);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, c, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (mainTableName != table.getName()) {
            writeLockNames = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(writeLockNames, mainTableName, writeLockNames.length, 1);
        }
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name, Boolean ifNotExists) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint check = new Constraint(name, null, 3);
        this.readCheckConstraintCondition(check);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, check, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int colIndex = table.getColumnCount();
        HsqlArrayList<Constraint> list = new HsqlArrayList<Constraint>();
        Constraint constraint = new Constraint(null, null, 5);
        Boolean ifNotExists = this.readIfNotExists();
        list.add(constraint);
        this.checkIsSimpleName();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema column = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (column == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 365) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1133, table, column, colIndex, list, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName name, Boolean ifNotExists) {
        if (name == null) {
            name = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint constraint = new Constraint(name, set, 4);
        constraint.setColumnsIndexes(table);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1134, table, constraint, ifNotExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterTableDropColumn(Table table) {
        boolean cascade = false;
        this.checkIsSimpleName();
        String colName = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            cascade = true;
        }
        int colindex = table.getColumnIndex(colName);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table.getColumn(colindex).getName(), ValuePool.getInt(9), cascade, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 1128, args, null, writeLockNames);
    }

    Statement compileAlterColumn(Table table, ColumnSchema column, int columnIndex) {
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileAlterColumnRename(table, column);
            }
            case 93: {
                this.read();
                if (this.token.tokenType == 83) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1141, table, column, columnIndex};
                    return new StatementSchema(sql, 7, args, null, writeLockNames);
                }
                if (this.token.tokenType == 425) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1142, table, column, columnIndex};
                    return new StatementSchema(sql, 7, args, null, writeLockNames);
                }
                if (this.token.tokenType == 434 || this.token.tokenType == 138) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1143, table, column, columnIndex};
                    return new StatementSchema(sql, 7, args, null, writeLockNames);
                }
                if (this.token.tokenType == 193) {
                    this.read();
                    this.readThis(196);
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1139, table, column, Boolean.TRUE};
                    return new StatementSchema(sql, 7, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 268: {
                this.read();
                switch (this.token.tokenType) {
                    case 400: {
                        this.read();
                        this.readThis(578);
                        return this.compileAlterColumnDataType(table, column);
                    }
                    case 83: {
                        this.read();
                        return this.compileAlterColumnDefault(table, column, columnIndex);
                    }
                    case 193: {
                        this.read();
                        this.readThis(196);
                        return this.compileAlterColumnSetNullability(table, column, false);
                    }
                    case 196: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, column, true);
                    }
                    case 434: {
                        return this.compileAlterColumnAddSequence(table, column, columnIndex);
                    }
                }
                this.rewind(position);
                this.read();
                break;
            }
            case 578: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                return this.compileAlterColumnDataType(table, column);
            }
            case 434: {
                return this.compileAlterColumnAddSequence(table, column, columnIndex);
            }
        }
        if (this.token.tokenType == 268 || this.token.tokenType == 525) {
            if (!column.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, column, columnIndex);
        }
        return this.compileAlterColumnDataTypeIdentity(table, column);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence sequence = column.getIdentitySequence();
        Type type = column.getDataType();
        if (this.token.tokenType == 138) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (sequence == null) {
                sequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(true, true);
            switch (this.token.tokenType) {
                case 138: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (sequence != null) break;
                    sequence = new NumberSequence(null, type);
                    break;
                }
                case 434: {
                    sequence = this.readSequence(table, column, true);
                    break;
                }
                default: {
                    sequence = null;
                }
            }
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1144, table, column, type, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(true, true);
        if (column.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1136, table, column, type};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema column, boolean nullable) {
        String sql = this.getLastPart();
        Object[] args = new Object[]{1139, table, column, nullable};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    private Statement compileAlterColumnDefault(Table table, ColumnSchema column, int columnIndex) {
        Type type = column.getDataType();
        Expression expr = this.readDefaultClause(type);
        String sql = this.getLastPart();
        int statementType = 1140;
        Object argObject = expr;
        if (expr.opType == 12) {
            statementType = 1137;
            argObject = ((ExpressionColumn)expr).sequence;
        }
        Object[] args = new Object[]{statementType, table, column, columnIndex, argObject};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema.name, true);
        this.read();
        if (this.token.tokenType == 677) {
            this.read();
            this.readThis(301);
            return this.compileRenameObject(sequence.getName(), 7, false);
        }
        this.checkSchemaUpdateAuthorisation(this.session, sequence.getName().schema);
        NumberSequence copy = sequence.duplicate();
        this.readSequenceOptions(copy, false, true, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, copy};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 5, args, null, writeLockNames);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema column, int colIndex) {
        if (!column.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (column.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence sequence = this.readSequence(table, column, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1137, table, column, colIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    NumberSequence readSequence(Table table, ColumnSchema column, boolean withType) {
        this.readThis(434);
        NumberSequence sequence = new NumberSequence(null, column.getDataType());
        boolean generatedAlways = false;
        if (this.token.tokenType == 27) {
            this.read();
            this.readThis(83);
        } else {
            this.readThis(359);
            generatedAlways = true;
        }
        this.readThis(11);
        if (!withType && this.token.tokenType == 548) {
            if (generatedAlways) {
                throw this.unexpectedToken();
            }
            this.read();
            if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                throw this.unexpectedToken(this.token.namePrefix);
            }
            sequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
            this.read();
        } else {
            this.readThis(138);
            sequence.setAlways(generatedAlways);
            if (this.token.tokenType == 937) {
                this.read();
                this.readSequenceOptions(sequence, false, false, false);
                this.readThis(922);
            }
            sequence.checkValues();
        }
        return sequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema column, int columnIndex) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        NumberSequence sequence = column.getIdentitySequence().duplicate();
        do {
            end = false;
            block0 : switch (this.token.tokenType) {
                case 525: {
                    long value;
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(337)) {
                        value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.reset();
                    break;
                }
                case 268: {
                    long value;
                    this.read();
                    switch (this.token.tokenType) {
                        case 444: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(27);
                            value = this.readBigint();
                            sequence.setIncrement(value);
                            break block0;
                        }
                        case 190: {
                            this.read();
                            if (this.token.tokenType == 475) {
                                sequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 479) {
                                sequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 76) {
                                sequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 475: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMaxValueNoCheck(value);
                            break block0;
                        }
                        case 479: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMinValueNoCheck(value);
                            break block0;
                        }
                        case 76: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            sequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
        String sql = this.getLastPart();
        Object[] args = new Object[]{1137, table, column, columnIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 7, args, null, writeLockNames);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema column) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(name.name) > -1) {
            throw Error.error(5504, name.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), column.getName());
        String sql = this.getLastPart();
        Object[] args = new Object[]{column.getName(), name, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 1152, args, null, writeLockNames);
    }

    Statement compileRenameSchema(HsqlNameManager.HsqlName name, int type) {
        HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(type, true);
        String sql = this.getLastPart();
        this.checkSchemaUpdateAuthorisation(this.session, name);
        Object[] args = new Object[]{name, newName, Boolean.FALSE};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 1153, args, null, writeLockNames);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName userName = this.readNewUserIdentifier();
        User userObject = this.database.getUserManager().get(userName.name);
        if (userName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        if (userName.name.equals("_SYSTEM")) {
            throw Error.error(5503);
        }
        this.readThis(268);
        switch (this.token.tokenType) {
            case 167: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{userObject, mode};
                return new StatementCommand(1091, args);
            }
            case 668: {
                this.read();
                boolean isDigest = false;
                if (this.readIfThis(629)) {
                    isDigest = Boolean.TRUE;
                }
                String password = this.readPassword();
                Object[] args = new Object[]{userObject, password, isDigest};
                StatementCommand cs = new StatementCommand(1093, args);
                String sql = userObject.getSetUserPasswordDigestSQL(password, isDigest);
                cs.setSQL(sql);
                return cs;
            }
            case 647: {
                this.read();
                this.readThis(540);
                HsqlNameManager.HsqlName schemaName = this.token.tokenType == 83 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{userObject, schemaName};
                return new StatementCommand(1092, args);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Type domain = this.database.schemaManager.getDomain(this.token.tokenString, schema.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(domain.getName(), 13, false);
            }
            case 93: {
                this.read();
                if (this.token.tokenType == 83) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1132, domain};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                if (this.token.tokenType == 51) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaObjectName(domain.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1130, domain, name};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 268: {
                this.read();
                this.readThis(83);
                Expression e = this.readDefaultClause(domain);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1135, domain, e};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
            case 356: {
                this.read();
                if (this.token.tokenType != 51 && this.token.tokenType != 40) break;
                HsqlArrayList tempConstraints = new HsqlArrayList();
                this.compileContext.currentDomain = domain;
                this.readConstraint(domain, tempConstraints);
                this.compileContext.currentDomain = null;
                Constraint c = (Constraint)tempConstraints.get(0);
                c.prepareDomainCheckConstraint(this.session);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1134, domain, c};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(domain.getName());
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterView() {
        int position = this.getPosition();
        this.read();
        String tableName = this.token.tokenString;
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Table t = this.database.schemaManager.getUserTable(tableName, schema.name);
        this.read();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(t.getName(), 4, false);
            }
            case 11: {
                this.rewind(position);
                return this.compileCreateView(true, false);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 84: 
            case 108: 
            case 145: 
            case 236: 
            case 265: 
            case 319: 
            case 584: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean grant = this.token.tokenType == 130;
        this.read();
        if (this.isGrantToken() || !grant && (this.token.tokenType == 130 || this.token.tokenType == 438)) {
            return this.compileRightGrantOrRevoke(grant);
        }
        return this.compileRoleGrantOrRevoke(grant);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean grant) {
        OrderedHashSet<String> granteeList = new OrderedHashSet<String>();
        Grantee grantor = null;
        Right right = null;
        HsqlNameManager.HsqlName objectName = null;
        boolean isTable = false;
        boolean isUsage = false;
        boolean isExec = false;
        boolean isAll = false;
        boolean isGrantOption = false;
        boolean isFilter = false;
        boolean cascade = false;
        if (!grant) {
            if (this.token.tokenType == 130) {
                this.read();
                this.readThis(494);
                this.readThis(120);
                isGrantOption = true;
            } else if (this.token.tokenType == 438) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 519) {
                this.read();
            }
            right = Right.fullRights;
            isAll = true;
        } else {
            right = new Right();
            boolean loop = true;
            block22: while (loop) {
                this.checkIsUndelimitedIdentifier();
                int rightType = GranteeManager.getCheckSingleRight(this.token.tokenString);
                int tokenType = this.token.tokenType;
                OrderedHashSet columnSet = null;
                this.read();
                switch (tokenType) {
                    case 145: 
                    case 236: 
                    case 265: 
                    case 319: {
                        if (this.token.tokenType == 937) {
                            columnSet = this.readColumnNames(false);
                        }
                    }
                    case 84: {
                        right.set(rightType, columnSet);
                        isTable = true;
                        if (!grant || tokenType == 236) break;
                        ParserBase.Recorder recorder = this.startRecording();
                        Expression filter = this.XreadFilterExpressionOrNull();
                        if (filter == null) break;
                        String sql = recorder.getSQL();
                        right.setFilterExpression(rightType, filter, sql);
                        isFilter = true;
                        break;
                    }
                    case 307: {
                        right.set(rightType, null);
                        isTable = true;
                        break;
                    }
                    case 584: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isUsage = true;
                        loop = false;
                        continue block22;
                    }
                    case 108: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isExec = true;
                        loop = false;
                        continue block22;
                    }
                }
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        this.readThis(204);
        int objectType = 0;
        switch (this.token.tokenType) {
            case 617: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                objectType = 16;
                break;
            }
            case 273: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 126: 
                    case 229: 
                    case 533: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                objectType = 24;
                break;
            }
            case 126: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 16;
                break;
            }
            case 229: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 17;
                break;
            }
            case 533: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 18;
                break;
            }
            case 578: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 12;
                break;
            }
            case 415: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 13;
                break;
            }
            case 548: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 7;
                break;
            }
            case 38: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(268);
                objectType = 14;
                break;
            }
            case 2: {
                this.read();
                if (this.readIfThis("SEQUENCES")) {
                    if (!isUsage && !isAll) {
                        throw this.unexpectedToken("SEQUENCES");
                    }
                    right = new Right();
                    right.set(16, null);
                } else if (this.readIfThis("ROUTINES")) {
                    if (!isExec && !isAll) {
                        throw this.unexpectedToken("ROUTINES");
                    }
                    right = new Right();
                    right.set(32, null);
                } else {
                    if (!isTable && !isAll) {
                        throw this.unexpectedToken();
                    }
                    this.readThis("TABLES");
                }
                this.readThis(140);
                this.readThis(540);
                objectType = 2;
                break;
            }
            default: {
                if (!isTable && !isAll) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(294);
                objectType = 3;
            }
        }
        objectName = this.readNewSchemaObjectName(objectType, false);
        if (grant) {
            if (objectType == 3 && !isFilter) {
                ParserBase.Recorder recorder = this.startRecording();
                Expression filter = this.XreadFilterExpressionOrNull();
                if (filter != null) {
                    String sql = recorder.getSQL();
                    right.setFilterExpression(filter, sql);
                }
            }
            this.readThis(301);
        } else {
            this.readThis(124);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (grant) {
            if (this.token.tokenType == 337) {
                this.read();
                this.readThis(130);
                this.readThis(494);
                isGrantOption = true;
            }
            if (this.token.tokenType == 437) {
                this.read();
                this.readThis(27);
                if (this.token.tokenType == 74) {
                    this.read();
                } else {
                    this.readThis(68);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantor = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 369) {
            cascade = true;
            this.read();
        } else {
            this.readThis(526);
        }
        String sql = this.getLastPart();
        int type = grant ? 53 : 63;
        Object[] args = new Object[]{granteeList, objectName, right, grantor, cascade, isGrantOption};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean grant) {
        Grantee grantor = this.session.getGrantee();
        OrderedHashSet<String> roleList = new OrderedHashSet<String>();
        OrderedHashSet<String> granteeList = new OrderedHashSet<String>();
        boolean cascade = false;
        if (!grant && this.token.tokenType == 357) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            roleList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (grant) {
            this.readThis(301);
        } else {
            this.readThis(124);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (grant && this.token.tokenType == 337) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 437) {
            this.read();
            this.readThis(27);
            if (this.token.tokenType == 74) {
                this.read();
            } else {
                this.readThis(68);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantor = this.session.getRole();
            }
        }
        if (!grant) {
            if (this.token.tokenType == 369) {
                cascade = true;
                this.read();
            } else {
                this.readThis(526);
            }
        }
        String sql = this.getLastPart();
        int type = grant ? 54 : 64;
        Object[] args = new Object[]{granteeList, roleList, grantor, cascade};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            throw Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema);
        session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        int type;
        this.readThis(619);
        this.readThis(204);
        switch (this.token.tokenType) {
            case 548: {
                type = 7;
                break;
            }
            case 307: {
                type = 8;
                break;
            }
            case 533: {
                type = 18;
                break;
            }
            case 294: {
                type = 3;
                break;
            }
            case 46: {
                type = 9;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.read();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, type);
        if (type == 9) {
            if (this.token.namePrefix == null) {
                throw Error.error(5501);
            }
            name.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
            name.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 2);
        } else {
            name.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
        }
        this.read();
        this.readThis(152);
        String comment = this.readQuotedString();
        Object[] arguments = new Object[]{name, comment};
        return new StatementSchema(null, 1123, arguments, null, null);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 678) {
            this.read();
            int action = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 250: {
                    this.read();
                    this.readThis(553);
                    break;
                }
                case 294: {
                    this.read();
                    this.readThis(400);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] args = new Object[]{this.session.getId(), action};
            return new StatementCommand(1120, args);
        }
        long sessionID = this.readBigint();
        Session targetSession = this.database.sessionManager.getSession(sessionID);
        if (targetSession == null) {
            throw Error.error(4500);
        }
        int action = this.token.tokenType;
        switch (this.token.tokenType) {
            case 42: {
                this.read();
                break;
            }
            case 247: {
                this.read();
                break;
            }
            case 99: {
                this.read();
                this.readThis(560);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{sessionID, action};
        return new StatementCommand(1120, args);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 310) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 114) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }
}

