/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementInsert;
import org.hsqldb.StatementProcedure;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserDML
extends ParserDQL {
    ParserDML(Session session, Scanner scanner) {
        super(session, scanner, null);
    }

    StatementDMQL compileInsertStatement(RangeGroup[] rangeGroups) {
        boolean[] updateColumnCheckList = null;
        int[] updateColumnMap = ValuePool.emptyIntArray;
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentityOrGenerated = false;
        boolean hasColumnList = false;
        int isSpecial = 0;
        Expression[] updateExpressions = Expression.emptyArray;
        Expression[] targets = null;
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(799)) {
                isSpecial = 2;
            }
            if (isSpecial == 0) {
                this.readThis(145);
                if (this.readIfThis(440)) {
                    isSpecial = 1;
                }
            }
            this.readIfThis(151);
        } else {
            this.readThis(145);
            this.readThis(151);
        }
        Token tableToken = this.getRecordedToken();
        RangeVariable targetRange = this.readRangeVariableForDataChange(55);
        targetRange.resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        RangeVariable[] rangeVariables = new RangeVariable[]{targetRange};
        Table table = targetRange.getTable();
        boolean[] insertColumnCheckList = null;
        int[] insertColumnMap = table.getColumnMap();
        int colCount = table.getColumnCount();
        int position = this.getPosition();
        Table baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        switch (this.token.tokenType) {
            case 83: {
                this.read();
                this.readThis(325);
                Expression row = new Expression(25, Expression.emptyArray);
                Expression insertExpressions = new Expression(26, new Expression[]{row});
                insertColumnCheckList = table.getNewColumnCheckList();
                StatementInsert cs = new StatementInsert(this.session, table, rangeVariables, insertColumnMap, insertExpressions, insertColumnCheckList, updateExpressions, updateColumnCheckList, updateColumnMap, null, isSpecial, this.compileContext);
                return cs;
            }
            case 937: {
                int brackets = this.readOpenBrackets();
                if (brackets == 1) {
                    boolean isQuery = false;
                    switch (this.token.tokenType) {
                        case 265: 
                        case 294: 
                        case 337: {
                            this.rewind(position);
                            isQuery = true;
                            break;
                        }
                    }
                    if (isQuery) break;
                    OrderedHashSet columnNames = new OrderedHashSet();
                    boolean withPrefix = this.database.sqlSyntaxOra;
                    this.readSimpleColumnNames(columnNames, targetRange, withPrefix);
                    this.readThis(922);
                    colCount = columnNames.size();
                    insertColumnMap = table.getColumnIndexes(columnNames);
                    hasColumnList = true;
                    break;
                }
                this.rewind(position);
                break;
            }
        }
        if (this.token.tokenType == 501) {
            this.read();
            if (this.token.tokenType == 321) {
                this.read();
                overridingUser = true;
            } else if (this.token.tokenType == 291) {
                this.read();
                overridingSystem = true;
            } else {
                throw this.unexpectedToken();
            }
            this.readThis(323);
        }
        switch (this.token.tokenType) {
            case 323: {
                if (!this.database.sqlSyntaxMys) {
                    throw this.unexpectedToken();
                }
            }
            case 325: {
                this.read();
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                List unresolved = insertExpressions.resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, insertColumnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[insertColumnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, insertColumnMap, newColumnMap);
                    insertColumnMap = newColumnMap;
                }
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(insertColumnMap[i]);
                        Type colType = column.getDataType();
                        if (column.isIdentity()) {
                            assignsToIdentityOrGenerated = true;
                            if (e.getType() != 4) {
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                } else if (!overridingSystem && baseTable.identitySequence.isAlways()) {
                                    throw Error.error(5542);
                                }
                            }
                        } else if (!column.hasDefault() && (column.isGenerated() || column.isSystemPeriod())) {
                            assignsToIdentityOrGenerated = true;
                            if (e.getType() != 4) {
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                } else {
                                    throw Error.error(5543);
                                }
                            }
                        }
                        if (e.isUnresolvedParam()) {
                            e.setAttributesAsColumn(column);
                        }
                        if (e.opType == 4 || e.dataType != null && !colType.isArrayType() && colType.typeDataGroup == e.dataType.typeDataGroup) continue;
                        rowArgs[i] = ExpressionOp.getConvertExpression(this.session, e, colType);
                    }
                }
                if (!assignsToIdentityOrGenerated && (overridingUser || overridingSystem)) {
                    throw this.unexpectedToken("OVERRIDING");
                }
                if (!hasColumnList) {
                    tableToken.setWithColumnList();
                }
                if (this.database.sqlSyntaxMys && isSpecial == 0 && this.readIfThis(204)) {
                    this.readThis(859);
                    this.readThis(463);
                    this.readThis(319);
                    OrderedHashSet targetSet = new OrderedHashSet();
                    LongDeque colIndexList = new LongDeque();
                    HsqlArrayList exprList = new HsqlArrayList();
                    RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
                    RangeVariable valueRange = new RangeVariable(targetRange.getTable(), 2);
                    isSpecial = 3;
                    this.readOnDuplicateClauseList(rangeVariables, targetSet, colIndexList, exprList);
                    updateColumnMap = new int[colIndexList.size()];
                    colIndexList.toArray(updateColumnMap);
                    targets = new Expression[targetSet.size()];
                    targetSet.toArray(targets);
                    for (int i = 0; i < targets.length; ++i) {
                        this.resolveReferencesAndTypes(rangeGroup, rangeGroups, targets[i]);
                    }
                    updateColumnCheckList = table.getColumnCheckList(updateColumnMap);
                    updateExpressions = new Expression[exprList.size()];
                    exprList.toArray(updateExpressions);
                    this.resolveUpdateExpressions(table, rangeGroup, updateColumnMap, targets, updateExpressions, rangeGroups, valueRange);
                }
                StatementInsert cs = new StatementInsert(this.session, table, rangeVariables, insertColumnMap, insertExpressions, insertColumnCheckList, updateExpressions, updateColumnCheckList, updateColumnMap, targets, isSpecial, this.compileContext);
                return cs;
            }
            case 265: 
            case 294: 
            case 337: 
            case 937: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[insertColumnMap.length];
            ArrayUtil.projectRow(baseColumnMap, insertColumnMap, newColumnMap);
            insertColumnMap = newColumnMap;
        }
        int enforcedDefaultIndex = baseTable.getIdentityColumnIndex();
        int overrideIndex = -1;
        if (enforcedDefaultIndex != -1 && ArrayUtil.find(insertColumnMap, enforcedDefaultIndex) > -1) {
            if (baseTable.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
            if (overridingUser) {
                overrideIndex = enforcedDefaultIndex;
            }
        } else if (overridingUser || overridingSystem) {
            throw this.unexpectedToken("OVERRIDING");
        }
        Object[] types = new Type[insertColumnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), insertColumnMap, types);
        this.compileContext.setOuterRanges(rangeGroups);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, rangeGroups, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        if (!hasColumnList) {
            tableToken.setWithColumnList();
        }
        if (this.database.sqlSyntaxMys && isSpecial == 0 && this.readIfThis(204)) {
            this.readThis(859);
            this.readThis(463);
            this.readThis(319);
            OrderedHashSet targetSet = new OrderedHashSet();
            LongDeque colIndexList = new LongDeque();
            HsqlArrayList exprList = new HsqlArrayList();
            RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
            RangeVariable valueRange = new RangeVariable(targetRange.getTable(), 2);
            isSpecial = 3;
            this.readOnDuplicateClauseList(rangeVariables, targetSet, colIndexList, exprList);
            updateColumnMap = new int[colIndexList.size()];
            colIndexList.toArray(updateColumnMap);
            targets = new Expression[targetSet.size()];
            targetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveReferencesAndTypes(rangeGroup, rangeGroups, targets[i]);
            }
            updateColumnCheckList = table.getColumnCheckList(updateColumnMap);
            updateExpressions = new Expression[exprList.size()];
            exprList.toArray(updateExpressions);
            this.resolveUpdateExpressions(table, rangeGroup, updateColumnMap, targets, updateExpressions, rangeGroups, valueRange);
        }
        StatementInsert cs = new StatementInsert(this.session, table, rangeVariables, insertColumnMap, insertColumnCheckList, queryExpression, updateExpressions, updateColumnCheckList, updateColumnMap, targets, isSpecial, overrideIndex, this.compileContext);
        return cs;
    }

    private static void setParameterTypes(Expression tableExpression, Table table, int[] columnMap) {
        for (int i = 0; i < tableExpression.nodes.length; ++i) {
            Expression[] list = tableExpression.nodes[i].nodes;
            for (int j = 0; j < list.length; ++j) {
                if (!list[j].isUnresolvedParam()) continue;
                list[j].setAttributesAsColumn(table.getColumn(columnMap[j]));
            }
        }
    }

    Statement compileTruncateStatement() {
        boolean isTable = false;
        boolean withCommit = false;
        boolean noCheck = false;
        boolean restartIdentity = false;
        HsqlNameManager.HsqlName objectName = null;
        RangeVariable[] rangeVariables = null;
        TableBase table = null;
        HsqlNameManager.HsqlName[] writeTableNames = null;
        RangeVariable targetRange = null;
        TimestampData timestamp = null;
        this.readThis(311);
        if (this.token.tokenType == 294) {
            this.readThis(294);
            targetRange = this.readRangeVariableForDataChange(1215);
            rangeVariables = new RangeVariable[]{targetRange};
            table = rangeVariables[0].getTable();
            objectName = ((Table)table).getName();
            isTable = true;
        } else {
            this.readThis(540);
            objectName = this.readSchemaName();
        }
        switch (this.token.tokenType) {
            case 398: {
                this.read();
                this.readThis(138);
                break;
            }
            case 525: {
                this.read();
                this.readThis(138);
                restartIdentity = true;
                break;
            }
            case 331: {
                if (!isTable) {
                    throw this.unexpectedToken();
                }
                if (!table.isSystemVersioned()) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(301);
                if (this.readIfThis(298)) {
                    String s = this.readQuotedString();
                    timestamp = (TimestampData)Type.SQL_TIMESTAMP_WITH_TIME_ZONE.convertToType(this.session, s, Type.SQL_VARCHAR_DEFAULT);
                    break;
                }
                this.readThis(72);
                timestamp = this.session.getTransactionUTC();
                break;
            }
        }
        if (!isTable) {
            this.checkIsThis(5);
        }
        if (this.readIfThis(5)) {
            this.readThis(47);
            withCommit = true;
            if (this.readIfThis(190)) {
                this.readThis(40);
                noCheck = true;
            }
        }
        writeTableNames = isTable ? new HsqlNameManager.HsqlName[]{((Table)table).getName()} : this.session.database.schemaManager.getCatalogAndBaseTableNames();
        if (withCommit || timestamp != null) {
            Object[] args = new Object[]{objectName, restartIdentity, noCheck, timestamp};
            return new StatementCommand(1215, args, null, writeTableNames);
        }
        StatementDML cs = new StatementDML(this.session, (Table)table, targetRange, rangeVariables, this.compileContext, restartIdentity, 1215, null);
        return cs;
    }

    Statement compileDeleteStatement(RangeGroup[] rangeGroups) {
        Table baseTable;
        Expression condition = null;
        boolean restartIdentity = false;
        this.readThis(84);
        if (this.database.sqlSyntaxOra) {
            this.readIfThis(124);
        } else {
            this.readThis(124);
        }
        RangeVariable targetRange = this.readRangeVariableForDataChange(19);
        RangeVariable[] rangeVariables = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
        Table table = rangeVariables[0].getTable();
        this.compileContext.setOuterRanges(rangeGroups);
        if (this.token.tokenType == 334) {
            this.read();
            condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
        }
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 649) {
            sortAndSlice = this.XreadOrderByExpression();
        }
        Table table2 = baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        if (table != baseTable) {
            QuerySpecification baseSelect = table.getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(this.session, rangeVariables[0], baseSelect.exprColumns);
            }
            condition = ExpressionLogical.andExpressions(baseSelect.queryCondition, condition);
            rangeVariables = baseSelect.rangeVariables;
            ArrayUtil.fillArray(rangeVariables[0].usedColumns, true);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(this.session, rangeVariables, null, this.compileContext, false);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        for (int i = 0; i < rangeVariables.length; ++i) {
            rangeVariables[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        StatementDML cs = new StatementDML(this.session, table, targetRange, rangeVariables, this.compileContext, restartIdentity, 19, sortAndSlice);
        return cs;
    }

    StatementDMQL compileUpdateStatement(RangeGroup[] rangeGroups) {
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable targetRange = this.readRangeVariableForDataChange(92);
        RangeVariable[] rangeVariables = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
        Table table = rangeVariables[0].rangeTable;
        Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        this.readThis(268);
        this.readSetClauseList(rangeGroups, rangeVariables, targetSet, colIndexList, exprList);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Expression[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveReferencesAndTypes(rangeGroup, rangeGroups, targets[i]);
        }
        boolean[] columnCheckList = table.getColumnCheckList(columnMap);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        Expression condition = null;
        if (this.token.tokenType == 334) {
            this.read();
            condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
        }
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 649) {
            sortAndSlice = this.XreadOrderByExpression();
        }
        this.resolveUpdateExpressions(table, rangeGroup, columnMap, targets, updateExpressions, rangeGroups, null);
        if (table != baseTable) {
            QuerySpecification baseSelect = table.getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(this.session, rangeVariables[0], baseSelect.exprColumns);
            }
            for (int i = 0; i < updateExpressions.length; ++i) {
                updateExpressions[i] = updateExpressions[i].replaceColumnReferences(this.session, rangeVariables[0], baseSelect.exprColumns);
            }
            condition = ExpressionLogical.andExpressions(baseSelect.queryCondition, condition);
            rangeVariables = baseSelect.rangeVariables;
            ArrayUtil.fillArray(rangeVariables[0].usedColumns, true);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(this.session, rangeVariables, null, this.compileContext, false);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        for (int i = 0; i < rangeVariables.length; ++i) {
            rangeVariables[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
            for (int i = 0; i < columnMap.length; ++i) {
                if (!baseTable.colGenerated[columnMap[i]]) continue;
                throw Error.error(5513);
            }
        }
        StatementDML cs = new StatementDML(this.session, targets, table, targetRange, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext, sortAndSlice);
        return cs;
    }

    Expression XreadAndResolveBooleanValueExpression(RangeGroup[] rangeGroups, RangeGroup rangeGroup) {
        Expression condition = this.XreadBooleanValueExpression();
        List unresolved = condition.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        condition.resolveTypes(this.session, null);
        if (condition.isUnresolvedParam()) {
            condition.dataType = Type.SQL_BOOLEAN;
        }
        if (condition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        return condition;
    }

    void resolveUpdateExpressions(Table targetTable, RangeGroup rangeGroup, int[] columnMap, Expression[] targets, Expression[] colExpressions, RangeGroup[] rangeGroups, RangeVariable valuesRange) {
        List unresolved = null;
        int enforcedDefaultIndex = -1;
        if (targetTable.hasIdentityColumn() && targetTable.identitySequence.isAlways()) {
            enforcedDefaultIndex = targetTable.getIdentityColumnIndex();
        }
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression e;
            int j;
            Expression expr = colExpressions[ix];
            if (targetTable.colGenerated[columnMap[i]]) {
                throw Error.error(5513);
            }
            if (expr.getType() == 25) {
                Expression[] elements = expr.nodes;
                j = 0;
                while (j < elements.length) {
                    e = elements[j];
                    if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                        throw Error.error(5541);
                    }
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]));
                    } else if (e.getType() != 4) {
                        unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                        ExpressionColumn.checkColumnsResolved(unresolved);
                        unresolved = null;
                        e.resolveTypes(this.session, null);
                    }
                    ++j;
                    ++i;
                }
            } else if (expr.getType() == 22) {
                unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                expr.resolveTypes(this.session, null);
                int count = expr.table.queryExpression.getColumnCount();
                j = 0;
                while (j < count) {
                    if (enforcedDefaultIndex == columnMap[i]) {
                        throw Error.error(5541);
                    }
                    ++j;
                    ++i;
                }
            } else {
                e = expr;
                if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                    throw Error.error(5541);
                }
                if (e.isUnresolvedParam()) {
                    if (targets.length > i && targets[i].opType == 101) {
                        Type type = targetTable.getColumn(columnMap[i]).getDataType().collectionBaseType();
                        e.setDataType(this.session, type);
                    } else {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]));
                    }
                } else if (e.getType() != 4) {
                    unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                    if (valuesRange != null && unresolved != null) {
                        for (int j2 = unresolved.size() - 1; j2 >= 0; --j2) {
                            ExpressionColumn col = (ExpressionColumn)unresolved.get(j2);
                            col.resolveColumnReference(valuesRange, false);
                            if (col.rangeVariable == null) continue;
                            unresolved.remove(j2);
                        }
                    }
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    e.resolveTypes(this.session, null);
                }
                ++i;
            }
            ++ix;
        }
    }

    void readSetClauseList(RangeGroup[] rangeGroups, RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression e;
            int degree;
            if (this.token.tokenType == 937) {
                this.read();
                int oldCount = targets.size();
                this.readTargetSpecificationList(targets, rangeVars, colIndexList);
                degree = targets.size() - oldCount;
                this.readThis(922);
            } else {
                Expression target = this.XreadTargetSpecification(rangeVars, colIndexList);
                if (!targets.add(target)) {
                    ColumnSchema col = target.getColumn();
                    throw Error.error(5579, col.getName().name);
                }
                degree = 1;
            }
            this.readThis(420);
            int position = this.getPosition();
            int brackets = this.readOpenBrackets();
            if (this.token.tokenType == 265) {
                this.rewind(position);
                this.compileContext.setOuterRanges(rangeGroups);
                TableDerived td = this.XreadSubqueryTableBody(22);
                QueryExpression qe = td.getQueryExpression();
                qe.setReturningResult();
                if (degree != qe.getColumnCount()) {
                    throw Error.error(5546);
                }
                Expression e2 = new Expression(22, td);
                expressions.add(e2);
                if (this.token.tokenType != 924) break;
                this.read();
                continue;
            }
            if (brackets > 0) {
                this.rewind(position);
            }
            if (degree > 1) {
                int rowDegree;
                this.readThis(937);
                e = this.readRow();
                this.readThis(922);
                int n = rowDegree = e.getType() == 25 ? e.nodes.length : 1;
                if (degree != rowDegree) {
                    throw Error.error(5546);
                }
                expressions.add(e);
            } else {
                e = this.XreadValueExpressionWithContext();
                expressions.add(e);
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
    }

    void readOnDuplicateClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression target;
            if (!targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) {
                ColumnSchema col = target.getColumn();
                throw Error.error(5579, col.getName().name);
            }
            this.readThis(420);
            Expression e = this.XreadValueExpressionOnDuplicate();
            expressions.add(e);
            if (this.token.tokenType != 924) break;
            this.read();
        }
    }

    void readGetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression target;
            if (!targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) {
                ColumnSchema col = target.getColumn();
                throw Error.error(5579, col.getName().name);
            }
            this.readThis(420);
            switch (this.token.tokenType) {
                case 480: 
                case 537: {
                    int columnIndex = ExpressionColumn.diagnosticsList.getIndex(this.token.tokenString);
                    ExpressionColumn e = new ExpressionColumn(10, columnIndex);
                    expressions.add(e);
                    this.read();
                    break;
                }
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
    }

    StatementDMQL compileMergeStatement(RangeGroup[] rangeGroups) {
        int opTwo;
        int[] insertColumnMap = null;
        int[] updateColumnMap = null;
        Expression[] targets = null;
        HsqlArrayList updateList = new HsqlArrayList();
        Expression[] updateExpressions = Expression.emptyArray;
        HsqlArrayList insertList = new HsqlArrayList();
        Expression insertExpression = null;
        this.read();
        this.readThis(151);
        RangeVariable targetRange = this.readRangeVariableForDataChange(56);
        Table table = targetRange.rangeTable;
        this.readThis(322);
        this.compileContext.setOuterRanges(rangeGroups);
        RangeVariable sourceRange = this.readTableOrSubquery();
        RangeVariable[] targetRanges = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(targetRanges, false);
        sourceRange.resolveRangeTable(this.session, rangeGroup, rangeGroups);
        sourceRange.resolveRangeTableTypes(this.session, targetRanges);
        this.compileContext.setOuterRanges(RangeGroup.emptyArray);
        RangeVariable[] fullRangeVars = new RangeVariable[]{sourceRange, targetRange};
        RangeVariable[] sourceRangeVars = new RangeVariable[]{sourceRange};
        RangeVariable[] targetRangeVars = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple fullRangeGroup = new RangeGroup.RangeGroupSimple(fullRangeVars, false);
        RangeGroup.RangeGroupSimple sourceRangeGroup = new RangeGroup.RangeGroupSimple(sourceRangeVars, false);
        this.readThis(204);
        Expression mergeCondition = this.XreadAndResolveBooleanValueExpression(rangeGroups, fullRangeGroup);
        insertColumnMap = table.getColumnMap();
        boolean[] insertColumnCheckList = table.getNewColumnCheckList();
        OrderedHashSet updateTargetSet = new OrderedHashSet();
        OrderedHashSet insertColNames = new OrderedHashSet();
        LongDeque updateColIndexList = new LongDeque();
        Expression[] conditions = new Expression[3];
        boolean deleteFirst = false;
        int opOne = this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions);
        if (opOne == 19) {
            deleteFirst = true;
        }
        if (this.token.tokenType == 332 && (opTwo = this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions)) == 19 && opOne == 55) {
            deleteFirst = true;
        }
        if (this.token.tokenType == 332) {
            this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions);
        }
        if (insertList.size() > 0) {
            int colCount = insertColNames.size();
            if (colCount != 0) {
                insertColumnMap = table.getColumnIndexes(insertColNames);
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
            }
            insertExpression = (Expression)insertList.get(0);
            ParserDML.setParameterTypes(insertExpression, table, insertColumnMap);
            if (conditions[0] == null) {
                conditions[0] = Expression.EXPR_TRUE;
            }
        }
        if (updateList.size() > 0) {
            targets = new Expression[updateTargetSet.size()];
            updateTargetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveReferencesAndTypes(rangeGroup, rangeGroups, targets[i]);
            }
            updateExpressions = new Expression[updateList.size()];
            updateList.toArray(updateExpressions);
            updateColumnMap = new int[updateColIndexList.size()];
            updateColIndexList.toArray(updateColumnMap);
            if (conditions[1] == null) {
                conditions[1] = Expression.EXPR_TRUE;
            }
        }
        if (updateExpressions.length != 0) {
            Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
            int[] baseUpdateColumnMap = updateColumnMap;
            if (table != baseTable) {
                baseUpdateColumnMap = new int[updateColumnMap.length];
                ArrayUtil.projectRow(table.getBaseTableColumnMap(), updateColumnMap, baseUpdateColumnMap);
            }
            this.resolveUpdateExpressions(table, fullRangeGroup, updateColumnMap, targets, updateExpressions, rangeGroups, null);
        }
        List unresolved = null;
        unresolved = mergeCondition.resolveColumnReferences(this.session, fullRangeGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        mergeCondition.resolveTypes(this.session, null);
        if (mergeCondition.isUnresolvedParam()) {
            mergeCondition.dataType = Type.SQL_BOOLEAN;
        }
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        fullRangeVars[1].addJoinCondition(mergeCondition);
        RangeVariableResolver resolver = new RangeVariableResolver(this.session, fullRangeVars, null, this.compileContext, false);
        resolver.processConditions();
        fullRangeVars = resolver.rangeVariables;
        for (int i = 0; i < fullRangeVars.length; ++i) {
            fullRangeVars[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        if (insertExpression != null) {
            unresolved = insertExpression.resolveColumnReferences(this.session, sourceRangeGroup, RangeGroup.emptyArray, null);
            unresolved = Expression.resolveColumnSet(this.session, RangeVariable.emptyArray, rangeGroups, unresolved);
            ExpressionColumn.checkColumnsResolved(unresolved);
            insertExpression.resolveTypes(this.session, null);
            Expression[] rowList = insertExpression.nodes;
            for (int j = 0; j < rowList.length; ++j) {
                Expression[] rowArgs = rowList[j].nodes;
                for (int i = 0; i < rowArgs.length; ++i) {
                    Expression e = rowArgs[i];
                    ColumnSchema column = table.getColumn(insertColumnMap[i]);
                    Type colType = column.getDataType();
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(column);
                    }
                    if (e.opType == 4 || e.dataType != null && colType.typeDataGroup == e.dataType.typeDataGroup && !colType.isArrayType()) continue;
                    rowArgs[i] = ExpressionOp.getConvertExpression(this.session, e, colType);
                }
            }
        }
        StatementDML cs = new StatementDML(this.session, targets, sourceRange, targetRange, fullRangeVars, insertColumnMap, updateColumnMap, insertColumnCheckList, mergeCondition, insertExpression, updateExpressions, deleteFirst, conditions[0], conditions[1], conditions[2], this.compileContext);
        return cs;
    }

    private int readMergeWhen(RangeGroup[] rangeGroups, RangeGroup rangeGroup, LongDeque updateColIndexList, OrderedHashSet insertColumnNames, OrderedHashSet updateTargetSet, HsqlArrayList insertExpressions, HsqlArrayList updateExpressions, RangeVariable[] targetRangeVars, RangeVariable sourceRangeVar, Expression[] conditions) {
        Table table = targetRangeVars[0].rangeTable;
        int columnCount = table.getColumnCount();
        Expression condition = null;
        this.readThis(332);
        if (this.token.tokenType == 474) {
            this.read();
            if (this.readIfThis(5)) {
                condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
            }
            this.readThis(296);
            if (this.readIfThis(319)) {
                if (updateExpressions.size() != 0) {
                    throw Error.error(5547);
                }
                conditions[1] = condition;
                this.readThis(268);
                this.readSetClauseList(rangeGroups, targetRangeVars, updateTargetSet, updateColIndexList, updateExpressions);
                return 92;
            }
            if (conditions[2] != null) {
                throw Error.error(5547);
            }
            if (condition == null) {
                condition = Expression.EXPR_TRUE;
            }
            conditions[2] = condition;
            this.readThis(84);
            return 19;
        }
        if (this.token.tokenType == 193) {
            if (insertExpressions.size() != 0) {
                throw Error.error(5548);
            }
            this.read();
            this.readThis(474);
            if (this.readIfThis(5)) {
                condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
            }
            conditions[0] = condition;
            this.readThis(296);
            this.readThis(145);
            int brackets = this.readOpenBrackets();
            if (brackets == 1) {
                boolean withPrefix = this.database.sqlSyntaxOra;
                this.readSimpleColumnNames(insertColumnNames, targetRangeVars[0], withPrefix);
                columnCount = insertColumnNames.size();
                this.readThis(922);
                brackets = 0;
            }
            this.readThis(325);
            Expression e = this.XreadContextuallyTypedTable(columnCount);
            if (e.nodes.length != 1) {
                throw Error.error(3201);
            }
            insertExpressions.add(e);
            return 55;
        }
        throw this.unexpectedToken();
    }

    StatementDMQL compileCallStatement(RangeGroup[] rangeGroups, boolean isStrictlyProcedure) {
        this.read();
        if (this.isIdentifier()) {
            String schema;
            ReferenceObject synonym;
            RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix, 17);
            if (routineSchema == null && this.token.namePrefix == null && (synonym = this.database.schemaManager.findSynonym(this.token.tokenString, schema = this.session.getSchemaName(null), 18)) != null) {
                HsqlNameManager.HsqlName name = synonym.getTarget();
                routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name.name, name.schema.name, name.type);
            }
            if (routineSchema != null) {
                this.read();
                return this.compileProcedureCall(rangeGroups, routineSchema);
            }
        }
        if (isStrictlyProcedure) {
            throw Error.error(5501, this.token.tokenString);
        }
        Expression expression = this.XreadValueExpression();
        List unresolved = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementProcedure cs = new StatementProcedure(this.session, expression, this.compileContext);
        return cs;
    }

    StatementDMQL compileProcedureCall(RangeGroup[] rangeGroups, RoutineSchema routineSchema) {
        int i;
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        boolean bracket = true;
        if (this.database.sqlSyntaxOra) {
            bracket = this.readIfThis(937);
        } else {
            this.readThis(937);
        }
        if (bracket) {
            if (this.token.tokenType == 922) {
                this.read();
            } else {
                while (true) {
                    Expression e = this.XreadValueExpression();
                    list.add(e);
                    if (this.token.tokenType != 924) break;
                    this.read();
                }
                this.readThis(922);
            }
        }
        Expression[] arguments = new Expression[list.size()];
        list.toArray(arguments);
        Routine routine = routineSchema.getSpecificRoutine(arguments.length);
        this.compileContext.addProcedureCall(routine);
        List unresolved = null;
        for (i = 0; i < arguments.length; ++i) {
            Expression e = arguments[i];
            if (e.isUnresolvedParam()) {
                e.setAttributesAsColumn(routine.getParameter(i));
                continue;
            }
            byte paramMode = routine.getParameter(i).getParameterMode();
            unresolved = arguments[i].resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, unresolved);
            if (paramMode == 1 || e.getType() == 6) continue;
            throw Error.error(5603);
        }
        ExpressionColumn.checkColumnsResolved(unresolved);
        for (i = 0; i < arguments.length; ++i) {
            arguments[i].resolveTypes(this.session, null);
            if (routine.getParameter(i).getDataType().canBeAssignedFrom(arguments[i].getDataType())) continue;
            throw Error.error(5561);
        }
        StatementProcedure cs = new StatementProcedure(this.session, routine, arguments, this.compileContext);
        return cs;
    }

    void resolveReferencesAndTypes(RangeGroup rangeGroup, RangeGroup[] rangeGroups, Expression e) {
        List unresolved = e.resolveColumnReferences(this.session, rangeGroup, rangeGroup.getRangeVariables().length, rangeGroups, null, false);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
    }

    void resolveOuterReferencesAndTypes(RangeGroup[] rangeGroups, Expression e) {
        List unresolved = e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
    }
}

