/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionJSON;
import org.hsqldb.ExpressionLike;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.ExpressionPeriod;
import org.hsqldb.ExpressionPeriodOp;
import org.hsqldb.ExpressionTable;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserBase;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableJoined;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntKeyHashMap;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;
import org.hsqldb.types.UserTypeModifier;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;

    ParserDQL(Session session, Scanner scanner, CompileContext baseContext) {
        super(scanner);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session, this, baseContext);
    }

    @Override
    void reset(Session session, String sql) {
        super.reset(session, sql);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
        if (this.database.sqlRegularNames) {
            this.checkIsIrregularCharInIdentifier();
        }
    }

    Type readTypeDefinition(boolean allowCollation, boolean includeUserTypes) {
        int typeNumber = Integer.MIN_VALUE;
        boolean hasLength = false;
        boolean hasScale = false;
        boolean isCharacter = false;
        boolean isIgnoreCase = false;
        boolean readByteOrChar = false;
        boolean enforceSize = this.database.sqlEnforceSize;
        boolean acceptsPrecision = true;
        long length = 0L;
        int scale = 0;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            typeNumber = Type.getTypeNr(this.token.tokenString);
        }
        if (this.database.sqlSyntaxOra && !this.session.isProcessingScript() && typeNumber == 91) {
            this.read();
            return Type.SQL_TIMESTAMP_NO_FRACTION;
        }
        if (typeNumber == Integer.MIN_VALUE) {
            if (includeUserTypes) {
                this.checkIsSchemaObjectName();
                Type type = this.database.schemaManager.findDomainOrUDT(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix, this.token.namePrePrePrefix);
                if (type != null) {
                    this.getRecordedToken().setExpression(type);
                    this.compileContext.addDomainOrType(type);
                    this.read();
                    return type;
                }
            }
            if (this.token.namePrefix != null) {
                throw Error.error(5509, this.token.tokenString);
            }
            if (this.database.sqlSyntaxOra) {
                switch (this.token.tokenType) {
                    case 606: 
                    case 607: {
                        this.read();
                        return Type.SQL_DOUBLE;
                    }
                    case 655: {
                        this.read();
                        if (this.token.tokenType == 673) {
                            this.read();
                            return Type.getType(61, null, null, 0x40000000L, 0);
                        }
                        this.readIfThis(329);
                        return Type.getType(12, null, this.database.collation, 0x40000000L, 0);
                    }
                    case 490: {
                        this.read();
                        if (this.token.tokenType == 937) {
                            this.read();
                            int precision = this.readInteger();
                            scale = 0;
                            if (this.token.tokenType == 924) {
                                this.read();
                                scale = this.readInteger();
                            }
                            this.readThis(922);
                            return Type.getType(3, null, null, precision, scale);
                        }
                        return Type.SQL_DECIMAL_DEFAULT;
                    }
                    case 673: {
                        typeNumber = 61;
                        break;
                    }
                    case 695: {
                        readByteOrChar = true;
                        enforceSize = false;
                        typeNumber = 12;
                        break;
                    }
                    case 665: {
                        typeNumber = 12;
                        break;
                    }
                    case 187: {
                        typeNumber = 1;
                        break;
                    }
                }
            }
            if (this.database.sqlSyntaxMss) {
                if ("MONEY".equals(this.token.tokenString)) {
                    return Type.getType(3, null, null, 18L, 4);
                }
                if ("UNIQUEIDENTIFIER".equals(this.token.tokenString)) {
                    return Type.SQL_GUID;
                }
                if ("DATETIME2".equals(this.token.tokenString)) {
                    typeNumber = 93;
                } else if ("IMAGE".equals(this.token.tokenString)) {
                    typeNumber = -4;
                } else if ("NTEXT".equals(this.token.tokenString)) {
                    typeNumber = -1;
                }
                switch (this.token.tokenType) {
                    case 860: {
                        typeNumber = 95;
                        break;
                    }
                    case 689: {
                        typeNumber = -1;
                    }
                }
            }
            if (this.database.sqlSyntaxPgs) {
                switch (this.token.tokenType) {
                    case 689: {
                        typeNumber = -1;
                        readByteOrChar = true;
                        break;
                    }
                    case 616: {
                        typeNumber = 100;
                        break;
                    }
                    default: {
                        if ("BYTEA".equals(this.token.tokenString)) {
                            typeNumber = -4;
                            break;
                        }
                        if ("INT2".equals(this.token.tokenString)) {
                            typeNumber = 5;
                            break;
                        }
                        if ("INT4".equals(this.token.tokenString)) {
                            typeNumber = 4;
                            break;
                        }
                        if ("INT8".equals(this.token.tokenString)) {
                            typeNumber = 25;
                            break;
                        }
                        if ("REAL".equals(this.token.tokenString)) {
                            typeNumber = 8;
                            break;
                        }
                        if (!"TIMESTAMPTZ".equals(this.token.tokenString)) break;
                        typeNumber = 95;
                        scale = 6;
                    }
                }
            }
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 630: {
                        return this.readMysEnum();
                    }
                    case 858: {
                        typeNumber = 12;
                        acceptsPrecision = false;
                        break;
                    }
                    case 689: {
                        typeNumber = -1;
                        acceptsPrecision = false;
                        break;
                    }
                    case 854: 
                    case 856: {
                        typeNumber = -1;
                        acceptsPrecision = false;
                        break;
                    }
                    case 857: {
                        typeNumber = -3;
                        acceptsPrecision = false;
                        break;
                    }
                    case 853: 
                    case 855: {
                        typeNumber = -4;
                        acceptsPrecision = false;
                    }
                }
            }
            if (typeNumber == Integer.MIN_VALUE) {
                throw Error.error(5509, this.token.tokenString);
            }
        }
        this.read();
        switch (typeNumber) {
            case 1: {
                if (this.token.tokenType == 330) {
                    this.read();
                    typeNumber = 12;
                    break;
                }
                if (this.token.tokenType == 157) {
                    this.read();
                    this.readThis(491);
                    typeNumber = 40;
                    break;
                }
                if (!this.database.sqlSyntaxOra) break;
                readByteOrChar = true;
                break;
            }
            case 8: {
                if (this.token.tokenType != 226) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 330) {
                    this.read();
                    typeNumber = 61;
                    break;
                }
                if (this.token.tokenType != 157) break;
                this.read();
                this.readThis(491);
                typeNumber = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 330) break;
                this.read();
                typeNumber = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(this.session, false);
            }
        }
        if (typeNumber == 93) {
            length = 6L;
        }
        if ((acceptsPrecision &= Types.acceptsPrecision(typeNumber)) && enforceSize && Types.requiresPrecision(typeNumber) && this.token.tokenType != 937 && !this.session.isProcessingScript()) {
            throw Error.error(5599, Type.getDefaultType(typeNumber).getNameString());
        }
        if (this.database.sqlSyntaxMys) {
            switch (typeNumber) {
                case -6: 
                case 4: 
                case 5: 
                case 25: {
                    acceptsPrecision = true;
                }
            }
        }
        if (this.database.sqlSyntaxMss) {
            switch (typeNumber) {
                case 95: {
                    acceptsPrecision = true;
                }
            }
        }
        if (acceptsPrecision) {
            if (this.token.tokenType == 937) {
                int multiplier = 1;
                this.read();
                block38 : switch (this.token.tokenType) {
                    case 1011: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 1018: {
                        if (typeNumber == 30 || typeNumber == 40 || typeNumber == 61 || typeNumber == 12) {
                            switch (this.token.lobMultiplierType) {
                                case 462: {
                                    multiplier = 1024;
                                    break block38;
                                }
                                case 472: {
                                    multiplier = 0x100000;
                                    break block38;
                                }
                                case 432: {
                                    multiplier = 0x40000000;
                                    break block38;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    case 173: {
                        if (this.database.sqlSyntaxMss) {
                            this.token.tokenValue = Integer.MAX_VALUE;
                            break;
                        }
                        throw this.unexpectedToken();
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                hasLength = true;
                length = ((Number)this.token.tokenValue).longValue();
                if (length < 0L || length == 0L && !Types.acceptsZeroPrecision(typeNumber)) {
                    throw Error.error(5592);
                }
                length *= (long)multiplier;
                this.read();
                if (typeNumber == 1 || typeNumber == 12 || typeNumber == 40) {
                    if (this.token.tokenType == 377) {
                        this.read();
                    } else if (this.token.tokenType == 492) {
                        this.read();
                    }
                }
                if (Types.acceptsScaleCreateParam(typeNumber) && this.token.tokenType == 924) {
                    this.read();
                    scale = this.readInteger();
                    if (!(scale >= 0 || typeNumber == 3 && this.database.sqlSyntaxOra)) {
                        throw Error.error(5592);
                    }
                    if (typeNumber == 3 && (long)scale > length) {
                        throw Error.error(5592);
                    }
                    hasScale = true;
                }
                if (readByteOrChar && !this.readIfThis(36)) {
                    this.readIfThis(611);
                }
                this.readThis(922);
            } else if (typeNumber == 14) {
                length = 1L;
            } else if (typeNumber == 30 || typeNumber == 40) {
                length = 0x40000000L;
            } else if (enforceSize && (typeNumber == 1 || typeNumber == 60)) {
                length = 1L;
            }
            switch (typeNumber) {
                case 92: 
                case 93: 
                case 95: {
                    if (length > 9L) {
                        throw Error.error(5592);
                    }
                    scale = (int)length;
                    length = 0L;
                    if (typeNumber == 95) break;
                    if (this.token.tokenType == 337) {
                        this.read();
                        this.readThis(297);
                        this.readThis(593);
                        if (typeNumber == 93) {
                            typeNumber = 95;
                            break;
                        }
                        typeNumber = 94;
                        break;
                    }
                    if (this.token.tokenType != 339) break;
                    this.read();
                    this.readThis(297);
                    this.readThis(593);
                }
            }
        }
        switch (typeNumber) {
            case -1: {
                if (this.database.sqlLongvarIsLob) {
                    typeNumber = 40;
                    length = 0x40000000L;
                    break;
                }
                typeNumber = 12;
                if (hasLength) break;
                length = 0x1000000L;
                break;
            }
            case -4: {
                if (this.database.sqlLongvarIsLob) {
                    typeNumber = 30;
                    length = 0x40000000L;
                    break;
                }
                typeNumber = 61;
                if (hasLength) break;
                length = 0x1000000L;
                break;
            }
            case 1: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(120)) {
                    this.readThis(608);
                    this.readThis(400);
                    typeNumber = 60;
                    break;
                }
                isCharacter = true;
                break;
            }
            case 40: {
                isCharacter = true;
                break;
            }
            case 100: {
                typeNumber = 12;
                isIgnoreCase = true;
            }
            case 12: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(120)) {
                    this.readThis(608);
                    this.readThis(400);
                    typeNumber = 61;
                    if (hasLength) break;
                    length = 32768L;
                    break;
                }
                isCharacter = true;
                if (!hasLength) {
                    length = 32768L;
                }
                if (this.session.isIgnorecase() && !this.session.isProcessingScript()) {
                    isIgnoreCase = true;
                }
                if (length <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 60: {
                break;
            }
            case 61: {
                if (!hasLength) {
                    length = 32768L;
                }
                if (length <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 2: 
            case 3: {
                if (hasLength || hasScale || enforceSize) break;
                length = 128L;
                scale = 32;
            }
        }
        Collation collation = this.database.collation;
        Charset charset = null;
        if (isCharacter && allowCollation) {
            if (this.token.tokenType == 38) {
                this.read();
                this.readThis(268);
                this.checkIsSchemaObjectName();
                charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            }
            if (this.token.tokenType == 44) {
                this.read();
                this.checkIsSchemaObjectName();
                collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            } else if (isIgnoreCase) {
                collation = Collation.getUpperCaseCompareCollation(collation);
            }
        }
        Type typeObject = Type.getType(typeNumber, charset, collation, length, scale);
        if (this.token.tokenType == 8) {
            if (typeObject.isLobType()) {
                throw this.unexpectedToken();
            }
            this.read();
            int maxCardinality = 0x100000;
            if (this.token.tokenType == 932) {
                this.read();
                maxCardinality = this.readInteger();
                if (maxCardinality < 0) {
                    throw Error.error(5592);
                }
                this.readThis(942);
            }
            typeObject = new ArrayType(typeObject, maxCardinality);
        }
        return typeObject;
    }

    Type readMysEnum() {
        this.read();
        this.checkIsThis(937);
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName("ENUM", false, 13);
        Type t = Type.getType(12, null, null, 32L, 0);
        t.userTypeModifier = new UserTypeModifier(name, 13, t);
        return t;
    }

    void readSimpleColumnNames(OrderedHashSet columns, RangeVariable rangeVar, boolean withPrefix) {
        do {
            ColumnSchema col = this.readSimpleColumnName(rangeVar, withPrefix);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922) {
            throw this.unexpectedToken();
        }
    }

    void readTargetSpecificationList(OrderedHashSet targets, RangeVariable[] rangeVars, LongDeque colIndexList) {
        do {
            Expression target;
            if (targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) continue;
            ColumnSchema col = target.getColumn();
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922 && this.token.tokenType != 124) {
            throw this.unexpectedToken();
        }
    }

    int[] readColumnList(Table table, boolean ascOrDesc) {
        OrderedHashSet set = this.readColumnNames(ascOrDesc);
        return table.getColumnIndexes(set);
    }

    void readSimpleColumnNames(OrderedHashSet columns, Table table, boolean withPrefix) {
        do {
            ColumnSchema col = this.readSimpleColumnName(table, withPrefix);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5577, col.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName tableName) {
        BitMap quotedFlags = new BitMap(0, true);
        OrderedHashSet set = this.readColumnNames(quotedFlags, false);
        HsqlNameManager.HsqlName[] colList = new HsqlNameManager.HsqlName[set.size()];
        for (int i = 0; i < colList.length; ++i) {
            String name = (String)set.get(i);
            boolean quoted = quotedFlags.isSet(i);
            colList[i] = this.database.nameManager.newHsqlName(tableName.schema, name, quoted, 9, tableName);
        }
        return colList;
    }

    OrderedHashSet readColumnNames(boolean readAscDesc) {
        return this.readColumnNames(null, readAscDesc);
    }

    OrderedHashSet readColumnNames(BitMap quotedFlags, boolean readAscDesc) {
        this.readThis(937);
        OrderedHashSet set = new OrderedHashSet();
        this.readColumnNameList(set, quotedFlags, readAscDesc);
        this.readThis(922);
        return set;
    }

    void readColumnNameList(OrderedHashSet set, BitMap quotedFlags, boolean readAscDesc) {
        int i = 0;
        do {
            if (this.session.isProcessingScript()) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!set.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (quotedFlags != null) {
                quotedFlags.setValue(i, this.isDelimitedIdentifier());
            }
            this.read();
            ++i;
            if (!readAscDesc || this.token.tokenType != 360 && this.token.tokenType != 411) continue;
            this.read();
        } while (this.readIfThis(924));
    }

    HsqlNameManager.SimpleName[] readColumnNameList(OrderedHashSet set) {
        BitMap columnNameQuoted = new BitMap(0, true);
        this.readThis(937);
        this.readColumnNameList(set, columnNameQuoted, false);
        this.readThis(922);
        HsqlNameManager.SimpleName[] columnNameList = new HsqlNameManager.SimpleName[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.SimpleName name;
            columnNameList[i] = name = HsqlNameManager.getSimpleName((String)set.get(i), columnNameQuoted.isSet(i));
        }
        return columnNameList;
    }

    int XreadUnionType() {
        int unionType = 0;
        switch (this.token.tokenType) {
            case 314: {
                this.read();
                unionType = 1;
                if (this.token.tokenType == 2) {
                    unionType = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
            case 148: {
                this.read();
                unionType = 3;
                if (this.token.tokenType == 2) {
                    unionType = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
            case 106: 
            case 661: {
                this.read();
                unionType = 6;
                if (this.token.tokenType == 2) {
                    unionType = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
        }
        return unionType;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 55) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 27) {
                this.read();
                OrderedHashSet names = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(names);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryExpression XreadQueryExpression() {
        try {
            this.XreadWithClause();
            QueryExpression queryExpression = this.XreadQueryExpressionBody();
            SortAndSlice sortAndSlice = this.XreadOrderByExpression();
            if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
                queryExpression.addSortAndSlice(sortAndSlice);
            } else if (queryExpression.sortAndSlice.hasLimit()) {
                if (sortAndSlice.hasLimit()) {
                    throw Error.error(5549);
                }
                for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                    Expression e = (Expression)sortAndSlice.exprList.get(i);
                    queryExpression.sortAndSlice.addOrderExpression(e);
                }
            } else if (sortAndSlice != SortAndSlice.noSort) {
                queryExpression.addSortAndSlice(sortAndSlice);
            }
            QueryExpression queryExpression2 = queryExpression;
            return queryExpression2;
        }
        finally {
            this.compileContext.unregisterSubqueries();
        }
    }

    void XreadWithClause() {
        if (this.token.tokenType == 337) {
            this.read();
            this.compileContext.unregisterSubqueries();
            this.compileContext.registerSubquery("RECURSIVE_TABLE");
            boolean recursive = this.readIfThis(234);
            while (true) {
                boolean[] cols;
                this.checkIsSimpleName();
                HsqlNameManager.HsqlName[] nameList = null;
                HsqlNameManager.HsqlName queryName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 27);
                queryName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
                this.read();
                if (this.token.tokenType == 937) {
                    nameList = this.readColumnNames(queryName);
                } else if (recursive) {
                    throw this.unexpectedTokenRequire("(");
                }
                this.readThis(11);
                this.readThis(937);
                this.compileContext.registerSubquery(queryName.name);
                TableDerived td = this.XreadTableNamedSubqueryBody(queryName, nameList);
                if (nameList == null && ArrayUtil.countTrueElements(cols = td.queryExpression.accessibleColumns) < cols.length) {
                    throw Error.error(5578);
                }
                this.readThis(922);
                if (td.queryExpression != null && td.queryExpression.isRecursive()) {
                    this.XreadRecursiveFeatures(td);
                }
                this.compileContext.registerSubquery(queryName.name, td);
                this.compileContext.registerSubquery("RECURSIVE_TABLE", null);
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
    }

    void XreadRecursiveFeatures(TableDerived table) {
        QueryExpression.RecursiveQuerySettings settings = null;
        if (this.token.tokenType == 263) {
            this.read();
            settings = new QueryExpression.RecursiveQuerySettings();
            switch (this.token.tokenType) {
                case 409: {
                    this.read();
                    settings.searchOrderType = 1;
                    break;
                }
                case 367: {
                    this.read();
                    settings.searchOrderType = 2;
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("DEPTH or BREADTH");
                }
            }
            this.readThis(427);
            this.readThis(27);
            settings.searchOrderSort = this.XreadOrderBy();
            this.readThis(268);
            this.checkIsSimpleName();
            HsqlNameManager.HsqlName searchOrderName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
            if (table.findColumn(searchOrderName.name) != -1) {
                throw Error.error(5578, this.token.tokenString);
            }
            this.read();
            settings.searchOrderSetColumn = new ColumnSchema(searchOrderName, Type.SQL_INTEGER, true, false, null);
        }
        if (this.token.tokenType == 76) {
            this.read();
            if (settings == null) {
                settings = new QueryExpression.RecursiveQuerySettings();
            }
            OrderedHashSet set = new OrderedHashSet();
            this.readColumnNameList(set, null, false);
            settings.cycleColumnList = table.getColumnIndexes(set);
            if (set.size() > 1) {
                throw Error.error(5564, this.token.tokenString);
            }
            settings.cycleColumnFirst = table.getColumn(settings.cycleColumnList[0]);
            this.readThis(268);
            this.checkIsSimpleName();
            HsqlNameManager.HsqlName cycleName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
            settings.cycleMarkColumn = new ColumnSchema(cycleName, Type.SQL_CHAR, false, false, null);
            if (table.findColumn(cycleName.name) != -1) {
                throw Error.error(5578, this.token.tokenString);
            }
            this.read();
            this.readThis(301);
            settings.cycleMarkValue = this.readQuotedString();
            if (settings.cycleMarkValue.length() != 1) {
                throw this.unexpectedToken(settings.cycleMarkValue);
            }
            this.readThis(83);
            settings.noCycleMarkValue = this.readQuotedString();
            if (settings.noCycleMarkValue.length() != 1) {
                throw this.unexpectedToken(settings.noCycleMarkValue);
            }
            if (settings.cycleMarkValue.equals(settings.noCycleMarkValue)) {
                throw this.unexpectedToken(settings.cycleMarkValue);
            }
            if (this.readIfThis(322)) {
                this.checkIsSimpleName();
                HsqlNameManager.HsqlName pathName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                if (table.findColumn(pathName.name) != -1) {
                    throw Error.error(5578, this.token.tokenString);
                }
                this.read();
                ArrayType arrayType = new ArrayType(settings.cycleColumnFirst.getDataType(), 0x100000);
                settings.cyclePathColumn = new ColumnSchema(pathName, arrayType, false, false, null);
            }
        }
        table.queryExpression.setRecursiveQuerySettings(settings);
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 106: 
                case 314: 
                case 661: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 148) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int unionType = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression rightQueryExpression = this.XreadQueryTerm();
        queryExpression.addUnion(rightQueryExpression, unionType);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 325: {
                QuerySpecification select = this.XreadSimpleTable();
                return select;
            }
            case 937: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(922);
                if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression e = (Expression)sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(e);
                    }
                } else if (sortAndSlice != SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification select;
        switch (this.token.tokenType) {
            case 294: {
                this.read();
                Table table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                }
                if (table.isView()) {
                    table = ((View)table).newDerivedTable(this.session, this.compileContext);
                }
                select = new QuerySpecification(this.session, table, this.compileContext, false);
                break;
            }
            case 325: {
                this.read();
                TableDerived td = this.XreadRowValueExpressionList();
                select = new QuerySpecification(this.session, td, this.compileContext, true);
                break;
            }
            case 265: {
                select = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return select;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification select = this.XreadSelect();
        if (!select.isValueList && select.getCurrentRangeVariableCount() == 0) {
            this.XreadTableExpression(select);
        }
        return select;
    }

    void XreadTableExpression(QuerySpecification select) {
        this.XreadFromClause(select);
        this.readWhereGroupHaving(select);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification select;
        block10: {
            SortAndSlice sortAndSlice;
            select = new QuerySpecification(this.compileContext);
            this.readThis(265);
            if ((this.token.tokenType == 690 || this.token.tokenType == 649) && (sortAndSlice = this.XreadTopOrLimit()) != null) {
                select.addSortAndSlice(sortAndSlice);
            }
            if (this.token.tokenType == 90) {
                select.setDistinctSelect();
                this.read();
            } else if (this.token.tokenType == 2) {
                this.read();
            }
            do {
                Expression e = this.XreadValueExpression();
                if (this.token.tokenType == 11) {
                    if (e.getType() == 99) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    if (e.getType() == 99) {
                        throw this.unexpectedToken();
                    }
                    e.setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                select.addSelectColumnExpression(e);
                if (this.token.tokenType == 124 || this.token.tokenType == 151) break block10;
            } while (this.readIfThis(924));
            if ((this.token.tokenType == 922 || this.token.tokenType == 1014 || this.token.tokenType == 943) && (this.database.sqlSyntaxMss || this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs)) {
                RangeVariable range = new RangeVariable(this.database.schemaManager.dualTable, null, null, null, this.compileContext);
                select.addRangeVariable(this.session, range);
                return select;
            }
            throw this.unexpectedToken();
        }
        return select;
    }

    void XreadFromClause(QuerySpecification select) {
        this.readThis(124);
        do {
            this.XreadTableReference(select);
        } while (this.readIfThis(924));
    }

    void XreadTableReference(QuerySpecification select) {
        boolean natural = false;
        RangeVariable leftRange = this.readTableOrSubquery();
        select.addRangeVariable(this.session, leftRange);
        block15: while (true) {
            boolean left = false;
            boolean right = false;
            boolean end = false;
            int type = this.token.tokenType;
            switch (this.token.tokenType) {
                case 186: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    natural = true;
                    continue block15;
                }
                case 142: {
                    this.read();
                    this.readThis(154);
                    break;
                }
                case 60: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(154);
                    break;
                }
                case 314: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    int position = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 154) {
                        this.read();
                        left = true;
                        right = true;
                        break;
                    }
                    this.rewind(position);
                    end = true;
                    break;
                }
                case 163: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    left = true;
                    break;
                }
                case 254: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    right = true;
                    break;
                }
                case 125: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    left = true;
                    right = true;
                    break;
                }
                case 154: {
                    this.read();
                    type = 142;
                    break;
                }
                default: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    end = true;
                }
            }
            if (end) break;
            RangeVariable rightRange = this.readTableOrSubquery();
            Expression condition = null;
            rightRange.setJoinType(left, right);
            switch (type) {
                case 60: {
                    select.addRangeVariable(this.session, rightRange);
                    break;
                }
                case 314: {
                    condition = Expression.EXPR_FALSE;
                    rightRange.addJoinCondition(condition);
                    select.addRangeVariable(this.session, rightRange);
                    break;
                }
                case 125: 
                case 142: 
                case 163: 
                case 254: {
                    OrderedHashSet columns;
                    boolean using;
                    boolean bl = using = this.token.tokenType == 322;
                    if (natural || using) {
                        leftRange.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                        rightRange.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                    }
                    if (natural) {
                        columns = rightRange.getUniqueColumnNameSet();
                        condition = select.getEquiJoinExpressions(columns, rightRange, false);
                        rightRange.addJoinCondition(condition);
                        select.addRangeVariable(this.session, rightRange);
                        break;
                    }
                    if (using) {
                        this.read();
                        columns = new OrderedHashSet();
                        this.readThis(937);
                        this.readSimpleColumnNames(columns, rightRange, false);
                        this.readThis(922);
                        condition = select.getEquiJoinExpressions(columns, rightRange, true);
                        rightRange.addJoinCondition(condition);
                        select.addRangeVariable(this.session, rightRange);
                        break;
                    }
                    if (this.token.tokenType == 204) {
                        this.read();
                        condition = this.XreadBooleanValueExpression();
                        rightRange.addJoinCondition(condition);
                        select.addRangeVariable(this.session, rightRange);
                        break;
                    }
                    throw this.unexpectedToken();
                }
            }
            natural = false;
        }
    }

    Expression getRowExpression(OrderedHashSet columnNames) {
        Expression[] elements = new Expression[columnNames.size()];
        for (int i = 0; i < elements.length; ++i) {
            String name = (String)columnNames.get(i);
            elements[i] = new ExpressionColumn(null, null, name);
        }
        return new Expression(25, elements);
    }

    void readWhereGroupHaving(QuerySpecification select) {
        Expression e;
        if (this.token.tokenType == 334) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addQueryCondition(e);
        }
        if (this.token.tokenType == 131) {
            this.read();
            this.readThis(27);
            if (this.readIfThis(90)) {
                select.setDistinctGroups();
            } else {
                this.readIfThis(2);
            }
            HsqlArrayList<Expression> expressions = new HsqlArrayList<Expression>();
            while (true) {
                Expression e2 = this.XreadGroupByExpressionPrimary();
                expressions.add(e2);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            Expression[] exprArray = new Expression[expressions.size()];
            expressions.toArray(exprArray);
            select.addGroupingSets(exprArray);
        }
        if (this.token.tokenType == 135) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addHavingExpression(e);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 208) {
            this.read();
            this.readThis(27);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 649 || this.token.tokenType == 115 || this.token.tokenType == 202) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int position;
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 649) {
            position = this.getPosition();
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                this.rewind(position);
                return null;
            }
            this.readIfThis(924);
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5563, 81);
            }
        } else if (this.token.tokenType == 690) {
            position = this.getPosition();
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                this.rewind(position);
                return null;
            }
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        } else {
            throw this.unexpectedToken();
        }
        boolean valid = true;
        if (e1.isUnresolvedParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        } else if (e1.opType == 1) {
            valid = e1.getDataType().typeCode == 4 && (Integer)e1.getValue(null) >= 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (e2.isUnresolvedParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        } else if (e2.opType == 1) {
            valid &= e2.getDataType().typeCode == 4 && (Integer)e2.getValue(null) >= 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (valid) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(96, e1, e2));
            return sortAndSlice;
        }
        throw Error.error(5563, 81);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 202) {
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                throw Error.error(5563, 81);
            }
            if (this.token.tokenType == 257 || this.token.tokenType == 259) {
                this.read();
            }
        }
        if (this.token.tokenType == 649) {
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5563, 81);
            }
            if (e1 == null) {
                if (this.token.tokenType == 924) {
                    this.read();
                    e1 = e2;
                    e2 = this.XreadSimpleValueSpecificationOrNull();
                } else if (this.token.tokenType == 202) {
                    this.read();
                    e1 = this.XreadSimpleValueSpecificationOrNull();
                }
            }
            if (this.database.sqlSyntaxPgs || this.database.sqlSyntaxMys) {
                sortAndSlice.setZeroLimitIsZero();
            }
        } else if (this.token.tokenType == 115) {
            this.read();
            boolean first = false;
            if (this.token.tokenType == 427 || this.token.tokenType == 486) {
                first = true;
                this.read();
            }
            if ((e2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                if (!first) {
                    throw super.unexpectedTokenRequire("FIRST");
                }
                e2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 257 || this.token.tokenType == 259) {
                this.read();
            }
            this.readThis(205);
            sortAndSlice.setStrictLimit();
        }
        if (sortAndSlice.hasOrder() && this.token.tokenType == 322) {
            this.read();
            this.readThis(644);
            sortAndSlice.setUsingIndex();
        }
        if (e1 == null) {
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean valid = true;
        if (e1.isUnresolvedParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (e2 != null && e2.isUnresolvedParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (valid) {
            sortAndSlice.addLimitCondition(new ExpressionOp(96, e1, e2));
            return;
        }
        throw Error.error(5563, 81);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            boolean isDesc = false;
            boolean nullsLast = false;
            Expression e = this.XreadValueExpression();
            ExpressionOrderBy o = new ExpressionOrderBy(e);
            if (this.token.tokenType == 411) {
                o.setDescending();
                isDesc = true;
                this.read();
            } else if (this.token.tokenType == 360) {
                this.read();
            }
            nullsLast = this.database.sqlNullsOrder ? !this.database.sqlNullsFirst : this.database.sqlNullsFirst == isDesc;
            o.setNullsLast(nullsLast);
            if (this.token.tokenType == 489) {
                this.read();
                if (this.token.tokenType == 427) {
                    this.read();
                    o.setNullsLast(false);
                } else if (this.token.tokenType == 467) {
                    this.read();
                    o.setNullsLast(true);
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(o);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readRangeVariableForDataChange(int operation) {
        Table table = this.readTableName(true);
        ExpressionPeriodOp appPeriodSpec = this.XreadQueryApplicationPeriodSpecOrNull(table);
        HsqlNameManager.SimpleName alias = null;
        if (appPeriodSpec != null) {
            throw Error.error(1551);
        }
        if (operation != 1215) {
            switch (this.token.tokenType) {
                case 501: {
                    break;
                }
                case 11: {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                default: {
                    if (!this.isNonCoreReservedIdentifier() || this.database.sqlSyntaxMys && operation == 55) break;
                    alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                    this.read();
                }
            }
            if (alias == null && this.lastSynonym != null) {
                alias = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
            }
        }
        if (table.isView) {
            switch (operation) {
                case 56: {
                    if (table.isTriggerUpdatable() && table.isTriggerInsertable() || !table.isTriggerUpdatable() && !table.isTriggerInsertable() && table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 92: {
                    if (table.isTriggerUpdatable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 19: {
                    if (table.isTriggerDeletable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 55: {
                    if (table.isTriggerInsertable() || table.isInsertable() || this.session.isProcessingScript()) break;
                    throw Error.error(5545);
                }
                case 1215: {
                    throw Error.error(5545);
                }
            }
            table = ((View)table).newDerivedTable(this.session, this.compileContext);
        }
        RangeVariable range = new RangeVariable(table, alias, null, null, this.compileContext);
        if (table.isSystemVersioned()) {
            ExpressionPeriodOp sysPeriodSpec = new ExpressionPeriodOp();
            sysPeriodSpec.setSystemRangeVariable(this.session, RangeGroup.emptyArray, range);
            range.setSystemPeriodCondition(sysPeriodSpec);
        }
        return range;
    }

    protected Table readNamedSubqueryOrNull() {
        if (!this.isSimpleName()) {
            return null;
        }
        TableDerived td = this.compileContext.getNamedSubQuery(this.token.tokenString);
        if (td == null) {
            return null;
        }
        this.read();
        if (td.isRecompiled()) {
            td = td.newDerivedTable(this.session, this.compileContext);
        }
        return td;
    }

    protected RangeVariable readTableOrSubquery() {
        RangeVariable range;
        Table table = null;
        HsqlNameManager.SimpleName alias = null;
        HsqlNameManager.SimpleName[] columnNameList = null;
        OrderedHashSet columnList = null;
        ExpressionPeriodOp sysPeriodSpec = null;
        boolean joinedTable = false;
        boolean isLateral = false;
        boolean isTableName = false;
        switch (this.token.tokenType) {
            case 937: {
                table = this.XreadTableSubqueryOrNull(false);
                if (table != null) break;
                table = this.XreadJoinedTableAsSubqueryOrNull();
                if (table == null) {
                    table = this.XreadTableSubqueryOrNull(true);
                    if (table != null) break;
                    throw this.unexpectedToken();
                }
                joinedTable = true;
                break;
            }
            case 317: {
                Expression e = this.XreadCollectionDerivedTable(23);
                table = e.getTable();
                isLateral = true;
                break;
            }
            case 159: {
                Expression e = this.XreadLateralDerivedTable();
                table = e.getTable();
                isLateral = true;
                break;
            }
            case 294: {
                Expression e = this.XreadTableFunctionDerivedTable();
                table = e.getTable();
                isLateral = true;
                break;
            }
            default: {
                table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                    isTableName = true;
                    sysPeriodSpec = this.XreadQuerySystemPeriodSpecOrNull(table);
                }
                if (!table.isView()) break;
                table = ((View)table).newDerivedTable(this.session, this.compileContext);
            }
        }
        boolean hasAs = false;
        if (this.token.tokenType == 11) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            hasAs = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean limit = this.token.tokenType == 649 || this.token.tokenType == 202 || this.token.tokenType == 115;
            boolean minus = this.token.tokenType == 661;
            int position = this.getPosition();
            alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 937) {
                columnList = new OrderedHashSet();
                columnNameList = this.readColumnNameList(columnList);
            } else if (!hasAs && limit) {
                if (this.token.tokenType == 923 || this.token.tokenType == 939 || this.token.tokenType == 1011) {
                    alias = null;
                    this.rewind(position);
                }
            } else if (!hasAs && minus) {
                this.rewind(position);
            }
        }
        if (isTableName && alias == null && this.lastSynonym != null) {
            alias = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
        }
        if (this.database.sqlSyntaxMss && this.readIfThis(337)) {
            this.readNestedParenthesisedTokens();
        }
        if (joinedTable) {
            range = new RangeVariableJoined(table, alias, columnList, columnNameList, this.compileContext);
        } else {
            range = new RangeVariable(table, alias, columnList, columnNameList, this.compileContext);
            if (sysPeriodSpec != null) {
                RangeGroup[] ranges = this.compileContext.getOuterRanges();
                sysPeriodSpec.setSystemRangeVariable(this.session, ranges, range);
                range.setSystemPeriodCondition(sysPeriodSpec);
            }
        }
        if (isLateral) {
            range.isLateral = true;
        }
        return range;
    }

    private Expression readAggregateFunctionOrNull() {
        int position = this.getPosition();
        int tokenT = this.token.tokenType;
        this.read();
        if (this.token.tokenType != 937) {
            this.rewind(position);
            return null;
        }
        this.readThis(937);
        Expression expr = this.readAggregateExpression(tokenT);
        this.readThis(922);
        this.readFilterClause(expr);
        return expr;
    }

    private void readFilterClause(Expression e) {
        Expression condition = this.XreadFilterExpressionOrNull();
        if (condition != null) {
            e.setCondition(condition);
        }
    }

    Expression XreadFilterExpressionOrNull() {
        int position = this.getPosition();
        Expression condition = null;
        if (this.token.tokenType == 116) {
            this.read();
            if (this.token.tokenType != 937) {
                this.rewind(position);
                return null;
            }
            this.readThis(937);
            this.readThis(334);
            condition = this.XreadBooleanValueExpression();
            this.readThis(922);
        }
        return condition;
    }

    private Expression readAggregateExpression(int tokenT) {
        int type = ParserDQL.getExpressionType(tokenT);
        boolean distinct = false;
        boolean all = false;
        SortAndSlice sort = null;
        String separator = null;
        if (this.token.tokenType == 90) {
            distinct = true;
            this.read();
        } else if (this.token.tokenType == 2) {
            all = true;
            this.read();
        }
        int position = this.getPosition();
        Expression e = this.XreadValueExpression();
        switch (type) {
            case 74: {
                if (e.getType() == 99) {
                    if (((ExpressionColumn)e).tableName != null) {
                        throw this.unexpectedToken();
                    }
                    if (all || distinct) {
                        throw this.unexpectedToken();
                    }
                    e.opType = 11;
                    break;
                }
                if (this.token.tokenType != 924) break;
                this.rewind(position);
                e = this.XreadRowElementList(false);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                if (!all && !distinct) break;
                throw this.unexpectedToken(all ? "ALL" : "DISTINCT");
            }
            case 85: 
            case 86: {
                if (this.token.tokenType == 208) {
                    this.read();
                    this.readThis(27);
                    sort = this.XreadOrderBy();
                }
                if (type == 86 && this.token.tokenType == 682) {
                    this.read();
                    this.checkIsQuotedString();
                    separator = (String)this.token.tokenValue;
                    this.read();
                }
                return new ExpressionArrayAggregate(type, distinct, e, sort, separator);
            }
            case 87: {
                this.readThis(924);
                this.checkIsQuotedString();
                separator = (String)this.token.tokenValue;
                this.read();
                if (this.token.tokenType == 208) {
                    this.read();
                    this.readThis(27);
                    sort = this.XreadOrderBy();
                }
                return new ExpressionArrayAggregate(86, distinct, e, sort, separator);
            }
            case 89: {
                return new ExpressionArrayAggregate(type, distinct, e, sort, separator);
            }
            default: {
                if (e.getType() != 99 && e.getType() != 11) break;
                throw this.unexpectedToken("*");
            }
        }
        ExpressionAggregate aggregateExp = new ExpressionAggregate(type, distinct, e);
        return aggregateExp;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression e = null;
        boolean minus = false;
        switch (this.token.tokenType) {
            case 938: {
                this.read();
                break;
            }
            case 935: {
                this.read();
                minus = true;
                break;
            }
        }
        e = this.XreadUnsignedValueSpecificationOrNull();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 310: {
                this.read();
                return new ExpressionBoolean(true);
            }
            case 114: {
                this.read();
                return new ExpressionBoolean(false);
            }
            case 83: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn e = new ExpressionColumn(4);
                return e;
            }
            case 325: {
                if (!this.compileContext.onDuplicateTypedExpression) break;
                this.read();
                this.readThis(937);
                this.checkIsSimpleName();
                ExpressionColumn e = new ExpressionColumn(this.token.tokenString);
                this.read();
                this.readThis(922);
                return e;
            }
            case 196: {
                ExpressionValue e = new ExpressionValue(null, null);
                this.read();
                return e;
            }
            case 1011: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 1012: 
            case 1013: {
                if (!this.token.isHostParameter) {
                    return null;
                }
                return null;
            }
            case 923: 
            case 939: {
                return this.XreadDynamicParameterOrNull();
            }
            case 380: {
                return this.XreadCurrentCollationSpec();
            }
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 267: 
            case 293: 
            case 321: 
            case 323: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    return null;
                }
                return this.readSQLFunction(function);
            }
        }
        return null;
    }

    Expression XreadDynamicParameterOrNull() {
        switch (this.token.tokenType) {
            case 923: {
                this.read();
                if (this.isIntegral()) {
                    int pos = this.readInteger();
                    ExpressionColumn p = new ExpressionColumn(8, pos);
                    this.compileContext.addParameter(p, this.getPosition());
                    return p;
                }
                if (this.isUndelimitedSimpleName()) {
                    int pos = this.compileContext.parameters.size();
                    ExpressionColumn p = new ExpressionColumn(8, pos);
                    this.compileContext.addParameter(p, this.getPosition());
                    Token newToken = new Token();
                    newToken.tokenType = 1011;
                    newToken.dataType = Type.SQL_INTEGER;
                    newToken.tokenString = String.valueOf(p.parameterIndex);
                    this.replaceToken(newToken, null);
                    this.read();
                    return p;
                }
                throw this.unexpectedToken(":");
            }
            case 939: {
                int pos = this.compileContext.parameters.size();
                ExpressionColumn p = new ExpressionColumn(8, pos);
                this.compileContext.addParameter(p, this.getPosition());
                Token changedToken = new Token();
                changedToken.tokenType = 923;
                changedToken.tokenString = ":";
                Token newToken = new Token();
                newToken.tokenType = 1011;
                newToken.dataType = Type.SQL_INTEGER;
                newToken.tokenValue = p.parameterIndex;
                newToken.tokenString = String.valueOf(p.parameterIndex);
                this.replaceToken(changedToken, newToken);
                this.read();
                return p;
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 1011: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 923: 
            case 939: {
                return this.XreadDynamicParameterOrNull();
            }
            case 1012: 
            case 1013: {
                this.checkValidCatalogName(this.token.namePrePrePrefix);
                ExpressionColumn e = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
                this.read();
                return e;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean isBoolean) {
        Expression e = null;
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 109: 
            case 315: {
                if (!isBoolean) break;
                return this.XreadPredicate();
            }
            case 220: {
                if (isBoolean) break;
                this.read();
                if (this.readIfThis(937)) {
                    e = this.XreadRowElementList(true);
                    if (e.nodes.length != 2) {
                        throw Error.error(5564);
                    }
                    e = new ExpressionPeriod(e);
                    this.readThis(922);
                    break;
                }
                this.rewind(position);
                e = this.XreadSimpleValueExpressionPrimary();
                if (e == null) break;
                e = this.XreadArrayElementReference(e);
                break;
            }
            case 257: {
                if (isBoolean) break;
                this.read();
                this.readThis(937);
                e = this.XreadRowElementList(true);
                this.readThis(922);
                break;
            }
            default: {
                e = this.XreadSimpleValueExpressionPrimary();
                if (e == null) break;
                e = this.XreadArrayElementReference(e);
            }
        }
        if (e == null) {
            if (this.token.tokenType == 257) {
                this.read();
                this.checkIsThis(937);
            } else if (this.token.tokenType == 220) {
                this.read();
                if (this.readIfThis(937)) {
                    e = this.XreadRowElementList(true);
                    if (e.nodes.length != 2) {
                        throw Error.error(5564);
                    }
                    e = new ExpressionPeriod(e);
                    this.readThis(922);
                } else {
                    this.rewind(position);
                    e = this.XreadSimpleValueExpressionPrimary();
                    if (e != null) {
                        e = this.XreadArrayElementReference(e);
                    }
                }
            }
            if (this.token.tokenType == 937) {
                this.read();
                e = this.XreadRowElementList(true);
                this.readThis(922);
            }
        }
        if (isBoolean && e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadValueExpressionPrimary() {
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            e = this.XreadArrayElementReference(e);
            return e;
        }
        if (this.token.tokenType != 937) {
            return null;
        }
        this.read();
        e = this.XreadValueExpression();
        this.readThis(922);
        return e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Expression XreadSimpleValueExpressionPrimary() {
        Expression e = this.XreadUnsignedValueSpecificationOrNull();
        if (e != null) {
            return e;
        }
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 937: {
                this.read();
                int subqueryPosition = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 265: 
                    case 294: 
                    case 325: 
                    case 337: {
                        TableDerived td = null;
                        this.rewind(subqueryPosition);
                        try {
                            td = this.XreadSubqueryTableBody(21);
                            this.readThis(922);
                        }
                        catch (HsqlException ex) {
                            ex.setLevel(this.compileContext.subqueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                                this.lastError = ex;
                            }
                            this.rewind(position);
                            return null;
                        }
                        if (td.queryExpression != null) {
                            e = td.queryExpression.isSingleColumn() ? new Expression(21, td) : new Expression(22, td);
                        }
                        if (e != null) {
                            return e;
                        }
                        this.rewind(position);
                        return null;
                    }
                }
                this.rewind(position);
                return null;
            }
            case 921: {
                e = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.getRecordedToken().setExpression(e);
                this.read();
                return e;
            }
            case 764: {
                e = this.readLeastExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 752: {
                e = this.readGreatestExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 744: {
                e = this.readDecodeExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 718: {
                e = this.readConcatExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 719: {
                e = this.readConcatSeparatorExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 439: 
            case 614: {
                e = this.readCaseWhenExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 32: {
                return this.readCaseExpression();
            }
            case 197: {
                return this.readNullIfExpression();
            }
            case 43: {
                return this.readCoalesceExpression();
            }
            case 754: 
            case 761: {
                e = this.readIfNullExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 666: {
                e = this.readIfNull2ExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 33: {
                e = this.readCastExpression();
                if (e == null) break;
                return e;
            }
            case 53: {
                e = this.readConvertExpressionOrNull();
                if (e == null) break;
                return e;
            }
            case 77: 
            case 150: 
            case 297: 
            case 298: {
                e = this.readDateTimeIntervalLiteral(this.session);
                if (e == null) break;
                return e;
            }
            case 8: {
                return this.readCollection(19);
            }
            case 6: 
            case 9: 
            case 17: 
            case 56: 
            case 105: 
            case 173: 
            case 178: 
            case 272: 
            case 283: 
            case 284: 
            case 289: 
            case 326: 
            case 327: 
            case 658: 
            case 753: 
            case 817: {
                e = this.readAggregateFunctionOrNull();
                if (e == null) break;
                return e;
            }
            case 486: {
                e = this.readSequenceExpressionOrNull(12);
                if (e == null) break;
                return e;
            }
            case 63: 
            case 671: {
                e = this.readSequenceExpressionOrNull(13);
                if (e == null) break;
                return e;
            }
            case 624: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(937);
                String spec = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(this.session, spec);
                scanner.scanNext();
                String schemaName = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence sequence = this.database.schemaManager.getSequence(scanner.token.tokenString, schemaName, true);
                e = new ExpressionColumn(sequence, 13);
                this.readThis(922);
                return e;
            }
            case 648: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(937);
                this.readThis(922);
                return FunctionCustom.newCustomFunction(this.session, "IDENTITY", 138);
            }
            case 663: {
                if (this.database.sqlSyntaxPgs) {
                    return this.readNextvalFunction();
                }
                if (!this.database.sqlSyntaxDb2 || (e = this.readSequenceExpressionOrNull(12)) == null) break;
                return e;
            }
            case 258: {
                this.read();
                if (this.token.tokenType == 937) {
                    this.read();
                    this.readThis(922);
                    this.readThis(211);
                    this.readThis(937);
                    this.readThis(922);
                    return new ExpressionColumn(14);
                }
                this.rewind(position);
                break;
            }
            case 680: {
                this.read();
                if (this.token.tokenType == 937) {
                    this.read();
                    if (this.token.tokenType == 922) {
                        this.read();
                        return new ExpressionColumn(14);
                    }
                    this.rewind(position);
                    break;
                }
                if (this.database.sqlSyntaxOra) return new ExpressionColumn(14);
                if (this.database.sqlSyntaxDb2) return new ExpressionColumn(14);
                this.rewind(position);
                break;
            }
            case 163: 
            case 254: {
                break;
            }
            case 294: {
                this.read();
                this.readThis(937);
                TableDerived td = this.XreadSubqueryTableBody(23);
                this.readThis(922);
                return new Expression(23, td);
            }
            case 325: {
                throw this.unexpectedToken();
            }
            case 133: {
                this.read();
                this.readThis(937);
                Expression groupingElements = this.XreadRowElementList(true);
                this.readThis(922);
                return new ExpressionColumn(groupingElements);
            }
            case 453: {
                this.read();
                return this.readJSONArray();
            }
            case 454: {
                this.read();
                return this.readJSONArrayAgg();
            }
            case 456: {
                this.read();
                return this.readJSONObject();
            }
            case 457: {
                this.read();
                return this.readJSONObjectAgg();
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        if (!(e = this.readColumnOrFunctionExpression()).isSelfAggregate()) return e;
        this.readFilterClause(e);
        return e;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Expression readJSONArray() {
        list = new HsqlArrayList<Expression>();
        qe = null;
        nullOnNull = true;
        dataType /* !! */  = Type.SQL_VARCHAR_LONG;
        this.readThis(937);
        position = this.getPosition();
        block6: while (true) {
            switch (this.token.tokenType) {
                case 196: 
                case 352: 
                case 922: {
                    break block6;
                }
                case 924: {
                    if (list.size() == 0) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
                default: {
                    try {
                        value = this.XreadValueExpression();
                        list.add(value);
                        continue block6;
                    }
                    catch (HsqlException e) {
                        if (list.size() > 0) {
                            throw e;
                        }
                        this.rewind(position);
                        ** break;
lbl26:
                        // 1 sources

                        break block6;
                    }
                }
            }
        }
        if (list.size() == 0 && this.token.tokenType != 922) {
            td = this.XreadSubqueryTableBody(23);
            qe = new Expression(102, td);
        }
        nullOnNull = this.readJSONNullClause(nullOnNull);
        if (this.readIfThis(531)) {
            dataType /* !! */  = this.readJSONReturningClause();
        }
        this.readThis(922);
        if (qe == null) {
            return new ExpressionJSON.ExpressionJSONArrayFromValues(list, nullOnNull, dataType /* !! */ );
        }
        return new ExpressionJSON.ExpressionJSONArrayFromQuery(qe, nullOnNull, dataType /* !! */ );
    }

    Expression readJSONArrayAgg() {
        boolean nullOnNull = false;
        Type dataType = Type.SQL_VARCHAR_LONG;
        SortAndSlice sort = null;
        this.readThis(937);
        Expression valueExpr = this.XreadValueExpression();
        if (this.token.tokenType == 208) {
            this.read();
            this.readThis(27);
            sort = this.XreadOrderBy();
        }
        ExpressionArrayAggregate arrayAgg = new ExpressionArrayAggregate(85, false, valueExpr, sort, null);
        nullOnNull = this.readJSONNullClause(nullOnNull);
        if (this.readIfThis(531)) {
            dataType = this.readJSONReturningClause();
        }
        this.readThis(922);
        return new ExpressionJSON.ExpressionJSONArrayAgg(arrayAgg, nullOnNull, dataType);
    }

    Expression readJSONObject() {
        OrderedHashMap<Expression, Expression> map = new OrderedHashMap<Expression, Expression>();
        boolean nullOnNull = true;
        boolean uniqueKeys = false;
        Type dataType = Type.SQL_VARCHAR_LONG;
        boolean hasDuplicate = false;
        this.readThis(937);
        block4: while (true) {
            boolean isKey = false;
            switch (this.token.tokenType) {
                case 196: 
                case 337: 
                case 339: 
                case 352: 
                case 922: {
                    break block4;
                }
                case 924: {
                    if (map.size() == 0) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
                default: {
                    Expression e;
                    if (this.readIfThis(463)) {
                        isKey = true;
                    }
                    int position = this.getPosition();
                    Expression nameExpr = this.XreadCharacterValueExpression();
                    if (nameExpr.opType == 103) {
                        this.rewind(position);
                        throw this.unexpectedToken();
                    }
                    if (!this.readIfThis(323)) {
                        if (isKey) {
                            throw this.unexpectedToken();
                        }
                        this.readThis(923);
                    }
                    Expression valueExpr = this.XreadValueExpression();
                    if (this.readIfThis(429)) {
                        this.readThis(452);
                        valueExpr = new ExpressionJSON.ExpressionJSONWrapper(valueExpr);
                    }
                    if ((e = map.put(nameExpr, valueExpr)) == null) continue block4;
                    hasDuplicate = true;
                    continue block4;
                }
            }
            break;
        }
        nullOnNull = this.readJSONNullClause(nullOnNull);
        uniqueKeys = this.readJSONUniqueClause(uniqueKeys);
        if (uniqueKeys && hasDuplicate) {
            throw Error.error(104);
        }
        if (this.readIfThis(531)) {
            dataType = this.readJSONReturningClause();
        }
        this.readThis(922);
        return new ExpressionJSON.ExpressionJSONObject(map, nullOnNull, uniqueKeys, dataType);
    }

    Expression readJSONObjectAgg() {
        boolean nullOnNull = true;
        boolean uniqueKeys = false;
        Type dataType = Type.SQL_VARCHAR_LONG;
        this.readThis(937);
        int position = this.getPosition();
        Expression nameExpr = this.XreadCharacterValueExpression();
        if (nameExpr.opType == 103) {
            this.rewind(position);
            throw this.unexpectedToken();
        }
        this.readThis(923);
        Expression valueExpr = this.XreadValueExpression();
        ExpressionArrayAggregate arrayAggName = new ExpressionArrayAggregate(85, false, nameExpr, null, null);
        ExpressionArrayAggregate arrayAggValue = new ExpressionArrayAggregate(85, false, valueExpr, null, null);
        nullOnNull = this.readJSONNullClause(nullOnNull);
        uniqueKeys = this.readJSONUniqueClause(uniqueKeys);
        if (this.readIfThis(531)) {
            dataType = this.readJSONReturningClause();
        }
        this.readThis(922);
        return new ExpressionJSON.ExpressionJSONObjectAgg(arrayAggName, arrayAggValue, nullOnNull, uniqueKeys, dataType);
    }

    boolean readJSONNullClause(boolean defaultValue) {
        boolean nullOnNull = defaultValue;
        switch (this.token.tokenType) {
            case 352: {
                this.read();
                this.readThis(204);
                this.readThis(196);
                nullOnNull = false;
                break;
            }
            case 196: {
                this.read();
                this.readThis(204);
                this.readThis(196);
                nullOnNull = true;
            }
        }
        return nullOnNull;
    }

    boolean readJSONUniqueClause(boolean defaultValue) {
        boolean uniqueKeys = defaultValue;
        switch (this.token.tokenType) {
            case 337: {
                this.read();
                this.readThis(315);
                this.readIfThis(466);
                uniqueKeys = true;
                break;
            }
            case 339: {
                this.read();
                this.readThis(315);
                this.readIfThis(466);
                uniqueKeys = false;
            }
        }
        return uniqueKeys;
    }

    Type readJSONReturningClause() {
        int position = this.getPosition();
        Type dataType = this.readTypeDefinition(false, true);
        if (dataType.typeCode == 12 || dataType.typeCode == 40) {
            return dataType;
        }
        this.rewind(position);
        throw super.unexpectedTokenRequire("VARCHAR or CLOB");
    }

    Expression readNextvalFunction() {
        this.read();
        this.readThis(937);
        String spec = this.readQuotedString();
        Scanner scanner = this.session.getScanner();
        scanner.reset(this.session, spec);
        scanner.scanNext();
        String schemaName = this.session.getSchemaName(scanner.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(scanner.token.tokenString, schemaName, true);
        ExpressionColumn e = new ExpressionColumn(sequence, 12);
        this.readThis(922);
        return e;
    }

    Expression XreadAllTypesPrimary(boolean boole) {
        Expression e = null;
        switch (this.token.tokenType) {
            case 1: 
            case 10: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 111: 
            case 113: 
            case 119: 
            case 166: 
            case 171: 
            case 174: 
            case 180: 
            case 192: 
            case 199: 
            case 200: 
            case 213: 
            case 222: 
            case 223: 
            case 224: 
            case 279: 
            case 286: 
            case 287: 
            case 304: 
            case 308: 
            case 320: 
            case 335: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw this.unsupportedFeature();
                }
                e = this.readSQLFunction(function);
                if (e != null) break;
            }
            default: {
                e = this.XreadAllTypesValueExpressionPrimary(boole);
            }
        }
        e = this.XreadModifier(e);
        return e;
    }

    Expression XreadModifier(Expression e) {
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 14: {
                this.read();
                Expression e1 = null;
                if (this.token.tokenType == 167) {
                    this.read();
                } else if (this.token.tokenType == 297) {
                    this.read();
                    this.readThis(593);
                    e1 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 78: 
                        case 137: 
                        case 179: 
                        case 183: 
                        case 264: 
                        case 341: {
                            IntervalType type = this.readIntervalType(this.session, false);
                            if (e1.getType() == 33) {
                                e1.dataType = type;
                                break;
                            }
                            e1 = new ExpressionOp(e1, type);
                            break;
                        }
                    }
                } else {
                    this.rewind(position);
                    return e;
                }
                e = new ExpressionOp(93, e, e1);
                break;
            }
            case 78: 
            case 137: 
            case 179: 
            case 183: 
            case 264: 
            case 341: {
                IntervalType type = this.readIntervalType(this.session, true);
                if (e.getType() == 33) {
                    e.dataType = type;
                    break;
                }
                e = new ExpressionOp(e, type);
                break;
            }
            case 44: {
                this.read();
                Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                e.setCollation(collation);
                this.read();
            }
        }
        return e;
    }

    Expression XreadValueExpressionWithContext() {
        Expression e;
        this.compileContext.contextuallyTypedExpression = true;
        try {
            e = this.XreadValueExpression();
        }
        finally {
            this.compileContext.contextuallyTypedExpression = false;
        }
        return e;
    }

    Expression XreadValueExpressionOnDuplicate() {
        Expression e;
        this.compileContext.onDuplicateTypedExpression = true;
        try {
            e = this.XreadValueExpression();
        }
        finally {
            this.compileContext.onDuplicateTypedExpression = false;
        }
        return e;
    }

    Expression XreadGroupByExpressionPrimary() {
        if (this.token.tokenType == 133) {
            this.read();
            this.readThis(553);
            this.readThis(937);
            HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
            while (true) {
                Expression e = this.XreadGroupByExpressionPrimary();
                list.add(e);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            this.readThis(922);
            Expression[] array = new Expression[list.size()];
            list.toArray(array);
            Expression e = new Expression(26, array);
            e.groupingType = 553;
            return e;
        }
        Expression e = this.XreadGroupByExpression();
        return e;
    }

    Expression XreadGroupByExpression() {
        int groupingType = 0;
        switch (this.token.tokenType) {
            case 61: 
            case 256: {
                groupingType = this.token.tokenType;
                this.read();
                this.readThis(937);
                Expression e = this.XreadRowElementList(true);
                this.readThis(922);
                this.checkIfGroupingOrAggregate(e);
                e.groupingType = groupingType;
                return e;
            }
            case 937: {
                int position = this.getPosition();
                this.read();
                if (this.token.tokenType == 922) {
                    this.read();
                    return new ExpressionColumn(0);
                }
                this.rewind(position);
                Expression e = this.XreadValueExpression();
                this.checkIfGroupingOrAggregate(e);
                return e;
            }
        }
        Expression e = this.XreadValueExpression();
        this.checkIfGroupingOrAggregate(e);
        return e;
    }

    private void checkIfGroupingOrAggregate(Expression e) {
        if (e == null) {
            return;
        }
        if (105 == e.opType || OpTypes.subqueryAggregateExpressionSet.contains(e.opType)) {
            throw Error.error(5572, "aggregate functions / subqueries are not allowed in GROUP BY");
        }
        for (int i = 0; i < e.nodes.length; ++i) {
            this.checkIfGroupingOrAggregate(e.nodes[i]);
        }
    }

    Expression XreadValueExpression() {
        Expression e = this.XreadAllTypesCommonValueExpression(true);
        if (this.token.tokenType == 932) {
            this.read();
            Expression e1 = this.XreadNumericValueExpression();
            this.readThis(942);
            e = new ExpressionAccessor(e, e1);
        }
        return e;
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean boole) {
        Expression e = this.XreadAllTypesTerm(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 938: {
                    type = 32;
                    boole = false;
                    break;
                }
                case 935: {
                    type = 33;
                    boole = false;
                    break;
                }
                case 925: {
                    type = 36;
                    boole = false;
                    break;
                }
                case 207: {
                    if (boole) {
                        type = 50;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesTerm(boole);
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesTerm(boolean boole) {
        Expression e = this.XreadAllTypesFactor(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 921: {
                    type = 34;
                    boole = false;
                    break;
                }
                case 926: {
                    type = 35;
                    boole = false;
                    break;
                }
                case 5: {
                    if (boole) {
                        type = 49;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesFactor(boole);
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesFactor(boolean boole) {
        boolean minus = false;
        boolean not = false;
        boolean unknown = false;
        switch (this.token.tokenType) {
            case 938: {
                this.read();
                boole = false;
                break;
            }
            case 935: {
                this.read();
                boole = false;
                minus = true;
                break;
            }
            case 193: {
                if (!boole) break;
                this.read();
                not = true;
                break;
            }
        }
        Expression e = this.XreadAllTypesPrimary(boole);
        if (boole && this.token.tokenType == 152) {
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                boolean bl = not = !not;
            }
            if (this.token.tokenType == 310) {
                this.read();
            } else if (this.token.tokenType == 114) {
                this.read();
                not = !not;
            } else if (this.token.tokenType == 316) {
                this.read();
                unknown = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        }
        if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression e = this.XreadCharacterPrimary();
        Collation collation = this.readCollateClauseOrNull();
        while (this.token.tokenType == 925 || this.token.tokenType == 938) {
            this.read();
            Expression a = e;
            e = this.XreadCharacterPrimary();
            collation = this.readCollateClauseOrNull();
            e = new ExpressionArithmetic(36, a, e);
        }
        return e;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 171: 
            case 213: 
            case 286: 
            case 308: 
            case 320: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 111: 
            case 113: 
            case 119: 
            case 166: 
            case 180: 
            case 200: 
            case 222: 
            case 224: 
            case 279: 
            case 335: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw this.unexpectedToken();
                }
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression e = this.XreadTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 938) {
                type = 32;
            } else {
                if (this.token.tokenType != 935) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadTerm() {
        Expression e = this.XreadFactor();
        while (true) {
            int type;
            if (this.token.tokenType == 921) {
                type = 34;
            } else {
                if (this.token.tokenType != 926) break;
                type = 35;
            }
            this.read();
            Expression a = e;
            e = this.XreadFactor();
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadFactor() {
        boolean minus = false;
        if (this.token.tokenType == 938) {
            this.read();
        } else if (this.token.tokenType == 935) {
            this.read();
            minus = true;
        }
        Expression e = this.XreadNumericPrimary();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadDatetimeValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 938) {
                type = 32;
            } else {
                if (this.token.tokenType != 935) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadIntervalValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 938) {
                type = 32;
            } else {
                if (this.token.tokenType != 935) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 65: 
            case 71: 
            case 72: 
            case 168: 
            case 169: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw this.unexpectedToken();
                }
                return this.readSQLFunction(function);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL function = null;
        switch (this.token.tokenType) {
            case 65: 
            case 71: 
            case 72: 
            case 168: 
            case 169: {
                function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 781: 
            case 821: 
            case 822: 
            case 837: {
                function = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
                if (function != null) break;
                return null;
            }
            default: {
                return null;
            }
        }
        if (function == null) {
            throw this.unexpectedToken();
        }
        return this.readSQLFunction(function);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression e = this.XreadBooleanTermOrNull();
            if (e == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 207) {
                int type = 50;
                this.read();
                Expression a = e;
                e = this.XreadBooleanTermOrNull();
                if (e == null) {
                    throw Error.error(5568);
                }
                e = new ExpressionLogical(type, a, e);
            }
            if (e == null) {
                throw Error.error(5568);
            }
            return e;
        }
        catch (HsqlException ex) {
            ex.setLevel(this.compileContext.subqueryDepth);
            if (this.lastError != null && this.lastError.getLevel() >= ex.getLevel()) {
                ex = this.lastError;
                this.lastError = null;
            }
            throw ex;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression e = this.XreadBooleanFactorOrNull();
        if (e == null) {
            return null;
        }
        while (this.token.tokenType == 5) {
            int type = 49;
            this.read();
            Expression a = e;
            e = this.XreadBooleanFactorOrNull();
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = new ExpressionLogical(type, a, e);
        }
        return e;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression e;
        boolean not = false;
        if (this.token.tokenType == 193) {
            this.read();
            not = true;
        }
        if ((e = this.XreadBooleanTestOrNull()) == null) {
            return null;
        }
        if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadBooleanTestOrNull() {
        boolean unknown = false;
        boolean isNot = false;
        Expression e = this.XreadBooleanPrimaryOrNull();
        if (e == null) {
            return e;
        }
        if (this.token.tokenType == 152) {
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                isNot = true;
            }
            if (this.token.tokenType == 310) {
                this.read();
                e = new ExpressionLogical(e, (Expression)new ExpressionBoolean(true));
            } else if (this.token.tokenType == 114) {
                this.read();
                e = new ExpressionLogical(e, (Expression)new ExpressionBoolean(false));
            } else if (this.token.tokenType == 316) {
                this.read();
                unknown = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        }
        if (isNot) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int position;
        Expression e = null;
        switch (this.token.tokenType) {
            case 109: 
            case 315: {
                return this.XreadPredicate();
            }
            case 257: {
                this.read();
                this.readThis(937);
                e = this.XreadRowElementList(true);
                this.readThis(922);
                break;
            }
            default: {
                position = this.getPosition();
                try {
                    e = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException ex) {
                    ex.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                        this.lastError = ex;
                    }
                    this.rewind(position);
                }
            }
        }
        if (e == null && this.token.tokenType == 937) {
            this.read();
            position = this.getPosition();
            try {
                e = this.XreadRowElementList(true);
                this.readThis(922);
            }
            catch (HsqlException ex) {
                ex.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                    this.lastError = ex;
                }
                this.rewind(position);
                e = this.XreadBooleanValueExpression();
                this.readThis(922);
            }
        }
        if (e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadBooleanPredicand() {
        Expression e;
        if (this.token.tokenType == 937) {
            this.read();
            e = this.XreadBooleanValueExpression();
            this.readThis(922);
        } else {
            e = this.XreadSimpleValueExpressionPrimary();
            if (e != null) {
                e = this.XreadArrayElementReference(e);
            }
        }
        return e;
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 109: {
                this.read();
                Expression s = this.XreadTableSubquery(55);
                return new ExpressionLogical(55, s);
            }
            case 315: {
                this.read();
                Expression s = this.XreadTableSubquery(66);
                return new ExpressionLogical(66, s);
            }
        }
        Expression a = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(a);
    }

    Expression XreadPredicateRightPart(Expression l) {
        boolean hasNot = false;
        boolean immediately = false;
        ExpressionLogical e = null;
        int position = this.getPosition();
        if (this.token.tokenType == 193) {
            this.read();
            hasNot = true;
        }
        if (this.token.tokenType == 641) {
            this.read();
            if (this.token.tokenType != 225 && this.token.tokenType != 288) {
                throw this.unexpectedToken();
            }
            immediately = true;
        }
        block0 : switch (this.token.tokenType) {
            case 152: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 193) {
                    hasNot = true;
                    this.read();
                }
                if (this.token.tokenType == 196) {
                    this.read();
                    if (hasNot) {
                        e = new ExpressionLogical(39, l);
                        hasNot = false;
                        break;
                    }
                    e = new ExpressionLogical(47, l);
                    break;
                }
                if (this.token.tokenType == 90) {
                    this.read();
                    this.readThis(124);
                    Expression r = this.XreadRowValuePredicand();
                    e = new ExpressionLogical(67, l, r);
                    hasNot = !hasNot;
                    break;
                }
                this.rewind(position);
                return l;
            }
            case 164: {
                e = this.XreadLikePredicateRightPart(l);
                break;
            }
            case 21: {
                e = this.XreadBetweenPredicateRightPart(l);
                break;
            }
            case 140: {
                e = this.XreadInPredicateRightPart(l);
                break;
            }
            case 52: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                e = this.XreadPeriodPredicateRightPart(59, l);
                break;
            }
            case 103: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                e = this.XreadPeriodPredicateRightPart(60, l);
                break;
            }
            case 212: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                e = this.XreadPeriodPredicateRightPart(61, l);
                break;
            }
            case 225: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                if (immediately) {
                    e = this.XreadPeriodPredicateRightPart(64, l);
                    break;
                }
                e = this.XreadPeriodPredicateRightPart(62, l);
                break;
            }
            case 288: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                if (immediately) {
                    e = this.XreadPeriodPredicateRightPart(65, l);
                    break;
                }
                e = this.XreadPeriodPredicateRightPart(63, l);
                break;
            }
            case 420: 
            case 929: 
            case 930: 
            case 933: 
            case 934: 
            case 936: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                int type = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 2: 
                    case 6: 
                    case 272: {
                        e = this.XreadQuantifiedComparisonRightPart(type, l);
                        break block0;
                    }
                }
                Expression row = this.XreadRowValuePredicand();
                e = new ExpressionLogical(type, l, row);
                break;
            }
            case 172: {
                e = this.XreadMatchPredicateRightPart(l);
                break;
            }
            default: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                return l;
            }
        }
        if (hasNot) {
            e = new ExpressionLogical(48, (Expression)e);
        }
        return e;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression a) {
        boolean symmetric = false;
        this.read();
        if (this.token.tokenType == 13) {
            this.read();
        } else if (this.token.tokenType == 290) {
            symmetric = true;
            this.read();
        }
        Expression left = this.XreadRowValuePredicand();
        this.readThis(5);
        Expression right = this.XreadRowValuePredicand();
        ExpressionLogical l = new ExpressionLogical(41, a, left);
        ExpressionLogical r = new ExpressionLogical(45, a, right);
        ExpressionLogical leftToRight = new ExpressionLogical(49, l, r);
        if (symmetric) {
            l = new ExpressionLogical(45, a, left);
            r = new ExpressionLogical(41, a, right);
            ExpressionLogical rightToLeft = new ExpressionLogical(49, l, r);
            return new ExpressionLogical(50, leftToRight, rightToLeft);
        }
        return leftToRight;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int exprType, Expression l) {
        Expression e;
        int tokenType = this.token.tokenType;
        int exprSubType = 0;
        switch (this.token.tokenType) {
            case 6: 
            case 272: {
                exprSubType = 52;
                break;
            }
            case 2: {
                exprSubType = 51;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ParserDQL");
            }
        }
        this.read();
        this.readThis(937);
        int position = this.getPosition();
        int brackets = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 317: {
                e = this.XreadCollectionDerivedTable(54);
                this.readThis(922);
                this.readCloseBrackets(brackets);
                break;
            }
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                this.rewind(position);
                TableDerived td = this.XreadSubqueryTableBody(54);
                e = new Expression(23, td);
                this.readThis(922);
                break;
            }
            default: {
                this.rewind(position);
                e = this.readAggregateExpression(tokenType);
                this.readThis(922);
                this.readFilterClause(e);
            }
        }
        ExpressionLogical r = new ExpressionLogical(exprType, l, e);
        r.setSubType(exprSubType);
        return r;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression l) {
        int degree = l.getDegree();
        Expression e = null;
        this.read();
        this.readThis(937);
        int position = this.getPosition();
        int brackets = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 317: {
                e = this.XreadCollectionDerivedTable(54);
                this.readThis(922);
                this.readCloseBrackets(brackets);
                break;
            }
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                this.rewind(position);
                TableDerived td = this.XreadSubqueryTableBody(54);
                e = new Expression(23, td);
                this.readThis(922);
                break;
            }
            default: {
                this.rewind(position);
                e = this.XreadInValueListConstructor(degree);
                this.readThis(922);
            }
        }
        ExpressionLogical r = new ExpressionLogical(40, l, e);
        r.setSubType(52);
        return r;
    }

    Expression XreadInValueList(int degree) {
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        while (true) {
            Expression e;
            if ((e = this.XreadValueExpression()).getType() != 25) {
                e = new Expression(25, new Expression[]{e});
            }
            list.add(e);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        Expression e = new Expression(26, array);
        for (int i = 0; i < array.length; ++i) {
            Expression[] args;
            if (array[i].getType() != 25) {
                array[i] = new Expression(25, new Expression[]{array[i]});
            }
            if ((args = array[i].nodes).length != degree) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < degree; ++j) {
                if (args[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return e;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression a) {
        this.read();
        Expression b = this.XreadStringValueExpression();
        Expression escape = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            escape = this.XreadStringValueExpression();
        }
        return new ExpressionLike(a, b, escape);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression a) {
        boolean isUnique = false;
        int matchType = 68;
        this.read();
        if (this.token.tokenType == 315) {
            this.read();
            isUnique = true;
        }
        switch (this.token.tokenType) {
            default: {
                matchType = isUnique ? 71 : 68;
                break;
            }
            case 554: {
                this.read();
                matchType = isUnique ? 71 : 68;
                break;
            }
            case 510: {
                this.read();
                matchType = isUnique ? 72 : 69;
                break;
            }
            case 125: {
                this.read();
                matchType = isUnique ? 73 : 70;
            }
        }
        int mode = isUnique ? 68 : 54;
        Expression s = this.XreadTableSubquery(mode);
        return new ExpressionLogical(matchType, a, s);
    }

    private ExpressionLogical XreadPeriodPredicateRightPart(int opType, Expression left) {
        boolean isLeftRow = false;
        switch (left.getType()) {
            case 2: {
                left = new ExpressionPeriod((ExpressionColumn)left);
                break;
            }
            case 57: {
                break;
            }
            case 25: {
                if (left.nodes.length != 2) {
                    throw Error.error(5564);
                }
                isLeftRow = true;
                break;
            }
            default: {
                throw Error.error(5564);
            }
        }
        this.read();
        boolean period = false;
        if (this.token.tokenType == 220) {
            if (isLeftRow) {
                throw this.unexpectedToken();
            }
            this.read();
            period = true;
            if (this.token.tokenType != 937) {
                throw this.unexpectedTokenRequire("(");
            }
        }
        Expression right = this.XreadRowValuePredicand();
        switch (right.getType()) {
            case 2: {
                if (period) {
                    throw Error.error(5564);
                }
                right = new ExpressionPeriod((ExpressionColumn)right);
                break;
            }
            case 25: {
                if (right.nodes.length == 2) {
                    if (period) {
                        right = new ExpressionPeriod(right);
                        break;
                    }
                    if (opType != 61) {
                        throw Error.error(5564);
                    }
                    return new ExpressionLogical(56, left, right);
                }
                throw Error.error(5564);
            }
            default: {
                if (opType != 59) {
                    throw Error.error(5564);
                }
                if (!period) break;
                throw Error.error(5564);
            }
        }
        return new ExpressionPeriodOp(opType, left, right);
    }

    Expression XreadRowValueExpression() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            e = this.XreadArrayElementReference(e);
        }
        return e;
    }

    Expression XreadRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        e = this.XreadRowOrCommonValueExpression();
        if (e != null) {
            return e;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 937: {
                this.read();
                int position = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 265: 
                    case 294: 
                    case 325: {
                        this.rewind(position);
                        TableDerived td = this.XreadSubqueryTableBody(22);
                        this.readThis(922);
                        return new Expression(22, td);
                    }
                }
                this.rewind(position);
                Expression e = this.XreadRowElementList(true);
                this.readThis(922);
                return e;
            }
            case 257: {
                this.read();
                this.readThis(937);
                Expression e = this.XreadRowElementList(false);
                this.readThis(922);
                return e;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean multiple) {
        Expression e;
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        while (true) {
            e = this.XreadValueExpression();
            list.add(e);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (multiple && list.size() == 1) {
            return e;
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        return new Expression(25, array);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadTableSubquery(int mode) {
        this.readThis(937);
        TableDerived td = this.XreadSubqueryTableBody(mode);
        this.readThis(922);
        return new Expression(23, td);
    }

    Table XreadTableSubqueryOrNull(boolean parens) {
        boolean joinedTable = false;
        int position = this.getPosition();
        this.readThis(937);
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                break;
            }
            case 937: {
                if (parens) break;
            }
            default: {
                joinedTable = true;
            }
        }
        if (joinedTable) {
            this.rewind(position);
            return null;
        }
        TableDerived td = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return td;
    }

    TableDerived XreadJoinedTableAsSubqueryOrNull() {
        int position = this.getPosition();
        ParserBase.Recorder recorder = this.startRecording();
        this.readThis(937);
        this.compileContext.incrementDepth();
        QuerySpecification qs = this.XreadJoinedTableAsView();
        qs.resolveReferences(this.session, this.compileContext.getOuterRanges());
        if (qs.rangeVariables.length < 2) {
            this.compileContext.decrementDepth();
            this.rewind(position);
            return null;
        }
        qs.resolveTypesPartOne(this.session);
        qs.resolveTypesPartTwo(this.session);
        TableDerived td = this.newSubQueryTable(qs, 23);
        this.readThis(922);
        String sql = recorder.getSQL();
        td.setSQL(sql);
        td.prepareTable(this.session);
        this.compileContext.decrementDepth();
        return td;
    }

    QuerySpecification XreadJoinedTableAsView() {
        QuerySpecification select = new QuerySpecification(this.compileContext);
        ExpressionColumn e = new ExpressionColumn(99);
        select.addSelectColumnExpression(e);
        this.XreadTableReference(select);
        return select;
    }

    TableDerived XreadTableNamedSubqueryBody(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames) {
        TableDerived td;
        Object namedtd = null;
        int position = this.getPosition();
        if (columnNames == null) {
            td = this.XreadSubqueryTableBody(name, 23);
            if (td.queryExpression != null) {
                td.queryExpression.resolve(this.session, this.compileContext.getOuterRanges(), null);
            }
            td.prepareTable(this.session);
        } else {
            try {
                td = this.XreadSubqueryTableBody(name, 23);
                if (td.queryExpression != null) {
                    td.queryExpression.resolve(this.session, this.compileContext.getOuterRanges(), null);
                }
                td.prepareTable(this.session, columnNames);
            }
            catch (HsqlException e) {
                String token;
                HsqlException ex = e;
                if (e.getErrorCode() != 5501 && this.lastError != null && this.lastError.getErrorCode() == -5501) {
                    ex = this.lastError;
                }
                if ("RECURSIVE_TABLE".equals(token = ex.getToken()) || name.name.equals(token)) {
                    this.rewind(position);
                    td = this.XreadRecursiveSubqueryBody(name, columnNames);
                }
                throw e;
            }
        }
        return td;
    }

    TableDerived XreadRecursiveSubqueryBody(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames) {
        int position = this.getPosition();
        QuerySpecification leftQueryExpression = this.XreadSimpleTable();
        leftQueryExpression.isBaseMergeable = false;
        leftQueryExpression.isMergeable = false;
        ((QueryExpression)leftQueryExpression).resolveReferences(this.session, this.compileContext.getOuterRanges());
        leftQueryExpression.resolve(this.session);
        HsqlNameManager.HsqlName leftName = this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false, 27);
        TableDerived leftTable = new TableDerived(this.database, leftName, 2, columnNames, ((QueryExpression)leftQueryExpression).getColumnTypes());
        TableDerived workTable = new TableDerived(this.database, name, 2, columnNames, ((QueryExpression)leftQueryExpression).getColumnTypes());
        HsqlNameManager.HsqlName recursiveName = this.database.nameManager.newHsqlName("RECURSIVE_TABLE", false, 27);
        TableDerived recursiveTable = new TableDerived(this.database, recursiveName, 2, columnNames, ((QueryExpression)leftQueryExpression).getColumnTypes());
        this.compileContext.registerSubquery(recursiveName.name, recursiveTable);
        this.compileContext.registerSubquery(name.name, workTable);
        this.checkIsThis(314);
        int unionType = this.XreadUnionType();
        this.compileContext.incrementDepth();
        QuerySpecification rightQuerySpecification = this.XreadSimpleTable();
        QueryExpression queryExpression = new QueryExpression(this.compileContext, leftQueryExpression);
        rightQuerySpecification.isBaseMergeable = false;
        rightQuerySpecification.isMergeable = false;
        rightQuerySpecification.resolveReferences(this.session, this.compileContext.getOuterRanges());
        queryExpression.addUnion(rightQuerySpecification, unionType);
        queryExpression.isRecursive = true;
        queryExpression.recursiveWorkTable = workTable;
        queryExpression.recursiveResultTable = recursiveTable;
        queryExpression.isBaseMergeable = false;
        queryExpression.isMergeable = false;
        queryExpression.resolve(this.session);
        TableDerived maintd = this.newSubQueryTable(name, queryExpression, 23);
        maintd.prepareTable(this.session, columnNames);
        maintd.setSQL(this.getLastPart(position));
        this.compileContext.decrementDepth();
        return maintd;
    }

    TableDerived newSubQueryTable(Expression e, int opType) {
        HsqlNameManager.HsqlName name = this.database.nameManager.getSubqueryTableName();
        TableDerived td = new TableDerived(this.database, name, 2, null, e, opType, this.compileContext.getDepth());
        return td;
    }

    TableDerived newSubQueryTable(QueryExpression qe, int opType) {
        return this.newSubQueryTable(null, qe, opType);
    }

    TableDerived newSubQueryTable(HsqlNameManager.HsqlName name, QueryExpression qe, int opType) {
        if (name == null) {
            name = this.database.nameManager.getSubqueryTableName();
        }
        TableDerived td = new TableDerived(this.database, name, 2, qe, null, opType, this.compileContext.getDepth());
        return td;
    }

    TableDerived XreadSubqueryTableBody(int type) {
        return this.XreadSubqueryTableBody(null, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableDerived XreadSubqueryTableBody(HsqlNameManager.HsqlName name, int type) {
        int position = this.getPosition();
        this.compileContext.incrementDepth();
        try {
            QueryExpression queryExpression = this.XreadQueryExpression();
            TableDerived td = null;
            if (type == 55) {
                queryExpression.setAsExists();
            }
            if (queryExpression.isValueList) {
                td = ((QuerySpecification)queryExpression).getValueListTable();
            }
            if (td == null) {
                td = this.newSubQueryTable(name, queryExpression, type);
            }
            String sql = this.getLastPart(position);
            td.setSQL(sql);
            TableDerived tableDerived = td;
            return tableDerived;
        }
        finally {
            this.compileContext.decrementDepth();
        }
    }

    TableDerived XreadViewSubqueryTable(View view, boolean resolve) {
        QueryExpression queryExpression;
        this.compileContext.incrementDepth();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        queryExpression.setView(view);
        queryExpression.resolveReferences(this.session, RangeGroup.emptyArray);
        queryExpression.resolveTypesPartOne(this.session);
        queryExpression.resolveTypesPartTwo(this.session);
        if (resolve) {
            queryExpression.resolveTypesPartThree(this.session);
        }
        TableDerived td = new TableDerived(this.database, view.getName(), 8, queryExpression, null, 0, this.compileContext.getDepth());
        td.view = view;
        td.columnList = view.columnList;
        td.columnCount = view.columnList.size();
        td.createPrimaryKey();
        td.triggerList = view.triggerList;
        td.triggerLists = view.triggerLists;
        this.compileContext.decrementDepth();
        return td;
    }

    Expression XreadContextuallyTypedTable(int degree) {
        int i;
        Expression e = this.readRow();
        Expression[] list = e.nodes;
        boolean isTable = false;
        if (degree == 1) {
            if (e.getType() == 25) {
                e.opType = 26;
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2].getType() != 25) {
                        list[i2] = new Expression(25, new Expression[]{list[i2]});
                        continue;
                    }
                    if (list[i2].nodes.length == degree) continue;
                    throw Error.error(5564);
                }
            } else {
                e = new Expression(25, new Expression[]{e});
                e = new Expression(26, new Expression[]{e});
            }
            return e;
        }
        if (e.getType() != 25) {
            throw Error.error(5564);
        }
        for (i = 0; i < list.length; ++i) {
            if (list[i].getType() != 25) continue;
            isTable = true;
            break;
        }
        if (isTable) {
            e.opType = 26;
            for (i = 0; i < list.length; ++i) {
                if (list[i].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] args = list[i].nodes;
                if (args.length != degree) {
                    throw Error.error(5564);
                }
                for (int j = 0; j < degree; ++j) {
                    if (args[j].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (list.length != degree) {
                throw Error.error(5564);
            }
            e = new Expression(26, new Expression[]{e});
        }
        return e;
    }

    Expression XreadInValueListConstructor(int degree) {
        int position = this.getPosition();
        this.compileContext.incrementDepth();
        Expression e = this.XreadInValueList(degree);
        TableDerived td = this.newSubQueryTable(e, 54);
        td.setSQL(this.getLastPart(position));
        e.table = td;
        this.compileContext.decrementDepth();
        return e;
    }

    private TableDerived XreadRowValueExpressionList() {
        this.compileContext.incrementDepth();
        Expression e = this.XreadRowValueExpressionListBody();
        TableDerived td = this.prepareSubqueryTable(e, null);
        this.compileContext.decrementDepth();
        return td;
    }

    private TableDerived prepareSubqueryTable(Expression e, HsqlNameManager.HsqlName[] colNames) {
        List unresolved = e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges(), null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
        e.prepareTable(this.session, null, e.nodes[0].nodes.length);
        TableDerived td = this.newSubQueryTable(e, 26);
        td.prepareTable(this.session, colNames);
        return td;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression r = null;
        while (true) {
            int brackets = this.readOpenBrackets();
            Expression e = this.readRow();
            this.readCloseBrackets(brackets);
            if (r == null) {
                r = new Expression(25, new Expression[]{e});
            } else {
                r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                r.nodes[r.nodes.length - 1] = e;
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        Expression[] list = r.nodes;
        int degree = 1;
        if (list[0].getType() == 25) {
            degree = list[0].nodes.length;
        }
        r.opType = 26;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getType() == 25) {
                if (list[i].nodes.length == degree) continue;
                throw Error.error(5564);
            }
            if (degree != 1) {
                throw Error.error(5564);
            }
            list[i] = new Expression(25, new Expression[]{list[i]});
        }
        return r;
    }

    Expression XreadTargetSpecification(RangeVariable[] rangeVars, LongDeque colIndexList) {
        ColumnBase column = null;
        int index = -1;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVars.length; ++i) {
            if (rangeVars[i] == null || (index = rangeVars[i].findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString)) <= -1) continue;
            column = rangeVars[i].getColumn(index);
            this.read();
            break;
        }
        if (column == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        colIndexList.add(index);
        if (this.token.tokenType == 932) {
            if (!column.getDataType().isArrayType()) {
                throw this.unexpectedToken();
            }
            this.read();
            Expression e = this.XreadNumericValueExpression();
            if (e == null) {
                throw Error.error(5501, this.token.tokenString);
            }
            e = new ExpressionAccessor(((ColumnSchema)column).getAccessor(), e);
            this.readThis(942);
            return e;
        }
        return ((ColumnSchema)column).getAccessor();
    }

    Expression XreadCollectionDerivedTable(int type) {
        boolean ordinality = false;
        int position = this.getPosition();
        this.readThis(317);
        this.readThis(937);
        this.compileContext.incrementDepth();
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        while (true) {
            Expression e = this.XreadValueExpression();
            list.add(e);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        this.readThis(922);
        if (this.token.tokenType == 337) {
            this.read();
            this.readThis(497);
            ordinality = true;
        }
        ExpressionTable e = new ExpressionTable(array, ordinality);
        TableDerived td = this.newSubQueryTable(e, type);
        td.setSQL(this.getLastPart(position));
        this.compileContext.decrementDepth();
        return e;
    }

    Expression XreadTableFunctionDerivedTable() {
        int position = this.getPosition();
        this.readThis(294);
        this.readThis(937);
        this.compileContext.incrementDepth();
        Expression e = this.XreadValueExpression();
        if (e.getType() != 27 && e.getType() != 28) {
            this.compileContext.decrementDepth();
            throw this.unexpectedToken("TABLE");
        }
        this.readThis(922);
        e = new ExpressionTable(new Expression[]{e}, false);
        TableDerived td = this.newSubQueryTable(e, 23);
        td.setSQL(this.getLastPart(position));
        this.compileContext.decrementDepth();
        return e;
    }

    Expression XreadLateralDerivedTable() {
        this.readThis(159);
        this.readThis(937);
        TableDerived td = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return new Expression(23, td);
    }

    Expression XreadArrayConstructor() {
        this.readThis(937);
        TableDerived td = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return new Expression(102, td);
    }

    Collation readCollateClauseOrNull() {
        if (this.token.tokenType == 44) {
            this.read();
            Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
            return collation;
        }
        return null;
    }

    Expression XreadArrayElementReference(Expression e) {
        if (this.token.tokenType == 932) {
            this.read();
            Expression e1 = this.XreadNumericValueExpression();
            this.readThis(942);
            e = new ExpressionAccessor(e, e1);
        }
        return e;
    }

    Expression readRow() {
        Expression r = null;
        while (true) {
            Expression e = this.XreadValueExpressionWithContext();
            if (r == null) {
                r = e;
            } else if (r.getType() == 25) {
                if (e.getType() == 25 && r.nodes[0].getType() != 25) {
                    r = new Expression(25, new Expression[]{r, e});
                } else {
                    r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                    r.nodes[r.nodes.length - 1] = e;
                }
            } else {
                r = new Expression(25, new Expression[]{r, e});
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        return r;
    }

    Expression readCaseExpression() {
        Expression predicand = null;
        this.read();
        if (this.token.tokenType != 332) {
            predicand = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(predicand);
    }

    private Expression readCaseWhen(Expression l) {
        this.readThis(332);
        Expression condition = null;
        if (l == null) {
            condition = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                Expression newCondition;
                if (l == (newCondition = this.XreadPredicateRightPart(l))) {
                    newCondition = new ExpressionLogical(l, this.XreadRowValuePredicand());
                }
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        this.readThis(296);
        Expression current = this.XreadValueExpression();
        Expression elseExpr = null;
        if (this.token.tokenType == 332) {
            elseExpr = this.readCaseWhen(l);
        } else if (this.token.tokenType == 97) {
            this.read();
            elseExpr = this.XreadValueExpression();
            this.readThis(99);
            this.readIfThis(32);
        } else {
            elseExpr = new ExpressionValue(null, (Type)null);
            this.readThis(99);
            this.readIfThis(32);
        }
        ExpressionOp alt = new ExpressionOp(98, current, elseExpr);
        ExpressionOp casewhen = new ExpressionOp(94, condition, (Expression)alt);
        return casewhen;
    }

    private Expression readCaseWhenExpressionOrNull() {
        Expression l = null;
        int position = this.getPosition();
        if (this.token.tokenType == 439 && !this.database.sqlSyntaxMys && !this.database.sqlSyntaxMss) {
            return null;
        }
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        l = this.XreadBooleanValueExpression();
        this.readThis(924);
        Expression then = this.XreadValueExpression();
        this.readThis(924);
        ExpressionOp thenelse = new ExpressionOp(98, then, this.XreadValueExpression());
        l = new ExpressionOp(94, l, (Expression)thenelse);
        this.readThis(922);
        return l;
    }

    private Expression readCastExpression() {
        this.read();
        this.readThis(937);
        Expression e = this.XreadValueExpression();
        this.readThis(11);
        Type typeObject = this.readTypeDefinition(false, true);
        if (e.isUnresolvedParam()) {
            e.setDataType(this.session, typeObject);
        } else {
            e = new ExpressionOp(e, typeObject);
        }
        this.readThis(922);
        return e;
    }

    private Expression readConvertExpressionOrNull() {
        Expression e;
        Type typeObject;
        Expression mode = null;
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        if (this.database.sqlSyntaxMss) {
            typeObject = this.readTypeDefinition(false, true);
            this.readThis(924);
            e = this.XreadValueExpression();
            if (this.readIfThis(924)) {
                mode = this.XreadSimpleValueSpecificationOrNull();
            }
        } else {
            e = this.XreadValueExpression();
            this.readThis(924);
            typeObject = Type.getTypeForJDBCConvertToken(this.token.tokenType);
            if (typeObject == null) {
                typeObject = this.readTypeDefinition(false, true);
            } else {
                this.read();
            }
        }
        if (e.isUnresolvedParam() && mode == null) {
            e.setDataType(this.session, typeObject);
        } else {
            e = new ExpressionOp(e, typeObject, mode);
        }
        this.readThis(922);
        return e;
    }

    private Expression readColumnOrFunctionExpression() {
        Object schema;
        ReferenceObject synonym;
        Expression e;
        String name = this.token.tokenString;
        boolean isSimpleQuoted = this.isDelimitedSimpleName();
        Token recordedToken = this.getRecordedToken();
        this.checkIsIdentifier();
        if (this.isUndelimitedSimpleName() && (e = this.readFunction()) != null) {
            return e;
        }
        this.read();
        if (this.token.tokenType != 937) {
            this.checkValidCatalogName(recordedToken.namePrePrePrefix);
            ExpressionColumn column = new ExpressionColumn(recordedToken.namePrePrefix, recordedToken.namePrefix, name);
            return column;
        }
        RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.session, name, recordedToken.namePrefix, recordedToken.namePrePrefix, 16);
        if (routineSchema == null && recordedToken.namePrefix == null && !this.isViewDefinition && (synonym = this.database.schemaManager.findSynonym(recordedToken.tokenString, (String)(schema = this.session.getSchemaName(null)), 18)) != null) {
            HsqlNameManager.HsqlName synonymName = synonym.getTarget();
            routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(synonymName.name, synonymName.schema.name, 18);
        }
        if (routineSchema == null && isSimpleQuoted) {
            schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, ((HsqlNameManager.HsqlName)schema).name, 16);
            if (routineSchema == null) {
                Routine.createRoutines(this.session, (HsqlNameManager.HsqlName)schema, name);
                routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, ((HsqlNameManager.HsqlName)schema).name, 16);
            }
        }
        if (routineSchema == null) {
            if (this.lastError != null) {
                throw this.lastError;
            }
            throw Error.error(5501, name);
        }
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        this.readThis(937);
        if (this.token.tokenType == 922) {
            this.read();
        } else {
            while (true) {
                Expression e2 = this.XreadValueExpression();
                list.add(e2);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            this.readThis(922);
        }
        FunctionSQLInvoked function = new FunctionSQLInvoked(routineSchema);
        Expression[] arguments = new Expression[list.size()];
        list.toArray(arguments);
        function.setArguments(arguments);
        this.compileContext.addFunctionCall(function);
        recordedToken.setExpression(routineSchema);
        return function;
    }

    Expression readFunction() {
        Expression e;
        FunctionSQL function = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
        if (function != null) {
            int pos = this.getPosition();
            try {
                Expression e2 = this.readSQLFunction(function);
                if (e2 != null) {
                    return e2;
                }
            }
            catch (HsqlException ex) {
                ex.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                    this.lastError = ex;
                }
                this.rewind(pos);
            }
        } else if (this.isReservedKey() && (function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext)) != null && (e = this.readSQLFunction(function)) != null) {
            return e;
        }
        return null;
    }

    Expression readCollection(int type) {
        this.read();
        if (this.token.tokenType == 937) {
            return this.XreadArrayConstructor();
        }
        this.readThis(932);
        HsqlArrayList<Expression> list = new HsqlArrayList<Expression>();
        int i = 0;
        while (true) {
            if (this.token.tokenType == 942) break;
            if (i > 0) {
                this.readThis(924);
            }
            Expression e = this.XreadValueExpression();
            list.add(e);
            ++i;
        }
        this.read();
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        return new Expression(19, array);
    }

    private Expression readDecodeExpressionOrNull() {
        ExpressionOp casewhen;
        block6: {
            int position = this.getPosition();
            this.read();
            if (!this.readIfThis(937)) {
                this.rewind(position);
                return null;
            }
            casewhen = null;
            Expression alternative = null;
            Expression main = this.XreadValueExpression();
            this.readThis(924);
            while (true) {
                Expression v = this.XreadValueExpression();
                if (this.token.tokenType != 924) {
                    if (alternative == null) {
                        throw this.unexpectedToken();
                    }
                    alternative.setRightNode(v);
                    break block6;
                }
                this.readThis(924);
                ExpressionLogical l = new ExpressionLogical(67, main, v);
                Expression r = this.XreadValueExpression();
                ExpressionOp a = new ExpressionOp(98, r, null);
                ExpressionOp c = new ExpressionOp(94, l, (Expression)a);
                if (casewhen == null) {
                    casewhen = c;
                } else {
                    alternative.setRightNode(c);
                }
                alternative = a;
                if (this.token.tokenType != 924) break;
                this.readThis(924);
            }
            alternative.setRightNode(new ExpressionValue(null, null));
        }
        this.readThis(922);
        return casewhen;
    }

    private Expression readConcatExpressionOrNull() {
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression root = this.XreadValueExpression();
        this.readThis(924);
        while (true) {
            Expression r = this.XreadValueExpression();
            root = new ExpressionArithmetic(36, root, r);
            if (this.token.tokenType == 924) {
                this.readThis(924);
                continue;
            }
            if (this.token.tokenType == 922) break;
        }
        this.readThis(922);
        return root;
    }

    private Expression readConcatSeparatorExpressionOrNull() {
        HsqlArrayList<Expression> array = new HsqlArrayList<Expression>();
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression e = this.XreadValueExpression();
        array.add(e);
        this.readThis(924);
        e = this.XreadValueExpression();
        array.add(e);
        this.readThis(924);
        while (true) {
            e = this.XreadValueExpression();
            array.add(e);
            if (this.token.tokenType == 924) {
                this.readThis(924);
                continue;
            }
            if (this.token.tokenType == 922) break;
        }
        this.readThis(922);
        Expression[] expressions = new Expression[array.size()];
        array.toArray(expressions);
        return new ExpressionOp(90, expressions);
    }

    private Expression readLeastExpressionOrNull() {
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression casewhen = null;
        while (true) {
            casewhen = this.readValue(casewhen, 44);
            if (this.token.tokenType != 924) break;
            this.readThis(924);
        }
        this.readThis(922);
        return casewhen;
    }

    private Expression readGreatestExpressionOrNull() {
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression casewhen = null;
        while (true) {
            casewhen = this.readValue(casewhen, 43);
            if (this.token.tokenType != 924) break;
            this.readThis(924);
        }
        this.readThis(922);
        return casewhen;
    }

    private Expression readValue(Expression e, int opType) {
        Expression r = this.XreadValueExpression();
        if (e == null) {
            return r;
        }
        ExpressionLogical l = new ExpressionLogical(opType, e, r);
        ExpressionOp a = new ExpressionOp(98, e, r);
        return new ExpressionOp(94, l, (Expression)a);
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(937);
        Expression c = this.XreadValueExpression();
        this.readThis(924);
        ExpressionOp alternative = new ExpressionOp(98, new ExpressionValue(null, (Type)null), c);
        c = new ExpressionLogical(c, this.XreadValueExpression());
        c = new ExpressionOp(94, c, (Expression)alternative);
        this.readThis(922);
        return c;
    }

    private Expression readIfNullExpressionOrNull() {
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression c = this.XreadValueExpression();
        this.readThis(924);
        Expression e = this.XreadValueExpression();
        ExpressionLogical condition = new ExpressionLogical(47, c);
        ExpressionOp alt = new ExpressionOp(98, e, c);
        c = new ExpressionOp(94, condition, (Expression)alt);
        c.setSubType(91);
        alt.setSubType(91);
        this.readThis(922);
        return c;
    }

    private Expression readIfNull2ExpressionOrNull() {
        int position = this.getPosition();
        this.read();
        if (!this.readIfThis(937)) {
            this.rewind(position);
            return null;
        }
        Expression c = this.XreadValueExpression();
        this.readThis(924);
        Expression e1 = this.XreadValueExpression();
        this.readThis(924);
        Expression e2 = this.XreadValueExpression();
        ExpressionLogical condition = new ExpressionLogical(47, c);
        ExpressionOp alt = new ExpressionOp(98, e2, e1);
        c = new ExpressionOp(94, condition, (Expression)alt);
        c.setSubType(91);
        alt.setSubType(91);
        this.readThis(922);
        return c;
    }

    private Expression readCoalesceExpression() {
        Expression current;
        ExpressionOp c = null;
        this.read();
        this.readThis(937);
        Expression leaf = null;
        while (true) {
            current = this.XreadValueExpression();
            if (leaf != null && this.token.tokenType == 922) break;
            ExpressionValue expressionNull = new ExpressionValue(null, (Type)null);
            ExpressionLogical condition = new ExpressionLogical(47, current);
            ExpressionOp alt = new ExpressionOp(98, expressionNull, current);
            ExpressionOp casewhen = new ExpressionOp(94, condition, (Expression)alt);
            if (this.session.database.sqlSyntaxMys) {
                alt.setSubType(91);
                casewhen.setSubType(91);
            }
            if (c == null) {
                c = casewhen;
            } else {
                leaf.setLeftNode(casewhen);
            }
            leaf = alt;
            this.readThis(924);
        }
        this.readThis(922);
        leaf.setLeftNode(current);
        return c;
    }

    Expression readSQLFunction(FunctionSQL function) {
        boolean isOpenBracket;
        int position = this.getPosition();
        this.read();
        short[] parseList = function.parseList;
        if (parseList.length == 0) {
            return function;
        }
        HsqlArrayList exprList = new HsqlArrayList();
        boolean bl = isOpenBracket = this.token.tokenType == 937;
        if (!isOpenBracket) {
            if (parseList[0] == 1002) {
                return function;
            }
            this.rewind(position);
            return null;
        }
        try {
            this.readExpression(exprList, parseList, 0, parseList.length, false);
            this.lastError = null;
        }
        catch (HsqlException e) {
            if (function.parseListAlt == null) {
                throw e;
            }
            this.rewind(position);
            this.read();
            parseList = function.parseListAlt;
            exprList = new HsqlArrayList();
            this.readExpression(exprList, parseList, 0, parseList.length, false);
            this.lastError = null;
        }
        Expression[] expr = new Expression[exprList.size()];
        exprList.toArray(expr);
        function.setArguments(expr);
        return function.getFunctionExpression();
    }

    void readExpression(HsqlArrayList exprList, short[] parseList, int start, int count, boolean isOption) {
        block10: for (int i = start; i < start + count; ++i) {
            short exprType = parseList[i];
            switch (exprType) {
                case 939: {
                    Expression e = null;
                    e = this.XreadAllTypesCommonValueExpression(false);
                    exprList.add(e);
                    continue block10;
                }
                case 1005: {
                    if (super.isUndelimitedSimpleName()) {
                        ExpressionValue e = new ExpressionValue(this.token.tokenString, Type.SQL_VARCHAR);
                        this.read();
                        exprList.add(e);
                        continue block10;
                    }
                    throw this.unexpectedToken();
                }
                case 1004: {
                    ExpressionValue e = null;
                    Integer value = this.readIntegerObject();
                    if (value < 0) {
                        throw Error.error(5592);
                    }
                    e = new ExpressionValue(value, Type.SQL_INTEGER);
                    exprList.add(e);
                    continue block10;
                }
                case 1002: {
                    int expressionCount = exprList.size();
                    int position = this.getPosition();
                    int n = ++i;
                    ++i;
                    short elementCount = parseList[n];
                    int initialExprIndex = exprList.size();
                    try {
                        this.readExpression(exprList, parseList, i, elementCount, true);
                    }
                    catch (HsqlException ex) {
                        ex.setLevel(this.compileContext.subqueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                            this.lastError = ex;
                        }
                        this.rewind(position);
                        exprList.setSize(expressionCount);
                        for (int j = i; j < i + elementCount; ++j) {
                            if (parseList[j] != 939 && parseList[j] != 1001 && parseList[j] != 1004) continue;
                            exprList.add(null);
                        }
                        i += elementCount - 1;
                        continue block10;
                    }
                    if (initialExprIndex == exprList.size() && parseList[i] != 937) {
                        exprList.add(null);
                    }
                    i += elementCount - 1;
                    continue block10;
                }
                case 1003: {
                    int initialExprIndex;
                    int n = ++i;
                    short elementCount = parseList[n];
                    int parseIndex = ++i;
                    do {
                        initialExprIndex = exprList.size();
                        this.readExpression(exprList, parseList, parseIndex, elementCount, true);
                    } while (exprList.size() != initialExprIndex);
                    i += elementCount - 1;
                    continue block10;
                }
                case 1001: {
                    short elementCount = parseList[++i];
                    ExpressionValue e = null;
                    if (ArrayUtil.find(parseList, this.token.tokenType, i + 1, elementCount) == -1) {
                        if (!isOption) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        e = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    exprList.add(e);
                    i += elementCount;
                    continue block10;
                }
                default: {
                    if (this.token.tokenType != exprType) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
            }
        }
    }

    private Expression readSequenceExpressionOrNull(int opType) {
        int position = this.getPosition();
        switch (opType) {
            case 12: {
                if (this.token.tokenType == 486) {
                    this.read();
                    if (this.token.tokenType != 323) {
                        this.rewind(position);
                        return null;
                    }
                    this.readThis(323);
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 663) {
                    this.read();
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 671) {
                    this.read();
                    break;
                }
                this.rewind(position);
                return null;
            }
            case 13: {
                this.read();
                this.readThis(323);
                break;
            }
        }
        this.readThis(120);
        this.checkIsSchemaObjectName();
        NumberSequence sequence = this.database.schemaManager.findSequence(this.session, this.token.tokenString, this.token.namePrefix);
        if (sequence == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        Token recordedToken = this.getRecordedToken();
        this.read();
        ExpressionColumn e = new ExpressionColumn(sequence, opType);
        recordedToken.setExpression(sequence);
        this.compileContext.addSequence(sequence);
        return e;
    }

    HsqlNameManager.SimpleName readSimpleName() {
        this.checkIsSimpleName();
        HsqlNameManager.SimpleName name = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        return name;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(2, false);
        SqlInvariants.checkSchemaNameNotSystem(name.name);
        return name;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int type, boolean checkSchema) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), type);
        if (this.token.namePrefix != null) {
            switch (type) {
                case 1: 
                case 11: 
                case 21: 
                case 22: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && !this.token.isDelimitedPrefix && "MODULE".equals(this.token.namePrefix)) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 25: 
                case 26: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName schemaName;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (checkSchema) {
                        schemaName = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        schemaName = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (schemaName == null) {
                            schemaName = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(schemaName);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName parentName, int type) {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(type, true);
        name.parent = parentName;
        name.setSchemaIfNull(parentName.schema);
        if (name.schema != null && parentName.schema != null && name.schema != parentName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return name;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return schema;
    }

    SchemaObject readSchemaObjectName(int type) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        String schema = this.session.getSchemaName(this.token.namePrefix);
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, schema, type);
        this.read();
        return object;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName schemaName, int type) {
        this.checkIsSchemaObjectName();
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, schemaName.name, type);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(schemaName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return object;
    }

    Table readTableName() {
        return this.readTableName(false);
    }

    Table readTableName(boolean orSynonym) {
        this.checkIsIdentifier();
        this.lastSynonym = null;
        Table table = this.database.schemaManager.findTable(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix);
        if (table == null) {
            ReferenceObject reference;
            boolean trySynonym;
            boolean bl = trySynonym = orSynonym && this.token.namePrefix == null && !this.isViewDefinition;
            if (trySynonym && (reference = this.database.schemaManager.findSynonym(this.token.tokenString, this.session.getCurrentSchemaHsqlName().name, 3)) != null) {
                table = (Table)this.database.schemaManager.getSchemaObject(reference.getTarget());
                this.lastSynonym = reference.getName();
            }
            if (table == null) {
                HsqlException ex = Error.error(5501, this.token.tokenString);
                ex.setToken(this.token.tokenString);
                throw ex;
            }
        }
        this.getRecordedToken().setExpression(table);
        this.read();
        return table;
    }

    ExpressionPeriodOp XreadQuerySystemPeriodSpecOrNull(Table table) {
        int position = this.getPosition();
        if (!table.isSystemVersioned()) {
            return null;
        }
        if (this.token.tokenType != 120) {
            ExpressionPeriodOp periodExpression = new ExpressionPeriodOp();
            return periodExpression;
        }
        this.read();
        if (this.token.tokenType != 292) {
            this.rewind(position);
            return null;
        }
        this.read();
        switch (this.token.tokenType) {
            case 11: {
                this.read();
                this.readThis(201);
                Expression point = this.XreadValueExpression();
                return new ExpressionPeriodOp(point);
            }
            case 21: {
                this.read();
                this.readIfThis(13);
                Expression pointStart = this.XreadRowValuePredicand();
                this.readThis(5);
                Expression pointEnd = this.XreadRowValuePredicand();
                return new ExpressionPeriodOp(pointStart, pointEnd);
            }
            case 124: {
                this.read();
                Expression pointStart = this.XreadValueExpression();
                this.readThis(301);
                Expression pointEnd = this.XreadValueExpression();
                return new ExpressionPeriodOp(pointStart, pointEnd);
            }
        }
        throw this.unexpectedToken();
    }

    ExpressionPeriodOp XreadQueryApplicationPeriodSpecOrNull(Table table) {
        PeriodDefinition period = table.getApplicationPeriod();
        if (period == null) {
            return null;
        }
        if (this.token.tokenType != 120) {
            return null;
        }
        this.read();
        this.readThis(221);
        this.readThis(201);
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(period.periodName.getNameString())) {
            throw Error.error(5501, this.token.tokenString);
        }
        this.read();
        this.readThis(124);
        Expression pointStart = this.XreadValueExpression();
        this.readThis(301);
        Expression pointEnd = this.XreadValueExpression();
        ExpressionPeriod left = new ExpressionPeriod(period);
        ExpressionPeriod right = new ExpressionPeriod(pointStart, pointEnd);
        return new ExpressionPeriodOp(61, left, right);
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVar, boolean withPrefix) {
        ColumnSchema column = null;
        this.checkIsIdentifier();
        if (!withPrefix && this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int index = rangeVar.findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
        if (index == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        column = rangeVar.getTable().getColumn(index);
        this.read();
        return column;
    }

    ColumnSchema readSimpleColumnName(Table table, boolean withPrefix) {
        int index;
        this.checkIsIdentifier();
        if (withPrefix) {
            if (this.token.namePrefix != null && !table.getName().name.equals(this.token.namePrefix)) {
                throw Error.error(5501, this.token.namePrefix);
            }
        } else if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        if ((index = table.findColumn(this.token.tokenString)) == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema column = table.getColumn(index);
        this.read();
        return column;
    }

    StatementQuery compileDeclareCursorOrNull(RangeGroup[] rangeGroups, boolean isRoutine) {
        int sensitivity = 0;
        int scrollability = 0;
        int holdability = 0;
        int returnability = 0;
        int position = this.getPosition();
        this.readThis(82);
        if (this.isReservedKey()) {
            this.rewind(position);
            return null;
        }
        HsqlNameManager.HsqlName cursorName = this.readNewSchemaObjectName(19, false);
        switch (this.token.tokenType) {
            case 266: {
                this.read();
                sensitivity = 2;
                break;
            }
            case 144: {
                this.read();
                sensitivity = 1;
                break;
            }
            case 12: {
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 190) {
            this.readThis(262);
        } else if (this.token.tokenType == 262) {
            this.read();
            scrollability = 1;
        }
        if (this.token.tokenType != 75) {
            this.rewind(position);
            return null;
        }
        this.readThis(75);
        for (int round = 0; round < 2; ++round) {
            if (this.token.tokenType == 337) {
                this.read();
                if (round == 0 && this.token.tokenType == 136) {
                    this.read();
                    holdability = 1;
                    continue;
                }
                this.readThis(251);
                ++round;
                returnability = 1;
                continue;
            }
            if (this.token.tokenType != 339) continue;
            this.read();
            if (round == 0 && this.token.tokenType == 136) {
                this.read();
                continue;
            }
            this.readThis(251);
            ++round;
        }
        this.readThis(120);
        int props = ResultProperties.getProperties(sensitivity, 1, scrollability, holdability, returnability);
        StatementQuery cs = this.compileCursorSpecification(rangeGroups, props, isRoutine);
        cs.setCursorName(cursorName);
        return cs;
    }

    StatementQuery compileCursorSpecification(RangeGroup[] rangeGroups, int props, boolean isRoutine) {
        OrderedHashSet colNames = null;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (this.token.tokenType == 120) {
            this.read();
            if (this.token.tokenType == 521 || this.token.tokenType == 115) {
                this.read();
                this.readThis(205);
                props = ResultProperties.addUpdatable(props, false);
            } else {
                this.readThis(319);
                props = ResultProperties.addUpdatable(props, true);
                if (this.token.tokenType == 201) {
                    this.readThis(201);
                    colNames = new OrderedHashSet();
                    this.readColumnNameList(colNames, null, false);
                }
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(664);
                }
            }
        }
        if (this.database.sqlSyntaxDb2) {
            if (this.readIfThis(337) && !this.readIfThis("CS") && !this.readIfThis("RR") && !this.readIfThis("RS")) {
                this.readThis("UR");
            }
            if (this.readIfThis(693)) {
                this.readThis(5);
                this.readThis("KEEP");
                if (!this.readIfThis("EXCLUSIVE") && !this.readIfThis("SHARE")) {
                    this.readThis(319);
                }
                this.readThis(654);
            }
        }
        if (ResultProperties.isUpdatable(props)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        if (this.database.sqlLowerCaseIdentifier && !isRoutine) {
            queryExpression.setLowerCaseResultIdentifer();
        }
        queryExpression.resolve(this.session, rangeGroups, null);
        StatementQuery cs = isRoutine ? new StatementCursor(this.session, queryExpression, this.compileContext) : new StatementQuery(this.session, queryExpression, this.compileContext);
        return cs;
    }

    StatementDMQL compileShortCursorSpecification(int props) {
        QuerySpecification select = this.XreadSimpleTable();
        if (ResultProperties.isUpdatable(props)) {
            select.isUpdatable = true;
        }
        ((QueryExpression)select).setReturningResult();
        select.resolve(this.session);
        StatementQuery cs = new StatementQuery(this.session, select, this.compileContext);
        return cs;
    }

    int readCloseBrackets(int limit) {
        int count;
        for (count = 0; count < limit && this.token.tokenType == 922; ++count) {
            this.read();
        }
        return count;
    }

    int readOpenBrackets() {
        int count = 0;
        while (this.token.tokenType == 937) {
            ++count;
            this.read();
        }
        return count;
    }

    void readNestedParenthesisedTokens() {
        this.readThis(937);
        do {
            this.read();
            if (this.token.tokenType == 937) {
                this.readNestedParenthesisedTokens();
            }
            if (this.token.tokenType != 1014) continue;
            throw this.unexpectedToken();
        } while (this.token.tokenType != 922);
        this.read();
    }

    void checkValidCatalogName(String name) {
        if (name != null && !name.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, name);
        }
    }

    @Override
    void rewind(int position) {
        super.rewind(position);
        this.compileContext.rewind(position);
    }

    public static final class CompileContext {
        final Session session;
        final ParserBase parser;
        final CompileContext baseContext;
        final int basePosition;
        boolean isViewTable;
        private int subqueryDepth;
        private HsqlArrayList namedSubqueries;
        private OrderedIntKeyHashMap parameters = new OrderedIntKeyHashMap();
        private HsqlArrayList usedSequences = new HsqlArrayList(16, true);
        private HsqlArrayList usedRoutines = new HsqlArrayList(16, true);
        private OrderedIntKeyHashMap rangeVariables = new OrderedIntKeyHashMap();
        private HsqlArrayList usedTypes = new HsqlArrayList(16, true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        boolean onDuplicateTypedExpression;
        Routine callProcedure;
        private RangeGroup[] outerRangeGroups = RangeGroup.emptyArray;
        private final int initialRangeVarIndex;
        private int rangeVarIndex;

        public CompileContext(Session session) {
            this(session, null, null);
        }

        public CompileContext(Session session, ParserBase parser, CompileContext baseContext) {
            this.session = session;
            this.parser = parser;
            this.baseContext = baseContext;
            if (baseContext == null) {
                this.rangeVarIndex = 1;
                this.initialRangeVarIndex = 1;
                this.basePosition = 0;
            } else {
                this.initialRangeVarIndex = this.rangeVarIndex = baseContext.getRangeVarCount();
                this.basePosition = baseContext.parser.getPosition();
                this.subqueryDepth = baseContext.getDepth();
            }
        }

        public void reset() {
            this.rangeVarIndex = this.initialRangeVarIndex;
            this.subqueryDepth = 0;
            this.rangeVariables.clear();
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.callProcedure = null;
            this.usedTypes.clear();
            this.outerRangeGroups = RangeGroup.emptyArray;
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public int getDepth() {
            return this.subqueryDepth;
        }

        public void incrementDepth() {
            ++this.subqueryDepth;
            if (this.baseContext != null) {
                ++this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth() {
            this.clearSubqueries();
            --this.subqueryDepth;
            if (this.baseContext != null) {
                --this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth(int toDepth) {
            while (this.subqueryDepth > toDepth) {
                this.decrementDepth();
            }
        }

        public void rewind(int position) {
            if (this.baseContext != null) {
                this.baseContext.rewind(this.basePosition + position);
                return;
            }
            this.rewindRangeVariables(position);
            this.rewindParameters(position);
        }

        private void rewindRangeVariables(int position) {
            for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
                int rangePos = this.rangeVariables.getKeyAt(i, -1);
                if (rangePos <= position) continue;
                this.rangeVariables.removeEntry(i);
            }
            if (this.rangeVariables.size() > 0) {
                RangeVariable range = (RangeVariable)this.rangeVariables.getValueAt(this.rangeVariables.size() - 1);
                this.rangeVarIndex = range.rangePosition + 1;
            } else {
                this.rangeVarIndex = this.initialRangeVarIndex;
            }
        }

        private void rewindParameters(int position) {
            if (this.baseContext != null) {
                this.baseContext.rewindParameters(this.basePosition + position);
                return;
            }
            Iterator it = this.parameters.keySet().iterator();
            while (it.hasNext()) {
                int pos = it.nextInt();
                if (pos < position) continue;
                it.remove();
            }
        }

        public void setCurrentSubquery(HsqlNameManager.HsqlName name) {
            this.isViewTable = name.type == 4;
        }

        public void registerRangeVariable(RangeVariable range) {
            int nextRangePosition = this.basePosition;
            if (this.parser != null) {
                nextRangePosition += this.parser.getPosition();
            }
            if (this.isViewTable) {
                range.isViewSubquery = true;
            }
            this.registerRangeVariable(range, nextRangePosition);
        }

        private void registerRangeVariable(RangeVariable range, int position) {
            if (this.baseContext != null) {
                this.baseContext.registerRangeVariable(range, position);
                return;
            }
            range.rangePosition = this.getNextRangeVarIndex();
            range.level = this.subqueryDepth;
            this.rangeVariables.put(position, range);
        }

        public void setNextRangeVarIndex(int n) {
            if (this.baseContext != null) {
                this.baseContext.setNextRangeVarIndex(n);
                return;
            }
            this.rangeVarIndex = n;
        }

        private int getNextRangeVarIndex() {
            if (this.baseContext != null) {
                return this.baseContext.getNextRangeVarIndex();
            }
            return this.rangeVarIndex++;
        }

        public int getNextResultRangeVarIndex() {
            RangeVariable range = new RangeVariable(null, null, false, 5);
            this.registerRangeVariable(range);
            return range.rangePosition;
        }

        public int getRangeVarCount() {
            if (this.baseContext != null) {
                return this.baseContext.getRangeVarCount();
            }
            return this.rangeVarIndex;
        }

        public RangeVariable[] getAllRangeVariables() {
            HsqlArrayList<RangeVariable> list = new HsqlArrayList<RangeVariable>();
            for (int i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.getValueAt(i);
                if (range.rangeType == 5) continue;
                list.add(range);
            }
            RangeVariable[] array = new RangeVariable[list.size()];
            list.toArray(array);
            return array;
        }

        public RangeGroup[] getOuterRanges() {
            if (this.baseContext != null) {
                return this.baseContext.outerRangeGroups;
            }
            return this.outerRangeGroups;
        }

        public void setOuterRanges(RangeGroup[] rangeGroups) {
            this.outerRangeGroups = rangeGroups;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.size() == 0) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] array = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(array);
            return array;
        }

        public Routine[] getRoutines() {
            if (this.callProcedure == null && this.usedRoutines.size() == 0) {
                return Routine.emptyArray;
            }
            OrderedHashSet<Routine> set = new OrderedHashSet<Routine>();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked function = (FunctionSQLInvoked)this.usedRoutines.get(i);
                if (function.routine == null) continue;
                set.add(function.routine);
            }
            if (this.callProcedure != null) {
                set.add(this.callProcedure);
            }
            Routine[] array = new Routine[set.size()];
            set.toArray(array);
            return array;
        }

        private void initSubqueryNames() {
            OrderedHashMap set;
            if (this.namedSubqueries == null) {
                this.namedSubqueries = new HsqlArrayList();
            }
            if (this.namedSubqueries.size() <= this.subqueryDepth) {
                this.namedSubqueries.setSize(this.subqueryDepth + 1);
            }
            if ((set = (OrderedHashMap)this.namedSubqueries.get(this.subqueryDepth)) == null) {
                set = new OrderedHashMap();
                this.namedSubqueries.set(this.subqueryDepth, set);
            }
        }

        private void clearSubqueries() {
            OrderedHashMap set;
            if (this.namedSubqueries != null && this.namedSubqueries.size() > this.subqueryDepth && (set = (OrderedHashMap)this.namedSubqueries.get(this.subqueryDepth)) != null) {
                set.clear();
            }
        }

        private void registerSubquery(String name) {
            this.initSubqueryNames();
            OrderedHashMap set = (OrderedHashMap)this.namedSubqueries.get(this.subqueryDepth);
            boolean added = set.add(name, null);
            if (!added) {
                throw Error.error(5504, name);
            }
        }

        private void registerSubquery(String name, TableDerived td) {
            OrderedHashMap set = (OrderedHashMap)this.namedSubqueries.get(this.subqueryDepth);
            set.put(name, td);
        }

        private void unregisterSubqueries() {
            if (this.namedSubqueries == null) {
                return;
            }
            for (int i = this.subqueryDepth; i < this.namedSubqueries.size(); ++i) {
                OrderedHashMap set = (OrderedHashMap)this.namedSubqueries.get(i);
                if (set == null) continue;
                set.clear();
            }
        }

        private TableDerived getNamedSubQuery(String name) {
            TableDerived td;
            if (this.baseContext != null && (td = this.baseContext.getNamedSubQuery(name)) != null) {
                return td;
            }
            if (this.namedSubqueries == null) {
                return null;
            }
            for (int i = this.subqueryDepth; i >= 0; --i) {
                OrderedHashMap set;
                if (this.namedSubqueries.size() <= i || (set = (OrderedHashMap)this.namedSubqueries.get(i)) == null || set.getIndex(name) < 0) continue;
                TableDerived td2 = (TableDerived)set.get(name);
                if (td2 == null) {
                    HsqlException ex = Error.error(5501, name);
                    ex.setToken(name);
                    throw ex;
                }
                return td2;
            }
            return null;
        }

        private void addParameter(ExpressionColumn e, int position) {
            this.parameters.put(position, e);
        }

        private void addDomainOrType(SchemaObject object) {
            this.usedTypes.add(object);
        }

        private void addSequence(SchemaObject object) {
            this.usedSequences.add(object);
        }

        void addFunctionCall(FunctionSQLInvoked function) {
            this.usedRoutines.add(function);
        }

        void addProcedureCall(Routine procedure) {
            this.callProcedure = procedure;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.size() == 0) {
                return ExpressionColumn.emptyArray;
            }
            ExpressionColumn[] result = new ExpressionColumn[this.parameters.size()];
            this.parameters.valuesToArray(result);
            this.parameters.clear();
            return result;
        }

        public OrderedHashSet getSchemaObjectNames() {
            SchemaObject object;
            int i;
            OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
            for (i = 0; i < this.usedSequences.size(); ++i) {
                object = (SchemaObject)this.usedSequences.get(i);
                set.add(object.getName());
            }
            for (i = 0; i < this.usedTypes.size(); ++i) {
                object = (SchemaObject)this.usedTypes.get(i);
                set.add(object.getName());
            }
            for (i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.getValueAt(i);
                if (range.isViewSubquery || range.rangeType == 5) continue;
                HsqlNameManager.HsqlName name = range.rangeTable.getName();
                if (name.type == 10) {
                    set.addAll(range.getColumnNames());
                    continue;
                }
                if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                set.add(name);
                set.addAll(range.getColumnNames());
                if (range.periodCondition == null || !range.periodCondition.isSystemVersionCondition()) continue;
                set.add(range.rangeTable.systemPeriod.getName());
            }
            Routine[] routines = this.getRoutines();
            for (int i2 = 0; i2 < routines.length; ++i2) {
                set.add(routines[i2].getSpecificName());
            }
            return set;
        }
    }
}

