/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserTable;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementProcedure;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSignal;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserTable {
    static String[] featureStrings = new String[]{"H901_03"};

    ParserRoutine(Session session, Scanner t) {
        super(session, t);
    }

    Statement compileOpenCursorStatement(StatementCompound context) {
        this.readThis(206);
        this.checkIsSimpleName();
        String tokenString = this.token.tokenString;
        this.read();
        for (int i = 0; i < context.cursors.length; ++i) {
            if (!context.cursors[i].getCursorName().name.equals(tokenString)) continue;
            return context.cursors[i];
        }
        throw Error.parseError(4680, null, this.scanner.getLineNumber());
    }

    Statement compileSelectSingleRowStatement(RangeGroup[] rangeGroups) {
        OrderedHashSet variableNames = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        this.compileContext.setOuterRanges(rangeGroups);
        QuerySpecification select = this.XreadSelect();
        this.readThis(151);
        RangeVariable[] ranges = rangeGroups[0].getRangeVariables();
        this.readTargetSpecificationList(variableNames, ranges, colIndexList);
        this.XreadTableExpression(select);
        select.setReturningResult();
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Expression[] variables = new Expression[variableNames.size()];
        variableNames.toArray(variables);
        Type[] targetTypes = this.getTypesArray(variables);
        select.setReturningResult();
        select.resolve(this.session, rangeGroups, targetTypes);
        if (select.getColumnCount() != variables.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statement = new StatementSet(this.session, variables, select, columnMap, this.compileContext);
        return statement;
    }

    Type[] getTypesArray(Expression[] variables) {
        Type[] targetTypes = new Type[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i].getColumn().getParameterMode() == 1) {
                throw Error.parseError(2500, null, this.scanner.getLineNumber());
            }
            targetTypes[i] = variables[i].getDataType();
        }
        return targetTypes;
    }

    Statement compileGetStatement(RangeGroup[] rangeGroups) {
        int i;
        this.read();
        this.readThis(413);
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        RangeVariable[] rangeVars = rangeGroups[0].getRangeVariables();
        this.readGetClauseList(rangeVars, targetSet, colIndexList, exprList);
        if (exprList.size() > 1) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Expression[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeGroups, targets[i]);
        }
        this.resolveOuterReferencesAndTypes(rangeGroups, expression);
        for (i = 0; i < targets.length; ++i) {
            if (targets[i].getColumn().getParameterMode() == 1) {
                throw Error.parseError(2500, null, this.scanner.getLineNumber());
            }
            if (targets[i].getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.parseError(5561, null, this.scanner.getLineNumber());
        }
        StatementSet cs = new StatementSet(this.session, targets, expression, columnMap, this.compileContext);
        return cs;
    }

    StatementSet compileSetStatement(RangeGroup[] rangeGroups, RangeVariable[] rangeVars) {
        int i;
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(rangeGroups, rangeVars, targetSet, colIndexList, exprList);
        if (exprList.size() > 1) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Expression[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeGroups, targets[i]);
        }
        this.resolveOuterReferencesAndTypes(rangeGroups, expression);
        for (i = 0; i < targets.length; ++i) {
            ColumnSchema col = targets[i].getColumn();
            if (col.getParameterMode() == 1) {
                throw Error.error(2500, col.getName().statementName);
            }
            if (targets[i].getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.parseError(5561, null, this.scanner.getLineNumber());
        }
        StatementSet cs = new StatementSet(this.session, targets, expression, columnMap, this.compileContext);
        return cs;
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeGroup[] rangeGroups) {
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] targetRangeVars = new RangeVariable[]{rangeGroups[0].getRangeVariables()[1]};
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(rangeGroups, targetRangeVars, targetSet, colIndexList, exprList);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Expression[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(RangeGroup.emptyArray, targets[i]);
        }
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        this.resolveUpdateExpressions(table, RangeGroup.emptyGroup, columnMap, targets, updateExpressions, rangeGroups, null);
        StatementSet cs = new StatementSet(this.session, targets, table, rangeGroups[0].getRangeVariables(), columnMap, updateExpressions, this.compileContext);
        return cs;
    }

    StatementSchema compileAlterSpecificRoutine(Routine routine) {
        OrderedHashSet set;
        boolean restrict = false;
        routine = routine.duplicate();
        this.readRoutineCharacteristics(routine);
        restrict = this.readIfThis(526);
        if (restrict && !(set = this.database.schemaManager.getReferencesTo(routine.getSpecificName())).isEmpty()) {
            throw Error.parseError(5502, null, this.scanner.getLineNumber());
        }
        if (this.token.tokenType == 610) {
            this.read();
        } else if (this.token.tokenType == 482) {
            this.read();
        }
        this.readRoutineBody(routine);
        routine.resetAlteredRoutineSettings();
        routine.resolve(this.session);
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 4, args, null, this.database.schemaManager.getCatalogNameArray());
        return cs;
    }

    StatementSchema compileCreateProcedureOrFunction(boolean orReplace) {
        Routine routine = this.readCreateProcedureOrFunction();
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 69, args, null, this.database.schemaManager.getCatalogNameArray());
        return cs;
    }

    Routine readCreateProcedureOrFunction() {
        Routine routine = this.readProcedureOrFunctionDeclaration();
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readProcedureOrFunctionDeclaration() {
        boolean isAggregate = false;
        if (this.token.tokenType == 602) {
            isAggregate = true;
            this.read();
            if (this.token.tokenType == 229) {
                throw this.unexpectedToken();
            }
        }
        int routineType = this.token.tokenType == 229 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(routineType, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Routine routine = new Routine(routineType);
        routine.setName(name);
        routine.setAggregate(isAggregate);
        this.readRoutineArguments(routine);
        if (routineType != 17) {
            this.readThis(252);
            if (this.token.tokenType == 294) {
                this.read();
                TableDerived table = new TableDerived(this.database, SqlInvariants.SYSTEM_SCHEMA_HSQLNAME, 11);
                this.readTableDefinition(routine, table);
                routine.setReturnTable(table);
            } else {
                Type type = this.readTypeDefinition(false, true);
                routine.setReturnType(type);
            }
        }
        this.readRoutineCharacteristics(routine);
        return routine;
    }

    void readRoutineArguments(Routine routine) {
        this.readThis(937);
        if (this.token.tokenType == 922) {
            this.read();
        } else {
            while (true) {
                ColumnSchema newcolumn = this.readRoutineParameter(routine, true);
                routine.addParameter(newcolumn);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            this.readThis(922);
        }
    }

    Routine readCreatePasswordCheckFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 191) {
            this.read();
            return null;
        }
        if (this.token.tokenType == 112) {
            routine.setLanguage(1);
            routine.setDataImpact(1);
        } else {
            routine.setLanguage(2);
            routine.setDataImpact(2);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 16);
        hsqlName.setSchemaIfNull(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        routine.setName(hsqlName);
        hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 23);
        ColumnSchema column = new ColumnSchema(hsqlName, Type.SQL_VARCHAR, false, false, null);
        routine.addParameter(column);
        routine.setReturnType(Type.SQL_BOOLEAN);
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readCreateDatabaseAuthenticationFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 191) {
            this.read();
            return null;
        }
        this.checkIsThis(112);
        routine.setLanguage(1);
        routine.setDataImpact(1);
        routine.setName(this.database.nameManager.newHsqlName("AUTHENTICATION", false, 16));
        for (int i = 0; i < 3; ++i) {
            ColumnSchema column = new ColumnSchema(null, Type.SQL_VARCHAR, false, false, null);
            routine.addParameter(column);
        }
        routine.setReturnType(new ArrayType(Type.SQL_VARCHAR_DEFAULT, 0x100000));
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    private void readTableDefinition(Routine routine, Table table) {
        this.readThis(937);
        int i = 0;
        while (true) {
            ColumnSchema newcolumn;
            if ((newcolumn = this.readRoutineParameter(routine, false)).getName() == null) {
                throw this.unexpectedToken();
            }
            table.addColumn(newcolumn);
            if (this.token.tokenType != 924) break;
            this.read();
            ++i;
        }
        this.readThis(922);
        table.createPrimaryKey();
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet set = new OrderedIntHashSet();
        boolean end = false;
        block16: while (!end) {
            switch (this.token.tokenType) {
                case 156: {
                    if (!set.add(156)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 461) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 275) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 214: {
                    if (!set.add(214)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(562);
                    if (this.token.tokenType == 461) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(275);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 273: {
                    if (!set.add(273)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(name);
                    continue block16;
                }
                case 88: {
                    if (!set.add(88)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 193: {
                    if (!set.add(88)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(88);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 181: {
                    if (!set.add(275)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    this.readThis(400);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 190: {
                    if (!set.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 232: {
                    if (!set.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    this.readThis(400);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 52: {
                    if (!set.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 252: {
                    if (!set.add(196) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isAggregate()) {
                        throw Error.error(5604, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(196);
                    this.readThis(204);
                    this.readThis(196);
                    this.readThis(446);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 29: {
                    if (!set.add(196) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(204);
                    this.readThis(196);
                    this.readThis(446);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 94: {
                    if (!set.add(250) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(250);
                    this.readThis(553);
                    int results = this.readInteger();
                    if (results < 0 || results > 16) {
                        throw Error.error(5604, String.valueOf(results));
                    }
                    routine.setMaxDynamicResults(results);
                    continue block16;
                }
                case 189: {
                    if (routine.getType() == 16 || !set.add(260)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(260);
                    this.readThis(469);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 203: {
                    if (routine.getType() == 16 || !set.add(260)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(260);
                    this.readThis(469);
                    routine.setNewSavepointLevel(false);
                    throw this.unsupportedFeature("OLD");
                }
            }
            end = true;
        }
    }

    void readRoutineBody(Routine routine) {
        if (this.token.tokenType == 112) {
            this.readRoutineJavaBody(routine);
        } else {
            this.readRoutineSQLBody(routine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRoutineSQLBody(Routine routine) {
        ParserBase.Recorder recorder = this.startRecording();
        this.session.sessionContext.pushRoutineTables();
        try {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            String sql = recorder.getSQL();
            statement.setSQL(sql);
            routine.setProcedure(statement);
        }
        finally {
            this.session.sessionContext.popRoutineTables();
        }
    }

    void readRoutineJavaBody(Routine routine) {
        if (routine.getLanguage() != 1) {
            throw this.unexpectedToken();
        }
        this.read();
        this.readThis(482);
        this.checkIsQuotedString();
        routine.setMethodURL((String)this.token.tokenValue);
        this.read();
        if (this.token.tokenType == 214) {
            this.read();
            this.readThis(562);
            this.readThis(461);
        }
    }

    Object[] readLocalDeclarationList(Routine routine, StatementCompound context) {
        HsqlArrayList<ColumnSchema[]> list = new HsqlArrayList<ColumnSchema[]>();
        boolean table = false;
        boolean variableOrCondition = true;
        int cursor = 2;
        int handler = 3;
        int objectType = 0;
        RangeGroup[] rangeGroups = new RangeGroup[]{context == null ? routine : context};
        this.compileContext.setOuterRanges(rangeGroups);
        while (this.token.tokenType == 82) {
            Object var = null;
            if (objectType == 0) {
                var = this.readLocalTableVariableDeclarationOrNull(routine);
                if (var == null) {
                    objectType = 1;
                    continue;
                }
                list.add((ColumnSchema[])var);
                this.readThis(943);
                continue;
            }
            if (objectType == 1) {
                var = this.readLocalVariableDeclarationOrNull();
                if (var == null) {
                    objectType = 2;
                    continue;
                }
                list.addAll((Object[])var);
                continue;
            }
            if (objectType == 2) {
                var = this.compileDeclareCursorOrNull(rangeGroups, true);
                if (var == null) {
                    objectType = 3;
                    continue;
                }
                list.add((ColumnSchema[])var);
                this.readThis(943);
                continue;
            }
            if (objectType != 3) continue;
            var = this.compileLocalHandlerDeclaration(routine, context);
            list.add((ColumnSchema[])var);
        }
        Object[] declarations = new Object[list.size()];
        list.toArray(declarations);
        return declarations;
    }

    Table readLocalTableVariableDeclarationOrNull(Routine routine) {
        int position = this.getPosition();
        this.readThis(82);
        if (this.token.tokenType == 294) {
            this.read();
            HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
            name.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
            Table table = new Table(this.database, name, 3);
            table.persistenceScope = 20;
            this.readTableDefinition(routine, table);
            this.session.sessionContext.addSessionTable(table);
            return table;
        }
        this.rewind(position);
        return null;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull() {
        Type type;
        int position = this.getPosition();
        HsqlArrayList<HsqlNameManager.HsqlName> names = new HsqlArrayList<HsqlNameManager.HsqlName>();
        try {
            this.readThis(82);
            if (this.isReservedKey()) {
                this.rewind(position);
                return null;
            }
            while (true) {
                HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(22, false);
                if (this.token.tokenType == 49) {
                    this.rewind(position);
                    return null;
                }
                names.add(name);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            type = this.readTypeDefinition(false, true);
        }
        catch (HsqlException e) {
            this.rewind(position);
            return null;
        }
        Expression def = null;
        if (this.token.tokenType == 83) {
            this.read();
            def = this.readDefaultClause(type);
        }
        ColumnSchema[] variable = new ColumnSchema[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            variable[i] = new ColumnSchema((HsqlNameManager.HsqlName)names.get(i), type, true, false, def);
            variable[i].setParameterMode((byte)2);
        }
        this.readThis(943);
        return variable;
    }

    private StatementHandler compileLocalHandlerDeclaration(Routine routine, StatementCompound context) {
        int handlerType;
        this.readThis(82);
        switch (this.token.tokenType) {
            case 398: {
                this.read();
                handlerType = 5;
                break;
            }
            case 110: {
                this.read();
                handlerType = 6;
                break;
            }
            case 313: {
                this.read();
                handlerType = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(134);
        this.readThis(120);
        StatementHandler handler = new StatementHandler(handlerType);
        boolean end = false;
        boolean start = true;
        block12: while (!end) {
            int conditionType = 0;
            switch (this.token.tokenType) {
                case 924: {
                    if (start) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    start = true;
                    continue block12;
                }
                case 277: {
                    conditionType = 4;
                }
                case 276: {
                    if (conditionType == 0) {
                        conditionType = 1;
                    }
                }
                case 278: {
                    if (conditionType == 0) {
                        conditionType = 2;
                    }
                }
                case 193: {
                    if (conditionType == 0) {
                        conditionType = 3;
                    }
                    if (!start) {
                        throw this.unexpectedToken();
                    }
                    start = false;
                    this.read();
                    if (conditionType == 3) {
                        this.readThis(431);
                    } else if (conditionType == 4) {
                        String sqlState = this.parseSQLStateValue();
                        handler.addConditionState(sqlState);
                        continue block12;
                    }
                    handler.addConditionType(conditionType);
                    continue block12;
                }
            }
            if (start) {
                throw this.unexpectedToken();
            }
            end = true;
        }
        if (this.token.tokenType == 943) {
            this.read();
        } else {
            Statement e = this.compileSQLProcedureStatementOrNull(routine, context);
            if (e == null) {
                throw this.unexpectedToken();
            }
            this.readThis(943);
            handler.addStatement(e);
        }
        return handler;
    }

    String parseSQLStateValue() {
        this.readIfThis(323);
        this.checkIsQuotedString();
        String sqlState = this.token.tokenString;
        if (sqlState.length() != 5) {
            throw Error.parseError(5607, null, this.scanner.getLineNumber());
        }
        this.read();
        return sqlState;
    }

    String parseSQLFeatureValue() {
        if (!this.isUndelimitedSimpleName()) {
            throw Error.parseError(5555, this.token.tokenString, this.scanner.getLineNumber());
        }
        String sqlFeature = this.token.tokenString;
        int index = ArrayUtil.find(featureStrings, sqlFeature);
        if (index < 0) {
            throw Error.parseError(5555, this.token.tokenString, this.scanner.getLineNumber());
        }
        this.read();
        return sqlFeature;
    }

    Statement compileCompoundStatement(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        boolean atomic = true;
        this.readThis(18);
        this.readThis(15);
        label = this.createLabelIfNull(context, label);
        StatementCompound statement = new StatementCompound(99, label, context);
        statement.setAtomic(true);
        statement.setRoot(routine);
        Object[] declarations = this.readLocalDeclarationList(routine, context);
        statement.setLocalDeclarations(declarations);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, statement);
        statement.setStatements(statements);
        this.readThis(99);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statement;
    }

    HsqlNameManager.HsqlName createLabelIfNull(StatementCompound context, HsqlNameManager.HsqlName label) {
        if (label != null) {
            return label;
        }
        StatementCompound parent = context;
        int level = 0;
        while (parent != null) {
            ++level;
            parent = parent.parent;
        }
        String labelString = "_" + level;
        label = this.session.database.nameManager.newHsqlName(labelString, false, 21);
        return label;
    }

    Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound context) {
        Statement e;
        HsqlArrayList<Statement> list = new HsqlArrayList<Statement>();
        while ((e = this.compileSQLProcedureStatementOrNull(routine, context)) != null) {
            this.readThis(943);
            list.add(e);
        }
        if (list.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statements = new Statement[list.size()];
        list.toArray(statements);
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound context) {
        Statement cs = null;
        HsqlNameManager.HsqlName label = null;
        RangeGroup rangeGroup = context == null ? routine : context;
        RangeGroup[] rangeGroups = new RangeGroup[]{rangeGroup};
        if (!routine.isTrigger() && this.isSimpleName() && !this.isReservedKey()) {
            label = this.readLabel();
        }
        this.compileContext.reset();
        HsqlNameManager.HsqlName oldSchema = this.session.getCurrentSchemaHsqlName();
        this.session.setCurrentSchemaHsqlName(routine.getSchemaName());
        try {
            switch (this.token.tokenType) {
                case 206: {
                    if (routine.dataImpact == 2) {
                        throw Error.error(5602, routine.getDataImpactString());
                    }
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileOpenCursorStatement(context);
                    break;
                }
                case 265: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileSelectSingleRowStatement(rangeGroups);
                    break;
                }
                case 145: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileInsertStatement(rangeGroups);
                    break;
                }
                case 319: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileUpdateStatement(rangeGroups);
                    break;
                }
                case 84: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileDeleteStatement(rangeGroups);
                    break;
                }
                case 311: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileTruncateStatement();
                    break;
                }
                case 176: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileMergeStatement(rangeGroups);
                    break;
                }
                case 268: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (routine.isTrigger()) {
                        if (routine.triggerType == 4 && routine.triggerOperation != 19) {
                            int position = this.getPosition();
                            try {
                                cs = this.compileTriggerSetStatement(routine.triggerTable, rangeGroups);
                                break;
                            }
                            catch (HsqlException e) {
                                this.rewind(position);
                                cs = this.compileSetStatement(rangeGroups, rangeGroup.getRangeVariables());
                            }
                        } else {
                            cs = this.compileSetStatement(rangeGroups, rangeGroup.getRangeVariables());
                        }
                        ((StatementSet)cs).checkIsNotColumnTarget();
                        break;
                    }
                    cs = this.compileSetStatement(rangeGroups, rangeGroup.getRangeVariables());
                    break;
                }
                case 128: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileGetStatement(rangeGroups);
                    break;
                }
                case 28: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileCallStatement(rangeGroups, true);
                    Routine proc = ((StatementProcedure)cs).procedure;
                    if (proc == null) break;
                    switch (routine.dataImpact) {
                        case 2: {
                            if (proc.dataImpact != 3 && proc.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                        case 3: {
                            if (proc.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                    }
                    break;
                }
                case 251: {
                    if (routine.isTrigger() || label != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    cs = this.compileReturnValue(routine, context);
                    break;
                }
                case 18: {
                    cs = this.compileCompoundStatement(routine, context, label);
                    break;
                }
                case 340: {
                    if (routine.isTrigger()) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileWhile(routine, context, label);
                    break;
                }
                case 248: {
                    cs = this.compileRepeat(routine, context, label);
                    break;
                }
                case 170: {
                    cs = this.compileLoop(routine, context, label);
                    break;
                }
                case 120: {
                    cs = this.compileFor(routine, context, label);
                    break;
                }
                case 153: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileIterate();
                    break;
                }
                case 162: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileLeave(routine, context);
                    break;
                }
                case 439: {
                    cs = this.compileIf(routine, context);
                    break;
                }
                case 32: {
                    cs = this.compileCase(routine, context);
                    break;
                }
                case 269: {
                    cs = this.compileSignal(routine, context, label);
                    break;
                }
                case 249: {
                    cs = this.compileResignal(routine, context, label);
                    break;
                }
                default: {
                    Statement statement = null;
                    return statement;
                }
            }
            cs.setRoot(routine);
            cs.setParent(context);
            Statement statement = cs;
            return statement;
        }
        finally {
            this.session.setCurrentSchemaHsqlName(oldSchema);
        }
    }

    HsqlNameManager.HsqlName readLabel() {
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        if (this.token.tokenType != 923) {
            throw this.unexpectedToken(label.getNameString());
        }
        this.readThis(923);
        return label;
    }

    Statement compileReturnValue(Routine routine, StatementCompound context) {
        RangeGroup[] rangeGroups = new RangeGroup[]{context == null ? routine : context};
        this.compileContext.setOuterRanges(rangeGroups);
        Expression e = this.XreadValueExpression();
        if (e == null) {
            throw this.unexpectedToken();
        }
        this.resolveOuterReferencesAndTypes(routine, context, e);
        if (routine.isProcedure()) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        if (routine.returnsTable() && e.getType() != 23) {
            throw Error.parseError(5611, null, this.scanner.getLineNumber());
        }
        RowType returnType = new RowType(e.getNodeDataTypes());
        Type declaredType = routine.getReturnType();
        if (!declaredType.isRowType()) {
            declaredType = new RowType(new Type[]{routine.getReturnType()});
        }
        if (declaredType.getDegree() != ((Type)returnType).getDegree()) {
            throw Error.parseError(5564, null, this.scanner.getLineNumber());
        }
        if (!declaredType.canBeAssignedFrom(returnType)) {
            throw Error.parseError(5611, null, this.scanner.getLineNumber());
        }
        return new StatementExpression(this.session, this.compileContext, 62, e);
    }

    Statement compileIterate() {
        this.readThis(153);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(103, label);
    }

    Statement compileLeave(Routine routine, StatementCompound context) {
        this.readThis(162);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(104, label);
    }

    Statement compileWhile(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(340);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1211, e);
        this.readThis(91);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(99);
        this.readThis(340);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(110, label, context);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    Statement compileRepeat(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(248);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(318);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1211, e);
        this.readThis(99);
        this.readThis(248);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(107, label, context);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    Statement compileLoop(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(170);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(99);
        this.readThis(170);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound result = new StatementCompound(105, label, context);
        result.setStatements(statements);
        return result;
    }

    Statement compileFor(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        RangeGroup[] rangeGroups = new RangeGroup[]{context == null ? routine : context};
        this.compileContext.setOuterRanges(rangeGroups);
        this.readThis(120);
        StatementQuery cursorStatement = this.compileCursorSpecification(rangeGroups, 0, false);
        this.readThis(91);
        StatementCompound forStatement = new StatementCompound(101, label, context);
        forStatement.setAtomic(true);
        forStatement.setRoot(routine);
        forStatement.setLoopStatement(null, cursorStatement);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, forStatement);
        this.readThis(99);
        this.readThis(120);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        forStatement.setStatements(statements);
        return forStatement;
    }

    Statement compileIf(Routine routine, StatementCompound context) {
        int i;
        HsqlArrayList<Statement> list = new HsqlArrayList<Statement>();
        this.readThis(439);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1211, e);
        list.add(statement);
        this.readThis(296);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        for (i = 0; i < statements.length; ++i) {
            list.add(statements[i]);
        }
        while (this.token.tokenType == 98) {
            this.read();
            e = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, context, e);
            statement = new StatementExpression(this.session, this.compileContext, 1211, e);
            list.add(statement);
            this.readThis(296);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        if (this.token.tokenType == 97) {
            this.read();
            e = Expression.EXPR_TRUE;
            statement = new StatementExpression(this.session, this.compileContext, 1211, e);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(99);
        this.readThis(439);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(102, null, context);
        result.setStatements(statements);
        return result;
    }

    Statement compileCase(Routine routine, StatementCompound context) {
        Statement[] statements;
        Expression condition = null;
        this.readThis(32);
        HsqlArrayList list = this.token.tokenType == 332 ? this.readCaseWhen(routine, context) : this.readSimpleCaseWhen(routine, context);
        if (this.token.tokenType == 97) {
            this.read();
            condition = Expression.EXPR_TRUE;
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1211, condition);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(99);
        this.readThis(32);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(102, null, context);
        result.setStatements(statements);
        return result;
    }

    HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList<Statement> list = new HsqlArrayList<Statement>();
        Expression condition = null;
        Expression predicand = this.XreadRowValuePredicand();
        do {
            this.readThis(332);
            while (true) {
                Expression newCondition;
                if (predicand == (newCondition = this.XreadPredicateRightPart(predicand))) {
                    newCondition = new ExpressionLogical(predicand, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, context, newCondition);
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1211, condition);
            list.add(statement);
            this.readThis(296);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 332);
        return list;
    }

    HsqlArrayList readCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList<Statement> list = new HsqlArrayList<Statement>();
        Expression condition = null;
        do {
            this.readThis(332);
            condition = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, context, condition);
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1211, condition);
            list.add(statement);
            this.readThis(296);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 332);
        return list;
    }

    Statement compileSignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        Expression message = null;
        this.readThis(269);
        this.readThis(277);
        String sqlState = this.parseSQLStateValue();
        if (this.readIfThis(268)) {
            this.readThis(478);
            this.readThis(420);
            message = this.XreadSimpleValueSpecificationOrNull();
            if (message == null) {
                throw this.unexpectedToken();
            }
            this.resolveOuterReferencesAndTypes(routine, context, message);
        }
        StatementSignal cs = new StatementSignal(108, sqlState, message);
        return cs;
    }

    private Statement compileResignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        String sqlState = null;
        Expression message = null;
        this.readThis(249);
        if (this.readIfThis(277)) {
            sqlState = this.parseSQLStateValue();
            if (this.readIfThis(268)) {
                this.readThis(478);
                this.readThis(420);
                message = this.XreadSimpleValueSpecificationOrNull();
                if (message == null) {
                    throw this.unexpectedToken();
                }
                this.resolveOuterReferencesAndTypes(routine, context, message);
            }
        }
        StatementSignal cs = new StatementSignal(106, sqlState, message);
        return cs;
    }

    ColumnSchema readRoutineParameter(Routine routine, boolean isParam) {
        HsqlNameManager.HsqlName hsqlName = null;
        int parameterMode = this.readRoutineParameterMode(routine.routineType, routine.isAggregate);
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type typeObject = this.readTypeDefinition(false, true);
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, true, false, null);
        if (isParam) {
            column.setParameterMode((byte)parameterMode);
        }
        return column;
    }

    int readRoutineParameterMode(int routineType, boolean isAggregate) {
        int parameterMode = 1;
        switch (this.token.tokenType) {
            case 140: {
                this.read();
                break;
            }
            case 209: {
                if (routineType != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                parameterMode = 4;
                break;
            }
            case 143: {
                if (routineType != 17 && !isAggregate) {
                    throw this.unexpectedToken();
                }
                this.read();
                parameterMode = 2;
                break;
            }
        }
        return parameterMode;
    }

    void resolveOuterReferencesAndTypes(Routine routine, StatementCompound context, Expression e) {
        RangeGroup rangeGroup = context == null ? routine : context;
        this.resolveOuterReferencesAndTypes(new RangeGroup[]{rangeGroup}, e);
    }

    StatementSchema compileCreateTrigger(boolean orReplace) {
        Object[] args;
        String sql;
        int operationType;
        int beforeOrAfterType;
        Boolean isForEachRow = null;
        boolean isNowait = false;
        boolean hasQueueSize = false;
        int queueSize = 0;
        HsqlNameManager.HsqlName otherName = null;
        OrderedHashSet columns = null;
        int[] updateColumnIndexes = null;
        this.read();
        Boolean ifNotExists = this.readIfNotExists();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 449: {
                beforeOrAfterType = TriggerDef.getTiming(449);
                this.read();
                this.readThis(201);
                break;
            }
            case 358: 
            case 365: {
                beforeOrAfterType = TriggerDef.getTiming(this.token.tokenType);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 84: 
            case 145: {
                operationType = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                break;
            }
            case 319: {
                operationType = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                if (this.token.tokenType != 201 || beforeOrAfterType == 6) break;
                this.read();
                columns = new OrderedHashSet();
                this.readColumnNameList(columns, null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(204);
        Table table = this.readTableName();
        if (this.token.tokenType == 365) {
            this.read();
            this.checkIsSimpleName();
            otherName = this.readNewSchemaObjectName(8, true);
        }
        name.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (beforeOrAfterType == 6 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, name.schema.name);
        }
        if (name.schema != table.getSchemaName()) {
            throw Error.error(5505, name.schema.name);
        }
        name.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (columns != null) {
            updateColumnIndexes = table.getColumnIndexes(columns);
            for (int i = 0; i < updateColumnIndexes.length; ++i) {
                if (updateColumnIndexes[i] != -1) continue;
                throw Error.error(5544, (String)columns.get(i));
            }
        }
        Expression condition = null;
        HsqlNameManager.SimpleName oldTableName = null;
        HsqlNameManager.SimpleName newTableName = null;
        HsqlNameManager.SimpleName oldRowName = null;
        HsqlNameManager.SimpleName newRowName = null;
        Table[] transitions = new Table[4];
        RangeVariable[] rangeVars = new RangeVariable[4];
        String conditionSQL = null;
        RangeGroup[] rangeGroups = new RangeGroup[]{new RangeGroup.RangeGroupSimple(rangeVars, false)};
        if (this.token.tokenType == 237) {
            this.read();
            if (this.token.tokenType != 203 && this.token.tokenType != 189) {
                throw this.unexpectedToken();
            }
            while (true) {
                RangeVariable range;
                RangeVariable range2;
                Table transition;
                HsqlNameManager.HsqlName hsqlName;
                HsqlNameManager.SimpleName n;
                if (this.token.tokenType == 203) {
                    if (operationType == 55) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 294) {
                        if (Boolean.TRUE.equals(isForEachRow) || oldTableName != null || beforeOrAfterType == 4) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(11);
                        this.checkIsSimpleName();
                        this.read();
                        n = oldTableName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                        if (n.equals(newTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        isForEachRow = Boolean.FALSE;
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n.name, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range2 = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[2] = transition;
                        rangeVars[2] = range2;
                        continue;
                    }
                    if (Boolean.FALSE.equals(isForEachRow) || oldRowName != null) {
                        throw this.unexpectedToken();
                    }
                    this.readIfThis(257);
                    this.readIfThis(11);
                    this.checkIsSimpleName();
                    oldRowName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    n = oldRowName;
                    if (n.equals(newTableName) || n.equals(oldTableName) || n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    isForEachRow = Boolean.TRUE;
                    range = new RangeVariable(table.columnList, oldRowName, false, 2);
                    range.rangePosition = 0;
                    transitions[0] = null;
                    rangeVars[0] = range;
                    continue;
                }
                if (this.token.tokenType != 189) break;
                if (operationType == 19) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 294) {
                    if (Boolean.TRUE.equals(isForEachRow) || newTableName != null || beforeOrAfterType == 4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readIfThis(11);
                    this.checkIsSimpleName();
                    newTableName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    isForEachRow = Boolean.FALSE;
                    n = newTableName;
                    if (n.equals(oldTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n.name, this.isDelimitedIdentifier(), 10);
                    transition = new Table(table, hsqlName);
                    range2 = new RangeVariable(transition, null, null, null, this.compileContext);
                    transitions[3] = transition;
                    rangeVars[3] = range2;
                    continue;
                }
                if (Boolean.FALSE.equals(isForEachRow) || newRowName != null) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(257);
                this.readIfThis(11);
                this.checkIsSimpleName();
                newRowName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                this.read();
                n = newRowName;
                if (n.equals(oldTableName) || n.equals(newTableName) || n.equals(oldRowName)) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.TRUE;
                range = new RangeVariable(table.columnList, newRowName, false, 2);
                range.rangePosition = 1;
                transitions[1] = null;
                rangeVars[1] = range;
            }
        }
        if (Boolean.TRUE.equals(isForEachRow) && this.token.tokenType != 120) {
            throw this.unexpectedTokenRequire("FOR");
        }
        if (this.token.tokenType == 120) {
            this.read();
            this.readThis(95);
            if (this.token.tokenType == 257) {
                if (Boolean.FALSE.equals(isForEachRow)) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.TRUE;
            } else if (this.token.tokenType == 560) {
                if (Boolean.TRUE.equals(isForEachRow) || beforeOrAfterType == 4) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.FALSE;
            } else {
                throw this.unexpectedToken();
            }
            this.read();
        }
        if (rangeVars[2] != null) {
            // empty if block
        }
        if (rangeVars[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            queueSize = this.readInteger();
            hasQueueSize = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            isNowait = true;
        }
        if (this.token.tokenType == 332 && beforeOrAfterType != 6) {
            this.read();
            this.readThis(937);
            int position = this.getPosition();
            condition = this.XreadBooleanValueExpression();
            conditionSQL = this.getLastPart(position);
            this.readThis(922);
            List unresolved = condition.resolveColumnReferences(this.session, rangeGroups[0], rangeGroups, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (isForEachRow == null) {
            isForEachRow = Boolean.FALSE;
        }
        if (this.token.tokenType == 28) {
            int position = this.getPosition();
            try {
                this.read();
                this.checkIsSimpleName();
                this.checkIsDelimitedIdentifier();
                String className = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 937) {
                    throw this.unexpectedToken();
                }
                TriggerDef td = new TriggerDef(name, beforeOrAfterType, operationType, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, className, isNowait, queueSize);
                sql = this.getLastPart();
                args = new Object[]{td, otherName, ifNotExists};
                HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema(sql, 90, args, null, writeLockNames);
            }
            catch (HsqlException e) {
                this.rewind(position);
            }
        }
        if (hasQueueSize) {
            throw this.unexpectedToken("QUEUE");
        }
        if (isNowait) {
            throw this.unexpectedToken("NOWAIT");
        }
        Routine routine = this.compileTriggerRoutine(table, rangeVars, beforeOrAfterType, operationType);
        TriggerDefSQL td = new TriggerDefSQL(name, beforeOrAfterType, operationType, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, routine);
        sql = this.getLastPart();
        args = new Object[]{td, otherName, ifNotExists};
        return new StatementSchema(sql, 90, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Routine compileTriggerRoutine(Table table, RangeVariable[] ranges, int beforeOrAfter, int operation) {
        int impact = beforeOrAfter == 4 ? 3 : 4;
        Routine routine = new Routine(table, ranges, impact, beforeOrAfter, operation);
        this.session.sessionContext.pushRoutineTables();
        try {
            ParserBase.Recorder recorder = this.startRecording();
            StatementCompound parent = new StatementCompound(99, null, null);
            parent.rangeVariables = ranges;
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            String sql = recorder.getSQL();
            statement.setSQL(sql);
            routine.setProcedure(statement);
            routine.resolve(this.session);
        }
        finally {
            this.session.sessionContext.popRoutineTables();
        }
        return routine;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName schema) {
        if (this.session.isProcessingLog()) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(schema.name);
        if (this.isSchemaDefinition) {
            if (schema != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(schema);
        }
        this.session.checkDDLWrite();
    }
}

