/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDML;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public class ParserTable
extends ParserDML {
    ParserTable(Session session, Scanner scanner) {
        super(session, scanner);
    }

    StatementSchema compileCreateTable(int type) {
        Table table;
        boolean ifNot = this.readIfNotExists();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (type) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, name, type);
                break;
            }
            default: {
                table = new Table(this.database, name, type);
            }
        }
        if (this.token.tokenType == 11) {
            return this.compileCreateTableAsSubqueryDefinition(table, ifNot);
        }
        return this.compileCreateTableBody(table, ifNot);
    }

    StatementSchema compileCreateTableBody(Table table, boolean ifNot) {
        Token value;
        OrderedHashMap list;
        HsqlArrayList tempConstraints = new HsqlArrayList();
        HsqlArrayList tempIndexes = new HsqlArrayList();
        StatementQuery statement = null;
        HsqlNameManager.HsqlName[] readLockNames = null;
        boolean isTable = this.readTableContentsSource(table, tempConstraints, tempIndexes);
        if (!isTable) {
            return this.compileCreateTableAsSubqueryDefinition(table, ifNot);
        }
        this.readTableVersioningClause(table);
        if (this.token.tokenType == 11) {
            this.read();
            QueryExpression queryExpression = null;
            queryExpression = this.readTableQuery();
            this.readThis(337);
            this.readThis(400);
            statement = new StatementQuery(this.session, queryExpression, this.compileContext);
            readLockNames = statement.getTableNamesForRead();
            Type[] dataTypes = queryExpression.getColumnTypes();
            if (table.getColumnCount() != dataTypes.length) {
                throw Error.error(5593);
            }
            for (int i = 0; i < dataTypes.length; ++i) {
                boolean b = table.getColumn(i).getDataType().canBeAssignedFrom(dataTypes[i]);
                if (b) continue;
                throw Error.error(5561);
            }
        }
        this.readTableOnCommitClause(table);
        if (this.database.sqlSyntaxMys && (list = super.readPropertyValuePairs(true, false)) != null && (value = (Token)list.get("COMMENT")) != null) {
            String comment;
            table.getName().comment = comment = value.tokenString;
        }
        OrderedHashSet<HsqlNameManager.HsqlName> names = new OrderedHashSet<HsqlNameManager.HsqlName>();
        names.add(this.database.getCatalogName());
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Table t;
            Constraint c = (Constraint)tempConstraints.get(i);
            HsqlNameManager.HsqlName name = c.getMainTableName();
            if (name == null || (t = this.database.schemaManager.findUserTable(name.name, name.schema.name)) == null || t.isTemp()) continue;
            names.add(table.getName());
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, tempConstraints, tempIndexes, statement, ifNot};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[names.size()];
        names.toArray(writeLockNames);
        return new StatementSchema(sql, 87, args, readLockNames, writeLockNames);
    }

    boolean readTableContentsSource(Table table, HsqlArrayList tempConstraints, HsqlArrayList tempIndexes) {
        int position = this.getPosition();
        this.readThis(937);
        Constraint c = new Constraint(null, null, 5);
        tempConstraints.add(c);
        boolean start = true;
        boolean startPart = true;
        boolean end = false;
        boolean hasRowStart = false;
        boolean hasRowEnd = false;
        block8: while (!end) {
            switch (this.token.tokenType) {
                case 164: {
                    ColumnSchema[] likeColumns = this.readLikeTable(table);
                    for (int i = 0; i < likeColumns.length; ++i) {
                        table.addColumn(likeColumns[i]);
                    }
                    start = false;
                    startPart = false;
                    continue block8;
                }
                case 40: 
                case 51: 
                case 121: 
                case 228: 
                case 315: {
                    if (!startPart) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, tempConstraints);
                    start = false;
                    startPart = false;
                    continue block8;
                }
                case 220: {
                    if (!startPart) {
                        throw this.unexpectedToken();
                    }
                    if (table.isTemp() || table.isText()) {
                        throw this.unexpectedToken();
                    }
                    PeriodDefinition period = this.readAndAddPeriod(table);
                    if (period == null) break;
                    start = false;
                    startPart = false;
                    continue block8;
                }
                case 924: {
                    if (startPart) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    startPart = true;
                    continue block8;
                }
                case 922: {
                    this.read();
                    end = true;
                    continue block8;
                }
                case 463: 
                case 644: {
                    if (!this.database.sqlSyntaxMys) break;
                    this.readIndex(table, tempIndexes);
                    start = false;
                    startPart = false;
                    continue block8;
                }
            }
            if (!startPart) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema newcolumn = this.readColumnDefinitionOrNull(table, hsqlName, tempConstraints);
            if (newcolumn == null) {
                if (start) {
                    this.rewind(position);
                    return false;
                }
                throw Error.error(5000);
            }
            table.addColumn(newcolumn);
            start = false;
            startPart = false;
            if (newcolumn.getSystemPeriodType() == 1) {
                if (hasRowStart) {
                    throw Error.error(5591);
                }
                hasRowStart = true;
                continue;
            }
            if (newcolumn.getSystemPeriodType() != 2) continue;
            if (hasRowEnd) {
                throw Error.error(5591);
            }
            hasRowEnd = true;
        }
        if (table.getColumnCount() == 0) {
            throw Error.error(5591);
        }
        if (hasRowStart ^ hasRowEnd) {
            throw Error.error(5516);
        }
        if (hasRowStart && table.systemPeriod == null) {
            throw Error.error(5516);
        }
        this.setPeriodColumns(table, table.systemPeriod);
        this.setPeriodColumns(table, table.applicationPeriod);
        if (table.applicationPeriod != null) {
            throw Error.error(1551, table.applicationPeriod.getName().name);
        }
        return true;
    }

    void setPeriodColumns(Table table, PeriodDefinition period) {
        if (period == null) {
            return;
        }
        OrderedHashSet set = period.columnNames;
        ColumnSchema startColumn = null;
        ColumnSchema endColumn = null;
        HsqlNameManager.HsqlName name = period.getName();
        int index = table.findColumn(name.name);
        if (index >= 0) {
            throw Error.error(5516, name.name);
        }
        for (int i = 0; i < 2; ++i) {
            String columnName = (String)set.get(i);
            index = table.findColumn(columnName);
            if (index < 0) {
                throw Error.error(5501, columnName);
            }
            ColumnSchema column = table.getColumn(index);
            Type type = column.getDataType();
            switch (period.periodType) {
                case 1: {
                    if (!type.isTimestampType()) {
                        throw Error.error(5516, columnName);
                    }
                    if (!(i == 0 ? column.getSystemPeriodType() != 1 : column.getSystemPeriodType() != 2)) break;
                    throw Error.error(5516, columnName);
                }
                case 2: {
                    if (type.isDateOrTimestampType()) break;
                    throw Error.error(5516, columnName);
                }
            }
            if (i == 0) {
                startColumn = column;
                continue;
            }
            endColumn = column;
            if (startColumn.getDataType().equals(endColumn.getDataType())) continue;
            throw Error.error(5516, columnName);
        }
        period.startColumn = startColumn;
        period.endColumn = endColumn;
    }

    void checkPeriodColumnsAdd(Table table, PeriodDefinition period) {
        if (period == null) {
            return;
        }
        OrderedHashSet set = period.columnNames;
        HsqlNameManager.HsqlName name = period.getName();
        int index = table.findColumn(name.name);
        if (index >= 0) {
            throw Error.error(5516, name.name);
        }
        for (int i = 0; i < 2; ++i) {
            String columnName = (String)set.get(i);
            index = table.findColumn(columnName);
            if (index < 0) continue;
            throw Error.error(5504, columnName);
        }
    }

    void readTableVersioningClause(Table table) {
        if (table.systemPeriod != null && this.readIfThis(337)) {
            this.readThis(291);
            this.readThis(331);
            table.isSystemVersioned = true;
        }
    }

    void readTableOnCommitClause(Table table) {
        if (this.token.tokenType == 204) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(47);
            if (this.token.tokenType != 84 && this.token.tokenType == 517) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(259);
        }
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean generated = false;
        boolean identity = false;
        boolean defaults = false;
        Table likeTable = this.readTableName();
        OrderedIntHashSet set = new OrderedIntHashSet();
        while (true) {
            boolean including;
            boolean bl = including = this.token.tokenType == 443;
            if (!including && this.token.tokenType != 424) break;
            this.read();
            switch (this.token.tokenType) {
                case 434: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    generated = including;
                    break;
                }
                case 138: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    identity = including;
                    break;
                }
                case 403: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    defaults = including;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnList = new ColumnSchema[likeTable.getColumnCount()];
        for (int i = 0; i < columnList.length; ++i) {
            ColumnSchema column = likeTable.getColumn(i).duplicate();
            HsqlNameManager.HsqlName name = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), column.getName());
            column.setName(name);
            column.setPrimaryKey(false);
            if (identity) {
                if (column.isIdentity()) {
                    column.setIdentity(column.getIdentitySequence().duplicate());
                }
            } else {
                column.setIdentity(null);
            }
            if (!defaults) {
                column.setDefaultExpression(null);
            }
            if (!generated) {
                column.setGeneratingExpression(null);
            }
            columnList[i] = column;
        }
        return columnList;
    }

    StatementSchema compileCreateTableAsSubqueryDefinition(Table table, boolean ifNotExists) {
        HsqlNameManager.HsqlName[] readName = null;
        boolean withData = true;
        HsqlNameManager.HsqlName[] columnNames = null;
        StatementQuery statement = null;
        QueryExpression queryExpression = null;
        if (this.token.tokenType == 937) {
            columnNames = this.readColumnNames(table.getName());
        }
        this.readThis(11);
        queryExpression = this.readTableQuery();
        this.readThis(337);
        if (this.token.tokenType == 190) {
            this.read();
            withData = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(400);
        if (this.token.tokenType == 204) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(47);
            if (this.token.tokenType != 84 && this.token.tokenType == 517) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(259);
        }
        if (columnNames == null) {
            columnNames = queryExpression.getResultColumnNames();
        } else if (columnNames.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, columnNames, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (withData) {
            statement = new StatementQuery(this.session, queryExpression, this.compileContext);
            readName = statement.getTableNamesForRead();
        }
        Object[] args = new Object[]{table, new HsqlArrayList(), new HsqlArrayList(), statement, ifNotExists};
        String sql = this.getLastPart();
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema st = new StatementSchema(sql, 87, args, readName, writeLockNames);
        return st;
    }

    private QueryExpression readTableQuery() {
        this.readThis(937);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(922);
        return queryExpression;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList tempConstraints, HsqlArrayList constraintList, boolean addToSchema) {
        Constraint c = (Constraint)tempConstraints.get(0);
        HsqlNameManager.HsqlName indexName = session.database.nameManager.newConstraintIndexName(table.getName(), c.getName(), session.database.sqlSysIndexNames);
        c.setColumnsIndexes(table);
        table.createPrimaryKey(indexName, c.core.mainCols, true);
        if (c.core.mainCols != null) {
            Constraint newconstraint = new Constraint(c.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(newconstraint);
            if (addToSchema) {
                session.database.schemaManager.addSchemaObject(newconstraint);
            }
        }
        block7: for (int i = 1; i < tempConstraints.size(); ++i) {
            c = (Constraint)tempConstraints.get(i);
            switch (c.getConstraintType()) {
                case 2: {
                    c.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(c.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    indexName = session.database.nameManager.newConstraintIndexName(table.getName(), c.getName(), session.database.sqlSysIndexNames);
                    Index index = table.createAndAddIndexStructure(session, indexName, c.core.mainCols, null, null, true, true, false);
                    Constraint newconstraint = new Constraint(c.getName(), table, index, 2);
                    table.addConstraint(newconstraint);
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(newconstraint);
                    continue block7;
                }
                case 0: {
                    ParserTable.addForeignKey(session, table, c, constraintList);
                    continue block7;
                }
                case 3: {
                    try {
                        c.prepareCheckConstraint(session, table);
                    }
                    catch (HsqlException e) {
                        if (session.isProcessingScript()) continue block7;
                        throw e;
                    }
                    table.addConstraint(c);
                    if (c.isNotNull()) {
                        ColumnSchema column = table.getColumn(c.notNullColumnIndex);
                        column.setNullable(false);
                        table.setColumnTypeVars(c.notNullColumnIndex);
                    }
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(c);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint c, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        if (mainTableName == table.getName()) {
            c.core.mainTable = table;
        } else {
            Table mainTable = session.database.schemaManager.findUserTable(mainTableName.name, mainTableName.schema.name);
            if (mainTable == null) {
                if (constraintList == null) {
                    throw Error.error(5501, mainTableName.name);
                }
                constraintList.add(c);
                return;
            }
            c.core.mainTable = mainTable;
        }
        c.setColumnsIndexes(table);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.checkCreateForeignKey(table, c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        if (uniqueConstraint == null) {
            throw Error.error(5523);
        }
        Index mainIndex = uniqueConstraint.getMainIndex();
        boolean isForward = c.core.mainTable.getSchemaName() != table.getSchemaName();
        int offset = session.database.schemaManager.getTableIndex(table);
        if (offset != -1 && offset < session.database.schemaManager.getTableIndex(c.core.mainTable)) {
            isForward = true;
        }
        HsqlNameManager.HsqlName refIndexName = session.database.nameManager.newConstraintIndexName(table.getName(), c.getName(), session.database.sqlSysIndexNames);
        Index index = table.createAndAddIndexStructure(session, refIndexName, c.core.refCols, null, null, false, true, isForward);
        HsqlNameManager.HsqlName mainName = session.database.nameManager.newAutoName("REF", c.getName().name, table.getSchemaName(), table.getName(), 20);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = table;
        c.core.refName = c.getName();
        c.core.refIndex = index;
        c.isForward = isForward;
        table.addConstraint(c);
        c.core.mainTable.addConstraint(new Constraint(mainName, c));
        session.database.schemaManager.addSchemaObject(c);
    }

    Constraint readFKReferences(Table refTable, HsqlNameManager.HsqlName constraintName, OrderedHashSet refColSet) {
        HsqlNameManager.HsqlName mainTableName;
        OrderedHashSet mainColSet = null;
        this.readThis(236);
        HsqlNameManager.HsqlName schema = this.token.namePrefix == null ? refTable.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (refTable.getSchemaName() == schema && refTable.getName().name.equals(this.token.tokenString)) {
            mainTableName = refTable.getName();
            this.read();
        } else {
            mainTableName = this.readFKTableName(schema);
        }
        if (this.token.tokenType == 937) {
            mainColSet = this.readColumnNames(false);
        }
        int matchType = 68;
        if (this.token.tokenType == 172) {
            this.read();
            switch (this.token.tokenType) {
                case 554: {
                    this.read();
                    break;
                }
                case 510: {
                    throw this.unsupportedFeature();
                }
                case 125: {
                    this.read();
                    matchType = 70;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int deleteAction = 3;
        int updateAction = 3;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 204) {
            this.read();
            if (!set.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 84) {
                this.read();
                if (this.token.tokenType == 268) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 83: {
                            this.read();
                            deleteAction = 4;
                            continue block13;
                        }
                        case 196: {
                            this.read();
                            deleteAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 369) {
                    this.read();
                    deleteAction = 0;
                    continue;
                }
                if (this.token.tokenType == 526) {
                    this.read();
                    continue;
                }
                this.readThis(190);
                this.readThis(354);
                continue;
            }
            if (this.token.tokenType == 319) {
                this.read();
                if (this.token.tokenType == 268) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 83: {
                            this.read();
                            updateAction = 4;
                            continue block13;
                        }
                        case 196: {
                            this.read();
                            updateAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 369) {
                    this.read();
                    updateAction = 0;
                    continue;
                }
                if (this.token.tokenType == 526) {
                    this.read();
                    continue;
                }
                this.readThis(190);
                this.readThis(354);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (this.readIfThis(193)) {
            this.readThis(404);
        }
        if (constraintName == null) {
            constraintName = this.database.nameManager.newAutoName("FK", refTable.getSchemaName(), refTable.getName(), 5);
        }
        return new Constraint(constraintName, refTable.getName(), refColSet, mainTableName, mainColSet, 0, deleteAction, updateAction, matchType);
    }

    HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName schema) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.token.tokenString, schema.name);
        HsqlNameManager.HsqlName name = table == null ? this.database.nameManager.newHsqlName(schema, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return name;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList constraintList) {
        boolean isGenerated = false;
        boolean isIdentity = false;
        boolean isPKIdentity = false;
        boolean generatedAlways = false;
        Expression generateExpr = null;
        int sysPeriodType = 0;
        boolean isNullable = true;
        Expression defaultExpr = null;
        Expression colConstraint = null;
        Type typeObject = null;
        NumberSequence sequence = null;
        switch (this.token.tokenType) {
            case 434: {
                this.read();
                this.readThis(359);
                isGenerated = true;
                generatedAlways = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 138: {
                this.read();
                isIdentity = true;
                isPKIdentity = true;
                typeObject = Type.SQL_INTEGER;
                sequence = new NumberSequence(null, 0L, 1L, typeObject);
                break;
            }
            case 924: {
                return null;
            }
            case 922: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            isIdentity = true;
                            isPKIdentity = true;
                            typeObject = Type.SQL_BIGINT;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            isIdentity = true;
                            typeObject = Type.SQL_INTEGER;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        isIdentity = true;
                        isPKIdentity = true;
                        typeObject = Type.SQL_BIGINT;
                        sequence = new NumberSequence(null, 1L, 1L, typeObject);
                        break;
                    }
                }
                typeObject = this.readTypeDefinition(true, true);
                if (!this.database.sqlSyntaxMys || !typeObject.isDomainType() || !typeObject.getName().name.equals("ENUM")) break;
                typeObject.userTypeModifier = null;
                HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                Constraint c = new Constraint(constName, null, 3);
                constraintList.add(c);
                this.readThis(937);
                ExpressionColumn left = new ExpressionColumn(hsqlName.name);
                Expression right = super.XreadInValueListConstructor(1);
                this.readThis(922);
                colConstraint = new ExpressionLogical(54, left, right);
                ((ExpressionLogical)colConstraint).setNoOptimisation();
                c.check = colConstraint;
            }
        }
        if (!isGenerated && !isIdentity) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 196: {
                        this.read();
                        break;
                    }
                    case 193: {
                        this.read();
                        this.readThis(196);
                        isNullable = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 337: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 83: {
                    this.read();
                    defaultExpr = this.readDefaultClause(typeObject);
                    if (defaultExpr.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    sequence = ((ExpressionColumn)defaultExpr).sequence;
                    defaultExpr = null;
                    isIdentity = true;
                    break;
                }
                case 434: {
                    this.read();
                    if (this.token.tokenType == 27) {
                        this.read();
                        this.readThis(83);
                    } else {
                        this.readThis(359);
                        generatedAlways = true;
                    }
                    this.readThis(11);
                    switch (this.token.tokenType) {
                        case 138: {
                            this.read();
                            sequence = new NumberSequence(null, typeObject);
                            sequence.setAlways(generatedAlways);
                            if (this.token.tokenType == 937) {
                                this.read();
                                this.readSequenceOptions(sequence, false, false, true);
                                this.readThis(922);
                            }
                            isIdentity = true;
                            break;
                        }
                        case 937: {
                            if (!generatedAlways) {
                                throw this.unexpectedToken(434);
                            }
                            isGenerated = true;
                            this.read();
                            generateExpr = this.XreadValueExpression();
                            this.readThis(922);
                            break;
                        }
                        case 548: {
                            if (generatedAlways) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                                throw this.unexpectedToken(this.token.namePrefix);
                            }
                            sequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                            isIdentity = true;
                            this.read();
                            break;
                        }
                        case 257: {
                            if (!typeObject.isTimestampType()) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            if (this.readIfThis(281)) {
                                sysPeriodType = 1;
                            } else {
                                this.readThis(99);
                                sysPeriodType = 2;
                            }
                            if (typeObject.typeCode != 93) break;
                            typeObject = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                        }
                    }
                    break;
                }
                case 138: {
                    this.read();
                    isIdentity = true;
                    isPKIdentity = true;
                    sequence = new NumberSequence(null, 0L, 1L, typeObject);
                }
            }
        }
        if (!isGenerated && !isIdentity && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            isIdentity = true;
            sequence = new NumberSequence(null, 1L, 1L, typeObject);
        }
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, isNullable, false, defaultExpr);
        if (colConstraint != null) {
            colConstraint.setLeftNode(new ExpressionColumn(column));
        }
        column.setGeneratingExpression(generateExpr);
        column.setSystemPeriodType(sysPeriodType);
        this.readColumnConstraints(table, column, constraintList);
        if (this.token.tokenType == 138 && !isIdentity) {
            this.read();
            isIdentity = true;
            isPKIdentity = true;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        }
        if (this.token.tokenType == 434 && !isIdentity && !isGenerated) {
            this.read();
            if (this.token.tokenType == 27) {
                this.read();
                this.readThis(83);
            } else {
                this.readThis(359);
                generatedAlways = true;
            }
            this.readThis(11);
            this.readThis(138);
            sequence = new NumberSequence(null, typeObject);
            sequence.setAlways(generatedAlways);
            if (this.token.tokenType == 937) {
                this.read();
                this.readSequenceOptions(sequence, false, false, true);
                this.readThis(922);
            }
            isIdentity = true;
        }
        if (isIdentity) {
            column.setIdentity(sequence);
        }
        if (isPKIdentity && !column.isPrimaryKey()) {
            OrderedHashSet<String> set = new OrderedHashSet<String>();
            set.add(column.getName().name);
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint c = new Constraint(constName, set, 4);
            c.setSimpleIdentityPK();
            constraintList.set(0, c);
            column.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 83 && column.getDefaultExpression() == null && column.getIdentitySequence() == null) {
            this.read();
            defaultExpr = this.readDefaultClause(typeObject);
            if (defaultExpr.opType == 12) {
                sequence = ((ExpressionColumn)defaultExpr).sequence;
                defaultExpr = null;
            }
            column.setDefaultExpression(defaultExpr);
            column.setIdentity(sequence);
        }
        return column;
    }

    PeriodDefinition readAndAddPeriod(Table table) {
        PeriodDefinition period = this.readPeriod(table);
        if (period == null) {
            return null;
        }
        if (period.getPeriodType() == 1) {
            table.systemPeriod = period;
        } else {
            table.applicationPeriod = period;
        }
        return period;
    }

    PeriodDefinition readPeriod(Table table) {
        int periodType = 0;
        HsqlNameManager.HsqlName periodName = null;
        int position = this.getPosition();
        this.readThis(220);
        if (this.token.tokenType != 120) {
            this.rewind(position);
            return null;
        }
        this.readThis(120);
        if (this.token.tokenType == 292) {
            periodType = 1;
            periodName = this.database.nameManager.newHsqlName(table.getName().schema, this.token.tokenString, false, 30);
        } else {
            periodType = 2;
            this.checkIsNonReservedIdentifier();
            this.checkIsIrregularCharInIdentifier();
            this.checkIsSimpleName();
            periodName = this.database.nameManager.newHsqlName(table.getName().schema, this.token.tokenString, this.isDelimitedIdentifier(), 30);
        }
        this.read();
        periodName.parent = table.getName();
        OrderedHashSet set = this.readColumnNames(false);
        if (set.size() != 2) {
            throw Error.error(5593);
        }
        PeriodDefinition period = new PeriodDefinition(periodName, periodType, set);
        if (period.getPeriodType() == 1 ? table.systemPeriod != null : table.applicationPeriod != null) {
            throw Error.error(5581);
        }
        return period;
    }

    void readConstraint(SchemaObject schemaObject, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName constName = null;
        if (this.token.tokenType == 51) {
            this.read();
            constName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 228: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(463);
                Constraint mainConst = (Constraint)constraintList.get(0);
                if (mainConst.getConstraintType() == 4 && !mainConst.isSimpleIdentityPK) {
                    throw Error.error(5532);
                }
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = new Constraint(constName, set, 4);
                constraintList.set(0, c);
                break;
            }
            case 315: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                if (this.database.sqlSyntaxMys && !this.readIfThis(644)) {
                    this.readIfThis(463);
                }
                OrderedHashSet set = this.readColumnNames(false);
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, set, 2);
                constraintList.add(c);
                break;
            }
            case 121: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(463);
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = this.readFKReferences((Table)schemaObject, constName, set);
                constraintList.add(c);
                break;
            }
            case 40: {
                this.read();
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, null, 3);
                this.readCheckConstraintCondition(c);
                constraintList.add(c);
                break;
            }
            default: {
                if (constName == null) break;
                throw this.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema column, HsqlArrayList constraintList) {
        boolean end = false;
        boolean hasNotNullConstraint = false;
        boolean hasNullNoiseWord = false;
        boolean hasPrimaryKey = false;
        if (column.getDataType().isTimestampType() && this.token.tokenType == 204) {
            int position = this.getPosition();
            try {
                FunctionSQL function;
                this.read();
                this.readThis(319);
                if (this.readIfThis(72)) {
                    function = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                } else {
                    this.readThis(169);
                    function = FunctionSQL.newSQLFunction("LOCALTIMESTAMP", this.compileContext);
                }
                function.resolveTypes(this.session, null);
                column.setUpdateExpression(function);
            }
            catch (Exception e) {
                this.rewind(position);
            }
        }
        do {
            HsqlNameManager.HsqlName constName = null;
            if (this.token.tokenType == 51) {
                this.read();
                constName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 228: {
                    if (hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(463);
                    Constraint existingConst = (Constraint)constraintList.get(0);
                    if (existingConst.getConstraintType() == 4) {
                        throw Error.error(5532);
                    }
                    OrderedHashSet<String> set = new OrderedHashSet<String>();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 4);
                    constraintList.set(0, c);
                    column.setPrimaryKey(true);
                    hasPrimaryKey = true;
                    break;
                }
                case 315: {
                    this.read();
                    OrderedHashSet<String> set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 2);
                    constraintList.add(c);
                    break;
                }
                case 121: {
                    this.read();
                    this.readThis(463);
                }
                case 236: {
                    OrderedHashSet<String> set = new OrderedHashSet<String>();
                    set.add(column.getName().name);
                    Constraint c = this.readFKReferences(table, constName, set);
                    constraintList.add(c);
                    break;
                }
                case 40: {
                    this.read();
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    this.readCheckConstraintCondition(c);
                    OrderedHashSet<String> set = c.getCheckColumnExpressions();
                    for (int i = 0; i < set.size(); ++i) {
                        ExpressionColumn e = (ExpressionColumn)set.get(i);
                        if (column.getName().name.equals(e.getColumnName())) {
                            if (e.getSchemaName() == null || e.getSchemaName().equals(table.getSchemaName().name)) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    constraintList.add(c);
                    break;
                }
                case 193: {
                    if (hasNotNullConstraint || hasNullNoiseWord) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(196);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    c.check = new ExpressionLogical(column);
                    constraintList.add(c);
                    hasNotNullConstraint = true;
                    break;
                }
                case 196: {
                    if (hasNotNullConstraint || hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    if (constName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    hasNullNoiseWord = true;
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
    }

    void readCheckConstraintCondition(Constraint c) {
        this.readThis(937);
        Expression condition = this.XreadBooleanValueExpression();
        condition.setNoOptimisation();
        this.readThis(922);
        c.check = condition;
    }

    Expression readDefaultClause(Type dataType) {
        Expression e = null;
        boolean minus = false;
        if (this.token.tokenType == 196) {
            this.read();
            return new ExpressionValue(null, dataType);
        }
        if (dataType.isDateTimeType() || dataType.isIntervalType()) {
            switch (this.token.tokenType) {
                case 77: 
                case 150: 
                case 297: 
                case 298: {
                    e = this.readDateTimeIntervalLiteral(this.session);
                    if (e.dataType.typeCode != dataType.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object defaultValue = e.getValue(this.session, dataType);
                    return new ExpressionValue(defaultValue, dataType);
                }
                case 1011: {
                    break;
                }
                default: {
                    e = this.XreadDateTimeValueFunctionOrNull();
                    if (e == null) break;
                    e = this.XreadModifier(e);
                    break;
                }
            }
        } else if (dataType.isNumberType()) {
            if (this.database.sqlSyntaxPgs && this.token.tokenType == 663) {
                return this.readNextvalFunction();
            }
            if (this.database.sqlDoubleNaN && dataType.typeCode == 8) {
                e = this.XreadNumericValueExpression();
            } else if (this.token.tokenType == 935) {
                this.read();
                minus = true;
            }
        } else if (dataType.isCharacterType()) {
            switch (this.token.tokenType) {
                case 64: 
                case 67: 
                case 68: 
                case 70: 
                case 74: 
                case 267: 
                case 293: 
                case 321: {
                    FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    e = this.readSQLFunction(function);
                    break;
                }
            }
        } else if (dataType.isBooleanType()) {
            switch (this.token.tokenType) {
                case 310: {
                    this.read();
                    return new ExpressionBoolean(true);
                }
                case 114: {
                    this.read();
                    return new ExpressionBoolean(false);
                }
            }
        } else if (dataType.isBitType()) {
            switch (this.token.tokenType) {
                case 310: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, dataType);
                }
                case 114: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, dataType);
                }
            }
        } else if (dataType.isArrayType()) {
            e = this.readCollection(19);
            if (e.nodes.length > 0) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            e.dataType = dataType;
            return e;
        }
        if (e != null) {
            e.resolveTypes(this.session, null);
            if (!dataType.canBeAssignedFrom(e.getDataType())) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            return e;
        }
        boolean inParens = false;
        if ((this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && this.token.tokenType == 937) {
            this.read();
            inParens = true;
        }
        if (this.token.tokenType == 1011) {
            Object value = this.token.tokenValue;
            Type valueType = this.token.dataType;
            Type convertType = dataType;
            if (dataType.typeCode == 40) {
                convertType = Type.getType(12, null, this.database.collation, dataType.precision, 0);
            } else if (dataType.typeCode == 30) {
                convertType = Type.getType(61, null, null, dataType.precision, 0);
            }
            if (minus) {
                value = valueType.negate(value);
            }
            value = convertType.convertToType(this.session, value, valueType);
            this.read();
            if (inParens) {
                this.readThis(922);
            }
            return new ExpressionValue(value, convertType);
        }
        if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxPgs) && (e = this.XreadAllTypesCommonValueExpression(false)) != null) {
            QuerySpecification qs;
            TableDerived t;
            if (e.getType() == 22) {
                t = (TableDerived)e.getTable();
                qs = (QuerySpecification)t.getQueryExpression();
                qs.setReturningResult();
            }
            e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, RangeGroup.emptyArray, null, true);
            e.resolveTypes(this.session, null);
            if (e.getType() == 22) {
                t = (TableDerived)e.getTable();
                qs = (QuerySpecification)t.getQueryExpression();
                Table d = qs.getRangeVariables()[0].getTable();
                if (d != this.session.database.schemaManager.dualTable || qs.exprColumns.length != 1) {
                    throw Error.error(5565);
                }
                e = qs.exprColumns[0];
            }
            if (inParens) {
                this.readThis(922);
            }
            return e;
        }
        if (this.database.sqlSyntaxDb2) {
            Object value = null;
            switch (dataType.typeComparisonGroup) {
                case 12: {
                    value = "";
                    break;
                }
                case 61: {
                    value = BinaryData.zeroLengthBinary;
                    break;
                }
                case 2: {
                    value = 0;
                    break;
                }
                case 16: {
                    value = Boolean.FALSE;
                    break;
                }
                case 40: {
                    value = "";
                    return new ExpressionValue(value, Type.SQL_VARCHAR_DEFAULT);
                }
                case 30: {
                    value = BinaryData.zeroLengthBinary;
                    return new ExpressionValue(value, Type.SQL_VARBINARY_DEFAULT);
                }
                case 92: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_TIME", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
                case 91: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_DATE", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
                case 93: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
            }
            value = dataType.convertToDefaultType(this.session, value);
            return new ExpressionValue(value, dataType);
        }
        if (inParens) {
            this.readThis(922);
        }
        throw this.unexpectedToken();
    }

    void readSequenceOptions(NumberSequence sequence, boolean withType, boolean isAlter, boolean allowComma) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block10: do {
            end = false;
            if (set.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 11: {
                    if (withType) {
                        set.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        sequence.setDefaults(sequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 281: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(337);
                    long value = this.readBigint();
                    sequence.setStartValueNoCheck(value);
                    if (!allowComma) continue block10;
                    this.readIfThis(924);
                    break;
                }
                case 525: {
                    if (!isAlter) {
                        end = true;
                        break;
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(337)) {
                        long value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.setStartValueDefault();
                    break;
                }
                case 444: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(27);
                    long value = this.readBigint();
                    sequence.setIncrement(value);
                    break;
                }
                case 190: {
                    this.read();
                    if (set.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 475) {
                        sequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 479) {
                        sequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 76) {
                        sequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 475: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMaxValueNoCheck(value);
                    break;
                }
                case 479: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMinValueNoCheck(value);
                    break;
                }
                case 76: {
                    set.add(this.token.tokenType);
                    this.read();
                    sequence.setCycle(true);
                    break;
                }
                default: {
                    if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxDb2) && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
    }

    private void readIndex(Table table, HsqlArrayList indexList) {
        this.read();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        indexHsqlName.schema = table.getSchemaName();
        indexHsqlName.parent = table.getName();
        indexHsqlName.schema = table.getSchemaName();
        if (this.readIfThis(322) && ("BTREE".equals(this.token.tokenString) || "HASH".equals(this.token.tokenString))) {
            this.read();
        }
        this.readThis(204);
        int[] indexColumns = this.readColumnList(table, true);
        Constraint c = new Constraint(indexHsqlName, table, indexColumns, 20);
        indexList.add(c);
    }

    Boolean readIfNotExists() {
        Boolean ifNot = Boolean.FALSE;
        if (this.token.tokenType == 439) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                this.readThis(109);
                ifNot = Boolean.TRUE;
            } else {
                this.rewind(position);
                ifNot = Boolean.FALSE;
            }
        }
        return ifNot;
    }

    StatementSchema compileAlterTableAddPeriod(Table table) {
        PeriodDefinition period = this.readPeriod(table);
        if (period.getPeriodType() != 1) {
            this.setPeriodColumns(table, period);
            throw Error.error(1551);
        }
        this.checkPeriodColumnsAdd(table, period);
        this.readThis(356);
        this.readIfThis(46);
        String nameString = (String)period.columnNames.get(0);
        if (!this.token.tokenString.equals(nameString)) {
            throw this.unexpectedToken();
        }
        HsqlArrayList list = new HsqlArrayList();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnStart = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (columnStart == null) {
            throw Error.error(5000);
        }
        if (columnStart.getSystemPeriodType() != 1) {
            throw Error.error(5516, columnStart.getNameString());
        }
        this.readThis(356);
        this.readIfThis(46);
        this.checkIsSimpleName();
        nameString = (String)period.columnNames.get(1);
        if (!this.token.tokenString.equals(nameString)) {
            throw this.unexpectedToken();
        }
        hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnEnd = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (columnEnd == null) {
            throw Error.error(5000);
        }
        if (columnEnd.getSystemPeriodType() != 2) {
            throw Error.error(5516, columnEnd.getNameString());
        }
        period.startColumn = columnStart;
        period.endColumn = columnEnd;
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, period};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 115, args, null, writeLockNames);
    }

    StatementSchema compileAlterTableDropPeriod(Table table) {
        if (!this.readIfThis(292)) {
            throw Error.error(1551);
        }
        PeriodDefinition period = table.systemPeriod;
        if (period == null) {
            throw Error.error(5517);
        }
        if (table.isSystemVersioned) {
            throw Error.error(5518);
        }
        Boolean cascade = this.readIfThis(369);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, period, cascade};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 116, args, null, writeLockNames);
    }

    StatementSchema compileAlterTableAddVersioning(Table table) {
        PeriodDefinition period = table.systemPeriod;
        if (period == null) {
            throw Error.error(5518);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 117, args, null, writeLockNames);
    }

    StatementSchema compileAlterTableDropVersioning(Table table) {
        if (!table.isSystemVersioned) {
            throw Error.error(5518);
        }
        Boolean cascade = this.readIfThis(369);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, cascade};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(sql, 118, args, null, writeLockNames);
    }
}

