/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QueryExpression
implements RangeGroup {
    public static final int NOUNION = 0;
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT_ALL = 5;
    public static final int EXCEPT = 6;
    public static final int UNION_TERM = 7;
    int columnCount;
    QueryExpression leftQueryExpression;
    QueryExpression rightQueryExpression;
    public SortAndSlice sortAndSlice;
    private int unionType;
    private boolean unionCorresponding;
    private OrderedHashSet unionCorrespondingColumns;
    int[] unionColumnMap;
    Type[] unionColumnTypes;
    boolean isFullOrder;
    List unresolvedExpressions;
    boolean isReferencesResolved;
    boolean isPartOneResolved;
    boolean isPartTwoResolved;
    boolean isResolved;
    int persistenceScope = 21;
    ResultMetaData resultMetaData;
    boolean[] accessibleColumns;
    View view;
    boolean isBaseMergeable;
    boolean isMergeable;
    boolean isUpdatable;
    boolean isInsertable;
    boolean isCheckable;
    boolean isTopLevel;
    boolean isRecursive;
    boolean isSingleRow;
    boolean acceptsSequences;
    boolean isCorrelated;
    boolean isTable;
    boolean isValueList;
    boolean lowerCaseResultIdentifier;
    public TableBase resultTable;
    public Index mainIndex;
    public Index fullIndex;
    public Index orderIndex;
    public Index idIndex;
    TableDerived recursiveWorkTable;
    TableDerived recursiveResultTable;
    RecursiveQuerySettings recursiveSettings;
    TableDerived[] materialiseList = TableDerived.emptyArray;
    ParserDQL.CompileContext compileContext;

    QueryExpression(ParserDQL.CompileContext compileContext) {
        this.compileContext = compileContext;
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QueryExpression(ParserDQL.CompileContext compileContext, QueryExpression leftQueryExpression) {
        this(compileContext);
        this.sortAndSlice = SortAndSlice.noSort;
        this.leftQueryExpression = leftQueryExpression;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return RangeVariable.emptyArray;
    }

    @Override
    public void setCorrelated() {
        this.isCorrelated = true;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    public void setSingleRow() {
        this.isSingleRow = true;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    void addUnion(QueryExpression queryExpression, int unionType) {
        this.sortAndSlice = SortAndSlice.noSort;
        this.rightQueryExpression = queryExpression;
        this.unionType = unionType;
        this.setFullOrder();
    }

    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
        sortAndSlice.sortUnion = true;
    }

    public void setUnionCorresoponding() {
        this.unionCorresponding = true;
    }

    public void setUnionCorrespondingColumns(OrderedHashSet names) {
        this.unionCorrespondingColumns = names;
    }

    public void setFullOrder() {
        this.isFullOrder = true;
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setFullOrder();
        }
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.setFullOrder();
        }
    }

    public void resolve(Session session) {
        this.resolveReferences(session, RangeGroup.emptyArray);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypes(session);
    }

    public void resolve(Session session, RangeGroup[] rangeGroups, Type[] targetTypes) {
        this.resolveReferences(session, rangeGroups);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypesPartOne(session);
        if (targetTypes != null) {
            for (int i = 0; i < this.unionColumnTypes.length && i < targetTypes.length; ++i) {
                if (this.unionColumnTypes[i] != null) continue;
                this.unionColumnTypes[i] = targetTypes[i];
            }
        }
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
    }

    public void resolveReferences(Session session, RangeGroup[] rangeGroups) {
        if (this.isReferencesResolved) {
            return;
        }
        this.leftQueryExpression.resolveReferences(session, rangeGroups);
        this.rightQueryExpression.resolveReferences(session, rangeGroups);
        this.addUnresolvedExpressions(this.leftQueryExpression.unresolvedExpressions);
        this.addUnresolvedExpressions(this.rightQueryExpression.unresolvedExpressions);
        if (this.leftQueryExpression.isCorrelated || this.rightQueryExpression.isCorrelated) {
            this.setCorrelated();
        }
        if (!this.unionCorresponding) {
            this.columnCount = this.leftQueryExpression.getColumnCount();
            int rightCount = this.rightQueryExpression.getColumnCount();
            if (this.columnCount != rightCount) {
                throw Error.error(5594);
            }
            this.unionColumnTypes = new Type[this.columnCount];
            this.leftQueryExpression.unionColumnMap = this.rightQueryExpression.unionColumnMap = new int[this.columnCount];
            ArrayUtil.fillSequence(this.leftQueryExpression.unionColumnMap);
            this.resolveColumnReferencesInUnionOrderBy();
            this.accessibleColumns = this.leftQueryExpression.accessibleColumns;
            this.isReferencesResolved = true;
            return;
        }
        Object[] leftNames = this.leftQueryExpression.getColumnNames();
        Object[] rightNames = this.rightQueryExpression.getColumnNames();
        if (this.unionCorrespondingColumns == null) {
            this.unionCorrespondingColumns = new OrderedHashSet();
            OrderedIntHashSet leftColumns = new OrderedIntHashSet();
            OrderedIntHashSet rightColumns = new OrderedIntHashSet();
            for (int i = 0; i < leftNames.length; ++i) {
                String name = leftNames[i];
                int index = ArrayUtil.find(rightNames, name);
                if (name.length() <= 0 || index == -1) continue;
                if (!this.leftQueryExpression.accessibleColumns[i]) {
                    throw Error.error(5578);
                }
                if (!this.rightQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                leftColumns.add(i);
                rightColumns.add(index);
                this.unionCorrespondingColumns.add(name);
            }
            if (this.unionCorrespondingColumns.isEmpty()) {
                throw Error.error(5578);
            }
            this.leftQueryExpression.unionColumnMap = leftColumns.toArray();
            this.rightQueryExpression.unionColumnMap = rightColumns.toArray();
        } else {
            this.leftQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            this.rightQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            for (int i = 0; i < this.unionCorrespondingColumns.size(); ++i) {
                String name = (String)this.unionCorrespondingColumns.get(i);
                int index = ArrayUtil.find(leftNames, name);
                if (index == -1) {
                    throw Error.error(5501);
                }
                if (!this.leftQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                this.leftQueryExpression.unionColumnMap[i] = index;
                index = ArrayUtil.find(rightNames, name);
                if (index == -1) {
                    throw Error.error(5501);
                }
                if (!this.rightQueryExpression.accessibleColumns[index]) {
                    throw Error.error(5578);
                }
                this.rightQueryExpression.unionColumnMap[i] = index;
            }
        }
        this.columnCount = this.unionCorrespondingColumns.size();
        this.unionColumnTypes = new Type[this.columnCount];
        this.resolveColumnReferencesInUnionOrderBy();
        this.accessibleColumns = new boolean[this.columnCount];
        ArrayUtil.fillArray(this.accessibleColumns, true);
        this.isReferencesResolved = true;
    }

    void resolveColumnReferencesInUnionOrderBy() {
        int orderCount = this.sortAndSlice.getOrderLength();
        if (orderCount == 0) {
            return;
        }
        Object[] unionColumnNames = this.getColumnNames();
        for (int i = 0; i < orderCount; ++i) {
            int index;
            Expression sort = (Expression)this.sortAndSlice.exprList.get(i);
            Expression e = sort.getLeftNode();
            if (e.getType() == 1) {
                if (e.getDataType().typeCode == 4 && 0 < (index = ((Integer)e.getValue(null)).intValue()) && index <= unionColumnNames.length) {
                    sort.getLeftNode().resultTableColumnIndex = index - 1;
                    continue;
                }
            } else if (e.getType() == 2 && (index = ArrayUtil.find(unionColumnNames, e.getColumnName())) >= 0) {
                sort.getLeftNode().resultTableColumnIndex = index;
                continue;
            }
            throw Error.error(5576);
        }
        this.sortAndSlice.prepare(0);
    }

    private void addUnresolvedExpressions(List expressions) {
        if (expressions == null) {
            return;
        }
        if (this.unresolvedExpressions == null) {
            this.unresolvedExpressions = new ArrayListIdentity();
        }
        this.unresolvedExpressions.addAll(expressions);
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
    }

    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.isPartOneResolved = true;
    }

    void resolveTypesPartTwoRecursive(Session session) {
        this.resolveTypesPartTwo(session);
    }

    void resolveTypesPartTwo(Session session) {
        if (this.isPartTwoResolved) {
            return;
        }
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        if (this.isRecursive) {
            this.leftQueryExpression.resolveTypesPartTwoRecursive(session);
            this.recursiveWorkTable.colTypes = this.leftQueryExpression.getColumnTypes();
            for (int i = 0; i < this.recursiveWorkTable.colTypes.length; ++i) {
                this.recursiveWorkTable.getColumn(i).setType(this.recursiveWorkTable.colTypes[i]);
            }
            this.recursiveWorkTable.getFullIndex(session);
        } else {
            this.leftQueryExpression.resolveTypesPartTwo(session);
        }
        this.leftQueryExpression.resolveTypesPartThree(session);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartTwo(session);
        this.rightQueryExpression.resolveTypesPartThree(session);
        ResultMetaData leftMeta = this.leftQueryExpression.getMetaData();
        ResultMetaData rightMeta = this.rightQueryExpression.getMetaData();
        for (int i = 0; i < this.leftQueryExpression.unionColumnMap.length; ++i) {
            int leftIndex = this.leftQueryExpression.unionColumnMap[i];
            int rightIndex = this.rightQueryExpression.unionColumnMap[i];
            ColumnBase column = leftMeta.columns[leftIndex];
            byte leftNullability = leftMeta.columns[leftIndex].getNullability();
            byte rightNullability = rightMeta.columns[rightIndex].getNullability();
            if (rightNullability != 1 && (rightNullability != 2 || leftNullability != 0)) continue;
            if (column instanceof ColumnSchema) {
                column = new ColumnBase();
                column.setType(this.leftQueryExpression.unionColumnTypes[i]);
                leftMeta.columns[leftIndex] = column;
            }
            column.setNullability(rightNullability);
        }
        if (this.unionCorresponding || this.isRecursive) {
            this.resultMetaData = this.leftQueryExpression.getMetaData().getNewMetaData(this.leftQueryExpression.unionColumnMap);
            this.createTable(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            QueryExpression queryExpression = this;
            while (true) {
                if (queryExpression.leftQueryExpression == null || queryExpression.unionCorresponding) {
                    this.sortAndSlice.setIndex(session, queryExpression.resultTable);
                    break;
                }
                queryExpression = queryExpression.leftQueryExpression;
            }
        }
        this.isPartTwoResolved = true;
    }

    void resolveTypesPartThree(Session session) {
        this.compileContext = null;
        this.isResolved = true;
    }

    public Object[] getValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return new Object[r.metaData.getColumnCount()];
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public void addExtraConditions(Expression e) {
    }

    public Object[] getSingleRowValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object getValue(Session session) {
        Object[] values = this.getValues(session);
        return values[0];
    }

    Result getResult(Session session, int maxRows) {
        if (this.isRecursive) {
            return this.getResultRecursive(session);
        }
        int currentMaxRows = this.unionType == 2 ? maxRows : 0;
        Result first = this.leftQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData navigator = (RowSetNavigatorData)first.getNavigator();
        Result second = this.rightQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData rightNavigator = (RowSetNavigatorData)second.getNavigator();
        if (this.unionCorresponding) {
            boolean memory = session.resultMaxMemoryRows == 0 || navigator.getSize() < session.resultMaxMemoryRows && rightNavigator.getSize() < session.resultMaxMemoryRows;
            RowSetNavigatorData rowSet = memory ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSet.copy(navigator, this.leftQueryExpression.unionColumnMap);
            navigator.release();
            navigator = rowSet;
            first.setNavigator(navigator);
            first.metaData = this.getMetaData();
            rowSet = memory ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSet.copy(rightNavigator, this.rightQueryExpression.unionColumnMap);
            rightNavigator.release();
            rightNavigator = rowSet;
        }
        switch (this.unionType) {
            case 1: {
                navigator.union(rightNavigator);
                break;
            }
            case 2: {
                navigator.unionAll(rightNavigator);
                break;
            }
            case 3: {
                navigator.intersect(rightNavigator);
                break;
            }
            case 4: {
                navigator.intersectAll(rightNavigator);
                break;
            }
            case 6: {
                navigator.except(rightNavigator);
                break;
            }
            case 5: {
                navigator.exceptAll(rightNavigator);
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        rightNavigator.release();
        if (this.sortAndSlice.hasOrder()) {
            navigator.sortOrderUnion(this.sortAndSlice);
        }
        if (this.sortAndSlice.hasLimit()) {
            int[] limits = this.sortAndSlice.getLimits(session, this, maxRows);
            navigator.trim(limits[0], limits[1]);
        }
        navigator.reset();
        return first;
    }

    public void setRecursiveQuerySettings(RecursiveQuerySettings settings) {
        OrderedHashSet subqueryList = this.rightQueryExpression.getSubqueries();
        if (subqueryList == null) {
            subqueryList = new OrderedHashSet();
        }
        block0: for (int i = 0; i < subqueryList.size(); ++i) {
            QueryExpression qe;
            TableDerived td = (TableDerived)subqueryList.get(i);
            if (td.isCorrelated() || (qe = td.queryExpression) == null) continue;
            OrderedHashSet refList = new OrderedHashSet();
            qe.collectObjectNames(refList);
            for (int j = 0; j < refList.size(); ++j) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)refList.get(j);
                if (name != this.recursiveWorkTable.tableName && name != this.recursiveResultTable.tableName) continue;
                this.materialiseList = ArrayUtil.toAdjustedArray(this.materialiseList, td);
                continue block0;
            }
        }
        this.recursiveSettings = settings;
    }

    Result getResultRecursive(Session session) {
        RowSetNavigatorData resultNav = new RowSetNavigatorData(session, this);
        Result leftResult = this.leftQueryExpression.getResult(session, 0);
        PersistentStore recursiveStore = this.recursiveWorkTable.getRowStore(session);
        PersistentStore recursiveResultStore = this.recursiveResultTable.getRowStore(session);
        leftResult.getNavigator().reset();
        this.recursiveWorkTable.insertSys(session, recursiveStore, leftResult);
        leftResult.getNavigator().reset();
        this.recursiveResultTable.insertSys(session, recursiveResultStore, leftResult);
        resultNav.unionAll((RowSetNavigatorData)leftResult.getNavigator());
        int round = 0;
        while (true) {
            for (int i = 0; i < this.materialiseList.length; ++i) {
                this.materialiseList[i].materialise(session);
            }
            Result currentResult = this.rightQueryExpression.getResult(session, 0);
            RowSetNavigatorData currentNavigator = (RowSetNavigatorData)currentResult.getNavigator();
            if (currentNavigator.isEmpty()) break;
            int startSize = resultNav.getSize();
            switch (this.unionType) {
                case 1: {
                    resultNav.union(currentNavigator);
                    break;
                }
                case 2: {
                    resultNav.unionAll(currentNavigator);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "QueryExpression");
                }
            }
            if (startSize == resultNav.getSize()) break;
            if (round > session.database.sqlMaxRecursive) {
                throw Error.error(3474);
            }
            currentNavigator.reset();
            this.recursiveResultTable.insertSys(session, recursiveResultStore, currentResult);
            recursiveStore.removeAll();
            currentNavigator.reset();
            this.recursiveWorkTable.insertSys(session, recursiveStore, currentResult);
            ++round;
        }
        Result result = Result.newResult(resultNav);
        result.metaData = this.resultMetaData;
        return result;
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet subqueries = this.leftQueryExpression.getSubqueries();
        subqueries = OrderedHashSet.addAll(subqueries, this.rightQueryExpression.getSubqueries());
        return subqueries;
    }

    public boolean isSingleColumn() {
        return this.leftQueryExpression.isSingleColumn();
    }

    public ResultMetaData getMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        return this.leftQueryExpression.getMetaData();
    }

    public QuerySpecification getMainSelect() {
        if (this.leftQueryExpression == null) {
            return (QuerySpecification)this;
        }
        return this.leftQueryExpression.getMainSelect();
    }

    public String describe(Session session, int blanks) {
        String temp;
        StringBuilder b = new StringBuilder(blanks);
        for (int i = 0; i < blanks; ++i) {
            b.append(' ');
        }
        StringBuilder sb = new StringBuilder();
        switch (this.unionType) {
            case 1: {
                temp = "UNION";
                break;
            }
            case 2: {
                temp = "UNION ALL";
                break;
            }
            case 3: {
                temp = "INTERSECT";
                break;
            }
            case 4: {
                temp = "INTERSECT ALL";
                break;
            }
            case 6: {
                temp = "EXCEPT";
                break;
            }
            case 5: {
                temp = "EXCEPT ALL";
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        sb.append((CharSequence)b).append(temp).append("\n");
        sb.append((CharSequence)b).append("Left Query=[\n");
        sb.append((CharSequence)b).append(this.leftQueryExpression.describe(session, blanks + 2));
        sb.append((CharSequence)b).append("]\n");
        sb.append((CharSequence)b).append("Right Query=[\n");
        sb.append((CharSequence)b).append(this.rightQueryExpression.describe(session, blanks + 2));
        sb.append((CharSequence)b).append("]\n");
        return sb.toString();
    }

    public List getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    public boolean areColumnsResolved() {
        if (this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            Expression e = (Expression)this.unresolvedExpressions.get(i);
            if (e.getRangeVariable() == null) {
                return false;
            }
            if (e.getRangeVariable().rangeType != 1) continue;
            return false;
        }
        return true;
    }

    String[] getColumnNames() {
        if (this.unionCorrespondingColumns == null) {
            return this.leftQueryExpression.getColumnNames();
        }
        String[] names = new String[this.unionCorrespondingColumns.size()];
        this.unionCorrespondingColumns.toArray(names);
        return names;
    }

    public Type[] getColumnTypes() {
        return this.unionColumnTypes;
    }

    public int getColumnCount() {
        if (this.unionCorrespondingColumns == null) {
            int right;
            int left = this.leftQueryExpression.getColumnCount();
            if (left != (right = this.rightQueryExpression.getColumnCount())) {
                throw Error.error(5594);
            }
            return left;
        }
        return this.unionCorrespondingColumns.size();
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        set = this.leftQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        if (this.rightQueryExpression != null) {
            set = this.rightQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVars, OrderedHashSet set) {
        set = this.leftQueryExpression.collectRangeVariables(rangeVars, set);
        if (this.rightQueryExpression != null) {
            set = this.rightQueryExpression.collectRangeVariables(rangeVars, set);
        }
        return set;
    }

    OrderedHashSet collectRangeVariables(OrderedHashSet set) {
        set = this.leftQueryExpression.collectRangeVariables(set);
        if (this.rightQueryExpression != null) {
            set = this.rightQueryExpression.collectRangeVariables(set);
        }
        return set;
    }

    public void collectObjectNames(Set set) {
        this.leftQueryExpression.collectObjectNames(set);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectObjectNames(set);
        }
    }

    public OrderedHashMap getColumns() {
        TableDerived table = (TableDerived)this.getResultTable();
        return table.columnList;
    }

    public void setView(View view) {
        this.view = view;
        this.isUpdatable = true;
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    public void setTableColumnNames(OrderedHashMap list) {
        if (this.resultTable != null) {
            ((TableDerived)this.resultTable).columnList = list;
            return;
        }
        this.leftQueryExpression.setTableColumnNames(list);
    }

    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        int[] fullCols = new int[this.columnCount];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, fullCols, null, null, false, false, false);
    }

    void createResultTable(Session session) {
        HsqlNameManager.HsqlName tableName = session.database.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 21 ? 2 : 9;
        OrderedHashMap columnList = this.leftQueryExpression.getUnionColumns();
        this.resultTable = new TableDerived(session.database, tableName, tableType, this.unionColumnTypes, columnList, ValuePool.emptyIntArray);
    }

    public void setColumnsDefined() {
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setColumnsDefined();
        }
    }

    public void setReturningResult() {
        if (this.compileContext.getSequences().length > 0) {
            throw Error.error(5598);
        }
        this.isTopLevel = true;
        this.setReturningResultSet();
    }

    void setReturningResultSet() {
        if (this.unionCorresponding) {
            this.persistenceScope = 23;
            return;
        }
        this.leftQueryExpression.setReturningResultSet();
    }

    private OrderedHashMap getUnionColumns() {
        if (this.unionCorresponding || this.leftQueryExpression == null) {
            OrderedHashMap columns = ((TableDerived)this.resultTable).columnList;
            OrderedHashMap<String, ColumnSchema> list = new OrderedHashMap<String, ColumnSchema>();
            for (int i = 0; i < this.unionColumnMap.length; ++i) {
                ColumnSchema column = (ColumnSchema)columns.get(this.unionColumnMap[i]);
                String name = (String)columns.getKeyAt(this.unionColumnMap[i]);
                list.add(name, column);
            }
            return list;
        }
        return this.leftQueryExpression.getUnionColumns();
    }

    public HsqlNameManager.HsqlName[] getResultColumnNames() {
        if (this.resultTable == null) {
            return this.leftQueryExpression.getResultColumnNames();
        }
        OrderedHashMap list = ((TableDerived)this.resultTable).columnList;
        HsqlNameManager.HsqlName[] resultColumnNames = new HsqlNameManager.HsqlName[list.size()];
        for (int i = 0; i < resultColumnNames.length; ++i) {
            resultColumnNames[i] = ((ColumnSchema)list.get(i)).getName();
        }
        return resultColumnNames;
    }

    public TableBase getResultTable() {
        if (this.resultTable != null) {
            return this.resultTable;
        }
        if (this.leftQueryExpression != null) {
            return this.leftQueryExpression.getResultTable();
        }
        return null;
    }

    public Table getBaseTable() {
        return null;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public int[] getBaseTableColumnMap() {
        return null;
    }

    public Expression getCheckCondition() {
        return null;
    }

    public boolean hasReference(RangeVariable range) {
        if (this.leftQueryExpression.hasReference(range)) {
            return true;
        }
        return this.rightQueryExpression.hasReference(range);
    }

    void getBaseTableNames(OrderedHashSet set) {
        this.leftQueryExpression.getBaseTableNames(set);
        this.rightQueryExpression.getBaseTableNames(set);
    }

    boolean isEquivalent(QueryExpression other) {
        return this.leftQueryExpression.isEquivalent(other.leftQueryExpression) && this.unionType == other.unionType && (this.rightQueryExpression == null ? other.rightQueryExpression == null : this.rightQueryExpression.isEquivalent(other.rightQueryExpression));
    }

    public void replaceColumnReferences(Session session, RangeVariable range, Expression[] list) {
        this.leftQueryExpression.replaceColumnReferences(session, range, list);
        this.rightQueryExpression.replaceColumnReferences(session, range, list);
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        this.leftQueryExpression.replaceRangeVariables(ranges, newRanges);
        this.rightQueryExpression.replaceRangeVariables(ranges, newRanges);
    }

    public void replaceExpressions(OrderedHashSet expressions, int resultRangePosition) {
        this.leftQueryExpression.replaceExpressions(expressions, resultRangePosition);
        this.rightQueryExpression.replaceExpressions(expressions, resultRangePosition);
    }

    public void setAsExists() {
    }

    public void setLowerCaseResultIdentifer() {
        this.lowerCaseResultIdentifier = true;
    }

    static class RecursiveQuerySettings {
        static final int none = 0;
        static final int depthFirst = 1;
        static final int breadthFirst = 2;
        static final int findCycle = 1;
        int searchOrderType;
        SortAndSlice searchOrderSort;
        ColumnSchema searchOrderSetColumn;
        int cycle;
        int[] cycleColumnList;
        ColumnSchema cycleColumnFirst;
        ColumnSchema cycleMarkColumn;
        String cycleMarkValue;
        String noCycleMarkValue;
        ColumnSchema cyclePathColumn;

        RecursiveQuerySettings() {
        }
    }
}

