/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.GroupSet;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    public int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    public boolean isGroupingSets;
    boolean isDistinctGroups;
    public boolean isOrderSensitive;
    public boolean isSimpleDistinct;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    int startInnerRange = -1;
    int endInnerRange = -1;
    Expression queryCondition;
    Expression checkQueryCondition;
    Expression[] exprColumns;
    HsqlArrayList exprColumnList;
    GroupSet groupSet;
    private int groupByColumnCount;
    private int havingColumnCount;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean isSingleMemoryTable;
    public boolean isUniqueResultRows;
    Type[] resultColumnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    public Index groupIndex;
    private RangeGroup[] outerRanges;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean isValueList) {
        this(compileContext);
        this.isValueList = isValueList;
        RangeVariable range = new RangeVariable(table, null, null, null, compileContext);
        range.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(session, range);
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
        this.isTable = true;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.resultRangePosition = compileContext.getNextResultRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
    }

    void addRangeVariable(Session session, RangeVariable rangeVar) {
        this.rangeVariableList.add(rangeVar);
    }

    public TableDerived getValueListTable() {
        if (this.isValueList) {
            RangeVariable range = null;
            if (this.rangeVariables == null) {
                if (this.rangeVariableList.size() == 1) {
                    range = (RangeVariable)this.rangeVariableList.get(0);
                }
            } else if (this.rangeVariables.length == 1) {
                range = this.rangeVariables[0];
            }
            if (range != null) {
                return (TableDerived)range.getTable();
            }
        }
        return null;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    public int getCurrentRangeVariableCount() {
        return this.rangeVariableList.size();
    }

    private void resolveRangeVariables(Session session, RangeGroup[] rangeGroups) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeGroup rangeGroup;
            if (this.rangeVariables[i].isLateral) {
                RangeVariable[] rangeVars = (RangeVariable[])ArrayUtil.resizeArray(this.rangeVariables, i);
                rangeGroup = new RangeGroup.RangeGroupSimple(rangeVars, this);
            } else {
                rangeGroup = rangeGroups == RangeGroup.emptyArray ? RangeGroup.emptyGroup : new RangeGroup.RangeGroupSimple(RangeVariable.emptyArray, this);
            }
            this.rangeVariables[i].resolveRangeTable(session, rangeGroup, rangeGroups);
        }
    }

    void addSelectColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (e.opType == 99 && ((ExpressionColumn)e).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression first = (Expression)this.exprColumnList.get(0);
            if (first.opType == 99 && ((ExpressionColumn)first).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(e);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression e) {
        this.queryCondition = e;
    }

    void setDistinctSelect() {
        this.isDistinctSelect = true;
    }

    void setDistinctGroups() {
        this.isDistinctGroups = true;
    }

    void addGroupingSets(Expression[] groupingExpressions) {
        this.groupSet = new GroupSet(groupingExpressions, this.isDistinctGroups);
    }

    void resolveColumnReferencesInGroupingSets(Session session, RangeGroup[] rangeGroups) {
        Expression e;
        if (this.groupSet == null) {
            return;
        }
        Expression[] groupExpressions = this.groupSet.groupExpressions;
        for (int i = 0; i < groupExpressions.length; ++i) {
            e = groupExpressions[i];
            this.tempSet.clear();
            e.resolveColumnReferences(session, this, this.rangeVariables.length, rangeGroups, this.tempSet, false);
            if (this.tempSet.isEmpty()) continue;
            if (session.database.sqlEnforceRefs) {
                ExpressionColumn.checkColumnsResolved(this.tempSet);
                continue;
            }
            Expression[] exprArray = new Expression[this.exprColumnList.size()];
            this.exprColumnList.toArray(exprArray);
            Expression resolved = e.replaceAliasInOrderBy(session, exprArray, this.indexLimitVisible);
            if (resolved != e) {
                groupExpressions[i] = resolved;
            }
            this.tempSet.clear();
            resolved.resolveColumnReferences(session, this, this.rangeVariables.length, RangeGroup.emptyArray, this.tempSet, false);
            ExpressionColumn.checkColumnsResolved(this.tempSet);
        }
        this.tempSet.clear();
        this.addGroupingExpressions(groupExpressions, this.tempSet);
        Iterator it = this.tempSet.iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            if (e.getType() == 25) {
                throw Error.error(5564);
            }
            e.resultTableColumnIndex = this.indexLimitVisible + this.groupByColumnCount;
            this.exprColumnList.add(e.resultTableColumnIndex, e);
            ++this.groupByColumnCount;
        }
        this.groupSet.process();
    }

    void addGroupingExpressions(Expression[] nodes, OrderedHashSet set) {
        for (int i = 0; i < nodes.length; ++i) {
            Expression e = nodes[i];
            if (e.groupingType != 0) {
                this.isGroupingSets = true;
            }
            if (e.opType == 25 || e.opType == 26) {
                for (int j = 0; j < e.nodes.length; ++j) {
                    this.addGroupingExpressions(e.nodes, set);
                }
                continue;
            }
            if (e.opType == 0) continue;
            nodes[i] = set.getOrAdd(e);
            this.isGrouped = true;
        }
    }

    void addHavingExpression(Expression e) {
        this.exprColumnList.add(e);
        this.havingColumnCount = 1;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session, RangeGroup[] rangeGroups) {
        if (this.isReferencesResolved) {
            return;
        }
        this.outerRanges = rangeGroups;
        this.resolveRangeVariables(session, rangeGroups);
        this.resolveColumnReferencesForAsterisk();
        this.resolveColumnReferencesInGroupingSets(session, rangeGroups);
        this.setColumnIndexes();
        this.finaliseColumns();
        this.resolveColumnReferences(session, rangeGroups);
        this.setReferenceableColumns();
        this.unresolvedExpressions = Expression.resolveColumnSet(session, RangeVariable.emptyArray, rangeGroups, this.unresolvedExpressions);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.isReferencesResolved = true;
    }

    @Override
    public boolean hasReference(RangeVariable range) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areColumnsResolved() {
        return super.areColumnsResolved();
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
    }

    @Override
    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        this.resolveExpressionTypes(session);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
        this.isPartOneResolved = true;
    }

    @Override
    void resolveTypesPartTwoRecursive(Session session) {
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            this.exprColumns[i].setDataType(session, type);
        }
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int i;
        if (this.isPartTwoResolved) {
            return;
        }
        this.resolveGroups();
        this.resolveGroupingSets();
        for (i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            if (type == null) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[i] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[i].setDataType(session, type);
            if (!this.exprColumns[i].dataType.isArrayType() || this.exprColumns[i].dataType.collectionBaseType() != null) continue;
            throw Error.error(5567);
        }
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability(session);
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
        this.mergeQuery(session);
        this.isPartTwoResolved = true;
    }

    @Override
    void resolveTypesPartThree(Session session) {
        if (this.isResolved) {
            return;
        }
        this.sortAndSlice.setSortIndex(this);
        this.setRangeVariableConditions(session);
        this.setDistinctConditions(session);
        this.setAggregateConditions(session);
        this.sortAndSlice.setSortRange(this);
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTableTypes(session, this.rangeVariables);
        }
        this.setResultNullability();
        this.rangeVariableList = null;
        this.tempSet = null;
        this.compileContext = null;
        this.outerRanges = null;
        this.isResolved = true;
    }

    @Override
    public void addExtraConditions(Expression e) {
        if (this.isAggregated || this.isGrouped) {
            return;
        }
        this.queryCondition = ExpressionLogical.andExpressions(this.queryCondition, e);
    }

    private void resolveColumnReferences(Session session, RangeGroup[] rangeGroups) {
        int i;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Expression e = this.rangeVariables[i].getJoinCondition();
            if (e == null) continue;
            this.resolveColumnReferencesAndAllocate(session, e, i + 1, rangeGroups, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, rangeGroups, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, rangeGroups, this.acceptsSequences);
            if (this.isGrouped || this.isDistinctSelect) continue;
            OrderedHashSet list = this.exprColumns[i].collectAllSubqueries(null);
            if (list != null) {
                this.isMergeable = false;
            }
            if ((list = this.exprColumns[i].collectAllExpressions(null, OpTypes.sequenceExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) continue;
            this.isOrderSensitive = true;
            this.isMergeable = false;
            this.isBaseMergeable = false;
        }
        for (i = this.indexStartHaving; i < this.indexStartOrderBy; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, rangeGroups, false);
        }
        this.resolveColumnReferencesInOrderBy(session, rangeGroups, this.sortAndSlice);
    }

    void resolveColumnReferencesInOrderBy(Session session, RangeGroup[] rangeGroups, SortAndSlice sortAndSlice) {
        int orderCount = sortAndSlice.getOrderLength();
        for (int i = 0; i < orderCount; ++i) {
            boolean check;
            ExpressionOrderBy e = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(e);
            if (e.getLeftNode().resultTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && e.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            e.replaceAliasInOrderBy(session, this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, e, this.rangeVariables.length, RangeGroup.emptyArray, false);
            if (!this.isAggregated && !this.isGrouped || (check = e.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            this.unresolvedExpressions = sortAndSlice.limitCondition.resolveColumnReferences(session, this, rangeGroups, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this.indexStartOrderBy);
    }

    private boolean resolveColumnReferences(Session session, Expression e, int rangeCount, boolean withSequences) {
        if (e == null) {
            return true;
        }
        int oldSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = e.resolveColumnReferences(session, this, rangeCount, RangeGroup.emptyArray, this.unresolvedExpressions, withSequences);
        int newSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return oldSize == newSize;
    }

    private void resolveColumnReferencesForAsterisk() {
        int pos = 0;
        while (pos < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(pos);
            if (e.getType() == 99) {
                this.exprColumnList.remove(pos);
                String tablename = ((ExpressionColumn)e).getTableName();
                if (tablename == null) {
                    this.addAllJoinedColumns(e);
                } else {
                    boolean resolved = false;
                    for (int i = 0; i < this.rangeVariables.length; ++i) {
                        RangeVariable range = this.rangeVariables[i].getRangeForTableName(tablename);
                        if (range == null) continue;
                        HashSet exclude = this.getAllNamedJoinColumns();
                        this.rangeVariables[i].addTableColumns(range, e, exclude);
                        resolved = true;
                        break;
                    }
                    if (!resolved) {
                        throw Error.error(5501, tablename);
                    }
                }
                for (int i = 0; i < e.nodes.length; ++i) {
                    this.exprColumnList.add(pos, e.nodes[i]);
                    ++pos;
                }
                this.indexLimitVisible += e.nodes.length - 1;
                continue;
            }
            ++pos;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression, int count, RangeGroup[] rangeGroups, boolean withSequences) {
        if (expression == null) {
            return;
        }
        List list = expression.resolveColumnReferences(session, this, count, rangeGroups, null, withSequences);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Expression e = (Expression)list.get(i);
                boolean resolved = true;
                if (e.isSelfAggregate()) {
                    for (int j = 0; j < e.nodes.length; ++j) {
                        List colList = e.nodes[j].resolveColumnReferences(session, this, count, RangeGroup.emptyArray, null, false);
                        for (int k = 0; k < rangeGroups.length; ++k) {
                            if (!rangeGroups[k].isVariable()) continue;
                            colList = Expression.resolveColumnSet(session, rangeGroups[k].getRangeVariables(), RangeGroup.emptyArray, colList);
                        }
                        resolved &= colList == null;
                    }
                } else {
                    resolved = this.resolveColumnReferences(session, e, count, withSequences);
                }
                if (resolved) {
                    if (e.isSelfAggregate()) {
                        this.addAggregateToSet(expression, e);
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(e);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(e);
            }
        }
    }

    private void addAggregateToSet(Expression parent, Expression e) {
        if (this.aggregateSet == null) {
            this.aggregateSet = new ArrayListIdentity();
        }
        this.aggregateSet.add(e);
        this.isAggregated = true;
        parent.setAggregate();
        e.setCorrelatedReferences(this);
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet set = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            if (range.namedJoinColumns == null) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(range.namedJoinColumns);
        }
        return set;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet nameSet, RangeVariable rightRange, boolean fullList) {
        HashSet<String> set = new HashSet<String>();
        Expression result = null;
        OrderedHashSet<String> joinColumnNames = new OrderedHashSet<String>();
        for (int i = this.rangeVariableList.size() - 1; i >= 0; --i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            OrderedHashMap columnList = range.rangeTable.columnList;
            for (int j = 0; j < columnList.size(); ++j) {
                boolean repeated;
                ColumnSchema column = (ColumnSchema)columnList.get(j);
                String name = range.getColumnAlias((int)j).name;
                boolean columnInList = nameSet.contains(name);
                boolean namedJoin = range.namedJoinColumns != null && range.namedJoinColumns.contains(name);
                boolean bl = repeated = !namedJoin && !set.add(name);
                if (repeated && (!fullList || columnInList)) {
                    throw Error.error(5578, name);
                }
                if (!columnInList) continue;
                joinColumnNames.add(name);
                int leftPosition = range.rangeTable.getColumnIndex(column.getNameString());
                int rightPosition = rightRange.rangeTable.getColumnIndex(name);
                ExpressionLogical e = new ExpressionLogical(range, leftPosition, rightRange, rightPosition);
                ExpressionColumn col = range.getColumnExpression(name);
                if (col == null) {
                    col = new ExpressionColumn(new Expression[]{e.getLeftNode(), e.getRightNode()}, name);
                    range.addNamedJoinColumnExpression(name, col, leftPosition);
                    result = ExpressionLogical.andExpressions(result, e);
                    rightRange.addNamedJoinColumnExpression(name, col, rightPosition);
                    continue;
                }
                if (rightRange.getColumnExpression(name) != null || range.isLeftJoin && !range.isRightJoin) continue;
                if (range.isLeftJoin && range.isRightJoin) {
                    e = new ExpressionLogical(col, e.getRightNode());
                }
                col.nodes = (Expression[])ArrayUtil.resizeArray(col.nodes, col.nodes.length + 1);
                col.nodes[col.nodes.length - 1] = e.getRightNode();
                result = ExpressionLogical.andExpressions(result, e);
                rightRange.addNamedJoinColumnExpression(name, col, rightPosition);
            }
            if (!range.isJoin) break;
        }
        if (fullList && !joinColumnNames.containsAll(nameSet)) {
            throw Error.error(5501);
        }
        rightRange.addNamedJoinColumns(joinColumnNames);
        return result;
    }

    private void addAllJoinedColumns(Expression e) {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(list);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        e.nodes = nodes;
    }

    private void setColumnIndexes() {
        int i = 0;
        while (i < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(i);
            e.resultTableColumnIndex = i++;
        }
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
    }

    private void finaliseColumns() {
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        this.exprColumnList = null;
        if (this.sortAndSlice.hasOrder()) {
            for (int i = 0; i < this.sortAndSlice.getOrderLength(); ++i) {
                this.exprColumns[this.indexStartOrderBy + i] = (Expression)this.sortAndSlice.exprList.get(i);
            }
        }
    }

    private int replaceColumnIndexInOrderBy(Expression orderBy) {
        int i;
        Expression e = orderBy.getLeftNode();
        if (e.getType() != 1) {
            return -1;
        }
        Type type = e.getDataType();
        if (type != null && type.typeCode == 4 && 0 < (i = ((Integer)e.getValue(null)).intValue()) && i <= this.indexLimitVisible) {
            orderBy.setLeftNode(this.exprColumns[i - 1]);
            return i;
        }
        throw Error.error(5576);
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVars, OrderedHashSet set) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            set = this.exprColumns[i].collectRangeVariables(rangeVars, set);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectRangeVariables(rangeVars, set);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            set = this.rangeVariables[i].collectRangeVariables(rangeVars, set);
        }
        return set;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            set = this.exprColumns[i].collectRangeVariables(set);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectRangeVariables(set);
        }
        return set;
    }

    public void resolveExpressionTypes(Session session) {
        Expression e;
        int i;
        Expression rowExpression = new Expression(25, this.exprColumns);
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            e.resolveTypes(session, rowExpression);
            if (e.getType() == 25) {
                throw Error.error(5565);
            }
            if (e.getType() == 22 && e.getDegree() > 1) {
                throw Error.error(5565);
            }
            if (e.getDataType() == null || e.getDataType().typeCode != 19) continue;
            throw Error.error(5565);
        }
        rowExpression.nodes = new Expression[1];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            e = this.rangeVariables[i].getJoinCondition();
            if (e == null) continue;
            rowExpression.setLeftNode(e);
            e.resolveTypes(session, rowExpression);
            e = rowExpression.getLeftNode();
            this.rangeVariables[i].setJoinCondition(e);
            if (e.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            rowExpression.setLeftNode(this.queryCondition);
            this.queryCondition.resolveTypes(session, rowExpression);
            this.queryCondition = rowExpression.getLeftNode();
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingColumnCount != 0 && this.exprColumns[this.indexStartHaving].getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int i = this.indexStartAggregates;
            int j = 0;
            while (i < this.indexLimitExpressions) {
                Expression e = (Expression)this.tempSet.get(j);
                this.exprColumns[i] = e.duplicate();
                this.exprColumns[i].nodes = e.nodes;
                this.exprColumns[i].dataType = e.dataType;
                ++i;
                ++j;
            }
            this.tempSet.clear();
        }
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeResolver = new RangeVariableResolver(session, this);
        rangeResolver.processConditions();
        this.rangeVariables = rangeResolver.rangeVariables;
        if (this.rangeVariables.length > 1) {
            this.isMergeable = false;
        }
    }

    private void setDistinctConditions(Session session) {
        Index index;
        int i;
        int[] colMap;
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            if (!this.rangeVariables[i2].isRightJoin) continue;
            return;
        }
        RangeVariable range = null;
        if (this.isGrouped) {
            colMap = new int[this.groupByColumnCount];
            for (i = 0; i < this.groupByColumnCount; ++i) {
                if (this.exprColumns[this.indexLimitRowId + i].getType() != 2) {
                    return;
                }
                if (range == null) {
                    range = this.exprColumns[this.indexLimitRowId + i].getRangeVariable();
                } else if (range != this.exprColumns[this.indexLimitRowId + i].getRangeVariable()) {
                    return;
                }
                colMap[i] = this.exprColumns[i].columnIndex;
            }
        } else {
            colMap = new int[this.indexLimitVisible];
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            if (this.exprColumns[i].getType() != 2) {
                return;
            }
            if (range == null) {
                range = this.exprColumns[i].getRangeVariable();
            } else if (range != this.exprColumns[i].getRangeVariable()) {
                return;
            }
            if (this.isGrouped) continue;
            colMap[i] = this.exprColumns[i].columnIndex;
        }
        if (range != this.rangeVariables[0]) {
            return;
        }
        boolean check = ArrayUtil.areAllIntIndexesAsBooleanArray(colMap, range.usedColumns);
        if (!check) {
            return;
        }
        if (!range.hasAnyIndexCondition() && (index = range.rangeTable.getIndexForAllColumns(colMap)) != null) {
            range.setSortIndex(index, false);
        }
        this.isSimpleDistinct = range.setDistinctColumnsOnIndex(colMap);
    }

    private void setAggregateConditions(Session session) {
        if (!this.isAggregated) {
            return;
        }
        if (this.isGrouped) {
            this.setGroupedAggregateConditions(session);
        } else if (!this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression e = this.exprColumns[this.indexStartAggregates];
            int opType = e.getType();
            Expression expr = e.getLeftNode();
            switch (opType) {
                case 76: 
                case 77: {
                    if (e.hasCondition()) break;
                    SortAndSlice slice = new SortAndSlice();
                    slice.isGenerated = true;
                    slice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!slice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = slice;
                    break;
                }
                case 74: {
                    if (e.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null) break;
                    if (expr.getType() == 11) {
                        this.isSimpleCount = true;
                        break;
                    }
                    if (expr.getNullability() != 0) break;
                    if (e.isDistinctAggregate) {
                        Table t;
                        if (expr.opType != 2 || (t = expr.getRangeVariable().getTable()).getPrimaryKey().length != 1 || t.getColumn(t.getPrimaryKey()[0]) != expr.getColumn()) break;
                        this.isSimpleCount = true;
                        break;
                    }
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
    }

    private void setGroupedAggregateConditions(Session session) {
    }

    void checkLobUsage() {
    }

    private void resolveGroups() {
        int i;
        int i2;
        int orderCount;
        Expression e;
        int i3;
        OrderedHashSet extraSet = null;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (i3 = this.indexLimitVisible; i3 < this.indexLimitVisible + this.groupByColumnCount; ++i3) {
                this.exprColumns[i3].collectAllExpressions(this.tempSet, OpTypes.aggregateFunctionSet, OpTypes.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (i3 = 0; i3 < this.indexLimitVisible; ++i3) {
                if (this.exprColumns[i3].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet)) continue;
                this.tempSet.add(this.exprColumns[i3]);
            }
            if (!this.tempSet.isEmpty()) {
                if (!this.resolveForGroupBy(this.tempSet)) {
                    throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
                }
                extraSet = new OrderedHashSet();
                extraSet.addAll(this.tempSet);
            }
        } else if (this.isAggregated) {
            for (i3 = 0; i3 < this.indexLimitVisible; ++i3) {
                this.exprColumns[i3].collectAllExpressions(this.tempSet, OpTypes.columnExpressionSet, OpTypes.aggregateFunctionSet);
                for (int j = 0; j < this.tempSet.size(); ++j) {
                    e = (Expression)this.tempSet.get(j);
                    for (int k = 0; k < this.rangeVariables.length; ++k) {
                        if (this.rangeVariables[k] != e.getRangeVariable()) continue;
                        throw Error.error(5574, e.getSQL());
                    }
                }
                this.tempSet.clear();
            }
        }
        this.tempSet.clear();
        if (this.havingColumnCount != 0) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (i3 = this.indexLimitVisible; i3 < this.indexLimitVisible + this.groupByColumnCount; ++i3) {
                this.tempSet.add(this.exprColumns[i3]);
            }
            if (extraSet != null) {
                this.tempSet.addAll(extraSet);
            }
            if (!this.exprColumns[this.indexStartHaving].isComposedOf(this.tempSet, this.outerRanges, OpTypes.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i2 = 0; i2 < orderCount; ++i2) {
                e = (Expression)this.sortAndSlice.exprList.get(i2);
                if (e.resultTableColumnIndex != -1 || e.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i2 = 0; i2 < orderCount; ++i2) {
                e = (Expression)this.sortAndSlice.exprList.get(i2);
                if (e.resultTableColumnIndex != -1 || e.hasAggregate() || e.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        OrderedHashSet<Expression> expressions = new OrderedHashSet<Expression>();
        i2 = this.indexStartAggregates;
        while (i2 < this.indexLimitExpressions) {
            e = this.exprColumns[i2];
            e.resultTableColumnIndex = i2++;
            expressions.add(e);
        }
        for (i2 = 0; i2 < this.indexStartHaving; ++i2) {
            if (this.exprColumns[i2].hasAggregate()) continue;
            e = this.exprColumns[i2];
            e.resultTableColumnIndex = i2;
            expressions.add(e);
        }
        if (!this.isAggregated) {
            return;
        }
        int orderCount2 = this.sortAndSlice.getOrderLength();
        for (i = 0; i < orderCount2; ++i) {
            Expression e2 = (Expression)this.sortAndSlice.exprList.get(i);
            if (!e2.getLeftNode().hasAggregate()) continue;
            e2.setAggregate();
        }
        for (i = this.indexStartOrderBy; i < this.indexStartAggregates; ++i) {
            if (!this.exprColumns[i].getLeftNode().hasAggregate()) continue;
            this.exprColumns[i].setAggregate();
        }
        for (i = 0; i < this.indexStartAggregates; ++i) {
            Expression e3 = this.exprColumns[i];
            if (!e3.hasAggregate()) continue;
            this.aggregateCheck[i] = true;
            this.exprColumns[i] = e3.replaceExpressions(expressions, this.resultRangePosition);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (i = 0; i < this.resolvedSubqueryExpressions.size(); ++i) {
                Expression e4 = (Expression)this.resolvedSubqueryExpressions.get(i);
                e4.replaceExpressions(expressions, this.resultRangePosition);
            }
        }
    }

    public void resolveGroupingSets() {
        int i;
        if (!this.isGrouped) {
            return;
        }
        this.tempSet.clear();
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            this.tempSet.add(this.exprColumns[i]);
        }
        for (i = this.indexStartAggregates; i < this.indexLimitExpressions; ++i) {
            this.tempSet.add(this.exprColumns[i]);
        }
        if (this.isGroupingSets) {
            for (i = 0; i < this.indexLimitVisible; ++i) {
                this.exprColumns[i] = this.exprColumns[i].replaceExpressions(this.tempSet, this.resultRangePosition);
            }
        }
        for (i = this.indexStartHaving; i < this.indexStartHaving + this.havingColumnCount; ++i) {
            this.exprColumns[i] = this.exprColumns[i].replaceExpressions(this.tempSet, this.resultRangePosition);
        }
    }

    boolean resolveForGroupBy(List unresolvedSet) {
        int i;
        for (i = this.indexLimitVisible; i < this.indexLimitVisible + this.groupByColumnCount; ++i) {
            Expression e = this.exprColumns[i];
            if (e.getType() != 2) continue;
            RangeVariable range = e.getRangeVariable();
            int colIndex = e.getColumnIndex();
            range.columnsInGroupBy[colIndex] = true;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            range.hasKeyedColumnInGroupBy = range.rangeTable.getUniqueNotNullColumnGroup(range.columnsInGroupBy) != null;
        }
        OrderedHashSet set = null;
        for (int i2 = 0; i2 < unresolvedSet.size(); ++i2) {
            Expression e = (Expression)unresolvedSet.get(i2);
            set = e.getUnkeyedColumns(set);
        }
        return set == null;
    }

    @Override
    Result getResult(Session session, int maxRows) {
        RowSetNavigatorData navigator = new RowSetNavigatorData(session, this);
        int[] limits = this.sortAndSlice.getLimits(session, this, maxRows);
        int skipCount = 0;
        int limitCount = limits[2];
        if (this.sortAndSlice.skipFullResult) {
            skipCount = limits[0];
            limitCount = limits[1];
        }
        Result r = this.buildResult(session, navigator, skipCount, limitCount);
        navigator = (RowSetNavigatorData)r.getNavigator();
        if (this.isDistinctSelect) {
            navigator.removeDuplicates();
        }
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            navigator.sortOrder();
        }
        if (limits != SortAndSlice.defaultLimits && !this.sortAndSlice.skipFullResult) {
            navigator.trim(limits[0], limits[1]);
        }
        r.getNavigator().reset();
        return r;
    }

    private Result buildResult(Session session, RowSetNavigatorData navigator, int skipCount, int limitCount) {
        int i;
        Result result = Result.newResult(navigator);
        boolean isResultGrouped = this.isGrouped && !this.isSimpleDistinct;
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        if (this.isSimpleCount) {
            this.getSimpleCountResult(session, navigator);
            return result;
        }
        if (limitCount == 0) {
            return result;
        }
        if (this.isGroupingSets) {
            session.sessionContext.setGroup(null);
        }
        int memoryRowLimit = !this.isAggregated && !this.isSingleMemoryTable && !this.isGroupingSets ? session.resultMaxMemoryRows : 0;
        int fullJoinIndex = 0;
        RangeIterator[] rangeIterators = new RangeIterator[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i] = this.rangeVariables[i].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        int currentIndex = 0;
        while (true) {
            int rowCount;
            int i2;
            int i3;
            RangeIterator it;
            if (currentIndex < fullJoinIndex) {
                boolean end = true;
                for (int i4 = fullJoinIndex + 1; i4 < this.rangeVariables.length; ++i4) {
                    if (!this.rangeVariables[i4].isRightJoin) continue;
                    fullJoinIndex = i4;
                    currentIndex = i4;
                    end = false;
                    ((RangeVariable.RangeIteratorRight)rangeIterators[i4]).setOnOuterRows();
                    break;
                }
                if (end) break;
            }
            if ((it = rangeIterators[currentIndex]).next()) {
                if (currentIndex < this.rangeVariables.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                it.reset();
                --currentIndex;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] data = new Object[this.indexLimitData];
            int start = 0;
            if (this.isGroupingSets) {
                start = this.indexLimitVisible;
            }
            for (i3 = start; i3 < this.indexStartAggregates; ++i3) {
                if (this.isAggregated && this.aggregateCheck[i3] || this.havingColumnCount > 0 && i3 == this.indexStartHaving) continue;
                data[i3] = this.exprColumns[i3].getValue(session);
            }
            for (i3 = this.indexLimitVisible; i3 < this.indexLimitRowId; ++i3) {
                data[i3] = i3 == this.indexLimitVisible ? Long.valueOf(it.getRowId()) : it.getCurrentRow();
            }
            ++session.sessionContext.rownum;
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            Object[] groupData = null;
            if ((this.isAggregated || isResultGrouped) && (groupData = navigator.getGroupData(data)) != null) {
                data = groupData;
            }
            for (i2 = this.indexStartAggregates; i2 < this.indexLimitExpressions; ++i2) {
                data[i2] = this.exprColumns[i2].updateAggregatingValue(session, (SetFunction)data[i2]);
            }
            if (groupData == null) {
                navigator.add(data);
                if (this.isSimpleDistinct) {
                    for (i2 = 1; i2 < this.rangeVariables.length; ++i2) {
                        rangeIterators[i2].reset();
                    }
                    currentIndex = 0;
                }
            } else if (this.isAggregated) {
                navigator.update(groupData, data);
            }
            if ((rowCount = navigator.getSize()) == memoryRowLimit) {
                navigator = new RowSetNavigatorDataTable(session, this, navigator);
                result.setNavigator(navigator);
                memoryRowLimit = 0;
            }
            if ((!this.isAggregated && !isResultGrouped || this.sortAndSlice.isGenerated) && rowCount >= limitCount) break;
        }
        navigator.reset();
        for (i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i].reset();
        }
        if (!this.isGroupingSets && !this.isAggregated && this.havingColumnCount == 0) {
            return result;
        }
        session.sessionContext.setRangeIterator(navigator);
        if (this.isGroupingSets) {
            session.sessionContext.setGroupSet(this.groupSet);
            Iterator groupsIterator = this.groupSet.getIterator();
            Object[][] baseResult = navigator.getDataTable();
            int baseResultSize = navigator.getSize();
            navigator.clear();
            if (this.groupSet.nullSets != 0) {
                int i5;
                Object[] data = new Object[this.indexLimitData];
                for (i5 = 0; i5 < this.indexStartAggregates; ++i5) {
                    data[i5] = this.exprColumns[i5].getValue(session);
                }
                navigator.add(data);
                navigator.next();
                if (this.isAggregated) {
                    for (i5 = 0; i5 < baseResultSize; ++i5) {
                        Object[] row = baseResult[i5];
                        for (int j = this.indexStartAggregates; j < this.indexLimitExpressions; ++j) {
                            data[j] = this.exprColumns[j].updateAggregatingValue(session, (SetFunction)data[j], (SetFunction)row[j]);
                        }
                    }
                    for (i5 = this.indexStartAggregates; i5 < this.indexLimitExpressions; ++i5) {
                        data[i5] = this.exprColumns[i5].getAggregatedValue(session, (SetFunction)data[i5]);
                    }
                    for (i5 = 0; i5 < this.indexStartAggregates; ++i5) {
                        if (!this.aggregateCheck[i5]) continue;
                        data[i5] = this.exprColumns[i5].getValue(session);
                    }
                }
                for (i5 = 1; i5 < this.groupSet.nullSets; ++i5) {
                    navigator.add(data);
                    navigator.next();
                }
            }
            while (groupsIterator.hasNext()) {
                navigator.resetRowMap();
                List set = (List)groupsIterator.next();
                session.sessionContext.setGroup(set);
                for (int i6 = 0; i6 < baseResultSize; ++i6) {
                    int j;
                    Object[] row = baseResult[i6];
                    Object[] data = new Object[this.indexLimitData];
                    for (int j2 = this.indexLimitVisible; j2 < this.indexStartHaving; ++j2) {
                        if (!set.contains(j2)) continue;
                        data[j2] = row[j2];
                    }
                    Object[] groupData = navigator.getGroupDataAndPosition(data);
                    if (groupData == null) {
                        navigator.add(data);
                        navigator.absolute(navigator.getSize() - 1);
                    } else {
                        data = groupData;
                    }
                    for (j = this.indexStartAggregates; j < this.indexLimitExpressions; ++j) {
                        data[j] = this.exprColumns[j].updateAggregatingValue(session, (SetFunction)data[j], (SetFunction)row[j]);
                    }
                    for (j = 0; j < this.indexLimitVisible; ++j) {
                        data[j] = this.exprColumns[j].getValue(session);
                    }
                    navigator.update(groupData, data);
                }
            }
        }
        navigator.reset();
        if (this.isAggregated) {
            if (!isResultGrouped && navigator.getSize() == 0) {
                Object[] data = new Object[this.exprColumns.length];
                for (int i7 = 0; i7 < this.indexStartAggregates; ++i7) {
                    if (this.aggregateCheck[i7]) continue;
                    data[i7] = this.exprColumns[i7].getValue(session);
                }
                navigator.add(data);
            }
            if (this.isGroupingSets) {
                for (int i8 = 0; i8 < this.groupSet.nullSets; ++i8) {
                    navigator.next();
                }
            }
            while (navigator.next()) {
                int i9;
                Object[] data = navigator.getCurrent();
                for (i9 = this.indexStartAggregates; i9 < this.indexLimitExpressions; ++i9) {
                    data[i9] = this.exprColumns[i9].getAggregatedValue(session, (SetFunction)data[i9]);
                }
                for (i9 = 0; i9 < this.indexStartAggregates; ++i9) {
                    if (!this.aggregateCheck[i9]) continue;
                    data[i9] = this.exprColumns[i9].getValue(session);
                }
            }
        }
        navigator.reset();
        if (this.havingColumnCount != 0) {
            while (navigator.next()) {
                Object[] data = navigator.getCurrent();
                boolean test = this.exprColumns[this.indexStartHaving].testCondition(session);
                if (test) continue;
                navigator.removeCurrent();
            }
            navigator.reset();
        }
        session.sessionContext.unsetRangeIterator(navigator);
        return result;
    }

    private void getSimpleCountResult(Session session, RowSetNavigatorData navigator) {
        Object[] data = new Object[this.indexLimitData];
        Table table = this.rangeVariables[0].getTable();
        table.materialise(session);
        PersistentStore store = table.getRowStore(session);
        long count = store.elementCount(session);
        data[this.indexStartAggregates] = ValuePool.getLong(count);
        navigator.add(data);
        navigator.reset();
        session.sessionContext.setRangeIterator(navigator);
        if (navigator.next()) {
            data = navigator.getCurrent();
            for (int i = 0; i < this.indexStartAggregates; ++i) {
                data[i] = this.exprColumns[i].getValue(session);
            }
        }
        session.sessionContext.unsetRangeIterator(navigator);
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap aliases = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String alias = expression.getAlias();
            if (alias.isEmpty()) {
                HsqlNameManager.HsqlName name = HsqlNameManager.getAutoColumnName(i);
                expression.setAlias(name);
                continue;
            }
            int index = aliases.get((Object)alias, -1);
            if (index == -1) {
                aliases.put(alias, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[index] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] names) {
        if (names.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(names[i]);
        }
    }

    private void createResultMetaData(Session session) {
        this.resultMetaData = ResultMetaData.newResultMetaData(this.resultColumnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            String colLabel;
            Expression e = this.exprColumns[i];
            ColumnSchema tableColumn = null;
            tableColumn = e.getColumn();
            this.resultMetaData.columnTypes[i] = e.getDataType();
            ColumnBase column = tableColumn == null ? new ColumnBase() : new ColumnBase(session.database.getCatalogName(), tableColumn, this.lowerCaseResultIdentifier);
            column.setType(e.getDataType());
            HsqlNameManager.SimpleName alias = e.getSimpleName();
            String string = colLabel = alias == null ? "" : alias.name;
            if (this.lowerCaseResultIdentifier && !alias.isNameQuoted) {
                colLabel = colLabel.toLowerCase(Locale.ENGLISH);
            }
            this.resultMetaData.columns[i] = column;
            this.resultMetaData.columnLabels[i] = colLabel;
        }
    }

    private void setResultNullability() {
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            RangeVariable range;
            Expression e = this.exprColumns[i];
            byte nullability = e.getNullability();
            if (e.opType == 2 && (range = e.getRangeVariable()) != null && (range.rangePositionInJoin < this.startInnerRange || range.rangePositionInJoin >= this.endInnerRange)) {
                nullability = 1;
            }
            this.resultMetaData.columns[i].setNullability(nullability);
        }
    }

    @Override
    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            int[] groupCols = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                groupCols[i] = this.indexLimitRowId + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, groupCols, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            int[] idCols = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, idCols, null, null, false, false, false);
        }
    }

    private void createFullIndex(Session session) {
        int[] fullCols = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, fullCols, null, null, false, false, false);
    }

    private void setResultColumnTypes() {
        Expression e;
        int i;
        this.resultColumnTypes = new Type[this.indexLimitData];
        for (i = 0; i < this.indexLimitVisible; ++i) {
            e = this.exprColumns[i];
            this.resultColumnTypes[i] = e.getDataType();
        }
        for (i = this.indexLimitVisible; i < this.indexLimitRowId; ++i) {
            this.resultColumnTypes[i] = i == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (i = this.indexLimitRowId; i < this.indexLimitData; ++i) {
            e = this.exprColumns[i];
            Type type = e.getDataType();
            if (type.getCollation() != e.collation && e.collation != null) {
                type = Type.getType(type, e.collation);
            }
            this.resultColumnTypes[i] = type;
        }
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName tableName = session.database.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 21 ? 2 : 9;
        OrderedHashMap<String, ColumnSchema> columnList = new OrderedHashMap<String, ColumnSchema>();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression e = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = e.getSimpleName();
            String nameString = simpleName.name;
            HsqlNameManager.HsqlName name = session.database.nameManager.newColumnSchemaHsqlName(tableName, simpleName);
            if (!this.accessibleColumns[i]) {
                nameString = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema column = new ColumnSchema(name, e.dataType, true, false, null);
            columnList.add(nameString, column);
        }
        this.resultTable = new TableDerived(session.database, tableName, tableType, this.resultColumnTypes, columnList, ValuePool.emptyIntArray);
    }

    public String getSQL() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT").append(' ');
        int limit = this.indexLimitVisible;
        for (i = 0; i < limit; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exprColumns[i].getSQL());
        }
        sb.append("FROM");
        limit = this.rangeVariables.length;
        for (i = 0; i < limit; ++i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            if (i > 0) {
                if (rangeVar.isLeftJoin && rangeVar.isRightJoin) {
                    sb.append("FULL").append(' ');
                } else if (rangeVar.isLeftJoin) {
                    sb.append("LEFT").append(' ');
                } else if (rangeVar.isRightJoin) {
                    sb.append("RIGHT").append(' ');
                }
                sb.append("JOIN").append(' ');
            }
            sb.append(rangeVar.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            sb.append(' ').append("GROUP").append(' ').append("BY");
            limit = this.indexLimitVisible + this.groupByColumnCount;
            for (i = this.indexLimitVisible; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.havingColumnCount != 0) {
            sb.append(' ').append("HAVING").append(' ');
            sb.append(this.exprColumns[this.indexStartHaving].getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            limit = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            sb.append(' ').append("ORDER").append("BY").append(' ');
            for (i = this.indexStartOrderBy; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            sb.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return sb.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session, int blanks) {
        String temp;
        int index;
        int i;
        StringBuilder b = new StringBuilder(blanks);
        for (i = 0; i < blanks; ++i) {
            b.append(' ');
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)b).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append((CharSequence)b).append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append((CharSequence)b).append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append((CharSequence)b).append("columns=[");
        for (i = 0; i < this.indexLimitVisible; ++i) {
            index = i;
            if (this.exprColumns[i].getType() == 5) {
                index = this.exprColumns[i].columnIndex;
            }
            sb.append((CharSequence)b);
            temp = this.exprColumns[index].describe(session, 2);
            sb.append(temp, 0, temp.length() - 1);
            if (this.resultMetaData.columns[i].getNullability() == 0) {
                sb.append(" not nullable\n");
                continue;
            }
            sb.append(" nullable\n");
        }
        sb.append("\n");
        sb.append((CharSequence)b).append("]\n");
        for (i = 0; i < this.rangeVariables.length; ++i) {
            sb.append((CharSequence)b).append("[");
            sb.append("range variable ").append(i + 1).append("\n");
            sb.append(this.rangeVariables[i].describe(session, blanks + 2));
            sb.append((CharSequence)b).append("]");
        }
        sb.append((CharSequence)b).append("]\n");
        String string = temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session, blanks);
        if (this.isGrouped) {
            sb.append((CharSequence)b).append("groupColumns=[");
            for (i = this.indexLimitRowId; i < this.indexLimitRowId + this.groupByColumnCount; ++i) {
                index = i;
                if (this.exprColumns[i].getType() == 5) {
                    index = this.exprColumns[i].columnIndex;
                }
                sb.append(this.exprColumns[index].describe(session, blanks));
            }
            sb.append((CharSequence)b).append("]\n");
        }
        if (this.havingColumnCount != 0) {
            temp = this.exprColumns[this.indexStartHaving].describe(session, blanks);
            sb.append((CharSequence)b).append("havingCondition=[").append(temp).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            sb.append((CharSequence)b).append("order by=[\n");
            for (i = 0; i < this.sortAndSlice.exprList.size(); ++i) {
                sb.append((CharSequence)b).append(((Expression)this.sortAndSlice.exprList.get(i)).describe(session, blanks));
            }
            if (this.sortAndSlice.primaryTableIndex != null) {
                sb.append((CharSequence)b).append("uses index");
            }
            sb.append((CharSequence)b).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                sb.append((CharSequence)b).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, b.length())).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                sb.append((CharSequence)b).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, b.length())).append("]\n");
            }
        }
        return sb.toString();
    }

    void setMergeability() {
        this.isOrderSensitive |= this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder();
        if (this.isOrderSensitive) {
            this.isMergeable = false;
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
        if (this.isGrouped || this.isDistinctSelect) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
        if (this.rangeVariables.length != 1) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
    }

    void setUpdatability(Session session) {
        String name;
        Expression expression;
        int i;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (this.isGrouped || this.isDistinctSelect || this.isAggregated) {
            return;
        }
        if (!this.isBaseMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if ((this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) && !session.database.sqlSyntaxDb2) {
            return;
        }
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Table baseTable = table.getBaseTable();
        if (baseTable == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap columns = new IntValueHashMap();
        int[] baseColumnMap = table.getBaseTableColumnMap();
        int[] columnMap = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(baseTable.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            expression = this.exprColumns[i];
            if (expression.getType() == 2) {
                name = expression.getColumn().getName().name;
                if (columns.containsKey(name)) {
                    columns.put(name, 1);
                    continue;
                }
                columns.put(name, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, expression);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (i = 0; i < this.indexLimitVisible; ++i) {
            if (this.accessibleColumns[i] && (expression = this.exprColumns[i]).getType() == 2 && columns.get(name = expression.getColumn().getName().name) == 0) {
                int index = table.findColumn(name);
                columnMap[i] = baseColumnMap[index];
                if (columnMap[i] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            columnMap[i] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] checkList = baseTable.getColumnCheckList(columnMap);
            for (i = 0; i < checkList.length; ++i) {
                ColumnSchema column;
                if (checkList[i] || (column = baseTable.getColumn(i)).isIdentity() || column.isGenerated() || column.hasDefault() || column.isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = columnMap;
            this.baseTable = baseTable;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!baseTable.isFileBased()) {
                ++this.indexLimitRowId;
                this.isSingleMemoryTable = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery(Session session) {
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Expression localQueryCondition = this.queryCondition;
        QueryExpression baseQueryExpression = table.getQueryExpression();
        if (this.isBaseMergeable && baseQueryExpression != null && baseQueryExpression.isMergeable) {
            QuerySpecification baseSelect = baseQueryExpression.getMainSelect();
            this.rangeVariables[0] = baseSelect.rangeVariables[0];
            this.rangeVariables[0].resetConditions();
            for (int i = 0; i < this.indexLimitExpressions; ++i) {
                Expression e = this.exprColumns[i];
                this.exprColumns[i] = e.replaceColumnReferences(session, rangeVar, baseSelect.exprColumns);
            }
            if (localQueryCondition != null) {
                localQueryCondition = localQueryCondition.replaceColumnReferences(session, rangeVar, baseSelect.exprColumns);
            }
            Expression baseQueryCondition = baseSelect.queryCondition;
            this.checkQueryCondition = baseSelect.checkQueryCondition;
            this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = localQueryCondition;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet set, Expression expression) {
        expression.collectAllExpressions(set, OpTypes.subqueryExpressionSet, OpTypes.emptyExpressionSet);
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            Expression e = (Expression)set.get(i);
            e.collectObjectNames(set);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int i;
        OrderedHashSet set = null;
        for (i = 0; i < this.indexLimitExpressions; ++i) {
            set = this.exprColumns[i].collectAllSubqueries(set);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllSubqueries(set);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            OrderedHashSet temp = this.rangeVariables[i].getSubqueries();
            set = OrderedHashSet.addAll(set, temp);
        }
        return set;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectOuterColumnExpressions(OrderedHashSet set, OrderedHashSet exclude) {
        if ((set = this.collectAllExpressions(set, OpTypes.columnExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) {
            return null;
        }
        for (int i = set.size() - 1; i >= 0; --i) {
            Expression col = (Expression)set.get(i);
            if (ArrayUtil.find(this.rangeVariables, col.getRangeVariable()) >= 0) {
                set.remove(i);
            }
            if (!exclude.contains(col)) continue;
            set.remove(i);
        }
        if (set.isEmpty()) {
            set = null;
        }
        return set;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            set = this.exprColumns[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    @Override
    public void collectObjectNames(Set set) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            HsqlNameManager.HsqlName name = this.rangeVariables[i].getTable().getName();
            set.add(name);
        }
    }

    @Override
    public void replaceColumnReferences(Session session, RangeVariable range, Expression[] list) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i] = this.exprColumns[i].replaceColumnReferences(session, range, list);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceColumnReferences(session, range, list);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            this.rangeVariables[i].replaceColumnReferences(session, range, list);
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].replaceRangeVariables(ranges, newRanges);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(ranges, newRanges);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            this.rangeVariables[i].getSubqueries();
        }
    }

    @Override
    public void replaceExpressions(OrderedHashSet expressions, int resultRangePosition) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i] = this.exprColumns[i].replaceExpressions(expressions, resultRangePosition);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceExpressions(expressions, resultRangePosition);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            this.rangeVariables[i].replaceExpressions(expressions, resultRangePosition);
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] names = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            names[i] = this.exprColumns[i].getAlias();
        }
        return names;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.resultColumnTypes.length == this.indexLimitVisible) {
            return this.resultColumnTypes;
        }
        Type[] types = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.resultColumnTypes, types, types.length);
        return types;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet set) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isView() || rangeTable.isDataReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
    }

    @Override
    boolean isEquivalent(QueryExpression other) {
        if (!(other instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification otherSpec = (QuerySpecification)other;
        if (!Expression.equals(this.exprColumns, otherSpec.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, otherSpec.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != otherSpec.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == otherSpec.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }
}

