/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RangeVariable;
import org.hsqldb.TableDerived;

public interface RangeGroup {
    public static final RangeGroup emptyGroup = new RangeGroupEmpty();
    public static final RangeGroup[] emptyArray = new RangeGroup[]{emptyGroup};

    public RangeVariable[] getRangeVariables();

    public void setCorrelated();

    public boolean isVariable();

    public static class RangeGroupEmpty
    implements RangeGroup {
        RangeGroupEmpty() {
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return RangeVariable.emptyArray;
        }

        @Override
        public void setCorrelated() {
        }

        @Override
        public boolean isVariable() {
            return false;
        }
    }

    public static class RangeGroupSimple
    implements RangeGroup {
        final RangeVariable[] ranges;
        final RangeGroup baseGroup;
        final TableDerived table;
        final boolean isVariable;

        public RangeGroupSimple(TableDerived table) {
            this.ranges = RangeVariable.emptyArray;
            this.baseGroup = null;
            this.table = table;
            this.isVariable = false;
        }

        public RangeGroupSimple(RangeVariable[] ranges, RangeGroup baseGroup) {
            this.ranges = ranges;
            this.baseGroup = baseGroup;
            this.table = null;
            this.isVariable = false;
        }

        public RangeGroupSimple(RangeVariable[] ranges, boolean isVariable) {
            this.ranges = ranges;
            this.baseGroup = null;
            this.table = null;
            this.isVariable = isVariable;
        }

        @Override
        public RangeVariable[] getRangeVariables() {
            return this.ranges;
        }

        @Override
        public void setCorrelated() {
            if (this.baseGroup != null) {
                this.baseGroup.setCorrelated();
            }
            if (this.table != null) {
                this.table.setCorrelated();
            }
        }

        @Override
        public boolean isVariable() {
            return this.isVariable;
        }
    }
}

