/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    public RangeVariableJoined(Table table, HsqlNameManager.SimpleName alias, OrderedHashSet columnList, HsqlNameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        super(table, alias, columnList, columnNameList, compileContext);
        this.setParameters();
    }

    private void setParameters() {
        this.namedJoinColumnExpressions = new HashMap();
        QuerySpecification qs = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = qs.rangeVariables;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (this.rangeArray[i].isLeftJoin) {
                this.hasLeftJoin = true;
            }
            if (this.rangeArray[i].isRightJoin) {
                this.hasRightJoin = true;
            }
            if (this.rangeArray[i].isLateral) {
                this.hasLateral = true;
            }
            if (this.rangeArray[i].namedJoinColumnExpressions == null) continue;
            this.namedJoinColumnExpressions.putAll(this.rangeArray[i].namedJoinColumnExpressions);
        }
    }

    public RangeVariable[] getBaseRangeVariables() {
        return this.rangeArray;
    }

    @Override
    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    @Override
    public void setJoinType(boolean isLeft, boolean isRight) {
        super.setJoinType(isLeft, isRight);
    }

    @Override
    public void addNamedJoinColumns(OrderedHashSet columns) {
        super.addNamedJoinColumns(columns);
    }

    @Override
    public void addColumn(int columnIndex) {
        super.addColumn(columnIndex);
    }

    @Override
    public void addAllColumns() {
        super.addAllColumns();
    }

    @Override
    public void addNamedJoinColumnExpression(String name, Expression e, int position) {
        super.addNamedJoinColumnExpression(name, e, position);
    }

    @Override
    public ExpressionColumn getColumnExpression(String name) {
        return null;
    }

    @Override
    public Table getTable() {
        return super.getTable();
    }

    @Override
    public boolean hasSingleIndexCondition() {
        return super.hasSingleIndexCondition();
    }

    @Override
    public boolean setDistinctColumnsOnIndex(int[] colMap) {
        return super.setDistinctColumnsOnIndex(colMap);
    }

    @Override
    public Index getSortIndex() {
        return super.getSortIndex();
    }

    @Override
    public boolean setSortIndex(Index index, boolean reversed) {
        return super.setSortIndex(index, reversed);
    }

    @Override
    public boolean reverseOrder() {
        return super.reverseOrder();
    }

    @Override
    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    @Override
    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    @Override
    public int findColumn(String schemaName, String tableName, String columnName) {
        if (this.tableAlias != null) {
            return super.findColumn(schemaName, tableName, columnName);
        }
        int count = 0;
        int colIndex = -1;
        if (tableName == null && this.namedJoinColumnExpressions.containsKey(columnName)) {
            return super.findColumn(null, null, columnName);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            RangeVariable currentRange = this.rangeArray[i];
            colIndex = currentRange.findColumn(schemaName, tableName, columnName);
            if (currentRange.namedJoinColumnCheck == null) {
                count = colIndex > -1 ? (count += colIndex) : (count += currentRange.rangeTable.getColumnCount());
            } else {
                int limit = colIndex > -1 ? colIndex : currentRange.namedJoinColumnCheck.length;
                for (int j = 0; j < limit; ++j) {
                    if (currentRange.namedJoinColumnCheck[j]) continue;
                    ++count;
                }
            }
            if (colIndex > -1) break;
        }
        if (colIndex > -1) {
            if (this.namedJoinColumnExpressions != null) {
                count += this.namedJoinColumnExpressions.size();
            }
            return count;
        }
        return -1;
    }

    @Override
    public HsqlNameManager.SimpleName getColumnAlias(int i) {
        return super.getColumnAlias(i);
    }

    @Override
    public boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    @Override
    public HsqlNameManager.SimpleName getTableAlias() {
        return super.getTableAlias();
    }

    @Override
    public RangeVariable getRangeForTableName(String name) {
        if (this.tableAlias != null) {
            return super.getRangeForTableName(name);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            RangeVariable range = this.rangeArray[i].getRangeForTableName(name);
            if (range == null) continue;
            return range;
        }
        return null;
    }

    @Override
    public void addTableColumns(HsqlArrayList exprList) {
        super.addTableColumns(exprList);
    }

    @Override
    public int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        return super.addTableColumns(exprList, position, exclude);
    }

    @Override
    public void addTableColumns(RangeVariable subRange, Expression expression, HashSet exclude) {
        int index = this.getFirstColumnIndex(subRange);
        this.addTableColumns(expression, index, subRange.rangeTable.getColumnCount(), exclude);
    }

    @Override
    protected int getFirstColumnIndex(RangeVariable subRange) {
        if (subRange == this) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int index = this.rangeArray[i].getFirstColumnIndex(subRange);
            if (index == -1) {
                count += this.rangeArray[i].rangeTable.getColumnCount();
                continue;
            }
            return count + index;
        }
        return -1;
    }

    @Override
    public void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    @Override
    public Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    @Override
    public void addJoinCondition(Expression e) {
        super.addJoinCondition(e);
    }

    @Override
    public void resetConditions() {
        super.resetConditions();
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        super.replaceRangeVariables(ranges, newRanges);
    }

    @Override
    public void resolveRangeTable(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroups) {
        super.resolveRangeTable(session, rangeGroup, rangeGroups);
    }

    @Override
    public String describe(Session session, int blanks) {
        RangeVariable.RangeVariableConditions[] conditionsArray = this.joinConditions;
        StringBuilder sb = new StringBuilder();
        String b = ValuePool.spaceString.substring(0, blanks);
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean fullScan = !conditionsArray[0].hasIndexCondition();
        sb.append(b).append("access=").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < conditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions conditions = this.joinConditions[i];
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b).append("condition = [");
            }
            sb.append(conditions.describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        return sb.toString();
    }

    @Override
    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

