/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;

public class ReferenceObject
implements SchemaObject {
    HsqlNameManager.HsqlName name;
    HsqlNameManager.HsqlName target;

    public ReferenceObject(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName target) {
        this.name = name;
        this.target = target;
    }

    @Override
    public int getType() {
        return 29;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
        set.add(this.target);
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE").append(' ').append("SYNONYM");
        sb.append(' ').append(this.name.getSchemaQualifiedStatementName());
        sb.append(' ').append("FOR").append(' ');
        sb.append(this.target.getSchemaQualifiedStatementName());
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public HsqlNameManager.HsqlName getTarget() {
        return this.target;
    }
}

