/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserRoutine;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class Routine
implements SchemaObject,
RangeGroup,
Cloneable {
    public static final int NO_SQL = 1;
    public static final int CONTAINS_SQL = 2;
    public static final int READS_SQL = 3;
    public static final int MODIFIES_SQL = 4;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_SQL = 2;
    public static final int PARAM_STYLE_JAVA = 1;
    public static final int PARAM_STYLE_SQL = 2;
    static final Routine[] emptyArray = new Routine[0];
    RoutineSchema routineSchema;
    private HsqlNameManager.HsqlName name;
    private HsqlNameManager.HsqlName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Table returnTable;
    final int routineType;
    int language = 2;
    int dataImpact = 2;
    int parameterStyle;
    boolean isDeterministic;
    boolean isNullInputOutput;
    boolean isNewSavepointLevel = true;
    int maxDynamicResults = 0;
    boolean isRecursive;
    boolean returnsTable;
    Statement statement;
    boolean isAggregate;
    boolean isIndex;
    boolean isSearch;
    private String methodName;
    Method javaMethod;
    boolean javaMethodWithConnection;
    private boolean isLibraryRoutine;
    OrderedHashMap parameterList = new OrderedHashMap();
    RangeVariable[] ranges = RangeVariable.emptyArray;
    int variableCount;
    int cursorCount;
    OrderedHashSet references;
    Table triggerTable;
    int triggerType;
    int triggerOperation;

    public Routine(int type) {
        this.routineType = type;
        this.returnType = Type.SQL_ALL_TYPES;
        this.ranges = new RangeVariable[]{new RangeVariable(this.parameterList, null, false, 3)};
    }

    public Routine(Table table, RangeVariable[] ranges, int impact, int triggerType, int operationType) {
        this.routineType = 8;
        this.returnType = Type.SQL_ALL_TYPES;
        this.dataImpact = impact;
        this.ranges = ranges;
        this.triggerTable = table;
        this.triggerType = triggerType;
        this.triggerOperation = operationType;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        if (this.routineType == 8) {
            return this.triggerTable.getSchemaName();
        }
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(Session session, SchemaObject parentObject) {
        ParserRoutine p = new ParserRoutine(session, new Scanner(session, this.statement.getSQL()));
        session.sessionContext.pushRoutineTables();
        try {
            p.read();
            ParserBase.Recorder recorder = p.startRecording();
            Statement newStatement = p.compileSQLProcedureStatementOrNull(this, null);
            String sql = recorder.getSQL();
            newStatement.setSQL(sql);
            this.setProcedure(newStatement);
            this.resolve(session);
        }
        finally {
            session.sessionContext.popRoutineTables();
        }
    }

    @Override
    public String getSQL() {
        return this.getDefinitionSQL(true);
    }

    public String getSQLAlter() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER").append(' ').append("SPECIFIC");
        sb.append(' ').append("ROUTINE").append(' ');
        sb.append(this.specificName.getSchemaQualifiedStatementName());
        sb.append(' ').append("BODY");
        sb.append(' ').append(this.statement.getSQL());
        return sb.toString();
    }

    public String getSQLDeclaration() {
        return this.getDefinitionSQL(false);
    }

    private String getDefinitionSQL(boolean withBody) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE").append(' ');
        if (this.isAggregate) {
            sb.append("AGGREGATE").append(' ');
        }
        if (this.routineType == 17) {
            sb.append("PROCEDURE");
        } else {
            sb.append("FUNCTION");
        }
        sb.append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName());
        sb.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            sb.append(param.getSQL());
        }
        sb.append(')');
        sb.append(' ');
        if (this.routineType == 16) {
            sb.append("RETURNS");
            sb.append(' ');
            if (this.returnsTable) {
                sb.append("TABLE");
                sb.append(this.returnTable.getColumnListWithTypeSQL());
            } else {
                sb.append(this.returnType.getTypeDefinition());
            }
            sb.append(' ');
        }
        if (this.specificName != null) {
            sb.append("SPECIFIC");
            sb.append(' ');
            sb.append(this.specificName.getStatementName());
            sb.append(' ');
        }
        sb.append("LANGUAGE");
        sb.append(' ');
        if (this.language == 1) {
            sb.append("JAVA");
        } else {
            sb.append("SQL");
        }
        sb.append(' ');
        if (!this.isDeterministic) {
            sb.append("NOT");
            sb.append(' ');
        }
        sb.append("DETERMINISTIC");
        sb.append(' ');
        sb.append(this.getDataImpactString());
        sb.append(' ');
        if (this.routineType == 16) {
            if (this.isNullInputOutput) {
                sb.append("RETURNS").append(' ').append("NULL");
            } else {
                sb.append("CALLED");
            }
            sb.append(' ').append("ON").append(' ');
            sb.append("NULL").append(' ').append("INPUT");
            sb.append(' ');
        } else {
            if (this.isNewSavepointLevel) {
                sb.append("NEW");
            } else {
                sb.append("OLD");
            }
            sb.append(' ').append("SAVEPOINT").append(' ');
            sb.append("LEVEL").append(' ');
            if (this.maxDynamicResults != 0) {
                sb.append(' ').append("DYNAMIC").append(' ');
                sb.append("RESULT").append(' ').append("SETS");
                sb.append(' ').append(this.maxDynamicResults).append(' ');
            }
        }
        if (this.language == 1) {
            sb.append("EXTERNAL").append(' ').append("NAME");
            sb.append(' ').append('\'').append(this.methodName).append('\'');
        } else if (withBody) {
            sb.append(this.statement.getSQL());
        } else {
            sb.append("SIGNAL").append(' ');
            sb.append("SQLSTATE").append(' ');
            sb.append('\'').append("45000").append('\'');
        }
        return sb.toString();
    }

    public String getSQLBodyDefinition() {
        StringBuilder sb = new StringBuilder();
        if (this.language == 1) {
            sb.append("EXTERNAL").append(' ').append("NAME");
            sb.append(' ').append('\'').append(this.methodName).append('\'');
        } else {
            sb.append(this.statement.getSQL());
        }
        return sb.toString();
    }

    public String getExternalName() {
        if (this.language == 1) {
            return this.methodName;
        }
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void addParameter(ColumnSchema param) {
        HsqlNameManager.HsqlName name = param.getName();
        String paramName = name == null ? HsqlNameManager.getAutoNoNameColumnString(this.parameterList.size()) : name.name;
        boolean result = this.parameterList.add(paramName, param);
        if (!result) {
            throw Error.error(5614);
        }
    }

    public void setLanguage(int lang) {
        this.language = lang;
    }

    public int getLanguage() {
        return this.language;
    }

    boolean isPSM() {
        return this.language == 2;
    }

    public void setDataImpact(int impact) {
        this.dataImpact = impact;
    }

    public int getDataImpact() {
        return this.dataImpact;
    }

    public String getDataImpactString() {
        StringBuilder sb = new StringBuilder();
        switch (this.dataImpact) {
            case 1: {
                sb.append("NO").append(' ').append("SQL");
                break;
            }
            case 2: {
                sb.append("CONTAINS").append(' ').append("SQL");
                break;
            }
            case 3: {
                sb.append("READS").append(' ').append("SQL").append(' ').append("DATA");
                break;
            }
            case 4: {
                sb.append("MODIFIES").append(' ').append("SQL").append(' ').append("DATA");
            }
        }
        return sb.toString();
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Table getTable() {
        return this.returnTable;
    }

    public void setProcedure(Statement statement) {
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(HsqlNameManager.HsqlName name) {
        this.specificName = name;
    }

    public int getMaxDynamicResults() {
        return this.maxDynamicResults;
    }

    public void setName(HsqlNameManager.HsqlName name) {
        this.name = name;
    }

    public HsqlNameManager.HsqlName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean value) {
        this.isDeterministic = value;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNullInputOutput(boolean value) {
        this.isNullInputOutput = value;
    }

    public boolean isNullInputOutput() {
        return this.isNullInputOutput;
    }

    public void setNewSavepointLevel(boolean value) {
        this.isNewSavepointLevel = value;
    }

    public void setMaxDynamicResults(int value) {
        this.maxDynamicResults = value;
    }

    public void setParameterStyle(int style) {
        this.parameterStyle = style;
    }

    public void setMethodURL(String url) {
        this.methodName = url;
    }

    public Method getMethod() {
        return this.javaMethod;
    }

    public void setMethod(Method method) {
        this.javaMethod = method;
    }

    public void setReturnTable(TableDerived table) {
        this.returnTable = table;
        this.returnsTable = true;
        HsqlNameManager.SimpleName[] names = new HsqlNameManager.SimpleName[table.getColumnCount()];
        Type[] types = table.getColumnTypes();
        this.returnType = new RowType(types);
    }

    public boolean returnsTable() {
        return this.returnsTable;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void resolve(Session session) {
        ColumnSchema param;
        this.setLanguage(this.language);
        if (this.language == 2) {
            if (this.dataImpact == 1) {
                throw Error.error(5604, "CONTAINS SQL");
            }
            if (this.parameterStyle == 1) {
                throw Error.error(5604, "PARAMETER STYLE");
            }
        }
        if (this.language == 2 && this.parameterStyle != 0 && this.parameterStyle != 2) {
            throw Error.error(5604, "PARAMETER STYLE");
        }
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            param = (ColumnSchema)this.parameterList.get(i);
            this.parameterTypes[i] = param.dataType;
            if (i >= 4) continue;
            this.typeGroups = BitMap.setByte(this.typeGroups, (byte)param.dataType.typeComparisonGroup, i * 8);
        }
        if (this.isAggregate) {
            if (this.parameterTypes.length != 4) {
                throw Error.error(5610);
            }
            boolean check = this.parameterTypes[1].typeCode == 16;
            param = (ColumnSchema)this.parameterList.get(0);
            check &= param.getParameterMode() == 1;
            param = (ColumnSchema)this.parameterList.get(1);
            check &= param.getParameterMode() == 1;
            param = (ColumnSchema)this.parameterList.get(2);
            check &= param.getParameterMode() == 2;
            param = (ColumnSchema)this.parameterList.get(3);
            if (!(check &= param.getParameterMode() == 2)) {
                throw Error.error(5610);
            }
        }
        this.resolveReferences(session);
    }

    void resolveReferences(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.checkSQLData(session);
        }
        if (this.methodName != null && this.javaMethod == null) {
            boolean[] hasConnection = new boolean[1];
            this.javaMethod = Routine.getMethod(this.methodName, this, hasConnection, this.returnsTable);
            if (this.javaMethod == null) {
                throw Error.error(6013);
            }
            this.javaMethodWithConnection = hasConnection[0];
            String className = this.javaMethod.getDeclaringClass().getName();
            if (className.equals("java.lang.Math")) {
                this.isLibraryRoutine = true;
            }
        }
        this.setReferences();
    }

    private void setReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            OrderedHashSet refs = param.getReferences();
            if (refs == null) continue;
            set.addAll(refs);
        }
        if (this.statement != null) {
            set.addAll(this.statement.getReferences());
        }
        this.isRecursive = false;
        if (set.contains(this.getSpecificName())) {
            set.remove(this.getSpecificName());
            this.isRecursive = true;
        }
        this.references = set;
    }

    void checkSQLData(Session session) {
        OrderedHashSet set = this.statement.getReferences();
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.type != 24) continue;
            Routine routine = (Routine)session.database.schemaManager.getSchemaObject(name);
            if (routine.dataImpact == 3) {
                if (this.dataImpact != 2) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
            if (routine.dataImpact != 4 || this.dataImpact != 2 && this.dataImpact != 3) continue;
            throw Error.error(5608, "MODIFIES SQL DATA");
        }
        if (this.dataImpact == 2 || this.dataImpact == 3) {
            HsqlNameManager.HsqlName[] names = this.statement.getTableNamesForWrite();
            for (int i = 0; i < names.length; ++i) {
                if (names[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "MODIFIES SQL DATA");
            }
        }
        if (this.dataImpact == 2) {
            HsqlNameManager.HsqlName[] names = this.statement.getTableNamesForRead();
            for (int i = 0; i < names.length; ++i) {
                if (names[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
        }
    }

    public boolean isTrigger() {
        return this.routineType == 8;
    }

    public boolean isProcedure() {
        return this.routineType == 17;
    }

    public boolean isFunction() {
        return this.routineType == 16;
    }

    public ColumnSchema getParameter(int i) {
        return (ColumnSchema)this.parameterList.get(i);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public int getParameterCount(int type) {
        int count = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema col = (ColumnSchema)this.parameterList.get(i);
            if (col.getParameterMode() != type) continue;
            ++count;
        }
        return count;
    }

    public int getParameterIndex(String name) {
        return this.parameterList.getIndex(name);
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.ranges;
    }

    @Override
    public void setCorrelated() {
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public int getCursorCount() {
        return this.cursorCount;
    }

    public boolean isLibraryRoutine() {
        return this.isLibraryRoutine;
    }

    public HsqlNameManager.HsqlName[] getTableNamesForRead() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    public void resetAlteredRoutineSettings() {
        if (this.isPSM()) {
            this.methodName = null;
            this.javaMethod = null;
            this.javaMethodWithConnection = false;
            this.parameterStyle = 2;
            if (this.dataImpact == 1) {
                this.dataImpact = 2;
            }
        } else {
            this.statement = null;
            this.references = null;
            this.variableCount = 0;
            this.cursorCount = 0;
            this.ranges = RangeVariable.emptyArray;
        }
    }

    public void setAsAlteredRoutine(Routine routine) {
        this.language = routine.language;
        this.dataImpact = routine.dataImpact;
        this.parameterStyle = routine.parameterStyle;
        this.isDeterministic = routine.isDeterministic;
        this.isNullInputOutput = routine.isNullInputOutput;
        this.maxDynamicResults = routine.maxDynamicResults;
        this.isRecursive = routine.isRecursive;
        this.javaMethod = routine.javaMethod;
        this.isRecursive = routine.isRecursive;
        this.javaMethodWithConnection = routine.javaMethodWithConnection;
        this.methodName = routine.methodName;
        this.statement = routine.statement;
        this.references = routine.references;
        this.variableCount = routine.variableCount;
        this.cursorCount = routine.cursorCount;
        this.ranges = routine.ranges;
    }

    Object[] convertArgsToJava(Session session, Object[] callArguments) {
        int i;
        int extraArg = this.javaMethodWithConnection ? 1 : 0;
        Object[] data = new Object[this.javaMethod.getParameterTypes().length];
        Type[] types = this.getParameterTypes();
        for (i = 0; i < types.length; ++i) {
            Object value = callArguments[i];
            ColumnSchema param = this.getParameter(i);
            if (param.parameterMode == 1) {
                data[i + extraArg] = types[i].convertSQLToJava(session, value);
                continue;
            }
            Object jdbcValue = types[i].convertSQLToJava(session, value);
            Class cl = types[i].getJDBCClass();
            Object array = Array.newInstance(cl, 1);
            Array.set(array, 0, jdbcValue);
            data[i + extraArg] = array;
        }
        while (i + extraArg < data.length) {
            data[i + extraArg] = new ResultSet[1];
            ++i;
        }
        return data;
    }

    void convertArgsToSQL(Session session, Object[] callArguments, Object[] data) {
        int i;
        int extraArg = this.javaMethodWithConnection ? 1 : 0;
        Type[] types = this.getParameterTypes();
        for (i = 0; i < types.length; ++i) {
            Object value = data[i + extraArg];
            ColumnSchema param = this.getParameter(i);
            if (param.parameterMode != 1) {
                value = Array.get(value, 0);
            }
            callArguments[i] = types[i].convertJavaToSQL(session, value);
        }
        Result head = null;
        while (i + extraArg < data.length) {
            ResultSet rs = ((ResultSet[])data[i + extraArg])[0];
            if (rs != null) {
                if (rs instanceof JDBCResultSet) {
                    Result r = ((JDBCResultSet)rs).result;
                    if (head == null) {
                        callArguments[i] = r;
                        head = r;
                    } else {
                        head.addChainedResult(r);
                    }
                } else {
                    throw Error.error(6000, "ResultSet not native");
                }
            }
            ++i;
        }
    }

    public Result invokeJavaMethodDirect(Object[] data) {
        Result result;
        try {
            Object returnValue = this.javaMethod.invoke(null, data);
            returnValue = this.returnType.convertJavaToSQL(null, returnValue);
            result = Result.newPSMResult(returnValue);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(Error.error(t, 6000, this.getName().name));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Result invokeJavaMethod(Session session, Object[] data) {
        Result result;
        HsqlNameManager.HsqlName oldSessionSchema = session.getCurrentSchemaHsqlName();
        try {
            if (this.dataImpact == 1) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
                session.setNoSQL();
            } else if (this.dataImpact == 2) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            } else if (this.dataImpact == 3) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            }
            session.setCurrentSchemaHsqlName(this.getSchemaName());
            Object returnValue = this.javaMethod.invoke(null, data);
            if (this.returnsTable()) {
                if (!(returnValue instanceof JDBCResultSet)) throw Error.runtimeError(201, "FunctionSQLInvoked");
                result = ((JDBCResultSet)returnValue).result;
            } else {
                returnValue = this.returnType.convertJavaToSQL(session, returnValue);
                result = Result.newPSMResult(returnValue);
            }
        }
        catch (InvocationTargetException e) {
            result = Result.newErrorResult(Error.error(e, 6000, this.getName().name));
        }
        catch (IllegalAccessException e) {
            result = Result.newErrorResult(Error.error(e, 6000, this.getName().name));
        }
        catch (Throwable e) {
            result = Result.newErrorResult(Error.error(e, 6000, this.getName().name));
        }
        session.setCurrentSchemaHsqlName(oldSessionSchema);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Result invoke(Session session, Object[] data, Object[] aggregateData, boolean push) {
        if (push) {
            session.sessionContext.pushRoutineInvocation();
        }
        if (this.isPSM()) {
            try {
                session.sessionContext.routineArguments = data;
                session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
                if (this.variableCount > 0) {
                    session.sessionContext.routineVariables = new Object[this.variableCount];
                }
                session.sessionContext.routineCursors = Result.emptyArray;
                if (this.cursorCount > 0) {
                    session.sessionContext.routineCursors = new Result[this.cursorCount];
                }
                result = this.statement.execute(session);
                if (aggregateData == null) ** GOTO lbl30
                for (i = 0; i < aggregateData.length; ++i) {
                    aggregateData[i] = data[i + 1];
                }
            }
            catch (Throwable e) {
                result = Result.newErrorResult(e);
            }
        } else {
            if (this.isAggregate) {
                data = this.convertArgsToJava(session, data);
            }
            result = this.invokeJavaMethod(session, data);
            if (this.isAggregate) {
                callResult = new Object[data.length];
                this.convertArgsToSQL(session, callResult, data);
                for (i = 0; i < aggregateData.length; ++i) {
                    aggregateData[i] = callResult[i + 1];
                }
            }
        }
lbl30:
        // 6 sources

        if (push) {
            session.sessionContext.popRoutineInvocation();
        }
        return result;
    }

    public Routine duplicate() {
        try {
            return (Routine)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Error.runtimeError(201, "Type");
        }
    }

    static Method getMethod(String name, Routine routine, boolean[] hasConnection, boolean returnsTable) {
        int i = name.indexOf(58);
        if (i != -1) {
            if (!name.substring(0, i).equals("CLASSPATH")) {
                throw Error.error(6012, name);
            }
            name = name.substring(i + 1);
        }
        Method[] methods = Routine.getMethods(name);
        int firstMismatch = -1;
        for (i = 0; i < methods.length; ++i) {
            int j;
            int offset = 0;
            hasConnection[0] = false;
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (params.length > 0 && params[0].equals(Connection.class)) {
                offset = 1;
                hasConnection[0] = true;
            }
            int matchedParamCount = params.length - offset;
            if (routine.isProcedure()) {
                for (j = offset; j < params.length; ++j) {
                    if (!params[j].isArray() || !ResultSet.class.isAssignableFrom(params[j].getComponentType())) continue;
                    matchedParamCount = j - offset;
                    break;
                }
            }
            if (matchedParamCount != routine.parameterTypes.length) continue;
            if (returnsTable) {
                if (!ResultSet.class.isAssignableFrom(method.getReturnType())) {
                    continue;
                }
            } else {
                Type methodReturnType = Types.getParameterSQLType(method.getReturnType());
                if (methodReturnType == null || !routine.returnType.canBeAssignedFrom(methodReturnType)) continue;
                if (methodReturnType.isLobType() || !methodReturnType.isBinaryType() && !methodReturnType.isCharacterType()) {
                    int routineRetType = routine.returnType.typeCode;
                    if (routineRetType == 2) {
                        routineRetType = 3;
                    }
                    if (methodReturnType.typeCode != routineRetType) continue;
                }
            }
            for (j = 0; j < routine.parameterTypes.length; ++j) {
                boolean result;
                Type methodParamType;
                boolean isInOut = false;
                Class<?> param = params[j + offset];
                if (param.isArray() && !byte[].class.equals(param)) {
                    if ((param = param.getComponentType()).isPrimitive()) {
                        method = null;
                        break;
                    }
                    isInOut = true;
                }
                if ((methodParamType = Types.getParameterSQLType(param)) == null) {
                    method = null;
                    break;
                }
                boolean bl = result = routine.parameterTypes[j].typeComparisonGroup == methodParamType.typeComparisonGroup;
                if (result && routine.parameterTypes[j].isNumberType()) {
                    int routineParamType = routine.parameterTypes[j].typeCode;
                    if (routineParamType == 2) {
                        routineParamType = 3;
                    }
                    boolean bl2 = result = routineParamType == methodParamType.typeCode;
                }
                if (isInOut && routine.getParameter((int)j).parameterMode == 1) {
                    result = false;
                }
                if (result) continue;
                method = null;
                if (j + offset <= firstMismatch) break;
                firstMismatch = j + offset;
                break;
            }
            if (method == null) continue;
            for (j = 0; j < routine.parameterTypes.length; ++j) {
                routine.getParameter(j).setNullable(!params[j + offset].isPrimitive());
            }
            return method;
        }
        if (firstMismatch >= 0) {
            ColumnSchema param = routine.getParameter(firstMismatch);
            throw Error.error(6021, param.getNameString());
        }
        return null;
    }

    static Method[] getMethods(String name) {
        Class<?> cl;
        int i = name.lastIndexOf(46);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        String className = name.substring(0, i);
        String methodname = name.substring(i + 1);
        Method[] methods = null;
        if (!HsqlDatabaseProperties.supportsJavaMethod(name)) {
            throw Error.error(5501, className);
        }
        try {
            cl = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t1) {
            try {
                cl = Class.forName(className);
            }
            catch (Throwable t) {
                throw Error.error(t, 5501, 26, new String[]{t.toString(), className});
            }
        }
        try {
            methods = cl.getMethods();
        }
        catch (Throwable t) {
            throw Error.error(t, 5501, 26, new String[]{t.toString(), className});
        }
        HsqlArrayList<Method> list = new HsqlArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            int offset = 0;
            int endIndex = Integer.MAX_VALUE;
            Method method = methods[i];
            int modifiers = method.getModifiers();
            if (!method.getName().equals(methodname) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            Class<?>[] params = methods[i].getParameterTypes();
            if (params.length > 0 && params[0].equals(Connection.class)) {
                offset = 1;
            }
            for (int j = offset; j < params.length; ++j) {
                Type methodParamType;
                Class<?> param = params[j];
                if (param.isArray()) {
                    if (!byte[].class.equals(param)) {
                        if ((param = param.getComponentType()).isPrimitive()) {
                            method = null;
                            break;
                        }
                        if (ResultSet.class.isAssignableFrom(param) && endIndex > j) {
                            endIndex = j;
                        }
                    }
                    if (j >= endIndex) {
                        if (ResultSet.class.isAssignableFrom(param)) continue;
                        method = null;
                        break;
                    }
                } else if (j > endIndex) {
                    method = null;
                    break;
                }
                if ((methodParamType = Types.getParameterSQLType(param)) != null) continue;
                method = null;
                break;
            }
            if (method == null) continue;
            if (ResultSet.class.isAssignableFrom(method.getReturnType())) {
                list.add(methods[i]);
                continue;
            }
            Type methodReturnType = Types.getParameterSQLType(method.getReturnType());
            if (methodReturnType == null) continue;
            list.add(methods[i]);
        }
        methods = new Method[list.size()];
        list.toArray(methods);
        return methods;
    }

    public static Routine[] newRoutines(Session session, Method[] methods) {
        Routine[] routines = new Routine[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            routines[i] = Routine.newRoutine(session, method);
        }
        return routines;
    }

    public static Routine newRoutine(Session session, Method method) {
        Routine routine = new Routine(16);
        int offset = 0;
        Class<?>[] params = method.getParameterTypes();
        String className = method.getDeclaringClass().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("CLASSPATH:");
        sb.append(method.getDeclaringClass().getName()).append('.');
        sb.append(method.getName());
        if (params.length > 0 && params[0].equals(Connection.class)) {
            offset = 1;
        }
        String name = sb.toString();
        if (className.equals("java.lang.Math")) {
            routine.isLibraryRoutine = true;
        }
        for (int j = offset; j < params.length; ++j) {
            Type methodParamType = Types.getParameterSQLType(params[j]);
            HsqlNameManager.HsqlName colName = session.database.nameManager.newHsqlName("C" + (j - offset + 1), false, 23);
            ColumnSchema param = new ColumnSchema(colName, methodParamType, !params[j].isPrimitive(), false, null);
            routine.addParameter(param);
        }
        routine.setLanguage(1);
        routine.setMethod(method);
        routine.setMethodURL(name);
        routine.setDataImpact(1);
        Type methodReturnType = Types.getParameterSQLType(method.getReturnType());
        routine.javaMethodWithConnection = offset == 1;
        routine.setReturnType(methodReturnType);
        routine.resolve(session);
        return routine;
    }

    public static void createRoutines(Session session, HsqlNameManager.HsqlName schema, String name) {
        Method[] methods = Routine.getMethods(name);
        Routine[] routines = Routine.newRoutines(session, methods);
        HsqlNameManager.HsqlName routineName = session.database.nameManager.newHsqlName(schema, name, true, 16);
        for (int i = 0; i < routines.length; ++i) {
            if (routines[i].getReturnType() == Type.SQL_ALL_TYPES) continue;
            routines[i].setName(routineName);
            session.database.schemaManager.addSchemaObject(routines[i]);
        }
    }
}

