/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class RoutineSchema
implements SchemaObject {
    static RoutineSchema[] emptyArray = new RoutineSchema[0];
    Routine[] routines = Routine.emptyArray;
    int routineType;
    private HsqlNameManager.HsqlName name;

    public RoutineSchema(int type, HsqlNameManager.HsqlName name) {
        this.routineType = type;
        this.name = name;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getReferences());
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet<Routine> set = new OrderedHashSet<Routine>();
        set.addAll(this.routines);
        return set;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray() {
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        for (int i = 0; i < this.routines.length; ++i) {
            list.add(this.routines[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void addSpecificRoutine(HsqlNameManager nameManager, Routine routine, boolean replace) {
        int signature = routine.getParameterSignature();
        Type[] types = routine.getParameterTypes();
        int matchPosition = this.routines.length;
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (this.routineType == 17 && !replace) {
                throw Error.error(5605);
            }
            if (this.routines[i].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean match = true;
            for (int j = 0; j < types.length; ++j) {
                if (this.routines[i].parameterTypes[j].equals(types[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (replace) {
                routine.setSpecificName(this.routines[i].getSpecificName());
                matchPosition = i;
                break;
            }
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            HsqlNameManager.HsqlName specificName = nameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(specificName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        if (matchPosition == this.routines.length) {
            this.routines = (Routine[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        }
        this.routines[matchPosition] = routine;
    }

    public void removeSpecificRoutine(Routine routine) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i] != routine) continue;
            this.routines = (Routine[])ArrayUtil.toAdjustedArray(this.routines, null, i, -1);
            break;
        }
    }

    public Routine[] getSpecificRoutines() {
        return this.routines;
    }

    public Routine getSpecificRoutine(Type[] types) {
        Routine routine = this.findSpecificRoutine(types);
        if (routine == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append("(");
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                if (types[i] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(types[i].getNameString());
            }
            sb.append(")");
            throw Error.error(5609, sb.toString());
        }
        return routine;
    }

    public Routine findSpecificRoutine(Type[] types) {
        int matchIndex = -1;
        block0: for (int i = 0; i < this.routines.length; ++i) {
            int j;
            int newDiff;
            int oldDiff;
            int matchCount = 0;
            if (this.routines[i].isAggregate() && types.length == 1) {
                if (types[0] == null) {
                    return this.routines[i];
                }
                int typeDifference = types[0].precedenceDegree(this.routines[i].parameterTypes[0]);
                if (typeDifference < -128) {
                    if (matchIndex == -1 || (oldDiff = types[0].precedenceDegree(this.routines[matchIndex].parameterTypes[0])) == (newDiff = types[0].precedenceDegree(this.routines[i].parameterTypes[0])) || newDiff >= oldDiff) continue;
                    matchIndex = i;
                    continue;
                }
                if (typeDifference == 0) {
                    return this.routines[i];
                }
                matchIndex = i;
                continue;
            }
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (types.length == 0) {
                return this.routines[i];
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null) continue;
                int typeDifference = types[j].precedenceDegree(this.routines[i].parameterTypes[j]);
                if (typeDifference < -128) continue block0;
                if (typeDifference != 0 || matchCount != j) continue;
                matchCount = j + 1;
            }
            if (matchCount == types.length) {
                return this.routines[i];
            }
            if (matchIndex == -1) {
                matchIndex = i;
                continue;
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null || (oldDiff = types[j].precedenceDegree(this.routines[matchIndex].parameterTypes[j])) == (newDiff = types[j].precedenceDegree(this.routines[i].parameterTypes[j]))) continue;
                if (newDiff >= oldDiff) continue block0;
                matchIndex = i;
                continue block0;
            }
        }
        return matchIndex < 0 ? null : this.routines[matchIndex];
    }

    public Routine getSpecificRoutine(int paramCount) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != paramCount) continue;
            return this.routines[i];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }
}

