/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;

public class Row
implements CachedObject {
    long position;
    Object[] rowData;
    public volatile RowAction rowAction;
    protected TableBase table;

    public RowAction getAction() {
        return this.rowAction;
    }

    public Row(TableBase table, Object[] data) {
        this.table = table;
        this.rowData = data;
    }

    public Object getField(int col) {
        return this.rowData[col];
    }

    public Object[] getData() {
        return this.rowData;
    }

    public Object[] getDataCopy() {
        Object[] newData = new Object[this.rowData.length];
        Object[] data = this.getData();
        System.arraycopy(data, 0, newData, 0, data.length);
        return newData;
    }

    boolean isDeleted(Session session, PersistentStore store) {
        Row row = (Row)store.get((CachedObject)this, false);
        if (row == null) {
            return true;
        }
        RowAction action = row.rowAction;
        if (action == null) {
            return false;
        }
        return !action.canRead(session, 0);
    }

    public TimestampData getSystemStartVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData ts = (TimestampData)this.getField(((Table)this.table).systemPeriodStartColumn);
            return ts;
        }
        return DateTimeType.epochTimestamp;
    }

    public TimestampData getSystemEndVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData ts = (TimestampData)this.getField(((Table)this.table).systemPeriodEndColumn);
            return ts;
        }
        return DateTimeType.epochLimitTimestamp;
    }

    public boolean isCurrentSystemVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData ts = (TimestampData)this.getField(((Table)this.table).systemPeriodEndColumn);
            return DateTimeType.epochLimitSeconds == ts.getSeconds();
        }
        return true;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public final boolean isInvariable() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return false;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public long getPos() {
        return this.position;
    }

    public long getId() {
        return ((long)this.table.getId() << 40) + this.position;
    }

    @Override
    public void setPos(long pos) {
        this.position = pos;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean flag) {
    }

    @Override
    public boolean isKeepInMemory() {
        return true;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return true;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    public void delete(PersistentStore store) {
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 0;
    }

    public TableBase getTable() {
        return this.table;
    }

    @Override
    public int getDefaultCapacity() {
        return 0;
    }

    @Override
    public void read(RowInputInterface in) {
    }

    @Override
    public void write(RowOutputInterface out) {
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Row) {
            return ((Row)obj).table == this.table && ((Row)obj).position == this.position;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.position;
    }
}

