/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    volatile boolean isInMemory;
    boolean isNew;
    boolean isFromFile;
    boolean hasDataChanged;
    private boolean hasNodesChanged;

    public RowAVLDisk(TableBase t, Object[] o, PersistentStore store) {
        super(t, o);
        this.setNewNodes(store);
        this.isNew = true;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(PersistentStore store, RowInputInterface in) {
        super(store.getTable(), null);
        this.position = in.getFilePosition();
        this.storageSize = in.getSize();
        int indexcount = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, in, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, in, i);
        }
        this.rowData = in.readData(this.table.getColumnTypes());
        this.isFromFile = true;
    }

    RowAVLDisk(TableBase t) {
        super(t, null);
    }

    @Override
    public NodeAVL insertNode(int index) {
        return null;
    }

    private void readRowInfo(RowInputInterface in) {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void setPos(long pos) {
        this.position = pos;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    @Override
    public synchronized void setChanged(boolean flag) {
        this.hasNodesChanged = flag;
        this.hasDataChanged = flag;
        this.isNew = flag;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public void delete(PersistentStore store) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public synchronized boolean keepInMemory(boolean keep) {
        if (!this.isInMemory) {
            return false;
        }
        if (keep) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public synchronized void setInMemory(boolean in) {
        this.isInMemory = in;
    }

    @Override
    public void setNewNodes(PersistentStore store) {
        int indexcount = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, i);
        }
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    @Override
    public void write(RowOutputInterface out) {
        this.writeNodes(out);
        if (this.hasDataChanged) {
            out.writeData(this, this.table.colTypes);
            out.writeEnd();
        }
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        out.writeSize(this.storageSize);
        NodeAVL rownode = this.nPrimaryNode;
        while (rownode != null) {
            rownode.write(out, lookup);
            rownode = rownode.nNext;
        }
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
    }

    void writeNodes(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.write(out);
            n = n.nNext;
        }
    }
}

