/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDiskData
extends RowAVL {
    RowStoreAVLDiskData store;
    int accessCount;
    boolean hasDataChanged;
    int storageSize;

    public RowAVLDiskData(PersistentStore store, TableBase t, Object[] o) {
        super(t, o);
        this.setNewNodes(store);
        this.store = (RowStoreAVLDiskData)store;
        this.hasDataChanged = true;
    }

    public RowAVLDiskData(RowStoreAVLDiskData store, TableBase t, RowInputInterface in) {
        super(t, null);
        this.setNewNodes(store);
        this.position = in.getFilePosition();
        this.storageSize = in.getSize();
        this.rowData = in.readData(this.table.getColumnTypes());
        this.store = store;
    }

    public void setData(Object[] data) {
        this.rowData = data;
    }

    @Override
    public Object[] getData() {
        Object[] data = this.rowData;
        if (data == null) {
            this.rowData = this.store.getData(this);
            data = this.rowData;
        }
        this.accessCount = this.store.getNextAccessCount();
        return data;
    }

    @Override
    public void setNewNodes(PersistentStore store) {
        int index = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = new NodeAVL(this);
        }
    }

    @Override
    public NodeAVL insertNode(int index) {
        NodeAVL backnode = this.getNode(index - 1);
        NodeAVL newnode = new NodeAVL(this);
        newnode.nNext = backnode.nNext;
        backnode.nNext = newnode;
        return newnode;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    @Override
    public synchronized void setChanged(boolean flag) {
        this.hasDataChanged = flag;
    }

    @Override
    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public void setPos(long pos) {
        this.position = pos;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public boolean isInMemory() {
        return this.rowData != null;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return true;
    }

    @Override
    public void setInMemory(boolean in) {
        if (!in) {
            this.rowData = null;
        }
    }
}

