/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.PersistentStore;

public class RowAction
extends RowActionBase {
    final TableBase table;
    final PersistentStore store;
    final Row memoryRow;
    final long rowId;
    RowAction updatedAction;

    public static RowAction addInsertAction(Session session, TableBase table, PersistentStore store, Row row) {
        RowAction action;
        row.rowAction = action = new RowAction(session, table, store, 1, row, null);
        return action;
    }

    public static RowAction addDeleteAction(Session session, TableBase table, PersistentStore store, Row row, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            row.rowAction = action = new RowAction(session, table, store, 2, row, colMap);
            return action;
        }
        return action.addDeleteAction(session, colMap);
    }

    public static boolean addRefAction(Session session, Row row, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            row.rowAction = action = new RowAction(session, row.getTable(), null, 5, row, colMap);
            return true;
        }
        return action.addRefAction(session, colMap);
    }

    public RowAction(Session session, TableBase table, PersistentStore store, byte type, Row row, int[] colMap) {
        this.session = session;
        this.type = type;
        this.actionSCN = session.actionSCN;
        this.table = table;
        this.store = store;
        this.memoryRow = row;
        this.rowId = row.getPos();
        this.changeColumnMap = colMap;
    }

    public synchronized int getType() {
        return this.type;
    }

    synchronized RowAction addDeleteAction(Session session, int[] colMap) {
        if (this.type == 0) {
            this.setNoOpAsAction(session, (byte)2);
            this.changeColumnMap = colMap;
        } else {
            RowActionBase action = this;
            while (true) {
                if (action.rolledback) {
                    if (action.next == null) break;
                    action = action.next;
                    continue;
                }
                switch (action.type) {
                    case 1: {
                        if (action.commitSCN != 0L || session == action.session) break;
                        throw Error.runtimeError(201, "RowAction");
                    }
                    case 2: 
                    case 3: {
                        if (session == action.session) break;
                        if (action.commitSCN == 0L) {
                            if (!session.actionSet.isEmpty()) {
                                session.actionSet.clear();
                            }
                            session.actionSet.add(action);
                        }
                        return null;
                    }
                    case 5: {
                        if (session == action.session || action.commitSCN != 0L || colMap != null && !ArrayUtil.haveCommonElement(colMap, action.changeColumnMap)) break;
                        if (!session.actionSet.isEmpty()) {
                            session.actionSet.clear();
                        }
                        session.actionSet.add(action);
                        return null;
                    }
                }
                if (action.next == null) break;
                action = action.next;
            }
            RowActionBase newAction = new RowActionBase(session, 2);
            newAction.changeColumnMap = colMap;
            action.next = newAction;
        }
        return this;
    }

    synchronized boolean addRefAction(Session session, int[] colMap) {
        if (this.type == 0) {
            this.setNoOpAsAction(session, (byte)5);
            this.changeColumnMap = colMap;
            return true;
        }
        RowActionBase action = this;
        while (true) {
            if (session == action.session) {
                if (action.type == 5 && action.changeColumnMap == colMap && action.commitSCN == 0L) {
                    return false;
                }
                if (action.type == 1 && action.commitSCN == 0L) {
                    return false;
                }
            } else if (action.type == 2 && action.commitSCN == 0L && (action.changeColumnMap == null || ArrayUtil.haveCommonElement(colMap, action.changeColumnMap))) {
                if (!session.actionSet.isEmpty()) {
                    session.actionSet.clear();
                }
                session.actionSet.add(action);
                return false;
            }
            if (action.next == null) break;
            action = action.next;
        }
        RowActionBase newAction = new RowActionBase(session, 5);
        newAction.changeColumnMap = colMap;
        action.next = newAction;
        return true;
    }

    synchronized void setNoOpAsAction(Session session, byte type) {
        this.session = session;
        this.type = type;
        this.actionSCN = session.actionSCN;
    }

    @Override
    synchronized void setAsAction(RowActionBase action) {
        super.setAsAction(action);
    }

    synchronized void setAsNoOp() {
        this.session = null;
        this.type = 0;
        this.actionSCN = 0L;
        this.commitSCN = 0L;
        this.rolledback = false;
        this.deleteComplete = false;
        this.prepared = false;
        this.changeColumnMap = null;
        this.next = null;
    }

    private void setAsDeleteFinal(long timestamp) {
        this.type = (byte)3;
        this.actionSCN = 0L;
        this.commitSCN = timestamp;
        this.rolledback = false;
        this.deleteComplete = false;
        this.prepared = false;
        this.changeColumnMap = null;
        this.next = null;
    }

    synchronized void prepareCommit(Session session) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitSCN != 0L) continue;
            action.prepared = true;
        } while ((action = action.next) != null);
    }

    synchronized int commit(Session session) {
        RowActionBase action = this;
        int actiontype = 0;
        do {
            if (action.session != session || action.commitSCN != 0L) continue;
            action.commitSCN = session.actionSCN;
            action.prepared = false;
            if (action.type == 1) {
                actiontype = action.type;
                continue;
            }
            if (action.type != 2) continue;
            actiontype = actiontype == 1 ? 4 : (int)action.type;
        } while ((action = action.next) != null);
        return actiontype;
    }

    public boolean isDeleted() {
        RowActionBase action = this;
        do {
            if (action.commitSCN == 0L || action.type != 2 && action.type != 3) continue;
            return true;
        } while ((action = action.next) != null);
        return false;
    }

    public boolean isDeleteComplete() {
        return this.deleteComplete;
    }

    public synchronized void setDeleteComplete() {
        this.deleteComplete = true;
    }

    synchronized int getCommitTypeOn(long timestamp) {
        RowActionBase action = this;
        int actionType = 0;
        do {
            if (action.commitSCN != timestamp) continue;
            if (action.type == 1) {
                actionType = action.type;
                continue;
            }
            if (action.type != 2) continue;
            actionType = actionType == 1 ? 4 : (int)action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    synchronized boolean canCommit(Session session) {
        long timestamp = session.transactionSCN;
        long commitTimestamp = 0L;
        boolean readCommitted = session.isolationLevel == 2;
        boolean hasDelete = false;
        RowActionBase action = this;
        if (readCommitted) {
            do {
                if (action.session != session || action.type != 2 || action.commitSCN != 0L) continue;
                timestamp = action.actionSCN;
            } while ((action = action.next) != null);
            action = this;
        }
        do {
            if (action.session == session) {
                if (action.type == 2) {
                    hasDelete = true;
                }
            } else {
                if (action.rolledback || action.type != 2) {
                    action = action.next;
                    continue;
                }
                if (action.prepared) {
                    return false;
                }
                if (action.commitSCN == 0L) {
                    session.actionSet.add(action);
                } else if (action.commitSCN > commitTimestamp) {
                    commitTimestamp = action.commitSCN;
                }
            }
            action = action.next;
        } while (action != null);
        if (!hasDelete) {
            return true;
        }
        return commitTimestamp < timestamp;
    }

    synchronized boolean complete(Session session, OrderedHashSet set) {
        boolean readCommitted = session.isolationLevel == 2;
        boolean result = true;
        RowActionBase action = this;
        do {
            if (action.rolledback || action.type == 0) {
                action = action.next;
                continue;
            }
            if (action.session != session) {
                if (action.prepared) {
                    set.add(action.session);
                    return false;
                }
                if (readCommitted) {
                    if (action.commitSCN > session.actionSCN) {
                        set.add(session);
                        result = false;
                    } else if (action.commitSCN == 0L) {
                        set.add(action.session);
                        result = false;
                    }
                } else if (action.commitSCN > session.transactionSCN) {
                    return false;
                }
            }
            action = action.next;
        } while (action != null);
        return result;
    }

    public long getPos() {
        return this.rowId;
    }

    public Row getRow() {
        return this.memoryRow;
    }

    private int getRollbackType(Session session) {
        int actionType = 0;
        RowActionBase action = this;
        do {
            if (action.session != session || !action.rolledback) continue;
            if (action.type == 2) {
                if (actionType == 1) {
                    actionType = 4;
                    continue;
                }
                actionType = action.type;
                continue;
            }
            if (action.type != 1) continue;
            actionType = action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    synchronized void rollback(Session session, long timestamp) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitSCN != 0L || action.actionSCN < timestamp) continue;
            action.commitSCN = session.actionSCN;
            action.rolledback = true;
            action.prepared = false;
        } while ((action = action.next) != null);
    }

    synchronized int mergeRollback(Session session, long timestamp) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        int rollbackAction = this.getRollbackType(session);
        do {
            if (action.session == session && action.rolledback) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            switch (rollbackAction) {
                case 1: 
                case 4: {
                    this.setAsDeleteFinal(timestamp);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
        return rollbackAction;
    }

    synchronized void mergeToTimestamp(long timestamp) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        int commitType = this.getCommitTypeOn(timestamp);
        if (this.type == 3 || this.type == 0) {
            return;
        }
        if (commitType == 2 || commitType == 4) {
            this.setAsDeleteFinal(timestamp);
            return;
        }
        do {
            boolean expired = false;
            if (action.commitSCN != 0L) {
                if (action.commitSCN <= timestamp) {
                    expired = true;
                } else if (action.type == 5) {
                    expired = true;
                }
            }
            if (expired) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            switch (commitType) {
                case 2: 
                case 4: {
                    this.setAsDeleteFinal(timestamp);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
        this.mergeExpiredRefActions();
    }

    public synchronized boolean canRead(Session session, int mode) {
        long threshold;
        int actionType = 0;
        if (this.type == 3) {
            return false;
        }
        if (this.type == 0) {
            return true;
        }
        RowActionBase action = this;
        if (session == null) {
            threshold = Long.MAX_VALUE;
        } else {
            switch (session.isolationLevel) {
                case 1: {
                    threshold = Long.MAX_VALUE;
                    break;
                }
                case 2: {
                    threshold = session.actionSCN;
                    break;
                }
                default: {
                    threshold = session.transactionSCN;
                }
            }
        }
        do {
            if (action.type == 5) {
                action = action.next;
                continue;
            }
            if (action.rolledback) {
                if (action.type == 1) {
                    actionType = 2;
                }
                action = action.next;
                continue;
            }
            if (session == action.session) {
                if (action.type == 2) {
                    actionType = action.type;
                } else if (action.type == 1) {
                    actionType = action.type;
                }
                action = action.next;
                continue;
            }
            if (action.commitSCN == 0L) {
                if (action.type == 0) {
                    throw Error.runtimeError(201, "RowAction");
                }
                if (action.type == 1) {
                    if (mode == 0) {
                        actionType = 2;
                        break;
                    }
                    if (mode == 1) {
                        actionType = 1;
                        session.actionSet.clear();
                        session.actionSet.add(action);
                        break;
                    }
                    if (mode != 2) break;
                    actionType = 2;
                    break;
                }
                if (action.type == 2 && mode != 1 && mode == 2) {
                    actionType = 2;
                }
                action = action.next;
                continue;
            }
            if (action.commitSCN < threshold) {
                if (action.type == 2) {
                    actionType = 2;
                } else if (action.type == 1) {
                    actionType = 1;
                }
            } else if (action.type == 1) {
                if (mode == 0) {
                    actionType = 2;
                } else if (mode == 1) {
                    actionType = 1;
                    session.actionSet.clear();
                    session.actionSet.add(action);
                } else if (mode == 2) {
                    actionType = 2;
                }
            }
            action = action.next;
        } while (action != null);
        return actionType == 0 || actionType == 1;
    }

    public boolean hasCurrentRefAction() {
        RowActionBase action = this;
        do {
            if (action.type != 5 || action.commitSCN != 0L) continue;
            return true;
        } while ((action = action.next) != null);
        return false;
    }

    private RowAction mergeExpiredRefActions() {
        if (this.updatedAction != null) {
            this.updatedAction = this.updatedAction.mergeExpiredRefActions();
        }
        if (this.hasCurrentRefAction()) {
            return this;
        }
        return this.updatedAction;
    }

    public synchronized String describe(Session session) {
        StringBuilder sb = new StringBuilder();
        RowActionBase action = this;
        do {
            if (action == this) {
                sb.append(this.rowId).append(' ');
            }
            sb.append(action.session.getId()).append(' ');
            sb.append(action.type).append(' ').append(action.actionSCN);
            sb.append(' ').append(action.commitSCN);
            if (action.commitSCN != 0L) {
                if (action.rolledback) {
                    sb.append('r');
                } else {
                    sb.append('c');
                }
            }
            sb.append(" - ");
        } while ((action = action.next) != null);
        return sb.toString();
    }
}

