/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    static int[] scriptSequenceOne = new int[]{14, 15, 12, 7, 16};
    static int[] scriptSequenceTwo = new int[]{3, 17, 8, 29, 31};
    private HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    SchemaObjectSet referenceLookup;
    SchemaObjectSet conditionLookup;
    SchemaObjectSet moduleLookup;
    OrderedHashMap tableList;
    OrderedHashMap sequenceList;
    OrderedHashMap referenceList;
    long changeTimestamp;

    public Schema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.name = name;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.referenceLookup = new SchemaObjectSet(29);
        this.conditionLookup = new SchemaObjectSet(32);
        this.moduleLookup = new SchemaObjectSet(31);
        this.tableList = (OrderedHashMap)this.tableLookup.map;
        this.sequenceList = (OrderedHashMap)this.sequenceLookup.map;
        this.referenceList = (OrderedHashMap)this.referenceLookup.map;
        name.owner = owner;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("CREATE").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.getName().statementName).append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(this.getOwner().getName().getStatementName());
        return sb.toString();
    }

    String getSetSchemaSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("SET").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.name.statementName);
        return sb.toString();
    }

    static String getCommentSQL(HsqlNameManager.HsqlName name, String typeName) {
        if (name.comment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("COMMENT").append(' ').append("ON");
        sb.append(' ').append(typeName).append(' ');
        sb.append(name.getSchemaQualifiedStatementName());
        sb.append(' ').append("IS").append(' ');
        sb.append(StringConverter.toQuotedString(name.comment, '\'', true));
        return sb.toString();
    }

    public HsqlArrayList getSQLArray(int objectType, OrderedHashSet resolved, OrderedHashSet unresolved) {
        HsqlArrayList list = new HsqlArrayList();
        switch (objectType) {
            case 14: {
                this.charsetLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 15: {
                this.collationLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 12: {
                this.typeLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 7: {
                this.sequenceLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 16: {
                this.functionLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 3: {
                this.tableLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 17: {
                this.procedureLookup.getSQL(list, resolved, unresolved);
                break;
            }
            case 29: {
                this.referenceLookup.getSQL(list, resolved, unresolved);
            }
        }
        return list;
    }

    public HsqlArrayList getSequenceRestartSQL() {
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        Iterator it = this.sequenceLookup.map.values().iterator();
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            String ddl = sequence.getRestartSQL();
            list.add(ddl);
        }
        return list;
    }

    public HsqlArrayList getTriggerSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.tableLookup.map.values().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Object[] ddl = table.getTriggerSQL();
            list.addAll(ddl);
        }
        return list;
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    public SchemaObjectSet getObjectSet(int type) {
        switch (type) {
            case 7: {
                return this.sequenceLookup;
            }
            case 3: 
            case 4: {
                return this.tableLookup;
            }
            case 14: {
                return this.charsetLookup;
            }
            case 15: {
                return this.collationLookup;
            }
            case 17: {
                return this.procedureLookup;
            }
            case 16: {
                return this.functionLookup;
            }
            case 18: {
                return this.functionLookup;
            }
            case 24: {
                return this.specificRoutineLookup;
            }
            case 12: 
            case 13: {
                return this.typeLookup;
            }
            case 6: {
                return this.assertionLookup;
            }
            case 8: {
                return this.triggerLookup;
            }
            case 32: {
                return this.conditionLookup;
            }
            case 31: {
                return this.moduleLookup;
            }
            case 29: {
                return this.referenceLookup;
            }
            case 20: {
                return this.indexLookup;
            }
            case 5: {
                return this.constraintLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    public Iterator schemaObjectIterator(int type) {
        switch (type) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator functions = this.functionLookup.map.values().iterator();
                return new WrapperIterator(functions, this.procedureLookup.map.values().iterator());
            }
            case 24: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 32: {
                return this.conditionLookup.map.values().iterator();
            }
            case 31: {
                return this.moduleLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 29: {
                return this.referenceLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    SchemaObject findAnySchemaObjectForSynonym(String name) {
        int[] types = new int[]{7, 3, 18};
        for (int i = 0; i < types.length; ++i) {
            SchemaObject object = this.findSchemaObject(name, types[i]);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    ReferenceObject findReference(String name, int type) {
        ReferenceObject ref = (ReferenceObject)this.referenceList.get(name);
        if (ref == null) {
            return null;
        }
        int targetType = ref.getTarget().type;
        if (targetType == type) {
            return ref;
        }
        switch (type) {
            case 3: {
                if (targetType != 4) break;
                return ref;
            }
            case 18: {
                if (targetType != 16 && targetType != 17) break;
                return ref;
            }
        }
        return null;
    }

    SchemaObject findSchemaObject(String name, int type) {
        SchemaObjectSet set = null;
        switch (type) {
            case 7: {
                return this.sequenceLookup.getObject(name);
            }
            case 3: 
            case 4: {
                return this.tableLookup.getObject(name);
            }
            case 14: {
                return this.charsetLookup.getObject(name);
            }
            case 15: {
                return this.collationLookup.getObject(name);
            }
            case 17: {
                return this.procedureLookup.getObject(name);
            }
            case 16: {
                return this.functionLookup.getObject(name);
            }
            case 18: {
                SchemaObject object = this.procedureLookup.getObject(name);
                if (object == null) {
                    object = this.functionLookup.getObject(name);
                }
                return object;
            }
            case 24: {
                return this.specificRoutineLookup.getObject(name);
            }
            case 32: {
                return this.conditionLookup.getObject(name);
            }
            case 31: {
                return this.moduleLookup.getObject(name);
            }
            case 12: 
            case 13: {
                return this.typeLookup.getObject(name);
            }
            case 20: {
                set = this.indexLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(objectName.parent.name);
                return table.getIndex(name);
            }
            case 5: {
                set = this.constraintLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(objectName.parent.name);
                if (table == null) {
                    return null;
                }
                return table.getConstraint(name);
            }
            case 8: {
                set = this.triggerLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(objectName.parent.name);
                return table.getTrigger(name);
            }
            case 29: {
                return this.referenceLookup.getObject(name);
            }
        }
        throw Error.runtimeError(201, "SchemaManager");
    }

    public void addSchemaObject(HsqlNameManager nameManager, SchemaObject object, boolean replace) {
        HsqlNameManager.HsqlName name = object.getName();
        SchemaObjectSet set = this.getObjectSet(name.type);
        switch (name.type) {
            case 16: 
            case 17: {
                RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                if (routine == null) {
                    routine = new RoutineSchema(name.type, name);
                    routine.addSpecificRoutine(nameManager, (Routine)object, replace);
                    set.checkAdd(name);
                    SchemaObjectSet specificSet = this.getObjectSet(24);
                    specificSet.checkAdd(((Routine)object).getSpecificName());
                    set.add(routine, replace);
                    specificSet.add(object, replace);
                } else {
                    SchemaObjectSet specificSet = this.getObjectSet(24);
                    HsqlNameManager.HsqlName specificName = ((Routine)object).getSpecificName();
                    if (specificName != null) {
                        specificSet.checkAdd(specificName);
                    }
                    routine.addSpecificRoutine(nameManager, (Routine)object, replace);
                    specificSet.add(object, replace);
                }
                return;
            }
        }
        set.add(object, replace);
    }

    void release() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            Table table = (Table)this.tableList.get(i);
            table.terminateTriggers();
        }
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.charsetLookup = null;
        this.collationLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.specificRoutineLookup = null;
        this.conditionLookup = null;
        this.moduleLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
        this.tableList.clear();
        this.sequenceList.clear();
        this.referenceList.clear();
    }
}

