/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.FilteredIterator;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    OrderedHashMap schemaMap = new OrderedHashMap();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 4;
    long schemaChangeTimestamp;
    HsqlNameManager.HsqlName[] catalogNameArray;
    UserSchemaFilter userSchemaFilter = new UserSchemaFilter();
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    Table dualTable;
    public Table dataChangeTable;
    long[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        this.catalogNameArray = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.charsetLookup.add(Charset.SQL_TEXT, false);
            schema.charsetLookup.add(Charset.SQL_IDENTIFIER_CHARSET, false);
            schema.charsetLookup.add(Charset.SQL_CHARACTER, false);
            schema.collationLookup.add(Collation.getDefaultInstance(), false);
            schema.collationLookup.add(Collation.getDefaultIgnoreCaseInstance(), false);
            schema.typeLookup.add(TypeInvariants.CARDINAL_NUMBER, false);
            schema.typeLookup.add(TypeInvariants.YES_OR_NO, false);
            schema.typeLookup.add(TypeInvariants.CHARACTER_DATA, false);
            schema.typeLookup.add(TypeInvariants.SQL_IDENTIFIER, false);
            schema.typeLookup.add(TypeInvariants.TIME_STAMP, false);
            schema.typeLookup.add(TypeInvariants.NCNAME, false);
            schema.typeLookup.add(TypeInvariants.URI, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getSystemChangeNumber();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    public void createPublicSchema() {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
            Schema schema = new Schema(name, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.writeLock.lock();
        try {
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            Schema schema = new Schema(name, owner);
            this.schemaMap.add(name.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String name, boolean cascade) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(5501, name);
            }
            if (SqlInvariants.isLobsSchemaName(name)) {
                throw Error.error(5503, name);
            }
            if (!cascade && !schema.isEmpty()) {
                throw Error.error(4200);
            }
            OrderedHashSet externalReferences = new OrderedHashSet();
            this.getCascadingReferencesToSchema(schema.getName(), externalReferences);
            this.removeSchemaObjects(externalReferences);
            Iterator tableIterator = schema.schemaObjectIterator(3);
            while (tableIterator.hasNext()) {
                Table table = (Table)tableIterator.next();
                Constraint[] list = table.getFKConstraints();
                for (int i = 0; i < list.length; ++i) {
                    Constraint constraint = list[i];
                    if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                    this.removeReferencesFrom(constraint);
                }
                this.removeTable(session, table);
            }
            Iterator sequenceIterator = schema.schemaObjectIterator(7);
            while (sequenceIterator.hasNext()) {
                NumberSequence sequence = (NumberSequence)sequenceIterator.next();
                this.database.getGranteeManager().removeDbObject(sequence.getName());
            }
            schema.release();
            this.schemaMap.remove(name);
            if (this.defaultSchemaHsqlName.name.equals(name)) {
                schema = new Schema(this.defaultSchemaHsqlName, this.database.getGranteeManager().getDBARole());
                this.defaultSchemaHsqlName = schema.getName();
                this.schemaMap.put(schema.getName().name, schema);
            } else {
                HsqlNameManager.HsqlName schemaName = schema.getName();
                this.database.getUserManager().removeSchemaReference(schemaName);
                this.database.getSessionManager().removeSchemaReference(schemaName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.name);
            Schema exists = (Schema)this.schemaMap.get(newName.name);
            if (schema == null) {
                throw Error.error(5501, name.name);
            }
            if (exists != null) {
                throw Error.error(5504, newName.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            SqlInvariants.checkSchemaNameNotSystem(newName.name);
            int index = this.schemaMap.getIndex(name.name);
            schema.getName().rename(newName);
            this.schemaMap.set(index, newName.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void release() {
        this.writeLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                schema.release();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            String[] array = new String[this.schemaMap.size()];
            this.schemaMap.keysToArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Schema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Schema[] objects = new Schema[this.schemaMap.size()];
            this.schemaMap.valuesToArray(objects);
            Schema[] schemaArray = objects;
            return schemaArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Iterator getUserSchemaIterator() {
        return new FilteredIterator(this.schemaMap.values().iterator(), this.userSchemaFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
                throw Error.error(4850, name);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            Grantee grantee = schema == null ? null : schema.getOwner();
            return grantee;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.defaultSchemaHsqlName = name;
    }

    public boolean schemaExists(String name) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(name);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName findSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                HsqlNameManager.HsqlName hsqlName = null;
                return hsqlName;
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        HsqlNameManager.HsqlName schemaName = this.findSchemaHsqlName(name);
        if (schemaName == null) {
            throw Error.error(4850, name);
        }
        return schemaName;
    }

    public String getSchemaName(String name) {
        return this.getSchemaHsqlName((String)name).name;
    }

    public Schema findSchema(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            return schema;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean cascade) {
        this.writeLock.lock();
        try {
            HsqlArrayList list = this.getSchemas(grantee);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                this.dropSchema(session, schema.getName().name, cascade);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            HsqlArrayList<Schema> list = new HsqlArrayList<Schema>();
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                list.add(schema);
            }
            HsqlArrayList<Schema> hsqlArrayList = list;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getAllTables(boolean withLobTables) {
        this.readLock.lock();
        try {
            HsqlArrayList alltables = new HsqlArrayList();
            String[] schemas = this.getSchemaNamesArray();
            for (int i = 0; i < schemas.length; ++i) {
                String name = schemas[i];
                if (!withLobTables && SqlInvariants.isLobsSchemaName(name) || SqlInvariants.isSystemSchemaName(name)) continue;
                OrderedHashMap current = this.getTables(name);
                alltables.addAll(current.values());
            }
            HsqlArrayList hsqlArrayList = alltables;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashMap getTables(String schema) {
        this.readLock.lock();
        try {
            Schema temp = (Schema)this.schemaMap.get(schema);
            OrderedHashMap orderedHashMap = temp.tableList;
            return orderedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            OrderedHashSet<HsqlNameManager.HsqlName> names = new OrderedHashSet<HsqlNameManager.HsqlName>();
            HsqlArrayList tables = this.getAllTables(false);
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                if (table.isTemp()) continue;
                names.add(table.getName());
            }
            names.add(this.database.getCatalogName());
            HsqlNameManager.HsqlName[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            HsqlNameManager.HsqlName[] hsqlNameArray = array;
            return hsqlNameArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames(HsqlNameManager.HsqlName name) {
        if (name == null) {
            return this.catalogNameArray;
        }
        this.readLock.lock();
        try {
            SchemaObject parentObject;
            switch (name.type) {
                case 2: {
                    if (this.findSchemaHsqlName(name.name) == null) {
                        HsqlNameManager.HsqlName[] hsqlNameArray = this.catalogNameArray;
                        return hsqlNameArray;
                    }
                    OrderedHashSet<HsqlNameManager.HsqlName> names = new OrderedHashSet<HsqlNameManager.HsqlName>();
                    names.add(this.database.getCatalogName());
                    OrderedHashMap list = this.getTables(name.name);
                    for (int i = 0; i < list.size(); ++i) {
                        names.add(((SchemaObject)list.get(i)).getName());
                    }
                    HsqlNameManager.HsqlName[] array = new HsqlNameManager.HsqlName[names.size()];
                    names.toArray(array);
                    HsqlNameManager.HsqlName[] hsqlNameArray = array;
                    return hsqlNameArray;
                }
                case 11: {
                    HsqlNameManager.HsqlName[] names = this.catalogNameArray;
                    return names;
                }
            }
            SchemaObject object = this.findSchemaObject(name.name, name.schema.name, name.type);
            if (object == null) {
                HsqlNameManager.HsqlName[] list = this.catalogNameArray;
                return list;
            }
            HsqlNameManager.HsqlName parent = object.getName().parent;
            OrderedHashSet references = this.getReferencesTo(object.getName());
            OrderedHashSet<HsqlNameManager.HsqlName> names = new OrderedHashSet<HsqlNameManager.HsqlName>();
            names.add(this.database.getCatalogName());
            if (parent != null && (parentObject = this.findSchemaObject(parent.name, parent.schema.name, parent.type)) != null && parentObject.getName().type == 3) {
                names.add(parentObject.getName());
            }
            if (object.getName().type == 3) {
                names.add(object.getName());
            }
            for (int i = 0; i < references.size(); ++i) {
                Table table;
                HsqlNameManager.HsqlName reference = (HsqlNameManager.HsqlName)references.get(i);
                if (reference.type != 3 || (table = this.findUserTable(reference.name, reference.schema.name)) == null || table.isTemp()) continue;
                names.add(reference);
            }
            HsqlNameManager.HsqlName[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            HsqlNameManager.HsqlName[] hsqlNameArray = array;
            return hsqlNameArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private SchemaObjectSet getSchemaObjectSet(Schema schema, int type) {
        SchemaObjectSet set = null;
        switch (type) {
            case 7: {
                set = schema.sequenceLookup;
                break;
            }
            case 3: 
            case 4: {
                set = schema.tableLookup;
                break;
            }
            case 14: {
                set = schema.charsetLookup;
                break;
            }
            case 15: {
                set = schema.collationLookup;
                break;
            }
            case 17: {
                set = schema.procedureLookup;
                break;
            }
            case 16: {
                set = schema.functionLookup;
                break;
            }
            case 12: 
            case 13: {
                set = schema.typeLookup;
                break;
            }
            case 20: {
                set = schema.indexLookup;
                break;
            }
            case 5: {
                set = schema.constraintLookup;
                break;
            }
            case 8: {
                set = schema.triggerLookup;
                break;
            }
            case 24: {
                set = schema.specificRoutineLookup;
                break;
            }
            case 29: {
                set = schema.referenceLookup;
                break;
            }
            case 31: {
                set = schema.moduleLookup;
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.checkAdd(name);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table getUserTable(HsqlNameManager.HsqlName name) {
        return this.getUserTable(name.name, name.schema.name);
    }

    public Table getUserTable(String name, String schema) {
        Table t = this.findUserTable(name, schema);
        if (t == null) {
            String longName = schema == null ? name : schema + '.' + name;
            throw Error.error(5501, longName);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(String name, String schemaName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema == null) {
                Table table = null;
                return table;
            }
            int i = schema.tableList.getIndex(name);
            if (i == -1) {
                Table table = null;
                return table;
            }
            Table table = (Table)schema.tableList.get(i);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table findSessionTable(Session session, String name) {
        return session.sessionContext.findSessionTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean cascade) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.dropView(table, cascade);
            } else {
                this.dropTable(session, table, cascade);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void dropView(Table table, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        this.removeSchemaObject(table.getName(), cascade);
        this.removeTableDependentReferences(table);
        schema.triggerLookup.removeParent(table.getName());
    }

    private void dropTable(Session session, Table table, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        OrderedHashSet externalConstraints = table.getDependentExternalConstraints();
        OrderedHashSet externalReferences = new OrderedHashSet();
        this.getCascadingReferencesTo(table.getName(), externalReferences);
        if (!cascade) {
            int i;
            for (i = 0; i < externalConstraints.size(); ++i) {
                Constraint c = (Constraint)externalConstraints.get(i);
                HsqlNameManager.HsqlName refname = c.getRefName();
                if (c.getConstraintType() != 1) continue;
                throw Error.error(5533, refname.getSchemaQualifiedStatementName());
            }
            if (!externalReferences.isEmpty()) {
                for (i = 0; i < externalReferences.size(); ++i) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)externalReferences.get(i);
                    if (name.parent == table.getName()) continue;
                    throw Error.error(5502, name.getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet tableSet = new OrderedHashSet();
        OrderedHashSet<HsqlNameManager.HsqlName> constraintNameSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> indexNameSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < externalConstraints.size(); ++i) {
            Constraint c = (Constraint)externalConstraints.get(i);
            Table t = c.getMain();
            if (t != table) {
                tableSet.add(t);
            }
            if ((t = c.getRef()) != table) {
                tableSet.add(t);
            }
            constraintNameSet.add(c.getMainName());
            constraintNameSet.add(c.getRefName());
            indexNameSet.add(c.getRefIndex().getName());
        }
        OrderedHashSet uniqueConstraintNames = table.getUniquePKConstraintNames();
        TableWorks tw = new TableWorks(session, table);
        tableSet = tw.dropConstraintsAndIndexes(tableSet, constraintNameSet, indexNameSet);
        tw.setNewTablesInSchema(tableSet);
        tw.updateConstraints(tableSet, constraintNameSet);
        this.removeSchemaObjects(externalReferences);
        this.removeTableDependentReferences(table);
        this.removeReferencesTo(uniqueConstraintNames);
        this.removeReferencesTo(table.getName());
        this.removeReferencesFrom(table);
        schema.tableList.remove(table.getName().name);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        schema.triggerLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(tableSet);
    }

    private void removeTable(Session session, Table table) {
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (!table.isView() && table.hasLobColumn()) {
            RowIterator it = table.rowIterator(session);
            while (it.next()) {
                Object[] data = it.getCurrent();
                session.sessionData.adjustLobUsageCount(table, data, -1);
            }
        }
        if (table.isTemp) {
            Session[] sessions = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                sessions[i].sessionData.persistentStoreCollection.removeStore(table);
            }
        } else {
            this.database.persistentStoreCollection.removeStore(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int index, Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            schema.tableList.set(index, table.getName().name, table);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            if (schema == null) {
                int n = -1;
                return n;
            }
            HsqlNameManager.HsqlName name = table.getName();
            int n = schema.tableList.getIndex(name.name);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet tableSet) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            for (int i = 0; i < tableSet.size(); ++i) {
                Table table = (Table)tableSet.get(i);
                set.addAll(this.getReferencesTo(table.getName()));
            }
            Session session = this.database.sessionManager.getSysSession();
            block7: for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                        continue block7;
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i = 0; i < list.size(); ++i) {
                    Table t = (Table)list.get(i);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(Table table) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            this.getCascadingReferencesTo(table.getName(), set);
            Session session = this.database.sessionManager.getSysSession();
            block6: for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                        continue block6;
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i = 0; i < list.size(); ++i) {
                    Table t = (Table)list.get(i);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collation getCollation(Session session, String name, String schemaName) {
        Collation collation = null;
        if (schemaName == null || "INFORMATION_SCHEMA".equals(schemaName)) {
            try {
                collation = Collation.getCollation(name);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        if (collation == null) {
            schemaName = session.getSchemaName(schemaName);
            collation = (Collation)this.getSchemaObject(name, schemaName, 15);
        }
        return collation;
    }

    public NumberSequence findSequence(Session session, String name, String schemaName) {
        ReferenceObject ref;
        NumberSequence seq = this.getSequence(name, session.getSchemaName(schemaName), false);
        if (seq == null && schemaName == null && (ref = this.findSynonym(name, schemaName = session.getSchemaName(null), 7)) != null) {
            seq = this.getSequence(ref.target.name, ref.target.schema.name, false);
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            NumberSequence object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = (NumberSequence)schema.sequenceList.get(name)) != null) {
                NumberSequence numberSequence = object;
                return numberSequence;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            NumberSequence numberSequence = null;
            return numberSequence;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findDomainOrUDT(Session session, String name, String prefix, String prePrefix, String prePrePrefix) {
        this.readLock.lock();
        try {
            Type type;
            Type type2 = type = (Type)this.findSchemaObject(session, name, prefix, prePrefix, 12);
            return type2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomain(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDomainType()) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDistinctType(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDistinctType()) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            SchemaObject object = this.findSchemaObject(name, schemaName, type);
            if (object == null) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(type), name);
            }
            SchemaObject schemaObject = object;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaObject getCharacterSet(Session session, String name, String schemaName) {
        if (schemaName == null || "INFORMATION_SCHEMA".equals(schemaName)) {
            if (name.equals("SQL_IDENTIFIER")) {
                return Charset.SQL_IDENTIFIER_CHARSET;
            }
            if (name.equals("SQL_TEXT")) {
                return Charset.SQL_TEXT;
            }
            if (name.equals("LATIN1")) {
                return Charset.LATIN1;
            }
            if (name.equals("ASCII_GRAPHIC")) {
                return Charset.ASCII_GRAPHIC;
            }
        }
        if (schemaName == null) {
            schemaName = session.getSchemaName(null);
        }
        return this.getSchemaObject(name, schemaName, 14);
    }

    public Table findTable(Session session, String name, String prefix, String prePrefix) {
        return (Table)this.findSchemaObject(session, name, prefix, prePrefix, 3);
    }

    public SchemaObject findSchemaObject(Session session, String name, String prefix, String prePrefix, int type) {
        if (prePrefix != null && !prePrefix.equals(this.database.getCatalogName().name)) {
            return null;
        }
        if (type == 3) {
            if (prefix == null) {
                if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2 || session.isProcessingScript()) && "DUAL".equals(name)) {
                    return this.dualTable;
                }
                Table t = this.findSessionTable(session, name);
                if (t != null) {
                    return t;
                }
                if (prefix == null) {
                    prefix = session.getSchemaName(null);
                }
            } else if (prePrefix == null) {
                Table t;
                if ("MODULE".equals(prefix) && (t = this.findSessionTable(session, name)) != null) {
                    return t;
                }
                if (("SESSION".equals(prefix) || "MODULE".equals(prefix)) && (t = this.findSessionTable(session, name)) != null) {
                    return t;
                }
            }
            if ("INFORMATION_SCHEMA".equals(prefix)) {
                if (this.database.dbInfo == null) {
                    return null;
                }
                return this.database.dbInfo.getSystemTable(session, name);
            }
        }
        if (prefix == null) {
            prefix = session.getSchemaName(null);
        }
        return this.findSchemaObject(name, prefix, type);
    }

    public ReferenceObject findSynonym(String name, String schemaName, int type) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema == null) {
            return null;
        }
        ReferenceObject reference = schema.findReference(name, type);
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findAnySchemaObjectForSynonym(String name, String schemaName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            SchemaObject schemaObject = schema.findAnySchemaObjectForSynonym(name);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            SchemaObject schemaObject = schema.findSchemaObject(name, type);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            HsqlNameManager.HsqlName indexName = schema.indexLookup.getName(name);
            if (indexName == null) {
                Table table = null;
                return table;
            }
            Table table = this.findUserTable(indexName.parent.name, schemaName);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropIndex(Session session, HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Table t = this.getUserTable(name.parent);
            TableWorks tw = new TableWorks(session, t);
            tw.dropIndex(name.name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConstraint(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            Table t = this.getUserTable(name.parent);
            TableWorks tw = new TableWorks(session, t);
            tw.dropConstraint(name.name, cascade);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void removeDependentObjects(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            schema.indexLookup.removeParent(name);
            schema.constraintLookup.removeParent(name);
            schema.triggerLookup.removeParent(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExportedKeys(Table toDrop) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(toDrop.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table = (Table)schema.tableList.get(i);
                Constraint[] constraints = table.getConstraints();
                for (int j = constraints.length - 1; j >= 0; --j) {
                    Table refTable = constraints[j].getRef();
                    if (toDrop != refTable) continue;
                    table.removeConstraint(j);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(String schemaName, int type) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            Iterator iterator = schema.schemaObjectIterator(type);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(int type) {
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            WrapperIterator objects = new WrapperIterator();
            while (it.hasNext()) {
                Object[] values;
                int targetType = type;
                if (type == 18) {
                    targetType = 16;
                }
                Schema temp = (Schema)it.next();
                SchemaObjectSet set = temp.getObjectSet(targetType);
                if (set.map.size() != 0) {
                    values = new Object[set.map.size()];
                    set.map.valuesToArray(values);
                    objects = new WrapperIterator(objects, new WrapperIterator(values));
                }
                if (type != 18) continue;
                set = temp.getObjectSet(17);
                if (set.map.size() == 0) continue;
                values = new Object[set.map.size()];
                set.map.valuesToArray(values);
                objects = new WrapperIterator(objects, new WrapperIterator(values));
            }
            WrapperIterator wrapperIterator = objects;
            return wrapperIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addReferencesFrom(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        HsqlNameManager.HsqlName name = object.getName();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            this.referenceMap.put(referenced, name);
        }
    }

    private void removeReferencesTo(OrderedHashSet set) {
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            this.referenceMap.remove(referenced);
        }
    }

    private void removeReferencesTo(HsqlNameManager.HsqlName referenced) {
        this.referenceMap.remove(referenced);
    }

    private void removeReferencesFrom(SchemaObject object) {
        HsqlNameManager.HsqlName name = object.getName();
        OrderedHashSet set = object.getReferences();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            this.referenceMap.remove(referenced, name);
        }
    }

    private void removeTableDependentReferences(Table table) {
        OrderedHashSet mainSet = table.getReferencesForDependents();
        block5: for (int i = 0; i < mainSet.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainSet.get(i);
            SchemaObject object = null;
            switch (name.type) {
                case 5: {
                    object = table.getConstraint(name.name);
                    break;
                }
                case 8: {
                    object = table.getTrigger(name.name);
                    break;
                }
                case 9: {
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                default: {
                    continue block5;
                }
            }
            this.removeReferencesFrom(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencesTo(HsqlNameManager.HsqlName object) {
        this.readLock.lock();
        try {
            OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
            Iterator it = this.referenceMap.getValuesIterator(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                set.add(name);
            }
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = set;
            return orderedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencesTo(HsqlNameManager.HsqlName table, HsqlNameManager.HsqlName column) {
        this.readLock.lock();
        try {
            HsqlNameManager.HsqlName name;
            OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
            Iterator it = this.referenceMap.getValuesIterator(table);
            while (it.hasNext()) {
                name = (HsqlNameManager.HsqlName)it.next();
                SchemaObject object = this.getSchemaObject(name);
                OrderedHashSet references = object.getReferences();
                if (!references.contains(column)) continue;
                set.add(name);
            }
            it = this.referenceMap.getValuesIterator(column);
            while (it.hasNext()) {
                name = (HsqlNameManager.HsqlName)it.next();
                set.add(name);
            }
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = set;
            return orderedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isReferenced(HsqlNameManager.HsqlName object) {
        this.writeLock.lock();
        try {
            boolean bl = this.referenceMap.containsKey(object);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesTo(HsqlNameManager.HsqlName object, OrderedHashSet set) {
        this.readLock.lock();
        try {
            OrderedHashSet<HsqlNameManager.HsqlName> newSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            Iterator it = this.referenceMap.getValuesIterator(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                boolean added = set.add(name);
                if (!added) continue;
                newSet.add(name);
            }
            for (int i = 0; i < newSet.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)newSet.get(i);
                this.getCascadingReferencesTo(name, set);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getCascadingReferencesToSchema(HsqlNameManager.HsqlName schema, OrderedHashSet set) {
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (name.schema != schema) continue;
            this.getCascadingReferencesTo(name, set);
        }
        for (int i = set.size() - 1; i >= 0; --i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.schema != schema) continue;
            set.remove(i);
        }
    }

    public MultiValueHashMap getReferencesToSchema(String schemaName) {
        MultiValueHashMap map = new MultiValueHashMap();
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (!name.schema.name.equals(schemaName)) continue;
            Iterator it = this.referenceMap.getValuesIterator(name);
            while (it.hasNext()) {
                map.put(name, it.next());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName schemaName, String name, int type, boolean raise) {
        this.readLock.lock();
        try {
            if (type == 2) {
                HsqlNameManager.HsqlName hsqlName = this.getSchemaHsqlName(name);
                return hsqlName;
            }
            Schema schema = (Schema)this.schemaMap.get(schemaName.name);
            SchemaObjectSet set = null;
            if (schema == null) {
                if (raise) {
                    throw Error.error(SchemaObjectSet.getGetErrorCode(type));
                }
                HsqlNameManager.HsqlName hsqlName = null;
                return hsqlName;
            }
            if (type == 18) {
                set = schema.functionLookup;
                SchemaObject object = schema.functionLookup.getObject(name);
                if (object == null) {
                    set = schema.procedureLookup;
                    object = schema.procedureLookup.getObject(name);
                }
            } else {
                set = this.getSchemaObjectSet(schema, type);
            }
            if (raise) {
                set.checkExists(name);
            }
            HsqlNameManager.HsqlName hsqlName = set.getName(name);
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            String nameString = name.type == 2 ? name.name : name.schema.name;
            Schema schema = (Schema)this.schemaMap.get(nameString);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            switch (name.type) {
                case 7: {
                    SchemaObject schemaObject = (SchemaObject)schema.sequenceList.get(name.name);
                    return schemaObject;
                }
                case 3: 
                case 4: {
                    SchemaObject schemaObject = (SchemaObject)schema.tableList.get(name.name);
                    return schemaObject;
                }
                case 14: {
                    SchemaObject schemaObject = schema.charsetLookup.getObject(name.name);
                    return schemaObject;
                }
                case 15: {
                    SchemaObject schemaObject = schema.collationLookup.getObject(name.name);
                    return schemaObject;
                }
                case 17: {
                    SchemaObject schemaObject = schema.procedureLookup.getObject(name.name);
                    return schemaObject;
                }
                case 16: {
                    SchemaObject schemaObject = schema.functionLookup.getObject(name.name);
                    return schemaObject;
                }
                case 24: {
                    SchemaObject schemaObject = schema.specificRoutineLookup.getObject(name.name);
                    return schemaObject;
                }
                case 18: {
                    SchemaObject object = schema.functionLookup.getObject(name.name);
                    if (object == null) {
                        object = schema.procedureLookup.getObject(name.name);
                    }
                    SchemaObject schemaObject = object;
                    return schemaObject;
                }
                case 12: 
                case 13: {
                    SchemaObject schemaObject = schema.typeLookup.getObject(name.name);
                    return schemaObject;
                }
                case 8: {
                    name = schema.triggerLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    TriggerDef triggerDef = table.getTrigger(name.name);
                    return triggerDef;
                }
                case 5: {
                    name = schema.constraintLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    Constraint constraint = table.getConstraint(name.name);
                    return constraint;
                }
                case 6: {
                    SchemaObject tableName = null;
                    return tableName;
                }
                case 20: {
                    name = schema.indexLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    Index index = table.getUserIndex(name.name);
                    return index;
                }
                case 29: {
                    SchemaObject schemaObject = schema.referenceLookup.getObject(name.name);
                    return schemaObject;
                }
                case 2: {
                    Schema schema2 = schema;
                    return schema2;
                }
            }
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName tableName, HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencesTo(tableName, name);
        if (!set.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencesTo(name);
        HsqlNameManager.HsqlName refName = null;
        for (int i = 0; i < set.size(); ++i) {
            refName = (HsqlNameManager.HsqlName)set.get(i);
            if (refName.parent != name) break;
            refName = null;
        }
        if (refName == null) {
            return;
        }
        if (name.type == 5) {
            return;
        }
        int errorCode = 5502;
        if (refName.type == 0) {
            errorCode = 5533;
        }
        throw Error.error(errorCode, refName.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Iterator it = this.referenceMap.values().iterator();
            HsqlNameManager.HsqlName refName = null;
            block7: while (it.hasNext()) {
                refName = (HsqlNameManager.HsqlName)it.next();
                switch (refName.type) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        if (refName.schema == name) break block7;
                    }
                    default: {
                        refName = null;
                        continue block7;
                    }
                }
            }
            if (refName == null) {
                return;
            }
            throw Error.error(5502, refName.getSchemaQualifiedStatementName());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(SchemaObject object) {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name = object.getName();
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            switch (name.type) {
                case 3: {
                    OrderedHashSet refs = ((Table)object).getReferencesForDependents();
                    block12: for (int i = 0; i < refs.size(); ++i) {
                        HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)refs.get(i);
                        switch (ref.type) {
                            case 9: {
                                int index = ((Table)object).findColumn(ref.name);
                                ColumnSchema column = ((Table)object).getColumn(index);
                                this.addSchemaObject(column);
                                continue block12;
                            }
                        }
                    }
                    break;
                }
                case 9: {
                    OrderedHashSet refs = object.getReferences();
                    if (refs == null || refs.isEmpty()) {
                        return;
                    }
                    this.addReferencesFrom(object);
                    return;
                }
            }
            schema.addSchemaObject(this.database.nameManager, object, false);
            this.addReferencesFrom(object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            OrderedHashSet<HsqlNameManager.HsqlName> objectSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            switch (name.type) {
                case 16: 
                case 17: 
                case 18: {
                    RoutineSchema routine = (RoutineSchema)this.getSchemaObject(name);
                    if (routine == null) break;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.getCascadingReferencesTo(specifics[i].getSpecificName(), objectSet);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 12: 
                case 14: 
                case 15: 
                case 24: {
                    this.getCascadingReferencesTo(name, objectSet);
                    break;
                }
                case 13: {
                    OrderedHashSet set = this.getReferencesTo(name);
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)it.next();
                        if (ref.type == 9) continue;
                        throw Error.error(5502, ref.getSchemaQualifiedStatementName());
                    }
                    break;
                }
            }
            if (objectSet.isEmpty()) {
                this.removeSchemaObject(name);
                return;
            }
            if (!cascade) {
                HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)objectSet.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
            objectSet.add(name);
            this.removeSchemaObjects(objectSet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet set) {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name;
            int i;
            for (i = 0; i < set.size(); ++i) {
                name = (HsqlNameManager.HsqlName)set.get(i);
                if (name.parent == null) continue;
                this.removeSchemaObject(name);
            }
            for (i = 0; i < set.size(); ++i) {
                name = (HsqlNameManager.HsqlName)set.get(i);
                if (name.parent != null) continue;
                this.removeSchemaObject(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObject object = null;
            SchemaObjectSet set = null;
            switch (name.type) {
                case 7: {
                    set = schema.sequenceLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 3: 
                case 4: {
                    set = schema.tableLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 9: {
                    Table table = (Table)this.getSchemaObject(name.parent);
                    if (table == null) break;
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                case 14: {
                    set = schema.charsetLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 15: {
                    set = schema.collationLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 17: {
                    set = schema.procedureLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 16: {
                    set = schema.functionLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 24: {
                    set = schema.specificRoutineLookup;
                    Routine routine = (Routine)set.getObject(name.name);
                    object = routine;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getName());
                    break;
                }
                case 12: 
                case 13: {
                    set = schema.typeLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 20: {
                    set = schema.indexLookup;
                    break;
                }
                case 5: {
                    set = schema.constraintLookup;
                    if (name.parent.type == 3) {
                        Table table = (Table)schema.tableList.get(name.parent.name);
                        object = table.getConstraint(name.name);
                        table.removeConstraint(name.name);
                        break;
                    }
                    if (name.parent.type != 13) break;
                    Type type = (Type)schema.typeLookup.getObject(name.parent.name);
                    object = type.userTypeModifier.getConstraint(name.name);
                    type.userTypeModifier.removeConstraint(name.name);
                    break;
                }
                case 8: {
                    set = schema.triggerLookup;
                    Table table = (Table)schema.tableList.get(name.parent.name);
                    object = table.getTrigger(name.name);
                    if (object == null) break;
                    table.removeTrigger((TriggerDef)object);
                    break;
                }
                case 29: {
                    set = schema.referenceLookup;
                    object = set.getObject(name.name);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (object != null) {
                this.database.getGranteeManager().removeDbObject(name);
                this.removeReferencesFrom(object);
            }
            if (set != null) {
                set.remove(name.name);
            }
            this.removeReferencesTo(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            if (name.schema != newName.schema) {
                throw Error.error(5505, newName.schema.name);
            }
            this.checkObjectIsReferenced(name);
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.rename(name, newName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void replaceReferences(SchemaObject oldObject, SchemaObject newObject) {
        this.writeLock.lock();
        try {
            this.removeReferencesFrom(oldObject);
            this.addReferencesFrom(newObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSQLArray() {
        this.readLock.lock();
        try {
            SchemaObject object;
            Iterator it;
            Schema schema;
            OrderedHashSet resolved = new OrderedHashSet();
            OrderedHashSet unresolved = new OrderedHashSet();
            HsqlArrayList<String> list = new HsqlArrayList<String>();
            Iterator schemas = this.getUserSchemaIterator();
            block3: while (schemas.hasNext()) {
                Iterator it2;
                Schema schema2 = (Schema)schemas.next();
                list.add(schema2.getSQL());
                for (int round = 0; round < Schema.scriptSequenceOne.length; ++round) {
                    int objectType = Schema.scriptSequenceOne[round];
                    list.addAll((Collection)schema2.getSQLArray(objectType, resolved, unresolved));
                }
                while ((it2 = unresolved.iterator()).hasNext()) {
                    OrderedHashSet newResolved = new OrderedHashSet();
                    SchemaObjectSet.addAllSQL(resolved, unresolved, list, it2, newResolved);
                    unresolved.removeAll(newResolved);
                    if (newResolved.size() != 0) continue;
                    continue block3;
                }
            }
            for (int round = 0; round < Schema.scriptSequenceTwo.length; ++round) {
                schemas = this.getUserSchemaIterator();
                while (schemas.hasNext()) {
                    schema = (Schema)schemas.next();
                    int objectType = Schema.scriptSequenceTwo[round];
                    list.addAll((Collection)schema.getSQLArray(objectType, resolved, unresolved));
                }
            }
            while ((it = unresolved.iterator()).hasNext()) {
                OrderedHashSet newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (!(object instanceof Routine)) continue;
                list.add(((Routine)object).getSQLDeclaration());
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (object instanceof Routine) {
                    list.add(((Routine)object).getSQLAlter());
                    continue;
                }
                list.add(object.getSQL());
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (!(object instanceof ReferenceObject)) continue;
                list.add(object.getSQL());
            }
            schemas = this.getUserSchemaIterator();
            while (schemas.hasNext()) {
                schema = (Schema)schemas.next();
                HsqlArrayList t = schema.getTriggerSQL();
                if (t.size() <= 0) continue;
                list.add(schema.getSetSchemaSQL());
                list.addAll((Collection)t);
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema = (Schema)schemas.next();
                list.addAll((Collection)schema.getSequenceRestartSQL());
            }
            if (this.defaultSchemaHsqlName != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("SET").append(' ').append("DATABASE");
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append("INITIAL").append(' ').append("SCHEMA");
                sb.append(' ').append(this.defaultSchemaHsqlName.statementName);
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablePropsSQL(boolean withHeader) {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList<Object[]> list = new HsqlArrayList<Object[]>();
            for (int i = 0; i < tableList.size(); ++i) {
                Object ddl;
                Table t = (Table)tableList.get(i);
                if (t.isText()) {
                    ddl = t.getSQLForTextSource(withHeader);
                    list.addAll((Object[])ddl);
                }
                if ((ddl = t.getSQLForReadOnly()) != null) {
                    list.add((Object[])ddl);
                }
                if (!t.isCached() || (ddl = t.getSQLForClustered()) == null) continue;
                list.add((Object[])ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableSpaceSQL() {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(true);
            HsqlArrayList<String> list = new HsqlArrayList<String>();
            for (int i = 0; i < tableList.size(); ++i) {
                String ddl;
                Table t = (Table)tableList.get(i);
                if (!t.isCached() || (ddl = t.getSQLForTableSpace()) == null) continue;
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexRootsSQL() {
        this.readLock.lock();
        try {
            long[][] rootsArray = this.getIndexRoots();
            HsqlArrayList tableList = this.getAllTables(true);
            HsqlArrayList<String> list = new HsqlArrayList<String>();
            for (int i = 0; i < rootsArray.length; ++i) {
                Table table = (Table)tableList.get(i);
                if (rootsArray[i] == null || rootsArray[i].length <= 0 || rootsArray[i][0] == -1L) continue;
                String ddl = table.getIndexRootsSQL(rootsArray[i]);
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setTempIndexRoots(long[][] roots) {
        this.tempIndexRoots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] getIndexRoots() {
        this.readLock.lock();
        try {
            if (this.tempIndexRoots != null) {
                long[][] roots = this.tempIndexRoots;
                this.tempIndexRoots = null;
                long[][] lArray = roots;
                return lArray;
            }
            HsqlArrayList allTables = this.getAllTables(true);
            HsqlArrayList<long[]> list = new HsqlArrayList<long[]>();
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 5) {
                    long[] roots = t.getIndexRootsArray();
                    list.add(roots);
                    continue;
                }
                list.add(null);
            }
            long[][] array = new long[list.size()][];
            list.toArray((T[])array);
            long[][] lArrayArray = array;
            return lArrayArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(long[][] roots) {
        this.readLock.lock();
        try {
            HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                long[] rootsArray;
                Table t = (Table)allTables.get(i);
                if (t.getTableType() != 5 || (rootsArray = roots[i]) == null) continue;
                t.setIndexRoots(rootsArray);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDefaultTableType(int type) {
        this.defaultTableType = type;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void createSystemTables() {
        this.dualTable = TableUtil.newSingleColumnTable(this.database, SqlInvariants.DUAL_TABLE_HSQLNAME, 12, SqlInvariants.DUAL_COLUMN_HSQLNAME, Type.SQL_VARCHAR);
        this.dualTable.insertSys(this.database.sessionManager.getSysSession(), this.dualTable.getRowStore(null), new Object[]{"X"});
        this.dualTable.setDataReadOnly(true);
        Type[] columnTypes = new Type[]{Type.SQL_BIGINT, Type.SQL_BIGINT, Type.SQL_BIGINT, TypeInvariants.SQL_IDENTIFIER, TypeInvariants.SQL_IDENTIFIER, Type.SQL_BOOLEAN};
        HsqlNameManager.HsqlName tableName = this.database.nameManager.getSubqueryTableName();
        OrderedHashMap<String, ColumnSchema> columnList = new OrderedHashMap<String, ColumnSchema>();
        for (int i = 0; i < columnTypes.length; ++i) {
            HsqlNameManager.HsqlName name = HsqlNameManager.getAutoColumnName(i + 1);
            ColumnSchema column = new ColumnSchema(name, columnTypes[i], true, false, null);
            columnList.add(name.name, column);
        }
        this.dataChangeTable = new TableDerived(this.database, tableName, 13, columnTypes, columnList, new int[]{0});
        this.dataChangeTable.createIndexForColumns(null, new int[]{1});
    }

    static class UserSchemaFilter
    implements FilteredIterator.Filter {
        UserSchemaFilter() {
        }

        public boolean test(Object schemaObject) {
            Schema schema = (Schema)schemaObject;
            String name = schema.getName().name;
            return !SqlInvariants.isLobsSchemaName(name) && !SqlInvariants.isSystemSchemaName(name);
        }
    }
}

