/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;

public class SchemaObjectSet {
    HashMap map;
    int type;

    SchemaObjectSet(int type) {
        this.type = type;
        switch (type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                this.map = new OrderedHashMap();
                break;
            }
            case 5: 
            case 20: {
                this.map = new HashMap();
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
    }

    HsqlNameManager.HsqlName getName(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                SchemaObject object = (SchemaObject)this.map.get(name);
                return object == null ? null : object.getName();
            }
            case 5: 
            case 20: {
                return (HsqlNameManager.HsqlName)this.map.get(name);
            }
        }
        return (HsqlNameManager.HsqlName)this.map.get(name);
    }

    public SchemaObject getObject(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                return (SchemaObject)this.map.get(name);
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    void checkAdd(HsqlNameManager.HsqlName name) {
        if (this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    void checkExists(String name) {
        if (!this.map.containsKey(name)) {
            int code = SchemaObjectSet.getGetErrorCode(this.type);
            throw Error.error(code, name);
        }
    }

    public void add(SchemaObject object, boolean replace) {
        HsqlNameManager.HsqlName name = object.getName();
        if (this.type == 24) {
            name = ((Routine)object).getSpecificName();
        }
        if (!replace && this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
        Object value = object;
        switch (name.type) {
            case 5: 
            case 20: {
                value = name;
                break;
            }
        }
        this.map.put(name.name, value);
    }

    void remove(String name) {
        this.map.remove(name);
    }

    void removeParent(HsqlNameManager.HsqlName parent) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            if (this.type == 8 || this.type == 24) {
                SchemaObject object = (SchemaObject)it.next();
                if (object.getName().parent != parent) continue;
                it.remove();
                continue;
            }
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            if (name.parent != parent) continue;
            it.remove();
        }
    }

    void rename(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        if (this.map.containsKey(newName.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, newName.name);
        }
        switch (newName.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 32: {
                int i = ((OrderedHashMap)this.map).getIndex(name.name);
                if (i == -1) {
                    int code = SchemaObjectSet.getGetErrorCode(name.type);
                    throw Error.error(code, name.name);
                }
                SchemaObject object = (SchemaObject)((OrderedHashMap)this.map).get(i);
                object.getName().rename(newName);
                ((OrderedHashMap)this.map).setKeyAt(i, newName.name);
                break;
            }
            case 24: {
                int i = ((OrderedHashMap)this.map).getIndex(name.name);
                if (i == -1) {
                    int code = SchemaObjectSet.getGetErrorCode(name.type);
                    throw Error.error(code, name.name);
                }
                Routine routine = (Routine)((OrderedHashMap)this.map).get(i);
                routine.getSpecificName().rename(newName);
                ((OrderedHashMap)this.map).setKeyAt(i, newName.name);
                break;
            }
            case 5: 
            case 20: {
                this.map.remove(name.name);
                name.rename(newName);
                this.map.put(name.name, name);
                break;
            }
        }
    }

    static int getAddErrorCode(int type) {
        int code;
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                code = 5504;
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
        return code;
    }

    static int getGetErrorCode(int type) {
        int code;
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                code = 5501;
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
        return code;
    }

    public static String getName(int type) {
        switch (type) {
            case 4: {
                return "VIEW";
            }
            case 3: {
                return "TABLE";
            }
            case 7: {
                return "SEQUENCE";
            }
            case 14: {
                return "CHARACTER SET";
            }
            case 13: {
                return "DOMAIN";
            }
            case 12: {
                return "TYPE";
            }
            case 15: {
                return "COLLATION";
            }
            case 17: {
                return "PROCEDURE";
            }
            case 16: {
                return "FUNCTION";
            }
            case 24: {
                return "SPECIFIC ROUTINE";
            }
            case 6: {
                return "ASSERTION";
            }
            case 8: {
                return "TRIGGER";
            }
            case 32: {
                return "EXCEPTION";
            }
            case 31: {
                return "MODULE";
            }
            case 29: {
                return "SYNONYM";
            }
            case 23: {
                return "PARAMETER";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 20: {
                return "INDEX";
            }
            case 30: {
                return "PERIOD";
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    void getSQL(HsqlArrayList list, OrderedHashSet resolved, OrderedHashSet unresolved) {
        if (!(this.map instanceof OrderedHashMap)) {
            return;
        }
        if (this.map.isEmpty()) {
            return;
        }
        Iterator<Object> it = this.map.values().iterator();
        if (this.type == 16 || this.type == 17) {
            OrderedHashSet<Routine> set = new OrderedHashSet<Routine>();
            while (it.hasNext()) {
                RoutineSchema routineSchema = (RoutineSchema)it.next();
                for (int i = 0; i < routineSchema.routines.length; ++i) {
                    Routine routine = routineSchema.routines[i];
                    set.add(routine);
                }
            }
            it = set.iterator();
        }
        SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, null);
    }

    static void addAllSQL(OrderedHashSet resolved, OrderedHashSet unresolved, HsqlArrayList list, Iterator it, OrderedHashSet newResolved) {
        block14: while (it.hasNext()) {
            ColumnSchema column;
            OrderedHashSet references;
            SchemaObject object = (SchemaObject)it.next();
            boolean isResolved = true;
            if (object.getType() == 3) {
                ((Table)object).setForwardConstraints(resolved);
                references = ((Table)object).getReferencesForScript();
            } else {
                references = object.getReferences();
            }
            block15: for (int j = 0; j < references.size(); ++j) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)references.get(j);
                if (SqlInvariants.isSchemaNameSystem(name)) continue;
                switch (name.type) {
                    case 3: {
                        if (resolved.contains(name)) continue block15;
                        isResolved = false;
                        continue block15;
                    }
                    case 9: {
                        if (object.getType() == 3) {
                            int index = ((Table)object).findColumn(name.name);
                            column = ((Table)object).getColumn(index);
                            if (SchemaObjectSet.isChildObjectResolved(column, resolved)) continue block15;
                            isResolved = false;
                            continue block15;
                        }
                        if (resolved.contains(name.parent)) continue block15;
                        isResolved = false;
                        continue block15;
                    }
                    case 5: {
                        Constraint constraint;
                        if (name.parent != object.getName() || (constraint = ((Table)object).getConstraint(name.name)).getConstraintType() != 3 || SchemaObjectSet.isChildObjectResolved(constraint, resolved)) continue block15;
                        isResolved = false;
                        continue block15;
                    }
                    case 14: {
                        if (name.schema == null) continue block15;
                    }
                    case 7: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 24: {
                        if (resolved.contains(name)) continue block15;
                        isResolved = false;
                        continue block15;
                    }
                }
            }
            if (!isResolved) {
                unresolved.add(object);
                continue;
            }
            HsqlNameManager.HsqlName name = object.getType() == 16 || object.getType() == 17 ? ((Routine)object).getSpecificName() : object.getName();
            resolved.add(name);
            if (newResolved != null) {
                newResolved.add(object);
            }
            switch (object.getType()) {
                case 3: {
                    list.addAll(((Table)object).getSQL(resolved, unresolved));
                    String comment = object.getName().getCommentSQL("TABLE");
                    if (comment != null) {
                        list.add(comment);
                    }
                    for (int j = 0; j < ((Table)object).getColumnCount(); ++j) {
                        column = ((Table)object).getColumn(j);
                        comment = column.getName().getCommentSQL("COLUMN");
                        if (comment == null) continue;
                        list.add(comment);
                    }
                    continue block14;
                }
                case 16: 
                case 17: {
                    String comment;
                    Routine routine = (Routine)object;
                    if (routine.isRecursive) {
                        list.add(((Routine)object).getSQLDeclaration());
                        list.add(((Routine)object).getSQLAlter());
                    } else {
                        list.add(object.getSQL());
                    }
                    if ((comment = object.getName().getCommentSQL("ROUTINE")) == null) continue block14;
                    list.add(comment);
                    break;
                }
                case 8: {
                    TriggerDef trigger = (TriggerDef)object;
                    list.add(object.getSQL());
                    String comment = object.getName().getCommentSQL("TRIGGER");
                    if (comment == null) continue block14;
                    list.add(comment);
                    break;
                }
                case 7: {
                    list.add(object.getSQL());
                    String comment = object.getName().getCommentSQL("SEQUENCE");
                    if (comment == null) continue block14;
                    list.add(comment);
                    break;
                }
                case 5: {
                    list.add(object.getSQL());
                    String added = ((Constraint)object).getAlterSQL();
                    if (added.isEmpty()) continue block14;
                    list.add(added);
                    break;
                }
                default: {
                    list.add(object.getSQL());
                }
            }
        }
    }

    static boolean isChildObjectResolved(SchemaObject object, OrderedHashSet resolved) {
        OrderedHashSet refs = object.getReferences();
        for (int i = 0; i < refs.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)refs.get(i);
            if (SqlInvariants.isSchemaNameSystem(name) || resolved.contains(name)) continue;
            return false;
        }
        return true;
    }
}

