/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.GroupSet;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementResultUpdate;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.navigator.RowSetNavigatorDataChangeMemory;
import org.hsqldb.result.Result;

public class SessionContext {
    Session session;
    public boolean isAutoCommit;
    boolean isReadOnly;
    boolean noSQL;
    int autoCommitRows;
    int currentMaxRows;
    OrderedHashMap sessionVariables;
    RangeVariable[] sessionVariablesRange;
    RangeGroup[] sessionVariableRangeGroups;
    private HsqlArrayList stack;
    Object[] diagnosticsVariables = ValuePool.emptyObjectArray;
    Object[] routineArguments = ValuePool.emptyObjectArray;
    Object[] routineVariables = ValuePool.emptyObjectArray;
    Result[] routineCursors = Result.emptyArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    Object[][] triggerArguments = null;
    public int depth;
    boolean isInRoutine;
    Number lastIdentity = ValuePool.INTEGER_0;
    OrderedHashMap savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    GroupSet groupSet;
    List currentGroup;
    OrderedHashMap sessionTables;
    OrderedHashMap popSessionTables;
    public Statement currentStatement;
    public int rownum;
    HashSet constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();
    RangeIterator checkIterator = new RangeVariable.RangeIteratorCheck();

    SessionContext(Session session) {
        this.session = session;
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new OrderedHashMap();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, null, true, 4);
        this.sessionVariableRangeGroups = new RangeGroup[]{new RangeGroup.RangeGroupSimple(this.sessionVariablesRange, true)};
        this.isAutoCommit = false;
        this.isReadOnly = false;
        this.noSQL = false;
        this.isInRoutine = false;
    }

    void resetStack() {
        while (this.depth > 0) {
            this.pop(this.isInRoutine);
        }
    }

    public void push() {
        this.push(false);
    }

    private void push(boolean isRoutine) {
        if (this.depth > 256) {
            throw Error.error(458);
        }
        this.session.sessionData.persistentStoreCollection.push(isRoutine);
        if (this.stack == null) {
            this.stack = new HsqlArrayList(32, true);
        }
        this.stack.add(this.diagnosticsVariables);
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.triggerArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.routineCursors);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.lastIdentity);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(this.isInRoutine);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.stack.add(ValuePool.getInt(this.rownum));
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new OrderedHashMap(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = false;
        this.currentMaxRows = 0;
        this.isInRoutine = isRoutine;
        ++this.depth;
    }

    public void pop() {
        this.pop(false);
    }

    private void pop(boolean isRoutine) {
        this.session.sessionData.persistentStoreCollection.pop(isRoutine);
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
        this.currentMaxRows = (Integer)this.stack.remove(this.stack.size() - 1);
        this.isInRoutine = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.noSQL = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isReadOnly = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isAutoCommit = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.lastIdentity = (Number)this.stack.remove(this.stack.size() - 1);
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (OrderedHashMap)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineCursors = (Result[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.triggerArguments = (Object[][])this.stack.remove(this.stack.size() - 1);
        this.routineArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.diagnosticsVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushRoutineInvocation() {
        this.push(true);
    }

    public void popRoutineInvocation() {
        this.pop(true);
    }

    public void pushDynamicArguments(Object[] args) {
        this.push();
        this.dynamicArguments = args;
    }

    public void pushStatementState() {
        if (this.stack == null) {
            this.stack = new HsqlArrayList(32, true);
        }
        this.stack.add(ValuePool.getInt(this.rownum));
    }

    public void popStatementState() {
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
    }

    public void setDynamicArguments(Object[] args) {
        this.dynamicArguments = args;
    }

    RowSetNavigatorDataChange getRowSetDataChange() {
        return new RowSetNavigatorDataChangeMemory(this.session);
    }

    void clearStructures(StatementDMQL cs) {
        int count = cs.rangeIteratorCount;
        if (count > this.rangeIterators.length) {
            count = this.rangeIterators.length;
        }
        for (int i = 0; i < count; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].release();
            this.rangeIterators[i] = null;
        }
    }

    public RangeIterator getCheckIterator(RangeVariable rangeVariable) {
        int position = rangeVariable.rangePosition;
        if (position >= this.rangeIterators.length) {
            int size = (int)ArrayUtil.getBinaryNormalisedCeiling(position + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, size);
        }
        this.rangeIterators[position] = this.checkIterator;
        return this.checkIterator;
    }

    public void setRangeIterator(RangeIterator iterator) {
        int position = iterator.getRangePosition();
        if (position >= this.rangeIterators.length) {
            int size = (int)ArrayUtil.getBinaryNormalisedCeiling(position + 1);
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, size);
        }
        this.rangeIterators[position] = iterator;
    }

    public RangeIterator getRangeIterator(int position) {
        RangeIterator[] ranges = this.rangeIterators;
        if (this.stack != null) {
            for (int i = 0; i < this.stack.size(); ++i) {
                Object o = this.stack.get(i);
                if (!(o instanceof RangeIterator[])) continue;
                ranges = (RangeIterator[])o;
                break;
            }
        }
        return ranges[position];
    }

    public void unsetRangeIterator(RangeIterator iterator) {
        int position = iterator.getRangePosition();
        this.rangeIterators[position] = null;
    }

    public void setGroupSet(GroupSet set) {
        this.groupSet = set;
    }

    public void setGroup(List group) {
        this.currentGroup = group;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema variable) {
        int index = this.sessionVariables.size();
        if (!this.sessionVariables.add(variable.getName().name, variable)) {
            throw Error.error(5504);
        }
        Object[] vars = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, vars, this.routineVariables.length);
        this.routineVariables = vars;
        this.routineVariables[index] = variable.getDefaultValue(this.session);
    }

    public void pushRoutineTables() {
        this.popSessionTables = this.sessionTables;
        this.sessionTables = new OrderedHashMap();
    }

    public void popRoutineTables() {
        this.sessionTables.clear();
        this.sessionTables = this.popSessionTables;
    }

    public void addSessionTable(Table table) {
        if (this.sessionTables == null) {
            this.sessionTables = new OrderedHashMap();
        }
        if (this.sessionTables.containsKey(table.getName().name)) {
            throw Error.error(5504);
        }
        this.sessionTables.add(table.getName().name, table);
    }

    public void setSessionTables(Table[] tables) {
    }

    public Table findSessionTable(String name) {
        if (this.sessionTables == null) {
            return null;
        }
        return (Table)this.sessionTables.get(name);
    }

    public void dropSessionTable(String name) {
        this.sessionTables.remove(name);
    }
}

