/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.rights.User;

public class SessionManager {
    AtomicLong sessionIdCount = new AtomicLong();
    private LongKeyHashMap sessionMap = new LongKeyHashMap();
    private Session sysSession;
    private Session sysLobSession;

    public SessionManager(Database db) {
        User sysUser = db.getUserManager().getSysUser();
        this.sysSession = new Session(db, sysUser, false, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
        this.sysLobSession = new Session(db, sysUser, true, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
    }

    public synchronized Session newSession(Database db, User user, boolean readonly, boolean autoCommit, TimeZone zone) {
        long sessionId = this.sessionIdCount.getAndIncrement();
        Session s = new Session(db, user, autoCommit, readonly, sessionId, zone);
        this.sessionMap.put(sessionId, s);
        return s;
    }

    public synchronized Session newSessionForLog(Database db) {
        long sessionId = this.sessionIdCount.getAndIncrement();
        Session s = new Session(db, db.getUserManager().getSysUser(), false, false, sessionId, TimeZone.getTimeZone("GMT"));
        s.isProcessingLog = true;
        this.sessionMap.put(sessionId, s);
        return s;
    }

    public Session getSysSessionForScript(Database db) {
        Session session = new Session(db, db.getUserManager().getSysUser(), false, false, 0L, TimeZone.getTimeZone("GMT"));
        session.setCurrentSchemaHsqlName(db.schemaManager.defaultSchemaHsqlName);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public synchronized Session newSysSession() {
        long sessionId = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, sessionId, TimeZone.getTimeZone("GMT"));
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(sessionId, session);
        return session;
    }

    public synchronized Session newSysSession(HsqlNameManager.HsqlName schema, User user) {
        long sessionId = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, user, false, false, sessionId, TimeZone.getTimeZone("GMT"));
        session.currentSchema = schema;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Session[] sessions = this.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].close();
        }
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            this.sessionMap.clear();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long id) {
        return (Session)this.sessionMap.get(id);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessions = new Session[this.sessionMap.size()];
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            sessions[i] = (Session)it.next();
            ++i;
        }
        return sessions;
    }

    public synchronized boolean isUserActive(String userName) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (!session.isClosed() && userName.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName schemaName) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (session.getCurrentSchemaHsqlName() == schemaName) {
                session.resetSchema();
            }
            ++i;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            session.loggedSchema = null;
            ++i;
        }
        this.sysLobSession.loggedSchema = null;
    }
}

