/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class SetFunctionValueAggregate
implements SetFunction {
    private HashSet distinctValues;
    private final boolean isDistinct;
    private final Session session;
    private final int setType;
    private final int typeCode;
    private final Type type;
    private final Type returnType;
    private final TypedComparator comparator;
    private long count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long hiLong;
    private long loLong;
    private long fraction;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static final BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunctionValueAggregate(Session session, int setType, Type type, Type returnType, boolean isDistinct) {
        this.session = session;
        this.setType = setType;
        this.type = type;
        this.returnType = returnType;
        this.isDistinct = isDistinct;
        if (isDistinct) {
            if (type.isRowType() || type.isArrayType() || type.isCharacterType()) {
                this.comparator = new TypedComparator(session);
                this.comparator.setType(type, null);
                this.distinctValues = new HashSet(32, this.comparator);
            } else {
                this.comparator = null;
                this.distinctValues = new HashSet(32);
            }
        } else {
            this.comparator = null;
        }
        switch (setType) {
            case 82: 
            case 84: {
                this.sample = true;
            }
        }
        this.typeCode = type == null ? 0 : (type.isIntervalYearMonthType() ? 102 : (type.isIntervalDaySecondType() ? 106 : type.typeCode));
    }

    @Override
    public void reset() {
    }

    @Override
    public void add(Object itemLeft, Object itemRight) {
    }

    @Override
    public void add(Object item) {
        if (item == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(item)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 74: {
                return;
            }
            case 75: 
            case 78: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.loLong += (long)((Number)item).intValue();
                        return;
                    }
                    case 106: {
                        if (item instanceof IntervalSecondData) {
                            this.addLong(((IntervalSecondData)item).getSeconds());
                            this.fraction += (long)((IntervalSecondData)item).getNanos();
                            if (this.fraction > 1000000000L) {
                                this.addLong(this.fraction / 1000000000L);
                                this.fraction %= 1000000000L;
                            }
                        }
                        return;
                    }
                    case 102: {
                        if (item instanceof IntervalMonthData) {
                            this.addLong(((IntervalMonthData)item).units);
                        }
                        return;
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        this.addLong(((TimestampData)item).getSeconds());
                        this.fraction += (long)((TimestampData)item).getNanos();
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = ((TimestampData)item).getZone();
                        return;
                    }
                    case 92: 
                    case 94: {
                        this.addLong(((TimeData)item).getSeconds());
                        this.fraction += (long)((TimeData)item).getNanos();
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = ((TimeData)item).getZone();
                        return;
                    }
                    case 25: {
                        this.addLong(((Number)item).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)item).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)item : this.currentBigDecimal.add((BigDecimal)item);
                        return;
                    }
                }
                throw Error.error(5563);
            }
            case 76: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (this.type.compare(this.session, this.currentValue, item) > 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 77: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (this.type.compare(this.session, this.currentValue, item) < 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 79: {
                if (!(item instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.every = this.every && (Boolean)item != false;
                return;
            }
            case 80: {
                if (!(item instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.some = this.some || (Boolean)item != false;
                return;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                this.addDataPoint((Number)item);
                return;
            }
            case 100: {
                this.currentValue = item;
                return;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    @Override
    public void addGroup(SetFunction group) {
        SetFunctionValueAggregate item = (SetFunctionValueAggregate)group;
        if (this.isDistinct) {
            HashSet otherSet = item.distinctValues;
            Iterator it = otherSet.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                this.add(value);
            }
            return;
        }
        switch (this.setType) {
            case 74: {
                this.count += item.count;
                return;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                this.count += item.count;
                this.addDataGroup(item);
                return;
            }
            case 75: 
            case 78: {
                this.count += item.count;
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.loLong += item.loLong;
                        return;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 102: 
                    case 106: {
                        this.addLongGroup(item);
                        this.fraction += item.fraction;
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = item.currentDouble;
                        return;
                    }
                    case 25: {
                        this.addLongGroup(item);
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += item.currentDouble;
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? item.currentBigDecimal : this.currentBigDecimal.add(item.currentBigDecimal);
                        return;
                    }
                }
                throw Error.error(5563);
            }
        }
        this.add(group.getValue());
    }

    @Override
    public Object getValue() {
        if (this.hasNull) {
            this.session.addWarning(Error.error(1003));
        }
        if (this.setType == 74) {
            if (this.count > 1L && this.isDistinct && (this.type.isRowType() || this.type.isArrayType() || this.type.isCharacterType())) {
                Object[] array = this.distinctValues.toArray();
                ArraySort.sort(array, array.length, this.comparator);
                this.count = ArraySort.deDuplicate(array, array.length, this.comparator);
            }
            return ValuePool.getLong(this.count);
        }
        if (this.count == 0L) {
            return null;
        }
        switch (this.setType) {
            case 78: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        if (this.returnType.scale != 0) {
                            return this.returnType.divide(this.session, this.loLong, this.count);
                        }
                        return this.loLong / this.count;
                    }
                    case 25: {
                        long value = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return value;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.currentDouble / (double)this.count;
                    }
                    case 2: 
                    case 3: {
                        if (this.returnType.scale == this.type.scale) {
                            return this.currentBigDecimal.divide(new BigDecimal(this.count), RoundingMode.DOWN);
                        }
                        return this.returnType.divide(this.session, this.currentBigDecimal, this.count);
                    }
                    case 102: 
                    case 106: {
                        BigInteger[] bi = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bi[0]) != 0) {
                            throw Error.error(3435);
                        }
                        if (this.type.isIntervalDaySecondType()) {
                            long nanos = (this.fraction + bi[1].longValue() * 1000000000L) / this.count;
                            nanos = DTIType.normaliseFraction((int)nanos, this.type.scale);
                            return new IntervalSecondData(bi[0].longValue(), nanos, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bi[0].longValue(), (IntervalType)this.type);
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        BigInteger[] bi = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bi[0]) != 0) {
                            throw Error.error(3435);
                        }
                        long seconds = bi[0].longValue();
                        long nanos = (this.fraction + bi[1].longValue() * 1000000000L) / this.count;
                        nanos = DTIType.normaliseFraction((int)nanos, this.type.scale);
                        if (this.setType == 91) {
                            seconds = HsqlDateTime.getNormalisedDate(seconds);
                            nanos = 0L;
                        }
                        return new TimestampData(seconds, (int)nanos, 0);
                    }
                    case 92: 
                    case 94: {
                        BigInteger[] bi = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bi[0]) != 0) {
                            throw Error.error(3435);
                        }
                        long seconds = bi[0].longValue();
                        long nanos = (this.fraction + bi[1].longValue() * 1000000000L) / this.count;
                        nanos = DTIType.normaliseFraction((int)nanos, 0);
                        if (this.setType == 91) {
                            seconds = HsqlDateTime.getNormalisedDate(seconds);
                            nanos = 0L;
                        }
                        return new TimeData((int)seconds, (int)nanos, 0);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return this.loLong;
                    }
                    case 25: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.currentDouble;
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                    case 102: 
                    case 106: {
                        BigInteger bi = this.getLongSum();
                        if (NumberType.compareToLongLimits(bi) != 0) {
                            throw Error.error(3435);
                        }
                        if (this.type.isIntervalDaySecondType()) {
                            return new IntervalSecondData(bi.longValue(), this.fraction, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bi.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 76: 
            case 77: {
                return this.currentValue;
            }
            case 79: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 80: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 81: 
            case 82: {
                return this.getStdDev();
            }
            case 83: 
            case 84: {
                return this.getVariance();
            }
            case 100: {
                return this.currentValue;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    private void addLong(long value) {
        if (value != 0L) {
            if (value > 0L) {
                this.hiLong += value >> 32;
                this.loLong += value & 0xFFFFFFFFL;
            } else if (value == Long.MIN_VALUE) {
                this.hiLong -= 0x80000000L;
            } else {
                long temp = (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hiLong -= temp >> 32;
                this.loLong -= temp & 0xFFFFFFFFL;
            }
        }
    }

    private void addLongGroup(SetFunctionValueAggregate item) {
        this.addLong(item.loLong);
        this.hiLong += item.hiLong;
    }

    private BigInteger getLongSum() {
        BigInteger biglo = BigInteger.valueOf(this.loLong);
        BigInteger bighi = BigInteger.valueOf(this.hiLong);
        BigInteger result = bighi.multiply(multiplier).add(biglo);
        return result;
    }

    private void addDataPoint(Number x) {
        if (x == null) {
            return;
        }
        double xi = x.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = xi;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long nm1 = this.n - 1L;
        double xsi = this.sk - xi * (double)nm1;
        this.vk += xsi * xsi / (double)this.n / (double)nm1;
        this.sk += xi;
    }

    private void addDataGroup(SetFunctionValueAggregate value) {
        if (value == null || value.count == 0L) {
            return;
        }
        if (!this.initialized) {
            this.n = value.n;
            this.sk = value.sk;
            this.vk = value.vk;
            this.initialized = true;
            return;
        }
        double cm = (this.sk + value.sk) / (double)(this.n + value.n);
        this.vk = this.vk + value.vk + (double)this.n * (this.sk / (double)this.n - cm) * (this.sk / (double)this.n - cm) + (double)value.n * (value.sk / (double)value.n - cm) * (value.sk / (double)value.n - cm);
        this.sk += value.sk;
        this.n += value.n;
    }

    private Double getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : Double.valueOf(this.vk / (double)(this.n - 1L))) : Double.valueOf(this.vk / (double)this.n);
    }

    private Double getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : Double.valueOf(Math.sqrt(this.vk / (double)(this.n - 1L)))) : Double.valueOf(Math.sqrt(this.vk / (double)this.n));
    }
}

