/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TablePeriodWorks;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVLCheck;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.ScriptLoader;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TextFileOps;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.scriptio.ScriptWriterTextColumnNames;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class StatementCommand
extends Statement {
    Object[] arguments;

    StatementCommand(int type, Object[] args) {
        this(type, args, null, null);
    }

    StatementCommand(int type, Object[] args, HsqlNameManager.HsqlName[] readNames, HsqlNameManager.HsqlName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.arguments = args;
        if (readNames != null) {
            this.readTableNames = readNames;
        }
        if (writeNames != null) {
            this.writeTableNames = writeNames;
        }
        switch (type) {
            case 1215: {
                this.group = 2014;
                break;
            }
            case 1150: 
            case 1151: {
                this.group = 2009;
                this.statementReturnType = 2;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String name = (String)this.arguments[0];
                if (name == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 909: 
            case 910: 
            case 1005: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1006: {
                this.statementReturnType = 2;
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1001: {
                this.group = 2014;
                if (writeNames.length == 0) {
                    this.group = 2015;
                }
                this.isLogged = false;
                break;
            }
            case 1052: {
                this.group = 2014;
                break;
            }
            case 1016: 
            case 1032: 
            case 1033: 
            case 1056: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1015: 
            case 1017: 
            case 1018: 
            case 1020: 
            case 1021: 
            case 1022: 
            case 1025: 
            case 1026: 
            case 1031: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1039: 
            case 1040: 
            case 1046: 
            case 1047: 
            case 1049: 
            case 1050: 
            case 1051: 
            case 1053: 
            case 1054: 
            case 1055: 
            case 1057: {
                this.group = 2013;
                break;
            }
            case 1014: {
                this.group = 2013;
                this.isLogged = false;
                break;
            }
            case 1159: 
            case 1160: 
            case 1161: {
                this.group = 2012;
                break;
            }
            case 1157: {
                this.group = 2012;
                this.isLogged = false;
                break;
            }
            case 1156: {
                this.group = 2012;
                break;
            }
            case 1155: {
                this.group = 2012;
                break;
            }
            case 1003: {
                this.group = 2014;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1158: {
                this.group = 2012;
                break;
            }
            case 1154: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1091: 
            case 1092: 
            case 1093: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1120: {
                this.group = 2011;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, this.getSQL());
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.getSQL());
        }
        return result;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1215: {
                return this.getTruncateResult(session);
            }
            case 1150: {
                OrderedHashSet set;
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                boolean referenceFrom = (Boolean)this.arguments[1];
                if (referenceFrom) {
                    SchemaObject object = session.database.schemaManager.getSchemaObject(name);
                    set = object.getReferences();
                    if (set == null) {
                        set = new OrderedHashSet();
                    }
                } else {
                    set = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesTo(name, set);
                }
                String[] names = new String[]{"OBJCT_TYPE", "OBJECT_NAME"};
                Type[] types = new Type[]{Type.SQL_VARCHAR_DEFAULT, Type.SQL_VARCHAR_DEFAULT};
                Result result = Result.newMultiColumnResult(names, types);
                for (int i = 0; i < set.size(); ++i) {
                    HsqlNameManager.HsqlName current = (HsqlNameManager.HsqlName)set.get(i);
                    Object[] data = new Object[]{SchemaObjectSet.getName(current.type), current.getSchemaQualifiedStatementName()};
                    result.navigator.add(data);
                }
                return result;
            }
            case 1151: {
                Statement statement = (Statement)this.arguments[0];
                return Result.newSingleColumnStringResult("PLAN", statement.describe(session));
            }
            case 1001: {
                String path = (String)this.arguments[0];
                boolean blocking = (Boolean)this.arguments[1];
                boolean script = (Boolean)this.arguments[2];
                boolean compressed = (Boolean)this.arguments[3];
                boolean files = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    if (session.database.getType() != DatabaseType.DB_FILE) {
                        throw Error.error(459);
                    }
                    if (session.database.isFilesReadOnly()) {
                        throw Error.error(455);
                    }
                    session.database.logger.backup(path, script, blocking, compressed, files);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1002: {
                boolean defrag = (Boolean)this.arguments[0];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.checkpoint(session, defrag, true);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1011: {
                return Result.updateZeroResult;
            }
            case 1012: {
                try {
                    int value = (Integer)this.arguments[0];
                    boolean check = this.arguments[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (check) {
                        value = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.cache_rows", value);
                    }
                    session.database.logger.setCacheMaxRows(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1013: {
                try {
                    int value = (Integer)this.arguments[0];
                    boolean check = this.arguments[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (check) {
                        value = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.cache_size", value);
                    }
                    session.database.logger.setCacheSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1014: {
                try {
                    long value1 = (Long)this.arguments[0];
                    long value2 = (Long)this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setFilesTimestamp(value1);
                        session.database.txManager.setSystemChangeNumber(value1 + 1L);
                    } else if (session.isProcessingLog() && value2 > 0L) {
                        session.database.logger.setFilesTimestamp(value1);
                        session.database.txManager.setSystemChangeNumber(value1 + 1L);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1017: {
                try {
                    int value = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setLobFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean mode = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileCompressedNoCheck(mode);
                    } else {
                        session.database.logger.setLobFileCompressed(mode);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1025: {
                try {
                    int value = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setDataFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setDataFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1031: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.database.getType() == DatabaseType.DB_RES) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.isFilesReadOnly()) {
                        return Result.updateZeroResult;
                    }
                    if (this.arguments[0] instanceof Boolean) {
                        boolean value = (Boolean)this.arguments[0];
                        session.database.logger.setDataFileSpace(value);
                    } else {
                        int value = (Integer)this.arguments[0];
                        session.database.logger.setDataFileSpace(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1015: {
                try {
                    int value = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!HsqlDatabaseProperties.validateProperty("hsqldb.defrag_limit", value)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setDefagLimit(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1016: {
                try {
                    int value = (Integer)this.arguments[0];
                    boolean isSql = (Boolean)this.arguments[1];
                    boolean internal = (Boolean)this.arguments[2];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (internal) {
                        session.database.logger.setEventLogLevel(value, isSql);
                    } else {
                        session.database.logger.setExternalEventLogLevel(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1022: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object v = this.arguments[0];
                    if (v instanceof Boolean) {
                        boolean value = (Boolean)this.arguments[0];
                        session.database.logger.setNioDataFile(value);
                    } else {
                        int value = (Integer)this.arguments[0];
                        value = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.nio_max_size", value);
                        session.database.logger.setNioMaxSize(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1020: {
                try {
                    boolean value = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1021: {
                try {
                    int value = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    value = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.log_size", value);
                    session.database.logger.setLogSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1032: {
                try {
                    String value = (String)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1026: {
                try {
                    int value = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1033: {
                try {
                    int value = (Integer)this.arguments[0];
                    value = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.write_delay_millis", value);
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1036: {
                try {
                    Routine routine = (Routine)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setExtAuthenticationFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1040: {
                try {
                    Routine routine = (Routine)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setPasswordCheckFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1057: {
                try {
                    String algo = (String)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    session.database.granteeManager.setDigestAlgo(algo);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1047: {
                try {
                    String name = (String)this.arguments[0];
                    boolean padSpaces = (Boolean)this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(name, padSpaces);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1049: {
                boolean mode = (Boolean)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.setReferentialIntegrity(mode);
                return Result.updateZeroResult;
            }
            case 1050: {
                String property = (String)this.arguments[0];
                boolean mode = (Boolean)this.arguments[1];
                int value = ((Number)this.arguments[2]).intValue();
                session.checkAdmin();
                session.checkDDLWrite();
                if ("sql.live_object".equals(property)) {
                    session.database.setLiveObject(mode);
                } else if ("sql.restrict_exec".equals(property)) {
                    session.database.setRestrictExec(mode);
                } else if ("sql.enforce_names".equals(property)) {
                    session.database.setStrictNames(mode);
                } else if ("sql.regular_names".equals(property)) {
                    session.database.setRegularNames(mode);
                } else if ("sql.enforce_size".equals(property)) {
                    session.database.setStrictColumnSize(mode);
                } else if ("sql.enforce_types".equals(property)) {
                    session.database.setStrictTypes(mode);
                } else if ("sql.enforce_refs".equals(property)) {
                    session.database.setStrictReferences(mode);
                } else if ("sql.enforce_tdc_delete".equals(property)) {
                    session.database.setStrictTDCD(mode);
                } else if ("sql.enforce_tdc_update".equals(property)) {
                    session.database.setStrictTDCU(mode);
                } else if ("jdbc.translate_tti_types".equals(property)) {
                    session.database.setTranslateTTI(mode);
                } else if ("sql.char_literal".equals(property)) {
                    session.database.setCharacterLiteral(mode);
                } else if ("sql.concat_nulls".equals(property)) {
                    session.database.setConcatNulls(mode);
                } else if ("sql.nulls_first".equals(property)) {
                    session.database.setNullsFirst(mode);
                } else if ("sql.nulls_order".equals(property)) {
                    session.database.setNullsOrder(mode);
                } else if ("sql.unique_nulls".equals(property)) {
                    session.database.setUniqueNulls(mode);
                } else if ("sql.convert_trunc".equals(property)) {
                    session.database.setConvertTrunc(mode);
                } else if ("sql.truncate_trailing".equals(property)) {
                    session.database.setTruncateTrailing(mode);
                } else if ("sql.avg_scale".equals(property)) {
                    value = HsqlDatabaseProperties.getPropertyWithinRange("sql.avg_scale", value);
                    session.database.setAvgScale(value);
                } else if ("sql.max_recursive".equals(property)) {
                    value = HsqlDatabaseProperties.getPropertyWithinRange("sql.max_recursive", value);
                    session.database.setMaxRecursive(value);
                } else if ("sql.double_nan".equals(property)) {
                    session.database.setDoubleNaN(mode);
                } else if ("sql.longvar_is_lob".equals(property)) {
                    session.database.setLongVarIsLob(mode);
                } else if ("sql.ignore_case".equals(property)) {
                    session.database.setIgnoreCase(mode);
                    session.setIgnoreCase(mode);
                } else if ("sql.syntax_db2".equals(property)) {
                    session.database.setSyntaxDb2(mode);
                } else if ("sql.syntax_mss".equals(property)) {
                    session.database.setSyntaxMss(mode);
                } else if ("sql.syntax_mys".equals(property)) {
                    session.database.setSyntaxMys(mode);
                } else if ("sql.syntax_ora".equals(property)) {
                    session.database.setSyntaxOra(mode);
                } else if ("sql.syntax_pgs".equals(property)) {
                    session.database.setSyntaxPgs(mode);
                } else if ("sql.sys_index_names".equals(property)) {
                    session.database.setSysIndexNames(mode);
                } else if ("sql.lowercase_ident".equals(property)) {
                    session.database.setLowerCaseIndentifer(mode);
                }
                return Result.updateZeroResult;
            }
            case 1034: {
                HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultSchemaHsqlName(schema);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1035: {
                Integer type = (Integer)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultTableType(type);
                return Result.updateZeroResult;
            }
            case 1052: {
                try {
                    int mode = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.txManager.setTransactionControl(session, mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1053: {
                try {
                    int mode = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.defaultIsolationLevel = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1054: {
                try {
                    boolean mode = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.database.txConflictRollback = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1055: {
                try {
                    boolean mode = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.database.txInterruptRollback = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1037: {
                try {
                    int count = (Integer)this.arguments[0];
                    session.checkAdmin();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1039: {
                try {
                    String property = (String)this.arguments[0];
                    Object value = this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1046: {
                int size = (Integer)this.arguments[0];
                session.checkAdmin();
                size = HsqlDatabaseProperties.getPropertyWithinRange("hsqldb.result_max_memory_rows", size);
                session.database.setResultMaxMemoryRows(size);
                return Result.updateZeroResult;
            }
            case 1051: {
                try {
                    String source = (String)this.arguments[0];
                    HsqlProperties props = null;
                    session.checkAdmin();
                    if (source.length() > 0) {
                        props = HsqlProperties.delimitedArgPairsToProps(source, "=", ";", null);
                        if (props.getErrorKeys().length > 0) {
                            throw Error.error(482, props.getErrorKeys()[0]);
                        }
                        session.database.logger.setDefaultTextTableProperties(source, props);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1056: {
                try {
                    String name = (String)this.arguments[0];
                    session.checkAdmin();
                    session.database.setDatabaseName(name);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText dsw = null;
                String name = (String)this.arguments[0];
                Integer scope = (Integer)this.arguments[1];
                Integer type = (Integer)this.arguments[2];
                Boolean colNames = (Boolean)this.arguments[3];
                HsqlNameManager.HsqlName tableName = (HsqlNameManager.HsqlName)this.arguments[4];
                TimestampData timestamp = (TimestampData)this.arguments[5];
                try {
                    if (!session.getGrantee().canPerformScriptOps()) {
                        throw Error.error(5507);
                    }
                    if (name == null) {
                        return session.database.getScript(false);
                    }
                    dsw = colNames != false ? new ScriptWriterTextColumnNames(session.database, name) : new ScriptWriterText(session.database, name, true, true, true);
                    switch (type) {
                        case 2: {
                            dsw.writeAll();
                            break;
                        }
                        case 561: {
                            dsw.writeDDL();
                            break;
                        }
                        case 400: {
                            if (tableName == null) {
                                dsw.writeExistingData(false);
                                break;
                            }
                            Table table = session.database.schemaManager.getUserTable(tableName);
                            dsw.setIncludeTableInit(true);
                            dsw.writeTableData(table);
                            break;
                        }
                        case 331: {
                            dsw.writeVersioningData(timestamp);
                        }
                    }
                    dsw.close();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1003: {
                try {
                    int mode = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.close(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1005: {
                try {
                    String pathName = (String)this.arguments[0];
                    int mode = (Integer)this.arguments[1];
                    Boolean isVersioning = (Boolean)this.arguments[2];
                    if (!session.getGrantee().canPerformScriptOps()) {
                        throw Error.error(5507);
                    }
                    return ScriptLoader.loadScriptData(session, pathName, mode, isVersioning);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 909: {
                try {
                    HsqlNameManager.HsqlName tableName = (HsqlNameManager.HsqlName)this.arguments[0];
                    String textprops = (String)this.arguments[1];
                    int mode = (Integer)this.arguments[2];
                    Table table = session.database.schemaManager.findTable(session, tableName.name, tableName.schema.name, null);
                    if (table == null) {
                        throw Error.error(5501, tableName.getSchemaQualifiedStatementName());
                    }
                    if (!session.getGrantee().canPerformScriptOps()) {
                        throw Error.error(5507);
                    }
                    return TextFileOps.loadTextData(session, textprops, table, mode);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 910: {
                try {
                    HsqlNameManager.HsqlName tableName = (HsqlNameManager.HsqlName)this.arguments[0];
                    String textprops = (String)this.arguments[1];
                    Table table = session.database.schemaManager.findTable(session, tableName.name, tableName.schema.name, null);
                    if (table == null) {
                        throw Error.error(5501, tableName.getSchemaQualifiedStatementName());
                    }
                    if (!session.getGrantee().canPerformScriptOps()) {
                        throw Error.error(5507);
                    }
                    return TextFileOps.unloadTextData(session, textprops, table);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1006: {
                try {
                    Result result;
                    HsqlNameManager.HsqlName tableName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int type = (Integer)this.arguments[1];
                    if (tableName == null) {
                        result = IndexAVLCheck.checkAllTables(session, type);
                    } else {
                        Table table = session.database.schemaManager.getUserTable(tableName);
                        result = IndexAVLCheck.checkTable(session, table, type);
                    }
                    return result;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1160: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    Table table = session.database.schemaManager.getUserTable(name);
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.logger.isFileDatabase()) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.logger.getDataFileSpace() == 0) {
                        throw Error.error(457);
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache cache = session.database.logger.getCache();
                    if (cache == null) {
                        return Result.updateZeroResult;
                    }
                    DataSpaceManager dataSpace = cache.spaceManager;
                    int tableSpaceID = dataSpace.getNewTableSpaceID();
                    table.setSpaceID(tableSpaceID);
                    if (!table.isCached()) {
                        return Result.updateZeroResult;
                    }
                    if (!dataSpace.isMultiSpace()) {
                        return Result.updateZeroResult;
                    }
                    RowStoreAVLDisk store = (RowStoreAVLDisk)table.getRowStore(session);
                    store.setSpaceManager(session);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1161: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int spaceid = (Integer)this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(name);
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    if (table.getTableType() != 5) {
                        return Result.updateZeroResult;
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache cache = session.database.logger.getCache();
                    if (cache == null) {
                        return Result.updateZeroResult;
                    }
                    table.setSpaceID(spaceid);
                    DataSpaceManager dataSpace = cache.spaceManager;
                    TableSpaceManager tableSpace = dataSpace.getTableSpace(table.getSpaceID());
                    PersistentStore store = table.getRowStore(session);
                    store.setSpaceManager(tableSpace);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1159: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int[] colIndex = (int[])this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index = table.getIndexForColumns(colIndex);
                    if (index != null) {
                        Index[] indexes = table.getIndexList();
                        for (int i = 0; i < indexes.length; ++i) {
                            indexes[i].setClustered(false);
                        }
                        index.setClustered(true);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1154: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    String value = (String)this.arguments[1];
                    Integer type = (Integer)this.arguments[2];
                    Table table = session.database.schemaManager.getUserTable(name);
                    if (session.isProcessingScript()) {
                        table.setIndexRoots(session, value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1155: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    Table table = session.database.schemaManager.getUserTable(name);
                    boolean mode = (Boolean)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(mode);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1156: 
            case 1157: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Boolean mode = (Boolean)this.arguments[1];
                String source = (String)this.arguments[2];
                Boolean isDesc = (Boolean)this.arguments[3];
                Boolean isHeader = (Boolean)this.arguments[4];
                Table table = null;
                try {
                    table = session.database.schemaManager.getUserTable(name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        HsqlException e = Error.error(321);
                        return Result.newErrorResult(e, this.sql);
                    }
                    if (mode != null) {
                        if (mode.booleanValue()) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    if (isHeader.booleanValue()) {
                        ((TextTable)table).setHeader(source);
                    } else {
                        ((TextTable)table).setDataSource(session, source, isDesc, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable e2) {
                    HsqlException e2;
                    if (!(e2 instanceof HsqlException)) {
                        e2 = Error.error(e2, 467, e2.toString());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(e2);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", e2);
                        ((TextTable)table).setDataSource(source, isDesc);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e2, this.sql);
                }
            }
            case 1158: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int type = (Integer)this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(name);
                    int oldType = table.getTableType();
                    PersistentStore oldStore = table.getRowStore(session);
                    if (oldType == type) {
                        return Result.updateZeroResult;
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tw = new TableWorks(session, table);
                    boolean result = tw.setTableType(type);
                    if (!result) {
                        throw Error.error(467);
                    }
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    if (name.schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        session.database.lobManager.compileStatements();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1091: {
                User user = (User)this.arguments[0];
                boolean mode = (Boolean)this.arguments[1];
                session.checkAdmin();
                session.checkDDLWrite();
                user.isLocalOnly = mode;
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1092: {
                try {
                    User user = (User)this.arguments[0];
                    HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.arguments[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getName().getNameString());
                    }
                    if (schema != null) {
                        schema = session.database.schemaManager.getSchemaHsqlName(schema.name);
                    }
                    user.setInitialSchema(schema);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1093: {
                try {
                    User user = this.arguments[0] == null ? session.getUser() : (User)this.arguments[0];
                    String password = (String)this.arguments[1];
                    boolean isDigest = (Boolean)this.arguments[2];
                    session.checkDDLWrite();
                    session.database.userManager.setPassword(session, user, password, isDigest);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1120: {
                try {
                    long sessionID = ((Number)this.arguments[0]).longValue();
                    int action = ((Number)this.arguments[1]).intValue();
                    Session targetSession = session.database.sessionManager.getSession(sessionID);
                    if (targetSession == null) {
                        throw Error.error(4500);
                    }
                    switch (action) {
                        case 2: {
                            session.database.txManager.resetSession(session, targetSession, Long.MAX_VALUE, 3);
                            break;
                        }
                        case 294: {
                            session.database.txManager.resetSession(session, targetSession, Long.MAX_VALUE, 2);
                            break;
                        }
                        case 250: {
                            session.database.txManager.resetSession(session, targetSession, Long.MAX_VALUE, 1);
                            break;
                        }
                        case 42: {
                            session.database.txManager.resetSession(session, targetSession, Long.MAX_VALUE, 6);
                            break;
                        }
                        case 247: {
                            session.database.txManager.resetSession(session, targetSession, Long.MAX_VALUE, 4);
                            break;
                        }
                        case 99: {
                            if (session == targetSession) {
                                return Result.updateZeroResult;
                            }
                            session.database.txManager.resetSession(session, targetSession, targetSession.statementStartSCN, 5);
                        }
                    }
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatementCommand");
    }

    Result getTruncateResult(Session session) {
        try {
            Table[] tables;
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
            boolean restartIdentity = (Boolean)this.arguments[1];
            boolean noCheck = (Boolean)this.arguments[2];
            TimestampData timestamp = (TimestampData)this.arguments[3];
            if (name.type == 3) {
                Table table = session.database.schemaManager.getUserTable(name);
                tables = new Table[]{table};
                session.getGrantee().checkDelete(table);
                if (timestamp != null) {
                    TablePeriodWorks works = new TablePeriodWorks(session, table);
                    long count = works.removeOldRows(timestamp.getSeconds());
                    return Result.newUpdateCountResult(0);
                }
                if (!noCheck) {
                    for (int i = 0; i < table.fkMainConstraints.length; ++i) {
                        HsqlNameManager.HsqlName tableName;
                        Table refTable;
                        if (table.fkMainConstraints[i].getRef() == table || (refTable = session.database.schemaManager.getUserTable(tableName = table.fkMainConstraints[i].getRef().getName())).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getName().name);
                    }
                }
            } else {
                session.database.schemaManager.getSchemaHsqlName(name.name);
                OrderedHashMap list = session.database.schemaManager.getTables(name.name);
                tables = new Table[list.size()];
                list.valuesToArray(tables);
                StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                if (!noCheck) {
                    OrderedHashSet set = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesToSchema(name, set);
                    for (int i = 0; i < set.size(); ++i) {
                        Table refTable;
                        HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(i);
                        if (objectName.type != 5 || objectName.parent.type != 3 || (refTable = session.database.schemaManager.getUserTable(objectName.parent)).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getName().name);
                    }
                }
                if (restartIdentity) {
                    Iterator it = session.database.schemaManager.databaseObjectIterator(name.name, 7);
                    while (it.hasNext()) {
                        NumberSequence sequence = (NumberSequence)it.next();
                        sequence.reset();
                    }
                }
            }
            for (int i = 0; i < tables.length; ++i) {
                Table table = tables[i];
                PersistentStore store = table.getRowStore(session);
                store.removeAll();
                if (!restartIdentity || table.identitySequence == null) continue;
                table.identitySequence.reset();
            }
            return Result.updateZeroResult;
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e, this.sql);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 1151: {
                return ResultMetaData.newSingleColumnMetaData("PLAN");
            }
            case 1150: {
                return ResultMetaData.newSingleColumnMetaData("REFERENCES");
            }
            case 1004: {
                if (this.statementReturnType == 2) {
                    return ResultMetaData.newSingleColumnMetaData("STATEMENTS");
                }
                return super.getResultMetaData();
            }
        }
        return super.getResultMetaData();
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

