/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementCompound
extends Statement
implements RangeGroup {
    final boolean isLoop;
    HsqlNameManager.HsqlName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    boolean hasUndoHandler;
    StatementQuery loopCursor;
    Statement[] statements;
    StatementExpression condition;
    boolean isAtomic;
    ColumnSchema[] variables = ColumnSchema.emptyArray;
    StatementCursor[] cursors = StatementCursor.emptyArray;
    OrderedHashMap scopeVariables = new OrderedHashMap();
    RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    Table[] tables = Table.emptyArray;
    OrderedHashMap scopeTables;
    int variablesOffset;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    StatementCompound(int type, HsqlNameManager.HsqlName label, StatementCompound parent) {
        super(type, 2007);
        this.label = label;
        this.isTransactionStatement = false;
        switch (type) {
            case 101: 
            case 105: 
            case 107: 
            case 110: {
                this.isLoop = true;
                break;
            }
            case 99: 
            case 102: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        this.parent = parent;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    boolean isLoop() {
        return this.isLoop;
    }

    void setLocalDeclarations(Object[] declarations) {
        int i;
        int varCount = 0;
        int handlerCount = 0;
        int cursorCount = 0;
        int tableCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                ++varCount;
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                ++handlerCount;
                continue;
            }
            if (declarations[i] instanceof Table) {
                ++tableCount;
                continue;
            }
            ++cursorCount;
        }
        if (varCount > 0) {
            this.variables = new ColumnSchema[varCount];
        }
        if (handlerCount > 0) {
            this.handlers = new StatementHandler[handlerCount];
        }
        if (tableCount > 0) {
            this.tables = new Table[tableCount];
        }
        if (cursorCount > 0) {
            this.cursors = new StatementCursor[cursorCount];
        }
        varCount = 0;
        handlerCount = 0;
        tableCount = 0;
        cursorCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof StatementCursor) {
                StatementCursor cursor = (StatementCursor)declarations[i];
                this.cursors[cursorCount++] = cursor;
                continue;
            }
            if (declarations[i] instanceof ColumnSchema) {
                this.variables[varCount++] = (ColumnSchema)declarations[i];
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                StatementHandler handler = (StatementHandler)declarations[i];
                handler.setParent(this);
                this.handlers[handlerCount++] = handler;
                if (handler.handlerType != 7) continue;
                this.hasUndoHandler = true;
                continue;
            }
            if (!(declarations[i] instanceof Table)) continue;
            Table table = (Table)declarations[i];
            this.tables[tableCount++] = table;
        }
        this.setVariables();
        this.setHandlers();
        this.setTables();
        this.setCursors();
    }

    void setLoopStatement(HsqlNameManager.HsqlName name, StatementQuery cursorStatement) {
        this.loopCursor = cursorStatement;
        HsqlNameManager.HsqlName[] colNames = cursorStatement.queryExpression.getResultColumnNames();
        Type[] colTypes = cursorStatement.queryExpression.getColumnTypes();
        Object[] columns = new ColumnSchema[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            columns[i] = new ColumnSchema(colNames[i], colTypes[i], false, false, null);
            ((ColumnBase)columns[i]).setParameterMode((byte)1);
        }
        this.setLocalDeclarations(columns);
    }

    void setStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.statements = statements;
    }

    void setCondition(StatementExpression condition) {
        this.condition = condition;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        switch (this.type) {
            case 99: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 101: {
                result = this.executeForLoop(session);
                break;
            }
            case 105: 
            case 107: 
            case 110: {
                result = this.executeLoop(session);
                break;
            }
            case 102: {
                result = this.executeIf(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result executeBlock(Session session) {
        boolean push;
        Result result = Result.updateZeroResult;
        boolean bl = push = !this.root.isTrigger();
        if (push) {
            session.sessionContext.push();
            if (this.hasUndoHandler) {
                String name = HsqlNameManager.getAutoSavepointNameString(session.actionSCN, session.sessionContext.depth);
                session.savepoint(name);
            }
        }
        for (int i = 0; i < this.statements.length; ++i) {
            result = this.executeProtected(session, this.statements[i]);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42 || result.getType() == 3) break;
        }
        if (result.getType() == 42 && result.getErrorCode() == 104) {
            if (result.getMainString() == null) {
                result = Result.updateZeroResult;
            } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                result = Result.updateZeroResult;
            }
        }
        if (push) {
            session.sessionContext.pop();
        }
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String sqlState = null;
        if (result.isError()) {
            sqlState = result.getSubString();
        } else if (session.getLastWarning() != null) {
            sqlState = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (sqlState != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler handler = this.handlers[i];
                session.clearWarnings();
                if (!handler.handlesCondition(sqlState)) continue;
                String labelString = this.label == null ? null : this.label.name;
                switch (handler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        if (session.sessionContext.savepoints.size() > 0) {
                            session.rollbackToSavepoint();
                        }
                        result = Result.newPSMResult(104, labelString, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(104, labelString, null);
                    }
                }
                Result actionResult = this.executeProtected(session, handler);
                if (actionResult.isError()) {
                    result = actionResult;
                    continue;
                }
                if (actionResult.getType() != 42) continue;
                result = actionResult;
            }
            if (result.isError() && this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeForLoop(Session session) {
        Result queryResult = this.loopCursor.execute(session);
        if (queryResult.isError()) {
            return queryResult;
        }
        Result result = Result.updateZeroResult;
        while (queryResult.navigator.next()) {
            Object[] data = queryResult.navigator.getCurrent();
            this.initialiseVariables(session, data, queryResult.metaData.getColumnCount());
            for (int i = 0; i < this.statements.length; ++i) {
                result = this.executeProtected(session, this.statements[i]);
                if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42 || result.getType() == 3) break;
            }
            if (result.isError()) break;
            if (result.getType() == 42) {
                if (result.getErrorCode() == 103) {
                    if (result.getMainString() != null && (this.label == null || !this.label.name.equals(result.getMainString()))) break;
                    continue;
                }
                if (result.getErrorCode() != 104) break;
                break;
            }
            if (result.getType() != 3) continue;
            break;
        }
        queryResult.navigator.release();
        return result;
    }

    private Result executeLoop(Session session) {
        Result result;
        block9: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 110) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block9;
                    if (!Boolean.TRUE.equals(result.getValueObject())) {
                        result = Result.updateZeroResult;
                        break block9;
                    }
                }
                for (int i = 0; i < this.statements.length; ++i) {
                    result = this.executeProtected(session, this.statements[i]);
                    if ((result = this.handleCondition(session, result)).getType() == 42 || result.getType() == 3) break;
                }
                if (result.isError()) break block9;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 103) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block9;
                    }
                    if (result.getErrorCode() != 104) break block9;
                    if (result.getMainString() == null) {
                        result = Result.updateZeroResult;
                    }
                    if (this.label != null && this.label.name.equals(result.getMainString())) {
                        result = Result.updateZeroResult;
                    }
                    break block9;
                }
                if (result.getType() == 3) break block9;
                if (this.type != 107) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block9;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean execute = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1211) {
                if (execute || (result = this.executeProtected(session, this.statements[i])).isError()) break;
                Object value = result.getValueObject();
                execute = Boolean.TRUE.equals(value);
                ++i;
            }
            result = Result.updateZeroResult;
            if (!execute) continue;
            result = this.executeProtected(session, this.statements[i]);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42) break;
        }
        return result;
    }

    private Result executeProtected(Session session, Statement statement) {
        long actionTimestamp;
        int actionIndex = session.rowActionList.size();
        session.actionSCN = actionTimestamp = session.database.txManager.getNextSystemChangeNumber();
        Result result = statement.execute(session);
        if (result.isError()) {
            session.rollbackAction(actionIndex, actionTimestamp);
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        int i;
        int i2;
        for (i2 = 0; i2 < this.statements.length; ++i2) {
            if (this.statements[i2].getType() == 104 || this.statements[i2].getType() == 103) {
                if (this.findLabel((StatementSimple)this.statements[i2])) continue;
                throw Error.error(5508, ((StatementSimple)this.statements[i2]).label.name);
            }
            if (this.statements[i2].getType() != 62 || this.root.isFunction()) continue;
            throw Error.error(5602, "RETURN");
        }
        for (i2 = 0; i2 < this.statements.length; ++i2) {
            this.statements[i2].resolve(session);
        }
        for (i2 = 0; i2 < this.handlers.length; ++i2) {
            this.handlers[i2].resolve(session);
        }
        OrderedHashSet<HsqlNameManager.HsqlName> writeTableNamesSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> readTableNamesSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet set = new OrderedHashSet();
        for (i = 0; i < this.variables.length; ++i) {
            OrderedHashSet refs = this.variables[i].getReferences();
            if (refs == null) continue;
            set.addAll(refs);
        }
        if (this.loopCursor != null) {
            set.addAll(this.loopCursor.getReferences());
            readTableNamesSet.addAll(this.loopCursor.getTableNamesForRead());
        }
        if (this.condition != null) {
            set.addAll(this.condition.getReferences());
            readTableNamesSet.addAll(this.condition.getTableNamesForRead());
        }
        for (i = 0; i < this.statements.length; ++i) {
            set.addAll(this.statements[i].getReferences());
            readTableNamesSet.addAll(this.statements[i].getTableNamesForRead());
            writeTableNamesSet.addAll(this.statements[i].getTableNamesForWrite());
        }
        for (i = 0; i < this.handlers.length; ++i) {
            set.addAll(this.handlers[i].getReferences());
            readTableNamesSet.addAll(this.handlers[i].getTableNamesForRead());
            writeTableNamesSet.addAll(this.handlers[i].getTableNamesForWrite());
        }
        readTableNamesSet.removeAll(writeTableNamesSet);
        this.readTableNames = new HsqlNameManager.HsqlName[readTableNamesSet.size()];
        readTableNamesSet.toArray(this.readTableNames);
        this.writeTableNames = new HsqlNameManager.HsqlName[writeTableNamesSet.size()];
        writeTableNamesSet.toArray(this.writeTableNames);
        this.references = set;
    }

    @Override
    public void setRoot(Routine routine) {
        this.root = routine;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    public void setAtomic(boolean atomic) {
        this.isAtomic = atomic;
    }

    private void setVariables() {
        int i;
        OrderedHashMap list = new OrderedHashMap();
        if (this.parent != null && this.parent.scopeVariables != null) {
            for (i = 0; i < this.parent.scopeVariables.size(); ++i) {
                list.add(this.parent.scopeVariables.getKeyAt(i), this.parent.scopeVariables.get(i));
            }
        }
        this.variablesOffset = list.size();
        for (i = 0; i < this.variables.length; ++i) {
            String name = this.variables[i].getName().name;
            boolean added = list.add(name, this.variables[i]);
            if (!added) {
                throw Error.error(5606, name);
            }
            if (this.root.getParameterIndex(name) == -1) continue;
            throw Error.error(5606, name);
        }
        this.scopeVariables = list;
        RangeVariable[] parameterRangeVariables = this.root.getRangeVariables();
        RangeVariable range = new RangeVariable(list, null, true, 4);
        this.rangeVariables = new RangeVariable[parameterRangeVariables.length + 1];
        for (int i2 = 0; i2 < parameterRangeVariables.length; ++i2) {
            this.rangeVariables[i2] = parameterRangeVariables[i2];
        }
        this.rangeVariables[parameterRangeVariables.length] = range;
        if (list.size() > this.root.variableCount) {
            this.root.variableCount = list.size();
        }
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet<String> statesSet = new HashSet<String>();
        OrderedIntHashSet typesSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] types = this.handlers[i].getConditionTypes();
            for (int j = 0; j < types.length; ++j) {
                if (typesSet.add(types[j])) continue;
                throw Error.error(5601);
            }
            String[] states = this.handlers[i].getConditionStates();
            for (int j = 0; j < states.length; ++j) {
                if (statesSet.add(states[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private void setTables() {
        int i;
        if (this.tables.length == 0) {
            return;
        }
        OrderedHashMap list = new OrderedHashMap();
        if (this.parent != null && this.parent.scopeTables != null) {
            for (i = 0; i < this.parent.scopeTables.size(); ++i) {
                list.add(this.parent.scopeTables.getKeyAt(i), this.parent.scopeTables.get(i));
            }
        }
        for (i = 0; i < this.tables.length; ++i) {
            String name = this.tables[i].getName().name;
            boolean added = list.add(name, this.tables[i]);
            if (added) continue;
            throw Error.error(5606, name);
        }
        this.scopeTables = list;
    }

    private void setCursors() {
        if (this.cursors.length == 0) {
            return;
        }
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < this.cursors.length; ++i) {
            StatementCursor cursor = this.cursors[i];
            boolean added = list.add(cursor.getCursorName().name);
            if (added) continue;
            throw Error.error(5606, cursor.getCursorName().name);
        }
    }

    private boolean findLabel(StatementSimple statement) {
        if (this.label != null && statement.label.name.equals(this.label.name)) {
            return this.isLoop || statement.getType() != 103;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statement);
    }

    private void initialiseVariables(Session session) {
        Object[] vars = session.sessionContext.routineVariables;
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                vars[this.variablesOffset + i] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    private void initialiseVariables(Session session, Object[] data, int count) {
        Object[] vars = session.sessionContext.routineVariables;
        for (int i = 0; i < count; ++i) {
            vars[this.variablesOffset + i] = data[i];
        }
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    @Override
    public void setCorrelated() {
    }

    @Override
    public boolean isVariable() {
        return true;
    }
}

