/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    boolean isTruncate;
    boolean isMergeDeleteFirst;
    Expression mergeInsertCondition;
    Expression mergeUpdateCondition;
    Expression mergeDeleteCondition;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    SortAndSlice sortAndSlice;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;

    public StatementDML(int type, HsqlNameManager.HsqlName schemaName) {
        super(type, 2004, schemaName);
    }

    StatementDML(Session session, Table targetTable, RangeVariable targetRange, RangeVariable[] rangeVars, ParserDQL.CompileContext compileContext, boolean restartIdentity, int type, SortAndSlice sortAndSlice) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerDeletable() ? targetTable : targetTable.getBaseTable();
        this.targetRangeVariables = rangeVars;
        this.restartIdentity = restartIdentity;
        this.sortAndSlice = sortAndSlice;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (type == 1215) {
            this.isTruncate = true;
        }
        targetRange.addAllColumns();
    }

    StatementDML(Session session, Expression[] targets, Table targetTable, RangeVariable targetRange, RangeVariable[] rangeVars, int[] updateColumnMap, Expression[] colExpressions, boolean[] checkColumns, ParserDQL.CompileContext compileContext, SortAndSlice sortAndSlice) {
        super(92, 2004, session.getCurrentSchemaHsqlName());
        this.targets = targets;
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerUpdatable() ? targetTable : targetTable.getBaseTable();
        this.updateColumnMap = updateColumnMap;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = checkColumns;
        this.targetRangeVariables = rangeVars;
        this.sortAndSlice = sortAndSlice;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        targetRange.addAllColumns();
    }

    StatementDML(Session session, Expression[] targets, RangeVariable sourceRange, RangeVariable targetRange, RangeVariable[] rangeVars, int[] insertColMap, int[] updateColMap, boolean[] checkColumns, Expression mergeCondition, Expression insertExpr, Expression[] updateExpr, boolean deleteFirst, Expression insertCondition, Expression updateCondition, Expression deleteCondition, ParserDQL.CompileContext compileContext) {
        super(56, 2004, session.getCurrentSchemaHsqlName());
        this.targets = targets;
        this.sourceTable = sourceRange.rangeTable;
        this.targetTable = targetRange.rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = checkColumns;
        this.insertColumnMap = insertColMap;
        this.updateColumnMap = updateColMap;
        this.insertExpression = insertExpr;
        this.updateExpressions = updateExpr;
        this.targetRangeVariables = rangeVars;
        this.condition = mergeCondition;
        this.mergeInsertCondition = insertCondition;
        this.mergeUpdateCondition = updateCondition;
        this.mergeDeleteCondition = deleteCondition;
        this.isMergeDeleteFirst = deleteFirst;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementDML() {
        super(91, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification select = this.targetTable.getQueryExpression().getMainSelect();
            this.updatableTableCheck = select.checkQueryCondition;
            this.checkRangeVariable = select.rangeVariables[select.rangeVariables.length - 1];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        int limit = Integer.MAX_VALUE;
        session.getTransactionUTC();
        if (this.sortAndSlice != null) {
            int[] limits = this.sortAndSlice.getLimits(session, null, Integer.MAX_VALUE);
            limit = limits[1];
        }
        switch (this.type) {
            case 92: {
                result = this.executeUpdateStatement(session, limit);
                break;
            }
            case 56: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session, limit);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        session.sessionContext.diagnosticsVariables[2] = result.getUpdateCount();
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (i = 0; i < this.baseTable.fkConstraints.length; ++i) {
                Constraint constraint = this.baseTable.fkConstraints[i];
                switch (this.type) {
                    case 92: {
                        if (!ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        continue block5;
                    }
                    case 55: {
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        continue block5;
                    }
                    case 56: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) {
                            set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        }
                        if (this.insertExpression == null) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                    }
                }
            }
            if (this.type == 92 || this.type == 56) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, set);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, set);
            }
            this.getTriggerTableNames(set, false);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isDataReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, true);
        } else if (!this.baseTable.isTemp()) {
            set.add(this.baseTable.getName());
            if (this.type == 92 || this.type == 56) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, set);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, set);
            }
            this.getTriggerTableNames(set, true);
        }
    }

    @Override
    public void setGeneratedColumnInfo(int generate, ResultMetaData meta) {
        switch (this.type) {
            case 19: 
            case 55: 
            case 56: 
            case 92: {
                break;
            }
            default: {
                return;
            }
        }
        int idColIndex = this.baseTable.getIdentityColumnIndex();
        this.generatedType = generate;
        this.generatedInputMetaData = meta;
        switch (generate) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = meta.getGeneratedColumnIndexes();
                for (int i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0 && this.generatedIndexes[i] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int i;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (idColIndex >= 0) {
                        int generatedCount = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[generatedCount];
                        int j = 0;
                        for (i = 0; i < this.baseTable.colGenerated.length; ++i) {
                            if (!this.baseTable.colGenerated[i] && i != idColIndex) continue;
                            this.generatedIndexes[j++] = i;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (idColIndex >= 0) {
                    this.generatedIndexes = new int[]{idColIndex};
                    break;
                }
                return;
            }
            case 11: {
                int i;
                String[] columnNames = meta.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.findColumnIndexes(columnNames);
                for (i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0) continue;
                    String upperName = columnNames[i].toUpperCase();
                    this.generatedIndexes[i] = this.baseTable.findColumn(upperName);
                    if (this.generatedIndexes[i] >= 0) continue;
                    throw Error.error(5501, columnNames[0]);
                }
                break;
            }
            case 31: {
                this.generatedIndexes = this.baseTable.getPrimaryKey();
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema column = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = column;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] data) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] values = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            values[i] = data[this.generatedIndexes[i]];
        }
        return values;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet set, boolean write) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef td = this.baseTable.triggerList[i];
            switch (this.type) {
                case 55: {
                    if (td.getStatementType() != 55) continue block6;
                    break;
                }
                case 92: {
                    if (td.getStatementType() != 92) continue block6;
                    break;
                }
                case 19: {
                    if (td.getStatementType() != 19) continue block6;
                    break;
                }
                case 56: {
                    if (td.getStatementType() != 55 && td.getStatementType() != 92) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (td.routine == null) continue;
            if (write) {
                set.addAll(td.routine.getTableNamesForWrite());
                continue;
            }
            set.addAll(td.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session, int limit) {
        int count = 0;
        RowSetNavigatorDataChange rowset = session.sessionContext.getRowSetDataChange();
        Type[] colTypes = this.baseTable.getColumnTypes();
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        int rowCount = 0;
        while (it.next()) {
            session.sessionData.startRowProcessing();
            Row row = it.getCurrentRow();
            Object[] newData = row.getDataCopy();
            StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, colTypes, newData);
            rowset.addRow(session, row, newData, colTypes, this.updateColumnMap);
            ++session.sessionContext.rownum;
            if (++rowCount != limit) continue;
            break;
        }
        rowset.endMainDataSet();
        it.release();
        rowset.beforeFirst();
        count = this.update(session, this.baseTable, rowset, generatedNavigator);
        if (count == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    static void getUpdatedData(Session session, Expression[] targets, Table targetTable, int[] columnMap, Expression[] colExpressions, Type[] colTypes, Object[] data) {
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            int colIndex;
            Expression expr;
            if ((expr = colExpressions[ix++]).getType() == 25) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Expression e = expr.nodes[j];
                    if (targetTable.identityColumn != colIndex || e.getType() != 1 || e.valueData != null) {
                        if (e.getType() == 4) {
                            if (targetTable.identityColumn != colIndex) {
                                data[colIndex] = targetTable.colDefaults[colIndex] == null ? null : targetTable.colDefaults[colIndex].getValue(session);
                            }
                        } else {
                            data[colIndex] = colTypes[colIndex].convertToType(session, values[j], e.dataType);
                        }
                    }
                    ++j;
                    ++i;
                }
                continue;
            }
            if (expr.getType() == 22) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Type colType = expr.table.queryExpression.getMetaData().columnTypes[j];
                    data[colIndex] = colTypes[colIndex].convertToType(session, values[j], colType);
                    ++j;
                    ++i;
                }
                continue;
            }
            int colIndex2 = columnMap[i];
            if (expr.getType() == 4) {
                if (targetTable.identityColumn == colIndex2) {
                    ++i;
                    continue;
                }
                data[colIndex2] = targetTable.colDefaults[colIndex2] == null ? null : targetTable.colDefaults[colIndex2].getValue(session);
                ++i;
                continue;
            }
            Object value = expr.getValue(session);
            data[colIndex2] = targets[i].getType() == 101 ? ((ExpressionAccessor)targets[i]).getUpdatedArray(session, (Object[])data[colIndex2], value, true) : colTypes[colIndex2].convertToType(session, value, expr.dataType);
            ++i;
        }
    }

    Result executeMergeStatement(Session session) {
        int i;
        boolean hasWhenMatched;
        Type[] colTypes = this.baseTable.getColumnTypes();
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        boolean bl = hasWhenMatched = this.mergeDeleteCondition != null || this.updateExpressions.length != 0;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        int count = 0;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange updateRowSet = session.sessionContext.getRowSetDataChange();
        RangeVariable[] joinRangeVariables = this.targetRangeVariables;
        RangeIterator[] rangeIterators = new RangeIterator[joinRangeVariables.length];
        for (i = 0; i < joinRangeVariables.length; ++i) {
            rangeIterators[i] = joinRangeVariables[i].getIterator(session);
        }
        int currentIndex = 0;
        while (currentIndex >= 0) {
            RangeIterator it = rangeIterators[currentIndex];
            boolean beforeFirst = it.isBeforeFirst();
            if (it.next()) {
                if (currentIndex < joinRangeVariables.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                Object[] data;
                if (currentIndex == 1 && beforeFirst && this.insertExpression != null && (data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes)) != null && this.mergeInsertCondition.testCondition(session)) {
                    newData.add(data);
                }
                it.reset();
                --currentIndex;
                continue;
            }
            if (!hasWhenMatched) continue;
            Row row = it.getCurrentRow();
            session.sessionData.startRowProcessing();
            try {
                boolean test = false;
                if (this.isMergeDeleteFirst && this.mergeDeleteCondition != null && (test = this.mergeDeleteCondition.testCondition(session))) {
                    updateRowSet.addRow(row);
                }
                if (!test && this.mergeUpdateCondition != null && (test = this.mergeUpdateCondition.testCondition(session))) {
                    Object[] data = row.getDataCopy();
                    StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, colTypes, data);
                    updateRowSet.addRow(session, row, data, colTypes, this.updateColumnMap);
                }
                if (test || this.isMergeDeleteFirst || this.mergeDeleteCondition == null || !(test = this.mergeDeleteCondition.testCondition(session))) continue;
                updateRowSet.addRow(row);
            }
            catch (HsqlException e) {
                for (int i2 = 0; i2 < joinRangeVariables.length; ++i2) {
                    rangeIterators[i2].reset();
                }
                throw Error.error(3201);
            }
        }
        updateRowSet.endMainDataSet();
        for (i = 0; i < joinRangeVariables.length; ++i) {
            rangeIterators[i].reset();
        }
        if (hasWhenMatched) {
            count = this.update(session, this.baseTable, updateRowSet, generatedNavigator);
        }
        if (newData.getSize() > 0) {
            this.insertRowSet(session, generatedNavigator, newData);
            count += newData.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, newData);
        }
        if (count == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    void insertRowSet(Session session, RowSetNavigator generatedNavigator, RowSetNavigator newData) {
        Object[] data;
        PersistentStore store = this.baseTable.getRowStore(session);
        RangeIterator checkIterator = null;
        if (this.updatableTableCheck != null) {
            checkIterator = session.sessionContext.getCheckIterator(this.checkRangeVariable);
        }
        newData.beforeFirst();
        if (this.baseTable.identityColumn != -1) {
            while (newData.next()) {
                data = newData.getCurrent();
                session.sessionData.startRowProcessing();
                this.baseTable.setIdentityColumn(session, data);
            }
            newData.beforeFirst();
        }
        if (this.baseTable.triggerLists[6].length > 0) {
            while (newData.next()) {
                data = newData.getCurrent();
                session.sessionData.startRowProcessing();
                this.baseTable.fireTriggers(session, 6, null, data, null);
            }
            newData.beforeFirst();
        }
        while (newData.next()) {
            data = newData.getCurrent();
            session.sessionData.startRowProcessing();
            this.baseTable.insertSingleRow(session, store, data, null);
            if (this.updatableTableCheck != null) {
                checkIterator.setCurrent(data);
                boolean check = this.updatableTableCheck.testCondition(session);
                if (!check) {
                    throw Error.error(5700);
                }
            }
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        newData.beforeFirst();
        while (newData.next()) {
            data = newData.getCurrent();
            this.performIntegrityChecks(session, this.baseTable, null, data, null);
        }
        newData.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (newData.next()) {
                data = newData.getCurrent();
                this.baseTable.fireTriggers(session, 3, null, data, null);
            }
            newData.beforeFirst();
        }
    }

    Result insertSingleRow(Session session, PersistentStore store, Object[] data) {
        session.sessionData.startRowProcessing();
        this.baseTable.setIdentityColumn(session, data);
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, data, null);
        }
        this.baseTable.insertSingleRow(session, store, data, null);
        this.performIntegrityChecks(session, this.baseTable, null, data, null);
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, data, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, (RowSetNavigator)null);
        }
        session.sessionContext.diagnosticsVariables[2] = 1;
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] colTypes, Expression[] rowArgs) {
        Object[] data = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < rowArgs.length; ++i) {
            Expression e = rowArgs[i];
            int colIndex = this.insertColumnMap[i];
            if (e.opType == 4) {
                if (this.baseTable.identityColumn == colIndex || this.baseTable.colDefaults[colIndex] == null) continue;
                data[colIndex] = this.baseTable.colDefaults[colIndex].getValue(session);
                continue;
            }
            Object value = e.getValue(session);
            Type type = colTypes[colIndex];
            if (session.database.sqlSyntaxMys || session.database.sqlSyntaxPgs) {
                try {
                    value = type.convertToType(session, value, e.dataType);
                }
                catch (HsqlException ex) {
                    if (type.typeCode == 91) {
                        value = Type.SQL_TIMESTAMP.convertToType(session, value, e.dataType);
                        value = type.convertToType(session, value, Type.SQL_TIMESTAMP);
                    }
                    if (type.typeCode == 93) {
                        value = Type.SQL_DATE.convertToType(session, value, e.dataType);
                        value = type.convertToType(session, value, Type.SQL_DATE);
                    }
                    throw ex;
                }
            }
            data[colIndex] = value;
        }
        return data;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange navigator, RowSetNavigator generatedNavigator) {
        boolean hasAfterRowTriggers;
        Table currentTable;
        int[] changedColumns;
        Row row;
        int rowCount = navigator.getSize();
        RangeIterator checkIterator = null;
        if (this.updatableTableCheck != null) {
            checkIterator = session.sessionContext.getCheckIterator(this.checkRangeVariable);
        }
        for (int i = 0; i < rowCount; ++i) {
            navigator.next();
            Object[] data = navigator.getCurrentChangedData();
            session.sessionData.startRowProcessing();
            table.setIdentityColumn(session, data);
            table.setGeneratedColumns(session, data);
            table.setUpdatedColumns(session, data, this.updateColumnMap);
        }
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet path = session.sessionContext.getConstraintPath();
            for (int i = 0; i < rowCount; ++i) {
                navigator.next();
                row = navigator.getCurrentRow();
                Object[] data = navigator.getCurrentChangedData();
                StatementDML.performReferentialActions(session, navigator, row, data, this.updateColumnMap, path, false);
                path.clear();
            }
            navigator.beforeFirst();
        }
        while (navigator.next()) {
            Row row2 = navigator.getCurrentRow();
            Object[] data = navigator.getCurrentChangedData();
            changedColumns = navigator.getCurrentChangedColumns();
            currentTable = (Table)row2.getTable();
            if (currentTable instanceof TableDerived) {
                currentTable = ((TableDerived)currentTable).view;
            }
            if (currentTable.triggerLists[8].length > 0) {
                session.sessionData.startRowProcessing();
                currentTable.fireTriggers(session, 8, row2.getData(), data, changedColumns);
                currentTable.enforceRowConstraints(session, data);
            }
            if (this.updatableTableCheck == null) continue;
            checkIterator.setCurrent(data);
            boolean check = this.updatableTableCheck.testCondition(session);
            if (check) continue;
            throw Error.error(5700);
        }
        if (table.isView) {
            return rowCount;
        }
        navigator.beforeFirst();
        while (navigator.next()) {
            Row row3 = navigator.getCurrentRow();
            Table currentTable2 = (Table)row3.getTable();
            changedColumns = navigator.getCurrentChangedColumns();
            PersistentStore store = currentTable2.getRowStore(session);
            session.addDeleteAction(currentTable2, store, row3, changedColumns);
        }
        navigator.beforeFirst();
        while (navigator.next()) {
            Row row4 = navigator.getCurrentRow();
            Object[] data = navigator.getCurrentChangedData();
            Table currentTable3 = (Table)row4.getTable();
            int[] changedColumns2 = navigator.getCurrentChangedColumns();
            PersistentStore store = currentTable3.getRowStore(session);
            if (currentTable3.isSystemVersioned()) {
                Object[] history = row4.getData();
                Row row5 = currentTable3.insertSystemVersionHistoryRow(session, store, history);
            }
            if (data == null) continue;
            Row newRow = currentTable3.insertSingleRow(session, store, data, changedColumns2);
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        navigator.beforeFirst();
        OrderedHashSet<Table> extraUpdateTables = null;
        boolean bl = hasAfterRowTriggers = table.triggerLists[5].length > 0;
        while (navigator.next()) {
            row = navigator.getCurrentRow();
            currentTable = (Table)row.getTable();
            Object[] changedData = navigator.getCurrentChangedData();
            int[] changedColumns3 = navigator.getCurrentChangedColumns();
            this.performIntegrityChecks(session, currentTable, row.getData(), changedData, changedColumns3);
            if (currentTable == table) continue;
            if (extraUpdateTables == null) {
                extraUpdateTables = new OrderedHashSet<Table>();
            }
            extraUpdateTables.add(currentTable);
            if (currentTable.triggerLists[5].length <= 0) continue;
            hasAfterRowTriggers = true;
        }
        navigator.beforeFirst();
        if (hasAfterRowTriggers) {
            while (navigator.next()) {
                row = navigator.getCurrentRow();
                Object[] changedData = navigator.getCurrentChangedData();
                int[] changedColumns4 = navigator.getCurrentChangedColumns();
                Table currentTable4 = (Table)row.getTable();
                currentTable4.fireTriggers(session, 5, row.getData(), changedData, changedColumns4);
            }
            navigator.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, navigator);
        if (extraUpdateTables != null) {
            for (int i = 0; i < extraUpdateTables.size(); ++i) {
                currentTable = (Table)extraUpdateTables.get(i);
                currentTable.fireTriggers(session, 2, navigator);
            }
        }
        return rowCount;
    }

    Result executeDeleteStatement(Session session, int limit) {
        int count = 0;
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowset = session.sessionContext.getRowSetDataChange();
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        int rowCount = 0;
        while (it.next()) {
            Row currentRow = it.getCurrentRow();
            rowset.addRow(currentRow);
            ++session.sessionContext.rownum;
            if (++rowCount != limit) continue;
            break;
        }
        it.release();
        rowset.endMainDataSet();
        if (rowset.getSize() > 0) {
            count = this.delete(session, this.baseTable, rowset, generatedNavigator);
        }
        if (count == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore store = this.targetTable.getRowStore(session);
        RowIterator it = this.targetTable.getDefaultIndex().firstRow(store);
        boolean hasData = false;
        for (int i = 0; i < this.targetTable.fkMainConstraints.length; ++i) {
            HsqlNameManager.HsqlName tableName;
            Table refTable;
            if (this.targetTable.fkMainConstraints[i].getRef() == this.targetTable || (refTable = session.database.schemaManager.getUserTable(tableName = this.targetTable.fkMainConstraints[i].getRef().getName())).isEmpty(session)) continue;
            throw Error.error(8, refTable.getName().name);
        }
        try {
            while (it.next()) {
                Row row = it.getCurrentRow();
                session.addDeleteAction((Table)row.getTable(), store, row, null);
                hasData = true;
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            it.release();
        }
        if (!hasData) {
            session.addWarning(HsqlException.noDataCondition);
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange navigator, RowSetNavigator generatedNavigator) {
        Table currentTable;
        Object[] changedData;
        Row row;
        boolean hasAfterRowTriggers;
        Table currentTable2;
        Object[] data;
        int rowCount = navigator.getSize();
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet path = session.sessionContext.getConstraintPath();
            if (table.cascadingDeletes > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    navigator.next();
                    Row row2 = navigator.getCurrentRow();
                    StatementDML.performReferentialActions(session, navigator, row2, null, null, path, true);
                    path.clear();
                }
                navigator.beforeFirst();
            }
            int newCount = navigator.getSize();
            for (int i = 0; i < newCount; ++i) {
                navigator.next();
                Row row3 = navigator.getCurrentRow();
                StatementDML.performReferentialActions(session, navigator, row3, null, null, path, false);
                path.clear();
            }
            navigator.beforeFirst();
        }
        while (navigator.next()) {
            Row row4 = navigator.getCurrentRow();
            Object[] changedData2 = navigator.getCurrentChangedData();
            int[] changedColumns = navigator.getCurrentChangedColumns();
            Table currentTable3 = (Table)row4.getTable();
            if (currentTable3 instanceof TableDerived) {
                currentTable3 = ((TableDerived)currentTable3).view;
            }
            if (changedData2 == null) {
                currentTable3.fireTriggers(session, 7, row4.getData(), null, null);
                continue;
            }
            currentTable3.fireTriggers(session, 8, row4.getData(), changedData2, changedColumns);
        }
        if (table.isView) {
            return rowCount;
        }
        navigator.beforeFirst();
        boolean hasUpdate = false;
        boolean hasPeriod = false;
        while (navigator.next()) {
            Row row5 = navigator.getCurrentRow();
            data = navigator.getCurrentChangedData();
            currentTable2 = (Table)row5.getTable();
            PersistentStore store = currentTable2.getRowStore(session);
            session.addDeleteAction(currentTable2, store, row5, null);
            if (generatedNavigator != null) {
                Object[] generatedValues = this.getGeneratedColumns(row5.getData());
                generatedNavigator.add(generatedValues);
            }
            if (data != null) {
                hasUpdate = true;
            }
            if (!currentTable2.isSystemVersioned()) continue;
            hasPeriod = true;
        }
        navigator.beforeFirst();
        if (hasUpdate || hasPeriod) {
            while (navigator.next()) {
                Object history;
                Row row6 = navigator.getCurrentRow();
                data = navigator.getCurrentChangedData();
                currentTable2 = (Table)row6.getTable();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                PersistentStore store = currentTable2.getRowStore(session);
                if (currentTable2.isSystemVersioned()) {
                    history = row6.getData();
                    Row row7 = currentTable2.insertSystemVersionHistoryRow(session, store, (Object[])history);
                }
                if (data == null) continue;
                history = currentTable2.insertSingleRow(session, store, data, changedColumns);
            }
            navigator.beforeFirst();
        }
        OrderedHashSet<Table> extraUpdateTables = null;
        OrderedHashSet<Table> extraDeleteTables = null;
        boolean bl = hasAfterRowTriggers = table.triggerLists[4].length > 0;
        if (rowCount != navigator.getSize()) {
            while (navigator.next()) {
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                Table currentTable4 = (Table)row.getTable();
                if (changedData != null) {
                    this.performIntegrityChecks(session, currentTable4, row.getData(), changedData, changedColumns);
                }
                if (currentTable4 == table) continue;
                if (changedData == null) {
                    if (currentTable4.triggerLists[4].length > 0) {
                        hasAfterRowTriggers = true;
                    }
                    if (extraDeleteTables == null) {
                        extraDeleteTables = new OrderedHashSet<Table>();
                    }
                    extraDeleteTables.add(currentTable4);
                    continue;
                }
                if (currentTable4.triggerLists[5].length > 0) {
                    hasAfterRowTriggers = true;
                }
                if (extraUpdateTables == null) {
                    extraUpdateTables = new OrderedHashSet<Table>();
                }
                extraUpdateTables.add(currentTable4);
            }
            navigator.beforeFirst();
        }
        if (hasAfterRowTriggers) {
            while (navigator.next()) {
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                Table currentTable5 = (Table)row.getTable();
                if (changedData == null) {
                    currentTable5.fireTriggers(session, 4, row.getData(), null, null);
                    continue;
                }
                currentTable5.fireTriggers(session, 5, row.getData(), changedData, null);
            }
            navigator.beforeFirst();
        }
        table.fireTriggers(session, 1, navigator);
        if (extraUpdateTables != null) {
            for (int i = 0; i < extraUpdateTables.size(); ++i) {
                currentTable = (Table)extraUpdateTables.get(i);
                currentTable.fireTriggers(session, 2, navigator);
            }
        }
        if (extraDeleteTables != null) {
            for (int i = 0; i < extraDeleteTables.size(); ++i) {
                currentTable = (Table)extraDeleteTables.get(i);
                currentTable.fireTriggers(session, 1, navigator);
            }
        }
        return rowCount;
    }

    void performIntegrityChecks(Session session, Table table, Object[] oldData, Object[] newData, int[] updatedColumns) {
        int i;
        if (newData == null) {
            return;
        }
        Expression filter = this.rangeVariables[0].filterCondition;
        if (filter != null) {
            RangeIterator it = session.sessionContext.getCheckIterator(this.rangeVariables[0]);
            it.setCurrent(newData);
            if (!filter.testCondition(session)) {
                throw Error.error(5700);
            }
        }
        int size = table.checkConstraints.length;
        for (i = 0; i < size; ++i) {
            table.checkConstraints[i].checkInsert(session, table, newData, oldData);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        size = table.fkConstraints.length;
        for (i = 0; i < size; ++i) {
            boolean check = oldData == null;
            Constraint c = table.fkConstraints[i];
            int[] fkColumns = c.getRefColumns();
            if (!check) {
                check = ArrayUtil.haveCommonElement(fkColumns, updatedColumns);
            }
            if (!check) continue;
            c.checkInsert(session, table, newData, oldData);
        }
    }

    static void performReferentialActions(Session session, RowSetNavigatorDataChange navigator, Row row, Object[] data, int[] changedCols, HashSet path, boolean deleteCascade) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean delete = data == null;
        Table table = (Table)row.getTable();
        for (Constraint c : table.fkMainConstraints) {
            int action = delete ? c.getDeleteAction() : c.getUpdateAction();
            if (deleteCascade ^ (delete && action == 0) || !delete && (!ArrayUtil.haveCommonElement(changedCols, c.core.mainCols) || c.core.mainIndex.compareRowNonUnique(session, row.getData(), data, c.core.mainCols) == 0)) continue;
            RowIterator refiterator = c.findFkRef(session, row.getData());
            block12: while (refiterator.next()) {
                String[] info;
                Row refRow = refiterator.getCurrentRow();
                Object[] refData = null;
                if (c.core.refIndex.compareRowNonUnique(session, refRow.getData(), row.getData(), c.core.mainCols) != 0) break;
                if (delete && refRow.getId() == row.getId() || !refRow.isCurrentSystemVersion()) continue;
                switch (action) {
                    case 0: {
                        int j;
                        if (delete) {
                            boolean result;
                            try {
                                result = navigator.addRow(refRow);
                            }
                            catch (HsqlException e) {
                                String[] info2 = StatementDML.getConstraintInfo(c);
                                refiterator.release();
                                throw Error.error(null, 3900, 2, info2);
                            }
                            if (!result) continue block12;
                            StatementDML.performReferentialActions(session, navigator, refRow, null, null, path, deleteCascade);
                            continue block12;
                        }
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = data[c.core.mainCols[j]];
                        }
                        break;
                    }
                    case 2: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            ColumnSchema col = c.core.refTable.getColumn(c.core.refCols[j]);
                            refData[c.core.refCols[j]] = col.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (delete ? navigator.containsDeletedRow(refRow) : navigator.containsUpdatedRow(row, refRow, c.core.mainCols)) continue block12;
                    }
                    case 1: {
                        int errorCode = c.getDeleteAction() == 3 ? 8 : 3501;
                        info = StatementDML.getConstraintInfo(c);
                        refiterator.release();
                        throw Error.error(null, errorCode, 2, info);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    refData = navigator.addRow(session, refRow, refData, c.core.refTable.getColumnTypes(), c.core.refCols);
                }
                catch (HsqlException e) {
                    info = StatementDML.getConstraintInfo(c);
                    refiterator.release();
                    throw Error.error(null, 3900, 2, info);
                }
                if (refData == null || !path.add(c)) continue;
                StatementDML.performReferentialActions(session, navigator, refRow, refData, c.core.refCols, path, deleteCascade);
                path.remove(c);
            }
            refiterator.release();
        }
    }

    static String[] getConstraintInfo(Constraint c) {
        return new String[]{c.core.refName.name, c.core.refTable.getName().name};
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

