/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;

public abstract class StatementDMQL
extends Statement {
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    QueryExpression queryExpression;
    HsqlNameManager.HsqlName cursorName;
    TableDerived[] subqueries = TableDerived.emptyArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int type, int group, HsqlNameManager.HsqlName schemaName) {
        super(type, group);
        this.schemaName = schemaName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            HsqlException e = Error.error(3706);
            return Result.newErrorResult(e);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t);
            result.getException().setStatementType(this.group, this.type);
        }
        finally {
            this.clearStructures(session);
        }
        return result;
    }

    private Result getExplainResult(Session session) {
        HsqlNameManager.HsqlName name;
        int i;
        Result result = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet set = this.getReferences();
        result.navigator.add(new Object[]{"Object References"});
        for (i = 0; i < set.size(); ++i) {
            name = (HsqlNameManager.HsqlName)set.get(i);
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"Read Locks"});
        for (i = 0; i < this.readTableNames.length; ++i) {
            name = this.readTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"WriteLocks"});
        for (i = 0; i < this.writeTableNames.length; ++i) {
            name = this.writeTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 55: {
                return this.insertCheckColumns;
            }
            case 92: {
                return this.updateCheckColumns;
            }
            case 56: {
                boolean[] check = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, check);
                return check;
            }
        }
        return null;
    }

    void materializeSubQueries(Session session) {
        HashSet<TableDerived> subqueryPopFlags = new HashSet<TableDerived>();
        for (int i = 0; i < this.subqueries.length; ++i) {
            TableDerived td = this.subqueries[i];
            if (!subqueryPopFlags.add(td) || td.isCorrelated()) continue;
            td.materialise(session);
        }
    }

    TableDerived[] getSubqueries(Session session) {
        int i;
        OrderedHashSet subQueries = null;
        for (i = 0; i < this.targetRangeVariables.length; ++i) {
            if (this.targetRangeVariables[i] == null) continue;
            OrderedHashSet set = this.targetRangeVariables[i].getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            subQueries = this.updateExpressions[i].collectAllSubqueries(subQueries);
        }
        if (this.insertExpression != null) {
            subQueries = this.insertExpression.collectAllSubqueries(subQueries);
        }
        if (this.condition != null) {
            subQueries = this.condition.collectAllSubqueries(subQueries);
        }
        if (this.queryExpression != null) {
            OrderedHashSet set = this.queryExpression.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (this.updatableTableCheck != null) {
            OrderedHashSet set = this.updatableTableCheck.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return TableDerived.emptyArray;
        }
        TableDerived[] subQueryArray = new TableDerived[subQueries.size()];
        subQueries.toArray(subQueryArray);
        return subQueryArray;
    }

    @Override
    void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getAllRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
        this.collectTableNamesForWrite(set);
        if (set.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.writeTableNames);
            set.clear();
        }
        this.collectTableNamesForRead(set);
        set.removeAll(this.writeTableNames);
        if (set.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.readTableNames);
        }
        if (this.readTableNames.length == 0 && this.writeTableNames.length == 0 && (this.type == 44 || this.type == 70)) {
            this.isTransactionStatement = false;
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getName());
            if (this.targetTable == this.baseTable) {
                if (this.insertCheckColumns != null) {
                    this.targetTable.getColumnNames(this.insertCheckColumns, this.references);
                }
                if (this.updateCheckColumns != null) {
                    this.targetTable.getColumnNames(this.updateCheckColumns, this.references);
                }
            }
        }
    }

    void checkAccessRights(Session session) {
        int i;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            Grantee owner;
            if (!session.isProcessingScript()) {
                this.targetTable.checkDataReadOnly();
            }
            if ((owner = this.targetTable.getOwner()) != null && owner.isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (i = 0; i < this.sequences.length; ++i) {
            session.getGrantee().checkAccess(this.sequences[i]);
        }
        for (i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[i]);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Right right;
            Expression expr;
            RangeVariable range = this.rangeVariables[i];
            if (range.isViewSubquery || range.rangeTable.getSchemaName() == SqlInvariants.SESSION_SCHEMA_HSQLNAME || range.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (expr = (right = session.getGrantee().checkSelect(range.rangeTable, range.usedColumns)).getFilterExpression(1)) == null) continue;
            expr = expr.duplicate();
            range.setFilterExpression(session, expr);
            OrderedHashSet set = expr.collectAllSubqueries(null);
            if (set == null || set.size() <= 0) continue;
            for (int j = 0; j < set.size(); ++j) {
                TableDerived subquery = (TableDerived)set.get(j);
                this.subqueries = (TableDerived[])ArrayUtil.toAdjustedArray(this.subqueries, subquery, this.subqueries.length, 1);
            }
        }
        Expression expr = null;
        switch (this.type) {
            case 10: {
                break;
            }
            case 55: {
                Right right = session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                expr = right.getFilterExpression(4);
                break;
            }
            case 44: {
                break;
            }
            case 19: {
                Right right = session.getGrantee().checkDelete(this.targetTable);
                expr = right.getFilterExpression(2);
                break;
            }
            case 92: {
                Right right = session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                expr = right.getFilterExpression(8);
                break;
            }
            case 56: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                Right right = session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                expr = right.getFilterExpression(8);
            }
        }
        if (expr != null) {
            expr = expr.duplicate();
            this.targetRangeVariables[0].setFilterExpression(session, expr);
            OrderedHashSet set = expr.collectAllSubqueries(null);
            if (set != null && set.size() > 0) {
                for (int j = 0; j < set.size(); ++j) {
                    TableDerived subquery = (TableDerived)set.get(j);
                    this.subqueries = (TableDerived[])ArrayUtil.toAdjustedArray(this.subqueries, subquery, this.subqueries.length, 1);
                }
            }
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 55: 
            case 56: 
            case 92: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    String describeImpl(Session session) {
        StringBuilder sb = new StringBuilder();
        int blanks = 0;
        switch (this.type) {
            case 44: {
                sb.append(this.queryExpression.describe(session, 0));
                this.appendParams(sb).append('\n');
                this.appendSubqueries(session, sb, 2);
                return sb.toString();
            }
            case 55: {
                if (this.queryExpression == null) {
                    sb.append("INSERT VALUES");
                    sb.append('[').append('\n');
                    this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                    this.appendTable(sb).append('\n');
                    this.appendParams(sb).append('\n');
                    this.appendSubqueries(session, sb, 2).append(']');
                    return sb.toString();
                }
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.insertColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.queryExpression.describe(session, blanks)).append('\n');
                this.appendParams(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 92: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParams(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 19: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParams(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 10: {
                sb.append("CALL");
                sb.append('[').append(']');
                return sb.toString();
            }
            case 56: {
                sb.append("MERGE");
                sb.append('[').append('\n');
                this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParams(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuilder appendSubqueries(Session session, StringBuilder sb, int blanks) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].depth).append('\n');
            if (this.subqueries[i].queryExpression == null) {
                for (int j = 0; j < blanks; ++j) {
                    sb.append(' ');
                }
                sb.append("value expression");
            } else {
                sb.append(this.subqueries[i].queryExpression.describe(session, blanks));
            }
            sb.append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuilder appendTable(StringBuilder sb) {
        sb.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return sb;
    }

    private StringBuilder appendSourceTable(StringBuilder sb) {
        sb.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return sb;
    }

    private StringBuilder appendColumns(StringBuilder sb, int[] columnMap) {
        int i;
        if (columnMap == null || this.updateExpressions.length == 0) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (i = 0; i < columnMap.length; ++i) {
            sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn(columnMap[i]).getNameString());
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            sb.append('[').append(this.updateExpressions[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuilder appendMultiColumns(StringBuilder sb, int[] columnMap) {
        if (columnMap == null || this.multiColumnValues == null) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (int j = 0; j < this.multiColumnValues.length; ++j) {
            for (int i = 0; i < columnMap.length; ++i) {
                sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)columnMap[i]).getName().name).append('[').append(this.multiColumnValues[j][i]).append(']');
            }
        }
        sb.append(']');
        return sb;
    }

    private StringBuilder appendParams(StringBuilder sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuilder appendCondition(Session session, StringBuilder sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public final boolean isCatalogLock(int model) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

