/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int type, Expression expression) {
        super(type, 2007, null);
        switch (type) {
            case 62: 
            case 1211: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 62: {
                return this.sql;
            }
            case 1211: {
                sb.append(this.expression.getSQL());
            }
        }
        return sb.toString();
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        BaseHashMap subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries((OrderedHashSet)subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return TableDerived.emptyArray;
        }
        TableDerived[] subQueryArray = new TableDerived[subQueries.size()];
        ((OrderedHashSet)subQueries).toArray(subQueryArray);
        for (int i = 0; i < this.subqueries.length; ++i) {
            subQueryArray[i].prepareTable(session);
        }
        return subQueryArray;
    }

    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 62: 
            case 1211: {
                Result result = this.expression.getResult(session);
                if (result.isData()) {
                    RowSetNavigatorData navigator = new RowSetNavigatorData(session, result.getNavigator());
                    result.setNavigator(navigator);
                }
                return result;
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    String describeImpl(Session session) {
        return this.getSQL();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
    }
}

