/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;

public class StatementHandler
extends Statement {
    public static final int NONE = 0;
    public static final int SQL_EXCEPTION = 1;
    public static final int SQL_WARNING = 2;
    public static final int SQL_NOT_FOUND = 3;
    public static final int SQL_STATE = 4;
    public static final int CONTINUE = 5;
    public static final int EXIT = 6;
    public static final int UNDO = 7;
    public final int handlerType;
    private OrderedIntHashSet conditionGroups = new OrderedIntHashSet();
    private OrderedHashSet conditionStates = new OrderedHashSet();
    private Statement statement;
    public static final StatementHandler[] emptyExceptionHandlerArray = new StatementHandler[0];

    StatementHandler(int handlerType) {
        super(1212, 2007);
        this.handlerType = handlerType;
    }

    public void addConditionState(String sqlState) {
        boolean result = this.conditionStates.add(sqlState);
        if (!(result &= this.conditionGroups.isEmpty())) {
            throw Error.error(5612);
        }
    }

    public void addConditionType(int conditionType) {
        boolean result = this.conditionGroups.add(conditionType);
        if (!(result &= this.conditionStates.isEmpty())) {
            throw Error.error(5612);
        }
    }

    public void addStatement(Statement s) {
        this.statement = s;
    }

    public boolean handlesConditionType(int type) {
        return this.conditionGroups.contains(type);
    }

    public boolean handlesCondition(String sqlState) {
        if (this.conditionStates.contains(sqlState)) {
            return true;
        }
        String conditionClass = sqlState.substring(0, 2);
        if (this.conditionStates.contains(conditionClass)) {
            return true;
        }
        if (conditionClass.equals("01")) {
            return this.conditionGroups.contains(2);
        }
        if (conditionClass.equals("02")) {
            return this.conditionGroups.contains(3);
        }
        return this.conditionGroups.contains(1);
    }

    public int[] getConditionTypes() {
        return this.conditionGroups.toArray();
    }

    public String[] getConditionStates() {
        String[] array = new String[this.conditionStates.size()];
        this.conditionStates.toArray(array);
        return array;
    }

    @Override
    public void resolve(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.readTableNames = this.statement.getTableNamesForRead();
            this.writeTableNames = this.statement.getTableNamesForWrite();
        }
    }

    @Override
    public Result execute(Session session) {
        if (this.statement != null) {
            return this.statement.execute(session);
        }
        return Result.updateZeroResult;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.statement == null) {
            return new OrderedHashSet();
        }
        return this.statement.getReferences();
    }

    @Override
    public String getSQL() {
        int i;
        StringBuilder sb = new StringBuilder(64);
        String s = this.handlerType == 5 ? "CONTINUE" : (this.handlerType == 6 ? "EXIT" : "UNDO");
        sb.append("DECLARE").append(' ').append(s).append(' ');
        sb.append("HANDLER").append(' ').append("FOR");
        sb.append(' ');
        for (i = 0; i < this.conditionStates.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append("SQLSTATE").append(' ');
            sb.append('\'').append(this.conditionStates.get(i)).append('\'');
        }
        block6: for (i = 0; i < this.conditionGroups.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            switch (this.conditionGroups.get(i)) {
                case 1: {
                    sb.append("SQLEXCEPTION");
                    continue block6;
                }
                case 2: {
                    sb.append("SQLWARNING");
                    continue block6;
                }
                case 3: {
                    sb.append("NOT").append(' ').append(431);
                }
            }
        }
        if (this.statement != null) {
            sb.append(' ').append(this.statement.getSQL());
        }
        return sb.toString();
    }

    @Override
    public boolean isCatalogLock(int model) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

