/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.navigator.RowSetNavigatorDataChangeMemory;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementInsert
extends StatementDML {
    static final int isNone = 0;
    static final int isIgnore = 1;
    static final int isReplace = 2;
    static final int isUpdate = 3;
    int overrideUserValue = -1;
    int specialAction = 0;

    StatementInsert(Session session, Table targetTable, RangeVariable[] rangeVars, int[] insertColumnMap, Expression insertExpression, boolean[] insertCheckColumns, Expression[] updateExpressions, boolean[] updateCheckColumns, int[] updateColumnMap, Expression[] targets, int specialAction, ParserDQL.CompileContext compileContext) {
        super(55, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.targetRangeVariables = rangeVars;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = insertColumnMap;
        this.insertCheckColumns = insertCheckColumns;
        this.insertExpression = insertExpression;
        this.updateCheckColumns = updateCheckColumns;
        this.updateExpressions = updateExpressions;
        this.updateColumnMap = updateColumnMap;
        this.targets = targets;
        this.specialAction = specialAction;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.isSimpleInsert = insertExpression != null && insertExpression.nodes.length == 1 && this.updatableTableCheck == null && specialAction == 0;
    }

    StatementInsert(Session session, Table targetTable, RangeVariable[] rangeVars, int[] insertColumnMap, boolean[] insertCheckColumns, QueryExpression queryExpression, Expression[] updateExpressions, boolean[] updateCheckColumns, int[] updateColumnMap, Expression[] targets, int specialAction, int override, ParserDQL.CompileContext compileContext) {
        super(55, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.targetRangeVariables = rangeVars;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = insertColumnMap;
        this.insertCheckColumns = insertCheckColumns;
        this.queryExpression = queryExpression;
        this.overrideUserValue = override;
        this.updateCheckColumns = updateCheckColumns;
        this.updateExpressions = updateExpressions;
        this.updateColumnMap = updateColumnMap;
        this.targets = targets;
        this.specialAction = specialAction;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Result resultOut = null;
        PersistentStore store = this.baseTable.getRowStore(session);
        int count = 0;
        session.getTransactionUTC();
        if (this.isSimpleInsert) {
            Type[] colTypes = this.baseTable.getColumnTypes();
            Object[] data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes);
            return this.insertSingleRow(session, store, data);
        }
        RowSetNavigator newDataNavigator = this.queryExpression == null ? this.getInsertValuesNavigator(session) : this.getInsertSelectNavigator(session);
        RowSetNavigatorDataChange changeNavigator = null;
        if (this.specialAction != 0) {
            while (newDataNavigator.next()) {
                boolean remove = false;
                Object[] data = newDataNavigator.getCurrent();
                for (Constraint constraint : this.baseTable.constraintList) {
                    if (!constraint.isUniqueOrPK()) continue;
                    RowIterator it = constraint.findUniqueRows(session, data);
                    while (it.next()) {
                        Row row;
                        remove = true;
                        if (this.specialAction == 1) break;
                        if (changeNavigator == null) {
                            changeNavigator = new RowSetNavigatorDataChangeMemory(session);
                        }
                        if (constraint.core.mainIndex.compareRowNonUnique(session, (row = it.getCurrentRow()).getData(), data, constraint.core.mainCols) != 0) break;
                        changeNavigator.addRow(session, row, data, this.baseTable.getColumnTypes(), this.baseTable.defaultColumnMap);
                        ++count;
                    }
                    it.release();
                }
                if (!remove) continue;
                newDataNavigator.removeCurrent();
            }
        }
        if (this.specialAction == 2 && changeNavigator != null) {
            count = this.update(session, this.baseTable, changeNavigator, null);
            changeNavigator.endMainDataSet();
        } else if (this.specialAction == 3 && changeNavigator != null) {
            Type[] colTypes = this.baseTable.getColumnTypes();
            session.sessionContext.setRangeIterator(changeNavigator);
            session.sessionContext.setRangeIterator(changeNavigator.getUpdateRowIterator());
            while (changeNavigator.next()) {
                session.sessionData.startRowProcessing();
                Row row = changeNavigator.getCurrentRow();
                Object[] newData = row.getDataCopy();
                StatementInsert.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, colTypes, newData);
                changeNavigator.addUpdate(row, newData, this.updateColumnMap);
                ++session.sessionContext.rownum;
            }
            count = this.update(session, this.baseTable, changeNavigator, null);
            changeNavigator.endMainDataSet();
        }
        if (newDataNavigator.getSize() != 0) {
            RowSetNavigator generatedNavigator = null;
            if (this.generatedIndexes != null) {
                resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
                generatedNavigator = resultOut.getChainedResult().getNavigator();
            }
            this.insertRowSet(session, generatedNavigator, newDataNavigator);
            count += newDataNavigator.getSize();
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, newDataNavigator);
        }
        if (resultOut == null) {
            resultOut = new Result(1, count);
        } else {
            resultOut.setUpdateCount(count);
        }
        if (count == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        session.sessionContext.diagnosticsVariables[2] = count;
        return resultOut;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        int[] columnMap = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator nav = result.initialiseNavigator();
        Type[] sourceTypes = result.metaData.columnTypes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(nav.getSize());
        while (nav.next()) {
            Object[] data = this.baseTable.getNewRowData(session);
            Object[] sourceData = nav.getCurrent();
            for (int i = 0; i < columnMap.length; ++i) {
                int j = columnMap[i];
                if (j == this.overrideUserValue) continue;
                Type sourceType = sourceTypes[i];
                data[j] = colTypes[j].convertToType(session, sourceData[i], sourceType);
            }
            newData.add(data);
        }
        return newData;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        Expression[] list = this.insertExpression.nodes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(list.length);
        for (int j = 0; j < list.length; ++j) {
            Expression[] rowArgs = list[j].nodes;
            Object[] data = this.getInsertData(session, colTypes, rowArgs);
            newData.add(data);
        }
        return newData;
    }
}

