/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public final class StatementManager {
    private Database database;
    private Session session;
    private HashSet<StatementWrapper> statementSet;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Session session) {
        this.session = session;
        this.database = session.database;
        this.statementSet = new HashSet(32, new StatementComparator());
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    void reset() {
        this.statementSet.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    public Statement getStatement(long csid) {
        StatementWrapper sw = (StatementWrapper)this.csidMap.get(csid);
        if (sw == null) {
            return null;
        }
        return this.getStatement(sw);
    }

    private Statement getStatement(StatementWrapper sw) {
        Statement statement = sw.statement;
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            Statement newStatement = this.recompileStatement(statement);
            if (newStatement == null) {
                this.removeStatement(statement.getID());
                return null;
            }
            newStatement.setCompileTimestamp(this.database.txManager.getSystemChangeNumber());
            sw.statement = newStatement;
            return newStatement;
        }
        return sw.statement;
    }

    public Statement getStatement(Statement statement) {
        StatementWrapper sw;
        long csid = statement.getID();
        if (csid != 0L && (sw = (StatementWrapper)this.csidMap.get(csid)) != null) {
            return this.getStatement(sw);
        }
        return this.recompileStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Statement cs) {
        Statement newStatement;
        HsqlNameManager.HsqlName oldSchema = this.session.getCurrentSchemaHsqlName();
        try {
            HsqlNameManager.HsqlName schema = cs.getSchemaName();
            int props = cs.getCursorPropertiesRequest();
            if (schema != null) {
                this.session.setSchema(schema.name);
            }
            boolean setGenerated = cs.generatedResultMetaData() != null;
            newStatement = this.session.compileStatement(cs.getSQL(), props);
            newStatement.setCursorPropertiesRequest(props);
            if (!cs.getResultMetaData().areTypesCompatible(newStatement.getResultMetaData())) {
                Statement statement = null;
                return statement;
            }
            if (!cs.getParametersMetaData().areTypesCompatible(newStatement.getParametersMetaData())) {
                Statement statement = null;
                return statement;
            }
            newStatement.setCompileTimestamp(this.database.txManager.getSystemChangeNumber());
            if (setGenerated) {
                StatementDML si = (StatementDML)cs;
                newStatement.setGeneratedColumnInfo(si.generatedType, si.generatedInputMetaData);
            }
        }
        catch (Throwable t) {
            Statement statement = null;
            return statement;
        }
        finally {
            this.session.setCurrentSchemaHsqlName(oldSchema);
        }
        return newStatement;
    }

    private long registerStatement(StatementWrapper wrapper) {
        Statement cs = wrapper.statement;
        cs.setCompileTimestamp(this.database.txManager.getSystemChangeNumber());
        long csid = this.nextID();
        cs.setID(csid);
        this.statementSet.add(wrapper);
        this.csidMap.put(csid, wrapper);
        return csid;
    }

    void freeStatement(long csid) {
        StatementWrapper sw = (StatementWrapper)this.csidMap.get(csid);
        if (sw == null) {
            return;
        }
        --sw.usageCount;
        if (sw.usageCount == 0L) {
            this.removeStatement(csid);
        }
    }

    private void removeStatement(long csid) {
        if (csid <= 0L) {
            return;
        }
        StatementWrapper sw = (StatementWrapper)this.csidMap.remove(csid);
        if (sw != null) {
            this.statementSet.remove(sw);
        }
    }

    Statement compile(Result cmd) {
        StatementWrapper newWrapper = new StatementWrapper();
        newWrapper.sql = cmd.getMainString();
        newWrapper.cursorProps = cmd.getExecuteProperties();
        newWrapper.generatedType = cmd.getGeneratedResultType();
        newWrapper.generatedMetaData = cmd.getGeneratedResultMetaData();
        newWrapper.schemaName = this.session.currentSchema;
        StatementWrapper wrapper = this.statementSet.get(newWrapper);
        if (wrapper != null) {
            if (wrapper.statement.getCompileTimestamp() >= this.database.schemaManager.getSchemaChangeTimestamp()) {
                ++wrapper.usageCount;
                return wrapper.statement;
            }
            this.removeStatement(wrapper.statement.getID());
        }
        wrapper = newWrapper;
        wrapper.statement = this.session.compileStatement(wrapper.sql, wrapper.cursorProps);
        wrapper.statement.setCursorPropertiesRequest(wrapper.cursorProps);
        wrapper.statement.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
        this.registerStatement(wrapper);
        wrapper.usageCount = 1L;
        return wrapper.statement;
    }

    private static class StatementWrapper {
        String sql;
        HsqlNameManager.HsqlName schemaName;
        int cursorProps;
        int generatedType;
        ResultMetaData generatedMetaData;
        Statement statement;
        long usageCount;

        private StatementWrapper() {
        }
    }

    private static class StatementComparator
    implements ObjectComparator<StatementWrapper> {
        private StatementComparator() {
        }

        @Override
        public boolean equals(StatementWrapper s1, StatementWrapper s2) {
            return s1.sql.equals(s2.sql) && s1.schemaName.equals(s2.schemaName) && s1.cursorProps == s2.cursorProps && s1.generatedType == s2.generatedType && ResultMetaData.areGeneratedReguestsCompatible(s1.generatedMetaData, s2.generatedMetaData);
        }

        @Override
        public int hashCode(StatementWrapper a) {
            return a.sql.hashCode();
        }

        @Override
        public long longKey(StatementWrapper a) {
            return 0L;
        }
    }
}

