/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDDL;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TablePeriodWorks;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class StatementSchema
extends Statement {
    int order;
    Object[] arguments = ValuePool.emptyObjectArray;
    boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema(int type, int group) {
        super(type, group);
        this.isTransactionStatement = true;
    }

    StatementSchema(String sql, int type) {
        this(sql, type, null, null, null);
    }

    StatementSchema(String sql, int type, Object[] args, HsqlNameManager.HsqlName[] readName, HsqlNameManager.HsqlName[] writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.sql = sql;
        if (args != null) {
            this.arguments = args;
        }
        if (readName != null) {
            this.readTableNames = readName;
        }
        if (writeName != null) {
            this.writeTableNames = writeName;
        }
        switch (type) {
            case 1152: 
            case 1153: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 1121: 
            case 1122: 
            case 1146: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 1128: 
            case 1129: 
            case 1130: 
            case 1131: 
            case 1148: {
                this.group = 2002;
                break;
            }
            case 53: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 54: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 63: 
            case 64: {
                this.group = 2002;
                break;
            }
            case 68: {
                this.group = 2001;
                break;
            }
            case 65: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 69: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 71: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 87: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 88: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 89: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 90: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 93: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 94: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 95: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 96: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 1126: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 9: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 11: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 13: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1124: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1125: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1147: {
                this.group = 2002;
                this.order = 12;
                break;
            }
            case 1123: {
                this.group = 2002;
                this.order = 11;
                break;
            }
            case 1214: {
                this.group = 2002;
                this.statementTokens = (Token[])args[0];
                break;
            }
            case 1162: {
                this.group = 2002;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, this.getSQL());
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.database.schemaManager.setSchemaChangeTimestamp();
        HsqlNameManager.HsqlName sessionSchema = session.currentSchema;
        try {
            if (this.type == 1153) {
                session.currentSchema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
            }
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            Result result2 = Result.newErrorResult(e, this.sql);
            return result2;
        }
        finally {
            if (this.type == 1153) {
                session.currentSchema = sessionSchema;
            }
        }
        return result;
    }

    Result getResult(Session session) {
        SchemaManager schemaManager = session.database.schemaManager;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        block35 : switch (this.type) {
            case 1152: 
            case 1153: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName newName = (HsqlNameManager.HsqlName)this.arguments[1];
                boolean ifExists = (Boolean)this.arguments[2];
                switch (name.type) {
                    case 1: {
                        try {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            name.rename(newName);
                            break block35;
                        }
                        catch (HsqlException e) {
                            return Result.newErrorResult(e, this.sql);
                        }
                    }
                    case 2: {
                        StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                        schemaManager.checkSchemaNameCanChange(name);
                        schemaManager.renameSchema(name, newName);
                        break block35;
                    }
                }
                try {
                    SchemaObject object;
                    name.setSchemaIfNull(session.getCurrentSchemaHsqlName());
                    if (ifExists && (object = schemaManager.findUserTable(name.name, name.schema.name)) == null) {
                        return Result.updateZeroResult;
                    }
                    if (name.type == 9) {
                        Table table = schemaManager.getUserTable(name.parent);
                        int index = table.getColumnIndex(name.name);
                        object = table.getColumn(index);
                    } else {
                        object = schemaManager.getSchemaObject(name);
                        if (object == null) {
                            throw Error.error(5501, name.name);
                        }
                        name = name.type == 24 ? ((Routine)object).getSpecificName() : object.getName();
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                    newName.setSchemaIfNull(name.schema);
                    if (name.schema != newName.schema) {
                        HsqlException e = Error.error(5505);
                        return Result.newErrorResult(e, this.sql);
                    }
                    newName.parent = name.parent;
                    switch (object.getType()) {
                        case 9: {
                            HsqlNameManager.HsqlName parent = object.getName().parent;
                            schemaManager.checkObjectIsReferenced(parent);
                            Table table = schemaManager.getUserTable(parent);
                            TriggerDef[] triggers = table.getTriggers();
                            for (int i = 0; i < triggers.length; ++i) {
                                if (!(triggers[i] instanceof TriggerDefSQL)) continue;
                                throw Error.error(5502, triggers[i].getName().getSchemaQualifiedStatementName());
                            }
                            table.renameColumn((ColumnSchema)object, newName);
                            break block35;
                        }
                    }
                    schemaManager.renameSchemaObject(name, newName);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1146: {
                Table table = (Table)this.arguments[0];
                int[] newColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                try {
                    Constraint constraint = (Constraint)session.database.schemaManager.getSchemaObject(name);
                    constraint.extendFKIndexColumns(session, newColumns);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1121: {
                Table table = (Table)this.arguments[0];
                int[] indexColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                try {
                    Index index = (Index)session.database.schemaManager.getSchemaObject(name);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.alterIndex(index, indexColumns);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 5: {
                try {
                    NumberSequence sequence = (NumberSequence)this.arguments[0];
                    NumberSequence settings = (NumberSequence)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, sequence.getSchemaName());
                    sequence.reset(settings);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3: {
                try {
                    int subType = (Integer)this.arguments[0];
                    Type domain = (Type)this.arguments[1];
                    Expression domainDefault = domain.userTypeModifier.getDefaultClause();
                    OrderedHashSet refSet = session.database.schemaManager.getReferencesTo(domain.getName());
                    OrderedHashSet<SchemaObject> tableSet = new OrderedHashSet<SchemaObject>();
                    for (int i = 0; i < refSet.size(); ++i) {
                        HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)refSet.get(i);
                        HsqlNameManager.HsqlName tableName = objectName.parent;
                        if (tableName.type != 3) continue;
                        SchemaObject table = session.database.schemaManager.getSchemaObject(tableName);
                        tableSet.add(table);
                    }
                    if (subType == 1134) {
                        Constraint c = (Constraint)this.arguments[2];
                        for (int i = 0; i < tableSet.size(); ++i) {
                            Table table = (Table)tableSet.get(i);
                            TableWorks tw = new TableWorks(session, table);
                            tw.checkAddDomainConstraint(domain, c);
                        }
                    }
                    switch (subType) {
                        case 1134: {
                            Constraint c = (Constraint)this.arguments[2];
                            this.setOrCheckObjectName(session, domain.getName(), c.getName(), true);
                            domain.userTypeModifier.addConstraint(c);
                            session.database.schemaManager.addSchemaObject(c);
                            break;
                        }
                        case 1135: {
                            Expression e = (Expression)this.arguments[2];
                            domain.userTypeModifier.setDefaultClause(e);
                            break;
                        }
                        case 1130: {
                            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                            session.database.schemaManager.removeSchemaObject(name);
                            break;
                        }
                        case 1132: {
                            domain.userTypeModifier.removeDefaultClause();
                        }
                    }
                    for (int i = 0; i < tableSet.size(); ++i) {
                        Table table = (Table)tableSet.get(i);
                        if (subType == 1132) {
                            for (int j = 0; j < table.getColumnCount(); ++j) {
                                ColumnSchema column = table.getColumn(j);
                                if (column.dataType != domain || column.getDefaultExpression() != null) continue;
                                column.setDefaultExpression(domainDefault);
                            }
                        }
                        table.resetDefaultFlags();
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 7: {
                try {
                    int subType = (Integer)this.arguments[0];
                    Table table = (Table)this.arguments[1];
                    block89 : switch (subType) {
                        case 1134: {
                            SchemaObject object;
                            Constraint c = (Constraint)this.arguments[2];
                            Boolean ifNotExists = (Boolean)this.arguments[3];
                            if (ifNotExists.booleanValue() && (object = session.database.schemaManager.findSchemaObject(c.getName().name, c.getName().schema.name, c.getName().type)) != null) {
                                return Result.updateZeroResult;
                            }
                            switch (c.getConstraintType()) {
                                case 4: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addPrimaryKey(c);
                                    break block89;
                                }
                                case 2: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addUniqueConstraint(c);
                                    break block89;
                                }
                                case 0: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addForeignKey(c);
                                    break block89;
                                }
                                case 3: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addCheckConstraint(c);
                                    break block89;
                                }
                            }
                            break;
                        }
                        case 1133: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int colIndex = (Integer)this.arguments[3];
                            HsqlArrayList list = (HsqlArrayList)this.arguments[4];
                            Boolean ifNotExists = (Boolean)this.arguments[5];
                            TableWorks tableWorks = new TableWorks(session, table);
                            if (ifNotExists.booleanValue() && table.findColumn(column.getName().name) != -1) break;
                            tableWorks.addColumn(column, colIndex, list);
                            break;
                        }
                        case 1136: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            ColumnSchema newCol = column.duplicate();
                            newCol.setType(type);
                            TableWorks tw = new TableWorks(session, table);
                            tw.retypeColumn(column, newCol);
                            break;
                        }
                        case 1144: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            NumberSequence sequence = (NumberSequence)this.arguments[4];
                            ColumnSchema newCol = column.duplicate();
                            newCol.setType(type);
                            newCol.setIdentity(sequence);
                            TableWorks tw = new TableWorks(session, table);
                            tw.retypeColumn(column, newCol);
                            break;
                        }
                        case 1137: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            NumberSequence sequence = (NumberSequence)this.arguments[4];
                            if (column.isIdentity()) {
                                column.getIdentitySequence().reset(sequence);
                                break;
                            }
                            column.setIdentity(sequence);
                            table.setColumnTypeVars(columnIndex);
                            break;
                        }
                        case 1139: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            boolean nullable = (Boolean)this.arguments[3];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColNullability(column, nullable);
                            break;
                        }
                        case 1140: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            Expression e = (Expression)this.arguments[4];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColDefaultExpression(columnIndex, e);
                            break;
                        }
                        case 1141: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            TableWorks tw = new TableWorks(session, table);
                            tw.setColDefaultExpression(columnIndex, null);
                            table.setColumnTypeVars(columnIndex);
                            break;
                        }
                        case 1142: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            column.setGeneratingExpression(null);
                            table.setColumnTypeVars(columnIndex);
                            break;
                        }
                        case 1143: {
                            ColumnSchema column = (ColumnSchema)this.arguments[2];
                            int columnIndex = (Integer)this.arguments[3];
                            column.setIdentity(null);
                            table.setColumnTypeVars(columnIndex);
                            break;
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 115: {
                Table table = (Table)this.arguments[0];
                PeriodDefinition period = (PeriodDefinition)this.arguments[1];
                TablePeriodWorks works = new TablePeriodWorks(session, table);
                try {
                    if (period.getPeriodType() == 1) {
                        works.addSystemPeriod(period);
                        break;
                    }
                    works.addApplicationPeriod(period);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 116: {
                Table table = (Table)this.arguments[0];
                PeriodDefinition period = (PeriodDefinition)this.arguments[1];
                Boolean cascade = (Boolean)this.arguments[2];
                TablePeriodWorks works = new TablePeriodWorks(session, table);
                try {
                    if (period.getPeriodType() == 1) {
                        works.dropSystemPeriod(cascade);
                        break;
                    }
                    works.dropApplicationPeriod(cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 117: {
                Table table = (Table)this.arguments[0];
                TablePeriodWorks works = new TablePeriodWorks(session, table);
                try {
                    works.addSystemVersioning();
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 118: {
                Table table = (Table)this.arguments[0];
                Boolean cascade = (Boolean)this.arguments[1];
                TablePeriodWorks works = new TablePeriodWorks(session, table);
                try {
                    works.dropSystemVersioning(cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 4: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    Routine oldRoutine = (Routine)schemaManager.getSchemaObject(routine.getSpecificName());
                    schemaManager.replaceReferences(oldRoutine, routine);
                    oldRoutine.setAsAlteredRoutine(routine);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 6: 
            case 8: {
                throw Error.runtimeError(201, "StatementSchema");
            }
            case 1122: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    View oldView = (View)schemaManager.getSchemaObject(view.getName());
                    if (oldView == null) {
                        throw Error.error(5501, view.getName().name);
                    }
                    view.setName(oldView.getName());
                    view.compile(session, null);
                    OrderedHashSet dependents = schemaManager.getReferencesTo(oldView.getName());
                    if (dependents.getCommonElementCount(view.getReferences()) > 0) {
                        throw Error.error(5502);
                    }
                    int i = schemaManager.getTableIndex(oldView);
                    schemaManager.setTable(i, view);
                    OrderedHashSet<View> set = new OrderedHashSet<View>();
                    set.add(view);
                    try {
                        schemaManager.recompileDependentObjects(set);
                        schemaManager.replaceReferences(oldView, view);
                    }
                    catch (HsqlException e) {
                        schemaManager.setTable(i, oldView);
                        schemaManager.recompileDependentObjects(set);
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1128: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    Table table = schemaManager.getUserTable(name.parent);
                    int colindex = table.getColumnIndex(name.name);
                    if (table.getColumnCount() == 1) {
                        throw Error.error(5591);
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.dropColumn(colindex, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 1129: 
            case 1130: 
            case 1131: 
            case 1148: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    switch (this.type) {
                        case 29: 
                        case 1131: {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            break;
                        }
                        case 31: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                            if (schemaManager.schemaExists(name.name) || !ifExists) break;
                            return Result.updateZeroResult;
                        }
                        default: {
                            if (name.schema == null) {
                                name.schema = session.getCurrentSchemaHsqlName();
                            } else if (!schemaManager.schemaExists(name.schema.name) && ifExists) {
                                return Result.updateZeroResult;
                            }
                            name.schema = schemaManager.getUserSchemaHsqlName(name.schema.name);
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            SchemaObject object = schemaManager.getSchemaObject(name);
                            if (object == null) {
                                if (ifExists) {
                                    return Result.updateZeroResult;
                                }
                                throw Error.error(5501, name.name);
                            }
                            name = name.type == 24 ? ((Routine)object).getSpecificName() : object.getName();
                        }
                    }
                    if (!cascade) {
                        schemaManager.checkObjectIsReferenced(name);
                    }
                    switch (this.type) {
                        case 29: {
                            StatementSchema.dropRole(session, name, cascade);
                            break;
                        }
                        case 1131: {
                            StatementSchema.dropUser(session, name, cascade);
                            break;
                        }
                        case 31: {
                            this.dropSchema(session, name, cascade);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 32: 
                        case 36: 
                        case 1148: {
                            this.dropObject(session, name, cascade);
                            break;
                        }
                        case 27: {
                            this.dropType(session, name, cascade);
                            break;
                        }
                        case 28: {
                            StatementSchema.dropDomain(session, name, cascade);
                            break;
                        }
                        case 30: {
                            this.dropRoutine(session, name, cascade);
                            break;
                        }
                        case 33: 
                        case 39: {
                            this.dropTable(session, name, cascade);
                            break;
                        }
                        case 34: 
                        case 35: 
                        case 37: 
                        case 38: {
                            break;
                        }
                        case 1129: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            schemaManager.dropIndex(session, name);
                            break;
                        }
                        case 1130: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
                            schemaManager.dropConstraint(session, name, cascade);
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 53: 
            case 63: {
                try {
                    boolean grant = this.type == 53;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[1];
                    this.setSchemaName(session, null, name);
                    name = schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
                    SchemaObject schemaObject = schemaManager.getSchemaObject(name);
                    Right right = (Right)this.arguments[2];
                    Grantee grantor = (Grantee)this.arguments[3];
                    boolean cascade = (Boolean)this.arguments[4];
                    boolean isGrantOption = (Boolean)this.arguments[5];
                    if (grantor == null) {
                        grantor = this.isSchemaDefinition ? this.schemaName.owner : session.getGrantee();
                    }
                    GranteeManager gm = session.database.granteeManager;
                    switch (schemaObject.getType()) {
                        case 14: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            Table t = (Table)schemaObject;
                            right.setColumns(t);
                            if (t.isTemp && !right.isFull()) {
                                return Result.newErrorResult(Error.error(5595), this.sql);
                            }
                            Expression[] filters = right.getFiltersArray();
                            for (int i = 0; i < filters.length; ++i) {
                                if (filters[i] == null) continue;
                                Expression expr = filters[i].duplicate();
                                expr.resolveGrantFilter(session, t);
                            }
                            break;
                        }
                    }
                    if (grant) {
                        gm.grant(session, granteeList, schemaObject, right, grantor, isGrantOption);
                        break;
                    }
                    gm.revoke(granteeList, schemaObject, right, grantor, isGrantOption, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 54: 
            case 64: {
                try {
                    String grantee;
                    int i;
                    boolean grant = this.type == 54;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    OrderedHashSet roleList = (OrderedHashSet)this.arguments[1];
                    Grantee grantor = (Grantee)this.arguments[2];
                    boolean cascade = (Boolean)this.arguments[3];
                    GranteeManager gm = session.database.granteeManager;
                    gm.checkGranteeList(granteeList);
                    for (i = 0; i < granteeList.size(); ++i) {
                        grantee = (String)granteeList.get(i);
                        gm.checkRoleList(grantee, roleList, grantor, grant);
                    }
                    if (grant) {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                String roleName = (String)roleList.get(j);
                                gm.grant(grantee, roleName, grantor);
                            }
                        }
                    } else {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                gm.revoke(grantee, (String)roleList.get(j), grantor);
                            }
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 9: {
                return Result.updateZeroResult;
            }
            case 11: {
                Charset charset = (Charset)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, charset.getName(), true);
                    schemaManager.addSchemaObject(charset);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 13: {
                Collation collation = (Collation)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, collation.getName(), true);
                    schemaManager.addSchemaObject(collation);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 65: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    session.database.getGranteeManager().addRole(name);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1126: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                String password = (String)this.arguments[1];
                Grantee grantor = (Grantee)this.arguments[2];
                boolean admin = (Boolean)this.arguments[3];
                boolean isDigest = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.getUserManager().createUser(session, name, password, isDigest);
                    if (!admin) break;
                    session.database.getGranteeManager().grant(name.name, "DBA", grantor);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 68: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Grantee owner = (Grantee)this.arguments[1];
                Boolean ifNotExists = (Boolean)this.arguments[2];
                try {
                    session.checkDDLWrite();
                    if (schemaManager.schemaExists(name.name)) {
                        if (session.isProcessingScript() && "PUBLIC".equals(name.name)) break;
                        if (ifNotExists != null && ifNotExists.booleanValue()) {
                            return Result.updateZeroResult;
                        }
                        throw Error.error(5504, name.name);
                    }
                    schemaManager.createSchema(name, owner);
                    Schema schema = schemaManager.findSchema(name.name);
                    this.sql = schema.getSQL();
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 69: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, routine.getName(), false);
                    schemaManager.addSchemaObject(routine);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1124: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Routine[] routines = (Routine[])this.arguments[1];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (name == null) break;
                    for (int i = 0; i < routines.length; ++i) {
                        routines[i].setName(name);
                        schemaManager.addSchemaObject(routines[i]);
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 71: {
                NumberSequence sequence = (NumberSequence)this.arguments[0];
                Boolean ifNotExists = (Boolean)this.arguments[1];
                try {
                    this.setOrCheckObjectName(session, null, sequence.getName(), true);
                    schemaManager.addSchemaObject(sequence);
                    break;
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 23: {
                Type type = (Type)this.arguments[0];
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    for (int i = 0; i < constraints.length; ++i) {
                        Constraint c = constraints[i];
                        this.setOrCheckObjectName(session, type.getName(), c.getName(), true);
                        schemaManager.addSchemaObject(c);
                    }
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 87: {
                Table table = (Table)this.arguments[0];
                HsqlArrayList tempConstraints = (HsqlArrayList)this.arguments[1];
                HsqlArrayList tempIndexes = (HsqlArrayList)this.arguments[2];
                StatementDMQL statement = (StatementDMQL)this.arguments[3];
                Boolean ifNotExists = (Boolean)this.arguments[4];
                HsqlArrayList foreignConstraints = null;
                try {
                    this.setOrCheckObjectName(session, null, table.getName(), true);
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
                try {
                    if (this.isSchemaDefinition) {
                        foreignConstraints = new HsqlArrayList();
                    }
                    if (tempConstraints.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, foreignConstraints, true);
                        this.arguments[1] = foreignConstraints;
                    }
                    table.compile(session, null);
                    schemaManager.addSchemaObject(table);
                    if (!tempIndexes.isEmpty()) {
                        TableWorks tableWorks = new TableWorks(session, table);
                        for (int i = 0; i < tempIndexes.size(); ++i) {
                            Constraint c = (Constraint)tempIndexes.get(i);
                            tableWorks.addIndex(c.getMainColumns(), c.getName(), false);
                        }
                        table = tableWorks.getTable();
                    }
                    if (statement != null) {
                        Result result = statement.execute(session);
                        if (result.isError()) {
                            return result;
                        }
                        table.insertIntoTable(session, result);
                        if (table.hasLobColumn) {
                            RowIterator it = table.rowIterator(session);
                            while (it.next()) {
                                Row row = it.getCurrentRow();
                                Object[] data = row.getData();
                                session.sessionData.adjustLobUsageCount(table, data, 1);
                            }
                        }
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    schemaManager.removeExportedKeys(table);
                    schemaManager.removeDependentObjects(table.getName());
                    schemaManager.removeSchemaObject(table.getName());
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 88: {
                return Result.updateZeroResult;
            }
            case 89: {
                return Result.updateZeroResult;
            }
            case 90: {
                TriggerDef trigger = (TriggerDef)this.arguments[0];
                HsqlNameManager.HsqlName otherName = (HsqlNameManager.HsqlName)this.arguments[1];
                Boolean ifNotExists = (Boolean)this.arguments[2];
                try {
                    this.setOrCheckObjectName(session, null, trigger.getName(), true);
                    if (otherName != null) {
                        this.setOrCheckObjectName(session, null, otherName, false);
                        if (schemaManager.getSchemaObject(otherName) == null) {
                            throw Error.error(5501, otherName.name);
                        }
                    }
                    trigger.table.addTrigger(trigger, otherName);
                    schemaManager.addSchemaObject(trigger);
                    trigger.start();
                    break;
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 93: {
                return Result.updateZeroResult;
            }
            case 94: {
                Type type = (Type)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 95: {
                return Result.updateZeroResult;
            }
            case 96: {
                View view = (View)this.arguments[0];
                Boolean ifNotExists = (Boolean)this.arguments[1];
                try {
                    this.setOrCheckObjectName(session, null, view.getName(), true);
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
                try {
                    view.compile(session, null);
                    schemaManager.addSchemaObject(view);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1125: {
                Table table = (Table)this.arguments[0];
                int[] indexColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                boolean unique = (Boolean)this.arguments[3];
                RoutineSchema routineSchema = (RoutineSchema)this.arguments[4];
                Boolean ifNotExists = (Boolean)this.arguments[5];
                try {
                    this.setOrCheckObjectName(session, table.getName(), name, true);
                }
                catch (HsqlException e) {
                    if (ifNotExists != null && ifNotExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e, this.sql);
                }
                try {
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.addIndex(indexColumns, name, unique);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1147: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName targetName = (HsqlNameManager.HsqlName)this.arguments[1];
                this.setSchemaName(session, null, name);
                this.setSchemaName(session, null, targetName);
                this.setOrCheckObjectName(session, null, name, true);
                SchemaObject object = session.database.schemaManager.findAnySchemaObjectForSynonym(name.name, name.schema.name);
                if (object != null) {
                    throw Error.error(5504);
                }
                object = session.database.schemaManager.findAnySchemaObjectForSynonym(targetName.name, targetName.schema.name);
                if (object == null) {
                    throw Error.error(5501);
                }
                if (!session.getGrantee().isFullyAccessibleByRole(object.getName())) {
                    throw Error.error(5501);
                }
                targetName = object.getName();
                ReferenceObject reference = new ReferenceObject(name, targetName);
                schemaManager.addSchemaObject(reference);
                break;
            }
            case 1123: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                String comment = (String)this.arguments[1];
                switch (name.type) {
                    case 9: {
                        Table table = (Table)schemaManager.getSchemaObject(name.parent.name, name.parent.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        int index = table.getColumnIndex(name.name);
                        if (index < 0) {
                            throw Error.error(5501);
                        }
                        ColumnSchema column = table.getColumn(index);
                        column.getName().comment = comment;
                        break block35;
                    }
                    case 3: 
                    case 7: 
                    case 8: 
                    case 18: {
                        SchemaObject object = schemaManager.getSchemaObject(name.name, name.schema.name, name.type);
                        if (!session.getGrantee().isFullyAccessibleByRole(object.getName())) {
                            throw Error.error(5501);
                        }
                        object.getName().comment = comment;
                        break block35;
                    }
                }
                break;
            }
            case 1162: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
        return Result.updateZeroResult;
    }

    private void dropType(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        Type distinct = (Type)session.database.schemaManager.getSchemaObject(name);
        session.database.schemaManager.removeSchemaObject(name, cascade);
        distinct.userTypeModifier = null;
    }

    private static void dropDomain(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Type domain = (Type)session.database.schemaManager.getSchemaObject(name);
        OrderedHashSet set = session.database.schemaManager.getReferencesTo(domain.getName());
        if (!cascade && set.size() > 0) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        Constraint[] constraints = domain.userTypeModifier.getConstraints();
        OrderedHashSet<HsqlNameManager.HsqlName> constraintNames = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < constraints.length; ++i) {
            constraintNames.add(constraints[i].getName());
        }
        session.database.schemaManager.removeSchemaObjects(constraintNames);
        session.database.schemaManager.removeSchemaObject(domain.getName(), cascade);
        domain.userTypeModifier = null;
    }

    private static void dropRole(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Grantee role = session.database.getGranteeManager().getRole(name.name);
        if (!cascade && session.database.schemaManager.hasSchemas(role)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(role);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, role, cascade);
        session.database.getGranteeManager().dropRole(name.name);
    }

    private static void dropUser(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        User grantee = session.database.getUserManager().get(name.name);
        if (session.database.getSessionManager().isUserActive(name.name)) {
            throw Error.error(5539);
        }
        if (!cascade && session.database.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(grantee);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, grantee, cascade);
        session.database.getUserManager().dropUser(name.name);
    }

    private void dropSchema(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        HsqlNameManager.HsqlName schema = session.database.schemaManager.getUserSchemaHsqlName(name.name);
        StatementSchema.checkSchemaUpdateAuthorisation(session, schema);
        session.database.schemaManager.dropSchema(session, name.name, cascade);
    }

    private void dropRoutine(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropObject(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        name = session.database.schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropTable(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Table table = session.database.schemaManager.findUserTable(name.name, name.schema.name);
        session.database.schemaManager.dropTableOrView(session, table, cascade);
    }

    static void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            throw Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name, boolean checkNotExists) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
        if (name.parent == null) {
            name.parent = parent;
        }
        if (!this.isSchemaDefinition) {
            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        }
        if (checkNotExists) {
            session.database.schemaManager.checkSchemaObjectNotExists(name);
        }
    }

    void setSchemaName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name) {
        if (name.type == 2) {
            return;
        }
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

