/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.result.Result;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.Type;

public class StatementSession
extends Statement {
    public static final StatementSession commitNoChainStatement = new StatementSession(14, new Object[]{Boolean.FALSE});
    public static final StatementSession rollbackNoChainStatement = new StatementSession(66, new Object[]{Boolean.FALSE});
    public static final StatementSession commitAndChainStatement = new StatementSession(14, new Object[]{Boolean.TRUE});
    public static final StatementSession rollbackAndChainStatement = new StatementSession(66, new Object[]{Boolean.TRUE});
    Expression[] expressions;
    Object[] arguments;

    StatementSession(Session session, ParserDQL.CompileContext context, int type, Expression[] args) {
        super(type);
        this.expressions = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        Expression e = this.expressions[0];
        switch (type) {
            case 76: {
                List unresolved = e.resolveColumnReferences(session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                e.resolveTypes(session, null);
                if (e.dataType == null) {
                    e.setDataType(session, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
                }
                if (!e.dataType.isCharacterType() && e.dataType.typeCode != 111) {
                    throw Error.error(5563);
                }
                this.group = 2008;
                return;
            }
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
        e.resolveTypes(session, null);
        switch (e.getType()) {
            case 1: {
                break;
            }
            case 8: {
                e.setDataType(session, Type.SQL_VARCHAR_DEFAULT);
                break;
            }
            case 28: {
                if (((FunctionSQL)e).isValueFunction()) break;
                throw Error.error(2200);
            }
            default: {
                throw Error.error(2200);
            }
        }
        if (!e.getDataType().isCharacterType()) {
            throw Error.error(2200);
        }
        this.setDatabaseObjects(session, context);
    }

    StatementSession(int type, Object[] args) {
        super(type);
        this.arguments = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (type) {
            case 80: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 1127: {
                this.group = 2011;
                this.isLogged = true;
                break;
            }
            case 1: {
                this.group = 2003;
                break;
            }
            case 2: 
            case 16: 
            case 17: {
                this.group = 2010;
                break;
            }
            case 41: {
                this.group = 2004;
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                this.group = 2003;
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                this.group = 2003;
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                this.group = 2010;
                break;
            }
            case 22: {
                this.group = 2006;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 84: 
            case 1114: 
            case 1115: 
            case 1116: 
            case 1117: {
                this.group = 2011;
                break;
            }
            case 1048: {
                this.isLogged = true;
                this.group = 2011;
                break;
            }
            case 14: 
            case 61: 
            case 66: 
            case 67: 
            case 85: 
            case 86: 
            case 1118: {
                this.group = 2005;
                break;
            }
            case 33: 
            case 1119: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    StatementSession(int type, HsqlNameManager.HsqlName[] readNames, HsqlNameManager.HsqlName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.isLogged = false;
        this.readTableNames = readNames;
        this.writeTableNames = writeNames;
        switch (type) {
            case 1111: 
            case 1112: 
            case 1113: {
                this.group = 2016;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    Result getResult(Session session) {
        startTransaction = false;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Result.updateZeroResult;
            }
            case 14: {
                try {
                    chain = (Boolean)this.arguments[0];
                    session.commit(chain);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 16: 
            case 17: {
                return Result.updateZeroResult;
            }
            case 22: {
                session.close();
                return Result.updateZeroResult;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                return Result.updateZeroResult;
            }
            case 1111: 
            case 1112: 
            case 1113: {
                return Result.updateZeroResult;
            }
            case 61: {
                savepoint = (String)this.arguments[0];
                try {
                    session.releaseSavepoint(savepoint);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 66: {
                chain = (Boolean)this.arguments[0];
                session.rollback(chain);
                return Result.updateZeroResult;
            }
            case 1118: {
                savepoint = (String)this.arguments[0];
                try {
                    session.rollbackToSavepoint(savepoint);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 67: {
                savepoint = (String)this.arguments[0];
                session.savepoint(savepoint);
                return Result.updateZeroResult;
            }
            case 72: {
                try {
                    name = (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                    if (session.database.getCatalogName().name.equals(name)) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(Error.error(4840), this.sql);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 73: 
            case 74: 
            case 75: {
                return Result.updateZeroResult;
            }
            case 76: {
                value = null;
                if (this.expressions[0].getType() == 1 && this.expressions[0].getConstantValueNoCheck(session) == null) {
                    session.resetTimeZone();
                    return Result.updateZeroResult;
                }
                try {
                    value = this.expressions[0].getValue(session);
                }
                catch (HsqlException e) {
                    // empty catch block
                }
                if (!(value instanceof Result)) ** GOTO lbl81
                result = (Result)value;
                if (!result.isData()) ** GOTO lbl80
                data = null;
                single = false;
                if (result.getNavigator().next()) {
                    data = result.getNavigator().getCurrent();
                    v0 = single = result.getNavigator().next() == false;
                }
                if (single && data != null && data[0] != null) {
                    value = data[0];
                    result.getNavigator().release();
                } else {
                    result.getNavigator().release();
                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl80:
                    // 1 sources

                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl81:
                    // 1 sources

                    if (value == null) {
                        return Result.newErrorResult(Error.error(3409), this.sql);
                    }
                }
                if (value instanceof String) {
                    zoneString = (String)value;
                    if (DateTimeType.zoneIDs.contains(zoneString)) {
                        zone = TimeZone.getTimeZone(zoneString);
                        session.setTimeZone(zone);
                        return Result.updateZeroResult;
                    }
                    value = Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, value);
                }
                if (value instanceof IntervalSecondData && -64800L <= (seconds = (interval = (IntervalSecondData)value).getSeconds()) && seconds <= 64800L) {
                    i = Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(interval);
                    sign = seconds < 0L ? "" : "+";
                    zoneString = "GMT" + sign + i;
                    zone = TimeZone.getTimeZone(zoneString);
                    session.setTimeZone(zone);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(3409), this.sql);
            }
            case 77: {
                return Result.updateZeroResult;
            }
            case 78: {
                return Result.updateZeroResult;
            }
            case 79: {
                role = null;
                try {
                    name = (String)this.expressions[0].getValue(session);
                    if (name != null) {
                        name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                        role = session.database.granteeManager.getRole(name);
                    }
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(Error.error(2200), this.sql);
                }
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                if (role == null) {
                    session.setRole(null);
                }
                if (session.getGrantee().hasRole(role)) {
                    session.setRole(role);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(2200), this.sql);
            }
            case 80: {
                try {
                    name = this.expressions == null ? ((HsqlNameManager.HsqlName)this.arguments[0]).name : (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, ' ', true, true);
                    schema = session.database.schemaManager.getSchemaHsqlName(name);
                    session.setCurrentSchemaHsqlName(schema);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 81: {
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                try {
                    password = null;
                    user = (String)this.expressions[0].getValue(session);
                    user = (String)Type.SQL_VARCHAR.trim(session, user, ' ', true, true);
                    if (this.expressions[1] != null) {
                        password = (String)this.expressions[1].getValue(session);
                    }
                    if ((userObject = password == null ? session.database.userManager.get(user) : session.database.getUserManager().getUser(user, password)) == null) {
                        throw Error.error(4001);
                    }
                    this.sql = userObject.getConnectUserSQL();
                    if (userObject == session.getGrantee()) {
                        return Result.updateZeroResult;
                    }
                    if (password == null && !session.isProcessingLog() && userObject.isAdmin() && !session.getGrantee().isAdmin()) {
                        throw Error.error(4000);
                    }
                    if (session.getGrantee().canChangeAuthorisation()) {
                        session.setUser(userObject);
                        session.setRole(null);
                        session.resetSchema();
                        return Result.updateZeroResult;
                    }
                    throw Error.error(5507);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 82: {
                try {
                    if (this.arguments[0] != null) {
                        readonly = (Boolean)this.arguments[0];
                        session.setReadOnlyDefault(readonly);
                    }
                    if (this.arguments[1] != null) {
                        level = (Integer)this.arguments[1];
                        session.setIsolationDefault(level);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 83: {
                return Result.updateZeroResult;
            }
            case 84: {
                return Result.updateZeroResult;
            }
            case 86: {
                startTransaction = true;
            }
            case 85: {
                try {
                    if (this.arguments[0] != null) {
                        readonly = (Boolean)this.arguments[0];
                        session.setReadOnly(readonly);
                    }
                    if (this.arguments[1] != null) {
                        level = (Integer)this.arguments[1];
                        session.setIsolation(level);
                    }
                    if (startTransaction) {
                        session.startTransaction();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1114: {
                mode = (Boolean)this.arguments[0];
                rows = (Integer)this.arguments[1];
                try {
                    if (rows < 0) {
                        session.setAutoCommit(mode);
                    } else {
                        session.setAutoCommitRows(rows);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1127: {
                variables = (ColumnSchema[])this.arguments[0];
                try {
                    for (i = 0; i < variables.length; ++i) {
                        session.sessionContext.addSessionVariable(variables[i]);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1115: {
                feature = (String)this.arguments[0];
                value = (Boolean)this.arguments[1];
                session.setFeature(feature, value);
                return Result.updateZeroResult;
            }
            case 1116: {
                size = (Integer)this.arguments[0];
                session.setSQLMaxRows(size);
                return Result.updateZeroResult;
            }
            case 1117: {
                size = (Integer)this.arguments[0];
                session.setResultMemoryRowCount(size);
                return Result.updateZeroResult;
            }
            case 1048: {
                try {
                    mode = (Boolean)this.arguments[0];
                    session.setIgnoreCase(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1119: {
                table = (Table)this.arguments[0];
                tempConstraints = (HsqlArrayList)this.arguments[1];
                statement = (StatementDMQL)this.arguments[3];
                ifNotExists = (Boolean)this.arguments[4];
                try {
                    if (tempConstraints.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, null, false);
                    }
                    table.compile(session, null);
                    try {
                        session.sessionContext.addSessionTable(table);
                    }
                    catch (HsqlException e) {
                        if (ifNotExists != null && ifNotExists.booleanValue()) {
                            return Result.updateZeroResult;
                        }
                        return Result.newErrorResult(e, this.sql);
                    }
                    if (table.hasLobColumn) {
                        throw Error.error(5534);
                    }
                    if (statement != null) {
                        result = statement.execute(session);
                        table.insertIntoTable(session, result);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 33: {
                name = (HsqlNameManager.HsqlName)this.arguments[0];
                ifExists = (Boolean)this.arguments[1];
                table = session.sessionContext.findSessionTable(name.name);
                if (table == null) {
                    if (ifExists.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    throw Error.error(5501, name.name);
                }
                session.sessionData.persistentStoreCollection.removeStore(table);
                session.sessionContext.dropSessionTable(name.name);
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatementSession");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return false;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public boolean isCatalogLock(int model) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    static {
        StatementSession.commitNoChainStatement.sql = "COMMIT";
        StatementSession.commitAndChainStatement.sql = "COMMIT CHAIN";
        StatementSession.rollbackNoChainStatement.sql = "ROLLBACK";
        StatementSession.rollbackAndChainStatement.sql = "ROLLBACK CHAIN";
        StatementSession.commitNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.commitAndChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackAndChainStatement.compileTimestamp = Long.MAX_VALUE;
    }
}

