/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementSignal
extends Statement {
    String sqlState;
    Expression messageExpression;

    StatementSignal(int type, String sqlState, Expression message) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = sqlState;
        this.messageExpression = message;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 108: {
                sb.append("SIGNAL").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 106: {
                sb.append("RESIGNAL").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 106: 
            case 108: {
                HsqlException ex = Error.error(this.getMessage(session), this.sqlState);
                return Result.newErrorResult(ex);
            }
        }
        throw Error.runtimeError(201, "StatementSignal");
    }

    void setMessage(Expression message) {
        this.messageExpression = message;
    }

    String getMessage(Session session) {
        if (this.messageExpression == null) {
            return null;
        }
        return (String)this.messageExpression.getValue(session);
    }

    @Override
    public void resolve(Session session) {
        boolean resolved = false;
        switch (this.type) {
            case 106: 
            case 108: {
                resolved = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSignal");
            }
        }
        if (!resolved) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public boolean isCatalogLock(int model) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

