/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class TableBase
implements Cloneable {
    public static final int INFO_SCHEMA_TABLE = 1;
    public static final int SYSTEM_SUBQUERY = 2;
    public static final int TEMP_TABLE = 3;
    public static final int MEMORY_TABLE = 4;
    public static final int CACHED_TABLE = 5;
    public static final int TEMP_TEXT_TABLE = 6;
    public static final int TEXT_TABLE = 7;
    public static final int VIEW_TABLE = 8;
    public static final int RESULT_TABLE = 9;
    public static final int TRANSITION_TABLE = 10;
    public static final int FUNCTION_TABLE = 11;
    public static final int SYSTEM_TABLE = 12;
    public static final int CHANGE_SET_TABLE = 13;
    public static final int MODULE_TABLE = 14;
    public static final int SCOPE_ROUTINE = 20;
    public static final int SCOPE_STATEMENT = 21;
    public static final int SCOPE_TRANSACTION = 22;
    public static final int SCOPE_SESSION = 23;
    public static final int SCOPE_FULL = 24;
    public PersistentStore store;
    public int persistenceScope;
    public long persistenceId;
    int tableSpace = 7;
    Index[] indexList;
    public Database database;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    Index fullIndex;
    boolean[] colNotNull;
    Type[] colTypes;
    protected int columnCount;
    boolean[] emptyColumnCheckList;
    int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    boolean isView;
    protected boolean isWithDataSource;
    public boolean isSessionBased;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    public boolean isSystemVersioned;
    boolean hasLobColumn;

    TableBase() {
    }

    public TableBase duplicate() {
        TableBase copy;
        try {
            copy = (TableBase)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "Expression");
        }
        copy.persistenceId = this.database.persistentStoreCollection.getNextId();
        return copy;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final void setTableType(int type) {
        if (this.tableType == 4 && type == 1) {
            this.tableType = type;
            this.persistenceScope = 22;
            this.isSessionBased = true;
            this.tableType = type;
        }
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    public int getSpaceID() {
        return this.tableSpace;
    }

    public void setSpaceID(int id) {
        this.tableSpace = id;
    }

    int getId() {
        return 0;
    }

    public final boolean onCommitPreserve() {
        return this.persistenceScope == 23;
    }

    public final RowIterator rowIterator(Session session) {
        PersistentStore store = this.getRowStore(session);
        return this.getDefaultIndex().firstRow(session, store, null, 0, null);
    }

    public final RowIterator rowIterator(PersistentStore store) {
        return this.getDefaultIndex().firstRow(store);
    }

    public final int getIndexCount() {
        return this.indexList.length;
    }

    public final Index getPrimaryIndex() {
        return this.indexList.length > 0 ? this.indexList[0] : null;
    }

    public Index getDefaultIndex() {
        return this.indexList[0];
    }

    public final Type[] getPrimaryKeyTypes() {
        return this.indexList[0].getColumnTypes();
    }

    public final boolean hasPrimaryKey() {
        return this.indexList[0].getColumnCount() > 0;
    }

    public final int[] getPrimaryKey() {
        return this.indexList[0].getColumns();
    }

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public final Index getIndex(int i) {
        return this.indexList[i];
    }

    public final Index[] getIndexList() {
        return this.indexList;
    }

    public final boolean[] getNewColumnCheckList() {
        return new boolean[this.getColumnCount()];
    }

    public final boolean[] getEmptyColumnCheckList() {
        return this.emptyColumnCheckList;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        return this.colTypes.length;
    }

    public boolean isSystemVersioned() {
        return this.isSystemVersioned;
    }

    public final void setBestRowIdentifiers() {
        int[] briCols = null;
        int briColsCount = 0;
        boolean isStrict = false;
        int nNullCount = 0;
        if (this.colNotNull == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] cols = index.getColumns();
            int colsCount = index.getColumnCount();
            if (colsCount == 0) continue;
            if (i == 0) {
                isStrict = true;
            }
            if (this.bestIndexForColumn[cols[0]] == -1) {
                this.bestIndexForColumn[cols[0]] = i;
            } else {
                Index existing = this.indexList[this.bestIndexForColumn[cols[0]]];
                if (colsCount > existing.getColumns().length) {
                    this.bestIndexForColumn[cols[0]] = i;
                }
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int nnullc = 0;
            for (int j = 0; j < colsCount; ++j) {
                if (!this.colNotNull[cols[j]]) continue;
                ++nnullc;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (nnullc == colsCount) {
                if (briCols != null && briColsCount == nNullCount && colsCount >= briColsCount) continue;
                briCols = cols;
                briColsCount = colsCount;
                nNullCount = colsCount;
                isStrict = true;
                continue;
            }
            if (isStrict || briCols != null && colsCount >= briColsCount && nnullc <= nNullCount) continue;
            briCols = cols;
            briColsCount = colsCount;
            nNullCount = nnullc;
        }
        this.bestRowIdentifierCols = briCols == null || briColsCount == briCols.length ? briCols : ArrayUtil.arraySlice(briCols, 0, briColsCount);
        this.bestRowIdentifierStrict = isStrict;
        if (this.indexList[0].getColumnCount() > 0) {
            this.bestIndex = this.indexList[0];
        }
    }

    public boolean[] getColumnNotNull() {
        return this.colNotNull;
    }

    public final void createPrimaryIndex(int[] pkcols, Type[] pktypes, HsqlNameManager.HsqlName name) {
        Index newIndex = this.getNewPrimaryIndex(pkcols, pktypes, name);
        this.addIndexStructure(newIndex);
    }

    Index getNewPrimaryIndex(int[] pkcols, Type[] pktypes, HsqlNameManager.HsqlName name) {
        long id = this.database.persistentStoreCollection.getNextId();
        return this.database.logger.newIndex(name, id, this, pkcols, null, null, pktypes, true, pkcols.length > 0, pkcols.length > 0, false);
    }

    public final Index createAndAddIndexStructure(Session session, HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward) {
        Index newindex = this.createIndexStructure(name, columns, descending, nullsLast, false, unique, constraint, forward);
        this.addIndex(session, newindex);
        return newindex;
    }

    public final Index createIndexStructure(HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean primaryKey, boolean unique, boolean constraint, boolean forward) {
        int s = columns.length;
        int[] cols = new int[s];
        Type[] types = new Type[s];
        for (int j = 0; j < s; ++j) {
            cols[j] = columns[j];
            types[j] = this.colTypes[cols[j]];
        }
        long id = this.database.persistentStoreCollection.getNextId();
        Index newIndex = this.database.logger.newIndex(name, id, this, cols, descending, nullsLast, types, primaryKey, unique, constraint, forward);
        return newIndex;
    }

    public void dropIndex(Session session, int todrop) {
        Index[] list = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, todrop, -1);
        for (int i = 0; i < list.length; ++i) {
            list[i].setPosition(i);
        }
        this.resetAccessorKeys(session, list);
        this.indexList = list;
        this.setBestRowIdentifiers();
    }

    final void addIndexStructure(Index index) {
        this.indexList = TableBase.getNewIndexArray(index, this.indexList);
        this.setBestRowIdentifiers();
    }

    static Index[] getNewIndexArray(Index index, Index[] list) {
        boolean replacePK;
        int i;
        for (i = 0; i < list.length; ++i) {
            Index current = list[i];
            int order = index.getIndexOrderValue() - current.getIndexOrderValue();
            if (order < 0) break;
        }
        boolean bl = replacePK = index.isPrimaryKey() && list.length > 0 && list[0].isPrimaryKey();
        if (replacePK) {
            list = (Index[])ArrayUtil.duplicateArray(list);
            list[0] = index;
        } else {
            list = (Index[])ArrayUtil.toAdjustedArray(list, index, i, 1);
        }
        for (i = 0; i < list.length; ++i) {
            list[i].setPosition(i);
        }
        return list;
    }

    final void addIndex(Session session, Index index) {
        Index[] list = TableBase.getNewIndexArray(index, this.indexList);
        try {
            this.resetAccessorKeys(session, list);
        }
        catch (HsqlException e) {
            for (int i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].setPosition(i);
            }
            throw e;
        }
        this.indexList = list;
        this.setBestRowIdentifiers();
    }

    private void resetAccessorKeys(Session session, Index[] indexes) {
        if (this.store != null) {
            this.store.resetAccessorKeys(session, indexes);
        }
    }

    public final void setIndexes(Index[] indexes) {
        this.indexList = indexes;
    }

    public final Object[] getEmptyRowData() {
        return new Object[this.getDataColumnCount()];
    }

    public final Index createIndex(Session session, HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward) {
        Index newIndex = this.createAndAddIndexStructure(session, name, columns, descending, nullsLast, unique, constraint, forward);
        return newIndex;
    }

    public final boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        PersistentStore store = this.getRowStore(session);
        return this.getIndex(0).isEmpty(store);
    }

    public PersistentStore getRowStore(Session session) {
        return this.store == null ? session.sessionData.persistentStoreCollection.getStore(this) : this.store;
    }
}

