/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class TableDerived
extends Table {
    public static final TableDerived[] emptyArray = new TableDerived[0];
    QueryExpression queryExpression;
    Expression dataExpression;
    boolean uniqueRows;
    boolean uniquePredicate;
    String sql;
    View view;
    int depth;
    boolean canRecompile = false;

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type) {
        super(database, name, type);
        switch (type) {
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type, HsqlNameManager.HsqlName[] colNames, Type[] colTypes) {
        this(database, name, type);
        for (int i = 0; i < colNames.length; ++i) {
            ColumnSchema column = new ColumnSchema(colNames[i], colTypes[i]);
            this.columnList.add(column.getName().name, column);
        }
        this.columnCount = colNames.length;
        this.createPrimaryKey(null, null, false);
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type, Type[] columnTypes, OrderedHashMap columnList, int[] pkColumns) {
        this(database, name, type);
        this.colTypes = columnTypes;
        this.columnList = columnList;
        this.columnCount = columnList.size();
        this.createPrimaryKey(null, pkColumns, true);
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type, QueryExpression queryExpression, Expression dataExpression, int opType, int depth) {
        super(database, name, type);
        switch (type) {
            case 2: 
            case 8: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.queryExpression = queryExpression;
        this.dataExpression = dataExpression;
        this.depth = depth;
        switch (opType) {
            case 55: {
                queryExpression.setSingleRow();
                break;
            }
            case 54: {
                if (queryExpression != null) {
                    queryExpression.setFullOrder();
                }
                this.uniqueRows = true;
                break;
            }
            case 66: {
                queryExpression.setFullOrder();
                this.uniquePredicate = true;
                break;
            }
            case 68: {
                queryExpression.setFullOrder();
                break;
            }
        }
        if (dataExpression != null) {
            dataExpression.table = this;
        }
    }

    public TableDerived newDerivedTable(Session session, ParserDQL.CompileContext baseContext) {
        TableDerived td = this;
        if (this.isRecompiled()) {
            ParserDQL p = new ParserDQL(session, new Scanner(), baseContext);
            p.compileContext.setCurrentSubquery(this.tableName);
            p.reset(session, this.sql);
            p.read();
            td = p.XreadSubqueryTableBody(this.tableName, 23);
            td.queryExpression.resolve(session, p.compileContext.getOuterRanges(), null);
            td.columnList = this.columnList;
            td.columnCount = this.columnList.size();
            td.triggerList = this.triggerList;
            td.triggerLists = this.triggerLists;
            td.view = this.view;
            td.createPrimaryKey();
        }
        return td;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public boolean isQueryBased() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        if (this.view != null && this.view.isTriggerInsertable) {
            return false;
        }
        return this.queryExpression == null ? false : this.queryExpression.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        if (this.view != null && this.view.isTriggerUpdatable) {
            return false;
        }
        return this.queryExpression == null ? false : this.queryExpression.isUpdatable();
    }

    @Override
    public int[] getUpdatableColumns() {
        if (this.queryExpression != null) {
            return this.queryExpression.getBaseTableColumnMap();
        }
        return this.defaultColumnMap;
    }

    @Override
    public boolean isTriggerInsertable() {
        if (this.view != null) {
            return this.view.isTriggerInsertable;
        }
        return false;
    }

    @Override
    public boolean isTriggerUpdatable() {
        if (this.view != null) {
            return this.view.isTriggerUpdatable;
        }
        return false;
    }

    @Override
    public boolean isTriggerDeletable() {
        if (this.view != null) {
            return this.view.isTriggerDeletable;
        }
        return false;
    }

    @Override
    public Table getBaseTable() {
        return this.queryExpression == null ? this : this.queryExpression.getBaseTable();
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.queryExpression == null ? null : this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public QueryExpression getQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public Expression getDataExpression() {
        return this.dataExpression;
    }

    @Override
    public void prepareTable(Session session) {
        if (this.columnCount > 0) {
            return;
        }
        if (this.dataExpression != null && this.columnCount == 0) {
            TableUtil.addAutoColumns(this, this.dataExpression.nodeDataTypes);
            this.setTableIndexesForSubquery(session);
        }
        if (this.queryExpression != null) {
            this.columnList = this.queryExpression.getColumns();
            this.columnCount = this.queryExpression.getColumnCount();
            this.setTableIndexesForSubquery(session);
        }
    }

    public void prepareTable(Session session, HsqlNameManager.HsqlName[] columns) {
        this.prepareTable(session);
        if (columns != null) {
            if (columns.length != this.columnList.size()) {
                throw Error.error(5593);
            }
            OrderedHashMap<String, ColumnSchema> newColumnList = new OrderedHashMap<String, ColumnSchema>();
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnSchema col = (ColumnSchema)this.columnList.get(i);
                col.setName(columns[i]);
                newColumnList.add(columns[i].name, col);
            }
            this.columnList = newColumnList;
        }
    }

    private void setTableIndexesForSubquery(Session session) {
        int[] cols = null;
        boolean hasFullIndex = false;
        if (this.queryExpression != null && this.queryExpression.fullIndex != null) {
            hasFullIndex = true;
        }
        if (hasFullIndex || this.uniqueRows || this.uniquePredicate) {
            cols = new int[this.getColumnCount()];
            ArrayUtil.fillSequence(cols);
        }
        int[] pkcols = (int[])(this.uniqueRows ? cols : null);
        this.createPrimaryKey(null, pkcols, false);
        if (this.uniqueRows) {
            this.fullIndex = this.getPrimaryIndex();
        } else if (this.uniquePredicate || hasFullIndex) {
            this.fullIndex = this.createIndexForColumns(session, cols);
        }
    }

    void setCorrelated() {
        if (this.dataExpression != null) {
            this.dataExpression.isCorrelated = true;
        }
        if (this.queryExpression != null) {
            this.queryExpression.isCorrelated = true;
        }
    }

    boolean isCorrelated() {
        if (this.dataExpression != null) {
            return this.dataExpression.isCorrelated;
        }
        if (this.queryExpression != null) {
            return this.queryExpression.isCorrelated;
        }
        return false;
    }

    boolean hasUniqueNotNullRows(Session session) {
        return this.getNavigator(session).hasUniqueNotNullRows();
    }

    void resetToView() {
        this.queryExpression = this.view.getQueryExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void materialise(Session session) {
        session.sessionContext.pushStatementState();
        try {
            if (this.dataExpression != null) {
                PersistentStore store = session.sessionData.getSubqueryRowStore(this);
                this.dataExpression.insertValuesIntoSubqueryTable(session, store);
                return;
            }
            if (this.queryExpression == null) {
                return;
            }
            Result result = this.queryExpression.getResult(session, 0);
            if (this.uniqueRows) {
                RowSetNavigatorData navigator = (RowSetNavigatorData)result.getNavigator();
                navigator.removeDuplicates();
            }
            PersistentStore store = session.sessionData.getSubqueryRowStore(this);
            this.insertResult(session, store, result);
            result.getNavigator().release();
        }
        finally {
            session.sessionContext.popStatementState();
        }
    }

    @Override
    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated()) {
            this.materialise(session);
        }
    }

    public boolean isRecompiled() {
        if (this.canRecompile && this.queryExpression instanceof QuerySpecification) {
            QuerySpecification qs = (QuerySpecification)this.queryExpression;
            return !qs.isAggregated && !qs.isGrouped && !qs.isOrderSensitive;
        }
        return false;
    }

    public Object[] getValues(Session session) {
        RowIterator it = this.rowIterator(session);
        if (it.next()) {
            Row row = it.getCurrentRow();
            if (it.next()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] data = this.getValues(session);
        return data[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable navigator = new RowSetNavigatorDataTable(session, this);
        return navigator;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }
}

