/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.PeriodDefinition;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;

class TablePeriodWorks {
    private Table table;
    private Session session;

    public TablePeriodWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    void addSystemPeriod(PeriodDefinition period) {
        if (this.table.systemPeriod != null) {
            throw Error.error(5517);
        }
        TableWorks tw = new TableWorks(this.session, this.table);
        tw.addSystemPeriod(period);
    }

    void addApplicationPeriod(PeriodDefinition period) {
        throw Error.error(1551);
    }

    void addSystemVersioning() {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5518);
        }
        this.table.isSystemVersioned = true;
    }

    void dropSystemPeriod(boolean cascade) {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5517);
        }
        TableWorks tw = new TableWorks(this.session, this.table);
        tw.dropSystemPeriod(cascade);
    }

    void dropApplicationPeriod(boolean cascade) {
        throw Error.error(1551);
    }

    void dropSystemVersioning(boolean cascade) {
        if (!this.table.isSystemVersioned()) {
            throw Error.error(5518);
        }
        TableWorks tw = new TableWorks(this.session, this.table);
        tw.dropSystemVersioning(cascade);
        long timestampLimit = DateTimeType.epochLimitTimestamp.getSeconds();
        this.removeOldRows(timestampLimit);
        this.table.isSystemVersioned = false;
    }

    long removeOldRows(long timestampLimit) {
        int colIndex = this.table.systemPeriodEndColumn;
        long count = 0L;
        RowIterator it = this.table.rowIterator(this.session);
        while (it.next()) {
            TimestampData value = (TimestampData)it.getField(colIndex);
            if (value.getSeconds() >= timestampLimit) continue;
            it.removeCurrent();
        }
        return count;
    }
}

