/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.types.Type;

public class TableUtil {
    static Table newSingleColumnTable(Database database, HsqlNameManager.HsqlName tableName, int tableType, HsqlNameManager.HsqlName colName, Type colType) {
        TableDerived table = new TableDerived(database, tableName, tableType);
        ColumnSchema column = new ColumnSchema(colName, colType, false, true, null);
        table.addColumn(column);
        table.createPrimaryKeyConstraint(table.getName(), new int[]{0}, true);
        return table;
    }

    public static void addAutoColumns(Table table, Type[] colTypes) {
        for (int i = 0; i < colTypes.length; ++i) {
            ColumnSchema column = new ColumnSchema(HsqlNameManager.getAutoColumnName(i), colTypes[i], true, false, null);
            table.addColumnNoCheck(column);
        }
    }

    public static void setColumnsInSchemaTable(Table table, HsqlNameManager.HsqlName[] columnNames, Type[] columnTypes) {
        for (int i = 0; i < columnNames.length; ++i) {
            HsqlNameManager.HsqlName columnName = columnNames[i];
            columnName = table.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnName);
            ColumnSchema column = new ColumnSchema(columnName, columnTypes[i], true, false, null);
            table.addColumn(column);
        }
        table.setColumnStructures();
    }
}

