/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class TableWorks {
    OrderedHashSet emptySet = new OrderedHashSet();
    private Database database;
    private Table table;
    private Session session;

    public TableWorks(Session session, Table table) {
        this.database = table.database;
        this.table = table;
        this.session = session;
        if (table.isView()) {
            throw Error.error(5524);
        }
    }

    public Table getTable() {
        return this.table;
    }

    void checkCreateForeignKey(Table fkTable, Constraint c) {
        ColumnSchema col;
        int[] cols = c.getRefColumns();
        for (int i = 0; i < cols.length; ++i) {
            ColumnSchema column = fkTable.getColumn(cols[i]);
            if (!column.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        boolean check = c.hasTriggeredAction();
        if (check) {
            for (int i = 0; i < c.core.refCols.length; ++i) {
                col = fkTable.getColumn(c.core.refCols[i]);
                if (!col.isGenerated()) continue;
                throw Error.error(5524, col.getNameString());
            }
        }
        if (c.core.mainName == fkTable.getName() && ArrayUtil.haveCommonElement(c.core.refCols, c.core.mainCols)) {
            throw Error.error(5527);
        }
        boolean bl = check = c.getUpdateAction() == 4 || c.getDeleteAction() == 4;
        if (check) {
            for (int i = 0; i < c.core.refCols.length; ++i) {
                col = fkTable.getColumn(c.core.refCols[i]);
                Expression defExpr = col.getDefaultExpression();
                if (defExpr != null) continue;
                String columnName = col.getName().statementName;
                throw Error.error(5521, columnName);
            }
        }
        boolean bl2 = check = c.core.updateAction == 2 || c.core.deleteAction == 2;
        if (check && !this.session.isProcessingScript()) {
            for (int i = 0; i < c.core.refCols.length; ++i) {
                col = fkTable.getColumn(c.core.refCols[i]);
                if (col.isNullable() && !col.isPrimaryKey()) continue;
                String columnName = col.getName().statementName;
                throw Error.error(5520, columnName);
            }
        }
        this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
        if (fkTable.getConstraint(c.getName().name) != null) {
            throw Error.error(5504, c.getName().statementName);
        }
        if (fkTable.getFKConstraintForColumns(c.core.mainTable, c.core.mainCols, c.core.refCols) != null) {
            throw Error.error(5528, c.getName().statementName);
        }
        if (c.core.mainTable.isTemp() != fkTable.isTemp()) {
            throw Error.error(5524, c.getName().statementName);
        }
        Constraint unique = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        if (unique == null) {
            throw Error.error(5529, c.getMain().getName().statementName);
        }
        c.core.mainTable.checkReferentialColumnsMatch(c.core.mainCols, fkTable, c.core.refCols);
        ArrayUtil.reorderMaps(unique.getMainColumns(), c.getMainColumns(), c.getRefColumns());
        boolean[] checkList = c.core.mainTable.getColumnCheckList(c.core.mainCols);
        Grantee grantee = this.session.getGrantee();
        grantee.checkReferences(c.core.mainTable, checkList);
    }

    void addForeignKey(Constraint c) {
        this.checkModifyTable(false);
        this.checkCreateForeignKey(this.table, c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        Index mainIndex = uniqueConstraint.getMainIndex();
        boolean isForward = false;
        if (c.core.mainTable.getSchemaName() == this.table.getSchemaName()) {
            int offset = this.database.schemaManager.getTableIndex(this.table);
            if (offset != -1 && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
                isForward = true;
            }
        } else {
            isForward = true;
        }
        HsqlNameManager.HsqlName mainName = this.database.nameManager.newAutoName("REF", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
        HsqlNameManager.HsqlName indexName = this.session.database.nameManager.newConstraintIndexName(this.table.getName(), c.getName(), this.session.database.sqlSysIndexNames);
        Index refIndex = this.table.createIndexStructure(indexName, c.core.refCols, null, null, false, false, true, isForward);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = this.table;
        c.core.refName = c.getName();
        c.core.refIndex = refIndex;
        c.isForward = isForward;
        if (!this.session.isProcessingScript()) {
            c.checkReferencedRows(this.session, this.table);
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, c, refIndex, new int[0], 0, this.emptySet, this.emptySet);
        if (!this.session.isProcessingScript()) {
            this.moveData(this.table, tn, new int[0], 0);
        }
        this.database.schemaManager.addSchemaObject(c);
        this.setNewTableInSchema(tn);
        Table mainTable = this.database.schemaManager.getUserTable(c.core.mainTable.getName());
        mainTable.addConstraint(new Constraint(mainName, c));
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(tn);
        this.database.schemaManager.recompileDependentObjects(mainTable);
        this.table = tn;
    }

    void checkAddColumn(ColumnSchema col) {
        this.checkModifyTable(true);
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (this.table.findColumn(col.getName().name) != -1) {
            throw Error.error(5504);
        }
        if (col.isPrimaryKey() && this.table.hasPrimaryKey()) {
            throw Error.error(5530);
        }
        if (col.isIdentity() && this.table.hasIdentityColumn()) {
            throw Error.error(5525);
        }
        if (!(this.table.isEmpty(this.session) || col.hasDefault() || col.isNullable() && !col.isPrimaryKey() || col.isIdentity())) {
            throw Error.error(5531);
        }
    }

    void addColumn(ColumnSchema column, int colIndex, HsqlArrayList constraints) {
        Index index = null;
        Constraint mainConstraint = null;
        boolean addFK = false;
        boolean addUnique = false;
        boolean addCheck = false;
        this.checkAddColumn(column);
        Constraint c = (Constraint)constraints.get(0);
        if (c.getConstraintType() == 4) {
            if (column.getDataType().isLobType()) {
                throw Error.error(5534);
            }
            c.core.mainCols = new int[]{colIndex};
            this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
            if (this.table.hasPrimaryKey()) {
                throw Error.error(5530);
            }
            addUnique = true;
        } else {
            c = null;
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, new ColumnSchema[]{column}, c, null, new int[]{colIndex}, 1, this.emptySet, this.emptySet);
        block5: for (int i = 1; i < constraints.size(); ++i) {
            c = (Constraint)constraints.get(i);
            switch (c.getConstraintType()) {
                case 2: {
                    if (addUnique) {
                        throw Error.error(5522);
                    }
                    if (column.getDataType().isLobType()) {
                        throw Error.error(5534);
                    }
                    addUnique = true;
                    c.core.mainCols = new int[]{colIndex};
                    this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
                    HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = tn.createAndAddIndexStructure(this.session, indexName, c.getMainColumns(), null, null, true, true, false);
                    c.core.mainTable = tn;
                    c.core.mainIndex = index;
                    tn.addConstraint(c);
                    continue block5;
                }
                case 0: {
                    boolean isSelf;
                    if (addFK) {
                        throw Error.error(5528);
                    }
                    addFK = true;
                    c.core.refCols = new int[]{colIndex};
                    c.core.mainTable = this.database.schemaManager.getUserTable(c.getMainTableName());
                    c.core.refTable = tn;
                    c.core.refName = c.getName();
                    boolean bl = isSelf = this.table == c.core.mainTable;
                    if (isSelf) {
                        c.core.mainTable = tn;
                    }
                    c.setColumnsIndexes(tn);
                    this.checkCreateForeignKey(tn, c);
                    Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
                    boolean isForward = c.core.mainTable.getSchemaName() != this.table.getSchemaName();
                    int offset = this.database.schemaManager.getTableIndex(this.table);
                    if (!isSelf && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
                        isForward = true;
                    }
                    HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = tn.createAndAddIndexStructure(this.session, indexName, c.getRefColumns(), null, null, false, true, isForward);
                    c.core.uniqueName = uniqueConstraint.getName();
                    c.core.mainName = this.database.nameManager.newAutoName("REF", c.core.refName.name, this.table.getSchemaName(), this.table.getName(), 20);
                    c.core.mainIndex = uniqueConstraint.getMainIndex();
                    c.core.refIndex = index;
                    c.isForward = isForward;
                    tn.addConstraint(c);
                    mainConstraint = new Constraint(c.core.mainName, c);
                    continue block5;
                }
                case 3: {
                    if (addCheck) {
                        throw Error.error(5528);
                    }
                    addCheck = true;
                    c.prepareCheckConstraint(this.session, tn);
                    tn.addConstraint(c);
                    if (!c.isNotNull()) continue block5;
                    column.setNullable(false);
                    tn.setColumnTypeVars(colIndex);
                    if (this.table.isEmpty(this.session) || column.hasDefault()) continue block5;
                    throw Error.error(5531);
                }
            }
        }
        column.compile(this.session, tn);
        this.moveData(this.table, tn, new int[]{colIndex}, 1);
        if (mainConstraint != null) {
            mainConstraint.getMain().addConstraint(mainConstraint);
        }
        this.registerConstraintNames(constraints);
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.addSchemaObject(column);
        this.database.schemaManager.recompileDependentObjects(tn);
        tn.compile(this.session, null);
        TriggerDef[] triggers = this.table.getTriggers();
        for (int i = 0; i < triggers.length; ++i) {
            if (!(triggers[i] instanceof TriggerDefSQL)) continue;
            triggers[i].compile(this.session, null);
        }
        this.table = tn;
        this.database.granteeManager.updateAddColumn(this.table.getName(), column.getName());
    }

    void updateConstraints(OrderedHashSet tableSet, OrderedHashSet dropConstraints) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.updateConstraints(t, dropConstraints);
        }
    }

    void updateConstraints(Table t, OrderedHashSet dropConstraints) {
        for (int i = t.constraintList.length - 1; i >= 0; --i) {
            Table mainT;
            Constraint c = t.constraintList[i];
            if (dropConstraints.contains(c.getName())) {
                t.removeConstraint(i);
                continue;
            }
            if (c.getConstraintType() == 0) {
                Table refT;
                c.core.refTable = refT = this.database.schemaManager.getUserTable(c.core.refTable.getName());
                Table mainT2 = this.database.schemaManager.getUserTable(c.core.mainTable.getName());
                Constraint mainC = mainT2.getConstraint(c.getMainName().name);
                mainC.core = c.core;
                continue;
            }
            if (c.getConstraintType() != 1) continue;
            c.core.mainTable = mainT = this.database.schemaManager.getUserTable(c.core.mainTable.getName());
            Table refT = this.database.schemaManager.getUserTable(c.core.refTable.getName());
            Constraint refC = refT.getConstraint(c.getRefName().name);
            refC.core = c.core;
        }
    }

    OrderedHashSet dropConstraintsAndIndexes(OrderedHashSet tableSet, OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        OrderedHashSet<Table> newSet = new OrderedHashSet<Table>();
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            TableWorks tw = new TableWorks(this.session, t);
            tw.dropConstraintsAndIndexes(dropConstraintSet, dropIndexSet);
            newSet.add(tw.getTable());
        }
        return newSet;
    }

    void dropConstraintsAndIndexes(OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, dropConstraintSet, dropIndexSet);
        if (tn.indexList.length == this.table.indexList.length) {
            this.database.persistentStoreCollection.removeStore(tn);
            return;
        }
        this.moveData(this.table, tn, new int[0], 0);
        this.table = tn;
    }

    void alterIndex(Index index, int[] columns) {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this.table);
        int position = index.getPosition();
        boolean[] modeFlags = new boolean[columns.length];
        Object[] colTypes = new Type[columns.length];
        ArrayUtil.projectRow(this.table.getColumnTypes(), columns, colTypes);
        Index newIndex = this.database.logger.newIndex(index.getName(), index.getPersistenceId(), this.table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, index.isConstraint(), index.isForward());
        newIndex.setPosition(position);
        this.table.getIndexList()[position] = newIndex;
        this.table.setBestRowIdentifiers();
        Index[] indexes = store.getAccessorKeys();
        indexes[position] = newIndex;
        store.reindex(this.session, newIndex, null);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    Index addIndex(int[] col, HsqlNameManager.HsqlName name, boolean unique) {
        Index newIndex;
        this.checkModifyTable(false);
        if (this.session.isProcessingScript() || this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            newIndex = this.table.createIndex(this.session, name, col, null, null, unique, false, false);
        } else {
            newIndex = this.table.createIndexStructure(name, col, null, null, false, unique, false, false);
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, newIndex, new int[0], 0, this.emptySet, this.emptySet);
            this.moveData(this.table, tn, new int[0], 0);
            this.table = tn;
            this.setNewTableInSchema(this.table);
            this.updateConstraints(this.table, this.emptySet);
        }
        this.database.schemaManager.addSchemaObject(newIndex);
        this.database.schemaManager.recompileDependentObjects(this.table);
        return newIndex;
    }

    void addPrimaryKey(Constraint constraint) {
        this.checkModifyTable(true);
        if (this.table.hasPrimaryKey()) {
            throw Error.error(5532);
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, null, new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, new int[0], 0);
        this.table = tn;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(int[] cols, HsqlNameManager.HsqlName name) {
        for (int i = 0; i < cols.length; ++i) {
            ColumnSchema column = this.table.getColumn(cols[i]);
            if (!column.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (this.table.getUniqueConstraintForColumns(cols) != null) {
            throw Error.error(5522);
        }
        HsqlNameManager.HsqlName indexname = this.database.nameManager.newAutoName("IDX", name.name, this.table.getSchemaName(), this.table.getName(), 20);
        Index index = this.table.createIndexStructure(indexname, cols, null, null, false, true, true, false);
        Constraint constraint = new Constraint(name, this.table, index, 2);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, index, new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, new int[0], 0);
        this.table = tn;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(Constraint constraint) {
        int[] cols = constraint.getMainColumns();
        for (int i = 0; i < cols.length; ++i) {
            ColumnSchema column = this.table.getColumn(cols[i]);
            if (!column.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        if (this.table.getUniqueConstraintForColumns(constraint.getMainColumns()) != null) {
            throw Error.error(5522);
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, constraint.getMainIndex(), new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, new int[0], 0);
        this.table = tn;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addCheckConstraint(Constraint c) {
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
        c.prepareCheckConstraint(this.session, this.table);
        c.checkCheckConstraint(this.session, this.table);
        this.table.addConstraint(c);
        if (c.isNotNull()) {
            ColumnSchema column = this.table.getColumn(c.notNullColumnIndex);
            column.setNullable(false);
            this.table.setColumnTypeVars(c.notNullColumnIndex);
        }
        this.database.schemaManager.addSchemaObject(c);
    }

    void dropIndex(String indexName) {
        this.checkModifyTable(false);
        Index index = this.table.getUserIndex(indexName);
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(this.session, index.getPosition());
        } else {
            OrderedHashSet<HsqlNameManager.HsqlName> indexSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            indexSet.add(this.table.getIndex(indexName).getName());
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, this.emptySet, indexSet);
            this.moveData(this.table, tn, new int[0], 0);
            this.setNewTableInSchema(tn);
            this.updateConstraints(tn, this.emptySet);
            this.table = tn;
        }
        if (!index.isConstraint()) {
            this.database.schemaManager.removeSchemaObject(index.getName());
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void dropColumn(int colIndex, boolean cascade) {
        int i;
        ColumnSchema column = this.table.getColumn(colIndex);
        if (column.isSystemPeriod()) {
            throw Error.error(5517);
        }
        OrderedHashSet<HsqlNameManager.HsqlName> constraintNameSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet dependentConstraints = this.table.getDependentConstraints(colIndex);
        OrderedHashSet cascadingConstraints = this.table.getContainingConstraints(colIndex);
        OrderedHashSet indexNameSet = this.table.getContainingIndexNames(colIndex);
        HsqlNameManager.HsqlName columnName = column.getName();
        OrderedHashSet referencingObjects = this.database.schemaManager.getReferencesTo(this.table.getName(), columnName);
        this.checkModifyTable(true);
        TriggerDef[] triggers = this.table.getTriggers();
        for (i = 0; i < triggers.length; ++i) {
            TriggerDef trig = triggers[i];
            if (!(trig instanceof TriggerDefSQL) || !trig.hasOldTable() && !trig.hasNewTable() && !trig.hasOldRow() && !trig.hasNewRow()) continue;
            throw Error.error(5502, trig.getName().getSchemaQualifiedStatementName());
        }
        if (!cascade) {
            HsqlNameManager.HsqlName name;
            if (!cascadingConstraints.isEmpty()) {
                Constraint c = (Constraint)cascadingConstraints.get(0);
                name = c.getName();
                if (c.getConstraintType() == 1) {
                    name = c.getRefName();
                }
                throw Error.error(5536, name.getSchemaQualifiedStatementName());
            }
            if (!referencingObjects.isEmpty()) {
                block1: for (i = 0; i < referencingObjects.size(); ++i) {
                    name = (HsqlNameManager.HsqlName)referencingObjects.get(i);
                    if (name == columnName) continue;
                    for (int j = 0; j < dependentConstraints.size(); ++j) {
                        Constraint c = (Constraint)dependentConstraints.get(j);
                        if (c.getName() == name) continue block1;
                    }
                    throw Error.error(5536, name.getSchemaQualifiedStatementName());
                }
            }
        }
        dependentConstraints.addAll(cascadingConstraints);
        cascadingConstraints.clear();
        OrderedHashSet tableSet = new OrderedHashSet();
        for (int i2 = 0; i2 < dependentConstraints.size(); ++i2) {
            Constraint c = (Constraint)dependentConstraints.get(i2);
            if (c.getConstraintType() == 0) {
                tableSet.add(c.getMain());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getName());
            }
            if (c.getConstraintType() == 1) {
                tableSet.add(c.getRef());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getName());
            }
            constraintNameSet.add(c.getName());
        }
        tableSet = this.dropConstraintsAndIndexes(tableSet, constraintNameSet, indexNameSet);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[]{colIndex}, -1, constraintNameSet, indexNameSet);
        this.moveData(this.table, tn, new int[]{colIndex}, -1);
        this.database.schemaManager.removeSchemaObjects(referencingObjects);
        this.database.schemaManager.removeSchemaObjects(constraintNameSet);
        this.database.schemaManager.removeSchemaObjects(indexNameSet);
        this.database.schemaManager.removeSchemaObject(columnName);
        this.setNewTableInSchema(tn);
        this.setNewTablesInSchema(tableSet);
        this.updateConstraints(tn, this.emptySet);
        this.updateConstraints(tableSet, constraintNameSet);
        this.database.schemaManager.recompileDependentObjects(tableSet);
        this.database.schemaManager.recompileDependentObjects(tn);
        tn.compile(this.session, null);
        this.table = tn;
    }

    void registerConstraintNames(HsqlArrayList constraints) {
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            switch (c.getConstraintType()) {
                case 2: 
                case 3: 
                case 4: {
                    this.database.schemaManager.addSchemaObject(c);
                }
            }
        }
    }

    void dropConstraint(String name, boolean cascade) {
        Constraint constraint = this.table.getConstraint(name);
        if (constraint == null) {
            throw Error.error(5501, name);
        }
        switch (constraint.getConstraintType()) {
            case 1: {
                throw Error.error(4002);
            }
            case 2: 
            case 4: {
                this.checkModifyTable(false);
                OrderedHashSet dependentConstraints = this.table.getDependentConstraints(constraint);
                if (!cascade && !dependentConstraints.isEmpty()) {
                    Constraint c = (Constraint)dependentConstraints.get(0);
                    HsqlNameManager.HsqlName constraintName = c.getName();
                    if (c.getConstraintType() == 1) {
                        constraintName = c.getRefName();
                    }
                    throw Error.error(5533, constraintName.getSchemaQualifiedStatementName());
                }
                OrderedHashSet tableSet = new OrderedHashSet();
                OrderedHashSet<HsqlNameManager.HsqlName> constraintNameSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
                OrderedHashSet<HsqlNameManager.HsqlName> indexNameSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
                for (int i = 0; i < dependentConstraints.size(); ++i) {
                    Constraint c = (Constraint)dependentConstraints.get(i);
                    Table t = c.getMain();
                    if (t != this.table) {
                        tableSet.add(t);
                    }
                    if ((t = c.getRef()) != this.table) {
                        tableSet.add(t);
                    }
                    constraintNameSet.add(c.getMainName());
                    constraintNameSet.add(c.getRefName());
                    indexNameSet.add(c.getRefIndex().getName());
                }
                constraintNameSet.add(constraint.getName());
                if (constraint.getConstraintType() == 2) {
                    indexNameSet.add(constraint.getMainIndex().getName());
                }
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, constraintNameSet, indexNameSet);
                this.moveData(this.table, tn, new int[0], 0);
                tableSet = this.dropConstraintsAndIndexes(tableSet, constraintNameSet, indexNameSet);
                if (constraint.getConstraintType() == 4) {
                    int[] cols = constraint.getMainColumns();
                    for (int i = 0; i < cols.length; ++i) {
                        tn.getColumn(cols[i]).setPrimaryKey(false);
                        tn.setColumnTypeVars(cols[i]);
                    }
                }
                this.database.schemaManager.removeSchemaObjects(constraintNameSet);
                this.setNewTableInSchema(tn);
                this.setNewTablesInSchema(tableSet);
                this.updateConstraints(tn, this.emptySet);
                this.updateConstraints(tableSet, constraintNameSet);
                this.database.schemaManager.recompileDependentObjects(tableSet);
                this.database.schemaManager.recompileDependentObjects(tn);
                this.table = tn;
                break;
            }
            case 0: {
                this.checkModifyTable(false);
                OrderedHashSet<HsqlNameManager.HsqlName> constraints = new OrderedHashSet<HsqlNameManager.HsqlName>();
                Table mainTable = constraint.getMain();
                HsqlNameManager.HsqlName mainName = constraint.getMainName();
                constraints.add(mainName);
                constraints.add(constraint.getRefName());
                OrderedHashSet<HsqlNameManager.HsqlName> indexes = new OrderedHashSet<HsqlNameManager.HsqlName>();
                indexes.add(constraint.getRefIndex().getName());
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, constraints, indexes);
                this.moveData(this.table, tn, new int[0], 0);
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                this.setNewTableInSchema(tn);
                mainTable.removeConstraint(mainName.name);
                this.updateConstraints(tn, this.emptySet);
                this.database.schemaManager.recompileDependentObjects(this.table);
                this.table = tn;
                break;
            }
            case 3: {
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                if (!constraint.isNotNull()) break;
                ColumnSchema column = this.table.getColumn(constraint.notNullColumnIndex);
                column.setNullable(false);
                this.table.setColumnTypeVars(constraint.notNullColumnIndex);
            }
        }
    }

    void retypeColumn(ColumnSchema oldCol, ColumnSchema newCol) {
        Type newType;
        Type oldType = oldCol.getDataType();
        if (oldType.equals(newType = newCol.getDataType()) && oldCol.getIdentitySequence() == newCol.getIdentitySequence()) {
            return;
        }
        if (oldCol.isGenerated() || oldCol.isSystemPeriod()) {
            throw Error.error(5517);
        }
        this.checkModifyTable(true);
        if (!this.table.isEmpty(this.session) && oldType.typeCode != newType.typeCode) {
            boolean allowed = newCol.getDataType().canConvertFrom(oldCol.getDataType());
            switch (oldType.typeCode) {
                case 1111: 
                case 2000: {
                    allowed = false;
                }
            }
            if (!allowed) {
                throw Error.error(5561);
            }
        }
        int colIndex = this.table.getColumnIndex(oldCol.getName().name);
        int checkData = newType.canMoveFrom(oldType);
        if (newCol.isIdentity() && this.table.hasIdentityColumn() && this.table.identityColumn != colIndex) {
            throw Error.error(5525);
        }
        if (checkData == 0) {
            if (newCol.isIdentity() && !oldCol.isIdentity() && oldCol.isNullable() && !oldCol.isPrimaryKey()) {
                checkData = 1;
            }
            if (newType.isDomainType() && newType.userTypeModifier.getConstraints().length > 0) {
                checkData = 1;
            }
        }
        if (checkData == 1) {
            this.checkConvertColDataType(oldCol, newCol);
            checkData = 0;
        }
        if (checkData == 0) {
            oldCol.setType(newCol);
            oldCol.setDefaultExpression(newCol.getDefaultExpression());
            oldCol.setIdentity(newCol.getIdentitySequence());
            this.table.setColumnTypeVars(colIndex);
            this.table.resetDefaultFlags();
            return;
        }
        this.database.schemaManager.checkColumnIsReferenced(this.table.getName(), this.table.getColumn(colIndex).getName());
        this.table.checkColumnInCheckConstraint(colIndex);
        this.table.checkColumnInFKConstraint(colIndex);
        this.checkConvertColDataType(oldCol, newCol);
        this.retypeColumn(newCol, colIndex);
    }

    void checkConvertColDataType(ColumnSchema oldCol, ColumnSchema newCol) {
        int colIndex = this.table.getColumnIndex(oldCol.getName().name);
        Type oldType = oldCol.getDataType();
        Type newType = newCol.getDataType();
        RowIterator it = this.table.rowIterator(this.session);
        while (it.next()) {
            Row row = it.getCurrentRow();
            Object o = row.getField(colIndex);
            if (!newCol.isNullable() && o == null) {
                throw Error.error(10);
            }
            newType.convertToType(this.session, o, oldType);
            if (!newType.isDomainType()) continue;
            Constraint[] checks = newType.userTypeModifier.getConstraints();
            for (int i = 0; i < checks.length; ++i) {
                checks[i].checkCheckConstraint(this.session, this.table, oldCol, o);
                this.checkAddDomainConstraint(newType, checks[i]);
            }
        }
    }

    void checkAddDomainConstraint(Type domain, Constraint check) {
        Type[] dataTypes = this.table.getColumnTypes();
        RowIterator it = this.table.rowIterator(this.session);
        while (it.next()) {
            Row row = it.getCurrentRow();
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                if (dataTypes[i] != domain) continue;
                ColumnSchema column = this.table.getColumn(i);
                check.checkCheckConstraint(this.session, this.table, column, row.getField(i));
            }
        }
    }

    private void retypeColumn(ColumnSchema column, int colIndex) {
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, new ColumnSchema[]{column}, null, null, new int[]{colIndex}, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, new int[]{colIndex}, 0);
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table = tn;
    }

    void setColNullability(ColumnSchema column, boolean nullable) {
        Constraint c = null;
        int colIndex = this.table.getColumnIndex(column.getName().name);
        if (column.isGenerated() || column.isSystemPeriod()) {
            throw Error.error(5517);
        }
        if (column.isNullable() == nullable) {
            return;
        }
        if (nullable) {
            if (column.isPrimaryKey()) {
                throw Error.error(5526);
            }
            this.table.checkColumnInFKConstraint(colIndex, 2);
            this.removeColumnNotNullConstraints(colIndex);
        } else {
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("CT", this.table.getSchemaName(), this.table.getName(), 5);
            c = new Constraint(constName, null, 3);
            c.check = new ExpressionLogical(column);
            c.prepareCheckConstraint(this.session, this.table);
            c.checkCheckConstraint(this.session, this.table);
            column.setNullable(false);
            this.table.addConstraint(c);
            this.table.setColumnTypeVars(colIndex);
            this.database.schemaManager.addSchemaObject(c);
        }
    }

    void setColDefaultExpression(int colIndex, Expression def) {
        ColumnSchema column;
        if (def == null) {
            this.table.checkColumnInFKConstraint(colIndex, 4);
        }
        if ((column = this.table.getColumn(colIndex)).isGenerated() || column.isSystemPeriod()) {
            throw Error.error(5517);
        }
        column.setDefaultExpression(def);
        this.table.setColumnTypeVars(colIndex);
    }

    public boolean setTableType(int newType) {
        Table tn;
        int currentType = this.table.getTableType();
        if (currentType == newType) {
            return false;
        }
        switch (newType) {
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            tn = this.table.moveDefinition(this.session, newType, ColumnSchema.emptyArray, null, null, new int[0], 0, this.emptySet, this.emptySet);
            this.moveData(this.table, tn, new int[0], 0);
        }
        catch (HsqlException e) {
            return false;
        }
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.table = tn;
        this.database.schemaManager.recompileDependentObjects(this.table);
        return true;
    }

    void addSystemPeriod(PeriodDefinition period) {
        if (this.table.systemPeriod != null) {
            throw Error.error(1551);
        }
        int columnCount = this.table.getColumnCount();
        int[] colIndex = new int[]{columnCount, columnCount + 1};
        ColumnSchema[] columns = new ColumnSchema[]{period.startColumn, period.endColumn};
        this.checkAddColumn(period.startColumn);
        this.checkAddColumn(period.endColumn);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, columns, null, null, colIndex, 2, this.emptySet, this.emptySet);
        tn.systemPeriod = period;
        this.moveData(this.table, tn, colIndex, 2);
        this.setNewTableInSchema(tn);
        this.table = tn;
        this.database.granteeManager.updateAddColumn(this.table.getName(), period.startColumn.getName());
        this.database.granteeManager.updateAddColumn(this.table.getName(), period.endColumn.getName());
    }

    void dropSystemPeriod(boolean cascade) {
        if (this.table.systemPeriod == null) {
            throw Error.error(1551);
        }
        OrderedHashSet referencingObjects = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.startColumn.getName());
        OrderedHashSet endReferences = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.startColumn.getName());
        referencingObjects.addAll(endReferences);
        if (cascade) {
            if (!referencingObjects.isEmpty()) {
                HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)referencingObjects.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
        } else if (!referencingObjects.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)referencingObjects.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        int[] colIndex = new int[]{this.table.systemPeriodStartColumn, this.table.systemPeriodEndColumn};
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, colIndex, -2, this.emptySet, this.emptySet);
        tn.systemPeriod = null;
        this.moveData(this.table, tn, colIndex, -2);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(tn);
        tn.compile(this.session, null);
        this.setNewTableInSchema(tn);
        this.table = tn;
    }

    void dropSystemVersioning(boolean cascade) {
        OrderedHashSet referencingObjects = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.getName());
        if (cascade) {
            if (!referencingObjects.isEmpty()) {
                HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)referencingObjects.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
        } else if (!referencingObjects.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)referencingObjects.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    void setNewTablesInSchema(OrderedHashSet tableSet) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.setNewTableInSchema(t);
        }
    }

    void setNewTableInSchema(Table newTable) {
        int i = this.database.schemaManager.getTableIndex(newTable);
        if (i != -1) {
            this.database.schemaManager.setTable(i, newTable);
        }
    }

    void removeColumnNotNullConstraints(int colIndex) {
        for (int i = this.table.constraintList.length - 1; i >= 0; --i) {
            Constraint c = this.table.constraintList[i];
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            this.database.schemaManager.removeSchemaObject(c.getName());
        }
        ColumnSchema column = this.table.getColumn(colIndex);
        column.setNullable(true);
        this.table.setColumnTypeVars(colIndex);
    }

    private void checkModifyTable(boolean withContents) {
        if (this.session.getUser().isSystem()) {
            return;
        }
        if (this.session.isProcessingScript()) {
            return;
        }
        if (this.database.isFilesReadOnly() || this.table.isReadOnly()) {
            throw Error.error(456);
        }
        if (this.table.isText() && this.table.isConnected()) {
            throw Error.error(320);
        }
    }

    void moveData(Table oldTable, Table newTable, int[] colIndex, int adjust) {
        if (oldTable.isTemp) {
            Session[] sessions = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                sessions[i].sessionData.persistentStoreCollection.moveData(oldTable, newTable, colIndex, adjust);
            }
        } else {
            PersistentStore oldStore = this.database.persistentStoreCollection.getStore(oldTable);
            boolean newSpaceID = false;
            if (newTable.isCached()) {
                boolean bl = newSpaceID = oldTable.getSpaceID() != 7;
                if (newSpaceID) {
                    int tableSpaceID = this.database.logger.getCache().spaceManager.getNewTableSpaceID();
                    newTable.setSpaceID(tableSpaceID);
                }
            }
            PersistentStore newStore = this.database.persistentStoreCollection.getStore(newTable);
            try {
                newStore.moveData(this.session, oldStore, colIndex, adjust);
            }
            catch (HsqlException e) {
                this.database.persistentStoreCollection.removeStore(newTable);
                throw e;
            }
            this.database.persistentStoreCollection.removeStore(oldTable);
        }
    }
}

